/* Holds the current title for trace browser portion of trace presenter */!!

inherit(Window, #TraceTitleWindow, #(titleText     /* title text */
titleHeight  /* number of lines */
titleLength  /* number of char on longest line */
), 2, nil)!!

now(class(TraceTitleWindow))!!

/* 1/30/1992 13:26 */
Def new(self, parent, rect, style | newInstance)
{
  newInstance := new( self:Behavior ) ;
  setPaintStruct(newInstance, new(Struct, 32));
  create(newInstance, 
         parent, 
         "", 
         rect cor sizeRect(self),
         (style bitOr WS_CHILD)
        ) ;
  setLocRect( newInstance ) ;
  ^newInstance
}
!!

now(TraceTitleWindow)!!

/* PUBLIC */
Def getTitle(self)
{ ^titleText;
}
!!

/* PUBLIC */
Def getTitleLength(self)
{ ^titleLength;
}
!!

/* 2/4/1992 9:28 */
Def paint(self, hdc | aStr txt yPos)
{   
  if( titleText )
    initTextColors(self,hdc);
    yPos := 0;
    do(size(titleText),
    {using(line) 
      aStr := copyFrom( titleText[line], 0, size(titleText[line]) ) ;
      txt := copyFrom(aStr,leftChar(parent), size(aStr));
      Call TextOut(hdc, hscrollIndex(parent)*tmWidth(parent), (yPos * tmHeight(parent)) + 2, txt, size(txt));
      yPos := yPos + 1;
    });
  endif;
}
!!

/* PUBLIC */
Def setTitle(self, text)
{ 
  if( text ) 
    add(titleText := new(TextCollection, 3), "");
    insertText(titleText,
             removeNulls(physicalString(text)),
             0,
             0);
    titleHeight := size(titleText) - 1;
    titleHeight := 3; /* @@@ force a fixed size */
    titleLength := 0;
    do(titleText,
    {using(line)
       titleLength := max(titleLength,size(line));
    });
    titleLength := titleLength + hscrollIndex(parent);    
  else
    titleText := nil;
    titleHeight := 0;
    titleLength := 0;
  endif;
}
!!

/* PUBLIC */
Def title(self)
{ ^titleText
}
!!

/* PUBLIC */
Def titleHeight(self)
{ if(not(titleHeight))
    ^0;
  else
    ^titleHeight;
  endif;
}
!!

/* MS-Window's message to paint self -- sends a
  paint(self) message.  This overrides Window:WM_PAINT
  so that TextWindow and its descendants use the
  System Fixed Font instead of the System Font. */
Def WM_PAINT(self, wP, lP | hdc oldFont)
{ hdc := Call BeginPaint(getHWnd(self), paintStruct);
  if oldFont := Call SelectObject(hdc,getFont(parent))
    paint(self, hdc);
    Call SelectObject(hdc, oldFont);
    Call EndPaint(getHWnd(self), paintStruct);
  endif;
  ^0;
}
!!
