/****************************************************************************
**
**  Name:  bkroot.h
**
**  Description:
**     Header file for bkroot processor-must-be-halted files.
**
**  Status:  CODED
**
**  $Log:   S:/tbird/arcmmcf/inc/bkroot.h_v  $
** 
**    Rev 1.1   10 Apr 1997 10:06:08   gene
** 
**    Rev 1.0   03 Jun 1996 11:24:28   gene
** Initial revision.
** 
**    Rev 1.0   07 Sep 1995 10:25:44   gene
** Initial revision.
** 
**    Rev 1.5   28 Jun 1993 07:22:12   doug
** centralizing error messages in errtext/mkerrors.h
** 
**    Rev 1.4   08 Dec 1992 06:43:36   brucea
** Comment changes: any callers to runaccess functions must generate runaccess
**    events
** 
**    Rev 1.3   27 Aug 1992 14:55:14   brucea
** Changed: BX_EMULATION_STATE and BX_CAUSE to use those defined in sdtempl.h
** 
**    Rev 1.2   25 Jun 1992 13:29:54   jim
** referencing things from bkptexec.h - need to include it
** 
**    Rev 1.1   23 Jun 1992 15:43:44   brucea
** Changed: ER_BX_EMULATOR_MUST_BE_HALTED  (MODULE_BREAKPOINT | E_WARNING | 0L)
**   to     ER_BK_EMULATOR_MUST_BE_HALTED  (MODULE_BKROOT | E_WARNING | 0L)
** 
**    Rev 1.0   23 Jun 1992 15:34:34   brucea
** Initial revision.
   
      Rev 1.0   22 Jun 1992 19:07:06   brucea
   Initial revision.
** 
**  $Header:   S:/tbird/arcmmcf/inc/bkroot.h_v   1.1   10 Apr 1997 10:06:08   gene  $
**
**  Copyright (C) 1991 Microtek International.  All rights reserved.
**
*****************************************************************************/

#define _BKROOT_


                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#ifndef _BKPTEXEC_
#include "bkptexec.h"
#endif

#ifndef _SDPROBE_
#include "sdprobe.h"
#endif


                       /****************************
                        *                          *
                        *       ERRORS             *
                        *                          *
                        ****************************/

/* errors are now in ertext/mkerrors.h */


                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/

#ifdef __cplusplus
extern "C" {
#endif
                       /****************************
                        *                          *
                        *    PUBLIC PROTOTYPES     *
                        *                          *
                        ****************************/

/****************************************************************************
**
**  BkGetEmulationStatus
**
**  Description:
**     Get the current state of emulation.
**
**  Parameters:
**     input:
**        none
**     output:
**        emulState:  current state
**
*****************************************************************************/
RETCODE EXPORT BkGetEmulationStatus(EMULATION_STATE FAR *emulState);


/***************************************************************************
**
**  BkProcessorMustBeHalted
**
**  Description:
**     Checks for user-changable state of emuRunAccess.  If ON (TRUE), skips
**     test for processor halted and returns GOOD, therefore caller is given
**     go-ahead even if emu is still running.
**     If emuRunAccess is OFF (FALSE), test is actually made and returns
**     error ER_BX_EMULATOR_MUST_BE_HALTED if the processor is not
**     currently halted.
**
**  Parameters: none
**
*****************************************************************************/
RETCODE EXPORT BkProcessorMustBeHalted(VOID);


/***************************************************************************
**
** BkProcessorMustBeHaltedAbsolute
**
** Description:
**    Returns error ER_BX_EMULATOR_MUST_BE_HALTED if the processor is not
**    currently halted.  This function does not check for state of
**    user-changable emuRunAccess flag while BkProcessorMustBeHalted does,
**    therefore it is a lower-level function.
**
** Parameters: none
**
*****************************************************************************/
RETCODE EXPORT BkProcessorMustBeHaltedAbsolute(VOID);


/*---------------------------------------------------------------------------
** BkSetRunAccess - allows user to access target while in emulation
**
** Description:
**    Provides means of setting the flag that allows target
**    access while it is in emulation.
**    Note: any caller other than the Source Presenter must generate
**    the EVENT_BKROOT_RUNACCESS_ON event so that its menu gets updated.
----------------------------------------------------------------------------*/
RETCODE EXPORT BkSetRunAccess(VOID);


/*---------------------------------------------------------------------------
** BkClearRunAccess - prevents user from accessing target while in emulation
**
**    Note: any caller other than the Source Presenter must generate
**    the EVENT_BKROOT_RUNACCESS_OFF event so that its menu gets updated.
----------------------------------------------------------------------------*/
RETCODE EXPORT BkClearRunAccess(VOID);


/*---------------------------------------------------------------------------
** BkGetRunAccess - returns run access state
**
** Parameter:
**    runAccess: returns state of control flag for allowing target access
**       while in emulation
----------------------------------------------------------------------------*/
RETCODE EXPORT BkGetRunAccess(BOOLEAN FAR *runAccess);


/*---------------------------------------------------------------------------
** BkRootInit - Initializes BKROOT DLL; called from Actor
----------------------------------------------------------------------------*/
RETCODE EXPORT BkRootInit(VOID);

#ifdef __cplusplus
}
#endif
//******************************** E O F ***********************************/
