/****************************************************************************
**
**  Name:  hlbrkpt.h
**
**  Description:
**     Source level and assembly level breakpoint routines used by high
**     level presenters.
**
**  Status:  PRELIMINARY
**
**  $Log:   S:/tbird/arcmmcf/inc/hlbrkpt.h_v  $
** 
**    Rev 1.0   03 Jun 1996 11:24:54   gene
** Initial revision.
** 
**    Rev 1.0   07 Sep 1995 10:26:00   gene
** Initial revision.
** 
**    Rev 1.1   13 Dec 1991 14:41:08   doug
** a) split call and return typedefs out to make it read better
** b) made enum names more uniform
** 
**    Rev 1.0   13 Dec 1991 13:34:06   doug
** Initial revision.
**
**  $Header:   S:/tbird/arcmmcf/inc/hlbrkpt.h_v   1.0   03 Jun 1996 11:24:54   gene  $
**
**  Copyright (C) 1991 Microtek International.  All rights reserved.
**
*****************************************************************************/

#define _HLBRKPT_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#ifndef _BASEWIND_
#include "basewind.h"
#endif

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/
typedef {
   HLB_STEP_INTO, /* step into functions */
   HLB_STEP_OVER, /* step over functions */
} HLB_STEP_TYPE;

typedef {
   HLB_GO_TIL_CALL, /* go until line/statement/asm that any call is on */
   HLB_GO_INTO_CALL, /* go until first line/statement/asm of any call */
} HLB_CALL_TYPE;

typedef {
   HLB_GO_TIL_RETURN, /* go until line/statement/asm that any return is on */
   HLB_GO_THROUGH_RETURN, /* go until first line/statement/asm of any return */
} HLB_RETURN_TYPE;

typedef {
   HLB_LINE_GRAN, /* sync up on source line */
   HLB_STATEMENT_GRAN, /* sync up on C statement */
} HLB_GRANULARITY;

#ifdef __cplusplus
extern "C" {
#endif
                        /****************************
                         *                          *
                         *        PROTOTYPES        *
                         *                          *
                         ****************************/

/*
**  Source Level Breakpoints
*/
/****************************************************************************
**
**  HlbSrcStep
**
**  Description:
**     This routine steps one source line or statement.
**
**  Parameters:
**     input:
**        type:  step into/over
**        gran:  step by line/statement
**     output:
**        none
**
*****************************************************************************/
RETCODE EXPORT HlbSrcStep(HLB_STEP_TYPE type, HLB_GRANULARITY gran);

/****************************************************************************
**
**  HlbSrcGoUntilCall
**
**  Description:
**     This routine goes until a line or statement before (or after) a call.
**     It will also stop at any return (using mode/granularity) in case none
**     of the calls are hit.
**
**  Parameters:
**     input:
**        mode:  go until line/statement of call or first line/statement of
**               routine called
**        gran:  line or statement granularity
**     output:
**        none
**
*****************************************************************************/
RETCODE EXPORT HlbSrcGoUntilCall(HLB_CALL_TYPE type, HLB_GRANULARITY gran);

/****************************************************************************
**
**  HlbSrcGoUntilReturn
**
**  Description:
**     This routine goes until a line or statement before (or after) a return.
**
**  Parameters:
**     input:
**        mode:  go until line/statement of call or first line/statement of
**               routine called
**        gran:  line or statement granularity
**     output:
**        none
**
*****************************************************************************/
RETCODE EXPORT HlbSrcGoUntilReturn(HLB_RETURN_TYPE type, HLB_GRANULARITY gran);

/*
**  Assembly Level Breakpoints
*/
/****************************************************************************
**
**  HlbAsmStep
**
**  Description:
**     This routine steps one assembly instruction.
**
**  Parameters:
**     input:
**        type:  step into/over
**     output:
**        none
**
*****************************************************************************/
RETCODE EXPORT HlbAsmStep(HLB_STEP_TYPE type);

/****************************************************************************
**
**  HlbAsmGoUntilCall
**
**  Description:
**     This routine goes until the assembly instruction of a call (or first
**     asm instruction in the called function.  It will also stop at any
**     return (using mode) in case none of the calls are hit.
**
**  Parameters:
**     input:
**        mode:  go until actual assembly call instruction or first line/
**               statement of the first routine called
**     output:
**        none
**
*****************************************************************************/
RETCODE EXPORT HlbAsmGoUntilCall(HLB_CALL_TYPE type);

/****************************************************************************
**
**  HlbAsmGoUntilReturn
**
**  Description:
**     This routine goes until the assembly instruction of a call (or first
**     asm instruction in the called function.
**           
**
**  Parameters:
**     input:
**        mode:  go until actual assembly call instruction or first line/
**               statement of the first routine called
**     output:
**        none
**
*****************************************************************************/
RETCODE EXPORT HlbAsmGoUntilReturn(HLB_RETURN_TYPE type);


#ifdef __cplusplus
}
#endif
/******************************** E O F ***********************************/
