/****************************************************************************
**
**  Name:  LDRSVR.H
**
**  Description:
**     IEEE 695 loader API's (external entry points).  Can be called by CLI,
**	   Symbol Server, and Project Definition Server
**
**  Status:  CODED
**
**  $Log:   S:/tbird/arcmmcf/inc/ldrsvr.h_v  $
** 
**    Rev 1.0   03 Jun 1996 11:24:58   gene
** Initial revision.
** 
**    Rev 1.1   01 Dec 1995 09:58:34   kevin
** joyce's modification
** 
**    Rev 1.0   07 Sep 1995 10:26:04   gene
** Initial revision.
** 
**    Rev 1.21   18 Feb 1994 15:57:02   nghia
** Added new interface for the loader to return the PWRVIEWS.INI path string.
** LdrGetIniDir()
** 
**    Rev 1.20   23 Sep 1993 10:41:28   nghia
** Revised paramter flags to U32 to support new load option.
** Remove RELOAD() and mask to be a separate variable.  Cleanup junks.
** 
**    Rev 1.19   14 Jul 1993 12:00:58   nghia
** Added LdrLoadModuleByDesc() to provide ondemand loading using module desc.
** 
**    Rev 1.18   02 Jun 1993 18:00:08   nghia
** Revised L695 flags value to support REPORT_WARNING. - PIP for Source.
** 
**    Rev 1.17   09 Mar 1993 17:49:52   nghia
** Revised LdrLoadWin() interface.
** Cleanup and added comments.
** 
**    Rev 1.16   21 Oct 1992 18:10:16   courtney
** Pointer parameter to LdrGetFileStatus should be far - fixed.
** 
**    Rev 1.15   07 Oct 1992 18:37:14   courtney
** Added prototype for LdrGetFileStatus().
** 
**    Rev 1.14   08 Sep 1992 10:23:32   courtney
** Removed events (consolidated to events.h).
** 
**    Rev 1.13   05 Aug 1992 13:59:02   courtney
** Consolidate load event (formerly separate events for CLI vs.
** Windows load).
** 
**    Rev 1.12   05 Aug 1992 13:45:58   courtney
** Revised entry point 'LdrGetCliOptions' to 'LdrGetOptions', it
** can now be used from either CLI or Windows (Button Bar or
** Source Presenter) as a callback to obtain load flags.
** 
**    Rev 1.11   09 Jul 1992 16:45:32   courtney
** Revised dummy enum member to signed so it will work properly in
** widening all members to U32.
** 
**    Rev 1.10   03 Jun 1992 10:24:20   courtney
** Added dummy member to LR_TYPE (enum) to force members to U16.
** 
**    Rev 1.9   03 Jun 1992 10:10:52   courtney
** Added callback to get code regions loaded (LdrGetLoadRegion), with
** enum for various types of regions.
** 
**    Rev 1.8   01 Jun 1992 20:20:02   courtney
** Added flag for alternate language support (non-C modules).
** 
**    Rev 1.7   08 May 1992 09:54:34   courtney
** Added reload flag.
** 
**    Rev 1.6   08 May 1992 09:50:14   courtney
** Added new event for Project Definition load invocation.
** 
**    Rev 1.5   06 Apr 1992 12:02:34   brucea
** Bug: the closing cplusplus used single underscore rather than double; this
**    caused mis-compile in symutil.cpp because it treated all functions as
**    "C" functions rather than C++
** 
**    Rev 1.4   03 Apr 1992 14:57:20   courtney
** Revised prototype for LdrGetStack (formerly was Stacktop) to return
** size as well as top of stack.
** 
**    Rev 1.3   03 Apr 1992 10:23:08   courtney
** Moved PATHLEN and IEEE_IDNLEN to this file for callbacks callers
** to use.
** 
**    Rev 1.2   02 Apr 1992 16:52:00   courtney
** Callbacks for events relating to stack, PC, and load from CLI.
** 
**    Rev 1.6   24 Mar 1992 20:43:00   courtney
** Added prototypes for callback functions.  Added two events,
** one for new start PC (on completion of loading code), one for
** completion of loading symbols, for new stacktop.
** 
**    Rev 1.5   31 Dec 1991 10:47:36   courtney
** Revised API names to make them shorter.
** 
**    Rev 1.4   16 Dec 1991 12:31:18   courtney
** Bracketed the load module API so it is callable from C++ (Symbol Server).
** 
**    Rev 1.3   16 Dec 1991 12:10:10   courtney
** Revised description of module-only load (simplified).
** 
**    Rev 1.2   12 Dec 1991 09:19:42   courtney
** Revised flag name, Load module API parameters, Load from CLI parameters.
** 
**    Rev 1.1   25 Oct 1991 11:08:24   courtney
** Revised API names.
** 
**    Rev 1.0   23 Oct 1991 09:27:28   courtney
** Initial revision.
**
**  $Header:   S:/tbird/arcmmcf/inc/ldrsvr.h_v   1.0   03 Jun 1996 11:24:58   gene  $
**
**  Copyright (C) 1991 Microtek International.  All rights reserved.
**
*****************************************************************************/
#ifndef _LDRSVR_
#define _LDRSVR_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#ifndef _BASEWIND_
#include "basewind.h"
#endif

#ifndef _SYMBLSVR_
#include "symblsvr.h"
#endif

#ifndef _CPU_
#include "cpu.h"
#endif

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/

/* Loader flags - please initialize your 'flags' parameter to zero before
   setting any of these flags when calling the Ldr API's, to allow for future
   expansion.
*/
#define L695_DBG        0x01    /* load symbols */
#define L695_CODE       0x02    /* load code */
#define L695_STATUS     0x04    /* display status indicator */
#define L695_WARNING    0x08    /* report warning */
#define L695_ASM        0x10    /* load asm modules */       
#define L695_SPACE      0x20    /* load space: supervisor/user */

/* default */
#define L695_DEF_FLAGS  L695_DBG | L695_CODE | L695_STATUS | L695_WARNING

#define PATHLEN  128        /* MS-DOS filename length with path */
#define IEEE_IDNLEN  127	/* name length for normal string (IEEE 695) */

/* define load region types */
typedef enum {LR_CODE, LR_DATA, LR_ROMDATA, LR_DUMMY=0x7fff
} LR_TYPE;

                        /****************************
                         *                          *
                         *        PROTOTYPES        *
                         *                          *
                         ****************************/

#ifdef __cplusplus
extern "C" {
#endif

/*****************************************************************************
**  LdrLoad
**
**	Description:
**		Load (at least) the code and global symbols from a file which is in
**		IEEE 695 format.  This is the entry point for the CLI.
**
**	Parameters:
**		input:
**			cmdString - concatenated list of null-terminated strings indicating
**			   various options to loader
**			argc - number of arguments found in argv parameter
**			argv - offsets in cmdString where strings live
**		output:
**			None.
**
**	Returns:
**		0 on successful load of required modules
**		-1 if an error occurred (this will be revised to indicate what kind
**		   of error), and to follow the CLI error conventions.
**
*****************************************************************************/
RETCODE EXPORT LdrLoad(LPSTR cmdString, U32 argc, U32 argv []);

/****************************************************************************
**  LdrLoadWin
**
**	Description:
**		Load (at least) the code and global symbols from a file which is in
**		IEEE 695 format.  Various parameters indicate whether local symbols
**		should always be loaded, or incrementally (on demand) loaded.  This
**      is the entry point for Source and ButtonBar Presenters.
**
**	Parameters:
**		input:
**			filename - filename of .ABS file to load
**			ondemand - TRUE/FALSE.  If TRUE, then incremental loading takes
**			   place, and this call only loads code and global symbols.  If
**			   FALSE, then all symbols are loaded here.
**			flags - indicate various options (display progress indicator, don't
**			   load code, don't load symbols, etc.)
**		output:
**			None.
**
**	Returns:
**		GOOD on successful load of required modules
**		ERRCODE return if an error occurred 
**
*****************************************************************************/
RETCODE EXPORT LdrLoadWin(LPSTR filename, BOOLEAN ondemand, U32 flags,
   U32 parenthWnd);

/*****************************************************************************
**  LdrLoadModuleByDesc
**
**	Description:
**		Load symbols local to this module.  This is the entry point for
**      the Symbol Server and the Shell's LOAD command.  Only local
**		symbols and line number records will be loaded (it is assumed that
**		global symbols - including module, function, and type information -
**		has already been loaded).
**
**      May also be called from the CLI API to force load symbols for a
**      particular module.  In either case (CLI or Windows invocation),
**      the resultant call to the Symbol Server to open a module will
**      return the file offset and the type fix-up offset.
**
**
**	Parameters:
**		input:
**          fileName    - Filename where module is found
**          moduleName  - Name of module to load
**          moduleDesc  - Module Descriptor of the module
**		output:
**			None.
**
**	Returns:
**       0 on successful load of required module
**		-1 if an error occurred (this will be revised to indicate what kind
**		   of error)
**
******************************************************************************/
RETCODE EXPORT LdrLoadModuleByDesc(LPSTR Filename, LPSTR moduleName,
      SYM_DESCRIPTOR moduleDesc);

/*****************************************************************************
**  LdrLoadModule
**
**	Description:
**		Load symbols local to this module.  This is the entry point for
**		the Symbol Server (perhaps via another presenter).  Only local
**		symbols and line number records will be loaded (it is assumed that
**		global symbols - including module, function, and type information -
**		has already been loaded).
**
**      May also be called from the CLI API to force load symbols for a
**      particular module.  In either case (CLI or Windows invocation),
**      the resultant call to the Symbol Server to open a module will
**      return the file offset and the type fix-up offset.
**
**
**	Parameters:
**		input:
**			filename - filename where module is found
**			module_name - name of module to load
**		output:
**			None.
**
**	Returns:
**		0 on successful load of required module
**		-1 if an error occurred (this will be revised to indicate what kind
**		   of error)
**
******************************************************************************/
RETCODE EXPORT LdrLoadModule(LPSTR filename, LPSTR module_name);


/******************************************************************************
**
**  ldrGetStartPC
**
**  Status: TESTED
**
**  Description:
**     Callback function to retrieve the loadfile's PC.
**
**  Parameters:
**     input:
**        none.
**     output:
**        pstartPC      Pointer to an Address Descriptor.  Caller responsible
**                      for destroying the descriptor when done.
**
******************************************************************************/
RETCODE EXPORT LdrGetStartPC(DESCRIPTOR FAR *pstartPC);

/******************************************************************************
**
**  LdrGetStack
**
**  Status: CODED
**
**  Description: Callback function to retrieve the loadfile's stack pointer.
**
**  Parameters:
**     input:
**        none.
**     output:
**        pstackTop     Pointer to address descriptor. Caller destroy descriptor
**                      when done.
**        ssize         Pointer to Stack size.
**
******************************************************************************/
RETCODE EXPORT LdrGetStack(DESCRIPTOR FAR *pstackTop, U32 *ssize);

/******************************************************************************
**
**  LdrGetOptions
**
**  Status: CODED
**
**  Description: Callback funtion to retrieve laod option when load complete.
**
**  Parameters:
**     input:
**        none.
**     output:
**        lpBinfile     loadfile name.
**        ondemand      pointer to ondemand flag.
**        ldrflags      pointer to load option flags.
**        lpmodule      pointer to load module.
**
******************************************************************************/
RETCODE EXPORT LdrGetOptions(LPSTR lpBinfile, BOOLEAN FAR *ondemand,
   U32 FAR *ldrflags, LPSTR lpmodule);

/******************************************************************************
**
**  LdrGetLoadRegion
**
**  Description:  Callback funtion to retrieve loadfile's load regions.
**
**  Parameters:
**     input:
**        lregion    Region identifier.
**     output:
**        lAddr      Pointer to an address descriptor contain the interest
**                   region.  Caller responsible to destroy the descriptor.
**
******************************************************************************/
RETCODE EXPORT LdrGetLoadRegion(LR_TYPE lregion, DESCRIPTOR FAR *pAddr);

/******************************************************************************
**
**  LdrGetFileStatus
**
**  Description:
**     Compare the Source timestamp and the current loadfile.
**
**  Parameters:
**     input:
**        .
**     output:
**       lpsource -  source file name (disk file)
**       pstatus  -  pointer to status:
**                   status returns GOOD if source <= loadfile timestamp
**
**      status returns !GOOD if source > loadfile timestamp (source newer)
**
**
******************************************************************************/
RETCODE EXPORT LdrGetFileStatus(LPSTR lpSourceFile, BOOL FAR *pstatus);

/******************************************************************************
**
**  LdrCliSetToolUse
**
**  Status: CODED
**
**  Description:
**     Allow user to set the ToolUse name from the CLI.
**
**  Parameters:
**     input:
**        cmdString     CLI command string.
**        argc          number of arguments in the command string.
**        argv          String contains command arguments.
**     output:
**        none.
**
******************************************************************************/
RETCODE EXPORT LdrCliSetToolUse(LPSTR cmdString, U32 argc, U32 argv[]);

/******************************************************************************
**
**  LdrGetIniDir
**
**  Status: CODED
**
**  Description:
**     Copy the PowerViews directory string from the loader server.
**
**  Parameters:
**     input:
**        none
**     output:
**        lpIniDir      buffer to hold PowerViews INI path string.
**
******************************************************************************/
RETCODE EXPORT LdrGetIniDir(LPSTR lpIniDir);

/******************************************************************************
**
**  LdrSpaceMode
**
**  Status: CODED
**
**  Description:
**     Get the loader space attribute option
**
**  Parameters:
**     input:
**        none
**     output:
**        none
**  Return : space mode: SUPERVISOR_MODE or USER_MODE
**
******************************************************************************/
SPACE_MODE EXPORT LdrSpaceMode(VOID);

#ifdef __cplusplus
}
#endif

#endif
/******************************** E O F ***********************************/
