/****************************************************************************
**
**  Name:  sharedat.h
**
**  Description:
**     
**     Shared data definitions common to both sides
**
**  Status:  CODED
**
**  $Log:   S:/tbird/arcmmcf/sds/sharedat.h_v  $
** 
**    Rev 1.0   03 Jun 1996 11:37:48   gene
** Initial revision.
** 
**    Rev 1.0   07 Sep 1995 11:12:16   gene
** Initial revision.
** 
**    Rev 1.14   30 Mar 1994 10:53:26   ernie
** Moved BDM_SPEED definition to sdprobe.h so it is shared by PowerPack
** 
**    Rev 1.13   13 Jul 1993 09:14:14   ernie
** 1. Added bdmSpeed functions for faster operation when clock > 1 MHz.
** 2. Added support for asynchronous shared data packet transmissions.
** 
**    Rev 1.12   13 May 1993 11:13:20   ernie
** Added _sdlog command support
** 
**    Rev 1.11   05 May 1993 09:24:22   doug
** support demo version (no hardware) run-time
** 
**    Rev 1.10   22 Mar 1993 07:36:08   ernie
** Added get/set for berr retry flag
** 
**    Rev 1.9   10 Dec 1992 07:52:20   ernie
** Added total packet count to _commerrors command output
** 
**    Rev 1.8   04 Dec 1992 12:37:26   doug
** com port is now read from .ini and passed in
** 
**    Rev 1.7   03 Dec 1992 14:49:38   ernie
** Added Sd(n)WriteMemberNoCallback functions
** 
**    Rev 1.6   02 Dec 1992 07:40:08   ernie
** Moved all comm related stuff from sharedat.c to sharefw.c for PwrScope
** 
**    Rev 1.5   03 Nov 1992 12:28:26   ernie
** Removed B2HDelay from commerrors statistics...obsolete
** 
**    Rev 1.4   23 Oct 1992 13:00:46   ernie
** Added SdsCheckBreakCause.
** 
**    Rev 1.3   22 Oct 1992 15:27:02   ernie
** Added entry points for get/set of comm error recovery parameters.
** 
**    Rev 1.2   03 Sep 1992 13:14:42   doug
** internal prototypes to support two new debug commands (timeout and sd dump)
** 
**    Rev 1.1   22 Jul 1992 16:36:02   doug
** use sd template for definitions
** 
**    Rev 1.0   13 May 1992 17:01:44   mindy
** Initial revision.
**
**  $Header:   S:/tbird/arcmmcf/sds/sharedat.h_v   1.0   03 Jun 1996 11:37:48   gene  $
**
*****************************************************************************/

#define _SHAREDAT_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#ifndef _BASETYPE_
#include "basetype.h"
#endif

#ifndef _LISTW_
#include "listw.h"
#endif

#ifndef _SDPROC_
#include "sdproc.h"
#endif

#ifndef _SDPROBE_
#include "sdprobe.h"
#endif

#ifndef _SSHARED_
#include "sshared.h"
#endif

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/

typedef U32 ALLOC_SZ;
/* !!! typedef VOID (*CALLBACK)(DESCRIPTOR) CALLBACK; */

/*
** Shared data descriptor
*/
typedef struct {
   MEMBER_INDEX index;    /* index into shared data array */
   CALLBACK updateFunc;  /* callback function register */
}  SD_DESCRIPTOR;

#define MEMBER_NAME(index) sdSharedData.member[(U16)(index)].name
#define MEMBER_INDEX(index) sdSharedData.member[(U16)(index)].memberIndex
#define MEMBER_HOST_ACCESS(index) sdSharedData.member[(U16)(index)].hostAccess
#define MEMBER_FW_ACCESS(index) sdSharedData.member[(U16)(index)].fwAccess
#define MEMBER_NUM_BYTES(index) sdSharedData.member[(U16)(index)].numBytes
#define MEMBER_RETCODE(index) sdSharedData.member[(U16)(index)].returnCode
#define MEMBER_DATA(index) \
   &sdSharedDataVal[(U16)sdSharedData.member[(U16)(index)].dataOffset]
#define MEMBER_CALLBACK(index) sdSharedData.member[(U16)(index)].updateFuncs

/*
** Shared data definition
*/
typedef U32 SD_BYTES; /* total number of bytes in shared data */
typedef U32 MEMBER_NUM; /* total count of the number of members */

typedef struct {
   MEMBER_NAME name[SD_MAX_NAME+1];
   MEMBER_INDEX memberIndex;
   MEMBER_ACCESS hostAccess; /* read/write permission of host side */
   MEMBER_ACCESS fwAccess; /* read/write permission of firmware side */
   MEMBER_SIZE numBytes; /* number of bytes in member */
   RETCODE returnCode; /* current status of member to be returned */
   SD_BYTES dataOffset; /* pointer to start of data */
   LIST updateFuncs; /* linked list of registered call backs */
} SD_MEMBER;

typedef struct {
   MEMBER_NUM numMembers;
   SD_MEMBER member[NUM_OF_SD_MEMBERS]; /* !!! */
   SD_BYTES numBytesOfData;
} SHARED_DATA;

typedef enum {
   SDS_SYNC, SDS_ASYNC
} SD_TRANSMIT_MODE;

                        /****************************
                         *                          *
                         *        PROTOTYPES        *
                         *                          *
                         ****************************/

/****************************************************************************
**
**  SdFwInitialize
**
**  Description:
**     Initialization routine for sharefw.c.
**
*****************************************************************************/
RETCODE EXPORT SdFwInitialize(U16 hWnd, MEMBER_RESIDENCE residence,
   S16 *comPort);

/****************************************************************************
**
**  SdatInputAvailable
**
**  Description:
**     Routine common to host and firmware that is called when there is
**     a character ready to be read.
**
**  Parameters:
**     input:
**        none
**     output:
**        none
**
*****************************************************************************/
VOID EXPORT SdatInputAvailable(U16 hWnd, U16 iMsg, U16 wParam,
U32 lParam);

/****************************************************************************
**
**  SdatGetExclusiveSdAccess
**
**  Description:
**     This routine is called when exclusive access to shared data is
**     necessary.  When this routine returns, it guarantees no on else
**     will use shared data until the caller frees exclusive access.
**
**  Parameters:
**     input:
**        none
**     output:
**        none
*****************************************************************************/
RETCODE EXPORT SdatGetExclusiveSdAccess(VOID);

/****************************************************************************
**
**  SdatFreeExclusiveSdAccess
**
**  Description:
**     This routine frees the exclusive access so others can use shared data.
**
**  Parameters:
**     input:
**        none
**     output:
**        none
*****************************************************************************/
RETCODE EXPORT SdatFreeExclusiveSdAccess(VOID);

/****************************************************************************
**
**  SdatInvokeCallback
**
**  Description:
**     This routine invokes a function and passes it a descriptor.  In Vrtx,
**     this will start up a task.  In Windows, ??? !!!don't know yet.
**
**  Parameters:
**     input:
**        updateFunc       update function to callback
**        desc             member descriptor
**     output:
**        none
*****************************************************************************/
RETCODE EXPORT SdatInvokeCallback(CALLBACK updateFunc, DESCRIPTOR desc);

/****************************************************************************
**
**  SdatSendBytes
**
**  Description:
**     Routine to send data to the box.
**
**  Parameters:
**     input:
**        length:     length of data.
**        data:       pointer to data.
**     output:
**        none
**
*****************************************************************************/
RETCODE EXPORT SdatSendBytes(U16 length, U8 FAR *data);

/****************************************************************************
**
**  SdatGetTimeout
**
**  Description:
**     Get the current setting of timeout in seconds
**
**  Parameters:
**     input:
**        none
**     output:
**        timeout:     time out in seconds
**
*****************************************************************************/
RETCODE SdatGetTimeout(TIMEOUT *timeout);

/****************************************************************************
**
**  SdatSetTimeout
**
**  Description:
**     Set timeout in seconds
**
**  Parameters:
**     input:
**        timeout:     time out in seconds
**     output:
**        none
**
*****************************************************************************/
RETCODE SdatSetTimeout(TIMEOUT timeout);

/****************************************************************************
**
**  SdatDisplayMember
**
**  Description:
**     Display member information to CLI
**
**  Parameters:
**     input:
**        index:  index of member
**     output:
**        none
**
*****************************************************************************/
RETCODE SdatDisplayMember(U32 index);

/****************************************************************************
**
**  SdatGetCommErrors
**
**  Description:
**     Return number of various types of communication errors
**
**  Parameters:
**     input:
**        none
**     output:
**        H2BTimeout:   number of pkt timeouts sending to box
**        H2BRetries:   number of pkt retries sending to box
**        B2HTimeout:   number of pkt timeouts sending to host
**        B2HMissing:   number of pkts with missing characters sending to host
**        B2HGarbled:   number of pkts with checksum errors sending to host
**        H2BTotal:     total number of pkts from host to box
**        B2HTotal:     total number of pkts from box to host
**
*****************************************************************************/
RETCODE SdatGetCommErrors(U32 *H2BTimeout,U32 *H2BRetries, U32 *B2HTimeout,
          U32 *B2HMissing,U32 *B2HGarbled,U32 *H2BTotal,U32 *B2HTotal);

/****************************************************************************
**
**  SdatSetCommRetry
**  SdatGetCommRetry
**
**  Description:
**     Get/Set number of retries allowed per packet before failure
**
**  Parameters:
**     retry:     number of retries
**
*****************************************************************************/
RETCODE SdatGetCommRetry(U32 *retry);
RETCODE SdatSetCommRetry(U32 retry);

/****************************************************************************
**
**  SdatSetCommTimeout
**  SdatGetCommTimeout
**
**  Description:
**     Get/Set number of seconds to wait for more characters when a complete
**     packet has not arrived.  When the timeout is exceeded, a NAK is
**     transmitted since it is assumed one or more characters were lost.
**
**  Parameters:
**     timeout:     number of seconds
**
*****************************************************************************/
RETCODE SdatGetCommTimeout(U32 *timeout);
RETCODE SdatSetCommTimeout(U32 timeout);

/****************************************************************************
**
**  SdatSetBerrRetry
**  SdatGetBerrRetry
**
**  Description:
**     Get/Set whether to terminate PowerScope bus cycle with BERR
**     if the target does not respond.
**
**  Parameters:
**     timeout:     number of seconds
**
*****************************************************************************/
RETCODE SdatGetBerrRetry(BOOLEAN *retry);
RETCODE SdatSetBerrRetry(BOOLEAN retry);

/****************************************************************************
**
**  SdatSetBdmSpeed
**  SdatGetBdmSpeed
**
**  Description:
**     Get/Set whether to use slow or fast mode in bdm transmissions.
**
**  Parameters:
**     speed:  bdm speed
**
*****************************************************************************/
RETCODE SdatGetBdmSpeed(BDM_SPEED *speed);
RETCODE SdatSetBdmSpeed(BDM_SPEED speed);

/****************************************************************************
**
**  SdatSetSdLog
**  SdatGetSdLog
**
**  Description:
**     Get/Set shared data member transaction log filename and state
**
**  Parameters:
**     filename:     filename of log file
**     log:          TRUE indicates logging on
**
*****************************************************************************/
RETCODE SdatGetSdLog(BOOLEAN *log, LPSTR *filename);
RETCODE SdatSetSdLog(BOOLEAN log, LPSTR filename);

/****************************************************************************
**
**  SendMessageToCli
**
**  Description:
**     Send a message to the CLI.
**
**  Parameters:
**     input:
**        msgPtr:  pointer to text to send
**     output:
**        none
**
*****************************************************************************/
RETCODE SendMessageToCli(LPSTR msgPtr);

/****************************************************************************
**
**  InitDummy
**
**  Description:
**     Initialize no hardware (dummy) demonstration version.
**
**  Parameters:
**     input:
**        none
**     output:
**        none
**
*****************************************************************************/
RETCODE InitDummy(VOID);

VOID FAR PASCAL SdsCheckBreakCause(DESCRIPTOR desc);

/*
** Local routines, found in sharecom.c
*/
VOID EXPORT InputAvailable(VOID);
RETCODE SendFullMemberData(MEMBER_INDEX index, SD_TRANSMIT_MODE sync,
                           FARPROC func);
RETCODE SendPartialMemberData(MEMBER_INDEX index, MEMBER_OFFSET offset,
   MEMBER_SIZE length, SD_TRANSMIT_MODE sync, FARPROC func);
RETCODE UpdateMember(SD_DESCRIPTOR FAR *sdDesc, MEMBER_OFFSET offset,
  MEMBER_SIZE numBytes,U8 FAR *buff,RETCODE returnCode,BOOLEAN callCallbacks);
RETCODE UpdateMemberUsingIndex(MEMBER_INDEX index, MEMBER_OFFSET offset,
  MEMBER_SIZE numBytes,U8 FAR *buff,RETCODE returnCode,BOOLEAN callCallbacks);

/******************************** E O F ***********************************/
