/****************************************************************************
**
**  Name:  types.h
**
**  Description:
**     Definitions of BASIC TYPES.  This is used by the symbol manager to 
**     initialize the basic types for a processor.
**
**  Status:  PRELIMINARY
**
**  $Log:   S:/tbird/arcmmcf/symbol/types.h_v  $
** 
**    Rev 1.1   11 Jun 1996 18:51:30   gene
** 
**    Rev 1.0   07 Sep 1995 11:16:58   gene
** Initial revision.
** 
**    Rev 1.3   03 Dec 1992 07:47:54   brucea
** Changed: UNKNOWN TYPE to Unknown Type and the pointer version of same
** 
** 
**    Rev 1.2   13 Jan 1992 17:18:30   john
** Fixed dumb bug in initialized arrays
** 
**    Rev 1.1   18 Nov 1991 15:24:12   brucea
** Cosmetic change
** 
**    Rev 1.0   12 Sep 1991 11:39:22   john
** Initial revision.
**
**  $Header:   S:/tbird/arcmmcf/symbol/types.h_v   1.1   11 Jun 1996 18:51:30   gene  $
**
**  Copyright (C) 1991 Microtek International.  All rights reserved.
**
*****************************************************************************/

#define _TYPES_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/

#define BASIC_TYPE_COUNT 52

/* This initializes the names for the basic variable types.  */

PRIVATE S8 *basicTypeName[] = {
   "Unknown Type", "void", "signed char", "unsigned char", "signed short int",
   "unsigned short int", "signed long", "unsigned long", "signed long long",
   "unsigned long long","float", "double", "long double", "long long double",
   "string", "instruction address", "int", "unsigned", "unsigned int",
   "char", "long", "short", "unsigned short", "short int", "signed short",
   "BCD float", "\0", "\0", "\0", "\0", "\0", "\0",
   "Unknown Type *", "void *", "signed char *", "unsigned char *",
   "signed short int *", "unsigned short int *", "signed long *",
   "unsigned long *", "signed long long *", "unsigned long long *","float *",
   "double *", "long double *", "long long double *", "string *",
   "instruction address *", "int *", "unsigned *", "unsigned int *",
   "char *", "long *", "short *", "unsigned short *", "short int *",
   "signed short *", "BCD float *"
   };

/* this initializes the size in bytes of the basic variable types. */

static U8 basicTypeSize[BASIC_TYPE_COUNT] = {
   0, 0, 1, 1, 2, 2, 4, 4,
   8, 8, 4, 8,10,16, 0, 0,
   2, 2, 2, 1, 4, 2, 2, 2,
   2, 8, 0, 0, 0, 0, 0, 0,
   4, 4, 4, 4, 4, 4, 4, 4,
   4, 4, 4, 4, 4, 4, 4, 4,
   4, 4, 4, 4
};

                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/

/******************************** E O F ***********************************/
