/* CLI If Else node:
   CLI:  if (expression) { ifBody } else { elseBody }
   Actor:  if (expression)  then ifBody else elseBody endif; */!!

inherit(Object, #CLIIfElseNode, #(expression /* if expression */
ifBody  /* if body */
elseBody /* else body */), 2, nil)!!

now(class(CLIIfElseNode))!!

now(CLIIfElseNode)!!

/* Compile the node into Actor source. */
Def CLICodeCompile(self)
{
  CLICodeCompile("if (cTrue(self, ");
  expressionEchoOff(getExecutionEngine(CLIExecEngine));
  CLICodeCompile(expression);
  expressionEchoOn(getExecutionEngine(CLIExecEngine));
  CLICodeCompile(")) then ");
  CLICodeCompile(ifBody);
  CLICodeCompile(" else ");
  CLICodeCompile(elseBody);
  CLICodeCompile(" endif ");
}
!!

Def init(self, exp, ifBod, elseBod)
{
  expression := exp;
  ifBody := ifBod;
  elseBody := elseBod;
}!!
