/****************************************************************************
**
**  Name:  errcodec.h
**
**  Description:
**     All the error codes, corresponding to the errtext.rc error text
**     string resources.  This file is mostly automatically generated,
**     from mkerrors.h -- DO NOT CHANGE THIS FILE DIRECTLY.
**
**  Status:  PRELIMINARY 
**
**  $Log:   S:/tbird/arcmmcf/errtext/errcodec.h_v  $
** 
**    Rev 1.0   13 Sep 1996 10:58:10   gene
** Initial revision.
   
      Rev 1.0   03 Jun 1996 11:22:50   gene
   Initial revision.
   
      Rev 1.0   07 Sep 1995 10:22:40   gene
   Initial revision.
   
      Rev 1.0   09 Jun 1993 17:11:56   ron
   Initial revision.
   
      Rev 1.1   04 Jun 1993 16:21:18   ron
   No change.
   
      Rev 1.0   03 Jun 1993 16:33:32   ron
   Initial revision.
** 
**  $Header:   S:/tbird/arcmmcf/errtext/errcodec.h_v   1.0   13 Sep 1996 10:58:10   gene  $
**
**  Copyright (C) 1993 Microtek International.  All rights reserved.
**
*****************************************************************************/

#define _ERRCODEC_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/

/*
 * This is the base for the Help Entries for the errors -- all non-internal
 * errors will have a help entry corresponding to ER_HELP_BASE + the error
 * code.  The error code itself + 100 will be the index into the errtext.rc
 * string table, and the module code is no longer used as part of the error.
 */
#define ER_HELP_BASE 3000

/*
 * Here are all the error codes for all the error types in PowerViews
 * The corresponding error text is in errtext\errtext.rc.
 *
 * The remainder of this file is automatically generated from mkerrors.c --
 * DO NOT CHANGE THIS FILE DIRECTLY.
 */
#define ERR_ASSIGN_VEC0                         ( INTERNAL_ERROR_ON | E_WARNING | 419L )
#define ERR_ASSIGN_VEC23                        ( INTERNAL_ERROR_ON | E_WARNING | 418L )
#define ERR_BAD                                 ( INTERNAL_ERROR_ON | E_WARNING | 361L )
#define ERR_BAD_BASE                            ( INTERNAL_ERROR_ON | E_WARNING | 350L )
#define ERR_BAD_DATA_PORT                       ( INTERNAL_ERROR_ON | E_WARNING | 402L )
#define ERR_BAD_DEV_INFO                        ( INTERNAL_ERROR_ON | E_WARNING | 375L )
#define ERR_BAD_MEMORY                          ( INTERNAL_ERROR_ON | E_WARNING | 399L )
#define ERR_BAD_PROBE_DATA                      ( INTERNAL_ERROR_ON | E_WARNING | 379L )
#define ERR_BAD_REFRESH_MEM                     ( INTERNAL_ERROR_ON | E_WARNING | 411L )
#define ERR_BAD_SD_DATA                         ( INTERNAL_ERROR_ON | E_WARNING | 388L )
#define ERR_BAD_TEST                            ( INTERNAL_ERROR_ON | E_WARNING | 374L )
#define ERR_BAD_TIMER1                          ( INTERNAL_ERROR_ON | E_WARNING | 410L )
#define ERR_BAD_TRACE_DATA                      ( INTERNAL_ERROR_ON | E_WARNING | 387L )
#define ERR_BAD_TRIG_TYPE                       ( INTERNAL_ERROR_ON | E_WARNING | 394L )
#define ERR_CP_BOOT_EPROM_CHKSM                 ( INTERNAL_ERROR_ON | E_WARNING | 403L )
#define ERR_CP_FLASH_PROM_CHKSM                 ( INTERNAL_ERROR_ON | E_WARNING | 404L )
#define ERR_CP_MEM                              ( INTERNAL_ERROR_ON | E_WARNING | 415L )
#define ERR_EMPTY_SYM                           ( INTERNAL_ERROR_ON | E_WARNING | 365L )
#define ERR_FILL_ALWAYS_ON                      ( INTERNAL_ERROR_ON | E_WARNING | 391L )
#define ERR_INT_NOT_ON                          ( INTERNAL_ERROR_ON | E_WARNING | 413L )
#define ERR_INT_ON                              ( INTERNAL_ERROR_ON | E_WARNING | 414L )
#define ERR_INVALID_BOARD_TYPE                  ( INTERNAL_ERROR_ON | E_WARNING | 396L )
#define ERR_INVALID_CHAR                        ( INTERNAL_ERROR_ON | E_WARNING | 353L )
#define ERR_INVALID_CMD                         ( INTERNAL_ERROR_ON | E_WARNING | 376L )
#define ERR_INVALID_LOOPING                     ( INTERNAL_ERROR_ON | E_WARNING | 373L )
#define ERR_INVALID_MASK                        ( INTERNAL_ERROR_ON | E_WARNING | 351L )
#define ERR_INVALID_NUM_TRCBUF                  ( INTERNAL_ERROR_ON | E_WARNING | 385L )
#define ERR_INVALID_PORT                        ( INTERNAL_ERROR_ON | E_WARNING | 371L )
#define ERR_INVALID_PROBE                       ( INTERNAL_ERROR_ON | E_WARNING | 377L )
#define ERR_INVALID_SIZE                        ( INTERNAL_ERROR_ON | E_WARNING | 384L )
#define ERR_IN_CP_PORT                          ( INTERNAL_ERROR_ON | E_WARNING | 400L )
#define ERR_MISSING_QUOTE                       ( INTERNAL_ERROR_ON | E_WARNING | 352L )
#define ERR_NOT_DONE                            ( INTERNAL_ERROR_ON | E_WARNING | 395L )
#define ERR_NOT_TRIG                            ( INTERNAL_ERROR_ON | E_WARNING | 393L )
#define ERR_NO_SOCKET                           ( INTERNAL_ERROR_ON | E_WARNING | 397L )
#define ERR_NO_TIMER2_INT                       ( INTERNAL_ERROR_ON | E_WARNING | 412L )
#define ERR_NUMBER_EXCEEDS_SIZE                 ( INTERNAL_ERROR_ON | E_WARNING | 368L )
#define ERR_ONLY_ONE_RANGE                      ( INTERNAL_ERROR_ON | E_WARNING | 366L )
#define ERR_OUT_CP_PORT                         ( INTERNAL_ERROR_ON | E_WARNING | 401L )
#define ERR_PARSER_STACK_OVERFLOW               ( INTERNAL_ERROR_ON | E_WARNING | 363L )
#define ERR_PARSER_SYNTAX                       ( INTERNAL_ERROR_ON | E_WARNING | 354L )
#define ERR_PORT_ALIGN                          ( INTERNAL_ERROR_ON | E_WARNING | 370L )
#define ERR_PORT_BOUND                          ( INTERNAL_ERROR_ON | E_WARNING | 369L )
#define ERR_POS_STK_ERROR                       ( INTERNAL_ERROR_ON | E_WARNING | 359L )
#define ERR_PROBE_RX_TIMEOUT                    ( INTERNAL_ERROR_ON | E_WARNING | 378L )
#define ERR_PROGRAM_IS_RUNNING                  ( INTERNAL_ERROR_ON | E_WARNING | 362L )
#define ERR_PROGRAM_NOT_RUNNING                 ( INTERNAL_ERROR_ON | E_WARNING | 360L )
#define ERR_RESET_TMAN                          ( INTERNAL_ERROR_ON | E_WARNING | 386L )
#define ERR_SET_SOCKET                          ( INTERNAL_ERROR_ON | E_WARNING | 398L )
#define ERR_SET_TRACE_ACTION                    ( INTERNAL_ERROR_ON | E_WARNING | 383L )
#define ERR_STACK_OVERFLOW                      ( INTERNAL_ERROR_ON | E_WARNING | 357L )
#define ERR_STACK_UNDERFLOW                     ( INTERNAL_ERROR_ON | E_WARNING | 356L )
#define ERR_SYM_REDEFINED                       ( INTERNAL_ERROR_ON | E_WARNING | 364L )
#define ERR_TIMER2_INT                          ( INTERNAL_ERROR_ON | E_WARNING | 417L )
#define ERR_TOO_MANY_DATA_ITEMS                 ( INTERNAL_ERROR_ON | E_WARNING | 367L )
#define ERR_TRCBUF_FILL                         ( INTERNAL_ERROR_ON | E_WARNING | 392L )
#define ERR_TRCBUF_NOT_FILL                     ( INTERNAL_ERROR_ON | E_WARNING | 381L )
#define ERR_TRCBUF_NOT_INC                      ( INTERNAL_ERROR_ON | E_WARNING | 382L )
#define ERR_TRIC_WR_DATA                        ( INTERNAL_ERROR_ON | E_WARNING | 380L )
#define ERR_TRIG_POS_CYCLE                      ( INTERNAL_ERROR_ON | E_WARNING | 389L )
#define ERR_TRIG_POS_SBUFF                      ( INTERNAL_ERROR_ON | E_WARNING | 390L )
#define ERR_UART_BAD_DATA                       ( INTERNAL_ERROR_ON | E_WARNING | 408L )
#define ERR_UART_BAD_LS                         ( INTERNAL_ERROR_ON | E_WARNING | 406L )
#define ERR_UART_INT                            ( INTERNAL_ERROR_ON | E_WARNING | 416L )
#define ERR_UART_RCVR_EMPTY                     ( INTERNAL_ERROR_ON | E_WARNING | 407L )
#define ERR_UART_RCVR_TIMEOUT                   ( INTERNAL_ERROR_ON | E_WARNING | 409L )
#define ERR_UART_XMIT_NOT_EMPTY                 ( INTERNAL_ERROR_ON | E_WARNING | 405L )
#define ERR_UNLEX_STACK_OVERFLOW                ( INTERNAL_ERROR_ON | E_WARNING | 355L )
#define ERR_VAR_REDEFINED                       ( INTERNAL_ERROR_ON | E_WARNING | 358L )
#define ER_ABORT_FROM_ESC                       ( 501L )
#define ER_ABORT_SESSION                        ( E_SEVERE | 14L )
#define ER_ADDRESS_MISSING                      ( E_WARNING | 502L )
#define ER_ADDRESS_NOT_FOUND                    ( E_WARNING | 503L )
#define ER_ADDRESS_UPDATED                      ( E_WARNING | 504L )
#define ER_ADDR_ODD_ADDRESS                     ( E_WARNING | 505L )
#define ER_ADDR_TYPE_NOT_ACCEPTED               ( INTERNAL_ERROR_ON | E_WARNING | 506L )
#define ER_ADR_ADDRESS_TOO_LARGE                ( E_WARNING | 507L )
#define ER_ADR_DESCTBL_LIMIT_EXCEEDED           ( E_SEVERE | 508L )
#define ER_ADR_DIFFER_SEGMENTS                  ( INTERNAL_ERROR_ON | E_SEVERE | 509L )
#define ER_ADR_DIFFER_SPACES                    ( INTERNAL_ERROR_ON | E_SEVERE | 510L )
#define ER_ADR_DIFFER_TYPES                     ( INTERNAL_ERROR_ON | E_SEVERE | 511L )
#define ER_ADR_END_ADDR_TOO_SMALL               ( E_WARNING | 512L )
#define ER_ADR_EXCEEDS_ADR_LIMIT                ( E_SEVERE | 513L )
#define ER_ADR_EXCEEDS_SEG_LIMIT                ( E_SEVERE | 514L )
#define ER_ADR_INVALID_ADDRESS_STR              ( E_WARNING | 515L )
#define ER_ADR_INVALID_DESCRIPTOR               ( INTERNAL_ERROR_ON | E_WARNING | 516L )
#define ER_ADR_INVALID_PTR_SIZE                 ( INTERNAL_ERROR_ON | E_WARNING | 517L )
#define ER_ADR_LDT_INVALID                      ( E_SEVERE | 518L )
#define ER_ADR_LINEAR_TO_VIRTUAL_INVALID        ( INTERNAL_ERROR_ON | E_SEVERE | 519L )
#define ER_ADR_MODE_INVALID                     ( E_WARNING | 520L )
#define ER_ADR_NOT_INTEL_USAGE                  ( INTERNAL_ERROR_ON | E_WARNING | 521L )
#define ER_ADR_NOT_MOTOROLA_USAGE               ( INTERNAL_ERROR_ON | E_WARNING | 522L )
#define ER_ADR_NOT_RANGE_TYPE                   ( INTERNAL_ERROR_ON | E_WARNING | 523L )
#define ER_ADR_NULL_GDT_DESCRIPTOR              ( E_SEVERE | 524L )
#define ER_ADR_PAGE_UNAVAILABLE                 ( INTERNAL_ERROR_ON | E_SEVERE | 525L )
#define ER_ADR_PHYS_TO_LINEAR_NOT_SUPPORTED     ( INTERNAL_ERROR_ON | E_SEVERE | 526L )
#define ER_ADR_PMODE_UNAVAILABLE                ( INTERNAL_ERROR_ON | E_SEVERE | 527L )
#define ER_ADR_RESULT_OVERFLOW                  ( E_WARNING | 528L )
#define ER_ADR_RESULT_UNDERFLOW                 ( INTERNAL_ERROR_ON | E_WARNING | 529L )
#define ER_ADR_SEGMENT_INVALID                  ( E_SEVERE | 530L )
#define ER_ADR_SEGMENT_USE_INVALID              ( E_SEVERE | 531L )
#define ER_ADR_SHELL_NOT_SUPPORTED              ( E_SEVERE | 532L )
#define ER_ADR_SPACE_INVALID                    ( E_WARNING | 533L )
#define ER_ANO_TEXT_PARSE_FIELD                 ( INTERNAL_ERROR_ON | E_WARNING | 534L )
#define ER_ANO_TEXT_PARSE_SPECIAL               ( INTERNAL_ERROR_ON | E_WARNING | 535L )
#define ER_ARGS_NEED_SYM                        ( INTERNAL_ERROR_ON | 536L )
#define ER_ARRAY_INDEX_TOO_LARGE                ( INTERNAL_ERROR_ON | E_WARNING | 537L )
#define ER_ATN_EXPT                             ( E_WARNING | 538L )
#define ER_ATN_NOT_HANDLED                      ( E_WARNING | 539L )
#define ER_ATTR_NOT_HANDLED                     ( E_WARNING | 540L )
#define ER_BADGET                               ( 541L )
#define ER_BADID                                ( E_WARNING | 542L )
#define ER_BADMODULE                            ( 543L )
#define ER_BAD_ATI_RECORD_IN_FILE               ( E_WARNING | 544L )
#define ER_BAD_CMD_TYPE                         ( INTERNAL_ERROR_ON | E_WARNING | 259L )
#define ER_BAD_COMM_STATE                       ( INTERNAL_ERROR_ON | E_WARNING | 261L )
#define ER_BAD_COUNTER                          ( INTERNAL_ERROR_ON | E_WARNING | 545L )
#define ER_BAD_EVENT                            ( E_WARNING | 546L )
#define ER_BAD_FIELD_NUMBER                     ( INTERNAL_ERROR_ON | E_WARNING | 547L )
#define ER_BAD_FILE                             ( E_WARNING | 548L )
#define ER_BAD_FREE                             ( INTERNAL_ERROR_ON | E_WARNING | 549L )
#define ER_BAD_FREQUENCY                        ( E_WARNING | 550L )
#define ER_BAD_HDR                              ( E_WARNING | 551L )
#define ER_BAD_LNUM_BLOCK_IN_FILE               ( E_WARNING | 552L )
#define ER_BAD_NEST                             ( E_WARNING | 553L )
#define ER_BAD_PART                             ( E_WARNING | 554L )
#define ER_BAD_REG_INDEX                        ( E_WARNING | 555L )
#define ER_BAD_SECREC                           ( E_WARNING | 556L )
#define ER_BAD_SEEK                             ( E_WARNING | 557L )
#define ER_BAD_TRACE_INFO                       ( INTERNAL_ERROR_ON | E_WARNING | 558L )
#define ER_BAD_UNREGISTER                       ( INTERNAL_ERROR_ON | E_WARNING | 559L )
#define ER_BAUDRATE                             ( INTERNAL_ERROR_ON | E_WARNING | 560L )
#define ER_BBFUNCTION_EXPT                      ( E_WARNING | 561L )
#define ER_BDM_PACKET_OVERFLOW                  ( INTERNAL_ERROR_ON | E_WARNING | 298L )
#define ER_BDM_RESULT_OVERFLOW                  ( INTERNAL_ERROR_ON | E_WARNING | 299L )
#define ER_BKPT_CANT_ADD                        ( INTERNAL_ERROR_ON | E_FATAL | 562L )
#define ER_BKPT_CANT_REGISTER                   ( INTERNAL_ERROR_ON | E_SEVERE | 563L )
#define ER_BKPT_MEM_FAIL                        ( E_FATAL | 564L )
#define ER_BKPT_NONE_AVAILABLE                  ( E_WARNING | 565L )
#define ER_BKPT_NONE_SELECTED                   ( E_WARNING | 566L )
#define ER_BKPT_NOT_FOUND                       ( INTERNAL_ERROR_ON | E_WARNING | 307L )
#define ER_BKPT_NO_WINDOW                       ( INTERNAL_ERROR_ON | E_SEVERE | 567L )
#define ER_BK_EMULATOR_MUST_BE_HALTED           ( E_WARNING | 568L )
#define ER_BLOCK_ALREADY_MAPPED                 ( E_WARNING | 569L )
#define ER_BLOCK_NOT_FOUND                      ( INTERNAL_ERROR_ON | E_WARNING | 570L )
#define ER_BLOCK_OUT_OF_RANGE                   ( INTERNAL_ERROR_ON | E_WARNING | 571L )
#define ER_BLOCK_TOO_LARGE                      ( E_WARNING | 572L )
#define ER_BLOCK_UNMAPPABLE                     ( E_WARNING | 573L )
#define ER_BONDOUT_FLT                          ( E_WARNING | 461L )
#define ER_BREAK                                ( INTERNAL_ERROR_ON | E_WARNING | 295L )
#define ER_BUF                                  ( INTERNAL_ERROR_ON | E_WARNING | 186L )
#define ER_BUS_ERROR                            ( E_WARNING | 300L )
#define ER_BUS_TIMEOUT                          ( E_WARNING | 302L )
#define ER_BX_ALREADY_HAS_BKPT                  ( E_WARNING | 574L )
#define ER_BX_ASMGRANULARITY_INVALID            ( INTERNAL_ERROR_ON | E_WARNING | 575L )
#define ER_BX_BKPT_LESSTHAN_FUNC                ( INTERNAL_ERROR_ON | E_WARNING | 576L )
#define ER_BX_EMU_IS_HALTED                     ( E_INFORMATIVE | 577L )
#define ER_BX_ID_TOO_BIG                        ( E_WARNING | 578L )
#define ER_BX_INACTIVE_BKPT                     ( E_WARNING | 579L )
#define ER_BX_INVALID_CALLBACK                  ( INTERNAL_ERROR_ON | E_WARNING | 580L )
#define ER_BX_INVALID_COUNT                     ( E_WARNING | 581L )
#define ER_BX_INVALID_DESCRIPTOR                ( INTERNAL_ERROR_ON | E_WARNING | 582L )
#define ER_BX_LOOP_COMPLETE                     ( INTERNAL_ERROR_ON | E_WARNING | 583L )
#define ER_BX_NOT_ON_INST_BOUNDARY              ( E_WARNING | 584L )
#define ER_BX_NO_BKPT_AVAILABLE                 ( E_WARNING | 585L )
#define ER_BX_NO_BKPT_MATCH_ADDR                ( E_WARNING | 586L )
#define ER_BX_NO_CALL_RETURN                    ( E_WARNING | 587L )
#define ER_BX_SEND_MESSAGE                      ( INTERNAL_ERROR_ON | E_WARNING | 588L )
#define ER_BYADDRTABLE_EMPTY                    ( INTERNAL_ERROR_ON | E_WARNING | 589L )
#define ER_BYTESIZE                             ( INTERNAL_ERROR_ON | E_WARNING | 590L )
#define ER_CANNOT_ADD_ASM_MOD                   ( INTERNAL_ERROR_ON | 591L )
#define ER_CANNOT_ADD_FUNC                      ( E_WARNING | 592L )
#define ER_CANNOT_ADD_MOD                       ( E_WARNING | 593L )
#define ER_CANNOT_ADD_PUBLIC                    ( E_WARNING | 594L )
#define ER_CANNOT_ADD_SYM                       ( E_WARNING | 595L )
#define ER_CANNOT_FIND_PFILE                    ( E_WARNING | 596L )
#define ER_CANNOT_FIND_WDIR                     ( E_WARNING | 597L )
#define ER_CANNOT_GET_TOOL_NAME                 ( E_WARNING | 598L )
#define ER_CANNOT_OPEN                          ( E_WARNING | 599L )
#define ER_CANNOT_WRITE_TO_FILE                 ( E_WARNING | 600L )
#define ER_CANT_CLOSE_FILE                      ( E_WARNING | 601L )
#define ER_CANT_CONV_TEXT                       ( E_WARNING | 602L )
#define ER_CANT_DISPLAY_BUF                     ( INTERNAL_ERROR_ON | E_WARNING | 603L )
#define ER_CANT_DO_COMMAND                      ( INTERNAL_ERROR_ON | E_WARNING | 604L )
#define ER_CANT_GET_SIZE                        ( E_WARNING | 605L )
#define ER_CANT_GET_STACK_DIR                   ( INTERNAL_ERROR_ON | E_FATAL | 606L )
#define ER_CANT_INIT_PROBE                      ( E_SEVERE | 17L )
#define ER_CANT_LOAD_BITMAP                     ( INTERNAL_ERROR_ON | E_WARNING | 607L )
#define ER_CANT_OPEN_FILE                       ( E_WARNING | 608L )
#define ER_CANT_OPEN_MEM_WINDOW                 ( E_WARNING | 609L )
#define ER_CANT_OPEN_SOURCE_FILE                ( E_WARNING | 610L )
#define ER_CANT_OPEN_TEMPLATE_FILE              ( E_WARNING | 611L )
#define ER_CANT_OPEN_UNIX_FILE                  ( E_WARNING | 612L )
#define ER_CANT_REOPEN_FILE                     ( E_WARNING | 613L )
#define ER_CANT_REOPEN_MIXED                    ( E_WARNING | 614L )
#define ER_CANT_SCROLL                          ( INTERNAL_ERROR_ON | E_WARNING | 615L )
#define ER_CANT_START_TASK                      ( INTERNAL_ERROR_ON | E_WARNING | 254L )
#define ER_CAUSE_STATUS                         ( E_WARNING | 424L )
#define ER_CLIULIB_BAD_DRIVES_BAT_LINE          ( INTERNAL_ERROR_ON | E_WARNING | 616L )
#define ER_CLIULIB_CLI_OPEN_FAILED              ( INTERNAL_ERROR_ON | E_WARNING | 617L )
#define ER_CLIULIB_DIRECTORY_ATTACH_FAILED      ( INTERNAL_ERROR_ON | E_WARNING | 618L )
#define ER_CLIULIB_DRIVES_BAT_NOT_FOUND         ( INTERNAL_ERROR_ON | E_WARNING | 619L )
#define ER_CLIULIB_DRIVES_BAT_OPEN_FAILED       ( INTERNAL_ERROR_ON | E_WARNING | 620L )
#define ER_CLIULIB_DRIVES_BAT_READ_FAILED       ( INTERNAL_ERROR_ON | E_WARNING | 621L )
#define ER_CLIULIB_DRIVE_ATTACH_FAILED          ( INTERNAL_ERROR_ON | E_WARNING | 622L )
#define ER_CLIULIB_ILLEGAL_DRIVE                ( INTERNAL_ERROR_ON | E_WARNING | 623L )
#define ER_CLIULIB_INVALID_INI_NUMBER           ( INTERNAL_ERROR_ON | E_WARNING | 624L )
#define ER_CLIULIB_PCNFS_NOT_INSTALLED          ( E_WARNING | 625L )
#define ER_CLIULIB_PFILE_NOT_FOUND              ( INTERNAL_ERROR_ON | E_SEVERE | 626L )
#define ER_CLIULIB_PPATH_NOT_AVAIL              ( INTERNAL_ERROR_ON | E_SEVERE | 627L )
#define ER_CLIULIB_UNABLE_TO_READ_PFILE         ( INTERNAL_ERROR_ON | E_SEVERE | 628L )
#define ER_CLIULIB_UNABLE_TO_WRITE_PFILE        ( INTERNAL_ERROR_ON | E_SEVERE | 629L )
#define ER_CLIULIB_UNIX_DIR_NOT_FOUND           ( INTERNAL_ERROR_ON | E_WARNING | 630L )
#define ER_CLIULIB_UNIX_FILE_NOT_FOUND          ( INTERNAL_ERROR_ON | E_WARNING | 631L )
#define ER_CLIULIB_WDIR_NOT_FOUND               ( INTERNAL_ERROR_ON | E_SEVERE | 632L )
#define ER_CLI_ALREADY_RUNNING                  ( INTERNAL_ERROR_ON | E_WARNING | 633L )
#define ER_CLI_BAD_DEC                          ( E_WARNING | 634L )
#define ER_CLI_BAD_HEX                          ( E_WARNING | 635L )
#define ER_CLI_BAD_OCT                          ( E_WARNING | 636L )
#define ER_CLI_BAD_SERVER_COMMAND               ( INTERNAL_ERROR_ON | E_WARNING | 637L )
#define ER_CLI_COMMAND_NAME                     ( INTERNAL_ERROR_ON | E_WARNING | 638L )
#define ER_CLI_COMMAND_SIZE                     ( E_WARNING | 639L )
#define ER_CLI_DOING_COMMAND                    ( E_INFORMATIVE | 640L )
#define ER_CLI_DUPLICATE_KEY                    ( INTERNAL_ERROR_ON | E_WARNING | 641L )
#define ER_CLI_DUPLICATE_SERVER                 ( INTERNAL_ERROR_ON | E_WARNING | 642L )
#define ER_CLI_ENTRY_POINT                      ( INTERNAL_ERROR_ON | E_WARNING | 643L )
#define ER_CLI_FAILED                           ( INTERNAL_ERROR_ON | E_WARNING | 644L )
#define ER_CLI_FILE_ACCESS                      ( E_WARNING | 645L )
#define ER_CLI_FILE_ARG                         ( INTERNAL_ERROR_ON | E_WARNING | 646L )
#define ER_CLI_FILE_CODE                        ( INTERNAL_ERROR_ON | E_WARNING | 647L )
#define ER_CLI_FILE_DEVICE                      ( INTERNAL_ERROR_ON | E_WARNING | 648L )
#define ER_CLI_FILE_HANDLE                      ( INTERNAL_ERROR_ON | E_WARNING | 649L )
#define ER_CLI_FILE_NOT_FOUND                   ( E_WARNING | 650L )
#define ER_CLI_FILE_NUMBER                      ( INTERNAL_ERROR_ON | E_WARNING | 651L )
#define ER_CLI_FILE_OPEN_ERR                    ( E_WARNING | 652L )
#define ER_CLI_FILE_PATH                        ( E_WARNING | 653L )
#define ER_CLI_FILE_TOO_MANY                    ( E_WARNING | 654L )
#define ER_CLI_HISTORY_SIZE                     ( E_WARNING | 655L )
#define ER_CLI_INPUT_STACK_OVERFLOW             ( E_WARNING | 656L )
#define ER_CLI_INTERNAL                         ( INTERNAL_ERROR_ON | E_FATAL | 657L )
#define ER_CLI_INTERNAL_ERROR                   ( INTERNAL_ERROR_ON | E_WARNING | 658L )
#define ER_CLI_LINE_COUNT                       ( E_WARNING | 659L )
#define ER_CLI_MALFORMED_VARIABLE               ( E_WARNING | 660L )
#define ER_CLI_NO_HELP                          ( INTERNAL_ERROR_ON | E_WARNING | 661L )
#define ER_CLI_NO_SERVER_NAME                   ( INTERNAL_ERROR_ON | E_WARNING | 662L )
#define ER_CLI_SERVER_REG                       ( INTERNAL_ERROR_ON | E_WARNING | 663L )
#define ER_CLI_SYNTAX                           ( E_WARNING | 664L )
#define ER_CLI_UNDECL_VAR                       ( E_WARNING | 665L )
#define ER_CLI_UNREGISTERED_COMMAND             ( INTERNAL_ERROR_ON | E_WARNING | 666L )
#define ER_CLI_UNREGISTERED_SERVER              ( INTERNAL_ERROR_ON | E_WARNING | 667L )
#define ER_CLI_UNTERM_COMMENT                   ( E_WARNING | 668L )
#define ER_CLI_UNTERM_STRING                    ( E_WARNING | 669L )
#define ER_CLI_USER_ABORT                       ( E_WARNING | 670L )
#define ER_CLOSE_SYM                            ( INTERNAL_ERROR_ON | E_WARNING | 671L )
#define ER_CMD_ABORT                            ( INTERNAL_ERROR_ON | E_WARNING | 283L )
#define ER_CODEBUF_SIZE                         ( INTERNAL_ERROR_ON | E_WARNING | 672L )
#define ER_CODE_OVF                             ( INTERNAL_ERROR_ON | E_WARNING | 256L )
#define ER_CODE_STREAM                          ( INTERNAL_ERROR_ON | E_WARNING | 673L )
#define ER_COM                                  ( INTERNAL_ERROR_ON | E_WARNING | 212L )
#define ER_COMM_PACKET_TIMEOUT                  ( E_SEVERE | 15L )
#define ER_COMM_RETRY_EXHAUSTED                 ( E_WARNING | 16L )
#define ER_COMM_STATE                           ( INTERNAL_ERROR_ON | E_WARNING | 674L )
#define ER_COM_BADTIMER                         ( INTERNAL_ERROR_ON | E_WARNING | 675L )
#define ER_COM_CONFIG                           ( INTERNAL_ERROR_ON | E_SEVERE | 9L )
#define ER_COM_FRAME                            ( INTERNAL_ERROR_ON | E_WARNING | 676L )
#define ER_COM_HWRCV                            ( INTERNAL_ERROR_ON | E_WARNING | 677L )
#define ER_COM_INREAD                           ( INTERNAL_ERROR_ON | E_WARNING | 678L )
#define ER_COM_NOREAD_CALLBACK                  ( INTERNAL_ERROR_ON | E_WARNING | 679L )
#define ER_COM_NOREAD_TIMEOUT                   ( INTERNAL_ERROR_ON | E_WARNING | 680L )
#define ER_COM_OPEN                             ( E_SEVERE | 7L )
#define ER_COM_RCVOVER                          ( INTERNAL_ERROR_ON | E_WARNING | 681L )
#define ER_COM_READNOTALL                       ( INTERNAL_ERROR_ON | E_WARNING | 682L )
#define ER_COM_READTIMEOUT                      ( INTERNAL_ERROR_ON | E_WARNING | 683L )
#define ER_COM_TIMEDOUT                         ( INTERNAL_ERROR_ON | E_WARNING | 684L )
#define ER_COM_TXFULL                           ( INTERNAL_ERROR_ON | E_WARNING | 685L )
#define ER_CONFIG_FILE_FORMAT                   ( E_WARNING | 686L )
#define ER_COPY_ABORT                           ( E_WARNING | 442L )
#define ER_CPP_DUPLICATE                        ( E_WARNING | 687L )
#define ER_CPP_NOT_SUPPORTED                    ( E_WARNING | 688L )
#define ER_CPU_CANT_BE_ODD                      ( E_WARNING | 689L )
#define ER_CPU_CONFIG_FILE_FORMAT               ( E_FATAL | 690L )
#define ER_CPU_PROC_EM                          ( E_INFORMATIVE | 691L )
#define ER_CVT                                  ( INTERNAL_ERROR_ON | E_WARNING | 211L )
#define ER_DAD_ASM_ERROR                        ( E_WARNING | 692L )
#define ER_DAD_AT_TOP_OF_MEMORY                 ( E_WARNING | 693L )
#define ER_DAD_BAD_FW_LINES                     ( INTERNAL_ERROR_ON | E_WARNING | 694L )
#define ER_DAD_BAD_MASKED_INST_FORMAT           ( E_WARNING | 695L )
#define ER_DAD_BAD_NUM_PARM                     ( E_WARNING | 696L )
#define ER_DAD_BOGUS_ADDRESS                    ( INTERNAL_ERROR_ON | E_WARNING | 697L )
#define ER_DAD_DISPLACEMENT_INVALID             ( E_WARNING | 698L )
#define ER_DAD_EA_INVALID                       ( E_WARNING | 699L )
#define ER_DAD_IMMED_FIELD_INCORRECT            ( E_WARNING | 700L )
#define ER_DAD_INCORRECT_DISP                   ( E_WARNING | 701L )
#define ER_DAD_INST_NOT_FOUND                   ( E_WARNING | 702L )
#define ER_DAD_INST_SIZE_UNDETERMINED           ( INTERNAL_ERROR_ON | E_WARNING | 703L )
#define ER_DAD_INVALID_ID_DESCRIPTOR            ( INTERNAL_ERROR_ON | E_WARNING | 704L )
#define ER_DAD_INVALID_INDEX_REG                ( E_WARNING | 705L )
#define ER_DAD_INVALID_INST_ADDR                ( E_WARNING | 706L )
#define ER_DAD_INVALID_MODE_FOR_INST            ( E_WARNING | 707L )
#define ER_DAD_INVALID_NUM_OPERANDS             ( E_WARNING | 708L )
#define ER_DAD_INVALID_OPCODE                   ( E_WARNING | 709L )
#define ER_DAD_INVALID_REGLIST_BIT              ( E_WARNING | 710L )
#define ER_DAD_NO_FLUSH_FRAMES_FOUND            ( E_WARNING | 711L )
#define ER_DAD_NO_SUCH_INST                     ( E_WARNING | 712L )
#define ER_DAD_OPERAND_INVALID                  ( E_WARNING | 713L )
#define ER_DAD_REG_INVALID                      ( E_WARNING | 714L )
#define ER_DAD_STRING_NOT_FOUND                 ( INTERNAL_ERROR_ON | E_WARNING | 715L )
#define ER_DAD_SYMBOL_USE_BUT_DISABLED          ( E_WARNING | 716L )
#define ER_DASM_CANT                            ( INTERNAL_ERROR_ON | E_FATAL | 717L )
#define ER_DASM_CANT_SET_BKPT                   ( E_WARNING | 718L )
#define ER_DASM_INVALID_ALIAS                   ( E_WARNING | 719L )
#define ER_DASM_MEMORY                          ( E_SEVERE | 720L )
#define ER_DASM_NO_BKPT                         ( E_WARNING | 721L )
#define ER_DASM_REOPEN                          ( E_FATAL | 722L )
#define ER_DEFAULT                              ( INTERNAL_ERROR_ON | E_WARNING | 723L )
#define ER_DEFINE_START_FIRST                   ( E_WARNING | 724L )
#define ER_DEFSEC_NOT_FOUND                     ( E_WARNING | 725L )
#define ER_DEL                                  ( INTERNAL_ERROR_ON | E_WARNING | 230L )
#define ER_DESCRIPTOR_NOT_VALID                 ( INTERNAL_ERROR_ON | E_WARNING | 726L )
#define ER_DOFIELD_END                          ( INTERNAL_ERROR_ON | E_WARNING | 727L )
#define ER_DOFIELD_END_TAG                      ( INTERNAL_ERROR_ON | E_WARNING | 728L )
#define ER_DQ_ABORTED                           ( E_WARNING | 434L )
#define ER_DQ_NO_FRAMES_AVAILABLE               ( E_WARNING | 435L )
#define ER_DUPLICATE_GLOBAL_NAME                ( INTERNAL_ERROR_ON | E_WARNING | 729L )
#define ER_EEPROM_ERROR                         ( INTERNAL_ERROR_ON | E_WARNING | 249L )
#define ER_END_NOT_ALLOWED                      ( INTERNAL_ERROR_ON | E_WARNING | 730L )
#define ER_END_OF_BUFFER                        ( INTERNAL_ERROR_ON | E_WARNING | 439L )
#define ER_ENL_CLI                              ( INTERNAL_ERROR_ON | E_WARNING | 731L )
#define ER_ERCODE_NOT_FOUND                     ( INTERNAL_ERROR_ON | 732L )
#define ER_ETHERNET_NOT_SUPPORTED               ( INTERNAL_ERROR_ON | E_SEVERE | 733L )
#define ER_EVTREC_TRACE                         ( E_WARNING | 469L )
#define ER_EXPAND_SIZE_ERROR                    ( INTERNAL_ERROR_ON | E_WARNING | 734L )
#define ER_FAILED_STRCPY                        ( INTERNAL_ERROR_ON | E_WARNING | 735L )
#define ER_FAST_TERMINATION                     ( E_WARNING | 420L )
#define ER_FCK                                  ( INTERNAL_ERROR_ON | E_WARNING | 239L )
#define ER_FIELD_NAME                           ( E_WARNING | 736L )
#define ER_FIELD_NAME_DUP                       ( E_WARNING | 737L )
#define ER_FILE_NOT_FOUND                       ( E_WARNING | 738L )
#define ER_FILL_ABORT                           ( E_WARNING | 312L )
#define ER_FIRST_CREATE                         ( INTERNAL_ERROR_ON | E_WARNING | 247L )
#define ER_FLASH_CHKSUM                         ( INTERNAL_ERROR_ON | E_WARNING | 276L )
#define ER_FLASH_ERASE                          ( INTERNAL_ERROR_ON | E_WARNING | 273L )
#define ER_FLASH_IMAGE_SIZE                     ( INTERNAL_ERROR_ON | E_WARNING | 277L )
#define ER_FLASH_SIZE                           ( INTERNAL_ERROR_ON | E_WARNING | 275L )
#define ER_FLASH_VERIFY                         ( INTERNAL_ERROR_ON | E_WARNING | 274L )
#define ER_FLUSH_IN_QUEUE                       ( INTERNAL_ERROR_ON | E_WARNING | 739L )
#define ER_FLUSH_OUT_QUEUE                      ( INTERNAL_ERROR_ON | E_WARNING | 740L )
#define ER_FN_NOT_FOUND                         ( INTERNAL_ERROR_ON | E_WARNING | 741L )
#define ER_FP_NOT_SUPPORTED                     ( INTERNAL_ERROR_ON | E_WARNING | 742L )
#define ER_FRAMING                              ( INTERNAL_ERROR_ON | E_WARNING | 292L )
#define ER_FSZ                                  ( INTERNAL_ERROR_ON | E_WARNING | 238L )
#define ER_FW_INTERNAL                          ( INTERNAL_ERROR_ON | E_WARNING | 232L )
#define ER_GO_RETURNED                          ( INTERNAL_ERROR_ON | E_WARNING | 248L )
#define ER_HALT_TIMEOUT                         ( E_WARNING | 429L )
#define ER_HARDWARE                             ( E_WARNING | 743L )
#define ER_HEAP_BAD_FREE_ADDRESS                ( INTERNAL_ERROR_ON | E_WARNING | 744L )
#define ER_HEAP_BAD_POINTER                     ( INTERNAL_ERROR_ON | E_WARNING | 745L )
#define ER_HEAP_CORRUPT                         ( INTERNAL_ERROR_ON | E_WARNING | 746L )
#define ER_HEAP_OUT_OF_MEMORY                   ( E_WARNING | 747L )
#define ER_HEAP_REQUEST_TOO_BIG                 ( INTERNAL_ERROR_ON | E_WARNING | 748L )
#define ER_HEX_ABORT                            ( INTERNAL_ERROR_ON | E_WARNING | 279L )
#define ER_HEX_FORMAT                           ( INTERNAL_ERROR_ON | E_WARNING | 280L )
#define ER_HOLD_STUCK                           ( E_WARNING | 464L )
#define ER_ICE_BKPT_TIMEOUT                     ( E_WARNING | 453L )
#define ER_ICE_CMD_TIMEOUT                      ( E_WARNING | 452L )
#define ER_ICE_MODE_TIMEOUT                     ( E_WARNING | 451L )
#define ER_ICP                                  ( INTERNAL_ERROR_ON | E_WARNING | 196L )
#define ER_ID                                   ( INTERNAL_ERROR_ON | E_WARNING | 228L )
#define ER_IEEE_FLOAT                           ( INTERNAL_ERROR_ON | E_SEVERE | 749L )
#define ER_IIP                                  ( INTERNAL_ERROR_ON | E_WARNING | 197L )
#define ER_ILLEGAL_386_CMD                      ( INTERNAL_ERROR_ON | E_WARNING | 465L )
#define ER_ILLEGAL_CMD                          ( E_WARNING | 301L )
#define ER_ILLEGAL_EVENT                        ( INTERNAL_ERROR_ON | E_WARNING | 750L )
#define ER_ILLEGAL_SIGNAL                       ( INTERNAL_ERROR_ON | E_WARNING | 431L )
#define ER_ILLEGAL_WHILE_EMON                   ( E_WARNING | 309L )
#define ER_ILL_MAP_CONTENT                      ( INTERNAL_ERROR_ON | E_WARNING | 454L )
#define ER_ILL_MAP_PROTECT                      ( INTERNAL_ERROR_ON | E_WARNING | 455L )
#define ER_INCOMPATIBLE_CPU                     ( E_WARNING | 751L )
#define ER_INDEX_ALREADY_EXISTS                 ( INTERNAL_ERROR_ON | E_WARNING | 752L )
#define ER_INDEX_NOT_IN_TABLE                   ( INTERNAL_ERROR_ON | E_WARNING | 753L )
#define ER_INDEX_OUT_OF_BOUNDS                  ( INTERNAL_ERROR_ON | E_WARNING | 754L )
#define ER_INI                                  ( INTERNAL_ERROR_ON | E_WARNING | 194L )
#define ER_INPUT_OVERRUN                        ( E_WARNING | 303L )
#define ER_INPUT_SEMA                           ( INTERNAL_ERROR_ON | E_SEVERE | 10L )
#define ER_INSUF_MAP_BLOCKS                     ( E_WARNING | 456L )
#define ER_INTERNAL                             ( INTERNAL_ERROR_ON | E_WARNING | 755L )
#define ER_INTERNAL_DQ_LINEUP                   ( INTERNAL_ERROR_ON | E_WARNING | 448L )
#define ER_INTERNAL_ERROR                       ( INTERNAL_ERROR_ON | E_SEVERE | 756L )
#define ER_INTERNAL_LINE_UP                     ( INTERNAL_ERROR_ON | E_WARNING | 757L )
#define ER_INTERNAL_TERMINATION                 ( E_WARNING | 441L )
#define ER_INT_TOO_BIG                          ( INTERNAL_ERROR_ON | E_WARNING | 758L )
#define ER_INVALID_ACCESS                       ( INTERNAL_ERROR_ON | E_WARNING | 426L )
#define ER_INVALID_ACTION                       ( INTERNAL_ERROR_ON | E_WARNING | 759L )
#define ER_INVALID_ADDRESS                      ( INTERNAL_ERROR_ON | E_WARNING | 760L )
#define ER_INVALID_ADDRESS_TYPE                 ( INTERNAL_ERROR_ON | E_WARNING | 761L )
#define ER_INVALID_ALIAS_PATH                   ( E_WARNING | 762L )
#define ER_INVALID_ARG                          ( E_WARNING | 763L )
#define ER_INVALID_BKPT_INFO                    ( E_WARNING | 764L )
#define ER_INVALID_BUFFER                       ( E_WARNING | 437L )
#define ER_INVALID_DATA_OBJECT                  ( INTERNAL_ERROR_ON | E_FATAL | 765L )
#define ER_INVALID_DIGIT                        ( E_WARNING | 766L )
#define ER_INVALID_DISP_FORMAT                  ( INTERNAL_ERROR_ON | E_WARNING | 767L )
#define ER_INVALID_EVENT                        ( INTERNAL_ERROR_ON | E_WARNING | 768L )
#define ER_INVALID_EVENT_NAME                   ( E_WARNING | 769L )
#define ER_INVALID_FIELD                        ( INTERNAL_ERROR_ON | E_WARNING | 770L )
#define ER_INVALID_FIELD_NUM                    ( INTERNAL_ERROR_ON | E_WARNING | 771L )
#define ER_INVALID_FRAME                        ( E_WARNING | 772L )
#define ER_INVALID_IDN                          ( INTERNAL_ERROR_ON | E_WARNING | 773L )
#define ER_INVALID_INPUT                        ( E_WARNING | 774L )
#define ER_INVALID_LANGUAGE                     ( INTERNAL_ERROR_ON | E_WARNING | 775L )
#define ER_INVALID_LENGTH                       ( INTERNAL_ERROR_ON | E_WARNING | 287L )
#define ER_INVALID_MAP_BLOCK                    ( INTERNAL_ERROR_ON | E_WARNING | 428L )
#define ER_INVALID_MODE                         ( E_WARNING | 776L )
#define ER_INVALID_MODULE_NAME                  ( INTERNAL_ERROR_ON | E_WARNING | 777L )
#define ER_INVALID_MODULE_SYMBOL                ( E_WARNING | 778L )
#define ER_INVALID_PROBE_SPACE                  ( INTERNAL_ERROR_ON | E_WARNING | 286L )
#define ER_INVALID_PRODUCT_IN_DEMO              ( INTERNAL_ERROR_ON | E_FATAL | 779L )
#define ER_INVALID_RANGE_SPEC                   ( INTERNAL_ERROR_ON | E_WARNING | 780L )
#define ER_INVALID_REGID                        ( INTERNAL_ERROR_ON | E_WARNING | 781L )
#define ER_INVALID_SECTION_NAME                 ( E_WARNING | 782L )
#define ER_INVALID_SIGID                        ( INTERNAL_ERROR_ON | E_WARNING | 783L )
#define ER_INVALID_SPACE                        ( INTERNAL_ERROR_ON | E_WARNING | 427L )
#define ER_INVALID_SYM_DESCRIPTOR               ( INTERNAL_ERROR_ON | E_WARNING | 784L )
#define ER_INVALID_TIMER                        ( INTERNAL_ERROR_ON | E_WARNING | 242L )
#define ER_INV_TASK_NUM                         ( INTERNAL_ERROR_ON | E_WARNING | 255L )
#define ER_IN_PROGRESS                          ( E_WARNING | 785L )
#define ER_IPIPE_NOT_FUNC                       ( INTERNAL_ERROR_ON | E_WARNING | 449L )
#define ER_ISC                                  ( INTERNAL_ERROR_ON | E_WARNING | 188L )
#define ER_KEY_TOKEN_NOT_FOUND                  ( E_WARNING | 786L )
#define ER_LAD                                  ( INTERNAL_ERROR_ON | E_WARNING | 235L )
#define ER_LDR_ABORT                            ( E_WARNING | 787L )
#define ER_LINENUMS_ALREADY_LOADED              ( INTERNAL_ERROR_ON | E_WARNING | 788L )
#define ER_LINENUMS_NOT_SORTED                  ( INTERNAL_ERROR_ON | E_WARNING | 789L )
#define ER_LINENUM_BAD_STATE                    ( E_WARNING | 790L )
#define ER_LINENUM_INDEX_TOO_LARGE              ( INTERNAL_ERROR_ON | E_WARNING | 791L )
#define ER_LINENUM_NOT_FOUND                    ( E_WARNING | 792L )
#define ER_LINE_EXPT                            ( E_WARNING | 793L )
#define ER_LINE_MISSING                         ( E_WARNING | 794L )
#define ER_LINE_NOT_ADDED                       ( INTERNAL_ERROR_ON | E_WARNING | 795L )
#define ER_LOADFILES_DONT_MATCH                 ( INTERNAL_ERROR_ON | E_WARNING | 796L )
#define ER_LOADFILE_HAD_INCOMPATIBLE_TOOLCHAIN  ( E_WARNING | 797L )
#define ER_LOAD_ABORT                           ( E_WARNING | 444L )
#define ER_LOAD_SEQUENCE                        ( INTERNAL_ERROR_ON | E_WARNING | 471L )
#define ER_LONG_DEFARG                          ( INTERNAL_ERROR_ON | E_WARNING | 798L )
#define ER_MAP_CANNOT_OPEN_FILE                 ( E_WARNING | 799L )
#define ER_MAP_INVALID_REGNAME                  ( E_WARNING | 800L )
#define ER_MAP_INVALID_VALUE_INPUT              ( E_WARNING | 801L )
#define ER_MAP_LIST_CORRUPT                     ( INTERNAL_ERROR_ON | E_WARNING | 457L )
#define ER_MAP_TOO_MANY_INPUT_LINES             ( E_WARNING | 802L )
#define ER_MAP_UNKNOWN_TYPE                     ( INTERNAL_ERROR_ON | E_WARNING | 803L )
#define ER_MAP_VALUE_MISSING                    ( E_WARNING | 804L )
#define ER_MAP_VALUE_TOO_BIG                    ( E_WARNING | 805L )
#define ER_MARKER_PEND_TIMEOUT                  ( INTERNAL_ERROR_ON | E_WARNING | 447L )
#define ER_MASK_VALUE_PROBLEM                   ( INTERNAL_ERROR_ON | E_WARNING | 806L )
#define ER_MAX_COUNTER_VALUE                    ( E_WARNING | 807L )
#define ER_MEM                                  ( INTERNAL_ERROR_ON | E_WARNING | 182L )
#define ER_MEMBER_NAME_NOT_FOUND                ( INTERNAL_ERROR_ON | E_WARNING | 263L )
#define ER_MEMORY_BUFF_LEN                      ( INTERNAL_ERROR_ON | E_WARNING | 422L )
#define ER_MEMORY_VERIFY                        ( E_WARNING | 306L )
#define ER_MEM_BUFF_LEN                         ( INTERNAL_ERROR_ON | E_SEVERE | 2L )
#define ER_MEM_COUNT_EXCEEDED                   ( E_WARNING | 808L )
#define ER_MEM_DATA_GREATER_THAN_BYTE           ( E_WARNING | 809L )
#define ER_MEM_DATA_GREATER_THAN_WORD           ( INTERNAL_ERROR_ON | E_WARNING | 810L )
#define ER_MEM_END_LESS_THAN_START              ( E_WARNING | 811L )
#define ER_MEM_FROM_TO                          ( E_WARNING | 812L )
#define ER_MEM_INVALID_DESCRIPTOR               ( INTERNAL_ERROR_ON | E_WARNING | 813L )
#define ER_MEM_INVALID_SRC_ID                   ( INTERNAL_ERROR_ON | E_WARNING | 814L )
#define ER_MEM_NON_NUM                          ( E_WARNING | 815L )
#define ER_MEM_NOT_IMPLEMENTED                  ( INTERNAL_ERROR_ON | E_WARNING | 816L )
#define ER_MEM_NO_FUNC                          ( INTERNAL_ERROR_ON | E_WARNING | 817L )
#define ER_MEM_PAT_LEN                          ( E_WARNING | 818L )
#define ER_MIN_COUNTER_VALUE                    ( E_WARNING | 819L )
#define ER_MISMATCHED_SHARED_DATA               ( E_SEVERE | 1L )
#define ER_MISSING_SECTION_NAME                 ( E_WARNING | 820L )
#define ER_MISSING_TOOLS_SUPPORT                ( E_WARNING | 821L )
#define ER_MIU                                  ( INTERNAL_ERROR_ON | E_WARNING | 184L )
#define ER_MODREF                               ( INTERNAL_ERROR_ON | E_WARNING | 822L )
#define ER_MODTIME                              ( E_WARNING | 823L )
#define ER_MODULE_ALREADY_OPEN                  ( INTERNAL_ERROR_ON | E_WARNING | 824L )
#define ER_MODULE_NOT_FOUND                     ( E_WARNING | 825L )
#define ER_MULTI_BUFS_NEEDED                    ( E_WARNING | 826L )
#define ER_MUST_DEFINE_TOOLUSE                  ( E_WARNING | 827L )
#define ER_NAME_NOT_ADDED                       ( E_WARNING | 828L )
#define ER_NAME_TOO_LONG                        ( E_WARNING | 829L )
#define ER_NCP                                  ( INTERNAL_ERROR_ON | E_WARNING | 195L )
#define ER_NET_CLOSE                            ( E_SEVERE | 830L )
#define ER_NET_COMM_ENDPOINT                    ( INTERNAL_ERROR_ON | E_FATAL | 831L )
#define ER_NET_CONNECT                          ( E_WARNING | 832L )
#define ER_NET_CONNECT_TIMEOUT                  ( E_WARNING | 833L )
#define ER_NET_EMULATOR_INFO                    ( INTERNAL_ERROR_ON | E_FATAL | 834L )
#define ER_NET_EMULATOR_IN_USE                  ( E_SEVERE | 835L )
#define ER_NET_HOST_INFO                        ( E_WARNING | 836L )
#define ER_NET_HOST_NAMES_NOT_FOUND             ( E_FATAL | 837L )
#define ER_NET_HOST_SELECT_DIALOG               ( INTERNAL_ERROR_ON | E_FATAL | 838L )
#define ER_NET_INCOMPATIBLE_VERSION             ( E_SEVERE | 839L )
#define ER_NET_NOT_NETWORK                      ( E_FATAL | 840L )
#define ER_NET_PROFILE_MISSING                  ( E_FATAL | 841L )
#define ER_NET_READ                             ( E_SEVERE | 842L )
#define ER_NET_READ_TIMEOUT                     ( E_SEVERE | 843L )
#define ER_NET_WRITE                            ( E_SEVERE | 844L )
#define ER_NMB                                  ( INTERNAL_ERROR_ON | E_WARNING | 183L )
#define ER_NMP                                  ( INTERNAL_ERROR_ON | E_WARNING | 190L )
#define ER_NOCB                                 ( INTERNAL_ERROR_ON | E_WARNING | 227L )
#define ER_NOCODE                               ( INTERNAL_ERROR_ON | E_WARNING | 845L )
#define ER_NOP                                  ( INTERNAL_ERROR_ON | E_WARNING | 236L )
#define ER_NOPEN                                ( INTERNAL_ERROR_ON | E_WARNING | 846L )
#define ER_NOQ                                  ( INTERNAL_ERROR_ON | E_WARNING | 423L )
#define ER_NOREG_UPDATE                         ( E_WARNING | 847L )
#define ER_NORUNACCESS                          ( E_WARNING | 848L )
#define ER_NOTYET_IMPL                          ( INTERNAL_ERROR_ON | E_WARNING | 849L )
#define ER_NOT_A_VARIABLE                       ( INTERNAL_ERROR_ON | E_WARNING | 850L )
#define ER_NOT_CPU                              ( E_WARNING | 851L )
#define ER_NOT_ENOUGH_STORAGE                   ( INTERNAL_ERROR_ON | E_WARNING | 852L )
#define ER_NOT_FOUND                            ( INTERNAL_ERROR_ON | 853L )
#define ER_NOT_IMPLEMENTED                      ( INTERNAL_ERROR_ON | E_WARNING | 854L )
#define ER_NOT_IN_POWERSCOPE                    ( E_WARNING | 855L )
#define ER_NOT_MEM_CONF                         ( E_WARNING | 856L )
#define ER_NOT_NOT_ALLOWED                      ( E_WARNING | 857L )
#define ER_NOT_SUPPORTED                        ( INTERNAL_ERROR_ON | E_WARNING | 266L )
#define ER_NO_ACTIVE_EVENT                      ( E_WARNING | 858L )
#define ER_NO_ACTIVE_FIELD                      ( INTERNAL_ERROR_ON | E_WARNING | 859L )
#define ER_NO_ACTIVE_TEMPLATE                   ( INTERNAL_ERROR_ON | E_WARNING | 860L )
#define ER_NO_CLOCK                             ( E_WARNING | 462L )
#define ER_NO_CONFIG                            ( E_WARNING | 241L )
#define ER_NO_CPU_CONFIG_FILE                   ( E_FATAL | 861L )
#define ER_NO_DATA_AVAIL                        ( INTERNAL_ERROR_ON | E_WARNING | 253L )
#define ER_NO_EVFILE_ENTRY                      ( E_WARNING | 862L )
#define ER_NO_FILE_GIVEN                        ( E_WARNING | 863L )
#define ER_NO_FLASH_PROM                        ( INTERNAL_ERROR_ON | E_WARNING | 284L )
#define ER_NO_FREE_MAP_BLOCKS                   ( E_WARNING | 864L )
#define ER_NO_LIBS                              ( INTERNAL_ERROR_ON | E_SEVERE | 865L )
#define ER_NO_LIFETIME_INFO                     ( INTERNAL_ERROR_ON | E_WARNING | 866L )
#define ER_NO_LINEBLK_IN_MODULE                 ( E_WARNING | 867L )
#define ER_NO_LINENUMS_ADDED                    ( E_WARNING | 868L )
#define ER_NO_MASK_SUPPORTED                    ( INTERNAL_ERROR_ON | E_WARNING | 869L )
#define ER_NO_MATCH                             ( INTERNAL_ERROR_ON | 870L )
#define ER_NO_MATCHING_VAR                      ( INTERNAL_ERROR_ON | E_WARNING | 871L )
#define ER_NO_MDESC                             ( INTERNAL_ERROR_ON | E_WARNING | 872L )
#define ER_NO_MEM                               ( INTERNAL_ERROR_ON | E_WARNING | 251L )
#define ER_NO_MEMORY                            ( E_WARNING | 873L )
#define ER_NO_MEMORY_PRESENT                    ( E_WARNING | 874L )
#define ER_NO_MEM_FOR_INPUT_DATA                ( INTERNAL_ERROR_ON | E_WARNING | 260L )
#define ER_NO_MORE_PG_DIR                       ( INTERNAL_ERROR_ON | E_WARNING | 233L )
#define ER_NO_MORE_SELECTORS                    ( INTERNAL_ERROR_ON | E_WARNING | 258L )
#define ER_NO_PC                                ( E_WARNING | 875L )
#define ER_NO_PREV_TBL_ENTRY                    ( INTERNAL_ERROR_ON | E_WARNING | 234L )
#define ER_NO_SECTION_NAME_DEFINED              ( E_WARNING | 876L )
#define ER_NO_SEMAPHORES_AVAILABLE              ( INTERNAL_ERROR_ON | E_WARNING | 264L )
#define ER_NO_STACK_LIMIT                       ( INTERNAL_ERROR_ON | E_WARNING | 877L )
#define ER_NO_STROBE                            ( E_WARNING | 313L )
#define ER_NO_SUCH_EVENT                        ( E_WARNING | 878L )
#define ER_NO_SYMBOLIC_INFO                     ( E_WARNING | 879L )
#define ER_NO_TASK                              ( INTERNAL_ERROR_ON | E_WARNING | 257L )
#define ER_NO_TASKS                             ( INTERNAL_ERROR_ON | E_WARNING | 25L )
#define ER_NO_TEMPLATE_FILE_GIVEN               ( INTERNAL_ERROR_ON | E_WARNING | 880L )
#define ER_NO_TIMER                             ( INTERNAL_ERROR_ON | E_SEVERE | 6L )
#define ER_NO_TIMER_AVAIL                       ( INTERNAL_ERROR_ON | E_WARNING | 881L )
#define ER_NO_TOOLS_SUPPORT_DEFINED             ( E_WARNING | 882L )
#define ER_NO_TOOLUSE_DEFINED                   ( E_WARNING | 883L )
#define ER_NO_TRACE_FRAME                       ( E_INFORMATIVE | 884L )
#define ER_NO_TRACE_OPEN                        ( INTERNAL_ERROR_ON | E_WARNING | 885L )
#define ER_NO_TRIG_DEFINED                      ( E_WARNING | 886L )
#define ER_NO_VALID_ADDRESS                     ( INTERNAL_ERROR_ON | E_WARNING | 887L )
#define ER_NULL_FUNCTION                        ( INTERNAL_ERROR_ON | E_WARNING | 243L )
#define ER_NUM_BASE_MISMATCH                    ( E_WARNING | 888L )
#define ER_ONLY_FOR_RANGES                      ( INTERNAL_ERROR_ON | E_WARNING | 889L )
#define ER_ONLY_HW_SUPPORT                      ( INTERNAL_ERROR_ON | E_WARNING | 890L )
#define ER_OPC                                  ( INTERNAL_ERROR_ON | E_WARNING | 213L )
#define ER_OPEN                                 ( E_WARNING | 891L )
#define ER_OPTIMIZED                            ( E_WARNING | 892L )
#define ER_OS2_LAN_SERVER_NOT_RUNNING           ( E_FATAL | 893L )
#define ER_OUT_OF_MEMORY                        ( INTERNAL_ERROR_ON | 894L )
#define ER_OUT_OF_RANGE                         ( INTERNAL_ERROR_ON | E_SEVERE | 3L )
#define ER_OVERLAY_HARDWARE                     ( E_WARNING | 297L )
#define ER_OVERRUN                              ( INTERNAL_ERROR_ON | E_WARNING | 290L )
#define ER_OVF                                  ( INTERNAL_ERROR_ON | E_WARNING | 231L )
#define ER_PACKET_BASE                          ( INTERNAL_ERROR_ON | E_WARNING | 296L )
#define ER_PACKET_FORMAT                        ( INTERNAL_ERROR_ON | E_WARNING | 288L )
#define ER_PARITY                               ( INTERNAL_ERROR_ON | E_WARNING | 291L )
#define ER_PATTERN_MISSING                      ( E_WARNING | 895L )
#define ER_PCALL_RECURSE                        ( INTERNAL_ERROR_ON | 896L )
#define ER_PCNFS_NOT_RUNNING                    ( E_FATAL | 897L )
#define ER_PCNFS_RNM_NOT_FOUND                  ( E_FATAL | 898L )
#define ER_PCNFS_RTM_NOT_RESIDENT               ( E_FATAL | 899L )
#define ER_PCNFS_TKDLL_NOT_FOUND                ( E_FATAL | 900L )
#define ER_PID                                  ( INTERNAL_ERROR_ON | E_WARNING | 193L )
#define ER_PND                                  ( INTERNAL_ERROR_ON | E_WARNING | 229L )
#define ER_POD_VERSION                          ( E_WARNING | 450L )
#define ER_PP_CFG_FILE_NOT_FOUND                ( INTERNAL_ERROR_ON | E_SEVERE | 901L )
#define ER_PP_CLOSE_CFG_FAIL                    ( INTERNAL_ERROR_ON | E_SEVERE | 902L )
#define ER_PP_CORRUPT_CFG_FILE                  ( INTERNAL_ERROR_ON | E_SEVERE | 903L )
#define ER_PP_INVALID_BASE                      ( E_SEVERE | 904L )
#define ER_PP_INVALID_VALUE                     ( INTERNAL_ERROR_ON | E_SEVERE | 905L )
#define ER_PP_OLD_VERSION                       ( E_SEVERE | 906L )
#define ER_PP_OPEN_CFG_FAIL                     ( E_SEVERE | 907L )
#define ER_PP_READING_FIELD                     ( INTERNAL_ERROR_ON | E_SEVERE | 908L )
#define ER_PP_READING_GROUP                     ( INTERNAL_ERROR_ON | E_SEVERE | 909L )
#define ER_PP_READING_REG                       ( INTERNAL_ERROR_ON | E_SEVERE | 910L )
#define ER_PP_UNEXPECTED_END_CFG                ( INTERNAL_ERROR_ON | E_SEVERE | 911L )
#define ER_PP_WIN_CREATE_FAIL                   ( INTERNAL_ERROR_ON | E_SEVERE | 912L )
#define ER_PRC_OPER_INCOMPAT                    ( INTERNAL_ERROR_ON | E_SEVERE | 913L )
#define ER_PROBE_FW_VERSION                     ( E_WARNING | 446L )
#define ER_PROBE_TIMEOUT                        ( INTERNAL_ERROR_ON | E_WARNING | 293L )
#define ER_PROBE_VERSION_NO_RETRY               ( E_SEVERE | 19L )
#define ER_PROBE_VERSION_NO_XBRKS               ( E_SEVERE | 18L )
#define ER_PROC_TYPE_UNKNOWN                    ( INTERNAL_ERROR_ON | E_WARNING | 440L )
#define ER_PROFILE_WRITE                        ( INTERNAL_ERROR_ON | 914L )
#define ER_PUBLIC_IGNORED                       ( INTERNAL_ERROR_ON | E_WARNING | 915L )
#define ER_QFL                                  ( INTERNAL_ERROR_ON | E_WARNING | 192L )
#define ER_QID                                  ( INTERNAL_ERROR_ON | E_WARNING | 191L )
#define ER_RCV_CHECKSUM                         ( INTERNAL_ERROR_ON | E_WARNING | 289L )
#define ER_RDWR_SIZE_EXCEEDED                   ( INTERNAL_ERROR_ON | E_WARNING | 285L )
#define ER_READING_FILE                         ( E_WARNING | 916L )
#define ER_READ_ABORT                           ( E_WARNING | 466L )
#define ER_REC_NOT_HANDLED                      ( INTERNAL_ERROR_ON | E_WARNING | 917L )
#define ER_REGISTER_CLASS_UNKNOWN               ( INTERNAL_ERROR_ON | E_WARNING | 918L )
#define ER_REGNAME_NOT_FOUND                    ( INTERNAL_ERROR_ON | E_WARNING | 919L )
#define ER_REGTABLE                             ( E_WARNING | 920L )
#define ER_REG_OUT_OF_RANGE                     ( E_WARNING | 921L )
#define ER_REMOVE_LIST                          ( INTERNAL_ERROR_ON | E_WARNING | 252L )
#define ER_RESET_DCB_STATE                      ( INTERNAL_ERROR_ON | E_WARNING | 922L )
#define ER_RESET_DURING_BDM                     ( E_WARNING | 304L )
#define ER_RESET_OCCURRED                       ( E_WARNING | 463L )
#define ER_RESET_STUCK                          ( E_WARNING | 923L )
#define ER_RESET_UNIT_FAILED                    ( INTERNAL_ERROR_ON | E_WARNING | 245L )
#define ER_RESLOAD                              ( INTERNAL_ERROR_ON | 924L )
#define ER_SAVECS_MBAR_INVALID                  ( E_WARNING | 925L )
#define ER_SCROLL_NEEDS_MEM                     ( E_WARNING | 926L )
#define ER_SDS_LOGFILE_OPEN                     ( INTERNAL_ERROR_ON | E_SEVERE | 22L )
#define ER_SDS_TIMEOUT                          ( INTERNAL_ERROR_ON | 927L )
#define ER_SD_CLOSE                             ( INTERNAL_ERROR_ON | E_SEVERE | 5L )
#define ER_SD_INDEX                             ( INTERNAL_ERROR_ON | E_SEVERE | 8L )
#define ER_SD_PARTIALMBR                        ( INTERNAL_ERROR_ON | E_WARNING | 12L )
#define ER_SD_WRITE                             ( INTERNAL_ERROR_ON | E_SEVERE | 11L )
#define ER_SEARCH_ABORT                         ( E_WARNING | 443L )
#define ER_SEARCH_FOUND                         ( E_INFORMATIVE | 928L )
#define ER_SEARCH_NOT_FOUND                     ( E_INFORMATIVE | 929L )
#define ER_SECTION_NOT_FOUND                    ( INTERNAL_ERROR_ON | E_WARNING | 930L )
#define ER_SEG_LIMIT                            ( INTERNAL_ERROR_ON | E_WARNING | 265L )
#define ER_SEND_MESSAGE_FAILED                  ( INTERNAL_ERROR_ON | 931L )
#define ER_SHARED_DATA_LIMIT_EXCEEDED           ( INTERNAL_ERROR_ON | E_WARNING | 262L )
#define ER_SIGNAL_NOT_FOUND                     ( INTERNAL_ERROR_ON | E_WARNING | 932L )
#define ER_SIG_NOT_AVAIL_IN_POWERSCOPE          ( E_WARNING | 933L )
#define ER_SIM_UNREADABLE                       ( E_WARNING | 430L )
#define ER_SINGLE_TRACE_BUFFER                  ( E_WARNING | 934L )
#define ER_SKIP_MODULE                          ( INTERNAL_ERROR_ON | E_WARNING | 935L )
#define ER_SLOW_CLOCK                           ( E_WARNING | 305L )
#define ER_SOURCE_END                           ( INTERNAL_ERROR_ON | E_WARNING | 936L )
#define ER_SOURCE_NEWER                         ( E_WARNING | 937L )
#define ER_SRC_CANT_FIND                        ( E_WARNING | 938L )
#define ER_SRC_CANT_OPEN_DATA                   ( INTERNAL_ERROR_ON | E_WARNING | 939L )
#define ER_SRC_CURSOR_MAP                       ( INTERNAL_ERROR_ON | E_WARNING | 940L )
#define ER_SRC_END_OF_HISTORY                   ( E_WARNING | 941L )
#define ER_SRC_EVENT_REG                        ( INTERNAL_ERROR_ON | E_FATAL | 942L )
#define ER_SRC_FIND_ADDRESS                     ( E_FATAL | 943L )
#define ER_SRC_FUNC_START_INFO                  ( E_INFORMATIVE | 944L )
#define ER_SRC_HISTORY_DEPTH                    ( E_WARNING | 945L )
#define ER_SRC_INVALID_ADDRESS                  ( E_WARNING | 946L )
#define ER_SRC_INVALID_INPUT_TAB                ( E_WARNING | 947L )
#define ER_SRC_INVALID_LINE                     ( E_WARNING | 948L )
#define ER_SRC_MEM_NEEDED                       ( E_WARNING | 949L )
#define ER_SRC_MODULE_HAS_NO_ADDR_RANGE         ( E_WARNING | 950L )
#define ER_SRC_NO_LOADFILE                      ( E_WARNING | 951L )
#define ER_SRC_NO_PATHS                         ( INTERNAL_ERROR_ON | E_WARNING | 952L )
#define ER_SRC_NO_VAR_SEL                       ( INTERNAL_ERROR_ON | E_WARNING | 953L )
#define ER_SRC_OPEN_FAIL                        ( E_WARNING | 954L )
#define ER_SRC_REOPEN_FAIL                      ( E_WARNING | 955L )
#define ER_SRC_START_OF_HISTORY                 ( E_WARNING | 956L )
#define ER_SRC_STEP_COUNT                       ( E_WARNING | 957L )
#define ER_SRC_TAB_RANGE                        ( E_WARNING | 958L )
#define ER_SRC_VIEW_ALREADY                     ( E_WARNING | 959L )
#define ER_STACK_ALARM_LIM                      ( E_INFORMATIVE | 960L )
#define ER_STACK_ALARM_RANGE                    ( E_WARNING | 961L )
#define ER_STACK_CRE                            ( INTERNAL_ERROR_ON | E_SEVERE | 962L )
#define ER_STACK_HW_DISABLED                    ( E_WARNING | 963L )
#define ER_STACK_INVALID_SIZE                   ( E_WARNING | 964L )
#define ER_STACK_NO_CHILD                       ( INTERNAL_ERROR_ON | E_SEVERE | 965L )
#define ER_STACK_NO_POINTER                     ( INTERNAL_ERROR_ON | E_SEVERE | 966L )
#define ER_STACK_NO_SESSION                     ( E_SEVERE | 967L )
#define ER_STACK_NO_VAR                         ( INTERNAL_ERROR_ON | E_WARNING | 968L )
#define ER_STACK_OVERFLOW                       ( E_INFORMATIVE | 969L )
#define ER_STACK_SIZE_0                         ( E_FATAL | 970L )
#define ER_STACK_SIZE_MISSING                   ( E_WARNING | 971L )
#define ER_STACK_TOO_LARGE                      ( E_WARNING | 972L )
#define ER_STACK_UNDERFLOW                      ( E_INFORMATIVE | 973L )
#define ER_STEP_TIMEOUT                         ( E_WARNING | 311L )
#define ER_STK_CLI_REG_FAILED                   ( INTERNAL_ERROR_ON | E_WARNING | 974L )
#define ER_STK_FILL_STACK_AREA                  ( E_WARNING | 975L )
#define ER_STK_FRAME_INVALID                    ( INTERNAL_ERROR_ON | E_WARNING | 976L )
#define ER_STK_FRAME_NOT_OPENED                 ( INTERNAL_ERROR_ON | E_WARNING | 977L )
#define ER_STK_FRAME_RELEASE_FAILED             ( INTERNAL_ERROR_ON | E_WARNING | 978L )
#define ER_STK_INIT_STK_FAIL                    ( E_WARNING | 979L )
#define ER_STK_INVALID_ALARM_LIMIT              ( E_WARNING | 980L )
#define ER_STK_INVALID_DESCRIPTOR               ( INTERNAL_ERROR_ON | E_WARNING | 981L )
#define ER_STK_INVALID_HWM                      ( E_WARNING | 982L )
#define ER_STK_INVALID_STK_SIZE                 ( E_WARNING | 983L )
#define ER_STK_NO_FRAMES                        ( E_WARNING | 984L )
#define ER_STK_RANGE_TOO_LARGE                  ( E_WARNING | 985L )
#define ER_STK_RANGE_TOO_SMALL                  ( E_WARNING | 986L )
#define ER_STK_SEND_MESSAGE_FAILED              ( INTERNAL_ERROR_ON | E_WARNING | 987L )
#define ER_STK_SESSION_NAME_NOT_FOUND           ( E_WARNING | 988L )
#define ER_STK_STK_BASE_INVALID                 ( E_WARNING | 989L )
#define ER_STORAGE_CLASS_UNKNOWN                ( INTERNAL_ERROR_ON | E_WARNING | 990L )
#define ER_STRESSED_OUT_SRVR                    ( INTERNAL_ERROR_ON | E_WARNING | 991L )
#define ER_STRING_LENGTH_ZERO                   ( INTERNAL_ERROR_ON | E_WARNING | 992L )
#define ER_SWAT_ABORT                           ( E_WARNING | 272L )
#define ER_SWAT_PA_OVERFLOW                     ( E_WARNING | 271L )
#define ER_SWAT_TIMEOUT                         ( E_WARNING | 270L )
#define ER_SWAT_WRONG_MODE                      ( INTERNAL_ERROR_ON | E_WARNING | 269L )
#define ER_SYMBASE                              ( E_FATAL | 993L )
#define ER_SYMBOLS_LOADED                       ( E_WARNING | 994L )
#define ER_SYMBOL_HAS_NO_CHILD                  ( INTERNAL_ERROR_ON | E_WARNING | 995L )
#define ER_SYMBOL_HAS_NO_LISTS                  ( INTERNAL_ERROR_ON | E_WARNING | 996L )
#define ER_SYMBOL_NOT_A_FUNCTION                ( INTERNAL_ERROR_ON | E_WARNING | 997L )
#define ER_SYMBOL_NOT_A_LABEL                   ( INTERNAL_ERROR_ON | E_WARNING | 998L )
#define ER_SYMBOL_NOT_A_MODULE                  ( E_WARNING | 999L )
#define ER_SYMBOL_NOT_FOUND                     ( E_WARNING | 1000L )
#define ER_SYMBOL_STACK_EMPTY                   ( INTERNAL_ERROR_ON | E_WARNING | 1001L )
#define ER_SYM_ALREADY                          ( E_WARNING | 1002L )
#define ER_SYM_ALREADY_CLI                      ( E_WARNING | 1003L )
#define ER_SYM_INVALID_CHAR                     ( INTERNAL_ERROR_ON | E_WARNING | 1004L )
#define ER_SYM_INVALID_LN_END_ADDR              ( E_WARNING | 1005L )
#define ER_SYM_LOCAL_VAR_ADDRESS                ( E_WARNING | 1006L )
#define ER_SYM_LOOP_COMPLETE                    ( INTERNAL_ERROR_ON | E_WARNING | 1007L )
#define ER_SYM_NOT_CODE_ADDRESS                 ( INTERNAL_ERROR_ON | E_WARNING | 1008L )
#define ER_SYM_NOT_DATA_ADDRESS                 ( INTERNAL_ERROR_ON | E_WARNING | 1009L )
#define ER_SYM_NOT_UPDATED                      ( INTERNAL_ERROR_ON | E_WARNING | 1010L )
#define ER_SYM_NO_CURRENT_CONTEXT               ( E_WARNING | 1011L )
#define ER_SYM_NO_FUNCTION_MATCH                ( INTERNAL_ERROR_ON | E_WARNING | 1012L )
#define ER_SYM_NO_MODULES_LOADED                ( 1013L )
#define ER_SYM_OUT_OF_MEMORY                    ( E_FATAL | 1014L )
#define ER_SYM_REG_VAR_NOT_ALLOWED              ( INTERNAL_ERROR_ON | E_WARNING | 1015L )
#define ER_SYM_SEND_MESSAGE                     ( INTERNAL_ERROR_ON | E_WARNING | 1016L )
#define ER_SYM_STACK_FULL                       ( INTERNAL_ERROR_ON | E_WARNING | 1017L )
#define ER_SYM_SYMBOL_NOT_IN_MODULE             ( INTERNAL_ERROR_ON | E_WARNING | 1018L )
#define ER_SYM_SYM_START_NOT_SHARP              ( E_WARNING | 1019L )
#define ER_SYM_TYPE                             ( E_WARNING | 1020L )
#define ER_TABLE_SMALLER_THAN_INDEX             ( E_WARNING | 1021L )
#define ER_TARGET_CONNECT                       ( E_WARNING | 458L )
#define ER_TARGET_FLT                           ( E_WARNING | 459L )
#define ER_TARGET_VCC                           ( E_WARNING | 460L )
#define ER_TASK_DONE                            ( INTERNAL_ERROR_ON | E_WARNING | 250L )
#define ER_TASK_NOT_IN_TABLE                    ( INTERNAL_ERROR_ON | E_SEVERE | 24L )
#define ER_TASK_TABLE_FULL                      ( INTERNAL_ERROR_ON | E_SEVERE | 26L )
#define ER_TCB                                  ( INTERNAL_ERROR_ON | E_WARNING | 181L )
#define ER_TEMPLATE_NAME_TOO_LONG               ( INTERNAL_ERROR_ON | E_WARNING | 1022L )
#define ER_TEST_ABORT                           ( E_WARNING | 467L )
#define ER_TID                                  ( INTERNAL_ERROR_ON | E_WARNING | 180L )
#define ER_TIMED_OUT                            ( E_SEVERE | 4L )
#define ER_TIMER_NOT_AVAIL                      ( INTERNAL_ERROR_ON | E_WARNING | 244L )
#define ER_TIMESTAMPS_DONT_MATCH                ( E_WARNING | 1023L )
#define ER_TMO                                  ( INTERNAL_ERROR_ON | E_WARNING | 189L )
#define ER_TOOL_NAME_TOO_LONG                   ( E_WARNING | 1024L )
#define ER_TOOMANY_SEC                          ( E_WARNING | 1025L )
#define ER_TOO_MANY_EVENTS                      ( E_WARNING | 1026L )
#define ER_TOO_MANY_FIELDS                      ( E_WARNING | 1027L )
#define ER_TOO_MANY_FRAMES                      ( INTERNAL_ERROR_ON | E_WARNING | 438L )
#define ER_TOO_MANY_PAIRS                       ( INTERNAL_ERROR_ON | E_WARNING | 1028L )
#define ER_TOO_MANY_SYMBOLS                     ( INTERNAL_ERROR_ON | E_WARNING | 1029L )
#define ER_TOO_MANY_TEMPLATES                   ( INTERNAL_ERROR_ON | E_WARNING | 1030L )
#define ER_TOO_MANY_XBRKS                       ( E_WARNING | 308L )
#define ER_TRACE_DATA                           ( E_WARNING | 1031L )
#define ER_TRACE_DISABLE_CURS                   ( E_WARNING | 1032L )
#define ER_TRACE_TRIG_ON                        ( E_WARNING | 1033L )
#define ER_TRACING_ON                           ( E_WARNING | 1034L )
#define ER_TRIGGER_ABORTED                      ( E_WARNING | 436L )
#define ER_TRIGGER_USING_EVENT                  ( E_WARNING | 1035L )
#define ER_TYPE_IDXS_DONT_MATCH                 ( INTERNAL_ERROR_ON | E_WARNING | 1036L )
#define ER_TYPE_TOO_LARGE                       ( INTERNAL_ERROR_ON | E_WARNING | 1037L )
#define ER_UART_INTERNAL                        ( INTERNAL_ERROR_ON | E_WARNING | 294L )
#define ER_UNEXPECTED_END                       ( E_WARNING | 1038L )
#define ER_UNEXPECTED_TYPE                      ( 1039L )
#define ER_UNK                                  ( INTERNAL_ERROR_ON | E_WARNING | 240L )
#define ER_UNKNOWN                              ( INTERNAL_ERROR_ON | E_WARNING | 1040L )
#define ER_UNKNOWN_EVENT                        ( INTERNAL_ERROR_ON | E_SEVERE | 1041L )
#define ER_UNKNOWN_FWREF_TYPE                   ( INTERNAL_ERROR_ON | E_SEVERE | 1042L )
#define ER_UNKNOWN_LIST_TYPE                    ( INTERNAL_ERROR_ON | E_WARNING | 1043L )
#define ER_UNKNOWN_LOAD_COMMAND                 ( INTERNAL_ERROR_ON | E_WARNING | 445L )
#define ER_UNKNOWN_TEST_CMD                     ( E_WARNING | 468L )
#define ER_UNKNOWN_XILINX                       ( INTERNAL_ERROR_ON | E_WARNING | 268L )
#define ER_UNRECOGNIZED_BLK                     ( INTERNAL_ERROR_ON | E_WARNING | 1044L )
#define ER_UNRECOGNIZED_SEC                     ( INTERNAL_ERROR_ON | E_WARNING | 1045L )
#define ER_UNRECOG_LFILE                        ( INTERNAL_ERROR_ON | E_WARNING | 1046L )
#define ER_UPD                                  ( INTERNAL_ERROR_ON | E_WARNING | 237L )
#define ER_UPDATE_BLOCK_FAIL                    ( INTERNAL_ERROR_ON | E_WARNING | 1047L )
#define ER_USER_ABORT                           ( E_WARNING | 1048L )
#define ER_USE_SET_START                        ( INTERNAL_ERROR_ON | E_WARNING | 1049L )
#define ER_VAR_CANT_FIND_FUN                    ( E_WARNING | 1050L )
#define ER_VAR_CANT_FIND_MOD                    ( E_WARNING | 1051L )
#define ER_VAR_CANT_FIND_VAR                    ( E_WARNING | 1052L )
#define ER_VAR_CANT_OPEN_SESSION                ( INTERNAL_ERROR_ON | E_WARNING | 1053L )
#define ER_VAR_END_PROB                         ( E_WARNING | 1054L )
#define ER_VAR_HIGHLIGHT                        ( E_WARNING | 1055L )
#define ER_VAR_IS_AT_ADDR                       ( E_INFORMATIVE | 1056L )
#define ER_VAR_NO_DEL_SEL                       ( E_WARNING | 1057L )
#define ER_VAR_NO_UNDO                          ( E_WARNING | 1058L )
#define ER_VAR_NO_VIEWS                         ( INTERNAL_ERROR_ON | E_WARNING | 1059L )
#define ER_VAR_UNKNOWN_ADDR                     ( INTERNAL_ERROR_ON | E_WARNING | 1060L )
#define ER_VAR_UNKNOWN_SORT_TYPE                ( INTERNAL_ERROR_ON | E_WARNING | 1061L )
#define ER_VPROF_NOT_INSTALLED                  ( INTERNAL_ERROR_ON | E_SEVERE | 23L )
#define ER_VRTX_INIT                            ( INTERNAL_ERROR_ON | E_WARNING | 246L )
#define ER_VS_ACCESS_DENIED                     ( INTERNAL_ERROR_ON | E_WARNING | 1062L )
#define ER_VS_ADDRESS_ACCESS_FAILED             ( INTERNAL_ERROR_ON | E_WARNING | 1063L )
#define ER_VS_ANONYMOUS_CLIENT_ACTIVE           ( INTERNAL_ERROR_ON | E_WARNING | 1064L )
#define ER_VS_ARRAY_MAPADDR_FAIL                ( INTERNAL_ERROR_ON | E_WARNING | 1065L )
#define ER_VS_BUFNUM_INVALID                    ( INTERNAL_ERROR_ON | E_WARNING | 1066L )
#define ER_VS_CLIENT_DISCREP                    ( INTERNAL_ERROR_ON | E_WARNING | 1067L )
#define ER_VS_CLI_REG_FAILED                    ( INTERNAL_ERROR_ON | E_SEVERE | 1068L )
#define ER_VS_CLI_VAR_NOT_FOUND                 ( E_WARNING | 1069L )
#define ER_VS_CPU_ACCESS_FAILED                 ( INTERNAL_ERROR_ON | E_WARNING | 1070L )
#define ER_VS_DOUBLE_EDIT_FAIL                  ( INTERNAL_ERROR_ON | E_WARNING | 1071L )
#define ER_VS_EVENT_ACCESS_FAILED               ( INTERNAL_ERROR_ON | E_WARNING | 1072L )
#define ER_VS_FUNCNAME_NOT_FOUND                ( E_WARNING | 1073L )
#define ER_VS_INVALID_EDITFIELDCHAROFFSET       ( INTERNAL_ERROR_ON | E_WARNING | 1074L )
#define ER_VS_LINENUM_INVALID                   ( INTERNAL_ERROR_ON | E_WARNING | 1075L )
#define ER_VS_LONG_OVERFLOW                     ( E_WARNING | 1076L )
#define ER_VS_MEMORY_ACCESS_FAILED              ( INTERNAL_ERROR_ON | E_WARNING | 1077L )
#define ER_VS_MODULENAME_NOT_FOUND              ( E_WARNING | 1078L )
#define ER_VS_NAME_NOT_VARIABLE                 ( INTERNAL_ERROR_ON | E_WARNING | 1079L )
#define ER_VS_NO_SPACE_TABLE                    ( INTERNAL_ERROR_ON | E_WARNING | 1080L )
#define ER_VS_RANGE                             ( E_FATAL | 1081L )
#define ER_VS_SEND_MESSAGE_FAILED               ( INTERNAL_ERROR_ON | E_WARNING | 1082L )
#define ER_VS_SHORT_OVERFLOW                    ( E_WARNING | 1083L )
#define ER_VS_STACK_ACCESS_FAILED               ( INTERNAL_ERROR_ON | E_WARNING | 1084L )
#define ER_VS_SYMBOL_ACCESS_FAILED              ( INTERNAL_ERROR_ON | E_WARNING | 1085L )
#define ER_VS_SYSTEM_ACCESS_FAILED              ( INTERNAL_ERROR_ON | E_WARNING | 1086L )
#define ER_VS_ULONG_OVERFLOW                    ( E_WARNING | 1087L )
#define ER_VS_USHORT_OVERFLOW                   ( E_WARNING | 1088L )
#define ER_VS_VALU_EDIT_FAIL                    ( E_WARNING | 1089L )
#define ER_VS_VARNAME_NOT_FOUND                 ( E_WARNING | 1090L )
#define ER_VS_VAR_NOT_FOUND                     ( E_WARNING | 1091L )
#define ER_WAIT_BDM_TIMEOUT                     ( E_WARNING | 421L )
#define ER_WAIT_EMOFF_TIMEOUT                   ( E_WARNING | 310L )
#define ER_WAIT_EMON_TIMEOUT                    ( E_WARNING | 470L )
#define ER_WINDOWS_MEMLOCK                      ( INTERNAL_ERROR_ON | 1092L )
#define ER_WRITING_FILE                         ( E_WARNING | 1093L )
#define ER_WTC                                  ( INTERNAL_ERROR_ON | E_WARNING | 187L )
#define ER_XILINX_BITS_OVERFLOW                 ( INTERNAL_ERROR_ON | E_WARNING | 1094L )
#define ER_XILINX_PROGRAMMING                   ( E_WARNING | 267L )
#define ER_ZMW                                  ( INTERNAL_ERROR_ON | E_WARNING | 185L )
