/****************************************************************************
**
**  Name:  bkptexec.h
**
**  Description:
**     Breakpoint and Execution Control Server
**
**     This server handles source and assembly level control of emulation
**     and breakpoints.
**
**     NOT IMPLEMENTED YET:  given address or symbolic range, return next
**        breakpoint in range.
**
**  Status:  PRELIMINARY
**
**  $Log:   S:/tbird/arcmmcf/inc/bkptexec.h_v  $
** 
**    Rev 1.0   03 Jun 1996 11:24:26   gene
** Initial revision.
** 
**    Rev 1.1   01 Dec 1995 09:58:18   kevin
** joyce's modification
** 
**    Rev 1.0   07 Sep 1995 10:25:44   gene
** Initial revision.
** 
**    Rev 1.30   06 Apr 1994 16:29:06   nghia
** Revised BxSetSrcBkpt() to require the caller supplying the breakpoint address
** descriptor. Using the default address descriptor (by calling CreateAddress())
** will not guarantee that the breakpoint is set into the correct address space.
** 
**    Rev 1.29   07 Oct 1993 12:32:50   ernie
** Added step mask prototypes
** 
**    Rev 1.28   28 Jun 1993 07:22:14   doug
** centralizing error messages in errtext/mkerrors.h
** 
**    Rev 1.27   12 May 1993 09:54:38   nghia
** Added ER_BX_NO_BKPT_MATCH_ADDR to error list.
** 
**    Rev 1.26   10 May 1993 17:00:26   nghia
** Added ER_BX_ALREADY_HAS_BKPT to bkptexec server.
** 
**    Rev 1.25   08 Dec 1992 06:42:22   brucea
** Changed: BxAnyBkptsSet to BxGetBkptCount along with the return parameter value
** 
**    Rev 1.24   03 Dec 1992 07:56:44   brucea
** Cosmetic changes
** Removed: #if 0 bracketed headers (BxShowBkptPopup, BxGetIdOfLastBreakpoint)
** Added: BxAnyBkptsSet
** 
**    Rev 1.23   14 Sep 1992 13:17:16   brucea
** Added: BxResetAndStartEmulation
** 
**    Rev 1.22   08 Sep 1992 12:58:40   brucea
** Removed: event definitions
** 
**    Rev 1.21   27 Aug 1992 14:54:22   brucea
** Removed: BX_EMULATION_STATE and BX_CAUSE; now using those defined in sdtempl.h
** 
**    Rev 1.20   18 Aug 1992 18:27:34   brucea
** Changed: BX_CAUSE to match those in sdtempl.h
** 
**    Rev 1.19   13 Aug 1992 11:22:54   brucea
** Added errors 0x11, 0x12
** 
**    Rev 1.18   10 Aug 1992 08:20:14   brucea
** Added: BxAsmSetpIntoOrOver prototype
** 
**    Rev 1.17   30 Jul 1992 18:58:02   brucea
** Removed: EVENT_HL_BKPTEXEC_TEMP_BKPT_MATCH
** ifdef'ed out RxRemoveMatchingTemporary
** 
**    Rev 1.16   21 Jul 1992 20:59:02   brucea
** Added: ER_BX_NOT_ON_INST_BOUNDARY and ER_BX_ADDRESS_TOO_LARGE
** 
**    Rev 1.15   23 Jun 1992 15:39:48   brucea
** Removed: ER_BX_EMULATOR_MUST_BE_HALTED error message; added to bkroot.h
** Removed functions: BxGetEmulationStatus, BxProcessorMustBeHalted,
**     BxProcessorMustBeHaltedAbsolute, 
** 
**    Rev 1.14   18 Jun 1992 15:58:58   brucea
** Added: BxGetSrcBkptNames
** 
**    Rev 1.13   15 Jun 1992 09:16:10   brucea
** Added: error code ER_BX_EMU_IS_HALTED that is used to determine if emulator is
**    halted from a CLI command
** Added: BxProcessor MustBeHaltedAbsolute -> a call to determine the state of
**    of the processor running which does not check emuRunAccess.
** 
**    Rev 1.12   02 Jun 1992 13:44:48   brucea
** Added: BxGetAllBkptNext which allows caller to retrieve all programmed bkpts
** 
**    Rev 1.11   02 Jun 1992 12:12:52   brucea
** Added: BxGetBkptByAddressNext to get next bkpt that matches an input address
**    range
** 
**    Rev 1.10   15 May 1992 14:37:46   brucea
** Removed: several error messages
** 
**    Rev 1.9   11 May 1992 12:47:04   brucea
** Changed: name of ProcessorMustBeHalted to BxProcessorMustBeHalted
** 
**    Rev 1.8   20 Apr 1992 07:47:58   brucea
** Removed: step forever
** Added: error messages
** 
**    Rev 1.7   03 Apr 1992 19:02:22   brucea
** Added: enum dummy type = 0x7FFF to force into U16 size
** Added: ER_BX_INVALID_CALLBACK, ER_BX_BKPT_LESSTHAN_FUNC
** Removed: ER_BX_ABORT (made generic and put in hosterrs.h)
** Added: ProcessorMustBeHalted to EXPORT list
** 
**    Rev 1.6   26 Mar 1992 18:10:56   brucea
** Added: BX_TEMPORARY_INTERNAL to enum list of BX_BPLIFE (presenters should not
**    use this enum value)
** Changes: numerous changes to typedefs for parameters passed into functions
** Added: error codes 0xFL thru 0x11L
** New: event defines
** New: BxRemoveMatchingTemporary
** Changed: BxSrcGoUntilCall to BxGoUntilCallReturn
**          BxSrcGoUntilReturn to BxGoIntoCallReturn
** Removed: BxAsmGoUntilCall, BxAsmGoUntilReturn
** 
**    Rev 1.5   16 Mar 1992 13:42:44   brucea
** Added: ER_BX_NO_ADDRESS error message
** 
**    Rev 1.4   12 Mar 1992 23:35:56   brucea
** Changed: BX_ENABLE, BX_DISABLE to BX_ENABLED, BX_DISABLED
** Added: E_WARNING to error messages, added 9 - 0xDL messages
** Modified: interface for BxSetSrcBkpt, BxGetSrcBkpt
** Added: BxGetSrcBkptNext
** Removed: CliBxSetSrcBkpt, CliBxSetBkpt
** 
**    Rev 1.3   17 Feb 1992 07:58:28   doug
** cli breakpoint number is not a visible function; added error
** 
**    Rev 1.2   05 Feb 1992 15:41:16   doug
** added error messages from CLI
** 
**    Rev 1.1   03 Feb 1992 17:19:52   tom
** Cheerson's changes.
**
**  $Header:   S:/tbird/arcmmcf/inc/bkptexec.h_v   1.0   03 Jun 1996 11:24:26   gene  $
**
**  Copyright (C) 1991,92 Microtek International.  All rights reserved.
**
*****************************************************************************/

#define _BKPTEXEC_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#ifndef _BASEWIND_
#include "basewind.h"
#endif

#ifndef _HOSTERRS_
#include "hosterrs.h"
#endif

#ifndef _SDPROBE_
#include "sdprobe.h"
#endif

#ifndef _SYMBLSVR_
#include "symblsvr.h"
#endif

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/
typedef enum {
   BX_ENABLED,  /* breakpoint enabled */
   BX_DISABLED, /* breakpoint disabled */
   BX_BPSTATE_DUMMY = 0x7FFF /* force a 16 bit enum size */
} BX_BPSTATE;

typedef enum {
   BX_PERMANENT,  /* active until caller explicitly clears it */
   BX_TEMPORARY,  /* cleared automatically when it is hit */
   BX_TEMPORARY_INTERNAL,  /* settable only internally, cleared
                             automatically emulation stops */
   BX_BPLIFE_DUMMY = 0x7FFF  /* force a 16 bit enum size */
} BX_BPLIFE;

typedef enum {
   BX_STEP_INTO, /* step into functions */
   BX_STEP_OVER, /* step over functions */
   BX_STEP_DUMMY = 0x7FFF /* force a 16 bit enum size */
} BX_STEP_TYPE;

typedef enum {
   BX_LINE_GRAN,      /* sync up on source line */
   BX_STATEMENT_GRAN, /* sync up on C statement */
   BX_ASM_GRAN,       /* instruction-level sync */
   BX_GRAN_DUMMY = 0x7FFF /* force a 16 bit enum size */
} BX_GRANULARITY;

typedef enum {
   BX_CALL_RETURN,    /* stop on call or return */
   BX_RETURN_ONLY,    /* stop on return only */
   BX_CALL_DUMMY = 0x7FFF /* force a 16 bit enum size */
} BX_CALL_RETURN_TYPE;

                       /****************************
                        *                          *
                        *          ERRORS          *
                        *                          *
                        ****************************/

/* errors are now in errtext/mkerrors.h */


                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/

/*
**
**  Initialization and Termination
**
*/
/****************************************************************************
**
**  BxInit
**
**  Description:
**     Initialization of breakpoint and execution control.  This must be
**     called once during init and before any other calls made.
**
**  Parameters:
**     input:
**        none
**     output:
**        none
**
*****************************************************************************/
RETCODE EXPORT BxInit(VOID);


/****************************************************************************
**
**  BxTerminate
**
**  Description:
**     Terminate breakpoint and execution control.  Called once at the end
**     of a session to free resources.  No more calls can be made to other
**     routines after this is called (unless BxInit called again).
**
**  Parameters:
**     input:
**        none
**     output:
**        none
**
*****************************************************************************/
RETCODE EXPORT BxTerminate(VOID);

/*
**
**  Source Level Breakpoint
**
*/
/****************************************************************************
**
**  BxSetSrcBkpt
**
**  Description:
**     Set a source level breakpoint. The input <bkptAddrDesc> will be
**     consumed by this routine, even if error occurs.
**
**  Parameters:
**     input:
**        state:  initial state of the breakpoint
**        life:  temporary or permanent lifetime
**        module:  module where breakpoint is
**        lineNum:  line within module
**        columnStart:  column within line; legit values are 1 - 255;
**                      0 ==> no statement support (e.g. set line break)
**        lineText:  null terminated string of line (statement/line text
**           will be extracted to show in breakpoint pop-up); use NULL if
**           no text to be displayed
**        bkptAddrDesc: address descriptor for setting breakpoint.
**     output:
**        desc:  descriptor representing the breakpoint (use this to get
**           information and to ultimately remove the breakpoint)
**
*****************************************************************************/
RETCODE EXPORT
BxSetSrcBkpt(BX_BPSTATE     state,
             BX_BPLIFE      life,
             SYM_DESCRIPTOR module,
             LINENUM_TYPE   lineNum,
             COLUMN_TYPE    columnStart,
             LPSTR          lineText,
             DESCRIPTOR     bkptAddrDesc,
             DESCRIPTOR FAR *desc);


/****************************************************************************
**
**  BxGetSrcBkpt
**
**  Description:
**     Get the current settings for a source level breakpoint.
**
**     Note:  both the source and assembly level get will return information
**            regardless of where the original set was done.
**
**  Parameters:
**     input:
**        desc:  descriptor representing the breakpoint
**     output:
**        state:  initial state of the breakpoint
**        life:  temporary or permanent lifetime
**        module:  module where breakpoint is (NULL_SYMBOL if no symbol
**           information)
**        lineNum:  line within module
**        columnStart:  column where text begins
**        columnEnd:  column where text ends
**
*****************************************************************************/
RETCODE EXPORT
BxGetSrcBkpt(DESCRIPTOR         desc,
             BX_BPSTATE FAR     *state,
             BX_BPLIFE FAR      *life,
             SYM_DESCRIPTOR FAR *module,
             LINENUM_TYPE FAR   *lineNum,
             COLUMN_TYPE FAR    *columnStart,
             COLUMN_TYPE FAR    *columnEnd);


/****************************************************************************
**
**  BxGetSrcBkptNames
**
*****************************************************************************/
RETCODE EXPORT BxGetSrcBkptNames(DESCRIPTOR     desc,
                                 DESCRIPTOR FAR *modRefName,
                                 DESCRIPTOR FAR *modName,
                                 DESCRIPTOR FAR *functionName);


/****************************************************************************
**
**  BxGetSrcBkptNext
**
**  Description:
**     Manage the acquisition of the next source breakpoint.
**
**     Note:  both the source and assembly level get will return information
**            regardless of where the original set was done as long as the
**            module filter criteria is met.
**
**  Parameters:
**     input:
**        moduleFilter:
**           the module descriptor which must match the stored bkpt for it
**           to be returned.
**        *loopDesc:
**           opaque value which specifies where to start the search for the
**           next bkpt
**           Use *loopDesc = 0 for the initial starting point for the loop
**     output:
**        *loopDesc: return value to be passed for next bkpt call
**        bkptDesc: opaque descriptor to breakpoint found
**
**  It is expected that BxGetSrcBkpt is called to obtain the actual bkpt info
**
**  Error: ER_BX_LOOP_COMPLETE indicates when the loop has finished; bkptDesc
**         is not valid when it is returned.
*****************************************************************************/
RETCODE EXPORT
BxGetSrcBkptNext(SYM_DESCRIPTOR moduleFilter,
                 DESCRIPTOR FAR *loopDesc,
                 DESCRIPTOR FAR *bkptDesc);


/****************************************************************************
**
** BxGetBkptByAddressNext
**
** Description:
**    Get the next bkpt matching an input address range.
**    NOTE: this function can be used to look for a bkpt matching a single
**       address.  Simply define the addrDesc with the start and end address
**       the same (the address you want to match to a bkpt).
**
** Parameters:
**    input:
**       addrDesc:
**          the address descriptor which defines the address range to match
**          bkpts.  NOTE: this must be set up as a range address; i.e. caller
**          must call AdrSetRangeActive as well as fill in start and end
**          address values.
**
**       *loopDesc:
**          opaque value which specifies where to start the search for the
**          next bkpt
**          Use *loopDesc = 0 for the initial starting point for the loop
**    output:
**       *loopDesc: return value to be passed for next bkpt call
**       bkptDesc: opaque descriptor to breakpoint found
**
** It is expected that BxGetSrcBkpt is called to obtain the actual bkpt info
**
**
** Error: ER_BX_LOOP_COMPLETE indicates when the loop has finished; bkptDesc
**        is not valid when it is returned.
*****************************************************************************/
RETCODE EXPORT
BxGetBkptByAddressNext(DESCRIPTOR addrDesc,
                       DESCRIPTOR FAR *loopDesc,
                       DESCRIPTOR FAR *bkptDesc);


/****************************************************************************
**
** BxGetAllBkptNext
**
** Description:
**    Get the next bkpt.  Used to retrieve all defined bkpts
**
** Parameters:
**    input:
**       *loopDesc:
**          opaque value which specifies where to start the search for the
**          next bkpt
**          Use *loopDesc = 0 for the initial starting point for the loop
**    output:
**       *loopDesc: return value to be passed for next bkpt call
**       bkptDesc: opaque descriptor to breakpoint found
**
** It is expected that BxGetSrcBkpt is called to obtain the actual bkpt info
**
** Error: ER_BX_LOOP_COMPLETE indicates when the loop has finished; bkptDesc
**        is not valid when it is returned.
*****************************************************************************/
RETCODE EXPORT
BxGetAllBkptNext(DESCRIPTOR FAR *loopDesc,
                 DESCRIPTOR FAR *bkptDesc);


/*
**
**  Assembly Level Breakpoint
**
*/
/****************************************************************************
**
**  BxSetBkpt
**
**  Description:
**     Set an assembly level address breakpoint.
**
**  Parameters:
**     input:
**        state: initial state of the breakpoint
**        life:  temporary or permanent lifetime
**        addr:  address of breakpoint; consumed by this function even
**               if it returns an error
**     output:
**        desc:
**           descriptor representing the breakpoint (used to get
**           information and can be used to remove the breakpoint)
**
*****************************************************************************/
RETCODE EXPORT
BxSetBkpt(BX_BPSTATE state,
          BX_BPLIFE  life,
          DESCRIPTOR addr,
          DESCRIPTOR FAR *desc);

/****************************************************************************
**
**  BxSetBkptWithSpaceFromSR
**
**  Description:
**     Set an assembly level address breakpoint. The addr space is acquired
**     from SR register
**
**  Parameters:
**     input:
**        state: initial state of the breakpoint
**        life:  temporary or permanent lifetime
**        addr:  address of breakpoint; consumed by this function even
**               if it returns an error
**     output:
**        desc:
**           descriptor representing the breakpoint (used to get
**           information and can be used to remove the breakpoint)
**
*****************************************************************************/
RETCODE EXPORT
BxSetBkptWithSpaceFromSR(BX_BPSTATE state,
                         BX_BPLIFE  life,
                         DESCRIPTOR addr,
                         DESCRIPTOR FAR *desc);


/****************************************************************************
**
**  BxGetBkpt
**
**  Description:
**     Get the current setting for an assembly level breakpoint.
**
**     Note:  both the source and assembly level get will return information
**            regardless of where the original set was done.
**
**  Parameters:
**     input:
**        desc:  descriptor representing the breakpoint
**     output:
**        state:  initial state of the breakpoint
**        life:  temporary or permanent lifetime
**        addr:  address of breakpoint; memory TMalloc'ed by this function;
**               caller responsible for freeing it with AdrDestroyAddress
**
*****************************************************************************/
RETCODE EXPORT
BxGetBkpt(DESCRIPTOR desc,
          BX_BPSTATE FAR *state,
          BX_BPLIFE FAR *life,
          DESCRIPTOR FAR *addr);

/*
**
**  Breakpoint Routines common to source and assembly
**
*/
/***************************************************************************
**
**  BxEnableBkpt
**
**  Description:
**     Enable one breakpoint.
**
**  Parameters:
**     input:
**        desc:  descriptor representing the breakpoint
**     output:
**        none
**
*****************************************************************************/
RETCODE EXPORT BxEnableBkpt(DESCRIPTOR desc);


/***************************************************************************
**
**  BxDisableBkpt
**
**  Description:
**     Disable one breakpoint.
**
**  Parameters:
**     input:
**        desc:  descriptor representing the breakpoint
**     output:
**        none
**
*****************************************************************************/
RETCODE EXPORT BxDisableBkpt(DESCRIPTOR desc);


/***************************************************************************
**
**  BxRemoveBkpt
**
**  Description:
**     Remove one breakpoint.
**
**  Parameters:
**     input:
**        desc:  descriptor representing the breakpoint
**     output:
**        none
**
*****************************************************************************/
RETCODE EXPORT BxRemoveBkpt(DESCRIPTOR desc);


/***************************************************************************
**
**  BxEnableAllBkpts
**
**  Description:
**     Enable all breakpoints.
**
**  Parameters:
**     input:
**        desc:  descriptor representing the breakpoint
**     output:
**        none
**
*****************************************************************************/
RETCODE EXPORT BxEnableAllBkpts(VOID);


/***************************************************************************
**
**  BxDisableAllBkpts
**
**  Description:
**     Disable all breakpoints.
**
**  Parameters:
**     input:
**        desc:  descriptor representing the breakpoint
**     output:
**        none
**
*****************************************************************************/
RETCODE EXPORT BxDisableAllBkpts(VOID);


/***************************************************************************
**
**  BxRemoveAllBkpts
**
**  Description:
**     Remove all breakpoints.
**
**  Parameters:
**     input:
**        desc:  descriptor representing the breakpoint
**     output:
**        none
**
*****************************************************************************/
RETCODE EXPORT BxRemoveAllBkpts(VOID);


/***************************************************************************
**
** BxGetBkptCount
**
** Description:
**    Returns count of the number of bkpts set
**
** Output parameter:
**    bkptCountParam: 0 = no bkpts set (there may be some temporary internal
**    bkpts set, but they are not reported to caller since they are not
**    reported to bkpt presenter and are removed when emulation halts)
**
*****************************************************************************/
RETCODE EXPORT BxGetBkptCount(U16 FAR *bkptCountParam);


/***************************************************************************
**
**  BxGetCauseOfLastBreak
**
**  Description:
**     Get the cause of the last breakpoint
**
**  Parameters:
**     input:
**        none
**     output:
**        cause:  cause of the last break
**
*****************************************************************************/
RETCODE EXPORT BxGetCauseOfLastBreak(BREAK_CAUSE FAR *cause);


/*
**
**  Source Level Execution Control
**
*/
/****************************************************************************
**
**  BxSrcStep
**
**  Description:
**     This routine steps by source line or statement.
**
**  Parameters:
**     input:
**        type:  step into/over
**        gran:  step by line/statement
**        count:  number of lines/statements to step
**     output:
**        none
**
*****************************************************************************/
RETCODE EXPORT BxSrcStep(BX_STEP_TYPE type, BX_GRANULARITY gran,
                         U32 count);


/****************************************************************************
**
**  BxGoUntilCallReturn
**
**  Description:
**     In call-return mode, this routine goes until a line, statement, or asm
**        call/return instruction is reached.
**     In return mode, the same is true except it only stops on a return.
**     The choices for where to stop are:
**       line -> stop on first instruction of a line containing one or more
**               calls or returns
**       statement -> same as line only statement start
**       instruction -> stop on call or return instruction
**
**  Parameters:
**     input:
**        gran: choices:
**           go until source line
**           source statement
**           assembly instruction
**
**        callReturnType: choices:
**           go until call or return
**           go until return
**     output:
**        none
**
*****************************************************************************/
RETCODE EXPORT
BxGoUntilCallReturn(BX_GRANULARITY      gran,
                    BX_CALL_RETURN_TYPE callReturnType);


/****************************************************************************
**
**  BxGoIntoCallReturn
**
**  Description:
**     In call-return mode, this routine goes until a line, statement, or asm
**        call/return instruction is reached.  If address landed on bkpt,
**        step one instruction.  If line/stmt mode, step one more stmt.
**     In return mode, the same is true except it only sets bkpts on returns.
**     The choices for where to stop are:
**       line -> stop on first instruction of a line containing one or more
**               calls or returns
**       statement -> same as line only statement start
**       instruction -> stop on call or return instruction, then step into.
**
**  Parameters:
**     input:
**        gran: choices:
**           go until source line
**           source statement
**           assembly instruction
**
**        callReturnType: choices:
**           go until call or return
**           go until return
**     output:
**        none
**
*****************************************************************************/
RETCODE EXPORT
BxGoIntoCallReturn(BX_GRANULARITY      gran,
                   BX_CALL_RETURN_TYPE callReturnType);

/*
**
**  Assembly Level Execution Control
**
*/
/****************************************************************************
**
**  BxAsmStep
**
**  Description:
**     Single step at processor instruction level for a given number of steps.
**     This routine starts emulation in "Stepping" mode.  Use BxHaltEmulation
**     to stop emulation before the step count is reached.  Use
**     BxGetEmulationState or event notification to find out when step
**     is complete.
**     NOTE:  This operation is different from Mice-V which waited until all
**     the steps were complete.
**     NOTE:  A count of BX_STEP_FOREVER will put the emulator in a
**     continuous stepping mode (infinite count).  Use BxHaltEmulation to
**     stop.
**
**  Parameters:
**     input:
**        stepCount:  number of steps
**     output:
**        none
**
*****************************************************************************/
RETCODE EXPORT BxAsmStep(U32 stepCount);


/****************************************************************************
**
** BxAsmStepIntoOrOver
**
** Purpose: exported, callable assembly step
**
*****************************************************************************/
RETCODE EXPORT BxAsmStepIntoOrOver(U32 stepCount, BX_STEP_TYPE stepType);


/*
**
**  Execution Control Routines common to source and assembly
**
*/
/****************************************************************************
**
**  BxStartEmulation
**
**  Description:
**     Start free run of emulation.
**
**  Parameters:
**     input:
**        none
**     output:
**        none
**
*****************************************************************************/
RETCODE EXPORT BxStartEmulation(VOID);


/****************************************************************************
**
**  BxResetAndStartEmulation
**
**  Description:
**     Resets target then starts free run of emulation.
**
**  Parameters:
**     input:
**        none
**     output:
**        none
**
*****************************************************************************/
RETCODE EXPORT BxResetAndStartEmulation(VOID);


/****************************************************************************
**
**  BxHaltEmulation
**
**  Description:
**     Stop emulation.  This will stop emulation regardless of breakpoint and
**     trigger state (asynchronous stop).
**
**  Parameters:
**     input:
**        none
**     output:
**        none
**
*****************************************************************************/
RETCODE EXPORT BxHaltEmulation(VOID);

/***************************************************************************
**
** BxSetStepMask
** BxGetStepMask
**
** Description:
**    Set or get state of interrupt mask for step.
**
** Parameters:
**    stepMask:   TRUE indicates that interrupts should be disabled during
**                all steps.
**
*****************************************************************************/
RETCODE EXPORT BxSetStepMask(BOOLEAN stepMask);
RETCODE EXPORT BxGetStepMask(BOOLEAN *stepMask);


/******************************** E O F ***********************************/
