/****************************************************************************
**
**  Name:  hlpentry.h
**
**  Description: Help entry points for cases other than errors.  (Errors
**               have help entry points defined in the errtext server's
**               errhelp.h file.)
**
**  Status:  preliminary.
**
**  $Log:   S:/tbird/arcmmcf/inc/hlpentry.h_v  $
** 
**    Rev 1.2   05 Aug 1997 16:01:24   gene
** added memory compare dialog entry
** 
**    Rev 1.1   04 Aug 1997 17:21:36   gene
** added help index and entry for PC breakpoint dialog
** 
**    Rev 1.0   03 Jun 1996 11:24:54   gene
** Initial revision.
** 
**    Rev 1.0   07 Sep 1995 10:26:02   gene
** Initial revision.
** 
**    Rev 1.9   04 Jan 1994 15:19:06   tom
** Added actual help context numbers for PC-NFS changes.
** 
**    Rev 1.8   23 Dec 1993 09:32:00   tom
** New help context numbers for PC-NFS; bogus for now.
** 
**    Rev 1.7   27 Sep 1993 10:28:42   ron
** added defines for peripheral presenter dialogs
** 
**    Rev 1.6   01 Sep 1993 14:37:18   ron
** changes for help/menu support in Peripheral Presenter
** 
**    Rev 1.5   30 Aug 1993 11:04:46   ron
** changes for Load Progress dialog
** 
**    Rev 1.4   28 Jul 1993 19:56:26   ron
** put back for 2.0 build
** 
**    Rev 1.3   27 Jul 1993 15:57:08   ron
** made more specific help entry for delete all events (just goes to event
** window help, since there is no specific help for that dialog).
** 
**    Rev 1.2   22 Jul 1993 16:19:22   ron
** ppr 8378: needed entry for select compiler used dialog
** 
**    Rev 1.1   09 Jul 1993 16:37:30   ron
** added help entry index for F1 hook
** 
**    Rev 1.0   25 Jun 1993 13:43:20   ron
** Initial revision.
** 
**  $Header:   S:/tbird/arcmmcf/inc/hlpentry.h_v   1.2   05 Aug 1997 16:01:24   gene  $
**
*****************************************************************************/

#define _HLPENTRY_
                        /****************************
                         *                          *
                         *       INCLUDE FILES      *
                         *                          *
                         ****************************/

                        /****************************
                         *                          *
                         *        DEFINITIONS       *
                         *                          *
                         ****************************/


/*
 * HELP ENTRY POINTS
 */

/*
 * Table of contents really is id 1...
 */
#define HE_CONTENTS                     1

#define HE_DELETE_ALL_EVENTS            2037
#define HE_LOADER_INFO                  1
#define HE_ENLIB_DEBUG_QUERY_1          1
#define HE_ENLIB_DEBUG_QUERY_2          1
#define HE_ENLIB_DEBUG_QUERY_3          1
#define HE_SDS_WSNET_1                  1
#define HE_SDS_WSCOM_1                  2048
#define HE_SELECT_COMPILER_DIALOG       2049

#define HE_INTERNAL_ERROR               13

#define HE_CANCEL_LOAD                  2059
#define HE_LOAD_PROGRESS                2060
#define HE_LOAD_INFO                    2061

#define HE_PERIPHERAL                   2067
#define HE_EDITPERIPHREGBUFFER          2068
#define HE_EDITPERIPHREG                2069
#define HE_PERIPHGOTOADDRESS            2070
#define HE_PERIPHGOTOPERIPH             2071

/*
 * Index of F1 hook table entry (see cliulib\f1hook.c)
 */

#define HI_MESSAGEBOXEX                 21
#define HI_PERIPHERAL                   38

#define HE_NET_EMULATOR_BUSY            2072
#define HE_HOST_SELECTION_DLG           2073


/*
 * Index of F1 hook table entry, added for PC Breakpoint dialog
 */

#define HI_ENTRY_BREAKPOINT             36 /* breakpoint */
#define HE_DLGR_SET_BREAKPOINT          2022 /* setbreakointdialog */

/*
 * Index of F1 hook table entry, added for Memory Compare dialog
 */

#define HE_DLGR_MEM_COMPARE             2076
