/****************************************************************************
**
**  Name:  stkutil.h
**
**  Title: Stack Utility
**
**  Description: Declarations for stack utility
**
**  Status:  PRELIMINARY 
**
**  $Log:   S:/tbird/arcmmcf/stkservr/stkutil.h_v  $
** 
**    Rev 1.0   03 Jun 1996 11:39:20   gene
** Initial revision.
** 
**    Rev 1.1   01 Dec 1995 10:10:40   kevin
** joyce's modification
** 
**    Rev 1.0   07 Sep 1995 11:14:24   gene
** Initial revision.
** 
**    Rev 1.8   16 Jul 1993 11:50:22   nghia
** PIP for Stack:
** - Added Stack profile name and items.
** - Added new function prototypes and moved private to public.
** 
**    Rev 1.7   12 Jan 1993 10:34:16   marilyn
** Added prototype for ReleasePreviousFrames.
** 
**    Rev 1.6   03 Jun 1992 15:24:32   marilyn
** Added prototype for GetBlankSpace.
** 
**    Rev 1.5   12 Mar 1992 17:28:20   marilyn
** No change.
** 
**    Rev 1.4   11 Mar 1992 10:44:20   marilyn
** Added prototypes
** 
**    Rev 1.3   02 Mar 1992 16:22:34   marilyn
** Moved prototypes from the .c file.
** 
**    Rev 1.2   27 Feb 1992 15:42:16   marilyn
** No change.
** 
**    Rev 1.1   11 Feb 1992 15:58:58   marilyn
** Added prototypes. Integrated DLL version.
** 
**    Rev 1.0   24 Jan 1992 12:07:32   brucea
** Initial revision.
** 
**  $Header:   S:/tbird/arcmmcf/stkservr/stkutil.h_v   1.0   03 Jun 1996 11:39:20   gene  $
**
**  Copyright (C) 1991 Microtek International.  All rights reserved.
**
*****************************************************************************/

#define _STKUTIL_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#ifndef _STKSERVR_
#include "stkservr.h"
#endif

#ifndef _STKWALK_
#include "stkwalk.h"
#endif

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/
/* StackInfo profile item names */ 
#define STK_APPNAME        "StackInfo"
#define STK_SIZE_ITEM      "StackSize"
#define STK_BASE_ITEM      "StackBaseAddr"
#define STK_PERCENT_ALARM  "PercentAlarmLimit"
#define STK_ENABLE_ALARM   "EnableAlarmLimit"
#define STK_ENABLE_HWM     "EnableHWM"

                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/
RETCODE FormatFrames(STK_FRAME_NODE *startPtr,
                     STK_FRAME_NODE *endPtr,
                     BOOLEAN interActive,
                     STRING *textPtr);

VOID GetBlankSpace(STRING *textPtr);

VOID GetEndOfBuffer(STRING *textPtr);

VOID GetEndOfLine(STRING *textPtr);

RETCODE GetParamsForFrame(STK_FRAME_NODE *frame,
                          STRING *textPtr,
                          BOOLEAN interActive);

RETCODE GetSingleFrame(STK_FRAME_NODE *frame,
                       STRING *textPtr,
                       BOOLEAN interActive);

RETCODE ReleasePreviousFrames(VOID);

RETCODE RecalcAlarmLimit(DESCRIPTOR sessionId, U32 percent);

RETCODE StkRestoreIniValues(VOID);

RETCODE StkSaveIniValues(VOID);

RETCODE StkInitWithIniValues(DESCRIPTOR sessionId);

RETCODE StkSetAddrSpace(DESCRIPTOR addr);
RETCODE StkGetAddrSpace(ADDR_SPACE *addrSpace);

/******************************** E O F ***********************************/
