/*----------------------------------------------------------------------------
** Name: byadrtbl.h
**
** Title: By-address Sorted Table
**
** Purpose:
**  Class and methods for managing the by-address sorted table.  Each base
**  structure points to one by-address sorted table.
**
** Status: PRELIMINARY | CODED
**
** $Log:   S:/tbird/arcmmcf/symbol/byadrtbl.h_v  $
** 
**    Rev 1.1   11 Jun 1996 18:48:52   gene
** 
**    Rev 1.0   07 Sep 1995 11:16:30   gene
** Initial revision.
** 
**    Rev 1.7   25 Jul 1992 16:35:20   brucea
** Added: output parameter tableSize to ByAddressTableGetNext
** 
**    Rev 1.6   10 Jul 1992 18:34:22   brucea
** Added: ByAddressTableGetNext
** 
**    Rev 1.5   24 Jun 1992 18:08:34   brucea
** Added: #ifdef __cplusplus around the C++ class definitions
** Added: EXPORT to SortAllByAddressTables
** 
**    Rev 1.4   29 Nov 1991 19:48:04   brucea
** changed LOGICAL_ADDR_TYPE to OFFSET_ADDR_TYPE
** 
**    Rev 1.3   01 Nov 1991 10:51:46   brucea
** Added SYMBOL_INFO_TYPE
** Modified ByAddressTable::GetOffset
** Added #ifdef __cplusplus
** Took AddressCompare out of class method
** Added SortAllByAddressTables
** 
**    Rev 1.2   11 Oct 1991 15:01:26   brucea
** Removed #include _SYMMGR_
** Changed ByAddressTable call to public:
** 
**    Rev 1.0   13 Sep 1991 09:57:50   brucea
** Initial revision.
** 
** $Header:   S:/tbird/arcmmcf/symbol/byadrtbl.h_v   1.1   11 Jun 1996 18:48:52   gene  $
**
** Copyright (C) 1991 Microtek International.  All rights reserved.
**
**--------------------------------------------------------------------------*/

#define _BYADRTBL_

#ifndef _MEMPOOL_
#include "mempool.h"
#endif

#ifndef _SYMMGR_
#include "symmgr.h"
#endif

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/

typedef struct {
   TABLE_OFFSET symbolOffset;
   U32          delta;      // requested addr minus start addr of matching sym
} SYMBOL_INFO_TYPE;

                       /**********************************
                        *                                *
                        *   MEMBER FUNCTION PROTOTYPES   *
                        *                                *
                        **********************************/

#ifdef __cplusplus

class ByAddressTable : public MemPool {

public:
//---------------------------------------------------------------------------
// ByAddressTable()  constructor
//
// Purpose:
//    Initialize by-address table variables for memory management.
//---------------------------------------------------------------------------
   ByAddressTable();    // constructor


//-----------------------------------------------------------------------
// GetOffset
//
// Purpose: returns the offset to the symbol stored in the by-address table
//-----------------------------------------------------------------------
TABLE_OFFSET ByAddressTable::GetOffset(U32 index) {
   return *(HP_TABLE_OFFSET)GetHugeDataPtr(index * sizeof(TABLE_OFFSET));
   } 


//-----------------------------------------------------------------------
// GetSymbolCount
// 
// Purpose: returns the number of symbol offsets placed into table
//-----------------------------------------------------------------------
   U32 GetSymbolCount(VOID) { return (GetAvailMemOffset()
                              / sizeof(TABLE_OFFSET)); };


//-----------------------------------------------------------------------
// SearchForAddr
//
// Purpose:
//    Searches for a symbol which has a range that contains the requested
//    address and has the smallest end address that still contains addr.
//-----------------------------------------------------------------------
   RETCODE
   ByAddressTable::SearchForAddr(OFFSET_ADDR_TYPE requestedAddr,
                                 SYMBOL_INFO_TYPE& symbolInfo);


//-----------------------------------------------------------------------
// SortTable
//
// Purpose: Sorts the offsets to symbols by the start address of each symbol
//
// Input parameter: NONE
//
// Return value: NONE
//
// Errors:
//    returns ER_BYADDRTABLE_EMPTY if no items in the table; this should
//    never occur since the call to SortTable should never be made if the
//    the dirty flag is not set - i.e. no symbols are put into table.
//------------------------------------------------------------------------
   RETCODE SortTable(VOID);

};  // end of class ByAddressTable

#endif


#ifdef __cplusplus
extern "C" {
#endif

//------------------------------------------------------------------------
// AddressCompare
//
// Purpose:
//    Provides the compare function for the QSort sort
//------------------------------------------------------------------------
int AddressCompare(const VOID _FAR * first,
                   const VOID _FAR * second);



//------------------------------------------------------------------------
// SortAllByAddressTables
//
// Purpose:
//    Sorts all by-address tables with addrTableDirty TRUE
//------------------------------------------------------------------------
RETCODE EXPORT
SortAllByAddressTables(VOID);


//-----------------------------------------------------------------------
// ByAddressTableGetNext
//
// Purpose:
//   Iterator to walk the bases and return the name and symbol count
//
// Input parameters:
//    startLoop: TRUE ==> starts the interation
//              FALSE ==> must be set after first access
//
// Output parameters:
//    loopPtr: call by reference; must be returned when startLoop FALSE
//    baseName: string of base name
//    entryCount: reference var returning number of symbols in this base
//    tableSize: allocated size of by-address table
//-----------------------------------------------------------------------
RETCODE
ByAddressTableGetNext(BOOLEAN       startLoop,
                      TABLE_OFFSET& loopPtr,
                      LPSTR         baseName,
                      U32&          entryCount,
                      U32&          tableSize);

#ifdef __cplusplus
}
#endif
/******************************** E O F *************************************/