/****************************************************************************
**
**  Name:  libmain.c
**
**  Description:
**     Contains the main entry/exit point of the VARSERVR.DLL
**
**  Status:  PRELIMINARY
**
**  $Log:   S:/tbird/arcmmcf/varsrv/libmain.c_v  $
** 
**    Rev 1.0   03 Jun 1996 11:43:58   gene
** Initial revision.
** 
**    Rev 1.0   07 Sep 1995 11:24:48   gene
** Initial revision.
** 
**    Rev 1.8   19 Aug 1992 09:11:40   marilyn
** Checks for errors from the init routine.
** 
**    Rev 1.7   14 May 1992 16:32:26   marilyn
** Added call to ErrInitDLL.
** 
**    Rev 1.6   20 Mar 1992 09:39:06   marilyn
** Removed include for  varservr.h , added include for varutil.h.
** 
**    Rev 1.5   28 Feb 1992 11:02:20   marilyn
** No change.
** 
**    Rev 1.4   24 Jan 1992 10:20:38   brucea
** Added #include "varservr.h"
** Reinstalled VSInit call in LibMain
** 
**    Rev 1.3   23 Jan 1992 11:54:02   marilyn
** Removed the call to VSInit from libmain.
** 
**    Rev 1.2   22 Jan 1992 17:35:00   marilyn
** Removed InitCServer to varcli.c
** 
**    Rev 1.1   21 Jan 1992 15:40:10   courtney
** Added InitCServer entry point.
** 
**    Rev 1.0   17 Jan 1992 08:09:26   marilyn
** Initial revision.
**
**  $Header:   S:/tbird/arcmmcf/varsrv/libmain.c_v   1.0   03 Jun 1996 11:43:58   gene  $
**
*****************************************************************************/

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#ifndef _BASEWIND_
#include "basewind.h"
#endif

#ifndef _VARUTIL_
#include "varutil.h"
#endif

#ifndef _HOSTERRS_
#include "hosterrs.h"
#endif

/* Define symbol to exclude the WEP routine */
#define _BORLANDC_
                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/

/* Handle of the DLL instance */
HANDLE hLib;

                        /****************************
                         *                          *
                         *    EXTERNAL VARIABLES    *
                         *                          *
                         ****************************/

                        /****************************
                         *                          *
                         *     LOCAL PROTOTYPES     *
                         *                          *
                         ****************************/

                        /****************************
                         *                          *
                         *      EXECUTABLE CODE     *
                         *                          *
                         ****************************/

/**************************************************************************
**
** LibMain
**
** Description: Main entry point of the VWSERVER.DLL
**
**	Parameters:
**    input:
**       hInstance:     Handle of the library instance
**       wDataSeg:      Value of Data Segment register
**       cbHeapSize:    Heap Size of the heap defined in the DEF
**       lpszCmdLine:   Command Line information (rarely used)
**
**    output:
**
***************************************************************************/
#pragma argsused
int FAR PASCAL LibMain(HANDLE hInstance, WORD wDataSeg, WORD cbHeapSize,
    LPSTR lpszCmdLine) {

    RETCODE err;

    /* the LIBENTRY initializes the local heap by calling LocalInit() and
       then calls LibMain.  The LocalInit() locks the data segment of the
       library when initialize; therefore LibMain needs to unlock */

    if (cbHeapSize != 0) /* the DLL Data segment is MOVEABLE */
       UnlockData(0);

    /* initialize successfully */
    hLib = hInstance;
    ErrInitDLL(MODULE_VAR, "varservr.dll");

    err = VSInit();        /* VSInit returns GOOD (hopefully) */
    if (GOOD != err)
       ErrDisplayError(err, FORCE_POPUP);
    return(TRUE);

}

#ifndef _BORLANDC_
/**************************************************************************
**
** WEP {Windows Exit Procedure}
**
** Description: DLL exit procedure to perform cleanup for the DLL before it
**              is unloaded. - not to be used with BC++ compiler.
**
**	Parameters:
**    input:
**       nParam:     Message to indicate whether all of Windows is shutting
**                   down or just the DLL itself.
**
**    output:
**       return a 1 to indicate success
**
***************************************************************************/
void FAR PASCAL WEP(int nParam) {

   switch(nParam) {
      case WEP_SYSTEMEXIT:
         /* System shutdown in progress. Respond accordingly */
         break;
      case WEP_FREE_DLL:
         /* The DLL use count is 0 */
         break;
      default:
         /* Undefined value - ignore */
         break;
   }
   return(TRUE);
}
#endif


/******************************** E O F ***********************************/
