/***************************************************************************
 *
 *  bufexp.c -- communications demo program
 *
 *  $Revision:   1.1  $
 *  $Date:   01 Mar 1990 16:59:58  $
 *  $Logfile:   V:/vcs/demo/logfiles/bufexp.c_v  $
 *  $Log:   V:/vcs/demo/logfiles/bufexp.c_v  $
 *  
 *     Rev 1.1   01 Mar 1990 16:59:58   MIKE
 *  Removed code that changed 8259 priority.
 *  
 *     Rev 1.0   12 Feb 1990 15:15:44   MIKE
 *  Initial revision.
 *
 *
 *  Copyright (c) 1989 Rational Systems, Incorporated
 *  All Rights Reserved
 *
 */

extern int  RS232_COM;
#define TRUE		1
#define FALSE		0
#define COM2EXISTS	1
/*
   COMMUNICATIONS BUFFER SUPPORT FOR IBM COM PORTS

	This program demonstrates a bimodal interrupt
	handler for the serial communications (COM1, COM2)
	ports.  The transmit and receive data for each 
	serial channel is buffered to provide an efficient,
	straight forward interface.

	The interface between the interrupt handlers and 
	background code is achieved through the following 
	buffer structure:

					INTERRUPT FLAG WORD
					BUFFER 1 HEADER
					BUFFER 2 HEADER
					BUFFER 1 TRANSMIT DATA
					BUFFER 1 RECEIVE DATA
					BUFFER 2 TRANSMIT DATA
					BUFFER 2 RECEIVE DATA

	INTERRUPT FLAG WORD: The LSB is used to store the number
		of COM ports (1 or 2).  If only one COM port, the MSB
		is meaningless.  However if two COM ports are active,
		the interrupt handlers use the MSB	to determine when 
		both ports have been serviced.  When an interrupt occurs, 
		the channel that caused the interrupt is serviced and, 
		before exiting, the other channel is checked and serviced 
		if necessary.  Handling is done in this way to prevent 
		any loss of characters.  

	BUFFER HEADERS: The buffer headers for channel 1 and 2 are
		defined as follows:


struct   buffer {
   char  *buffer_starting_address;				 -----
   int   buffer_size;									|
   char  *fill_pointer;									|
   char  *empty_pointer;								|		Transmit
   int   free_space;										|		Buffer
   int   xon_xoff;										|
   int   status;											|
   int   handler_index;								 -----
   char  *rbuffer_starting_address;				 -----
   int   rbuffer_size;									|		Receive
   char  *rfill_pointer;								|		Buffer
   char  *rempty_pointer;								|
   int   rfree_space;								 -----
   };
 
	
	The buffer address pointers are initialized to protected-mode
	values, with offsets that are the same in both modes.  A
	real-mode and protected-mode buffer pointer are initialized
	and stored in the interrupt handler code.	In this way, the 
	interrupt handler can load the real or protected-mode buffer
	address at the start of an interrupt and can access the buffer 
	using	the offsets of the pointers.

	The transmit/receive buffer sizes and optional XON/XOFF
	protocol support for each channel are selectable through
	#defines in the buffer.h include file.

	The interrupt handling code is in the file IBMITX.ASM.

	The buffer handling code is contained in the file BUFRUTSX.ASM.
	This file contains the following interface routines:

			int _g_received_character(COM_index) 
				  INPUT: COM_index = 0 (COM1), 1 (COM2)
				RETURNS: the next character	in the buffer.


N.B. THIS CODE DOES NOT HANDLE COMMUNICATIONS ERRORS (ERRORS ARE
		IGNORED).



																							*/


#include <stdio.h>
#include <conio.h>
#include "buffer.h"
#include "pmode.h"

#define  COM1 0
#define  IRQ4	0x0c
#define  COM2 1
#define  IRQ3	0x0b

#define IOERR 0x24

extern void _com1init();
extern void _com1it();
extern void _RM_com1it();
extern void _PM_com1it();
extern void _RM_com2it();
extern void _PM_com2it();
extern void _IoErr();
INTVECT Int24VectBackUp;

int buffer_init();

extern char far *_bufptrs;
unsigned char *DS_ptr;
unsigned int *DS_buf;
unsigned char *PM_ptr;
unsigned char *RM_ptr;
INTVECT IRQ3VECT;
INTVECT IRQ4VECT;
unsigned char *data_ptr;
struct buffer *ctransmit;

int   buffer_parameters[BUFFER_NUMBER][3] = {
         {TRANSMIT_BUFFER_SIZE,RECEIVE_BUFFER_SIZE,ENABLED}  /* COM 1 */
         ,{TRANSMIT_BUFFER_SIZE,RECEIVE_BUFFER_SIZE,ENABLED} /* COM 2 */
};

int rstint()
{
	_comexit();
if ( RS232_COM == 0 )
/* restore original real-mode interrupt vectors */
	D16rmInstall (IRQ4, IRQ4VECT.sel, IRQ4VECT.off,NULL);
else
	D16rmInstall (IRQ3, IRQ3VECT.sel, IRQ3VECT.off,NULL);
}


/*
	Initialize buffer header pointers and variables
																	*/

void header_init(hdr_p,data_p)
unsigned char *hdr_p,*data_p;
{
int i;
   for (i=0;i<BUFFER_NUMBER;i++)
   {
	(unsigned char *)ctransmit = hdr_p;
   ctransmit->buffer_starting_address = 
            ctransmit->fill_pointer = 
            ctransmit->empty_pointer = 
                  data_p;
   data_p += buffer_parameters[i][0];

   ctransmit->rbuffer_starting_address = 
            ctransmit->rfill_pointer = 
            ctransmit->rempty_pointer = 
                  data_p;
   data_p += buffer_parameters[i][1];

 
   ctransmit->buffer_size = ctransmit->free_space = 
         buffer_parameters[i][0];
   ctransmit->rbuffer_size = ctransmit->rfree_space = 
         buffer_parameters[i][1];
   ctransmit->status = 0;
   ctransmit->xon_xoff = buffer_parameters[i][2];         
   ctransmit->handler_index = i;
	hdr_p += sizeof(struct buffer); /* increment to next buffer header area */
   }
}

InitIoErr()
{
void (*p) ();

	D16MemStrategy(MForceLow); 
	p = _IoErr;
	if (! D16SegRealloc (p)) return(FALSE);
	p = D16RealPtr(_IoErr);
	D16rmInstall (IOERR, FP_SEG(p), FP_OFF(p), &Int24VectBackUp);
	D16MemStrategy(MPreferExt); 
}

EndIoErr()
{
	D16rmInstall (IOERR, FP_SEG(Int24VectBackUp.sel),
						FP_OFF(Int24VectBackUp.off), NULL);
}

int buffer_init()
{
int   i;
void (*p) ();

/*
	Force interrupt handler code to low memory for real-mode
																			   */
	D16MemStrategy(MForceLow); 
	p = _com1it;
	if (! D16SegRealloc (p)) { rstint();return(FALSE); }

/*
	Setup data alias in order to store the buffer pointers into the
	interrupt handler code segment
																							*/
	DS_ptr = D16SegDSAlias ((void (far *)())&_bufptrs); 
	if (! DS_ptr) { rstint();return(FALSE); }

/*
	Allocate space for buffer data and header into low memory
																				*/
   PM_ptr = D16MemAlloc((2+sizeof(struct buffer)*BUFFER_NUMBER)+TOTAL_BUFFER_SIZE);
	if (! PM_ptr) { rstint();return(FALSE); }

	data_ptr = PM_ptr+(2+sizeof(struct buffer)*BUFFER_NUMBER); /* setup pointer to data area */
/* initialize interrupt done flag */
	*(PM_ptr) = BUFFER_NUMBER;
   PM_ptr += 2; /* save word for interrupt done flag */
   RM_ptr = D16RealPtr(PM_ptr);
	if (! RM_ptr) { rstint(); return(FALSE); }


/*
	Store protected/real-mode pointers in interrupt handler code
																						*/
	DS_buf    = (unsigned *)DS_ptr;
	DS_buf[0] = (unsigned int)(FP_OFF(RM_ptr));	
	DS_buf[1] = (unsigned int)(FP_SEG(RM_ptr));	
	DS_buf[2] = (unsigned int)(FP_OFF(PM_ptr));	
	DS_buf[3] = (unsigned int)(FP_SEG(PM_ptr));	
	header_init(PM_ptr,data_ptr);

if ( RS232_COM == 0 ) {
/* install COM1 real-mode interrupt handler */
	p = D16RealPtr(_RM_com1it);
	D16rmInstall (IRQ4, FP_SEG(p), FP_OFF(p), &IRQ4VECT);
/* install COM1 protected-mode interrupt handler */
	p = _PM_com1it;
	D16pmInstall (IRQ4, FP_SEG(p), FP_OFF(p), NULL);

} else {
/* install COM2 real-mode interrupt handler */
	p = D16RealPtr(_RM_com2it);
	D16rmInstall (IRQ3, FP_SEG(p), FP_OFF(p), &IRQ3VECT);
/* install COM2 protected-mode interrupt handler */
	p = _PM_com2it;
	D16pmInstall (IRQ3, FP_SEG(p), FP_OFF(p), NULL);
}

	D16MemStrategy(MPreferExt); 
}

int rcv_is_ready(channel_number)
int   channel_number;
{
	(unsigned char *)ctransmit = PM_ptr+sizeof(struct buffer)*channel_number;
	return (ctransmit->rfree_space != ctransmit->rbuffer_size);
}

rx_data()
{
 if ( rcv_is_ready(RS232_COM) ) return(_g_received_character(RS232_COM));
 else return(-1);
}
