/*--------------------------------------------------------------------------*/
/*  cmdhelp.c								    */
/*--------------------------------------------------------------------------*/


#include  "system.h"
#include  "usd3.h"
#include  "gblext.h"
#include  "oldext.h"
#include  "usym1.h"
#include  "usym3.h"
#include  "funcext.h"

char  *CmdArgu[] = {

	/*   0 */  "no argument",
	/*   1 */  "Please refer to \"?\" command",
	/*   2 */  "Please refer to \"HElp\" command",

	/*-------------------------  MICE-II command argument  -------------------------*/

	/*   3 */  "[[CS|DS|SS|ES|seg:]addr]",
	/*   4 */  "[R]addx[ c[ q]]",
	/*   5 */  "[W|c]",
	/*   6 */  "[N|I|H|C]",
	/*   7 */  "[[seg:]addr]",
	/*   8 */  "[0[1|2]|1 [addx[ c[ q]]]|2 [addr]]",
	/*   9 */  "[W]port[ c[ time]]",
	/*  10 */  "[seg:]addr",
	/*  11 */  "[step[ a1[ a2[q...]]]|S[step]|Z[step]|N]",
	/*  12 */  "[W][[CS|DS|SS|ES|seg:]a1[ a2[ d1[..d8]][S]]]",
	/*  13 */  "[W]port d1[..d8]",
	/*  14 */  "[AX|BX|CX|DX|SP|BP|SI|DI|DS|ES|SS|CS|IP|FS]",
	/*  15 */  "[S|R][c]|[Z]|[a1 a2]",
	/*  16 */  "[CS|DS|SS|ES|seg:]a1 a2 S|M|[CS|DS|SS|ES|seg:]a3[ V]",
	/*  17 */  "[[CS|DS|SS|ES|seg:]a1 [a2]]",
	/*  18 */  "[loc]",
	/*  19 */  "[I|H|B]",
	/*  20 */  "[addr]",
	/*  21 */  "[W|B]port[ c[ time]]",
	/*  22 */  "addr",
	/*  23 */  "[a1[ a2[ d1[..d4]][ S]]]",
	/*  24 */  "[n]",
	/*  25 */  "[W]port d1[..d4]|B port d1[..d8]",
	/*  26 */  "[D0|1|2|3|4|5|6|7|A0|1|2|3|4|5|6|SP|UP|SR]",
	/*  27 */  "a1 a2 S|M|a3[ V]",
	/*  28 */  "[a1 [a2]]",
	/*  29 */  "[c]",
	/*  30 */  "[N|I]",
	/*  31 */  "port[ c[ time]]",
	/*  32 */  "[a1[ a2[ d1[..d8]][ S]]]",
	/*  33 */  "port d1[..d8]",
	/*  34 */  "[A|X|Y|P|S]",
	/*  35 */  "[S|R][c]|[Z]",
	/*  36 */  "[R|I|X]",
	/*  37 */  "[I|T]",
	/*  38 */  "[ a1[ a2[ d1[..d8][S]]]|AP[ a1 a2 {M|T|MR|TR|G}]]",
	/*  39 */  "[I|register|P|A/D]",

	/*------------------------  MICE-III command argument  -------------------------*/

	/*  40 */  "[space-adr]",
	/*  41 */  "[space-adr [data]]",
	/*  42 */  "space-adr {adr|Length length}",
	/*  43 */  "space-adr1 {adr|Length length} space-adr2",
	/*  44 */  "[[Berr] [Intr] [BR] [Cdis] {Enable|Disable}]",
	/*  45 */  "space-adr1 {adr|Length length} [space-adr2]",
	/*  46 */  "[Wait|count]",
	/*  47 */  "[space-adr [adr|Length length]]",
	/*  48 */  "[adx [datum] [status] [COunt count]|CLear]",
	/*  49 */  "[adx [datum] [status]|CLear]",
	/*  50 */  "[High|Low|CLear]",
	/*  51 */  "[[Run] adr [COunt count]|CLear]",
	/*  52 */  "[adr|CLear]",
	/*  53 */  "space-adr {adr|Length length} data",
	/*  54 */  "[Run] [adr]",
	/*  55 */  "[code]",
	/*  56 */  "[USD3|GRoup {Emulation|Memory|Port|Setup|Trace}|command|ALl]",
	/*  57 */  "space-adr [Length in-length]",
	/*  58 */  "[On|OFf]",
	/*  59 */  "adr",
/*...*/	/*  60 */  "[N|{S|I} [frame] [Odd-word]|frame [adr1 adr2] [status] [trace-bits]]",
/*...*/	/*  61 */  "(EMM)[adr1 adr2 {I|IR|E}|AL E] (HEMM)[adr1 adr2 {I|E|ER|G}|AL {E|G}]",
	/*  62 */  "[adr1 adr2 {I|IR|E|ER|G}]",
	/*  63 */  "space-adr data",
	/*  64 */  "[string]",
	/*  65 */  "[adx [status]|CLear]",
	/*  66 */  "[Internal|External]",
	/*  67 */  "[register|FP-processor [fp-register]]",
	/*  68 */  "[pc [isp]]",
	/*  69 */  "[Byte|Word|Long]",
	/*  70 */  "[Common|[Supervisor|User] [Program]]",
	/*  71 */  "[adr1 adr2 [CALl]|count|CALl]",
	/*  72 */  "[{Input|OUtput} {On|OFf}]",
	/*  73 */  "[Go|Event] [1|10|100|1000|10000]",
/*...*/	/*  74 */  "[CLear|[Run] ... [BACKward|CENter|FOrward|DELay count]]",
	/*  75 */  "[0|1|2]",
	/*  76 */  "[adr [data]]",
	/*  77 */  "adr1 {adr2|Length length}",
	/*  78 */  "adr1 {adr2|Length length} adr3",
	/*  79 */  "[[Nmi|Reset|Intr|Int|Hold|Hldrq] {Enable|Disable}]",
	/*  80 */  "[[Nmi|Reset|Intr|Int|RQ0|RQ1] {Enable|Disable}]",
	/*  81 */  "[adr1 [adr2|Length length]]",
	/*  82 */  "adr1 {adr2|Length length} data",
	/*  83 */  "[Word] port [Length in-length]",
/*...*/	/*  84 */  "[Number|{S|I} [frame]|frame [abs1 abs2] [status] [trace-bits]]",
	/*  85 */  "[abs1 abs2 {I|IR|ID|E|ER|ED|G}]",
	/*  86 */  "[Intel|Nec[NAtive|Emulation]]",
	/*  87 */  "[Word] port data",
	/*  88 */  "[register]",
	/*  89 */  "[cs[:ip]]",
	/*  90 */  "[Byte|Word]",
	/*  91 */  "[adr]",
	/*  92 */  "[[Berr][Intr][BR]{Enable|Disable}]",
	/*  93 */  "[adr [SP|UP][Vector-Based value]|CLear]",
/*...*/	/*  94 */  "[Number|{S|I} [frame]|frame [adr1 adr2] [status] [trace-bits]]",
	/*  95 */  "[space-adr adr {{I|IR} {1|2|3|4|}|E|ER|G}|ALl {E|G}]",
	/*  96 */  "[pc [ssp]]",
	/*  97 */  "adr1 {adr2|Length length} [adr3]",
	/*  98 */  "[[Berr][Intr][BR][Cdis][Mmudis][CBack] {Enable|Disable}]",
	/*  99 */  "[register|FP-processor[fp-register]|MMu[mmu-register]]",
/*...*/	/* 100 */  "[[INT0][INT1][INT2][INT3][Nmi][DRQ0][DRQ1][Reset][Hold][Pereq]{E|D}]",
	/* 101 */  "(EMM) [abs1 abs2 {I|IR|E}|ALl E]    (HEMM) [abs1 abs2 {I|IR|E|ER|G}]",
	/* 102 */  "[Command|Queue]",
	/* 103 */  "[register|INternal [i-register]|COprocessor [co-register]]",
	/* 104 */  "[0|1|2|3|4|5]",
	/* 105 */  "[[Res][Stby][Nmi][IRQ1][Irq0][Breq]{Enable|Disable}]",
	/* 106 */  "[Wait]",
	/* 107 */  "port [Length in-length]",
/*...*/	/* 108 */  "[N|{S|I} [frame [BY {0|1}]]|[frame [abs1 abs2][status][trace-bits]]]",
	/* 109 */  "[abs1 abs2 {I|IR|IP|ID|E|ER|EP|ED|G}]",
	/* 110 */  "[Maximum {Rom|Norom}|MInimum {Rom|Norom}|Single-chip]",
	/* 111 */  "port data",
	/* 112 */  "[Dtc [d-register]|register|INternal [i-register [Bit [b-register]]]]",
	/* 113 */  "[cp [:pc]]",
/*...*/	/* 114 */  "[[1|2|3|4|5|6|7] [CLear]|{1|2|3|4|5|6|7} ... ]",
/*...*/	/* 115 */  "[[1|2|3|4|5|6] [CLear]|{1|2|3|4|5|6} ... ]",
/*...*/	/* 116 */  "[[1|2|3|4|5] [CLear]|{1|2|3|4|5} ... ]",
	/* 117 */  "[LOgical|Physical] adr1 {adr2|Length length} data",
	/* 118 */  "[LOgical|Physical] [adr [data]]",
	/* 119 */  "[LOgical|Physical] adr1 {adr2|Length length}",

	/*-------------------------  USD-III command argument  -------------------------*/

	/* 120 */  "[address]",
	/* 121 */  "[no1 [no2]]",
	/* 122 */  "%symbol hex_address",
	/* 123 */  "%symbol",
	/* 124 */  "[dos_command]",
	/* 125 */  "[Physical] [address [data-1 [...data-8]]]",
	/* 126 */  "filename",
	/* 127 */  "[number]",
	/* 128 */  "filename [(arg0,...,arg9)]",
	/* 129 */  "[Over] [count|FOrever]",
	/* 130 */  "[filename [APPEND]|CLOSE]",
	/* 131 */  "filename",
	/* 132 */  "[{Symbol|Log|Journal|Breakpoint} {ON|OFf}]",
	/* 133 */  "{[%%module]%symbol|hex_address}",
	/* 134 */  "{K1|K2|K3|K4|K5|K6|K7|K8|K9|K10} command_description",
	/* 135 */  "[All|Global|%%module]",
	/* 136 */  "[{Breakpoint|CODe|Register|Stack|Trace|Data} {ON|OFf}]",
	/* 137 */  "filename [I|T|M]",
	/* 138 */  "[W|K]",
	/* 139 */  "filename [UP|UD|SP|SD]",
	/* 140 */  "filename [P|R]",
	/* 141 */  "filename [UP|UD|SP|SD]",
	/* 142 */  "filename [I [X|P]|T [X|P]|M]",
	/* 143 */  "[{[%%module]%symbol|hex_address} [number] [Byte|Word|Long]]",
	/* 144 */  "filename",
	/* 145 */  "filename [PHY|LOG]",
	/* 146 */  "[0.1|1|10|100|1000]",
	/* 147 */  "[{[%%module]%symbol|address} [number [{Byte|Word|Long} [I|P|X]]]]",
	/* 148 */  "",
	/* 149 */  "",

	/*------------------------  MICE-III command argument  -------------------------*/

	/* 150 */  "[Physical] [adr]",
	/* 151 */  "[Physical] [adr [data]]",
	/* 152 */  "[Physical] adr1 {adr2|Length length}",
	/* 153 */  "[Physical] adr1 {adr2|Length length} adr3",
	/* 154 */  "[[Nmi][Reset][Intr][Hold][Pereq] {Enable|Disable}]",
	/* 155 */  "[Physical] adr1 {adr2|Length length} [adr3]",
	/* 156 */  "[Physical] [adr1 [adr2|Length length]]",
	/* 157 */  "[Protected]",
	/* 158 */  "adr [Idt.base abs]",
	/* 159 */  "[Physical] adr1 {adr2|Length length} data",
	/* 160 */  "[addr]",
	/* 161 */  "[BYte|Word] port [Length in-length]",
/*...*/	/* 162 */  "(EMM)[abs1 abs2{I|IR|E|C}|AL E](HEMM)[abs1 abs2{I|E|ER|G|C}|AL{E|G}]",
	/* 163 */  "[Real|Protected][Debug|Trace]",
	/* 164 */  "[BYte|Word] port data",
/*...*/	/* 165 */  "[[SR|TR|LDTR|register]|CO ...|DT ...|{GDT|IDT} ...|LDT ...|TSS ...]",
	/* 166 */  "[Physical] [adr] [DBIt 0|1]",
	/* 167 */  "[Physical] [adr1 [adr2|Length length]] [DBIt 0|1]",
	/* 168 */  "[Protected|PAging]",
	/* 169 */  "{[adr [Idt.base abs]]|CLear}",
	/* 170 */  "[BYte|Word|DWord|Long] port [Length in-length]",
/*...*/	/* 171 */  "[N|{S|I} [frame [BY {0|1|2|3}]]|[frame [abs1 abs2][status] ... ]]",
	/* 172 */  "[abs1 abs2 {I|IR|E}|ALl E]",
	/* 173 */  "[BYte|Word|DWord|Long] port data",
	/* 174 */  "[Enable|Disable]",
/*...*/	/* 175 */  "[[SR|TR|LDTR|CR|TSTR|register]|DT...|{GDT|IDT}...|LDT...|TSS...|..]",
	/* 176 */  "[BYte|Word|DWord|Long]",
	/* 177 */  "[LOgical|Physical]",
	/* 178 */  "[LOgical|Physical] [[[cbar]:[bbr]:[cbr]:]adr]",
	/* 179 */  "[O [Bbr|Cbr]|Bbr [O|Cbr]|Cbr [O|Bbr]]",
	/* 180 */  "[[Nmi] [Reset] [INT0] [INT1] [INT2] [Busreq] {Enable|Disable}]",
	/* 181 */  "[Nmi]",
	/* 182 */  "[LOgical|Physical] [[[cbar]:[bbr]:[cbr]:]adr1 [adr2|Length length]]",
	/* 183 */  "[adx [data] [status] [COunt count]|CLear]",
	/* 184 */  "[phy-adr|CLear]",
	/* 185 */  "[Run] [LOgical|Physical] [[[cbar]:[bbr]:[cbr]:]adr] [Nmi]",
	/* 186 */  "port1 [port2|Length length]",
	/* 187 */  "{?|[LOgical|Physical] [[cbar]:[bbr]:[cbr]:]adr}",
/*...*/	/* 188 */  "[N|{S|I} [frame]|[frame [phy-adr1 phy-adr2] [status] [trace-bits]]",
	/* 189 */  "[phy-adr1 phy-adr2 {I|E|IR|ER|P|PR|G}|ALl {E|G}]",
	/* 190 */  "MULtiplex",
	/* 191 */  "[register|INternal [i-register]]",
	/* 192 */  "[LOgical|Physical] [adr1 adr2 [CALl]|count|CALl]",
	/* 193 */  "[Internal] [adr [data]]",
	/* 194 */  "[Internal] adr1 {adr2|Length length}",
	/* 195 */  "[Internal] adr1 {adr2|Length length} [Internal] adr3",
	/* 196 */  "[[Nmi][Reset][Hldrq] {Enable|Disable}]",
	/* 197 */  "[Internal] adr1 {adr2|Length length} [[Internal] adr3]",
	/* 198 */  "[Internal] [adr1 [adr2|Length length]]",
	/* 199 */  "[Internal] adr1 {adr2|Length length} data",
	/* 200 */  "[abs1 abs2 {I|IR|ID|E|ER|ED|G|IP}]",
	/* 201 */  "[Nec|Intel]",
	/* 202 */  "[{[n] [register]|SFr [sfr]}]",
	/* 203 */  "[ps[:pc]]",
	/* 204 */  "[adx [data] [status]|CLear]",
	/* 205 */  "[<clock rate>]",
	/* 206 */  "[<logical state>]",
	/* 207 */  "[[<signal list>] {Enable|Disable}]",
	/* 208 */  "[<count>]",
	/* 209 */  "[<address> [<address>]|<logical state>]",
/*...*/	/* 210 */  "[CLear|<number> [<wildcard addr> [<status list> [<wildcard data>...",
	/* 211 */  "[<text>]",
	/* 212 */  "<port> [<count>]",
	/* 213 */  "<address>",
/*...*/	/* 214 */  "[<number>|<number>[<wildcard addr>[<status list>[<wildcard data>...",
	/* 215 */  "[<address> <address> <memory attributes> [RETi]]",
	/* 216 */  "[CLear|<wildcard addr> [<status list>]]",
	/* 217 */  "[Prime|<register> [<number>]]",
	/* 218 */  "[<trace time base>]",
	/* 219 */  "[LOgical|Physical] adr1 {adr2|Length length} adr3",

	/*-------------------------  MICE-II command argument  -------------------------*/

	/* 220 */  "[I|T|A]",
	/* 221 */  "[P|I|X] [a1[ a2[ d1[ d2[..d8]][ S]]]]",
	/* 222 */  "port d1[ d2[..d8]]",
	/* 223 */  "[B0|B1][A|0|1|2|3|4|5|6|7|T|P]",
	/* 224 */  "M|[P|I|X] a1 a2 S|M|a3[ V]",
	/* 225 */  "[address]",
	/* 226 */  "[I|B|N]",
	/* 227 */  "address",
	/* 228 */  "[a1[ a2[ d1[ d2[ ..d8]] [S]]]]",
	/* 229 */  "[P][A|B|C|D|E|H|L|I|F|X|Y|S]",
	/* 230 */  "[S|R[P]][c]|[Z]",
	/* 231 */  "[N|I|B|R]",
	/* 232 */  "port d1[ d2[...[ d8]]]",
	/* 233 */  "[R|X]",
	/* 234 */  "[P|X][a1[ a2[ d1[..d8]][S]]]",
	/* 235 */  "[Rn|Fflag]|G[a1[ a2[ d1[..d8]]]]|S[[0|1]a1]",
	/* 236 */  "[P|X]a1 a2 S|M|a3[ V]",
	/* 237 */  "[N|I|D|H|R]",
	/* 238 */  "[A|B|CC|DP|X|Y|U|S]",
	/* 239 */  "[[CS|DS|SS|ES|seg:]loc]",
	/* 240 */  "[N|H|I|D]",
	/* 241 */  "[AX|BX|CX|DX|SP|BP|SI|DI|DS|ES|SS|CS|IP|FS|I[[M]base[ o]]]",
	/* 242 */  "[N|H|I|P|R|W]",
	/* 243 */  "[N|H|I|P|R|W|D|T]",
	/* 244 */  "[W]port[ c[ time]]|DT=addr",
	/* 245 */  "[W][[CS|DS|SS|ES|seg:]a1[ a2[ d1[..d8]][S]]]|ODE [R|P]",
	/* 246 */  "[AX|BX|CX|DX|SP|BP|SI|DI|DS|ES|SS|CS|IP|MS|FS|GDT|IDT]",
	/* 247 */  "[I|R|X]",
	/* 248 */  "[P|G|W|a1[ a2[ d1[..d8]]]]",
	/* 249 */  "[R|X|A|S|P]",
	/* 250 */  "[[P|X|I][ a1[ a2[ d1[..d8][S]]]]|V[ a1[ a2[ d1[..d8] S]]]]",
	/* 251 */  "[S[ a1]|register|BIT[.symbol| a1[ a2[ d1[...d8]]]]|INT]",
	/* 252 */  "{[P|X|I] a1 a2 {S|M|a3[ V]}|V a1 a2 {S|a3[ V]}}",
	/* 253 */  "[V][ a1[ a2]]",
	/* 254 */  "[R|X|A]",
	/* 255 */  "[R|X|A|M {2|4|8|16}]",
	/* 256 */  "[S|register|BIT[.symbol| a1[ a2[ d1[...d8]]]]|INT]",
	/* 257 */  "[I|H|T]",
	/* 258 */  "[A|B|C|D|E|H|L|M|P|S]",
	/* 259 */  "[B]",
	/* 260 */  "[M]",
	/* 261 */  "[B|W|V]",
	/* 262 */  "[M[51[ S|E]|52[ S|E]|154]]",
	/* 263 */  "[B|P]",
	/* 264 */  "[M87|M287]",
	/* 265 */  "[ADDR1 ADDR2 I|IR|E|ER|G]|[E|D]",
	/* 266 */  "[0|1|2]",
	/*-------------------------  MICE-III 68302 command argument  ---------*/
	/* 267 */  "[register | Dumped int-reg | Internal]",
	/*-------------------------  MICE-III C186EB command argument	-------*/
	/* 268 */  "[[INT0][INT1][INT2][INT3][INT4][Nmi][Reset][Hold][Pereq]{E|D}]",
	/* 269 */  "",
	/* 270 */  "",
	/* 271 */  "",
	/* 272 */  "",
	/* 273 */  "",
	/* 274 */  "",
	/* 275 */  "",
	/* 276 */  "",
	/* 277 */  "",
	/* 278 */  "",
	/* 279 */  "",

	/*------------------------  MICE-III command argument  -------------------------*/

	/* 280 */  "[[Run] phy-adr|CLear]",
	/* 281 */  "[LOgical|Physical] adr1 {adr2|Length length} [adr3]",
	/* 282 */  "[LOgical|Physical] [adr1 [adr2|Length length]]",
	/* 283 */  "<port> <value list>",
	/* 284 */  "[CLear|<match sequence>]",
	/* 285 */  "[High|Low]",
	/* 286 */  "[<address>]",
	/* 287 */  "<address> {<address>|Length <length>}",
	/* 288 */  "<address> {<address>|Length <length>} <address>",
	/* 289 */  "<address> {<address>|Length <length>} [<address>]",
	/* 290 */  "[<count>|Wait]",
	/* 291 */  "<address> {<address>|Length <length>} <value list>",
	/* 292 */  "[<number>]",
	/* 293 */  "[<address> [<address>|Length <length>]]",
	/* 294 */  "[CALls|<count>|<address> <address>]",
	/* 295 */  "[GRoup {Emulation|Memory|Port|Setup|Trace}|command|ALl]",
	/* 296 */  "[System]",
	/* 297 */  "[{Route|DEVice} [code]]",
	/* 298 */  "[abs1 abs2 {I|IR|E|ER|G|C}]",
/*...*/	/* 299 */  "[CLear|[TImer {On|OFf}] [Trace {On|OFf}]| ... ]",
/*...*/	/* 300 */  "{Range adr1 adr2|adx} [datum] [status] [EX ext-bits] [CO count]",
	/* 301 */  "[CONditional] {High|Low}",
	/* 302 */  "[Run] [Physical] adr [fetch-state] [COunt count]",
	/* 303 */  "[Run] adr [fetch-state] [COunt count]",
	/* 304 */  "[Physical] adr [fetch-state]",
	/* 305 */  "adr [fetch-state]",
/*...*/	/* 306 */  "[[1|2|3|4|5|6|7|8] [CLear]|{1|2|3|4|5|6|7|8} ... ]",
	/* 307 */  "[adr1 adr2[CLear]|ENable|DIsable|CLear|Reset|List [adr]|SP|UP|SD|UD]",
	/* 308 */  "[adr1 adr2[CLear]|ENable|DIsable|CLear|Reset|List [adr]]",
	/* 309 */  "[{1|2} [{RA adr1 adr2|adx} [status] [EX trace-bits]]|[CL|DI|EN]]",
	/* 310 */  "[[1|2|3|4|5|6|7|8|9] [CLear]|{1|2|3|4|5|6|7|8|9} ... ]",
	/* 311 */  "[Mfm] [adr [data]]",
	/* 312 */  "[address [data-1 [...data-8]]]",
	/* 313 */  "[Mfm] adr1 {adr2|Length length} data",
	/* 314 */  "[timer-value [MS|Sec|Min]]",
	/* 315 */  "[ports]",
	/* 316 */  "adr [Length in-length]",
	/* 317 */  "[adr1 adr2 {C|CR|E|ER|G} | ALl {E|C}]",
	/* 318 */  "[Mfm] [adr1 [adr2|Length length]]",
	/* 319 */  "[Run] [pc]",
	/* 320 */  "pc",
	/* 321 */  "adr data",
	/* 322 */  "[[register] | [Sfr [sfr-reg]| [sfr-adr]]]",
	/* 323 */  "[pc [mode]]",
	/* 324 */  "[Mfm] adr1 {adr2|Length length}",
	/* 325 */  "[adr1 adr2[CLear]|ENable|DIsable|CLear|Reset|List [adr]|status]",
	/* 326 */  "[adr [Run] [COunt count]|CLear]"
};

/****************************************************************************/
/*									    */
/****************************************************************************/

ReadCmdWordFile()
{
 FILE  *CmdWordFilePtr;
 char  TmpStr[100], TmpFileName[20];
 int   MaxEntryNo, Len, i, j;

 if ( env.MICEGroup == MICE2 ) {

    if ( ( CmdWordFilePtr = fopen( "MICE2CMD.TXT", "rt" ) ) == NULL ) {

       ErrorCondition = CMDWORDFILE_OPEN_ERR;
       return( FALSE );	     
    }

    MaxEntryNo = 28;

 } else	{

    if ( ( CmdWordFilePtr = fopen( "MICE3CMD.TXT", "rt" ) ) == NULL ) {

       ErrorCondition = CMDWORDFILE_OPEN_ERR;
       return( FALSE );	     
    }

    MaxEntryNo = 25;
 }

 while ( fgets( TmpStr, 100, CmdWordFilePtr ) != NULL )

   if ( TmpStr[0] == ';' ) {

      sscanf( TmpStr+1, "%s", TmpFileName );
      if ( strcmp( TmpFileName, CmdWordFileName ) == 0 )  break;
   }

 while ( fgets( TmpStr, 100, CmdWordFilePtr ) != NULL )
   if ( strstr( TmpStr, "*COMMAND_WORD" ) != NULL )  break;

 fgets( TmpStr, 100, CmdWordFilePtr );

 for ( i = 0; i <= MaxEntryNo; i++ ) {

     fgets( TmpStr, 100, CmdWordFilePtr );
     Len = strlen( TmpStr );

     if ( ( Len > 0 ) && ( TmpStr[ Len - 1 ] == '\n' ) ) {

	TmpStr[ Len - 1 ] = '\0';
	Len--;
     }

     if ( Len > 4 ) {

     	if ( ( CmdWord[i][0] = malloc( Len - 3 ) ) == NULL ) {

	   for ( j = 0; j < i; j++ )  free( CmdWord[j][0] );
	   fclose( CmdWordFilePtr );
	   ErrorCondition = MEM_INSUFFICIENT;
	   return( FALSE );

     	} else  strcpy( CmdWord[i][0], TmpStr+4 );

     } else  CmdWord[i][0] = NULL;
 }

 while ( fgets( TmpStr, 100, CmdWordFilePtr ) != NULL )
   if ( strstr( TmpStr, "*COMMAND_ARGUMENT_INDEX" ) != NULL )  break;

 fgets( TmpStr, 100, CmdWordFilePtr );

 for ( i = 0; i <= MaxEntryNo; i++ ) {

     fgets( TmpStr, 100, CmdWordFilePtr );
     Len = strlen( TmpStr );

     if ( ( Len > 0 ) && ( TmpStr[ Len - 1 ] == '\n' ) ) {

	TmpStr[ Len - 1 ] = '\0';
	Len--;
     }

     if ( Len > 4 ) {

     	if ( ( CmdWord[i][1] = malloc( Len - 3 ) ) == NULL ) {

	   for ( j = 0; j <= 25; j++ )  free( CmdWord[j][0] );
	   for ( j = 0; j < i; j++ )  free( CmdWord[j][1] );
	   fclose( CmdWordFilePtr );
	   ErrorCondition = MEM_INSUFFICIENT;
	   return( FALSE );
     	} else 	strcpy( CmdWord[i][1], TmpStr+4 );

     } else  CmdWord[i][1] = NULL;
 }

 fclose( CmdWordFilePtr );
 return( TRUE ); 

} /*  of ReadCmdWordFile()  */

/****************************************************************************/
/*									    */
/****************************************************************************/

DisplayCmdWord( CmdBufIdx )
int  CmdBufIdx;
{
 char  c;
 int   i;  

 if ( !wn_isup( CmdHelpVP ) )  wn_up( CmdHelpVP );
 else  wn_clr( CmdHelpVP );

 i = ch_toupper( c = CmdBuf[ CmdWordChkIdx=CmdBufIdx ] ) - 'A';

 if ( ( env.MICEGroup == MICE2 ) && ( ( i < 0 ) || ( i > 25 ) ) ) {

    if	     ( c == '?' )  i = 26;
    else  if ( c == '!' )  i = 27;
    else  if ( c == '*' )  i = 28;
 }

 if ( ( ( ( env.MICEGroup == MICE2 ) && ( i >= 0 ) && ( i <= 28 ) ) ||
	( ( env.MICEGroup != MICE2 ) && ( i >= 0 ) && ( i <= 25 ) ) ) &&
      ( CmdWord[i][0] != NULL ) ) {

    CmdWordChk = 1;
    v_stpl( 0, 1, "COMMAND : ", CmdHelpVP );
    v_stpl( 0, 11, CmdWord[i][0], CmdHelpVP );

 } else {

    CmdWordChk = 2;
    v_stpl( 0, 1, "no matched command", CmdHelpVP );
 }

}  /*  of DisplayCmdWord()  */

/****************************************************************************/
/*									    */
/****************************************************************************/

DisplayCmdArgu( CmdBufIdx )
int  CmdBufIdx;
{
 char  TmpStr[100], InputCmdWord[20], *SrchCmdWord, *SrchCmdArgu;
 int   Match = 0, SrchCmdWordCount, EntryNo, i, j;
 char  c;

 CmdArguChk = 1;
 CmdArguChkIdx = CmdBufIdx;

 if ( CmdWordChk == 2 )  return;

 for ( i = CmdWordChkIdx, j = 0; (i<CmdArguChkIdx) && (j<19) ; i++, j++ )
     InputCmdWord[j] = CmdBuf[i];
 InputCmdWord[j] = '\0';

 EntryNo = ch_toupper( c = CmdBuf[CmdWordChkIdx] ) - 'A';

 if ( ( env.MICEGroup == MICE2 ) && ( ( EntryNo < 0 ) || ( EntryNo > 25 ) ) ) {

    if	     ( c == '?' )  EntryNo = 26;
    else  if ( c == '!' )  EntryNo = 27;
    else  if ( c == '*' )  EntryNo = 28;
 }

 strcpy( TmpStr, CmdWord[EntryNo][0] );
 SrchCmdWord = strtok( TmpStr, " " );

 for ( SrchCmdWordCount = 0 ; ; SrchCmdWordCount++ ) {

   if ( TestMatch( InputCmdWord, SrchCmdWord ) ) { Match = 1; break; }
   if ( ( SrchCmdWord = strtok( NULL, " " ) ) == NULL )  break;
 }

 wn_clr( CmdHelpVP );

 if ( Match ) {

    strcpy( TmpStr, CmdWord[EntryNo][1] );
    SrchCmdArgu = strtok( TmpStr, " " );

    for ( i = 0; i < SrchCmdWordCount; i++ )
	SrchCmdArgu = strtok( NULL, " " );
        if(SrchCmdArgu==NULL) return(29);         ////
    v_stpl( 0, 1, "ARGUMENT : ", CmdHelpVP );

        i =  atoi( SrchCmdArgu );            ////bug right here
    v_stpl( 0, 12, CmdArgu[i], CmdHelpVP );

 } else  v_stpl( 0, 1, "no matched command", CmdHelpVP );

}  /*  of DisplayCmdArgu()  */

/****************************************************************************/
/*									    */
/****************************************************************************/

TestMatch( InputCmdWord, SrchCmdWord )
char  *InputCmdWord, *SrchCmdWord;
{
 int  InputCmdWordLen, SrchCmdWordLen, i;

 if ( (InputCmdWordLen=strlen(InputCmdWord)) > (SrchCmdWordLen=strlen(SrchCmdWord)) )
    return( 0 );

 for ( i = 0; i < InputCmdWordLen; i++ )
   if ( ch_toupper( InputCmdWord[i] ) != ch_toupper( SrchCmdWord[i] ) )  return( 0 );

 if ( ( SrchCmdWord[InputCmdWordLen] == '\0' ) || ch_islower( SrchCmdWord[InputCmdWordLen] ) )
    return( 1 );
 else  return( 0 );

}  /*  of TestMatch()  */
