/****************************************************************************

MICROTEK International Inc., Copyright reserved.

Product:      CONV3  --  USD-III
Module:       CONV3.C
Engineer:     Amy Wang
Description:  the main program of CONV3

Record of Changes:
nnn: by who, MM/DD/YY, descriptions

001:
*****************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <malloc.h>
#include <io.h>
#include <ctype.h>
#include <fcntl.h>
#include <string.h>
#include <search.h>
#include <errno.h>
#include <dos.h>
#include <signal.h>
#include "uco11.h"

/*----------------------------------------------------------------------*/
int (*call)();
int ErrorOut();
int omf86();
int omf51();
int omf85();
int ad2500();
int omf2386();
int InterTools();
int mri68k51z80();
int mri64180();
int sysrof();


/**********************************************************************/
/***** main(): the converter main program                         *****/
/**********************************************************************/

main(argc,argv)
int argc;
char *argv[];
{
        int i;
        unsigned char format;

        printf("CONV3 Version 2.3d -- Microtek International Inc.\n");
        printf("Copyright (c) 1992, 1993, 1994.   All rights reserved.\n\n");


        ProcessCmdLine(argc,argv);
        for (i=0; i < inputFileCnt; i++) {
           if ((fdin=open( fnin[i], O_RDONLY | O_BINARY)) == -1) {
              prn_exit("Error opening input file!\n");
           }
           lseek(fdin, 0L, 0 );
           read(fdin,temp,3);
           inputFileInx = i;
           if (inputFileInx > 0 && temp[0] != format)
              prn_exit("Input files with inconsistant formats!\n");
           format = temp[0];
           switch( format )  {
                case OMF86:
                        if (!inputFileInx) {
                           att.addrunit = AddrUnit = 4;
                           att.absflag = AbsFlag = 1;
                           call = omf86;
                           OpenTempFile(2);
                        }
                        break;

                case OMF51_START:
                        if (!inputFileInx) {
                           att.addrunit = AddrUnit = 2;
                           att.absflag = AbsFlag = 0;
                           OpenTempFile(2);
                        }
                        memcpy(&i,&temp[1],2);
                        read(fdin,temp1,i);
                        if (temp1[i-3] == 0) call = omf85;
                        else call = omf51;
                        break;

                case BOOT_286:
                        if (!inputFileInx) {
                           att.addrunit = AddrUnit = 4;
                           att.absflag = AbsFlag = 1;
                           call = omf2386;
                           OpenTempFile(2);
                        }
                        break;

                case BOOT_386:
                        if (!inputFileInx) {
                           att.addrunit = AddrUnit = 6;
                           att.absflag = AbsFlag = 1;
                           yes386 = 1;
                           call = omf2386;
                           OpenTempFile(2);
                        }
                        break;

                case AD2500_START:
                        if (!inputFileInx) {
                           call = ad2500;
                           OpenTempFile(1);
                        }
                        break;

                case SYSROF_CS1:
                case SYSROF_CS2:
                        if (!inputFileInx) {
                           call = sysrof;
                           OpenTempFile(2);
                        }
                        break;

                case MRI_68K_51_Z80:
                        close(fdin);
                        fdin=0;
                        if (!inputFileInx) {
                           call = mri68k51z80;
                           OpenTempFile(1);
                        }
                        break;

                case MRI64180:
                        close(fdin);
                        fdin=0;
                        if (!inputFileInx) {
                           att.addrunit = AddrUnit = 3;
                           att.absflag = AbsFlag = 0;
                           call = mri64180;
                           OpenTempFile(1);
                        }
                        break;

                case SPACE:
                        close(fdin);
                        fdin=0;
                        if (!inputFileInx) OpenTempFile(1);
                        CheckMRIFormat(i);
                        break;

                case INTERTOOL_START:
                        if (!strncmp(temp,".id",3)) {
                           close(fdin);
                           fdin=0;
                           call = InterTools;
                           if (!inputFileInx) OpenTempFile(2);
                           break;
                        }
                default:
                        prn_exit("Invalid data file!\n");
                        break;
           } /* end switch */
           (*call)();
           if (fdin) close(fdin);
        }
        NormalExit();
        printf("%s is converted OK!\n",fnsy);
        exit(0);
}

