/*--------------------------------------------------------------------------*/
/*  display.c								    */
/*--------------------------------------------------------------------------*/


#include  "system.h"
#include  "usd3.h"
#include  "gblext.h"
#include  "oldext.h"
#include  "usym1.h"
#include  "usym3.h"
#include  "funcext.h"
#include  "cpucode.h"

#define  CEP_Z8			4
#define  EPZ_ZS8		7

#define  CEP4_8048		5

#define  CEP5_8050		6
#define  EP51_80515		10
#define  EP53_80515		10
#define  EP8031			16
#define  EP8032			16
#define  EP8051			16
#define  EP8052			16
#define  EP8044			16
#define  EP8344			16
#define  EP80C51		16
#define  EP80154		16
#define  EP83154		16
#define  EP80C152		16
#define  EP83C152		16

#define  E68000			26
#define  E68010			28

#define  E68008			27

#define  EP68HC11		29

#define  MICE8_Z80_V1		31
#define  MICE8_Z80_V2		36
#define  CICE8_Z80_V2		36

#define  MICE16_68000		32
#define  CICE16_68000		32
#define  MICE16_68010		32
#define  CICE16_68010		32

#define  MICE32_68020		35 
#define  CICE_68020		35
#define  CICE32_68020		35
#define  MICE32_68030 		35
#define  CICE_68030		35
#define  CICE32_68030		35

#define  MICE32_80386		33
#define  CICE_80386		33
#define  CICE32_80386		33

#define  MICE8_64180		34
#define  CICE8_64180		34

#define  MICE16_80286		41
#define  CICE_80286		41
#define  CICE16_80286		41

/****************************************************************************/
/*  display a character at the viewport 'VPOut'				    */
/****************************************************************************/

DisplayCh( Ch )
unsigned char  Ch;
{
 disableRS232();

 JournalCh( Ch );

 switch ( Ch ) {

   case  CR	  : VP[VPOut].Ptr->c = 0;
		    csr_plwn( VP[VPOut].Ptr );

		    break;

   case  LF	  : v_ch( LF, VP[VPOut].Ptr );

		    if ( VP[VPOut].Ptr->r > VP[VPOut].Maxr )
		       wn_scrl( 1, UP, VP[VPOut].Ptr );

		    break;

   case  BS	  :
   case  DEL	  :
   case  KEY_DEL  : if ( VP[VPOut].Ptr->c == 0 ) {

		       if ( ( --( VP[VPOut].Ptr->r ) ) < 0 ) {

			  ++( VP[VPOut].Ptr->r );
			  break;
		       }

		       VP[VPOut].Ptr->c = VP[VPOut].Maxc;

		       if ( VP[VPOut].Ptr->row_org > VP[VPOut].Ptr->r ) {

			  wn_msadj( VP[VPOut].Ptr );
			  wn_upd( VP[VPOut].Ptr );
		       }

		       v_ch( ' ', VP[VPOut].Ptr );
		       --( VP[VPOut].Ptr->r );
		       VP[VPOut].Ptr->c = VP[VPOut].Maxc;

		    } else {

		       --( VP[VPOut].Ptr->c );

		       if ( VP[VPOut].Ptr->col_org > VP[VPOut].Ptr->c ) {

			  wn_msadj( VP[VPOut].Ptr );
			  wn_upd( VP[VPOut].Ptr );
		       }

		       v_ch( ' ', VP[VPOut].Ptr );
		       --( VP[VPOut].Ptr->c );
		    }

		    csr_plwn( VP[VPOut].Ptr );

		    break;

   default	  : v_ch( Ch, VP[VPOut].Ptr );

		    break;

 }  /*  of switch ( Ch )  */

 enableRS232();

}  /*  of DisplayCh()  */

/****************************************************************************/
/*  display a string at the viewport 'VPOut'				    */
/****************************************************************************/

DisplayStr( Str )
unsigned char  *Str;
{
 char  *Tmp;

 disableRS232();

 JournalStr( Str );

 while ( ( Tmp = strchr( Str, CR ) ) != NULL ) {

   *Tmp = '\0';
   v_st( Str, VP[VPOut].Ptr );
   VP[VPOut].Ptr->c = 0;
   csr_plwn( VP[VPOut].Ptr );
   *Tmp = CR;
   Str = Tmp + 1;
 }

 v_st( Str, VP[VPOut].Ptr );

 if ( VP[VPOut].Ptr->r > VP[VPOut].Maxr )
    wn_scrl( 1, UP, VP[VPOut].Ptr );

 enableRS232();

}  /*  of DisplayStr()  */

/****************************************************************************/
/*  display a character at indicated position of the viewport 'VPOut'	    */
/****************************************************************************/

DisplayPosCh( Row, Col, Ch )
int   Row, Col;
unsigned char  Ch;
{
 char  Str[2];

 disableRS232();

 Str[0] = Ch;
 Str[1] = '\0';

 sw_opt( CLRENDROW, OFF, VP[VPOut].Ptr );

 v_stpl( ( Row + VP[VPOut].Ptr->row_org ), ( Col + VP[VPOut].Ptr->col_org ),
	 Str, VP[VPOut].Ptr );

 sw_opt( CLRENDROW, ON, VP[VPOut].Ptr );

 enableRS232();

}  /*  of DisplayPosCh()  */

/****************************************************************************/
/*  display a string at indicated position of the viewport 'VPOut'	    */
/****************************************************************************/

DisplayPosStr( Row, Col, Str )
int   Row, Col;
unsigned char  *Str;
{
 disableRS232();

 sw_opt( CLRENDROW, OFF, VP[VPOut].Ptr );

 v_stpl( ( Row + VP[VPOut].Ptr->row_org ), ( Col + VP[VPOut].Ptr->col_org ),
	 Str, VP[VPOut].Ptr );

 sw_opt( CLRENDROW, ON, VP[VPOut].Ptr );

 enableRS232();

}  /*  of DisplayPosStr()  */

/****************************************************************************/
/*  display command cursor '_'						    */
/****************************************************************************/

DisplayCMDCURSOR()
{
 csr_plwn( VP[COMVP].Ptr );

}  /*  of DisplayCMDCURSOR()  */

/****************************************************************************/
/*  erase command cursor '_'						    */
/****************************************************************************/

EraseCMDCURSOR()
{
}  /*  of EraseCMDCURSOR()  */

/****************************************************************************/
/*  mark the source line that software breakpoint is set		    */
/****************************************************************************/

MarkBKPT( Bufy, BKPTSign )
int   Bufy;
char  BKPTSign;
{
 char  Str[2];

 Str[0] = BKPTSign;
 Str[1] = '\0';

 v_stpl( Bufy, 0, Str, VP[CODVP].Ptr );

}  /*  of MarkBKPT()  */

/****************************************************************************/
/*  mark the source line that current PC indicates			    */
/****************************************************************************/

MarkPC( Bufy )
int  Bufy;
{
 if ( CurrentPC >= 0 )  /*  clear the original PC-indicated line  */

    v_chattrow( CurrentPC, 0,
		' ', COLOR( VP[CODVP].TextColor, VP[CODVP].BackgrndColor ),
		ENDROW, ATT, VP[CODVP].Ptr );

 /*  update current PC 'CurrentPC'  */

 if ( ( CurrentPC = Bufy ) < 0 )  return;

 /*  mark the new PC-indicated line  */

/* CORE 90.08.014 */

#ifdef NEC_PC9801

 v_chattrow( CurrentPC, 0, ' ', LBLA_BLU, ENDROW, ATT, VP[CODVP].Ptr );

#else

 v_chattrow( CurrentPC, 0,
	     ' ', COLOR( VP[CODVP].BackgrndColor, VP[CODVP].TextColor ),
	     ENDROW, ATT, VP[CODVP].Ptr );

#endif

}  /*  of MarkPC()  */

/****************************************************************************/
/*  scroll the source line that current PC indicates to the top		    */
/****************************************************************************/

NewPCPage( Topy )
int  Topy;
{
 char  Str[2];
 int   Oldc;

 /*  redraw the CODE viewport  */

 sw_msorg( Topy, VP[CODVP].Ptr->col_org, VP[CODVP].Ptr );
 wn_upd( VP[CODVP].Ptr );

 /*  mark the source line that current PC indicates  */

 VP[CODVP].Ptr->r = Topy;
 Oldc = VP[CODVP].Ptr->c;
 VP[CODVP].Ptr->c = LABELINDENT;
 v_stcpy( Str, FROM_WN, CH, VP[CODVP].Ptr );

 if ( ishex( Str[0] ) )  MarkPC( Topy );

 else {

   VP[CODVP].Ptr->r = Topy + 1;
   v_stcpy( Str, FROM_WN, CH, VP[CODVP].Ptr );

   if ( ishex( Str[0] ) )  MarkPC( Topy + 1 );
 }

 VP[CODVP].Ptr->r = Topy;  /*  for scrolling  */
 VP[CODVP].Ptr->c = Oldc;  /*  for scrolling  */

}  /*  of NewPCPage()  */

/****************************************************************************/
/*  update the contents of viewports according to the flag 'RedrawFlag'	    */
/****************************************************************************/

UpdateVP()
{
 if ( wn_isup( VP[REGVP].Ptr ) && ( RedrawFlag & REDRAWREG ) &&
      ( ! ( MaskRedrawFlag & REDRAWREG ) ) )  UpdateREGVP();

 if ( wn_isup( VP[CODVP].Ptr ) && ( RedrawFlag & REDRAWCOD ) &&
      ( ! ( MaskRedrawFlag & REDRAWCOD ) ) )  UpdateCODVP();
 else  if ( RedrawFlag & REDRAWCOD )  GetPC(&PC);

 if ( wn_isup( VP[STAVP].Ptr ) && ( RedrawFlag & REDRAWSTA ) &&
      ( ! ( MaskRedrawFlag & REDRAWSTA ) ) )  UpdateSTAVP();

 if ( wn_isup( VP[BREVP].Ptr ) && ( RedrawFlag & REDRAWBRE ) &&
      ( ! ( MaskRedrawFlag & REDRAWBRE ) ) )  UpdateBREVP( 0 );

 if ( wn_isup( VP[TRAVP].Ptr ) && ( RedrawFlag & REDRAWTRA ) &&
      ( ! ( MaskRedrawFlag & REDRAWTRA ) ) )  UpdateTRAVP( 0 );

 if ( wn_isup( VP[DATVP].Ptr ) && ( RedrawFlag & REDRAWDAT ) &&
      ( ! ( MaskRedrawFlag & REDRAWDAT ) ) )  UpdateDATVP();

 RedrawFlag = 0L;

}  /*  of UpdateVP()  */

/****************************************************************************/
/*  update the contents of the REGISTER viewport			    */
/****************************************************************************/

UpdateREGVP()
{
 static int  KnowRow = FALSE;  /*  indicate whether the rows needed to show
				   registers are known			     */
 static int  LFCount;	       /*  rows needed to show registers	     */
 static int  WarningMsg = 0;   /*  0 : no warning message,
				   1 : has warning message		     */
 char	     RowBuf[ REGBUFCOL + 1 ];
 int	     Bufx, i, Oldr;

 v_titleatt( " ........ ", 0, VP[REGVP].Ptr );

 do_1_cmd_save( "R", MICEBuf, ( MICEBUFSIZE + 1 ) );

 if ( ( strchr(MICEBuf,EXCL)!=NULL ) || ( strstr(MICEBuf,"step")!=NULL ) ||
      ( strstr(MICEBuf,"halt")!=NULL ) ) {

    /*  can't get REGISTER information  */

    WarningMsg = 1;
    VPOut = REGVP;
    DisplayPosStr( VP[REGVP].Height - 3, 0,
		   " ( Warning! Cannot update REGISTER viewport. )" );
    DisplayPosStr( VP[REGVP].Height - 3, 46,
		   "                                              " );
    v_titleatt( NULLP, 0, VP[REGVP].Ptr );
    send_ESC();

    return;

 } else  if ( WarningMsg == 1 ) {

	    WarningMsg = 0;
	    VPOut = REGVP;
	    DisplayPosStr( VP[REGVP].Height - 3, 0,
			   "                                              " );
 	 }

 if ( ! KnowRow ) {  /*  count the rows needed to show registers  */

    KnowRow = TRUE;
    LFCount = i = 0;

    while ( MICEBuf[i] != '\0' ) {

	  if  ( MICEBuf[i] == LF )  LFCount++;
	  i++;
    }
 }

 /*  modify the display buffer of the REGISTER viewport  */

 sw_opt( WNECHO, OFF, VP[REGVP].Ptr );

 Oldr = VP[REGVP].Ptr->r;

 for ( i = 0,  Bufx = 0, VP[REGVP].Ptr->r = 0; VP[REGVP].Ptr->r < LFCount; i++, Bufx = 0, VP[REGVP].Ptr->r++ ) {

     /*  if ( i == 0 && env.Mmodel == MICE16_80286 ) i = 1;  */

     while ( MICEBuf[i] != LF ) {

       if ( MICEBuf[i] != CR ) {
	  if ( Bufx < REGBUFCOL )  RowBuf[Bufx++] = MICEBuf[i];
       } else {
	  /*  if ( env.Mmodel == MICE16_80286 )  i++;  */
       }

       i++;
     }

     for ( ; Bufx < REGBUFCOL; )  RowBuf[Bufx++] = ' ';
     v_stcpy( RowBuf, TO_WN, ROW, VP[REGVP].Ptr );
 }

 /*  redraw the REGISTER viewport  */

 sw_opt( WNECHO, ON, VP[REGVP].Ptr );
 if ( VP[REGVP].Ptr->row_org >= REGVPLine )
    sw_msorg( VP[REGVP].Ptr->r = 0, VP[REGVP].Ptr->col_org, VP[REGVP].Ptr );
 else  VP[REGVP].Ptr->r = Oldr;
 wn_upd( VP[REGVP].Ptr );

 v_titleatt( NULLP, 0, VP[REGVP].Ptr );

}  /*  of UpdateREGVP()  */

/****************************************************************************/
/*  update the contents of the CODE viewport				    */
/****************************************************************************/

UpdateCODVP()
{
 static int  WarningMsg = 0;		   /*  0 : no warning message,
					       1 : has warning message	      */
 char	     RowBuf[ CODBUFCOL + 1 ];
 int	     Bufx, r, i, Oldc;

 v_titleatt( " .... ", 0, VP[CODVP].Ptr );

 /*  clear the original PC-indicated line  */

 if ( CurrentPC >= 0 )  MarkPC( -1 );

 /*  set the data that will be displayed at the CODE viewport to CODBuf[0][]  */ 

 if ( SetCodeVPData() == FAIL ) {  /*  can't get the CODE information  */

    WarningMsg = 1;
    VPOut = CODVP;
    DisplayPosStr( VP[CODVP].Height - 3, 0,
		   " ( Warning! Cannot update CODE viewport. )" );
    DisplayPosStr( VP[CODVP].Height - 3, 42,
		   "                                          " );
    v_titleatt( NULLP, 0, VP[CODVP].Ptr );

    return;

 } else  if ( WarningMsg == 1 ) {

	    WarningMsg = 0;
	    VPOut = CODVP;
	    DisplayPosStr( VP[CODVP].Height - 3, 0,
			   "                                          " );
 	 }

 /*  erase the display buffer of the CODE viewport  */

 sw_opt( WNECHO, OFF, VP[CODVP].Ptr );

 ms_clr( VP[CODVP].Buf );

 /*  modify the display buffer of the CODE viewport  */

 for ( Bufx = 0; Bufx < CODVPINDENT; Bufx++ )  RowBuf[Bufx] = ' ';

 for ( i = 0,  Bufx = CODVPINDENT, VP[CODVP].Ptr->r = 0; VP[CODVP].Ptr->r < CODBUFROW; i++, Bufx = CODVPINDENT, VP[CODVP].Ptr->r++ ) {

     while ( ( CODBuf[0][i] != LF ) && ( CODBuf[0][i] != '\0' ) ) {

       if ( CODBuf[0][i] != CR )
	  if ( Bufx < CODBUFCOL )  RowBuf[Bufx++] = CODBuf[0][i];

       i++;
     }

     for ( ; Bufx < CODBUFCOL; )  RowBuf[Bufx++] = ' ';
     v_stcpy( RowBuf, TO_WN, ROW, VP[CODVP].Ptr );

     if ( CODBuf[0][i] == '\0' )  break;
 }

 SetBKPTinCodeVP();

 /*  redraw the CODE viewport  */

 sw_opt( WNECHO, ON, VP[CODVP].Ptr );
 sw_msorg( 0, VP[CODVP].Ptr->col_org, VP[CODVP].Ptr );
 wn_upd( VP[CODVP].Ptr );
 GetCodeVPRange( ALL );

 /*  mark the source line that current PC indicates  */

 Oldc = VP[CODVP].Ptr->c;
 VP[CODVP].Ptr->c = LABELINDENT;

 for ( r = 1; r <= 5; r++ ) {

   VP[CODVP].Ptr->r = r;
   v_stcpy( RowBuf, FROM_WN, CH, VP[CODVP].Ptr );
   if ( ishex( RowBuf[0] ) ) { MarkPC(r); break; }
 }

 CODBufAddr[1][0] = '\0';

 for ( r = CODBUFROW - 1; r >= CODBUFROW - 2; r-- ) {

   VP[CODVP].Ptr->r = r;
   v_stcpy( RowBuf, FROM_WN, ROW, VP[CODVP].Ptr );

   if ( ishex( RowBuf[LABELINDENT] ) ) {

      sscanf( &(RowBuf[LABELINDENT]), "%s", CODBufAddr[1] );
      break;
   }
 }

 VP[CODVP].Ptr->r = 0;	   /*  for scrolling  */
 VP[CODVP].Ptr->c = Oldc;  /*  for scrolling  */

 v_titleatt( NULLP, 0, VP[CODVP].Ptr );

}  /*  of UpdateCODVP()  */

/****************************************************************************/
/*									    */
/****************************************************************************/

GetPrevCodePage()
{
 static int  WarningMsg = 0;		   /*  0 : no warning message,
					       1 : has warning message	      */
 char	     RowBuf[ CODBUFCOL + 1 ];
 int	     Bufx, r, i, Oldc;

 if ( CurrentCODBuf <= 0 )  return( 0 );

 v_titleatt( " .... ", 0, VP[CODVP].Ptr );

 /*  clear the original PC-indicated line  */

// if ( CurrentPC >= 0 )  MarkPC( -1 );

 /*  set the data that will be displayed at the CODE viewport to CODBuf[CurrentCODBuf][]  */

 CurrentCODBuf--;

 /*  erase the display buffer of the CODE viewport  */

 sw_opt( WNECHO, OFF, VP[CODVP].Ptr );

 ms_clr( VP[CODVP].Buf );

 /*  modify the display buffer of the CODE viewport  */

 for ( Bufx = 0; Bufx < CODVPINDENT; Bufx++ )  RowBuf[Bufx] = ' ';

 for ( i = 0,  Bufx = CODVPINDENT, VP[CODVP].Ptr->r = 0; VP[CODVP].Ptr->r < CODBUFROW; i++, Bufx = CODVPINDENT, VP[CODVP].Ptr->r++ ) {

     while ( ( CODBuf[CurrentCODBuf][i] != LF ) && ( CODBuf[CurrentCODBuf][i] != '\0' ) ) {

       if ( CODBuf[CurrentCODBuf][i] != CR )
	  if ( Bufx < CODBUFCOL )  RowBuf[Bufx++] = CODBuf[CurrentCODBuf][i];

       i++;
     }

     for ( ; Bufx < CODBUFCOL; )  RowBuf[Bufx++] = ' ';
     v_stcpy( RowBuf, TO_WN, ROW, VP[CODVP].Ptr );

     if ( CODBuf[CurrentCODBuf][i] == '\0' )  break;
 }

 SetBKPTinCodeVP();

 /*  redraw the CODE viewport  */

 sw_opt( WNECHO, ON, VP[CODVP].Ptr );
 sw_msorg( 0, VP[CODVP].Ptr->col_org, VP[CODVP].Ptr );
 wn_upd( VP[CODVP].Ptr );
 GetCodeVPRange( ALL );

 /*  mark the source line that current PC indicates  */

 Oldc = VP[CODVP].Ptr->c;
 VP[CODVP].Ptr->c = LABELINDENT;

 if ( CurrentCODBuf == 0 )  MarkPC(CurrentPC);

// for ( r = 1; r <= 5; r++ ) {
//
//   VP[CODVP].Ptr->r = r;
//   v_stcpy( RowBuf, FROM_WN, CH, VP[CODVP].Ptr );
//   if ( ishex( RowBuf[0] ) ) { MarkPC(r); break; }
// }
//
// CODBufAddr[CurrentCODBuf+1][0] = '\0';
//
// for ( r = CODBUFROW - 1; r >= CODBUFROW - 2; r-- ) {
//
//   VP[CODVP].Ptr->r = r;
//   v_stcpy( RowBuf, FROM_WN, ROW, VP[CODVP].Ptr );
//
//   if ( ishex( RowBuf[LABELINDENT] ) ) {
//
//      sscanf( &(RowBuf[LABELINDENT]), "%s", CODBufAddr[CurrentCODBuf+1] );
//      break;
//   }
// }

 VP[CODVP].Ptr->r = 0;	   /*  for scrolling  */
 VP[CODVP].Ptr->c = Oldc;  /*  for scrolling  */

 v_titleatt( NULLP, 0, VP[CODVP].Ptr );

}  /*  of GetPrevCodePage()  */

/****************************************************************************/
/*									    */
/****************************************************************************/

GetNextCodePage()
{
 static int  WarningMsg = 0;		   /*  0 : no warning message,
					       1 : has warning message	      */
 char	     RowBuf[ CODBUFCOL + 1 ];
 int	     Bufx, r, i, Oldc;

 if ( ( CurrentCODBuf < 0 ) || ( CurrentCODBuf >= ( CODBUFNUM - 1 ) ) ||
      ( CODBufAddr[CurrentCODBuf+1][0] == '\0' ) )  return( 0 );

 v_titleatt( " .... ", 0, VP[CODVP].Ptr );

 /*  clear the original PC-indicated line  */

// if ( CurrentPC >= 0 )  MarkPC( -1 );

 /*  set the data that will be displayed at the CODE viewport to CODBuf[CurrentCODBuf][]  */

 if ( ++CurrentCODBuf > LastCODBuf ) {

    LastCODBuf++;

    if ( SetCodeVPData1() == FAIL ) {  /*  can't get the CODE information  */

       v_titleatt( NULLP, 0, VP[CODVP].Ptr );
       return( 0 );
    }
 }

 /*  erase the display buffer of the CODE viewport  */

 sw_opt( WNECHO, OFF, VP[CODVP].Ptr );

 ms_clr( VP[CODVP].Buf );

 /*  modify the display buffer of the CODE viewport  */

 for ( Bufx = 0; Bufx < CODVPINDENT; Bufx++ )  RowBuf[Bufx] = ' ';

 for ( i = 0,  Bufx = CODVPINDENT, VP[CODVP].Ptr->r = 0; VP[CODVP].Ptr->r < CODBUFROW; i++, Bufx = CODVPINDENT, VP[CODVP].Ptr->r++ ) {

     while ( ( CODBuf[CurrentCODBuf][i] != LF ) && ( CODBuf[CurrentCODBuf][i] != '\0' ) ) {

       if ( CODBuf[CurrentCODBuf][i] != CR )
	  if ( Bufx < CODBUFCOL )  RowBuf[Bufx++] = CODBuf[CurrentCODBuf][i];

       i++;
     }

     for ( ; Bufx < CODBUFCOL; )  RowBuf[Bufx++] = ' ';
     v_stcpy( RowBuf, TO_WN, ROW, VP[CODVP].Ptr );

     if ( CODBuf[CurrentCODBuf][i] == '\0' )  break;
 }

 SetBKPTinCodeVP();

 /*  redraw the CODE viewport  */

 sw_opt( WNECHO, ON, VP[CODVP].Ptr );
 sw_msorg( 0, VP[CODVP].Ptr->col_org, VP[CODVP].Ptr );
 wn_upd( VP[CODVP].Ptr );
 GetCodeVPRange( ALL );

 /*  mark the source line that current PC indicates  */

 Oldc = VP[CODVP].Ptr->c;
 VP[CODVP].Ptr->c = LABELINDENT;

// for ( r = 1; r <= 5; r++ ) {
//
//   VP[CODVP].Ptr->r = r;
//   v_stcpy( RowBuf, FROM_WN, CH, VP[CODVP].Ptr );
//   if ( ishex( RowBuf[0] ) ) { MarkPC(r); break; }
// }

 CODBufAddr[CurrentCODBuf+1][0] = '\0';

 for ( r = CODBUFROW - 1; r >= CODBUFROW - 2; r-- ) {

   VP[CODVP].Ptr->r = r;
   v_stcpy( RowBuf, FROM_WN, ROW, VP[CODVP].Ptr );

   if ( ishex( RowBuf[LABELINDENT] ) ) {

      sscanf( &(RowBuf[LABELINDENT]), "%s", CODBufAddr[CurrentCODBuf+1] );
      break;
   }
 }

 VP[CODVP].Ptr->r = 0;	   /*  for scrolling  */
 VP[CODVP].Ptr->c = Oldc;  /*  for scrolling  */

 v_titleatt( NULLP, 0, VP[CODVP].Ptr );

}  /*  of GetNextCodePage()  */

/****************************************************************************/
/*  update the contents of the STACK viewport				    */
/****************************************************************************/

UpdateSTAVP()
{
 static int  WarningMsg = 0;  /*  0 : no warning message,
				  1 : has warning message  */
 char	     SPH[10], SPL[10], SPValue[15], SSSP[30];
 char	     Addr[30], Data[10];
 char	     RowBuf[ STABUFCOL + 1 ];
 int	     PMode, SSPOrUSP, ISPOrMSPOrUSP;
 int	     Bufx, Len, i;
 char	     c, *ptr;

 v_titleatt( " ..... ", 0, VP[STAVP].Ptr );

 /*  get the value of the stack pointer  */

 do_1_cmd_save( env.sp, MICEBuf, ( MICEBUFSIZE + 1 ) );

 switch ( env.Mmodel ) {

   case  CEP_Z8		:
   case  EPZ_ZS8	: sscanf( MICEBuf, "%*s %s", SPH );
			  do_1_cmd_save( "", MICEBuf, ( MICEBUFSIZE + 1 ) );
			  sscanf( MICEBuf, "%*s %s", SPL );
			  strcpy( SPValue, SPH );
			  strcat( SPValue, SPL );

			  break;

   case  CEP4_8048	: break;

   case  CEP5_8050	:
/* case  EP51_80515	:
*/ case  EP53_80515	:
/* case  EP8031		:
   case  EP8032		:
   case  EP8051		:
   case  EP8052		:
   case  EP8044		:
   case  EP8344		:
   case  EP80C51	:
   case  EP80154	:
   case  EP83154	:
   case  EP80C152	:
*/ case  EP83C152	: sscanf( MICEBuf, "%*s %*s %s", SPValue );

			  break;

   case  E68000		:
   case  E68010		: sscanf( MICEBuf, "%*3s %1d", &SSPOrUSP );
			  send_ESC();
			  if ( ( SSPOrUSP & (int) 2 ) == 2 )
			     do_1_cmd_save( "R SP", MICEBuf, ( MICEBUFSIZE + 1 ) );
			  else  do_1_cmd_save( "R UP", MICEBuf, ( MICEBUFSIZE + 1 ) );
			  sscanf( MICEBuf, "%*5s %s", SPValue );

			  break;

/* case  MICE16_68000	:
   case  CICE16_68000	:
   case  MICE16_68010	:
*/ case  CICE16_68010	: if ( strchr( MICEBuf, EXCL ) == NULL )
			     sscanf( MICEBuf, "%*s %s", SPValue );
			  else {
			     send_ESC();
			     do_1_cmd_save( "R SR", MICEBuf, ( MICEBUFSIZE + 1 ) );
			     sscanf( MICEBuf, "%*3s %1d", &SSPOrUSP );
			     send_ESC();
			     if ( SSPOrUSP == 2 )
			        do_1_cmd_save( "R SSP", MICEBuf, ( MICEBUFSIZE + 1 ) );
			     else  do_1_cmd_save( "R USP", MICEBuf, ( MICEBUFSIZE + 1 ) );
			         sscanf( MICEBuf, "%*s %*2s %s", SPValue );
			  }

			  break;

/* case  MICE32_68020	:
   case  CICE_68020	:
   case  CICE32_68020	:
   case  MICE32_68030 	:
   case  CICE_68030	:
*/ case  CICE32_68030	: if ( strchr( MICEBuf, EXCL ) == NULL )
			     sscanf( MICEBuf, "%*s %s", SPValue );
			  else {
			     send_ESC();
			     do_1_cmd_save( "R SR", MICEBuf, ( MICEBUFSIZE + 1 ) );
			     sscanf( MICEBuf, "%*3s %1d", &ISPOrMSPOrUSP );
			     send_ESC();
			     if ( ISPOrMSPOrUSP == 2 )
			        do_1_cmd_save( "R ISP", MICEBuf, ( MICEBUFSIZE + 1 ) );
			     else  if ( ISPOrMSPOrUSP == 3 )
			        do_1_cmd_save( "R MSP", MICEBuf, ( MICEBUFSIZE + 1 ) );
			     else  do_1_cmd_save( "R USP", MICEBuf, ( MICEBUFSIZE + 1 ) );
			     sscanf( MICEBuf, "%*s %s", SPValue );
			  }

			  break;

   case  E68008		: sscanf( MICEBuf, "%*s %*3s %s", SPValue );

			  break;

   case  EP68HC11	: sscanf( MICEBuf, "%*s %s", SPH );
			  do_1_cmd_save( "", MICEBuf, ( MICEBUFSIZE + 1 ) );
			  sscanf( MICEBuf, "%*s %s", SPL );
			  strcpy( SPValue, SPH );
			  strcat( SPValue, SPL );

			  break;

   case  MICE8_Z80_V1	:
/* case  MICE8_Z80_V2	:
*/ case  CICE8_Z80_V2	: sscanf( MICEBuf, "%*s %*s %*s %*s %s", SPValue );

			  break;

/* case  MICE8_64180	:
*/ case  CICE8_64180	: sscanf( MICEBuf, "%*s %*s %s", SPValue );

			  break;

   default		: sscanf( MICEBuf, "%*s %s", SPValue );

			  break;
 }

 send_ESC();

 if ( ( env.Mmodel == MICE32_80386 ) || ( env.Mmodel == MICE16_80286 ) ) {

    /*  or CICE_80386, CICE32_80386, CICE_80286, CICE16_80286  */

    PMode =  ChkMode();
    strcpy( SSSP, env.ss );
    strcat( SSSP, SPValue );
    do_1_cmd_save( SSSP, MICEBuf, ( MICEBUFSIZE + 1 ) );
    if ( PMode == 0 )  /*  real mode  */
       sscanf( MICEBuf, "%s %s", Addr, Data );
    else  /*  protected mode  */
       if ( env.Mmodel == MICE32_80386 )
	  sscanf( MICEBuf, "%*s %*s %s %s", Addr, Data );
       else  sscanf( MICEBuf, "%*s %*s %*s %*s %s %s", Addr, Data );

 } else {

    strcpy( SSSP, env.ss );
    if ( env.Mmodel != CEP4_8048 )  strcat( SSSP, SPValue );
    do_1_cmd_save( SSSP, MICEBuf, ( MICEBUFSIZE + 1 ) );

    switch ( env.Mmodel ) {

      case  CEP4_8048	 : sscanf( MICEBuf, "%*2s %s %s", Addr, Data );

			   break;

      case  MICE8_Z80_V1 :
/*    case  MICE8_Z80_V2 :
*/    case  CICE8_Z80_V2 : sscanf( MICEBuf, "%*s %*s %*s %s %s", Addr, Data );

			   break;

/*    case  MICE8_64180	 :
*/    case  CICE8_64180	 : sscanf( MICEBuf, "%*s %s %s", Addr, Data );

			   break;

      default		 : sscanf( MICEBuf, "%s %s", Addr, Data );

			   break;

    }  /*  of switch ( env.Mmodel )  */

 }

 for ( Len = strlen( Addr ), i = 0; i < Len; i++ )

     if ( ! ishex( Addr[i] ) ) {  /*  can't get the STACK information  */

	WarningMsg = 1;
	VPOut = STAVP;
	DisplayPosStr( VP[STAVP].Height - 3, 0,
		       " ( Warning! Cannot update STACK viewport. )" );
	DisplayPosStr( VP[STAVP].Height - 3, 43,
		       "                                           " );
	v_titleatt( NULLP, 0, VP[STAVP].Ptr );
	send_ESC();

	return;
     }
     
 if ( WarningMsg == 1 ) {

    WarningMsg = 0;
    VPOut = STAVP;
    DisplayPosStr( VP[STAVP].Height - 3, 0,
		   "                                           " );
 }

 /*  modify the display buffer of the STACK viewport  */

 sw_opt( WNECHO, OFF, VP[STAVP].Ptr );

 for ( i = 0; i < STABUFCOL; i++ )  RowBuf[i] = ' ';

 Addr[Len] = EQUAL;
 Addr[ Len + 1 ] = '\0';
 strcpy( RowBuf, "SP->" );
 strcat( RowBuf, Addr );
 strcat( RowBuf, Data );

 /*  change '\0' to be SP  */

 if ( env.Maddrid < 3 )

    if ( env.Mmodel == CEP4_8048 )
       RowBuf[ env.Mcsiplen+6 ] = SP;
    else  RowBuf[ env.Mcsiplen+7 ] = SP;

 else
 
    if ( ( env.Mmodel == MICE8_64180 ) || ( env.Mmodel == E68008 ) )
       RowBuf[ env.Mcsiplen+6 ] = SP;
    else  RowBuf[ env.Mcsiplen+9 ] = SP;

 VP[STAVP].Ptr->r = VP[STAVP].Maxr;
 v_stcpy( RowBuf, TO_WN, ROW, VP[STAVP].Ptr );

 for ( VP[STAVP].Ptr->r = VP[STAVP].Maxr - 1; VP[STAVP].Ptr->r > VP[STAVP].Maxr - StaBufRow; VP[STAVP].Ptr->r-- ) {

     if ( ( env.Mmodel == EP83C152 ) || ( env.Mmodel == EP53_80515 ) || ( env.Mmodel == CEP5_8050 ) || ( env.Mmodel == CEP4_8048 ) ) {

	ptr = MICEBuf;
	send( LF );
	while ( ( (c=receive()) != CR ) && ( c != LF ) );
	while ( ( (c=receive()) == CR ) || ( c == LF ) || !c );
	while ( (c=receive()) != HAND_SHAKE )  if (c)  *ptr++ = c;
	*ptr = '\0';

     } else  do_1_cmd_save( "", MICEBuf, ( MICEBUFSIZE + 1 ) );

     if ( ( ( env.Mmodel==MICE32_80386 ) || ( env.Mmodel==MICE16_80286 ) ) &&
	  ( (strchr(MICEBuf,EXCL)!=NULL) || (strchr(MICEBuf,',')!=NULL) ) ) {

        /*  or CICE_80386, CICE32_80386, CICE_80286, CICE16_80286  */

	ms_clr( VP[STAVP].Buf );

        break;
     }

     if ( env.Mmodel == CEP4_8048 )
	sscanf( MICEBuf, "%*2s %s %s", Addr, Data );
     else  if ( env.Mmodel == MICE8_64180 )
	      sscanf( MICEBuf, "%*s %s %s", Addr, Data );
	   else  sscanf( MICEBuf, "%s %s", Addr, Data );

     Addr[Len] = EQUAL;
     Addr[ Len + 1 ] = '\0';
     strcpy( RowBuf, "    " );
     strcat( RowBuf, Addr );
     strcat( RowBuf, Data );

     /*  change '\0' to be SP  */

     if ( env.Maddrid < 3 )

	if ( env.Mmodel == CEP4_8048 )
	   RowBuf[ env.Mcsiplen+6 ] = SP;
	else  RowBuf[ env.Mcsiplen+7 ] = SP;

     else

	if ( ( env.Mmodel == MICE8_64180 ) || ( env.Mmodel == E68008 ) )
	   RowBuf[ env.Mcsiplen+6 ] = SP;
	else  RowBuf[ env.Mcsiplen+9 ] = SP;

     v_stcpy( RowBuf, TO_WN, ROW, VP[STAVP].Ptr );

     if ( ( env.Mmodel == CEP4_8048 ) && ( VP[STAVP].Ptr->r==(VP[STAVP].Maxr-15) ) )  break;
 }

 send_ESC();

 /*  redraw the STACK viewport  */

 sw_opt( WNECHO, ON, VP[STAVP].Ptr );
 sw_msorg( ( VP[STAVP].Ptr->r = VP[STAVP].Maxr ) - VP[STAVP].Height + 3, VP[STAVP].Ptr->col_org, VP[STAVP].Ptr );
 wn_upd( VP[STAVP].Ptr );

 v_titleatt( NULLP, 0, VP[STAVP].Ptr );

}  /*  of UpdateSTAVP()  */

/****************************************************************************/
/*  update the contents of the BREAKPOINT viewport			    */
/****************************************************************************/

UpdateBREVP( PageFlag )
int  PageFlag;			     /*  0          : current page,
					 BREVP_PREV : previous page,
					 BREVP_NEXT : next page	      */
{
 static int	CurrentPage = 0;  /*  indicate the page that is displayed at
				      the BREAKPOINT viewport currently	    */
 char		RowBuf[ BREBUFCOL + 1 ];
 unsigned char  adr1[6], Symbol[41];
 int		Bufx, i, j, k, l, m, Oldr;

 v_titleatt( " BREAKPOINT ", 0, VP[BREVP].Ptr );

 /*  get the number of the page that will be displayed at the BREAKPOINT
     viewport								  */

 switch ( PageFlag ) {

   case  0	    : if ( ( ( CurrentPage * (2*BREBUFROW) + 1 ) > BreakNumber ) ||
			   ( ( (CurrentPage+1) * (2*BREBUFROW) ) < BreakNumber ) ) {

			 if ( BreakNumber <= (2*BREBUFROW) )  CurrentPage = 0;
			 else  CurrentPage = ( BreakNumber - 1 ) / (2*BREBUFROW);

			 sw_msorg( VP[BREVP].Ptr->r = 0, VP[BREVP].Ptr->col_org, VP[BREVP].Ptr );
		      }

		      break;

   case  BREVP_PREV : if ( CurrentPage == 0 ) {

			 v_titleatt( NULLP, 0, VP[BREVP].Ptr );
			 return( 0 );

		      } else {

			 CurrentPage--;
			 sw_msorg( VP[BREVP].Ptr->r = 0, VP[BREVP].Ptr->col_org, VP[BREVP].Ptr );
		      }

		      break;

   case  BREVP_NEXT : if ( ( (CurrentPage+1) * (2*BREBUFROW) + 1 ) > BreakNumber ) {

			 v_titleatt( NULLP, 0, VP[BREVP].Ptr );
			 return( 0 );

		      } else {

			 CurrentPage++;
			 sw_msorg( VP[BREVP].Ptr->r = 0, VP[BREVP].Ptr->col_org, VP[BREVP].Ptr );
		      }

		      break;

   default	    : v_titleatt( NULLP, 0, VP[BREVP].Ptr );

		      return( 0 );
 }

 /*  erase the display buffer of the BREAKPOINT viewport  */

 sw_opt( WNECHO, OFF, VP[BREVP].Ptr );

 ms_clr( VP[BREVP].Buf );

 /*  modify the display buffer of the BREAKPOINT viewport  */

 RowBuf[0] = ' ';
 Oldr = VP[BREVP].Ptr->r;

 for ( i = (CurrentPage*(2*BREBUFROW)), VP[BREVP].Ptr->r = 0; VP[BREVP].Ptr->r < BREBUFROW; i++, VP[BREVP].Ptr->r++ ) {

     /*  fill the left margin  */

     if ( SwBreak[i].exists == 0 )  break;

     /*  fill the "number" field of the software breakpoint  */

     j = i + 1;

     if ( j < 10 ) {

	itoa( j, RowBuf + 1, 10 );
	strcpy( RowBuf + 2, ".   " );

     } else  if ( j < 100 ) {

		itoa( j, RowBuf + 1, 10 );
		strcpy( RowBuf + 3, ".  " );

	     } else {

		itoa( j, RowBuf + 1, 10 );
		strcpy( RowBuf + 4, ". " );
	     }

     /*  fill the "address" field of the software breakpoint  */

     for ( l=env.Maddrunit-1, k=0; l>=0; l--, k+=8 )
	 adr1[l] = ( SwBreak[i].address >> k ) & 0xff;
     adr_ascii( adr1, env.Maddrunit, RowBuf + 6 );

     /*  fill the "symbol" field of the software breakpoint  */

     if ( SwBreak[i].sym[0] != '\0' ) {

	strcpy( Symbol, SwBreak[i].sym );
	Symbol[18] = '\0';
	strcat( RowBuf, "  " );
	strcat( RowBuf, Symbol );
     }

     for ( Bufx = strlen(RowBuf) ; Bufx <= 39; )  RowBuf[Bufx++] = ' ';
     RowBuf[40] = '\0';

     /*  fill the right margin  */

     if ( SwBreak[++i].exists == 0 )  goto CopyToWindowBuf;

     /*  fill the "number" field of the software breakpoint  */

     j = i + 1;

     if ( j < 10 ) {

	itoa( j, RowBuf + 40, 10 );
	strcpy( RowBuf + 41, ".   " );

     } else  if ( j < 100 ) {

		itoa( j, RowBuf + 40, 10 );
		strcpy( RowBuf + 42, ".  " );

	     } else {

		itoa( j, RowBuf + 40, 10 );
		strcpy( RowBuf + 43, ". " );
	     }

     /*  fill the "address" field of the software breakpoint  */

     for ( l=env.Maddrunit-1, k=0; l>=0; l--, k+=8 )
	 adr1[l] = ( SwBreak[i].address >> k ) & 0xff;
     adr_ascii( adr1, env.Maddrunit, RowBuf + 45 );

     /*  fill the "symbol" field of the software breakpoint  */

     if ( SwBreak[i].sym[0] != '\0' ) {

	strcpy( Symbol, SwBreak[i].sym );
	Symbol[18] = '\0';
	strcat( RowBuf, "  " );
	strcat( RowBuf, Symbol );
     }

     /*  copy RowBuf[] to the display buffer of the BREAKPOINT viewport  */

     CopyToWindowBuf:

     for ( Bufx = strlen(RowBuf) ; Bufx < BREBUFCOL; )  RowBuf[Bufx++] = ' ';
     v_stcpy( RowBuf, TO_WN, ROW, VP[BREVP].Ptr );

     if ( SwBreak[i].exists == 0 )  break;
 }

 /*  redraw the BREAKPOINT viewport  */

 sw_opt( WNECHO, ON, VP[BREVP].Ptr );
 VP[BREVP].Ptr->r = Oldr;
 wn_upd( VP[BREVP].Ptr );

 v_titleatt( NULLP, 0, VP[BREVP].Ptr );

 return( 1 );

}  /*  of UpdateBREVP()  */

/****************************************************************************/
/*  update the contents of the TRACE viewport				    */
/****************************************************************************/

UpdateTRAVP( PageFlag )
int  PageFlag;		      /*  0          : frame 0,
				  TRAVP_PREV : previous page,
				  TRAVP_NEXT : next page        */
{
 static int  WarningMsg = 0;  /*  0 : no warning message,
				  1 : has warning message		 */
 char	     RowBuf[ TRABUFCOL + 1 ];
 int	     Bufx, i;

 v_titleatt( " ..... ", 0, VP[TRAVP].Ptr );

 /*  set the data that will be displayed at the TRACE viewport to MICEBuf[]  */ 

 if ( SetTraceVPData(PageFlag)==FAIL ) { /*  can't get the TRACE information  */

    WarningMsg = 1;
    VPOut = TRAVP;
    DisplayPosStr( VP[TRAVP].Height - 3, 0,
		   " ( Warning! Cannot update TRACE viewport. )" );
    DisplayPosStr( VP[TRAVP].Height - 3, 43,
		   "                                           " );
    v_titleatt( NULLP, 0, VP[TRAVP].Ptr );

    return;

 } else  if ( WarningMsg == 1 ) {

	    WarningMsg = 0;
	    VPOut = TRAVP;
	    DisplayPosStr( VP[TRAVP].Height - 3, 0,
			   "                                           " );
	 }

 if ( ( PageFlag != 0 ) && ( MICEBuf[0] == '\0' ) ) {

    v_titleatt( NULLP, 0, VP[TRAVP].Ptr );

    return;
 }

 /*  erase the display buffer of the TRACE viewport  */

 sw_opt( WNECHO, OFF, VP[TRAVP].Ptr );

 ms_clr( VP[TRAVP].Buf );

 /*  modify the display buffer of the TRACE viewport  */

 for ( i = 0,  Bufx = 0, VP[TRAVP].Ptr->r = 0; VP[TRAVP].Ptr->r < TRABUFROW; i++, Bufx = 0, VP[TRAVP].Ptr->r++ ) {

     while ( ( MICEBuf[i] != LF ) && ( MICEBuf[i] != '\0' ) ) {

       if ( MICEBuf[i] != CR )
	  if ( Bufx < TRABUFCOL )  RowBuf[Bufx++] = MICEBuf[i];

       i++;
     }

     for ( ; Bufx < TRABUFCOL; )  RowBuf[Bufx++] = ' ';
     v_stcpy( RowBuf, TO_WN, ROW, VP[TRAVP].Ptr );

     if ( MICEBuf[i] == '\0' )  break;
 }

 /*  redraw the TRACE viewport  */

 sw_opt( WNECHO, ON, VP[TRAVP].Ptr );
 sw_msorg( VP[TRAVP].Ptr->r = 0, VP[TRAVP].Ptr->col_org, VP[TRAVP].Ptr );
 wn_upd( VP[TRAVP].Ptr );

 v_titleatt( NULLP, 0, VP[TRAVP].Ptr );

}  /*  of UpdateTRAVP()  */

/****************************************************************************/
/*									    */
/****************************************************************************/

GetPrevPage( dummyptr )
KEYCTRLPTR  dummyptr;
{
 if ( ActVP == BREVP ) {

    if ( UpdateBREVP( BREVP_PREV ) )  csr_mvwn( 0, 0, VP[BREVP].Ptr );
    else  csr_plwn( VP[BREVP].Ptr );

/* CORE 90.08.10 Change Arrow Charactor */
#ifdef NEC_PC9801
    v_titleatt( "     \036\037     ", 0, VP[BREVP].Ptr );
#else
    v_titleatt( "     \030\031     ", 0, VP[BREVP].Ptr );
#endif

 } else  if ( ActVP == TRAVP ) {

    if ( UpdateTRAVP( TRAVP_PREV ) )  csr_mvwn( 0, 0, VP[TRAVP].Ptr );
    else  csr_plwn( VP[TRAVP].Ptr );

/* CORE 90.08.10 Change Arrow Charactor */
#ifdef NEC_PC9801
    v_titleatt( "  \036\037   ", 0, VP[TRAVP].Ptr );
#else
    v_titleatt( "  \030\031   ", 0, VP[TRAVP].Ptr );
#endif

 } else  if ( ActVP == CODVP ) {

    if ( GetPrevCodePage() )  csr_mvwn( 0, 0, VP[CODVP].Ptr );
    else  csr_plwn( VP[CODVP].Ptr );

/* CORE 90.08.10 Change Arrow Charactor */
#ifdef NEC_PC9801
    v_titleatt( "  \036\037  ", 0, VP[CODVP].Ptr );
#else
    v_titleatt( " \030\031\033\032 ", 0, VP[CODVP].Ptr );
#endif

 } else  csr_plwn( VP[ActVP].Ptr );

}  /*  GetPrevPage()  */

/****************************************************************************/
/*									    */
/****************************************************************************/

GetNextPage( dummyptr )
KEYCTRLPTR  dummyptr;
{
 if ( ActVP == BREVP ) {

    if ( UpdateBREVP( BREVP_NEXT ) )  csr_mvwn( 0, 0, VP[BREVP].Ptr );
    else  csr_plwn( VP[BREVP].Ptr );

/* CORE 90.08.10 Change Arrow Charactor */
#ifdef NEC_PC9801
    v_titleatt( "     \036\037     ", 0, VP[BREVP].Ptr );
#else
    v_titleatt( "     \030\031     ", 0, VP[BREVP].Ptr );
#endif

 } else  if ( ActVP == TRAVP ) {

    if ( UpdateTRAVP( TRAVP_NEXT ) )  csr_mvwn( 0, 0, VP[TRAVP].Ptr );
    else  csr_plwn( VP[TRAVP].Ptr );

/* CORE 90.08.10 Change Arrow Charactor */
#ifdef NEC_PC9801
    v_titleatt( "  \036\037   ", 0, VP[TRAVP].Ptr );
#else
    v_titleatt( "  \030\031   ", 0, VP[TRAVP].Ptr );
#endif

 } else  if ( ActVP == CODVP ) {

    if ( GetNextCodePage() )  csr_mvwn( 0, 0, VP[CODVP].Ptr );
    else  csr_plwn( VP[CODVP].Ptr );

/* CORE 90.08.10 Change Arrow Charactor */
#ifdef NEC_PC9801
    v_titleatt( "  \036\037  ", 0, VP[CODVP].Ptr );
#else
    v_titleatt( " \030\031\033\032 ", 0, VP[CODVP].Ptr );
#endif

 } else  csr_plwn( VP[ActVP].Ptr );

}  /*  GetNextPage()  */

/****************************************************************************/
/*  update the contents of the DATA viewport				    */
/****************************************************************************/

UpdateDATVP()
{
 char  RowBuf[ DATBUFCOL + 1 ], Cmd[30], TmpData1[30], TmpData2[30], *DataPtr;
 int   RefEntry, CRCount, Bufx, i, j, Oldr;

 v_titleatt( " .... ", 0, VP[DATVP].Ptr );

 /*  erase the display buffer of the DATA viewport  */

 sw_opt( WNECHO, OFF, VP[DATVP].Ptr );

 ms_clr( VP[DATVP].Buf );

 /*  modify the display buffer of the DATA viewport  */

 Oldr = VP[DATVP].Ptr->r;

 for ( i = 0, VP[DATVP].Ptr->r = 0; i < NextMonVarEntry; i++, VP[DATVP].Ptr->r++ ) {

   /*  fill number  */

   if ( MonVar[i].Num > 0 ) {

      if ( MonVar[i].Num < 10 ) {

         itoa( MonVar[i].Num, RowBuf, 10 );
         strcpy( RowBuf + 1, ".  " );

      } else  if ( MonVar[i].Num < 100 ) {

		 itoa( MonVar[i].Num, RowBuf, 10 );
		 strcpy( RowBuf + 2, ". " );
	      }

   } else  RowBuf[0] = RowBuf[1] = RowBuf[2] = ' ';

   /*  fill symbol or address  */

   if ( MonVar[i].Num != 0 ) {

      RefEntry = i;

      if ( MonVar[i].Sym[0] != '\0' ) {

	 j = strlen( MonVar[i].Sym );
	 strcpy( RowBuf + 4, MonVar[i].Sym );

      } else {

	 j = strlen( MonVar[i].Addr );
	 strcpy( RowBuf + 4, MonVar[i].Addr );
      }

	if (env.CpuCode == M8051) {
		if (!(MonVar[i].Type&0xf0)) strcpy(RowBuf+j+4, " (I)");
		else if ((MonVar[i].Type&0xf0) == 0x10) strcpy(RowBuf+j+4, " (P)");
		else strcpy(RowBuf+j+4, " (X)");
		j += 4;
	}

      for ( Bufx = 4 + j; Bufx <= 20; Bufx++ )  RowBuf[Bufx] = ' ';
      RowBuf[21] = '=';
      RowBuf[22] = ' ';

   } else {

      RowBuf[17] = '+';
      j = i - RefEntry;

      if ( j < 10 ) {

         itoa( j, RowBuf + 18, 10 );
         RowBuf[19] = ' ';

      } else {

         itoa( j, RowBuf + 18, 10 );
         RowBuf[20] = ' ';
      }
   }

   /*  fill data  */

   if ( MonVar[i].Num != 0 ) {

      send_ESC();

      if ( ( env.Mmodel < MICE_3_BOUND ) || ( env.Mmodel == MICE8_Z80_V1 ) ||
	   ( env.Mmodel == MICE8_Z80_V2 ) ) { /* MonVar[i].Num != 0, MICE-II */

 	 CRCount = MonVar[i].Type&0xf;
 	 if (CRCount == 2) CRCount=3;

	 if ( ( env.Mmodel == MICE8_Z80_V1 ) || ( env.Mmodel == MICE8_Z80_V2 ) )
	    strcpy( Cmd, "MO " );
	 else  if (env.CpuCode != M8051) strcpy( Cmd, "M " );
	 else {
	 	if (!(MonVar[i].Type&0xf0)) strcpy(Cmd, "M I ");
	 	else if ((MonVar[i].Type&0xf0) == 0x10) strcpy(Cmd, "M ");
	 	else if ((MonVar[i].Type&0xf0) == 0x20) strcpy(Cmd, "M X ");
	 }

 	 strcat( Cmd, MonVar[i].Addr );
 	 do_1_cmd_save( Cmd, MICEBuf, ( MICEBUFSIZE + 1 ) );
 	 GetMonVarData( MICEBuf, &DataPtr );

	 if ( env.Maddrid == 4 ) {

 	    if ( DataPtr != NULL )  strcpy( TmpData1, DataPtr );
 	    else  strcpy( TmpData1, "?" );

 	    for ( j = 1; j <= CRCount; j++ ) {

 	      do_1_cmd_save( "", MICEBuf, ( MICEBUFSIZE + 1 ) );
 	      GetMonVarData( MICEBuf, &DataPtr );

 	      if ( DataPtr != NULL ) {
		 strcat( DataPtr, TmpData1 );
		 strcpy( TmpData1, DataPtr );
 	      } else {
		 strcpy( TmpData2, TmpData1 );
		 strcpy( TmpData1, "?" );
		 strcat( TmpData1, TmpData2 );
	      }
 	    }

 	    strcpy( RowBuf + 23, TmpData1 );

	 } else {

 	    if ( DataPtr != NULL )  strcpy( RowBuf + 23, DataPtr );
 	    else  strcpy( RowBuf + 23, "?" );

 	    for ( j = 1; j <= CRCount; j++ ) {

 	      do_1_cmd_save( "", MICEBuf, ( MICEBUFSIZE + 1 ) );
 	      GetMonVarData( MICEBuf, &DataPtr );

 	      if ( DataPtr != NULL )  strcat( RowBuf, DataPtr );
 	      else  strcat( RowBuf, "?" );
 	    }
	 }

      } else {  /*  MonVar[i].Num != 0, MICE-III  */

 	 if ( MonVar[i].Type == 0 )  strcpy( Cmd, "B " );
 	 else  if ( MonVar[i].Type == 1 )  strcpy( Cmd, "W " );
 	 else  strcpy( Cmd, "LO " );

 	 strcat( Cmd, MonVar[i].Addr );
 	 do_1_cmd_save( Cmd, MICEBuf, ( MICEBUFSIZE + 1 ) );
 	 GetMonVarData( MICEBuf, &DataPtr );

 	 if ( DataPtr != NULL )  strcpy( RowBuf + 23, DataPtr );
 	 else  strcpy( RowBuf + 23, "?" );
      }

   } else {  /*  MonVar[i].Num == 0  */

      if ( ( env.Mmodel < MICE_3_BOUND ) || ( env.Mmodel == MICE8_Z80_V1 ) ||
	   ( env.Mmodel == MICE8_Z80_V2 ) ) { /* MonVar[i].Num == 0, MICE-II */

	 if ( env.Maddrid == 4 ) {

	    TmpData1[0] = '\0';

 	    for ( j = 0; j <= CRCount; j++ ) {

 	      do_1_cmd_save( "", MICEBuf, ( MICEBUFSIZE + 1 ) );
 	      GetMonVarData( MICEBuf, &DataPtr );

 	      if ( DataPtr != NULL ) {
		 strcat( DataPtr, TmpData1 );
		 strcpy( TmpData1, DataPtr );
 	      } else {
		 strcpy( TmpData2, TmpData1 );
		 strcpy( TmpData1, "?" );
		 strcat( TmpData1, TmpData2 );
	      }
 	    }

 	    strcpy( RowBuf + 23, TmpData1 );

	 } else {

	    RowBuf[23] = '\0';

	    for ( j = 0; j <= CRCount; j++ ) {

	      do_1_cmd_save( "", MICEBuf, ( MICEBUFSIZE + 1 ) );
	      GetMonVarData( MICEBuf, &DataPtr );

	      if ( DataPtr != NULL )  strcat( RowBuf, DataPtr );
	      else  strcat( RowBuf, "?" );
	    }
	 }

      } else {  /*  MonVar[i].Num == 0, MICE-III  */

	 do_1_cmd_save( "", MICEBuf, ( MICEBUFSIZE + 1 ) );
	 GetMonVarData( MICEBuf, &DataPtr );

	 if ( DataPtr != NULL )  strcpy( RowBuf + 23, DataPtr );
	 else  strcpy( RowBuf + 23, "?" );
      }
   }

   for ( Bufx = strlen( RowBuf ); Bufx < DATBUFCOL; )  RowBuf[Bufx++] = ' ';
   v_stcpy( RowBuf, TO_WN, ROW, VP[DATVP].Ptr );

 }  /*  of for ( i = 0, VP[DATVP].Ptr->r = 0; ... )  */

 send_ESC();

 /*  redraw the DATA viewport  */

 sw_opt( WNECHO, ON, VP[DATVP].Ptr );
 VP[DATVP].Ptr->r = Oldr;
 wn_upd( VP[DATVP].Ptr );

 TimeDelayinSec( 1.0 );
 v_titleatt( NULLP, 0, VP[DATVP].Ptr );

}  /*  of UpdateDATVP()  */

/****************************************************************************/
/*									    */
/****************************************************************************/

GetMonVarData( MICEBuf, DataPtr )
char *MICEBuf, **DataPtr;
{
 char  *Ptr;
 int   i;

 *DataPtr = NULL;
 if ( ( i = strlen( MICEBuf ) ) == 0 )  return;

 for ( i--; i >= 0; i-- )
   if ( isxdigit( MICEBuf[i] ) )  break;
   else  if ( !isspace( MICEBuf[i] ) )  return;
	 else  MICEBuf[i] = '\0';

 if ( i < 0 )  return;

 for ( i--; i >= 0; i-- )
   if ( !isxdigit( MICEBuf[i] ) )  break;

 *DataPtr = &( MICEBuf[i+1] );
}
