/******************************
      pageseg = e_pageseg ;
	  e_NX e_NY
*******************************/
#include <stdio.h>
#include <ctype.h>
#include <fcntl.h>
#include <graph.h>
#include <process.h>
#include <memory.h>
#include <dos.h>
#include "egf.h"
#include "msc.h"

#define e_NX	8
#define e_NY	14
#define	PAGE0	1
#define CHR_WID	5
#define DSW_LEN	12
#define DSW_WID	6
#define WHITE	3
#define	BLACK	0
#define NOC	3
#define NX	8
#define NY	13
#define MIN(a,b)	((a<b)?a:b)
#define MAX(a,b)	((a>b)?a:b)
#define REPL_BLACK	0
#define XOR_BLACK	0x80
#define REPL_WHITE	0x7f
#define XOR_WHITE	0xff

int color_d;
int patsize;
unsigned char BITARRAY[8] = { 1,2,4,8,16,32,64,128 };
unsigned char BIT2[8] = { 0x00,0x80,0xc0,0xe0,0xf0,0xf8,0xfc,0xfe };

unsigned char mskl[8] = {0,0x80,0xc0,0xe0,0xf0,0xf8,0xfc,0xfe } ;
unsigned char mask1[8] = {1,2,4,8,16,32,64,128 } ;
unsigned char mask2[8] = {0x00,0x80,0xc0,0xe0,0xf0,0xf8,0xfc,0xfe } ;
unsigned char c_mskr[8] = {0x03,0x01,0x00,0x7f,0x3f,0x1f,0x0f,0x07 } ;
char *LINE[] = {
"                      Welcome  to",
"            Universal  Symbolic  Debugger",
"                      Version 2.6",
"(C) 1986, 1987, 1988, 1989, 1990 Microtek International Inc."
};
unsigned char pattern[1056];
int lineno, datacnt;

int (*(linedraw))();
int (*(tmode))();
int (*(gmode))();
int (*(gh_clrwindow))();
int (*(gh_color))();
int (*(gh_grachar))();
int (*(gh_dischar))();
int (*(gh_grastring))();
int (*(gh_prtdotln))();
int (*(gh_cur_blk))();
int (*(SPA_cmp))();
int (*(SPA_inc))();

unsigned int DISTANCE=0;
int SPA_Y1=0, SPA_Y2=0, SPA_Y3=0, SPA_Y4=0, diff1=0, DIFF=0;
unsigned int H_X=0, L_H, H_Y1, H_Y, H_Y2, M_Y1, M_Y2, F_Y1=0, F_Y2=0;
unsigned int h_flag ;
unsigned aoffset;

char F_SPA[]=".Software Performance Analysis";
char SPA[] ="  Entry   Module Ex-Time                                                  Quit\n\r  <F1>    <F2>    <F3>                                                    <F10>";
int error_flag=0;
int global=0;
int FOUR_OR_TWO, seri86=0;
unsigned char arrow2[5][11] = {
       { 0x00,0x08,0x1c,0x3e,0x08,0x08,0x08,0x08,0x08,0x08,0x00 },
       { 0x00,0x10,0x10,0x10,0x10,0x10,0x10,0x7e,0x38,0x10,0x00 },
       { 0x00,0x00,0x04,0x06,0xff,0x06,0x04,0x00,0x00,0x00,0x00 },
       { 0x00,0x00,0x20,0x60,0xff,0x60,0x20,0x00,0x00,0x00,0x00 },
       { 0x80,0xc0,0xe0,0xf0,0xf8,0xfc,0xf8,0xf0,0xe0,0xc0,0x80 },
};

int est_fg=HEX, etr_fg[]={ HEX, HEX, HEX, HEX	}, eend_fg=HEX;
int xst_fg=HEX, ext_fg[]={ HEX, HEX	}, xend_fg=HEX;
int mst_fg=HEX, mdl_fg[]={ HEX, HEX, HEX, HEX, HEX, HEX, HEX, HEX}, mend_fg=HEX;
char est_sym[20], etr_sym[4][20], eend_sym[20];
char xst_sym[20], ext_sym[2][20], xend_sym[20];
char mst_sym[20], mdl_sym[8][20], mend_sym[20];
char xst_hex[20], ext_hex[2][20], xend_hex[20];
char mst_hex[20], mdl_hex[8][20], mend_hex[20];
char est_hex[20], etr_hex[4][20], eend_hex[20];
char temp_etr_hex[6][50];
int e_side= LEFT, x_side=LEFT, m_side= LEFT;
unsigned long etr[4], ext[9], mdl[9];

int g_lin=0, fr_st[2]={ 0, 0 }, mag=32;
int cur_fr=0, frn_st=0, frn_end=63, mag_fr=0, fst_fr=0, local_mag=0, ch_no, sig_no;
int ch_set[16];
int ch_sig[] = {
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};
unsigned char gtable[] ={
	0x35,0x2D,0x2C,0x07,0x5B,0x02,0x57,0x57,0x02,0x03,0x00,0x00} ;
unsigned char *patbuf;

extern int  c_line(), 
	tmodeh(), grastring(), grachar(), dischar(), h_grastring(),
	h_grachar(), e_h_dischar(), h_color(),h_prtdotln(),c_color(),prtdotln(),
	SPA_h_cmp(), SPA_c_cmp(), SPA_h_inc(), SPA_c_inc(), c_cur_blk(),
	h_cur_blk(), h_line_plus(),
	e_grastring(), e_grachar(), e_color(), e_prtdotln(), e_cur_blk(),
	gh_cur_blk1(), text1(), gh_grachar1(),gh_clrwindow1();
extern unsigned e_mapping(), e_nextln();

extern int sig_no, ch_no, lsa_ptr, oddev;
extern first, S_flag, S_start, S_end, S1_start, S1_end, S_time;
extern unsigned int video_addr;
extern unsigned int bufptr;
extern int w_model;
extern int d_row, d_col ;
extern char hex[];
extern int INVS, NOR, INVBLK, BLINK, SPA_UP, TOG_NOR, TOG_INVS;
int iii, iiii, iiiii, iiiiii;

struct  attribute {
    int Saddrunit;           /* addrunit from input data file */
    int Sabsflag;            /* 1:86-series,  0: others */
    int Scsiplen;            /* addr-len from input data file in ascii */
    int Maddrunit;           /* addrunit from mice model in unsigned char */
    int Mmodel;              /* mice model id */
    int Maddrid;             /* mice addr id. ex: 4 for 8086, 5 for 68020... */
    int Miplen;   /* ip len of the mice addr, 0: for cpu other than 86-series */
    int Mcsiplen;            /* addr-len from mice model in ascii */
    unsigned long addr_limit;/* address upper bound */
    int upload_handshake;
    int pos[30];             /* position get from "usd.fmt" */
    int mmu[12];             /* MMU pos for 64180 only */
    char getpc[20];          /* command line for get PC */

	int getpc_row;           /* for MICE-II, which "R PC" will cause error */
	int getpc_col;           /* for MICE-II, which "R PC" will cause error */

    char step[6];            /* valid sub-command char for "Step" command */
    char sp[15];             /* variable used for updating the STACK viewport */
    char ss[15];             /* variable used for updating the STACK viewport */
    int MICEGroup;           /* MICE2 for MICE-II, MICE3 for MICE-III */
    int ChipGroup;    /* CHIP86 for 86s, CHIP68 for 68Ks, CHIPELSE for others */
    int CpuCode;             /* for "BREAKPOINT" cmd */
    int CpuType;             /* for "BREAKPOINT" cmd */
    unsigned long VectAdr;   /* for "BREAKPOINT" cmd */
    unsigned char newVect[4];/* for "BREAKPOINT" cmd */
    int Toffset;             /* for "BREAKPOINT" cmd */
    unsigned char TrapCode[2];/* for "BREAKPOINT" cmd */
    unsigned char IRET[2];   /* for "BREAKPOINT" cmd */
    unsigned char JmpHere[2];/* for "BREAKPOINT" cmd */
};
/* struct attribute env */
extern struct attribute env;
int ip_len;
int MMU_64180[12];

int TextColor, InvsColor, BlinkColor;

e_h_dischar(c)
unsigned char c;
{
	unsigned int x, y;
	gh_scr_loc(&y,&x);
	gh_grachar(c,NOC,y,x);
}

checkcode(c,y,x)
unsigned char  c;
unsigned int x, y ;
{
}

SPA_h_cmp(y,c)  
int y,c ;
{
	return(y>c);
}

SPA_c_cmp(y,c)  
int y,c ;
{
	return(y<c) ;
}

SPA_h_inc(y)  
int y ;
{ 
	return(--y);
}

SPA_c_inc(y)  
int y ;
{ 
	return(++y);
}

Rtest()
{
int i;
char word[30] ;
char c ;
	send('R') ;
	  send('\r') ;
	  while ( receive() != '\n') ;
	  while ( (c=receive()) != HAND_SHAKE) {
	      if (isalpha(c)) {
			  i = 0 ;
			   while (isalpha(c)) {
			        toupper(c) ;
			        word[i++] = c ;
					c = receive() ;
			   }
			   word[i] = '\0' ;
			   if (strcmp(word,"halted")== 0) {
	                while ( (c=receive()) != HAND_SHAKE) ;
			        return(1) ;
			   }
		  }
	  }
	  return(0) ;
}

graph_ret(code,str)
char *str;
{
	noncursor() ;
	set_cur1(0,0);
}

mice(c)
int c ;
{
	switch(c) {
		case 0 :
		case 1 :
		case 2 :
		case 3 :
		case 4:
		case 5 :
		case 6 :
		case 7 :
		case 8 :
		case 9 :
		case 10 :
		case 11 :
		case 12 :
		case 13 :
		case 14 :
		case 15 : 				/* 8051 */
		case 16 :
		case 17 :
		case 18 :
		case 30 :
			FOUR_OR_TWO = 2 ;
			break ;
		case 19 :
		case 20 :
		case 21 :
		case 22 :
			seri86 =1 ;
			FOUR_OR_TWO = 2 ;
			break ;
		case 23 :
		case 24 :
		case 25 :
		case 33 : 				/* MICE-32 80386  */
		case 37 : 				/* MICE-16 8086F  */
		case 38 : 				/* MICE-16 V25    */
		case 39 : 				/* MICE-32 80C186 */
		case 40 : 				/* MICE-16 H8/532 */
		case 41 : 				/* MICE-16 80286  */
			seri86 =1 ;
			FOUR_OR_TWO = 4 ;
			break ;
		case 26 :
		case 27 :
		case 28 :
		case 31 : 				/* MICE-8 Z80     */
		case 32 : 				/* MICE-16 68000  */
		case 35 : 				/* MICE-32 68020  */
		case 36 :
			FOUR_OR_TWO = 4 ;
			break ;
		case 29 : 				/* 68HC11         */
			FOUR_OR_TWO = 2 ;
			break ;
		case 34 : 				/* MICE-8 64180   */
		default :
			FOUR_OR_TWO = 4 ;
			break ;
	}
}

gh_distring(str,y,x)
int y, x;
char *str;
{
	gh_grastring(str,y,x,0L,15);
}

char char_to_hex(ch)
char ch ;
{ 
	if (ch < 'a') return(ch - '0') ;
	else return(ch - 'a'+10);
}

gh_scr_loc(row,col)
int *row, *col;
{
     save_curs1();
     *row = d_row;
	 *col = d_col;
}

getpat(c)
unsigned char c;
{
	switch(c) {
		case 0x18:
			patbuf = arrow2[0];
			break;
		case 0x19:
			patbuf = arrow2[1];
			break;
		case 0x1a:
			patbuf = arrow2[2];
			break;
		case 0x1b:
			patbuf = arrow2[3];
			break;
		case 0x10:
			patbuf = arrow2[4];
			break;
		default:
			patbuf= &(pattern[ (c - SP) * 11] );
	}
}

card_color(v)
unsigned int v;
{
	if(mono_flag == 2) {
		if(v == WHITE) color_d = TOG_NOR;
		else color_d = TOG_INVS;
	}
}

init_graph()
{
	int i;
	init_spa();
	g_lin= fr_st[0]= fr_st[1]= cur_fr= frn_st= mag_fr= fst_fr= local_mag= 0;
	frn_end = 63;
	mag = 32;
	int_setmem(ch_sig,16,0xff);
	int_setmem(ch_set,16,0);
	sig_no = ch_no = lsa_ptr = oddev = 0;
	first = S_flag = S_start = S_end = S1_start = S1_end = S_time = 0;
}

init_spa()
{
	int i;
	setmem(est_hex,9,SP);
	setmem(xst_hex,9,SP);
	setmem(mst_hex,9,SP);
	setmem(eend_hex,9,SP);
	setmem(xend_hex,9,SP);
	setmem(mend_hex,9,SP);
	for(i=0 ; i<4 ; ++i) setmem(etr_hex[i],9,SP);
	for(i=0 ; i<2 ; ++i) setmem(ext_hex[i],9,SP);
	for(i=0 ; i<8 ; ++i) setmem(mdl_hex[i],9,SP);

	setmem(est_sym,10,SP);
	setmem(xst_sym,10,SP);
	setmem(mst_sym,10,SP);
	setmem(eend_sym,10,SP);
	setmem(xend_sym,10,SP);
	setmem(mend_sym,10,SP);
	est_sym[10]=xst_sym[10]=mst_sym[10]=eend_sym[10]=xend_sym[10]=mend_sym[10]='\0';
	for(i=0 ; i<4 ; ++i) {
		setmem(etr_sym[i],10,SP);
		etr_sym[i][10] = '\0';
	}
	for(i=0 ; i<8 ; ++i) {
		setmem(mdl_sym[i],10,SP);
		mdl_sym[i][10] = '\0';
	}
	for(i=0 ; i<2 ; ++i) {
		setmem(ext_sym[i],10,SP);
		ext_sym[i][10] = '\0';
	}
	error_flag = global = FOUR_OR_TWO = seri86 = 0;
	est_fg = xst_fg = mst_fg = eend_fg = xend_fg = mend_fg = HEX;
	int_setmem(etr_fg,4,HEX);
	int_setmem(ext_fg,2,HEX);
	int_setmem(mdl_fg,8,HEX);
	e_side = x_side = m_side = LEFT;
}

init_display_card()
{
	int fd ;
	int i ,j;

	color_d = WHITE ;
	switch(mono_flag) {
		case 0:
			fd = open("USD3.PAT",O_RDWR) ;
			read(fd,pattern,1056) ;
			close(fd) ;

			DISTANCE = -13 ;
			H_X = 80 ;
			h_flag = 1 ;
			H_Y = 123 ;
			H_Y1 =123 ;
			F_Y1 = 64 ;
			F_Y2 = 104 ;
			M_Y1 = 26 ;
			M_Y2 = 37 ;

			SPA_Y1 = 52 ;
			SPA_Y2 = 26 ;
			diff1 = -11 ;
			DIFF = -7 ;
			L_H = -6 ;

			linedraw = h_line_plus ;
			tmode = tmodeh ;
			gh_dischar = e_h_dischar ;
			gh_grastring = h_grastring ;
			gh_grachar = h_grachar ;
			gh_color = h_color ;
			gh_prtdotln = h_prtdotln ;
			SPA_cmp = SPA_h_cmp ;
			SPA_inc = SPA_h_inc ;
			gh_cur_blk= h_cur_blk;
			break ;
		case  1 :
			DISTANCE = 8 ;
			h_flag = 0 ;
			H_X = 80 ;
			H_Y = 121 ;
			H_Y1 = 121 ;
			M_Y1 = 17 ;
			M_Y2 = 25 ;
			L_H =  6 ;
			F_Y1 = 41 ;
			F_Y2 = 64 ;
			SPA_Y2 = 184 ;
			SPA_Y1 = 168 ;
			diff1 = 7 ;
			DIFF = 4 ;

			gh_dischar = dischar ;
			gh_grastring = /*grastring ;*/text1;
			gh_grachar = gh_grachar1 ;
			gh_color = c_color ;
			gh_prtdotln = prtdotln ;
			SPA_cmp = SPA_c_cmp ;
			SPA_inc = SPA_c_inc ;
			gh_cur_blk= c_cur_blk;
			break ;
		case  2 :
			fd = open("USD3.PAT",O_RDWR) ;
			read(fd,pattern,1056) ;
			close(fd) ;
			DISTANCE = -14 ;
			H_X = 80 ;
			h_flag = 2 ;
			H_Y = 133 ;
			H_Y1 =133 ;
			F_Y1 = 69 ;
			F_Y2 = 112 ;
			M_Y1 = 28 ;
			M_Y2 = 39 ;

			SPA_Y1 = 56 ;
			SPA_Y2 = 28 ;
			diff1 = -12 ;
			L_H  = -7 ;
			DIFF = -7 ;

			tmode = tmodeh ;
			gh_dischar = e_h_dischar ;
			gh_grastring = /*e_grastring ;*/text1 ;
			gh_grachar = gh_grachar1 ;
			gh_color = e_color ;
			gh_prtdotln = e_prtdotln ;
			SPA_cmp = SPA_h_cmp ;
			SPA_inc = SPA_h_inc ;
			gh_cur_blk= e_cur_blk;
			break ;
	}
	gh_cur_blk= gh_cur_blk1;
	gh_clrwindow = gh_clrwindow1;
}

/******************************************************************************/
mapping(basex,basey)
unsigned int basex, basey;
{
	return( 0x2000 * (basey & 3) + 90 * (basey >> 2) + (basex >> 3) );
}

unsigned e_mapping(basex,basey)
{
	return( basey * 80 + (basex >> 3) ); 
}

nextln(addr)
unsigned addr;
{
	if(addr >= 0x6000)
		addr = addr - 0x6000 + 0x5a;
	else addr = addr + 0x2000;
	return(addr);
}

unsigned e_nextln(addr)
unsigned addr;
{
	return(addr+80);
}

tmodeh()
{
	_setvideomode(_TEXTMONO);
}

c_cur_blk(row,cmn,curz)
int row,cmn,curz;
{
	int x, y, i, j, k;

	gh_color(INVS);
	for(x=cmn*8,y=200-(row+1)*8,i=x+curz*8-1,j=201-row*8,k=0 ;k<8 ; y++,k++)
		linedraw(x,y,i,y);
}

h_cur_blk(row,cmn,curz)
int row,cmn,curz;
{
	int x, y, i, j;
	gh_color(INVS);
	for(x=cmn*8,y=row*13,i=x+curz*8-1,j=(row+1)*13-2 ; y<j ; y++) 
		linedraw(x,y,i,y);
}
char blk40[] = "                                        ";
e_cur_blk(row,cmn,curz)
int row,cmn,curz;
{
	int x, y, i, j, k;
	int  attr;

	for (i=0;i<14;i++);
	{
 	    _settextposition(row,cmn++);
	    set_atr(' ',0,63,1);
	}
}

prtdotln(n)
{
	e_prtdotln(n);
}

h_prtdotln(n)
{
	e_prtdotln(n);
}

e_prtdotln(n)
int n;
{
	int y;
	gh_color(INVS);
	if(mono_flag == 1) y = 200 - (n + 1) * 8;
	else if(mono_flag == 0) y = n * 13;
	else y = n * 14;
	linedraw(0,y,639,y);
}

c_line(a1,a2,a3,a4)
int a1,a2,a3,a4;
{
   _moveto(a1,a2);
   _lineto(a3,a4);
}	

h_grachar(chr,c_class,row,cmn)
unsigned row, cmn;
int c_class;
unsigned char chr;
{
	char far	*graph_p2;
	unsigned char c, byte;
	int i;
	unsigned x, y;

	if(chr == '\n') {
		gh_scr_loc(&row,&cmn);
		set_cur1(++row,cmn);
		return;
	}
	if(chr == '\r') {
		gh_scr_loc(&row,&cmn);
		set_cur1(row,0);
		return;
	}
	getpat(chr);
	y = row;
	x = cmn;
	row *= NY;
	cmn *= NX;
	aoffset = mapping(cmn,row);
	(*((unsigned*)&(graph_p2)+1)) = 0xb800;
	(*((unsigned*)&(graph_p2)  )) = aoffset;
	switch(c_class) {
		case  REPL_BLACK:
			for(i=0 ; i!=11 ; ++i) {
				c = (~patbuf[i]) & 0x0;	
				memset(graph_p2,c,1);
				aoffset = nextln(aoffset);
				(*((unsigned*)&(graph_p2)  )) = aoffset;
			}
			break;
		case  REPL_WHITE:
			for(i=0 ; i!=11 ; ++i) {
				c = ~patbuf[i];	
				memset(graph_p2,c,1);
				aoffset = nextln(aoffset);
				(*((unsigned*)&(graph_p2)  )) = aoffset;
			}
			break;
		case  XOR_BLACK:
			for(i=0 ; i!=11 ; ++i) {
				memcpy(&byte, graph_p2,1);
				c = (~patbuf[i]) ^ byte;
				memset(graph_p2,c,1);
				aoffset = nextln(aoffset);
				(*((unsigned*)&(graph_p2)  )) = aoffset;
			}
			break;
		case  XOR_WHITE:
			for(i=0 ; i!=11 ; ++i) {
				memcpy(&byte, graph_p2,1);
				c = patbuf[i] /*^ byte*/;
				memset(graph_p2,c,1);
				aoffset = nextln(aoffset);
				(*((unsigned*)&(graph_p2)  )) = aoffset;
			}
			break;
		case  NOC:
			for(i=0 ; i!=11 ; ++i) {
				c = patbuf[i];
				memset(graph_p2,c,1);
				aoffset = nextln(aoffset);
				(*((unsigned*)&(graph_p2)  )) = aoffset;
			}
	}
	set_cur1(y,x+1);
}

e_grachar(chr,c_class,row,cmn)
unsigned row, cmn;
int c_class;
unsigned char chr;
{
	unsigned char c, byte;
	int i;
	unsigned x, y;
	union REGS INREG, OUTREG;
	union REGS *INREG_ptr=&INREG, *OUTREG_ptr=&OUTREG;

	if(chr == '\n') {
		gh_scr_loc(&row,&cmn);
		set_cur1(++row,cmn);
		return;
	}
	if(chr == '\r') {
		gh_scr_loc(&row,&cmn);
		set_cur1(row,0);
		return;
	}
	getpat(chr);
	y = row;
	x = cmn;
	set_cur1(y,x);
	INREG_ptr->x.cx = 1 ;
	switch(c_class) {
		case  REPL_BLACK:
		           INREG_ptr->x.cx = 0x900 | chr;
	               	   INREG_ptr->x.bx = INVS ;
		           int86(0x10,INREG_ptr,OUTREG_ptr);
			   break;
		case  REPL_WHITE:
		           INREG_ptr->x.ax = 0x900 | chr;
	                   INREG_ptr->x.bx = NOR ;
		           int86(0x10,INREG_ptr,OUTREG_ptr);
			   break;
		case  XOR_BLACK:
		           INREG_ptr->x.ax = 0x900 | chr;
	                   INREG_ptr->x.bx = INVS|0x80 ;
		           int86(0x10,INREG_ptr,OUTREG_ptr);
			   break;
		case  XOR_WHITE:
		case  NOC:
		           INREG_ptr->x.ax = 0x900 | chr;
	                   INREG_ptr->x.bx = NOR|0x80 ;
		           int86(0x10,INREG_ptr,OUTREG_ptr);
			   break;
    }
	set_cur1(y,x+1);
}

grastring(ptr,color_md,row,cmn)
char *ptr;
int color_md, row, cmn;
{
	h_grastring(ptr,color_md,row,cmn);
}

h_grastring(string,y,x,bkc,color_md)
unsigned  x, y;
unsigned long bkc;
char *string;
int color_md;
{
	char *str;
	for(str = string; *str != '\0'; ++str) {
		h_grachar(*str,0xff,y,x) ;
		if((*str == '\n') || (*str == '\r')) {
			gh_scr_loc(&y,&x);
			continue ;
		} else ++x ;
	}
}

e_grastring(string,color_md,y,x)
unsigned  x, y;
char *string;
int color_md;
{
	h_grastring(string,color_md,y,x);
}

h_color(v)
unsigned int v;
{
	if(v == INVS || v == WHITE) color_d = WHITE;
	else color_d = BLACK;
}

c_color(v)
unsigned int v;
{
	if(v == INVS || v == WHITE) /*color_d = WHITE;*/ _setcolor(_WHITE);
	else /*color_d = BLACK;*/ _setcolor(_BLACK);
}

e_color(v)
unsigned int v;
{
   if(v == WHITE) color_d = TOG_NOR;
   else color_d = TOG_INVS;
}

int_setmem(p,len,data)
int *p, len, data;
{
	while(len--) *p++ = data;
}

start_up1()
{
	int ci, r;
	char c;

	init_display_card();
	attr_setup();
	get_usd3_model();
	InitColor();
}

gh_cur_blk1(row, col, n)
int row, col, n;
{
	_settextposition(row, col);
	set_atr(' ',0,InvsColor,n);
}

gh_grachar1(ch1, color, row, col)
char ch1;
int color,row,col;
{
	_settextposition(row, col);
	printf("%c",ch1);

}

gh_clrwindow1(n)
int n;
{
	int i;

	for(i=2;i<n;i++) {
		_settextposition(i,2);
		set_atr(' ',0,31,77);
	}
}

text1(s,row,col,bk,tc)
char *s;
int  row, col, tc;
long bk;
{
	int p_tc;
	long p_bk, _getbkcolor();

	p_bk = _getbkcolor();
	p_tc = _gettextcolor();

	_settextposition(row,col);
	_settextcolor(tc);
	_setbkcolor(bk);
	_outtext(s);

	_settextcolor(p_tc);
	_setbkcolor(p_bk);
}

get_usd3_model()
{
	int i;

	symaddrUNIT = env.Saddrunit;	
	addrUNIT    = env.Maddrunit;
	ID          = env.Maddrid;
	w_model     = env.Mmodel;
	ip_len      = env.Miplen;
	symcsip_len = env.Scsiplen;
	csip_len    = env.Mcsiplen;
	up_handshake= env.upload_handshake;
	for (i=0;i<6;i++) inst_stp[i]=env.step[i];
	for (i=0;i<12;i++) MMU_64180[i] = env.mmu[i];
	for (i=0;i<30;i++) POSITION[i]=env.pos[i];
	/*PROMPT        = prompt;*/
}

InitColor()
{
	if (mono_flag == 0)  InvsColor = 112;
	else InvsColor = 62;
	TextColor = 31;
	BlinkColor = 159;
}


