;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;   ibmitx.asm -- communications demo interrupt handler
;
;
;   $Revision:   1.0  $
;   $Date:   12 Feb 1990 15:16:52  $
;   $Logfile:   V:/vcs/demo/logfiles/ibmitx.asv  $
;   $Log:   V:/vcs/demo/logfiles/ibmitx.asv  $
;   
;      Rev 1.0   12 Feb 1990 15:16:52   MIKE
;   Initial revision.
;
;
;   Copyright (c) 1989 Rational Systems, Incorporated
;   All Rights Reserved
;
;
;
;	Static Name Aliases
;
	TITLE   IBMIT
;	NAME    IBMIT.ASM
	.286
	include buffer.mac

.MODEL LARGE, C
.CODE

B300   equ     40h;    300
B600   equ     60h;    600
B1200  equ     80h;   1200
B2400  equ     0a0h;  2400
B4800  equ     0c0h;  4800
B9600  equ     0e0h;  9600

o7     equ     0ah ;odd 7 bit
e7     equ     1ah ;even
n7     equ     2   ;no par
o8     equ     0bh
e8     equ     1bh
n8     equ     3

imr    equ     21h;  8259 IT mask register

ier    =     3f9h; 8250 it enable reg.
itidr  =     3fah; 8250 it ident. reg.
mcr    =     3fch; 8250 modem contr. reg
mstr   =     3feh; 8250 modem satus register
errsta =     3fdh; 8250 hiba stat. reg.
trxdata =      3f8h; 8250 transmit-receive buffer

out2   =     8;      


	PUBLIC	_com1init

_com1init  PROC FAR
        push  si             ;Standard C function linkage
        push  di             ;Save the si,di and bp registers
        push  bp             ;and set up new frame pointer.
        mov   bp,sp
        push    ds              ;save data segment

       xor     al,al;
       mov     dx,mcr
       out     dx,al;

;       mov     ax, B9600 + n8 ;com2:9600,no parity
        mov   ax,[bp+10]      ;get baud rate+parity setting

       xor     dx,dx
       int     14h;  ; call BIOS to initialize 
       cli
       mov     dx,errsta
       in      al,dx ; pending IT 
       dec     dx
       mov     al,out2+3 ; IT enable + RTS+DTR
       out     dx,al;  
       dec     dx
       dec     dx
       in      al,dx;  
       dec     dx
       dec     dx
       in      al,dx;  

       in      al,imr; 
       and     al,0efh;
       out     imr,al; 

       mov     dx,ier; 3f9h it enable reg.
       mov     al,01;  receiv, tr.buf emp. rcv ch. err it eng.
       out     dx,al
 
 
        pop     ds              ;restore data segment
        pop   bp             ;Standard C return linkage.
        pop   di             ;Restore saved registers
        pop   si             ;and go home
       sti
	ret
_com1init	ENDP
ier    =     2f9h; 8250 it enable reg.
itidr  =     2fah; 8250 it ident. reg.
mcr    =     2fch; 8250 modem contr. reg
mstr   =     2feh; 8250 modem satus register
errsta =     2fdh; 8250 hiba stat. reg.

	PUBLIC	_com2init

_com2init  PROC FAR
        push  si             ;Standard C function linkage
        push  di             ;Save the si,di and bp registers
        push  bp             ;and set up new frame pointer.
        mov   bp,sp
        push    ds              ;save data segment

       xor     al,al;  
       mov     dx,mcr
       out     dx,al;  

;       mov     ax, B9600 + n8 ;com2:9600,no parity
        mov   ax,[bp+10]      ;get baud rate+parity setting

       mov	dx,1
       int     14h;	       
       cli
       mov     dx,errsta
       in      al,dx ; pending IT 
       dec     dx
       mov     al,out2+3 ; IT enable + RTS+DTR
       out     dx,al;  
       dec     dx
       dec     dx
       in      al,dx;  
       dec     dx
       dec     dx
       in      al,dx;  


       in      al,imr; 
       and     al,0f7h;
       out     imr,al; 

       mov     dx,ier; 3f9h it enable reg.
       mov     al,01;  receiv, tr.buf emp. rcv ch. err it eng.
       out     dx,al
 
        pop     ds              ;restore data segment
        pop   bp             ;Standard C return linkage.
        pop   di             ;Restore saved registers
        pop   si             ;and go home
       sti
	ret
_com2init	ENDP

;+
; VOID _comexit
;-
	PUBLIC	_comexit

_comexit  PROC FAR

       cli
       in      al,imr;
       or      al,18h;
       out     imr,al;
       sti
	ret

_comexit  ENDP

CH0    =       0; 
CH1    =       1;

		public _bufptrs
		public _PM_bufptr
_bufptrs	equ	$
_RM_bufptr	dd	0	; address of buffer data when in real mode
_PM_bufptr	dd	0	; address of buffer data when in protected mode

;
; transmitter interrupt handler subroutine common to both COM ports
;
;       On entry: BL: index to buffer parameter area.
	PUBLIC	transit

transit        PROC NEAR
	push	bp
        bufparad        ;set up es:bp

        and     byte ptr es:[bp+18],0feh ;clear activ bit and test XON/XOFF
	jns	trytran			 ;jmp if no request for sending
 	mov	al,013h;XOFF
        and     byte ptr es:[bp+18],07eh ;clear XON/XOFF sending request bit
        test    byte ptr es:[bp+18],060h ;XON or XOFF
	jnz	chrsnd
	mov	al,011h;XON
	jmp	chrsnd

tbufne: test    byte ptr es:[bp+18],2   ;status = 2 (no XOFF)?
        jnz      trexit

tndis:  readbuf         ;read character from the buffer
chrsnd:                
        transch 	;transmit character

trexit:	pop bp
	ret

	PUBLIC trytran
trytran LABEL NEAR
        mov     ax,word ptr es:[bp+14]   ;get free space
        sub     ax,word ptr es:[bp+4]    ;buffer empty?
        jnz     tbufne
        jmp	trexit

transit  ENDP

;
; receiver interrupt handler subroutine common to both COM ports
;
;       On entry: BL: index to buffer parameter area.
	PUBLIC	receit

receit        PROC NEAR
        push    bp
        push    ax
        bufparad        ;set up es:bp
        cmp     byte ptr es:[bp+16],0   ;XON/XOFF enabled?
        pop     ax
        jz      noxon

rxon:
        cmp     al,011h         ;XON?
        jnz      rxoff
        and     byte ptr es:[bp+18],0fdh  ;clear disable bit
        test    byte ptr es:[bp+18],01h  ;is transmitter activ?
        jz     trytran
	jmp	rxit

rxoff:
        cmp     al,013h         ;XOFF?
	jnz	noxon
        or      byte ptr es:[bp+18],2   ;set disable bit
	jmp	rxit

noxon:
dostore:
        add     bp,rcv_hdr
        storebuf        ;store on buffer
	cmp	word ptr es:[bp+14],DISABREC; empty room <disabrec?
	jnc	rxit
	mov	ax,04013h ; send out XOFF
	sub	bp,rcv_hdr
	xoosnd

rxit:	pop bp
	ret

receit  ENDP

ier    =     3f9h; 8250 it enable reg.
itidr  =     3fah; 8250 it ident. reg.
mcr    =     3fch; 8250 modem contr. reg
mstr   =     3feh; 8250 modem satus register
errsta =     3fdh; 8250 hiba stat. reg.
trxdata =      3f8h; 8250 transmit-receive buffer


comment /*
		REAL-MODE interrupt handler entry point for COM1
								 */

	PUBLIC _RM_com1it
_RM_com1it:
	pusha
	push	ds
	push	es
	mov	ax,cs
	mov	ds,ax
;        mov     al,20h          ; EOI
;        out     20h,al           ;   for 8259
	
	les	bp,_RM_bufptr
	clrflg	; clear interrupt flag
	nop
	jmp	short _com1it


comment /*
		PROTECTED-MODE interrupt handler entry point for COM1
									 */

	PUBLIC _PM_com1it
_PM_com1it:
	pusha
	push	ds
	push	es
	mov	ax,DGROUP
	mov	ds,ax
;        mov     al,20h          ; EOI
;        out     20h,al           ;   for 8259

	les	bp,_PM_bufptr
	clrflg	; clear interrupt flag
	nop
	jmp	short _com1it


	PUBLIC	_com1it
	

_com1it  PROC FAR

	PUBLIC itbeg
itbeg	LABEL NEAR
        mov     dx,itidr        ;it identifier register
        in      al,dx           ;read               
        and     al,6
        cmp     al,4
        je      rcv
	cmp	al,6
	je	err
        mov     dx,errsta
        in      al,dx
	test	al,20h
        jz      notrans


        mov     bl,CH0            ;select buffer area 0
        call    transit

notrans:
	xorflg
	je	itend
        jmp     short it2chk

;N.B. ERRORS ARE IGNORED!!!!!!!!
err:
	jmp	notrans

rcv:
        mov     dx,trxdata
        in      al,dx
        mov     bl,CH0           ;select buffer area 0

        call    receit
	cmpflg
	je	itbeg

it2chk:
	chkcom
        je      it2beg

	PUBLIC itend
itend	LABEL NEAR
        pop     es
        pop     ds
        mov     al,20h          ; EOI
        out     20h,al           ;   for 8259
        popa
        iret 
_com1it  ENDP

ier    =       2f9h; 8250 it enable reg.
itidr  =       2fah; 8250 it ident. reg.
mcr    =       2fch; 8250 modem contr. reg
mstr   =       2feh; 8250 modem satus register
errsta =       2fdh; 8250 hiba stat. reg.
trxdata =      2f8h; 8250 transmit-receive buffer


comment /*
		REAL-MODE interrupt handler entry point for COM2
									 */

	PUBLIC _RM_com2it
_RM_com2it:
	pusha
	push	ds
	push	es
	mov	ax,cs
	mov	ds,ax
;        mov     al,20h          ; EOI
;        out     20h,al           ;   for 8259

	les	bp,_RM_bufptr
	clrflg	; clear interrupt flag
	nop
 	jmp	short _com2it


comment /*
		PROTECTED-MODE interrupt handler entry point for COM2
									 */

	PUBLIC _PM_com2it
_PM_com2it:
	pusha
	push	ds
	push	es
	mov	ax,DGROUP
	mov	ds,ax
;        mov     al,20h          ; EOI
;        out     20h,al           ;   for 8259

	les	bp,_PM_bufptr
	clrflg	; clear interrupt flag
	nop
 	jmp	short _com2it
 

	PUBLIC	_com2it
	

_com2it  PROC FAR


;        mov     al,'B'
;        call    far ptr trachar

	PUBLIC it2beg
it2beg	LABEL NEAR
        mov     dx,itidr        ;it identifier register
        in      al,dx           ;read               
        and     al,6
        cmp     al,4
        je      rcv2
	cmp	al,6
	je	err2
        mov     dx,errsta
        in      al,dx
	test	al,20h
        jz      no2trans

        mov     bl,CH1           ;select buffer area 1
        call    transit

no2trans:
	xorflg
	je	itend
	jmp	itbeg

;N.B. ERRORS ARE IGNORED!!!!!!!!
err2:
	jmp	no2trans


rcv2:
        mov     dx,trxdata
        in      al,dx
        mov     bl,CH1            ;select buffer area 1

        call    receit
	cmpflg
	je	it2beg
        jmp     itbeg

_com2it  ENDP

END




