/*--------------------------------------------------------------------------*/
/*  init.c								    */
/*--------------------------------------------------------------------------*/


#include  "system.h"
#include  "usd3.h"
#include  "gblext.h"
#include  "oldext.h"
#include  "usym1.h"
#include  "usym3.h"
#include  "funcext.h"

int USD3clrfld();
int USD3rowdel();
int USD3disable();
int ClistQuit();
MFILEPTR ReplaceHelpRd();

extern int fdRX, FPORT;
extern int log_fid, logFlag, log_count;
extern char log_buf[];
extern int MAXFlag;

/****************************************************************************/
/*									    */
/****************************************************************************/

ClearField(keyptr)
KEYCTRLPTR  keyptr;
{
	DFIELDPTR fldptr;
	MEMOPTR memoptr;
	
	fldptr = (DFIELDPTR) curitemp(DlgFmPtr);
	if (fldptr->type == F_MEMO) {
		memoptr = (MEMOPTR) curitemp(DlgFmPtr);
		memoptr->datap[0] = '\0';
		memo_upd("",curitemnum(DlgFmPtr),DlgFmPtr);
	} else {
		strcpy(fldptr->datap,"");
		fld_upd("",curitemnum(DlgFmPtr),DlgFmPtr);
	}
	k_quit(keyptr);
}

ClistQuit(kcp)
KEYCTRLPTR kcp;
{
	DFIELDPTR fldptr;

	if (DlgFmPtr->cur_item == DlgFmPtr->itemq-1) {
		sfm_nextitem(0,DlgFmPtr);
		if (DlgFmPtr->cur_item == 0) DlgFmPtr->nextact = AC_QUIT;  
	}
	fldptr = curdfldp(DlgFmPtr);
	fldptr->clistp->nextact = AC_QUIT;
	return(1);
}

#define MAXDISTANCE    32000
upitem(dummyptr)
KEYCTRLPTR  dummyptr;
{
    int i;
    int itemq, curitem;
    int nextitem = -1;
    int csr_row, csr_col;               /*row and col of the current cursor   */
    int tgt_row, tgt_col;               /*row & col of the item being tested  */
    int tgt_distance;
    int distance = MAXDISTANCE;
    int row_q;				/*number of rows on form	      */
    long wrap;				/*local copy of form wrap flag	      */
    PTR *map;                           /*pointer to the field map            */
    PTR itemp;
    WINDOWPTR wnp;
    FORMPTR fmp;

    fmp = DlgFmPtr;
    if (fmp->flags & CURSORFREE)        /* if free cursor movement            */
    {
        itemq = fmp->itemq;             /*dereference the item quantity       */
        curitem = fmp->cur_item;        /*dereference the current item number */
        map = fmp->item_arrayp;         /*dereference the item array pointer  */
        wnp = fmp->wnp;
        csr_col = wnp->c;
        csr_row = wnp->r;
					/*top-to-bottom wrap enabled?	      */
	if (wrap = fmp->flags & FMWRAP)
	{				/*YES				      */
            if (fm_isvirtual(fmp))	/*calculate number of rows on form    */
                row_q = wnp->bufp->row_q;
            else
                row_q = wn_rowq(wnp);
	}

        for (i = 0; i < itemq; ++i)     /*loop through all the fields         */
        {
            if (i != curitem)           /*skip looking at the current item    */
            {
                itemp = *(map+i);       /*dereference the item pointer        */
                                        /*if it is not a skip field           */
                if (!_i_isskipfld(itemp))
                {
                                        /* get the target item cursor coord   */
                    _i_csr(&tgt_row, &tgt_col, itemp, fmp);

/*----------------------------------------------------------------------------*/
/*  If form wrap is enabled and the item is below the current cursor position,*/
/*  pretend it is ABOVE by decrementing it by the number of rows on the form. */
/*----------------------------------------------------------------------------*/
		    if (wrap && tgt_row > csr_row)
			tgt_row -= row_q;

                    if (tgt_row < csr_row)  /*is it above the current item?   */
                    {
/*----------------------------------------------------------------------------*/
/*  If the row is closer than the currently closest one or it is on the same  */
/*  row and the target cursor position is closer, choose this item.           */
/*----------------------------------------------------------------------------*/
			tgt_distance = (csr_row - tgt_row) +
					    _abs(csr_col - tgt_col);
			if (tgt_distance < distance)
                        {
                            distance = tgt_distance;
                            nextitem = i;
                        }
                    }
                }
            }
        }
        if (nextitem >= 0)
            sfm_nextitem(nextitem, fmp);/*go to the item if we found one      */
    }
    else  {
/*	if (fmp->cur_item == 0) sfm_nextitem((fmp->itemq)-1,fmp);
	else  sfm_nextitem(AC_PREVITEM, fmp); *//*go to the previous item */

	DFIELDPTR dptr;
	itemq = fmp->itemq;      
        curitem = fmp->cur_item; 
	do {
		if (curitem == 0) curitem = fmp->itemq - 1;
		else curitem--;
		dptr = (DFIELDPTR) i_numptr(curitem,fmp);
		if (dptr == NULLP) break;
	} while ((dptr->flags & SKIP) == SKIP);
	sfm_nextitem(curitem,fmp);
	}
    return(1);
}

downitem(dummyptr)
KEYCTRLPTR  dummyptr;
{
    FORMPTR fmp;
    int i;
    int itemq, curitem;
    int nextitem = -1;
    int csr_row, csr_col;               /*row and col of the current cursor   */
    int tgt_row, tgt_col;               /*row & col of the item being tested  */
    int tgt_distance;
    int distance = MAXDISTANCE;
    int row_q;				/*number of rows on form	      */
    long wrap;				/*local copy of form wrap flag	      */
    PTR *map;                           /*pointer to the field map            */
    PTR itemp;
    WINDOWPTR wnp;
    int saveflag;

    fmp = DlgFmPtr;
    if (fmp->flags & CURSORFREE)        /* if free cursor movement            */
    {
        itemq = fmp->itemq;             /*dereference the item quantity       */
        curitem = fmp->cur_item;        /*dereference the current item number */
        map = fmp->item_arrayp;         /*dereference the item array pointer  */
        wnp = fmp->wnp;
        csr_col = wnp->c;
        csr_row = wnp->r;
					/*bottom-to-top wrap enabled?	      */
	if (wrap = fmp->flags & FMWRAP)
	{				/*YES				      */
            if (fm_isvirtual(fmp))	/*calculate number of rows on form    */
                row_q = wnp->bufp->row_q;
            else
                row_q = wn_rowq(wnp);
	}

        for (i = 0; i < itemq; ++i)     /*loop through all the fields         */
        {
            if (i != curitem)           /*skip looking at the current item    */
            {
                itemp = *(map+i);       /*dereference the item pointer        */
                                        /*only look at this item if it is not */
                                        /*a skip field                        */
                if (!_i_isskipfld(itemp))
                {                       /* get the target item cursor coord   */
                    _i_csr(&tgt_row, &tgt_col, itemp, fmp);

/*----------------------------------------------------------------------------*/
/*  If form wrap is enabled and the item is above the current cursor position,*/
/*  pretend it is BELOW by incrementing it by the number of rows on the form. */
/*----------------------------------------------------------------------------*/
		    if (wrap && tgt_row < csr_row)
			tgt_row += row_q;

                    if (tgt_row > csr_row)  /*is it below the current item?   */
                    {
/*----------------------------------------------------------------------------*/
/*  If the row is closer than the currently closest one or it is on the same  */
/*  row and the target cursor position is closer, choose this item.           */
/*----------------------------------------------------------------------------*/
			tgt_distance = (tgt_row - csr_row) +
					    _abs(tgt_col - csr_col);
                        if (tgt_distance < distance)
                        {
                            distance = tgt_distance;
                            nextitem = i;
                        }
                    }
                }
            }
        }
        if (nextitem >= 0)
            sfm_nextitem(nextitem, fmp);/*go to the item if we found one      */
    }
    else {
/*	if (fmp->cur_item == (fmp->itemq - 1)) sfm_nextitem(0, fmp);
	else sfm_nextitem(AC_NEXTITEM, fmp); */ /*go to the next item */

	DFIELDPTR dptr;
	itemq = fmp->itemq;      
        curitem = fmp->cur_item; 
	do {
		if (curitem == (fmp->itemq - 1)) curitem = 0;
		else curitem++;
		dptr = (DFIELDPTR) i_numptr(curitem,fmp);
		if (dptr == NULLP) break;
	} while ((dptr->flags & SKIP) == SKIP);
	sfm_nextitem(curitem,fmp);
	}
    return(1);
}

USD3clrfld(dummyptr)
KEYCTRLPTR  dummyptr;
{
    DFORMPTR dfmp;
    long flags;
    UCHAR *picp;
    UCHAR *picch;
    WINDOWPTR wnp;
    DFIELDPTR dfldp;

    dfmp = DlgFmPtr;
    dfldp = curdfldp(dfmp);             /*avoid many levels of indirection    */
    flags = dfldp->flags;

    if (flags & PROTECTED)              /*check if field is protected         */
        VAL_ERR = PROT_FIELD;
    else
    {
	wnp = dfmp->wnp;
	picp = dfldp->picp;
        picch = _fldinfo[dfldp->type].picch;    /*get allowed picture chars   */

	if (flags & RTENTRY)            /*Right entry fields                  */
            wnp->c = dfldp->cb; /* + _picchlast(picp, picch); */
	else                            /*Left entry fields                   */
            wnp->c = dfldp->cb; /* + _picchfirst(picp, picch); */

        _pictobuf(dfldp);       	/*display just picture		      */

        v_stattnop(dfldp->rb, dfldp->cb, dfldp->editbufp, dfldp->act_att,
                   dfldp->len, STATT, wnp);

        dfldp->flags |=  FLDALTERED;    /*set field altered flag              */
        dfldp->flags &= ~FLDVALID;      /*clear field valid flag              */
        dfmp->flags |= FMALTERED;       /*set form altered flag               */
        dfmp->flags &= ~FMVALID;        /*clear form valid flag               */
    }

    return(1);
}

USD3rowdel(dummyptr)
KEYCTRLPTR  dummyptr;
{
    DFORMPTR dfmp;
    int i;
    int row;
    int maxline;
    UCHAR * stp;
    MFILEPTR mfp;
    MFLINEPTR * farray;                 /*pointer to the array of MFLINEPTR's */
    WINDOWPTR wnp;
    MEMOPTR memop;

    dfmp = DlgFmPtr;
    memop = curmemop(dfmp);
    if (memop->flags & PROTECTED)       /*Make sure it is not protected       */
        VAL_ERR = PROT_FIELD;
    else
    {
        wnp = memop->wnp;
        mfp = wnp->mfp;
        farray = mfp->farray;

	wnp->col_org = 0;
	wnp->c = 0;

        row = wnp->r + wnp->row_org;
        maxline = wnp->mfp->fmaxline - 2;

        stp = farray[row]->line_st;     /*save the string pointer that will   */
                                        /*otherwise get trashed               */

        for (i = row; i < maxline; ++i) /*move all the string pointers down   */
        {
            farray[i]->line_st = farray[i + 1]->line_st;
            farray[i]->line_len = farray[i + 1]->line_len;
            _memo_scrupd(i, 0, memop);
        }

        farray[i]->line_st = stp;       /*restore the saved string pointer    */
        farray[i]->line_len = 0;        /*reset the line length               */
        *stp = '\0';                    /*set the string to null              */
        _memo_scrupd(i, 0, memop);

        if (mfp->ln_q > 0)              /*decrement the line quantities       */
            mfp->ln_q--;
        if (mfp->vln_q > 1)             /*never go below 1 visible row        */
            mfp->vln_q--;

        if (row >= mfp->vln_q)          /*deleted the last row                */
        {
            if (wnp->r > 0)
                --wnp->r;
            else if (wnp->row_org > 0)
                --wnp->row_org;
        }

        memop->flags |= FLDALTERED;     /*set the field altered flag          */
        memop->flags &= ~FLDVALID;      /*reset the field valid flag          */
        dfmp->flags |= FMALTERED;       /*set the form altered flag           */
        dfmp->flags &= ~FMVALID;        /*reset the form valid flag           */
    }
    return(1);
}

USD3disable(dummyptr)
KEYCTRLPTR  dummyptr;
{
    return(1);
}

/****************************************************************************/
/*									    */
/****************************************************************************/

SetHelpEnv()
{
/* CORE 90.08.15 Change Message From MII To CD */
#ifdef NEC_PC9801 /*NEC_PC9801*/
    se_defaulthelpmsg("USD-III V2.6 -- CORE DIGITAL Co.,Ltd. Copyright 1995-196");
#else /*NEC_PC9801*/
    se_defaulthelpmsg("USD-III v2.6 -- MICROTEK International Inc., Copyright 1995-1996");
#endif /*NEC_PC9801*/
	sw_att(LBLA_WHI,HELP_WNP);
	sw_bdr(BDR_DLNP,HELP_WNP);
	sw_bdratt(LBLA_WHI,HELP_WNP);
	sw_sb(AUTOUPD,VSBAR,HELP_WNP);   // USD-III V2.0x 
	sw_title(" HELP ",LBLA_WHI,TOPCENTER,HELP_WNP);
	wn_mod(vs_rowq()-10,5,9,vs_colq()-10,HELP_WNP);

/* CORE 90.08.014 */

#ifndef NEC_PC9801

	sw_updnfp(wn_expset,wn_expunset,HELP_WNP);

#endif

}

/****************************************************************************/
/*  initialize global variables						    */
/****************************************************************************/

InitGbl()
{
 int	       i;
 extern int    mono_flag;
 extern UCHAR  *_vv_infomsg[];

/* CORE 90.08.12 Specify Scroll Bar's Character */

#ifdef NEC_PC9801

    se_sbch ( 0x9b,0x1e,0x1f,0x1d,0x1c,0x3a,0xe0) ;

#endif 

/* CORE 90.08.08 Test */

#ifdef NEC_PC9801

 AdapterType = EGA ;

#else

 AdapterType = vid_adapter();

#endif

 switch( AdapterType ) {

   case MDA  : mono_flag = 0;
	       break;
   case CGA  : mono_flag = 1;
	       break;
   case EGA  : mono_flag = 2;
	       break;
   default   : mono_flag = 2;
 }

 if ( AdapterType == MDA ) {

    ColorMode = FALSE;
    USD3vid_setmode( MONO );

    LVPTITLEACT	  = LBLA_WHI;
    LVPTITLEINACT = LWHI_BLA;

 } else {  /*  CGA, EGA, PGS, VGA, MCGA  */

    ColorMode = TRUE;
    USD3vid_setmode( CO80 );
    vid_hibg( ON );

    if ( ( AdapterType == PGS ) || ( AdapterType == MCGA ) ) {

       _latt[ LMNINACT   ] = catt_def( LIGHT | CYAN, 	CYAN    );
       _latt[ LMNACT     ] = catt_def( LIGHT | WHITE, 	BLUE    );

       _latt[ LMNSELCH   ] = catt_def( LIGHT | WHITE,  	CYAN    );

       _latt[ LARROW     ] = catt_def( LIGHT | WHITE, 	BLACK   );
       _latt[ LCORNER    ] = catt_def( LIGHT | WHITE, 	BLUE    );
       _latt[ LPAGERGN   ] = catt_def( LIGHT | WHITE, 	BLACK   );
       _latt[ LTHUMB     ] = catt_def( LIGHT | WHITE, 	BROWN   );

       _latt[ LFORMS     ] = catt_def( LIGHT | BROWN, 	BLUE    );
       _latt[ LFLDACTON  ] = catt_def( BLUE,          	BROWN   );
       _latt[ LFLDACTOFF ] = catt_def( LIGHT | BROWN, 	CYAN    );

       _latt[ LBLA_BLA	 ] = catt_def( LIGHT | BLACK,   BLACK   );
       _latt[ LBLA_BLU	 ] = catt_def( LIGHT | BLACK,   BLUE    );
       _latt[ LBLA_MAG	 ] = catt_def( LIGHT | BLACK,   MAGENTA );
       _latt[ LBLA_RED	 ] = catt_def( LIGHT | BLACK,   RED     );
       _latt[ LBLA_WHI	 ] = catt_def( LIGHT | BLACK,   WHITE   );
       _latt[ LBLA_BRO	 ] = catt_def( LIGHT | BLACK,   BROWN   );
       _latt[ LBLA_CYA	 ] = catt_def( LIGHT | BLACK,   CYAN    );
       _latt[ LBLA_GRE	 ] = catt_def( LIGHT | BLACK,   GREEN   );
       _latt[ LBLA_YEL	 ] = catt_def( LIGHT | BLACK,   BROWN   );

       _latt[ LBLU_BLA	 ] = catt_def( LIGHT | BLUE,    BLACK   );
       _latt[ LBLU_BLU	 ] = catt_def( LIGHT | BLUE,    BLUE    );
       _latt[ LBLU_MAG	 ] = catt_def( LIGHT | BLUE,    MAGENTA );
       _latt[ LBLU_RED	 ] = catt_def( LIGHT | BLUE,    RED     );
       _latt[ LBLU_WHI	 ] = catt_def( LIGHT | BLUE,    WHITE   );
       _latt[ LBLU_BRO	 ] = catt_def( LIGHT | BLUE,    BROWN   );
       _latt[ LBLU_CYA	 ] = catt_def( LIGHT | BLUE,    CYAN    );
       _latt[ LBLU_GRE	 ] = catt_def( LIGHT | BLUE,    GREEN   );
       _latt[ LBLU_YEL	 ] = catt_def( LIGHT | BLUE,    BROWN   );

       _latt[ LMAG_BLA	 ] = catt_def( LIGHT | MAGENTA, BLACK   );
       _latt[ LMAG_BLU	 ] = catt_def( LIGHT | MAGENTA, BLUE    );
       _latt[ LMAG_MAG	 ] = catt_def( LIGHT | MAGENTA, MAGENTA );
       _latt[ LMAG_RED	 ] = catt_def( LIGHT | MAGENTA, RED     );
       _latt[ LMAG_WHI	 ] = catt_def( LIGHT | MAGENTA, WHITE   );
       _latt[ LMAG_BRO	 ] = catt_def( LIGHT | MAGENTA, BROWN   );
       _latt[ LMAG_CYA	 ] = catt_def( LIGHT | MAGENTA, CYAN    );
       _latt[ LMAG_GRE	 ] = catt_def( LIGHT | MAGENTA, GREEN   );
       _latt[ LMAG_YEL	 ] = catt_def( LIGHT | MAGENTA, BROWN   );

       _latt[ LRED_BLA	 ] = catt_def( LIGHT | RED,     BLACK   );
       _latt[ LRED_BLU	 ] = catt_def( LIGHT | RED,     BLUE    );
       _latt[ LRED_MAG	 ] = catt_def( LIGHT | RED,     MAGENTA );
       _latt[ LRED_RED	 ] = catt_def( LIGHT | RED,     RED     );
       _latt[ LRED_WHI	 ] = catt_def( LIGHT | RED,     WHITE   );
       _latt[ LRED_BRO	 ] = catt_def( LIGHT | RED,     BROWN   );
       _latt[ LRED_CYA	 ] = catt_def( LIGHT | RED,     CYAN    );
       _latt[ LRED_GRE	 ] = catt_def( LIGHT | RED,     GREEN   );
       _latt[ LRED_YEL	 ] = catt_def( LIGHT | RED,     BROWN   );

       _latt[ LWHI_BLA	 ] = catt_def( LIGHT | WHITE,   BLACK   );
       _latt[ LWHI_BLU	 ] = catt_def( LIGHT | WHITE,   BLUE    );
       _latt[ LWHI_MAG	 ] = catt_def( LIGHT | WHITE,   MAGENTA );
       _latt[ LWHI_RED	 ] = catt_def( LIGHT | WHITE,   RED     );
       _latt[ LWHI_WHI	 ] = catt_def( LIGHT | WHITE,   WHITE   );
       _latt[ LWHI_BRO	 ] = catt_def( LIGHT | WHITE,   BROWN   );
       _latt[ LWHI_CYA	 ] = catt_def( LIGHT | WHITE,   CYAN    );
       _latt[ LWHI_GRE	 ] = catt_def( LIGHT | WHITE,   GREEN   );
       _latt[ LWHI_YEL	 ] = catt_def( LIGHT | WHITE,   BROWN   );

       _latt[ LBRO_BLA	 ] = catt_def( LIGHT | BROWN,   BLACK   );
       _latt[ LBRO_BLU	 ] = catt_def( LIGHT | BROWN,   BLUE    );
       _latt[ LBRO_MAG	 ] = catt_def( LIGHT | BROWN,   MAGENTA );
       _latt[ LBRO_RED	 ] = catt_def( LIGHT | BROWN,   RED     );
       _latt[ LBRO_WHI	 ] = catt_def( LIGHT | BROWN,   WHITE   );
       _latt[ LBRO_BRO	 ] = catt_def( LIGHT | BROWN,   BROWN   );
       _latt[ LBRO_CYA	 ] = catt_def( LIGHT | BROWN,   CYAN    );
       _latt[ LBRO_GRE	 ] = catt_def( LIGHT | BROWN,   GREEN   );
       _latt[ LBRO_YEL	 ] = catt_def( LIGHT | BROWN,   BROWN   );

       _latt[ LCYA_BLA	 ] = catt_def( LIGHT | CYAN,    BLACK   );
       _latt[ LCYA_BLU	 ] = catt_def( LIGHT | CYAN,    BLUE    );
       _latt[ LCYA_MAG	 ] = catt_def( LIGHT | CYAN,    MAGENTA );
       _latt[ LCYA_RED	 ] = catt_def( LIGHT | CYAN,    RED     );
       _latt[ LCYA_WHI	 ] = catt_def( LIGHT | CYAN,    WHITE   );
       _latt[ LCYA_BRO	 ] = catt_def( LIGHT | CYAN,    BROWN   );
       _latt[ LCYA_CYA	 ] = catt_def( LIGHT | CYAN,    CYAN    );
       _latt[ LCYA_GRE	 ] = catt_def( LIGHT | CYAN,    GREEN   );
       _latt[ LCYA_YEL	 ] = catt_def( LIGHT | CYAN,    BROWN   );

       _latt[ LGRE_BLA	 ] = catt_def( LIGHT | GREEN,   BLACK   );
       _latt[ LGRE_BLU	 ] = catt_def( LIGHT | GREEN,   BLUE    );
       _latt[ LGRE_MAG	 ] = catt_def( LIGHT | GREEN,   MAGENTA );
       _latt[ LGRE_RED	 ] = catt_def( LIGHT | GREEN,   RED     );
       _latt[ LGRE_WHI	 ] = catt_def( LIGHT | GREEN,   WHITE   );
       _latt[ LGRE_BRO	 ] = catt_def( LIGHT | GREEN,   BROWN   );
       _latt[ LGRE_CYA	 ] = catt_def( LIGHT | GREEN,   CYAN    );
       _latt[ LGRE_GRE	 ] = catt_def( LIGHT | GREEN,   GREEN   );
       _latt[ LGRE_YEL	 ] = catt_def( LIGHT | GREEN,   BROWN   );

       _latt[ LYEL_BLA	 ] = catt_def( LIGHT | YELLOW,  BLACK   );
       _latt[ LYEL_BLU	 ] = catt_def( LIGHT | YELLOW,  BLUE    );
       _latt[ LYEL_MAG	 ] = catt_def( LIGHT | YELLOW,  MAGENTA );
       _latt[ LYEL_RED	 ] = catt_def( LIGHT | YELLOW,  RED     );
       _latt[ LYEL_WHI	 ] = catt_def( LIGHT | YELLOW,  WHITE   );
       _latt[ LYEL_BRO	 ] = catt_def( LIGHT | YELLOW,  BROWN   );
       _latt[ LYEL_CYA	 ] = catt_def( LIGHT | YELLOW,  CYAN    );
       _latt[ LYEL_GRE	 ] = catt_def( LIGHT | YELLOW,  GREEN   );
       _latt[ LYEL_YEL	 ] = catt_def( LIGHT | YELLOW,  BROWN   );
    }

/* CORE 90.08.014 */

#ifdef NEC_PC9801

    LVPTITLEACT	  = LBLA_GRE;
    LVPTITLEINACT = LGRE_BLA;

#else

    LVPTITLEACT	  = LWHI_RED;
    LVPTITLEINACT = LWHI_BLA;

#endif

 }

 _vv_infomsg[ EXCLISTMSG ] = (UCHAR *) "<F1> for help, Cursor keys to scroll, <ESC> to quit, <F6> clear, <CR> select";
													    
 /* define memory file for help and install the help text to the memory file */
// amy DOS/16M
// if ( ( DlgMFilePtr = help_mf("USD3DLG.TXT",DLGMFILEMAXROW+200) ) == NULLP ) {
 if ( ( DlgMFilePtr = ReplaceHelpRd("USD3DLG.TXT",DLGMFILEMAXROW+200) ) == NULLP ) {

    if ( VV_ERR == ERROPEN )  ErrorCondition = USD3DLG_TXT_OPEN_ERR;
    else  ErrorCondition = MEM_INSUFFICIENT;

    return( FALSE );

 } else  SetHelpEnv();

 if ( ( ( CmdHelpWnp = wn_def( 1, 5, 23, vs_colq()-10, LBLA_WHI, BDR_DLNP ) ) == NULLP ) ||
      ( ( CmdMFilePtr = mf_def( CMDMFILEMAXROW, 80 ) ) == NULLP ) ) {

    ErrorCondition = MEM_INSUFFICIENT;
    return( FALSE );

 } else {

   sw_title( " HELP ", LBLA_WHI, TOPCENTER, CmdHelpWnp );
   sw_sb(AUTOUPD,VSBAR,CmdHelpWnp);  // USD-III V2.0x
   sw_mgcol( 1, 1, CmdHelpWnp );

/* CORE 90.08.014 */

#ifndef NEC_PC9801

   sw_updnfp( wn_expset, wn_expunset, CmdHelpWnp );

#endif

   sw_mf( CmdMFilePtr, CmdHelpWnp );

   if ( mf_rd( "USD3CMD.TXT", CmdMFilePtr ) == 0 ) {

      if ( VV_ERR == ERROPEN )  ErrorCondition = USD3CMD_TXT_OPEN_ERR;
      else  ErrorCondition = MEM_INSUFFICIENT;

      return( FALSE );

   } else  if ( mf_kwdset( "*USD3HELP", CmdMFilePtr ) == 0 ) {

	      ErrorCondition = MEM_INSUFFICIENT;
	      return( FALSE );
	   }
 }

 /*  define memory file for choice list  */

 if ( ( CListMFilePtr = mf_def(CLISTMFILEMAXROW,CLISTMFILEMAXCOL) ) == NULLP ) {

    ErrorCondition = MEM_INSUFFICIENT;
    return( FALSE );

 } else {

    if ( mf_rd( "USD3CLST.TXT", CListMFilePtr ) == 0 ) {

      if ( VV_ERR == ERROPEN )  ErrorCondition = USD3CLST_TXT_OPEN_ERR;
      else  ErrorCondition = MEM_INSUFFICIENT;

      return( FALSE );
    }
 }

 /*  open VVD library for dialog-box  */

 if ( ( VVDLibp = dl_open( "USD3DLG.LIB" ) ) == NULLP ) {

    if ( VV_ERR == ERROPEN )  ErrorCondition = USD3DLG_LIB_OPEN_ERR;
    else  ErrorCondition = MEM_INSUFFICIENT;

    return( FALSE );

 } else  se_dllocking( ON );

 /*  redefine key-function of VIEWKTP for wn_browse()  */

 kt_rplkey( KEY_ESC, k_exit, VIEWKTP );
 kt_rplkey( KEY_CPGUP, GetPrevPage, VIEWKTP );
 kt_rplkey( KEY_CPGDN, GetNextPage, VIEWKTP );
 kt_rplkey( KEY_F10, k_exit, CLKTP );
 kt_rplkey( KEY_F6, ClearField, CLKTP );
 kt_rplkey( KEY_ESC, ClistQuit, CLKTP );
 kt_rplkey( KEY_UP, upitem, FMKTP);
 kt_rplkey( KEY_UP, upitem, TTMEMOKTP);
 kt_rplkey( KEY_DN, downitem, FMKTP);
 kt_rplkey( KEY_DN, downitem, TTMEMOKTP);
 kt_rplkey( KEY_F6, USD3clrfld, FMKTP);
 kt_rplkey( KEY_F6, USD3rowdel, TTMEMOKTP);
 kt_rplkey( KEY_F7, USD3disable, TTMEMOKTP);
 kt_rplkey( KEY_F8, USD3disable, FMKTP);

 /*  initialize the buffer used for storing user-defined commands
     corresponding to SHIFT-F1 through SHIFT-F8			   */

 for ( i = 0; i <= 7; i++ )  SoftKeyBuf[i][0] = '\0';

 /*  initialize the flag used for masking the updating operations of
     viewports							      */

 MaskRedrawFlag = 0;

 /*  initialize the flag used for recognizing the situation that currently
     displayed command are retrived from the history buffer		    */

 his_flag = 0;

 /*  initialize the buffer index that current PC indicates  */

 CurrentPC = -1;

 /*  initialize StaBufRow which is a copy of the STABUFROW except executing
     the ISTEP command							     */

 StaBufRow = STABUFROW;

 InitOldGbls();

 return( TRUE );

}  /*  of InitGbl()  */

MFILEPTR ReplaceHelpRd(fname,rowcnt)
UCHAR *fname;
int rowcnt;
{
	MFILEPTR mptr;

	mptr = mf_def(rowcnt,80);
	if (mptr == NULLP) return(NULLP);
	smf_opt(INDEXING,ON,mptr);
	mf_rd(fname,mptr);
	se_helpmfp(mptr);
	return(mptr);
}

/****************************************************************************/
/*  free global variables						    */
/****************************************************************************/

FreeGbl()
{
 if ( DlgMFilePtr != NULLP )  mf_free( DlgMFilePtr );

 if ( CmdHelpWnp  != NULLP )  wn_free( CmdHelpWnp );
 if ( CmdMFilePtr != NULLP )  mf_free( CmdMFilePtr );

 if ( CListMFilePtr != NULLP )  mf_free( CListMFilePtr );

 if ( VVDLibp != NULLP )  dl_close( VVDLibp );
 if ( FPORT) close(fdRX);
 if (logFlag) {
	if (log_count) write(log_fid, log_buf, log_count);
	close(log_fid);
 }
}  /*  of FreeGbl()  */

/****************************************************************************/
/*  manage the initialization of MICE					    */
/****************************************************************************/

InitMICE()
{
 int	    i;

 /*  define linking viewport  */

 if ( ( VPLink = wn_def( 0, 0, 25, 80, LBLA_CYA, BDR_NULLP ) ) != NULLP ) {

    if ( ( AdapterType == PGS ) || ( AdapterType == MCGA ) )
       sw_att( LWHI_CYA, VPLink );

    sw_opt( CSRPLACE, ON, VPLink );

    if ( wn_up( VPLink ) == 0 ) {

       wn_free( VPLink );
       ErrorCondition = MEM_INSUFFICIENT;
       return( FALSE );
    }

 } else {

    ErrorCondition = MEM_INSUFFICIENT;
    return( FALSE );
 }

 /*  display the USD-III release information  */
//Frank, 12/07/95, change V2.5d to V2.6
 v_stattpl( 2, CENTER_TEXT, "                USD-III Version 2.6               ",
	    LCYA_BLU, STATT, VPLink );

/* CORE 90.08.15 Change Message From MII To CD */

#ifdef NEC_PC9801 /*NEC_PC9801*/

 v_stattpl( 3, CENTER_TEXT, "   CORE DIGITAL Co.,Ltd. Copyright 1995-1996   ",
	    LCYA_BLU, STATT, VPLink );
 v_stattpl( 4, CENTER_TEXT, " MICROTEK International Inc., Copyright 1995-1996 ",
	    LCYA_BLU, STATT, VPLink );

#else /*NEC_PC9801*/

 v_stattpl( 3, CENTER_TEXT, " MICROTEK International Inc., Copyright 1995-1996 ",
	    LCYA_BLU, STATT, VPLink );

#endif /*NEC_PC9801*/

 /*  read "USD3.INS"  */

 ReadUSD3INS();

 /*  linking MICE loop  */

 while ( 1 ) {

   /*  initialize the communication port  */

   if ( ( i = InitPort() ) == ( 1 - OK ) ) {

      ErrorCondition = CANNOT_LOAD_HANDLER;
      return( FALSE );
   
   } else if ( i != ESC ) {  /*  initialization of the communication port is
				successful, try to link MICE  */

	     if ( ( i = LinkMICE() ) != OK ) {

	        if ( !PORT )  rstint();

	        if ( i == ESC )

		   if ( LinkMICEDlgBox(" Terminated by user ")==RETRYLINKMICE )
		      goto retry;
		   else  return ( FALSE );

	        else

		   if ( LinkMICEDlgBox(" Please check MICE ")==RETRYLINKMICE )
		      goto retry;
		   else  return ( FALSE );

	     } else  break;  /*  linking MICE is successful  */

	  } else {  /*  user terminate the initialization of the communication port  */

	     if ( !PORT )  rstint();

	     if ( LinkMICEDlgBox( " Terminated by user " ) == RETRYLINKMICE )
	        goto retry;
	     else  return ( FALSE );
	  }

   retry:

   for ( VPLink->r = 7; VPLink->r <= 24; VPLink->r++ )
       v_stcpy( SpaceLine, TO_WN, ROW, VPLink );

 }  /*  of while ( 1 )  */

 v_st( "\n\n                 ( Linking MICE successfully, please wait... )", VPLink );

 if (InitMICEGbls() == FALSE || ReadCmdWordFile() == FALSE ) {

    wn_dn( VPLink );
    wn_free( VPLink );
    return( FALSE );
 }

 if (!MAXFlag) init_sw();

 /*  free linking viewport  */

 wn_dn( VPLink );
 wn_free( VPLink );
 VPLink = NULLP;

 return( TRUE );

}  /*  of InitMICE()  */

/****************************************************************************/
/*									    */
/****************************************************************************/

WmClose()
{
 int  i;

 if ( !PORT )  rstint();

 for ( i = 0; i <= 25; i++ ) {

     if ( CmdWord[i][0] != NULL )  free( CmdWord[i][0] );
     if ( CmdWord[i][1] != NULL )  free( CmdWord[i][1] );
 }

 if ( SymLoaded == OK )  free_all();
 if ( cmd_logged == TRUE )  Blog_close();
 if ( out_logged == TRUE )  Olog_close();
}

/****************************************************************************/
/*  create menus							    */
/****************************************************************************/

CreateMenu()
{
 int  FreeVP = 0, i, j;

 /*  define menu-bar and all pull-down menus  */

 if ( ( MenuBar = mn_def(MNSTANDARD,0,0,1,80,LMNINACT,BDR_NULLP) ) == NULLP )
    return( FALSE );

 for ( i = FILMENU; i <= LSAMENU; i++ ) {

     Menu[i] = mn_defauto( MNAUTOSELECT, LMNINACT, BDR_DLNP );
     if ( Menu[i] == NULLP ) { FreeVP = 1; break; }
 }

 if ( FreeVP ) {

    DestroyMenu();
    return( FALSE );

 } else {

  sfm_help( "*FileMenu",	Menu[FILMENU] );
  sfm_help( "*SetupMenu",	Menu[SETMENU] );
  sfm_help( "*MemoryMenu",	Menu[MEMMENU] );
  sfm_help( "*EmulationMenu",	Menu[EMUMENU] );
  sfm_help( "*TraceMenu",	Menu[TRAMENU] );
  sfm_help( "*SymbolMenu",	Menu[SYMMENU] );
  sfm_help( "*OptionsMenu",	Menu[OPTMENU] );
  sfm_help( "*SpaMenu",		Menu[SPAMENU] );
  sfm_help( "*LsaMenu",		Menu[LSAMENU] );
 }

 /*  define menu-items of menu-bar  */

 if ( ( ( MenuBarItem[0]  = mnf_def( 0, 4,  "File",	 NULLP, Menu[0], MENUCALL, MenuBar ) ) == NULLP ) ||
      ( ( MenuBarItem[1]  = mnf_def( 0, 11, "Setup",     NULLP, Menu[1], MENUCALL, MenuBar ) ) == NULLP ) ||
      ( ( MenuBarItem[2]  = mnf_def( 0, 19, "Memory",    NULLP, Menu[2], MENUCALL, MenuBar ) ) == NULLP ) ||
      ( ( MenuBarItem[3]  = mnf_def( 0, 28, "Emulation", NULLP, Menu[3], MENUCALL, MenuBar ) ) == NULLP ) ||
      ( ( MenuBarItem[4]  = mnf_def( 0, 40, "Trace",     NULLP, Menu[4], MENUCALL, MenuBar ) ) == NULLP ) ) {

    DestroyMenu();
    return( FALSE );
 }

 if ( ( ( MenuBarItem[5]  = mnf_def( 0, 48, "Symbol",  NULLP, Menu[5], MENUCALL, MenuBar ) ) == NULLP ) ||
      ( ( MenuBarItem[6]  = mnf_def( 0, 57, "Options", NULLP, Menu[6], MENUCALL, MenuBar ) ) == NULLP ) ||
      ( ( MenuBarItem[7]  = mnf_def( 0, 67, "Spa",     NULLP, Menu[7], MENUCALL, MenuBar ) ) == NULLP ) ||
      ( ( MenuBarItem[8]  = mnf_def( 0, 73, "Lsa",     NULLP, Menu[8], MENUCALL, MenuBar ) ) == NULLP ) ) {

    DestroyMenu();
    return( FALSE );

 } else {

    smnf_selectch( 1, LMNSELCH, MenuBarItem[5] );
    smnf_selectch( 1, LMNSELCH, MenuBarItem[7] );
 }

 /*  define menu-items of FILE menu  */

 if ( ( ( MenuItem[FILMENU][0] = mnf_def( 0, 0, "Download...",	      NULLP, NULLP, MN_F_DOWNLOAD,	Menu[FILMENU] ) ) == NULLP ) ||
      ( ( MenuItem[FILMENU][1] = mnf_def( 1, 0, "Upload...",	      NULLP, NULLP, MN_F_UPLOAD,	Menu[FILMENU] ) ) == NULLP ) ||
      ( ( MenuItem[FILMENU][2] = mnf_def( 2, 0, "Include...",	      NULLP, NULLP, MN_F_INCLUDE,	Menu[FILMENU] ) ) == NULLP ) ||
      ( ( MenuItem[FILMENU][3] = mnf_def( 3, 0, "Log File...",	      NULLP, NULLP, MN_F_LOG,		Menu[FILMENU] ) ) == NULLP ) ||
      ( ( MenuItem[FILMENU][4] = mnf_def( 4, 0, "Journal File...",    NULLP, NULLP, MN_F_JOURNAL,	Menu[FILMENU] ) ) == NULLP ) ) {

    DestroyMenu();
    return( FALSE );
 }

 if ( ( ( MenuItem[FILMENU][5] = mnf_def( 5, 0, "Close Log/Jou...",   NULLP, NULLP, MN_F_CLOSE_LOGJOU,	Menu[FILMENU] ) ) == NULLP ) ||
      ( ( MenuItem[FILMENU][6] = mnf_def( 6, 0, "Dos",		      NULLP, NULLP, MN_F_DOS,		Menu[FILMENU] ) ) == NULLP ) ||
      ( ( MenuItem[FILMENU][7] = mnf_def( 7, 0, "Quit",		      NULLP, NULLP, MN_F_QUIT,		Menu[FILMENU] ) ) == NULLP ) ||
      //Frank, 12/07/95, change V2.5d to V2.6
      ( ( MenuItem[FILMENU][8] = mnf_def( 8, 0, "Version 2.6",       NULLP, NULLP, MN_F_VERSION,   Menu[FILMENU] ) ) == NULLP ) ) {

    DestroyMenu();
    return( FALSE );

 } else {

    smnf_selectch( 1, LMNSELCH, MenuItem[FILMENU][6] );

    sf_help( "*FDownload",		MenuItem[FILMENU][0] );
    sf_help( "*FUpload",		MenuItem[FILMENU][1] );
    sf_help( "*FInclude",		MenuItem[FILMENU][2] );
    sf_help( "*FLog",			MenuItem[FILMENU][3] );
    sf_help( "*FJournal",		MenuItem[FILMENU][4] );
    sf_help( "*FCloseLogJournal",	MenuItem[FILMENU][5] );
    sf_help( "*FDos",			MenuItem[FILMENU][6] );
    sf_help( "*FQuit",			MenuItem[FILMENU][7] );
    sf_help( "*FVersion",		MenuItem[FILMENU][8] );
 }

 /*  define menu-items of SETUP menu  */

 if ( ( ( MenuItem[SETMENU][0] = mnf_def( 0, 0, "Map...", NULLP, NULLP, MN_S_MAP,    Menu[SETMENU] ) ) == NULLP ) ||
      ( ( MenuItem[SETMENU][1] = mnf_def( 1, 0, "Recall", NULLP, NULLP, MN_S_RECALL, Menu[SETMENU] ) ) == NULLP ) ||
      ( ( MenuItem[SETMENU][2] = mnf_def( 2, 0, "Save",   NULLP, NULLP, MN_S_SAVE,   Menu[SETMENU] ) ) == NULLP ) ) {

    DestroyMenu();
    return( FALSE );

 } else {

    sf_help( "*SMap",		MenuItem[SETMENU][0] );
    sf_help( "*SRecall",	MenuItem[SETMENU][1] );
    sf_help( "*SSave",		MenuItem[SETMENU][2] );
 }

 /*  define menu-items of MEMORY menu  */	 

 if ( ( ( MenuItem[MEMMENU][0] = mnf_def( 0, 0, "Checksum...",	  NULLP, NULLP, MN_M_CHECKSUM,	  Menu[MEMMENU] ) ) == NULLP ) ||
      ( ( MenuItem[MEMMENU][1] = mnf_def( 1, 0, "Compare...",	  NULLP, NULLP, MN_M_COMPARE,	  Menu[MEMMENU] ) ) == NULLP ) ||
      ( ( MenuItem[MEMMENU][2] = mnf_def( 2, 0, "Copy...",	  NULLP, NULLP, MN_M_COPY,	  Menu[MEMMENU] ) ) == NULLP ) ||
      ( ( MenuItem[MEMMENU][3] = mnf_def( 3, 0, "Disassembly...", NULLP, NULLP, MN_M_DISASSEMBLY, Menu[MEMMENU] ) ) == NULLP ) ||
      ( ( MenuItem[MEMMENU][4] = mnf_def( 4, 0, "Dump...",	  NULLP, NULLP, MN_M_DUMP,	  Menu[MEMMENU] ) ) == NULLP ) ) {

    DestroyMenu();
    return( FALSE );
 }

 if ( ( ( MenuItem[MEMMENU][5] = mnf_def( 5, 0, "Fill...",	  NULLP, NULLP, MN_M_FILL,	  Menu[MEMMENU] ) ) == NULLP ) ||
      ( ( MenuItem[MEMMENU][6] = mnf_def( 6, 0, "Search...",	  NULLP, NULLP, MN_M_SEARCH,	  Menu[MEMMENU] ) ) == NULLP ) ||
      ( ( MenuItem[MEMMENU][7] = mnf_def( 7, 0, "Test...",	  NULLP, NULLP, MN_M_TEST,	  Menu[MEMMENU] ) ) == NULLP ) ||
      ( ( MenuItem[MEMMENU][8] = mnf_def( 8, 0, "Data Monitor...",NULLP, NULLP, MN_M_MONITOR,	  Menu[MEMMENU] ) ) == NULLP ) ) {

    DestroyMenu();
    return( FALSE );

 } else {

    smnf_selectch( 1, LMNSELCH, MenuItem[MEMMENU][1] );
    smnf_selectch( 2, LMNSELCH, MenuItem[MEMMENU][2] );
    smnf_selectch( 1, LMNSELCH, MenuItem[MEMMENU][4] );
    smnf_selectch( 5, LMNSELCH, MenuItem[MEMMENU][8] );

    sf_help( "*MChecksum",	MenuItem[MEMMENU][0] );
    sf_help( "*MCompare",	MenuItem[MEMMENU][1] );
    sf_help( "*MCopy",		MenuItem[MEMMENU][2] );
    sf_help( "*MDisassembly",	MenuItem[MEMMENU][3] );
    sf_help( "*MDump",		MenuItem[MEMMENU][4] );
    sf_help( "*MFill",		MenuItem[MEMMENU][5] );
    sf_help( "*MSearch",	MenuItem[MEMMENU][6] );
    sf_help( "*MTest",		MenuItem[MEMMENU][7] );
    sf_help( "*MMonitor",	MenuItem[MEMMENU][8] );
 }

 /*  define menu-items of EMULATION menu  */

 if ( ( ( MenuItem[EMUMENU][0] = mnf_def( 0, 0, "Istep",	      NULLP, NULLP, MN_E_ISTEP,		     Menu[EMUMENU] ) ) == NULLP ) ||
      ( ( MenuItem[EMUMENU][1] = mnf_def( 1, 0, "Istep Over",	      NULLP, NULLP, MN_E_ISTEP_OVER,	     Menu[EMUMENU] ) ) == NULLP ) ||
      ( ( MenuItem[EMUMENU][2] = mnf_def( 2, 0, "Istep Forever",      NULLP, NULLP, MN_E_ISTEP_FOREVER,	     Menu[EMUMENU] ) ) == NULLP ) ||
      ( ( MenuItem[EMUMENU][3] = mnf_def( 3, 0, "Istep Over Forever", NULLP, NULLP, MN_E_ISTEP_OVER_FOREVER, Menu[EMUMENU] ) ) == NULLP ) ||
      ( ( MenuItem[EMUMENU][4] = mnf_def( 4, 0, "Cycle",	      NULLP, NULLP, MN_E_CYCLE,		     Menu[EMUMENU] ) ) == NULLP ) ) {

    DestroyMenu();
    return( FALSE );

 } else {

    smnf_selectch( 1, LMNSELCH, MenuItem[EMUMENU][0] );
    smnf_selectch( 6, LMNSELCH, MenuItem[EMUMENU][1] );
    smnf_selectch( 6, LMNSELCH, MenuItem[EMUMENU][2] );
    smnf_selectch( 2, LMNSELCH, MenuItem[EMUMENU][3] );

    sf_help( "*EIstep",			MenuItem[EMUMENU][0] );
    sf_help( "*EIstepOver",		MenuItem[EMUMENU][1] );
    sf_help( "*EIstepForever",		MenuItem[EMUMENU][2] );
    sf_help( "*EIstepOverForever",	MenuItem[EMUMENU][3] );
    sf_help( "*ECycle",			MenuItem[EMUMENU][4] );
 }

 /*  define menu-items of TRACE menu  */

 if ( ( ( MenuItem[TRAMENU][0] = mnf_def( 0, 0, "S/W Breakpoint...", NULLP, NULLP, MN_T_SW,	  Menu[TRAMENU] ) ) == NULLP ) ||
      ( ( MenuItem[TRAMENU][1] = mnf_def( 1, 0, "Break On Read...",  NULLP, NULLP, MN_T_BREAK,	  Menu[TRAMENU] ) ) == NULLP ) ||
      ( ( MenuItem[TRAMENU][2] = mnf_def( 2, 0, "Event...",	     NULLP, NULLP, MN_T_EVENT,	  Menu[TRAMENU] ) ) == NULLP ) ||
      ( ( MenuItem[TRAMENU][3] = mnf_def( 3, 0, "Trigger Level...",  NULLP, NULLP, MN_T_TRIGGER,  Menu[TRAMENU] ) ) == NULLP ) ||
      ( ( MenuItem[TRAMENU][4] = mnf_def( 4, 0, "Trace Control...",  NULLP, NULLP, MN_T_TRACE,	  Menu[TRAMENU] ) ) == NULLP ) ) {

    DestroyMenu();
    return( FALSE );
 }

 if ( ( ( MenuItem[TRAMENU][5] = mnf_def( 5, 0, "Backward Trace...", NULLP, NULLP, MN_T_BACKWARD, Menu[TRAMENU] ) ) == NULLP ) ||
      ( ( MenuItem[TRAMENU][6] = mnf_def( 6, 0, "Forward  Trace...", NULLP, NULLP, MN_T_FORWARD,  Menu[TRAMENU] ) ) == NULLP ) ||
      ( ( MenuItem[TRAMENU][7] = mnf_def( 7, 0, "Go",		     NULLP, NULLP, MN_T_GO,	  Menu[TRAMENU] ) ) == NULLP ) ||
      ( ( MenuItem[TRAMENU][8] = mnf_def( 8, 0, "Halt",		     NULLP, NULLP, MN_T_HALT,	  Menu[TRAMENU] ) ) == NULLP ) ||
      ( ( MenuItem[TRAMENU][9] = mnf_def( 9, 0, "List...",	     NULLP, NULLP, MN_T_LIST,	  Menu[TRAMENU] ) ) == NULLP ) ) {

    DestroyMenu();
    return( FALSE );

 } else {

    smnf_selectch( 4, LMNSELCH, MenuItem[TRAMENU][1] );
    smnf_selectch( 1, LMNSELCH, MenuItem[TRAMENU][3] );

    sf_help( "*TSoftwareBreak",	MenuItem[TRAMENU][0] );
    sf_help( "*TBreak",		MenuItem[TRAMENU][1] );
    sf_help( "*TEvent",		MenuItem[TRAMENU][2] );
    sf_help( "*TTriggerLevel",	MenuItem[TRAMENU][3] );
    if (HaveLAM2) sf_help( "*TLAM2Trace",       MenuItem[TRAMENU][4] );
    else          sf_help( "*TTrace",		MenuItem[TRAMENU][4] );
    sf_help( "*TBackward",	MenuItem[TRAMENU][5] );
    sf_help( "*TForward",	MenuItem[TRAMENU][6] );
    sf_help( "*TGo",		MenuItem[TRAMENU][7] );
    sf_help( "*THalt",		MenuItem[TRAMENU][8] );
    sf_help( "*TList",		MenuItem[TRAMENU][9] );
 }

 /*  define menu-items of SYMBOL menu  */

 if ( ( ( MenuItem[SYMMENU][0] = mnf_def( 0, 0, "List",		    NULLP, NULLP, MN_Y_LIST,	Menu[SYMMENU] ) ) == NULLP ) ||
      ( ( MenuItem[SYMMENU][1] = mnf_def( 1, 0, "Load...",	    NULLP, NULLP, MN_Y_LOAD,	Menu[SYMMENU] ) ) == NULLP ) ||
      ( ( MenuItem[SYMMENU][2] = mnf_def( 2, 0, "Create...",	    NULLP, NULLP, MN_Y_CREATE,	Menu[SYMMENU] ) ) == NULLP ) ||
      ( ( MenuItem[SYMMENU][3] = mnf_def( 3, 0, "Delete...",	    NULLP, NULLP, MN_Y_DELETE,	Menu[SYMMENU] ) ) == NULLP ) ||
      ( ( MenuItem[SYMMENU][4] = mnf_def( 4, 0, "Module",	    NULLP, NULLP, MN_Y_MODULE,	Menu[SYMMENU] ) ) == NULLP ) ) {

    DestroyMenu();
    return( FALSE );
 }

 if ( ( ( MenuItem[SYMMENU][5] = mnf_def( 5, 0, "Ssave...",         NULLP, NULLP, MN_Y_SSAVE,	Menu[SYMMENU] ) ) == NULLP ) ||
      ( ( MenuItem[SYMMENU][6] = mnf_def( 6, 0, "Srecall...",       NULLP, NULLP, MN_Y_SRECALL, Menu[SYMMENU] ) ) == NULLP ) ||
      ( ( MenuItem[SYMMENU][7] = mnf_def( 7, 0, "Symbol Query...",  NULLP, NULLP, MN_Y_SYMBOL,	Menu[SYMMENU] ) ) == NULLP ) ||
      ( ( MenuItem[SYMMENU][8] = mnf_def( 8, 0, "Address Query...", NULLP, NULLP, MN_Y_ADDRESS, Menu[SYMMENU] ) ) == NULLP ) ) {

    DestroyMenu();
    return( FALSE );

 } else {

    smnf_selectch( 1, LMNSELCH, MenuItem[SYMMENU][1] );
    smnf_selectch( 2, LMNSELCH, MenuItem[SYMMENU][5] );
    smnf_selectch( 1, LMNSELCH, MenuItem[SYMMENU][6] );

    sf_help( "*YList",		MenuItem[SYMMENU][0] );
    sf_help( "*YLoad",		MenuItem[SYMMENU][1] );
    sf_help( "*YCreate",	MenuItem[SYMMENU][2] );
    sf_help( "*YDelete",	MenuItem[SYMMENU][3] );
    sf_help( "*YModule",	MenuItem[SYMMENU][4] );
    sf_help( "*YSsave",		MenuItem[SYMMENU][5] );
    sf_help( "*YSrecall",	MenuItem[SYMMENU][6] );
    sf_help( "*YSymbol",	MenuItem[SYMMENU][7] );
    sf_help( "*YAddress",	MenuItem[SYMMENU][8] );
 }

 /*  define menu-items of OPTIONS menu  */

 if ( ( ( MenuItem[OPTMENU][0] = mnf_def( 0, 0, "Toggle Status...",	  NULLP, NULLP, MN_O_TOGGLE,  Menu[OPTMENU] ) ) == NULLP ) ||
      ( ( MenuItem[OPTMENU][1] = mnf_def( 1, 0, "Update Viewport...",	  NULLP, NULLP, MN_O_UPDATE,  Menu[OPTMENU] ) ) == NULLP ) ||
      ( ( MenuItem[OPTMENU][2] = mnf_def( 2, 0, "Define Softkey...",	  NULLP, NULLP, MN_O_DEFINE,  Menu[OPTMENU] ) ) == NULLP ) ||
      ( ( MenuItem[OPTMENU][3] = mnf_def( 3, 0, "Usav...",		  NULLP, NULLP, MN_O_USAVE,   Menu[OPTMENU] ) ) == NULLP ) ||
      ( ( MenuItem[OPTMENU][4] = mnf_def( 4, 0, "Urecall...",		  NULLP, NULLP, MN_O_URECALL, Menu[OPTMENU] ) ) == NULLP ) ) {

    DestroyMenu();
    return( FALSE );

 } else {

    smnf_selectch( 1, LMNSELCH, MenuItem[OPTMENU][3] );
    smnf_selectch( 1, LMNSELCH, MenuItem[OPTMENU][4] );

    sf_help( "*OToggle",	MenuItem[OPTMENU][0] );
    sf_help( "*OUpdate",	MenuItem[OPTMENU][1] );
    sf_help( "*ODefine",	MenuItem[OPTMENU][2] );
    sf_help( "*OUsave",		MenuItem[OPTMENU][3] );
    sf_help( "*OUrecall",	MenuItem[OPTMENU][4] );
 }

 if ( ( ( MenuItem[OPTMENU][5] = mnf_def( 5, 0, "Dialog Color...",	  NULLP, NULLP, MN_O_DLGCOLOR, Menu[OPTMENU] ) ) == NULLP ) ) {

    DestroyMenu();
    return( FALSE );

 } else {

    smnf_selectch( 7, LMNSELCH, MenuItem[OPTMENU][5] );

    sf_help( "*ODlgColor",	MenuItem[OPTMENU][5] );
 }

 /*  define menu-items of SPA menu  */

 if ( ( ( MenuItem[SPAMENU][0] = mnf_def( 0, 0, "Entry",    NULLP, NULLP, MN_P_ENTRY,    Menu[SPAMENU] ) ) == NULLP ) ||
      ( ( MenuItem[SPAMENU][1] = mnf_def( 1, 0, "Duration", NULLP, NULLP, MN_P_DURATION, Menu[SPAMENU] ) ) == NULLP ) ||
      ( ( MenuItem[SPAMENU][2] = mnf_def( 2, 0, "Time",     NULLP, NULLP, MN_P_TIME,     Menu[SPAMENU] ) ) == NULLP ) ||
      ( ( MenuItem[SPAMENU][3] = mnf_def( 3, 0, "Coverage", NULLP, NULLP, MN_P_COVERAGE, Menu[SPAMENU] ) ) == NULLP ) ) {

    DestroyMenu();
    return( FALSE );

 } else {

    sf_help( "*PEntry",		MenuItem[SPAMENU][0] );
    sf_help( "*PDuration",	MenuItem[SPAMENU][1] );
    sf_help( "*PTime",		MenuItem[SPAMENU][2] );
    sf_help( "*SPACoverage",	MenuItem[SPAMENU][3] );
 }

 /*  define menu-items of LSA menu  */

 if ( ( ( MenuItem[LSAMENU][0] = mnf_def( 0, 0, "Lsa", NULLP, NULLP, MN_L_LSA, Menu[LSAMENU] ) ) == NULLP ) ) {

    DestroyMenu();
    return( FALSE );

 } else {

    sf_help( "*LsaMenu",	MenuItem[LSAMENU][0] );
 }

 /*  show menu-bar  */

 if ( mn_up( MenuBar ) == 0 ) {

    DestroyMenu();
    return( FALSE );
 }

 return( TRUE );

}  /*  of CreateMenu()  */

/****************************************************************************/
/*  create viewports							    */
/****************************************************************************/

CreateVP()
{
 int   FreeVP = 0, i, j;
 char  c[2];

 /*  set the position, size and color of each viewport  */

 VP[REGVP].yOrg   = 1;
 VP[REGVP].xOrg   = 0;
 REGVPLine = ( VP[REGVP].Height = CountREGVPHeight() ) - 2;
 VP[REGVP].Width  = 80;
 VP[REGVP].Maxr   = REGBUFROW - 1;
 VP[REGVP].Maxc   = REGBUFCOL - 1;

 if ( ColorMode ) {

    if ( ( AdapterType == PGS ) || ( AdapterType == MCGA ) ) {

       VP[REGVP].TextColor     = WHICOLOR;
       VP[REGVP].BackgrndColor = WHICOLOR;

    } else {

/* CORE 90.08.014 */

#ifdef NEC_PC9801

       VP[REGVP].TextColor     = WHICOLOR;
       VP[REGVP].BackgrndColor = BLACOLOR;

#else

       VP[REGVP].TextColor     = WHICOLOR;
       VP[REGVP].BackgrndColor = BLUCOLOR;

#endif

    }

 } else {

    VP[REGVP].TextColor	    = WHICOLOR;
    VP[REGVP].BackgrndColor = BLACOLOR;
 }

 VP[COMVP].Height = 7;
 VP[COMVP].Width  = VP[REGVP].Width;
 VP[COMVP].yOrg   = 25 - VP[COMVP].Height - 1;  /*  "- 1" is for function key viewport  */
 VP[COMVP].xOrg   = VP[REGVP].xOrg;
 VP[COMVP].Maxr   = COMBUFROW - 1;
 VP[COMVP].Maxc   = COMBUFCOL - 1;

 if ( ColorMode ) {

    if ( ( AdapterType == PGS ) || ( AdapterType == MCGA ) ) {

       VP[COMVP].TextColor     = WHICOLOR;
       VP[COMVP].BackgrndColor = WHICOLOR;

    } else {

/* CORE 90.08.014 */

#ifdef NEC_PC9801

       VP[COMVP].TextColor     = WHICOLOR;
       VP[COMVP].BackgrndColor = BLACOLOR;

#else

       VP[COMVP].TextColor     = BLACOLOR;
       VP[COMVP].BackgrndColor = CYACOLOR;

#endif

    }

 } else {

    VP[COMVP].TextColor	    = WHICOLOR;
    VP[COMVP].BackgrndColor = BLACOLOR;
 }

 VP[CODVP].yOrg   = VP[REGVP].yOrg + VP[REGVP].Height - 1;
 VP[CODVP].xOrg   = VP[REGVP].xOrg;
 VP[CODVP].Height = 23 - VP[REGVP].Height - VP[COMVP].Height + 2;
 VP[CODVP].Width  = VP[REGVP].Width;
 VP[CODVP].Maxr   = CODBUFROW - 1;
 VP[CODVP].Maxc   = CODBUFCOL - 1;

 if ( ColorMode ) {

    if ( ( AdapterType == PGS ) || ( AdapterType == MCGA ) ) {

       VP[CODVP].TextColor     = WHICOLOR;
       VP[CODVP].BackgrndColor = WHICOLOR;

    } else {

/* CORE 90.08.014 */

#ifdef NEC_PC9801

       VP[CODVP].TextColor     = WHICOLOR;
       VP[CODVP].BackgrndColor = BLACOLOR;

#else

       VP[CODVP].TextColor     = WHICOLOR;
       VP[CODVP].BackgrndColor = BLACOLOR;

#endif

    }

 } else {

    VP[CODVP].TextColor	    = WHICOLOR;
    VP[CODVP].BackgrndColor = BLACOLOR;
 }

 VP[BREVP].yOrg   = VP[REGVP].yOrg;
 VP[BREVP].xOrg   = VP[REGVP].xOrg;
 VP[BREVP].Height = VP[REGVP].Height;
 VP[BREVP].Width  = VP[REGVP].Width;
 VP[BREVP].Maxr   = BREBUFROW - 1;
 VP[BREVP].Maxc   = BREBUFCOL - 1;

 if ( ColorMode ) {

    if ( ( AdapterType == PGS ) || ( AdapterType == MCGA ) ) {

       VP[BREVP].TextColor     = WHICOLOR;
       VP[BREVP].BackgrndColor = WHICOLOR;

    } else {

/* CORE 90.08.014 */

#ifdef NEC_PC9801

       VP[BREVP].TextColor     = WHICOLOR;
       VP[BREVP].BackgrndColor = BLACOLOR;

#else

       VP[BREVP].TextColor     = WHICOLOR;
       VP[BREVP].BackgrndColor = BLUCOLOR;

#endif

    }

 } else {

    VP[BREVP].TextColor	    = WHICOLOR;
    VP[BREVP].BackgrndColor = BLACOLOR;
 }

 VP[TRAVP].yOrg   = VP[REGVP].yOrg;
 VP[TRAVP].xOrg   = VP[REGVP].xOrg;
 VP[TRAVP].Height = VP[REGVP].Height;
 VP[TRAVP].Width  = VP[REGVP].Width;
 VP[TRAVP].Maxr   = TRABUFROW - 1;
 VP[TRAVP].Maxc   = TRABUFCOL - 1;

 if ( ColorMode ) {

    if ( ( AdapterType == PGS ) || ( AdapterType == MCGA ) ) {

       VP[TRAVP].TextColor     = WHICOLOR;
       VP[TRAVP].BackgrndColor = WHICOLOR;

    } else {

/* CORE 90.08.014 */

#ifdef NEC_PC9801

       VP[TRAVP].TextColor     = WHICOLOR;
       VP[TRAVP].BackgrndColor = BLACOLOR;

#else

       VP[TRAVP].TextColor     = WHICOLOR;
       VP[TRAVP].BackgrndColor = BLUCOLOR;

#endif

    }

 } else {

    VP[TRAVP].TextColor	    = WHICOLOR;
    VP[TRAVP].BackgrndColor = BLACOLOR;
 }

 VP[STAVP].Height = VP[CODVP].Height;
 VP[STAVP].Width  = CountSTAVPWidth();
 VP[STAVP].yOrg   = VP[CODVP].yOrg;
 VP[STAVP].xOrg   = 80 - VP[STAVP].Width;
 VP[STAVP].Maxr   = STABUFROW - 1;
 VP[STAVP].Maxc   = STABUFCOL - 1;

 if ( ColorMode ) {

    if ( ( AdapterType == PGS ) || ( AdapterType == MCGA ) ) {

       VP[STAVP].TextColor     = WHICOLOR;
       VP[STAVP].BackgrndColor = WHICOLOR;

    } else {

/* CORE 90.08.014 */

#ifdef NEC_PC9801

       VP[STAVP].TextColor     = WHICOLOR;
       VP[STAVP].BackgrndColor = BLACOLOR;

#else

       VP[STAVP].TextColor     = BLACOLOR;
       VP[STAVP].BackgrndColor = WHICOLOR;

#endif

    }

 } else {

    VP[STAVP].TextColor	    = WHICOLOR;
    VP[STAVP].BackgrndColor = BLACOLOR;
 }

 VP[DATVP].Height = VP[STAVP].Height;
 VP[DATVP].Width  = 34;	 /*  includes viewport border  */
 VP[DATVP].yOrg   = VP[STAVP].yOrg;
 VP[DATVP].xOrg   = 80 - VP[DATVP].Width;
 VP[DATVP].Maxr   = DATBUFROW - 1;
 VP[DATVP].Maxc   = DATBUFCOL - 1;

 if ( ColorMode ) {

    if ( ( AdapterType == PGS ) || ( AdapterType == MCGA ) ) {

       VP[DATVP].TextColor     = WHICOLOR;
       VP[DATVP].BackgrndColor = WHICOLOR;

    } else {

/* CORE 90.08.014 */

#ifdef NEC_PC9801

       VP[DATVP].TextColor     = WHICOLOR;
       VP[DATVP].BackgrndColor = BLACOLOR;

#else

       VP[DATVP].TextColor     = BLACOLOR;
       VP[DATVP].BackgrndColor = WHICOLOR;

#endif

    }

 } else {

    VP[DATVP].TextColor	    = WHICOLOR;
    VP[DATVP].BackgrndColor = BLACOLOR;
 }

 /*  define viewports  */

 for ( i = BREVP; i <= DATVP; i++ ) {

     if	      ( ( i == BREVP ) || ( i == REGVP ) || ( i == TRAVP ) )

	      VP[i].Ptr = wn_def( VP[i].yOrg, VP[i].xOrg,
				  VP[i].Height, VP[i].Width,
				  COLOR(VP[i].TextColor,VP[i].BackgrndColor),
				  &TopVPBdr );

     else  if ( i == CODVP )

	      VP[i].Ptr = wn_def( VP[i].yOrg, VP[i].xOrg,
				  VP[i].Height, VP[i].Width,
				  COLOR(VP[i].TextColor,VP[i].BackgrndColor),
				  &MiddleVPBdr );

     else  if ( ( i == STAVP ) || ( i == DATVP ) )

	      VP[i].Ptr = wn_def( VP[i].yOrg, VP[i].xOrg,
				  VP[i].Height, VP[i].Width,
				  COLOR(VP[i].TextColor,VP[i].BackgrndColor),
				  &RightVPBdr );

     else
	      VP[i].Ptr = wn_def( VP[i].yOrg, VP[i].xOrg,
				  VP[i].Height, VP[i].Width,
				  COLOR(VP[i].TextColor,VP[i].BackgrndColor),
				  &BottomVPBdr );

     if ( VP[i].Ptr == NULLP ) { FreeVP = 1; break; }
 }

 if ( FreeVP ) {

    DestroyVP();
    return( FALSE );
 }

 /*  allocate display-buffer of each viewport  */

 if ( ( ( VP[BREVP].Buf = ms_def( BREBUFROW, BREBUFCOL, COLOR( VP[BREVP].TextColor, VP[BREVP].BackgrndColor ) ) ) == NULLP ) ||
      ( ( VP[CODVP].Buf = ms_def( CODBUFROW, CODBUFCOL, COLOR( VP[CODVP].TextColor, VP[CODVP].BackgrndColor ) ) ) == NULLP ) ||
      ( ( VP[COMVP].Buf = ms_def( COMBUFROW, COMBUFCOL, COLOR( VP[COMVP].TextColor, VP[COMVP].BackgrndColor ) ) ) == NULLP ) ) {

    DestroyVP();
    return( FALSE );
 }

 if ( ( ( VP[REGVP].Buf = ms_def( REGBUFROW, REGBUFCOL, COLOR( VP[REGVP].TextColor, VP[REGVP].BackgrndColor ) ) ) == NULLP ) ||
      ( ( VP[STAVP].Buf = ms_def( STABUFROW, STABUFCOL, COLOR( VP[STAVP].TextColor, VP[STAVP].BackgrndColor ) ) ) == NULLP ) ||
      ( ( VP[TRAVP].Buf = ms_def( TRABUFROW, TRABUFCOL, COLOR( VP[TRAVP].TextColor, VP[TRAVP].BackgrndColor ) ) ) == NULLP ) ||
      ( ( VP[DATVP].Buf = ms_def( DATBUFROW, DATBUFCOL, COLOR( VP[DATVP].TextColor, VP[DATVP].BackgrndColor ) ) ) == NULLP ) ) {

    DestroyVP();
    return( FALSE );
 }

 /*  link display-buffer to each viewport  */

 for ( i = BREVP; i <= DATVP; i++ )  sw_msbuf( VP[i].Buf, VP[i].Ptr );

 /*  set the title, border and scroll-bar of each viewport  */

 sw_title( " BREAKPOINT ", LVPTITLEINACT, TOPCENTER, VP[BREVP].Ptr );
 sw_sb( AUTOUPD, VSBAR, VP[BREVP].Ptr );
 sw_bdratt( LVPBDR, VP[BREVP].Ptr );
 sw_opt( TRACKING, OFF, VP[BREVP].Ptr );
 sw_opt( CSRPLACE, OFF, VP[BREVP].Ptr );
 sw_opt( CLRENDROW, OFF, VP[BREVP].Ptr );
 sw_opt( POPUP, OFF, VP[BREVP].Ptr );
 sw_opt( WORDWRAP, OFF, VP[BREVP].Ptr );

 sw_title( " CODE ", LVPTITLEINACT, TOPCENTER, VP[CODVP].Ptr );
 sw_sb( AUTOUPD, VSBAR, VP[CODVP].Ptr );
 sw_bdratt( LVPBDR, VP[CODVP].Ptr );
 sw_opt( TRACKING, OFF, VP[CODVP].Ptr );
 sw_opt( CSRPLACE, OFF, VP[CODVP].Ptr );
 sw_opt( CLRENDROW, OFF, VP[CODVP].Ptr );
 sw_opt( POPUP, OFF, VP[CODVP].Ptr );
 sw_opt( WORDWRAP, OFF, VP[CODVP].Ptr );

 VPOut = ActVP = COMVP;

 sw_title( " COMMAND ", LVPTITLEACT, TOPCENTER, VP[COMVP].Ptr );
 sw_sb( AUTOUPD, VSBAR, VP[COMVP].Ptr );
 sw_bdratt( LVPBDR, VP[COMVP].Ptr );
 sw_opt( TRACKING, ON, VP[COMVP].Ptr );
 sw_opt( CSRPLACE, ON, VP[COMVP].Ptr );
 sw_opt( CLRENDROW, OFF, VP[COMVP].Ptr );
 sw_opt( POPUP, OFF, VP[COMVP].Ptr );
 sw_opt( WORDWRAP, OFF, VP[COMVP].Ptr );

 TopVP = REGVP;

 sw_title( " REGISTER ", LVPTITLEINACT, TOPCENTER, VP[REGVP].Ptr );
 sw_sb( AUTOUPD, VSBAR, VP[REGVP].Ptr );
 sw_bdratt( LVPBDR, VP[REGVP].Ptr );
 sw_opt( TRACKING, OFF, VP[REGVP].Ptr );
 sw_opt( CSRPLACE, OFF, VP[REGVP].Ptr );
 sw_opt( CLRENDROW, OFF, VP[REGVP].Ptr );
 sw_opt( POPUP, OFF, VP[REGVP].Ptr );
 sw_opt( WORDWRAP, OFF, VP[REGVP].Ptr );

 sw_title( " STACK ", LVPTITLEINACT, TOPCENTER, VP[STAVP].Ptr );
 sw_sb( AUTOUPD, VSBAR, VP[STAVP].Ptr );
 sw_bdratt( LVPBDR, VP[STAVP].Ptr );
 sw_opt( TRACKING, OFF, VP[STAVP].Ptr );
 sw_opt( CSRPLACE, OFF, VP[STAVP].Ptr );
 sw_opt( CLRENDROW, OFF, VP[STAVP].Ptr );
 sw_opt( POPUP, OFF, VP[STAVP].Ptr );
 sw_opt( WORDWRAP, OFF, VP[STAVP].Ptr );

 sw_title( " TRACE ", LVPTITLEINACT, TOPCENTER, VP[TRAVP].Ptr );
 sw_sb( AUTOUPD, VSBAR, VP[TRAVP].Ptr );
 sw_bdratt( LVPBDR, VP[TRAVP].Ptr );
 sw_opt( TRACKING, OFF, VP[TRAVP].Ptr );
 sw_opt( CSRPLACE, OFF, VP[TRAVP].Ptr );
 sw_opt( CLRENDROW, OFF, VP[TRAVP].Ptr );
 sw_opt( POPUP, OFF, VP[TRAVP].Ptr );
 sw_opt( WORDWRAP, OFF, VP[TRAVP].Ptr );

 sw_title( " DATA ", LVPTITLEINACT, TOPCENTER, VP[DATVP].Ptr );
 sw_sb( AUTOUPD, VSBAR, VP[DATVP].Ptr );
 sw_bdratt( LVPBDR, VP[DATVP].Ptr );
 sw_opt( TRACKING, OFF, VP[DATVP].Ptr );
 sw_opt( CSRPLACE, OFF, VP[DATVP].Ptr );
 sw_opt( CLRENDROW, OFF, VP[DATVP].Ptr );
 sw_opt( POPUP, OFF, VP[DATVP].Ptr );
 sw_opt( WORDWRAP, OFF, VP[DATVP].Ptr );

 /*  open "USD3.SAV" for reading  */

 if ( ( USD3SAVFileHan = open( "USD3.SAV", O_RDONLY ) ) != -1 ) {

    /*  read viewport information ( screen layout ) from "USD3.SAV"  */

    read( USD3SAVFileHan, c, 1 );

    if ( c[0] == '1' ) {

       if ( ReadVPInfoFromUSD3SAV() == FALSE ) {

	 DestroyVP();
	 return( FALSE );

       } else  csr_plwn( VP[COMVP].Ptr );

    } else {

      if ( ( wn_up( VP[REGVP].Ptr ) == 0 ) || ( wn_up( VP[CODVP].Ptr ) == 0 ) ||
	   ( wn_up( VP[COMVP].Ptr ) == 0 ) ) {

	 DestroyVP();
	 return( FALSE );

      } else  csr_plwn( VP[COMVP].Ptr );
    }

    /*  read softkey definitions from "USD3.SAV"  */

    lseek( USD3SAVFileHan, (long) ( 7 * VPINFOBUFSIZE ), SEEK_SET );
    read( USD3SAVFileHan, c, 1 );
    if ( c[0] == '1' )  ReadSoftKeyFromUSD3SAV();
 
    /*  close "USD3.SAV"  */

    close( USD3SAVFileHan );

 } else {

    if ( ( wn_up( VP[REGVP].Ptr ) == 0 ) || ( wn_up( VP[CODVP].Ptr ) == 0 ) ||
	 ( wn_up( VP[COMVP].Ptr ) == 0 ) ) {

	 DestroyVP();
	 return( FALSE );

    } else  csr_plwn( VP[COMVP].Ptr );
 }

 /*  create function key viewport  */

 if ( ( ( FuncKeyVP = wn_def( 24, 0, 1, 80, LWHI_BLA, BDR_NULLP ) ) == NULLP ) ||
      ( ( FuncKeyVPBuf = ms_def( 1, 80, LWHI_BLA ) ) == NULLP ) ) {

    DestroyVP();
    return( FALSE );

 } else {

    sw_opt( POPUP, OFF, FuncKeyVP );
    sw_msbuf( FuncKeyVPBuf, FuncKeyVP );
 }

 if ( AdapterType == MDA )  i = LMNACT;
 else  i = LMNINACT;

 v_stattpl( 0, 0,  "1",      LWHI_BLA, STATT, FuncKeyVP );
 v_stattpl( 0, 1,  "Help  ", i,        STATT, FuncKeyVP );

 v_stattpl( 0, 8,  "2",      LWHI_BLA, STATT, FuncKeyVP );
 v_stattpl( 0, 9,  "Reset ", i,        STATT, FuncKeyVP );

 v_stattpl( 0, 16, "3",      LWHI_BLA, STATT, FuncKeyVP );
 v_stattpl( 0, 17, "IStep ", i,        STATT, FuncKeyVP );

 v_stattpl( 0, 24, "4",      LWHI_BLA, STATT, FuncKeyVP );
 v_stattpl( 0, 25, "IStepO", i,        STATT, FuncKeyVP );

 v_stattpl( 0, 32, "5",      LWHI_BLA, STATT, FuncKeyVP );
 v_stattpl( 0, 33, "TogREG", i,        STATT, FuncKeyVP );

 v_stattpl( 0, 40, "6",      LWHI_BLA, STATT, FuncKeyVP );
 v_stattpl( 0, 41, "TogSTA", i,        STATT, FuncKeyVP );

 v_stattpl( 0, 48, "7",      LWHI_BLA, STATT, FuncKeyVP );
 v_stattpl( 0, 49, "MaxCOM", i,        STATT, FuncKeyVP );

 v_stattpl( 0, 56, "8",      LWHI_BLA, STATT, FuncKeyVP );
 v_stattpl( 0, 57, "Active", i,        STATT, FuncKeyVP );

 v_stattpl( 0, 64, "9",      LWHI_BLA, STATT, FuncKeyVP );
 v_stattpl( 0, 65, "Enlarg", i,        STATT, FuncKeyVP );

 v_stattpl( 0, 72, "10",     LWHI_BLA, STATT, FuncKeyVP );
 v_stattpl( 0, 74, "Shrink", i,        STATT, FuncKeyVP );

 if ( wn_up( FuncKeyVP ) == 0 ) {

    DestroyVP();
    return( FALSE );
 }

 /*  create function key viewport  */

 if ( ( CmdHelpVP = wn_def( 24, 0, 1, 80, LMESSAGE, BDR_NULLP ) ) == NULLP ) {

    DestroyVP();
    return( FALSE );

 } else  sw_opt( POPUP, ON, CmdHelpVP );

 return( TRUE );

}  /*  of CreateVP()  */

/****************************************************************************/
/*									    */
/****************************************************************************/

UpdateFuncKeyVP()
{
 if ( wn_isup( FuncKeyVP ) )  wn_dn( FuncKeyVP );
 wn_up( FuncKeyVP );

}  /*  of UpdateFuncKeyVP()  */

/****************************************************************************/
/*  destroy menus							    */
/****************************************************************************/

DestroyMenu()
{
 int  i;

 if ( MenuBar != NULLP ) {

    if ( wn_isup( MenuBar->wnp ) )  mn_dn( MenuBar );
    mn_free( MenuBar );
 }

 for ( i = FILMENU; i <= LSAMENU; i++ ) 
   if ( Menu[i] != NULLP )  mn_free( Menu[i] );

}  /*  of DestroyMenu()  */

/****************************************************************************/
/*  destroy viewports							    */
/****************************************************************************/

DestroyVP()
{
 int  i;

 for ( i = BREVP; i <= DATVP; i++ ) {

   if ( VP[i].Buf != NULLP )  ms_free( VP[i].Buf );

   if ( VP[i].Ptr != NULLP ) {

      if ( wn_isup( VP[i].Ptr ) )  wn_dn( VP[i].Ptr );
      wn_free( VP[i].Ptr );
   }
 }

 if ( FuncKeyVPBuf != NULLP )  ms_free( FuncKeyVPBuf );

 if ( FuncKeyVP != NULLP ) {

    if ( wn_isup( FuncKeyVP ) )  wn_dn( FuncKeyVP );
    wn_free( FuncKeyVP );
 }

 if ( CmdHelpVP != NULLP ) {

    if ( wn_isup( CmdHelpVP ) )  wn_dn( CmdHelpVP );
    wn_free( CmdHelpVP );
 }

}  /*  of DestroyVP()  */

/****************************************************************************/
/*  count the viewport's height needed to show registers of each MICE model */
/****************************************************************************/

CountREGVPHeight()
{
 int  LFCount = 0;  /*  rows needed to show registers  */
 int  Len, i = 0;

 if (MAXFlag) return(6);

 if ( ! AbortTarget ) {

    do_1_cmd_save( "", MICEBuf, ( MICEBUFSIZE + 1 ) );

    if ( ( Len = strlen( MICEBuf ) ) >= 4 )
       if ( strcmpi( &( MICEBuf[ Len - 4 ] ), "RUN>" ) == 0 )  return( 6 );
 }

 do_1_cmd_save( "R", MICEBuf, ( MICEBUFSIZE + 1 ) );

 if ( strchr( MICEBuf, EXCL ) != NULL )  return( 6 );

 else  /*  count the rows needed to show registers  */

       while ( MICEBuf[i] != '\0' ) {

	     if  ( MICEBuf[i] == LF )  LFCount++;
	     i++;
       }

 return( LFCount + 2 );  /*  include border  */

}  /*  of CountREGVPHeight()  */

/****************************************************************************/
/*  count the viewport's width needed to show stack of each MICE model	    */
/****************************************************************************/

CountSTAVPWidth()
{
 if ( env.Maddrid < 3 )  return( env.Mcsiplen + 8 + 2 );  /*  include border  */
 else  return( env.Mcsiplen + 10 + 2 );  /*  include border  */

}  /*  of CountSTAVPWidth()  */

/****************************************************************************/
/*  set initial display of each viewport				    */
/****************************************************************************/

InitVPDisplay()
{
 int   Len, i;
 char  c;

 csr_mvwn( 0, 0, VP[COMVP].Ptr );

 MICEBuf[ MICEBUFSIZE ] = '\0';

 for ( i = MICEBUFSIZE/2 ; MICEBuf[i] != '\0'; i++ ) {

     if ( ( (c=MICEBuf[i]) != CR ) && ( c != LF ) && ( c != SP ) ) {

	DisplayStr( &MICEBuf[ MICEBUFSIZE/2 ] );
	break;
     }
 }

 /*  gray and check menu-items  */

 if ( env.MICEGroup == MICE2 ) {

    do_1_cmd_save( "*?", MICEBuf, ( MICEBUFSIZE + 1 ) );
    if ( strchr( MICEBuf, EXCL ) != NULL )
       sf_opt( UNAVAILABLE, ON,	MenuItem[SETMENU][0] );

    sf_opt( UNAVAILABLE, ON, MenuItem[EMUMENU][1] );
    sf_opt( UNAVAILABLE, ON, MenuItem[EMUMENU][3] );
    sf_opt( UNAVAILABLE, ON, MenuItem[TRAMENU][1] );
    sf_opt( UNAVAILABLE, ON, MenuItem[TRAMENU][3] );
    sf_opt( UNAVAILABLE, ON, MenuItem[TRAMENU][4] );
    sf_opt( UNAVAILABLE, ON, MenuItem[SPAMENU][1] );
    sf_opt( UNAVAILABLE, ON, MenuItem[SPAMENU][3] );

 } else {

    if ( ( env.Mmodel == 31 ) || ( env.Mmodel == 36 ) ) { /* MICE-III Z80 */

       sf_opt( UNAVAILABLE, ON, MenuItem[TRAMENU][2] );
       sf_opt( UNAVAILABLE, ON, MenuItem[TRAMENU][4] );
       sf_opt( UNAVAILABLE, ON, MenuItem[TRAMENU][9] );
    }

    sf_opt( UNAVAILABLE, ON, MenuItem[TRAMENU][5] );
    sf_opt( UNAVAILABLE, ON, MenuItem[TRAMENU][6] );
 }

 if ( !HaveLAM2 ) {

    sf_opt( UNAVAILABLE, ON, MenuItem[TRAMENU][1] );
    sf_opt( UNAVAILABLE, ON, MenuItem[TRAMENU][3] );
    sf_opt( UNAVAILABLE, ON, MenuItem[SPAMENU][3] );
 }

 /*  display the contents of the REGISTER and CODE viewports initially  */
do_1_cmd_save( "", MICEBuf, ( MICEBUFSIZE + 1 ) );
strcpy(prompt, MICEBuf);

if (!MAXFlag) {
 if ( ! AbortTarget ) {

//    do_1_cmd_save( "", MICEBuf, ( MICEBUFSIZE + 1 ) );
    Len = strlen( MICEBuf );

    if ( ( Len < 4 ) || ( ( Len >= 4 ) &&
			  ( strcmpi( &( MICEBuf[Len-4] ), "RUN>" ) != 0 ) ) ) {

       if ( wn_isup( VP[REGVP].Ptr ) && ( ! ( MaskRedrawFlag & REDRAWREG ) ) )  UpdateREGVP();
       if ( wn_isup( VP[CODVP].Ptr ) && ( ! ( MaskRedrawFlag & REDRAWCOD ) ) )  UpdateCODVP();  else  GetPC(&PC);
       if ( wn_isup( VP[STAVP].Ptr ) && ( ! ( MaskRedrawFlag & REDRAWSTA ) ) )  UpdateSTAVP();
       if ( wn_isup( VP[BREVP].Ptr ) && ( ! ( MaskRedrawFlag & REDRAWBRE ) ) )  UpdateBREVP( 0 );
       if ( wn_isup( VP[TRAVP].Ptr ) && ( ! ( MaskRedrawFlag & REDRAWTRA ) ) )  UpdateTRAVP( 0 );
       if ( wn_isup( VP[DATVP].Ptr ) && ( ! ( MaskRedrawFlag & REDRAWDAT ) ) )  UpdateDATVP();
    }

 } else {

    if ( wn_isup( VP[REGVP].Ptr ) && ( ! ( MaskRedrawFlag & REDRAWREG ) ) )  UpdateREGVP();
    if ( wn_isup( VP[CODVP].Ptr ) && ( ! ( MaskRedrawFlag & REDRAWCOD ) ) )  UpdateCODVP();  else  GetPC(&PC);
    if ( wn_isup( VP[STAVP].Ptr ) && ( ! ( MaskRedrawFlag & REDRAWSTA ) ) )  UpdateSTAVP();
    if ( wn_isup( VP[BREVP].Ptr ) && ( ! ( MaskRedrawFlag & REDRAWBRE ) ) )  UpdateBREVP( 0 );
    if ( wn_isup( VP[TRAVP].Ptr ) && ( ! ( MaskRedrawFlag & REDRAWTRA ) ) )  UpdateTRAVP( 0 );
    if ( wn_isup( VP[DATVP].Ptr ) && ( ! ( MaskRedrawFlag & REDRAWDAT ) ) )  UpdateDATVP();
 }
}

 /*  display the contents of the COMMAND viewport initially : ready for
     accepting the first command					 */

 InitNewCmd();
 d_o_prompt();
// DisplayStr( prompt );

}  /*  of InitVPDisplay()  */
