/*--------------------------------------------------------------------------*/
/*  initold.c								    */
/*--------------------------------------------------------------------------*/

#include  <sys\types.h>
#include  <sys\stat.h>
#include  "system.h"
#include  "usd3.h"
#include  "gblext.h"
#include  "oldext.h"
#include  "usym1.h"
#include  "usym3.h"
#include  "funcext.h"
#ifdef NEC_PC9801 /*NEC_PC9801*/
#include  <memory.h>
#endif /*NEC_PC9801*/

char *baud_pat[] = {
	"19200", "150", "300", "600", "1200", "2400", "4800", "9600", "38400", "57600"
};

/*              "012345678901234567890123456789012345678901234" */
char link_mg1[]="Linking serial port: COM1\n\r";
char link_mg2[]="9600  baud rate, 8 data bit, NONE parity\n\r";
char link_mg4[]="Linking parallel port: 000\n\r";
int  FPORT, MAXFlag;
int  fdRX;
char LOGNAME[81];
int log_fid;
int logFlag;

extern int COMVPMax;
extern int log_count;

InitOldGbls()
{
	strcpy(hand_shak,"HAN     ");
	strcpy(hex,"0123456789ABCDEF");
	strcpy(prompt,">");
	baud = -1;
	RS232 = 0xf3;
	RS232_COM = 0;
	IO_COUNT = 5000;
	P_DATA=0x200;
	P_STATUS=0x201;
	PORT = R_2_386 = 0;
	HAND_SHAKE = 3;
	AbortTarget = TRUE;
	SymLoaded = FAIL;
	CurrModuBeforeLZ = NOT_IN_LOCAL;
	cmd_logged = out_logged = FALSE;
	sym_flag = echo_flag = 1;
	rear_his = front_his = his_count = 0;
	curr_his = -1;
	log_cmd_file[0] = '\0';
	log_out_file[0] = '\0';
}

/* return value:
	1-OK 
	OK (0) or ESC
*/
InitPort()
{
	int PortStatus=OK;
	char c, buf[100];

	strcpy(buf,"( ");
	if(PORT) {
		strcat(buf,link_mg4);
	} else {
		strcat(buf,link_mg1);
		buf[strlen(buf)-2] = ',';
		buf[strlen(buf)-1] = SP;
		strcat(buf,link_mg2);
	}
	strcpy(buf+strlen(buf)-2," )");
	v_stpl( 7,CENTER_TEXT,buf,VPLink );
	v_stpl( 8,CENTER_TEXT,"( You may press M<CR> to link MICE. )",VPLink );

	if(!PORT) {
/*		strncpy(b1,&(link_mg1[21]),4);
		strncpy(b2,link_mg2,5);
		b3[0] = link_mg2[17];
		strncpy(b4,&(link_mg2[29]),4);
		b1[4] = b2[5] = b3[1] = b4[4] = '\0';
		if(!stricmp(b4,"EVEN")) b5 = EVENPARITY;
		else if(!stricmp(b4,"ODD ")) b5 = ODDPARITY;
		else b5 = NOPARITY;
*/
                if ( init_vct() == FALSE ) return( 1-OK );
                init_rs232();
                if ( baud == 0 )  c192();
		else  if ( baud == 8 )  c384();
		else  if ( baud == 9 )  c576();

	}
/*	if(PortStatus == OK && (c=chk_kb()) && c==ESC) return(ESC);
	else  */  return(PortStatus);
}

init_vct()
{
 return( buffer_init() );
}

ReadUSD3INS()
{
	FILE *fp;
	int pat_len, i;
	char c, buf[81], *ptr, *ptr1, buf2[80], Option;
	unsigned long aa, bb;
	if((fp=fopen("USD3.INS","r")) != NULL) {
		while(fgets(buf,80,fp) != NULL) {
			ptr = buf - 1;
			do {
				c = *++ptr;
				*ptr = USDtoupper(c);
			} while(c && c!=CR && c!=LF) ;
			*ptr = '\0';
			ptr = buf;
			while (*ptr == ' ') ptr++;
			Option = *ptr;
			while((c= *++ptr) != ':' && c) ;
			if(c != ':') continue;
			if(Option=='S' && PORT!=1) {
				do {
					while(!isalnum(c=*++ptr) &&c) ;
					if(isalpha(c)) {
						if(!(strncmp(ptr,"COM",3))) {
							ptr+=3;
							link_mg1[24]=*ptr;
							if(*ptr == '2') {
								RS232_COM = 1;
								RBR -= 0x100;
								THR -= 0x100;
								IER -= 0x100;
								IIR -= 0x100;
								LCR -= 0x100;
								MCR -= 0x100;
								LSR -= 0x100;
								MSR -= 0x100;
								IRQ = 0xfff7;
								IRQCMPL = 8;
								VEC_NO = 11;
							}
						} else if(c=='E'||c=='O'||c=='N') {
/* clear bit4,3 */					RS232 &= 0xe7;
							if(c != 'N') RS232|=((c=='E')<<4|8);
							if (c == 'N') strncpy(&link_mg2[29],"NONE",4);
							else if (c=='O') strncpy(&link_mg2[29],"ODD ",4);
							else strncpy(&link_mg2[29],"EVEN",4);
						}
					} else if(isdigit(c)) {
						if(c == '7' || c == '8') {
							RS232 &= 0xfe;
							RS232 |= (c == '8');
							link_mg2[17]=c;
						} else {
							pat_len = decide_baud(ptr);
							ptr += (pat_len-1);
						}
					}
				} while(c=*ptr) ;
			} else if(Option == 'P') {
				sscanf(ptr+1,"%x",&P_DATA);
				P_STATUS = P_DATA + 1;
				PORT = 1;
				link_mg2[0] = '\0';
				sprintf(&link_mg4[23],"%3x\n\r",P_DATA);
				strcpy(link_mg1,link_mg4);
			} else if(Option == 'F') {
				sscanf(ptr+1,"%s", buf2);
				fdRX = UsdOpenFile((LPSTR)buf2, OF_READ);
				FPORT = 1;
			} else if(Option == 'O') {
					sscanf(ptr+1,"%s",LOGNAME);
					log_fid=creat(LOGNAME, S_IWRITE);
					if (log_fid != -1) {
						logFlag=1;
						log_count=0;
					}
			} else if(Option == 'M') {
				sscanf(ptr+1,"%x", &i);
				MAXFlag = i;
			} else if(Option == 'H') {
				while(!isalnum(*ptr)) ++ptr;
				sscanf(ptr,"%x",&HAND_SHAKE);
				strcat(&(hand_shak[4]),ptr);
			} else if(Option == 'R') {
				sscanf(ptr+1,"%s",buf2);
				if (buf2[0] == 'Y') AbortTarget=0;
				else AbortTarget = 1;
			} else if(Option == 'V') {
				sscanf(ptr+1,"%s",buf2);
				if(buf2[0] == 'N') VNFlag = 1;
				else {
                      ptr++;
                      if(!index(ptr,':')) {      ////by chris ,for bug 5031,July 25,1995.
						sscanf(ptr,"%lx",&env.VectAdr);
					} else {
						sscanf(ptr,"%x:%lx",&aa,&bb);
						env.VectAdr = (aa << 16) | (bb & 0xffff);
					}
					VNFlag = 2;
				}
			} else if (Option == 'I') {

				auto_flag=1;

				strcpy( KbdBuf, "INC " );
				ptr1 = &KbdBuf[4];

				while(!isalnum(c=*++ptr) &&c) ;
				if ( c )
				   do {
					c=*ptr++;
					*ptr1++=c;
				   } while (c);
				*ptr1 = '\0';

				strcat( KbdBuf, "\r" );
				KbdBufIdx = 0; 
				KbdBufLastIdx = strlen( KbdBuf ); 
			}
		}
		fclose(fp);
	}
}

/****************************************************************************/
/*  call INT 14h to initialize RS-232					    */
/****************************************************************************/

init_rs232()
{
 union REGS  inregs, outregs;

/* CORE 90.08.14 Modify RS232C Setting (Same As SPEED Command) */
#ifdef NEC_PC9801 /*NEC_PC9801*/
    struct SREGS segregs ;
    unsigned int flags = 0 ;
    
    flags  = (((RS232 & 0x00e0)>> 5)+1)<<8 ; /* CORE 90.08.14 Set Baud Rate */
    flags |= ( (RS232 & 0x0003)<< 2)       ; /* CORE 90.08.14 Set Data Leng */
    flags |= ( (RS232 & 0x0018)<< 1)       ; /* CORE 90.08.14 Set Party Chk */
    flags |= 0x0040;                         /* CORE 90.08.14 Set Stop = 1  */
    segread (&segregs) ;                     /*              & X-Cntl = OFF */
    inregs.h.ah = 0 ;
    movedata(segregs.ds,(int)&flags,0x0060,0x0068,2);
    segregs.ds = 0x0060 ;
    int86x(0x19,&inregs,&outregs,&segregs);
#else /*NEC_PC9801*/
//    inregs.x.ax = RS232 & 0xff;
//    inregs.x.dx = RS232_COM;
//    int86( 0x14, &inregs, &outregs );

/* 
	Initialize COM port baud rate and parity settings
																		*/
if ( RS232_COM == 0 )
	_com1init(RS232);
else
	_com2init(RS232);

#endif /*NEC_PC9801*/

}  /*  of init_rs232()  */

decide_baud(ptr)
char *ptr;
{
	int i,j;
	int pat_len;
	char *p;
	for(i=0 ; i<10 ; i++) {
		pat_len = strlen(baud_pat[i]);
		if(!strnicmp(baud_pat[i],ptr,pat_len)) {
			baud = i;
			for(j=0;j < pat_len;j++) link_mg2[j]=*ptr++;
			if (pat_len == 3) link_mg2[3]=' ';
			RS232 &= 0x1f;
			RS232 |= (baud<<5);
			return(pat_len);
		}
	}
	p = index(ptr,',');
	if(!p) pat_len = strlen(ptr);
	else pat_len = p - ptr;
	return(pat_len);
}

WriteINSFile()
{
}

/****************************************************************************/
/*									    */
/****************************************************************************/

LinkMICE()
{
 char  c, buf[100];
 int   i = 1, j = ( MICEBUFSIZE / 2 ), k;
 int   ChangeBaud = 0, OldRS232;


 upTX_DATA( CR );
 csr_mvwn( 9, 0, VPLink );

 MICEBuf[j] = '\0';

 if ( ( !PORT ) && ( ( baud == 8 ) || ( baud == 9 ) ) ) {

    TimeDelayinSec( 0.5 );

    if ( ( k = upRX_DATA() ) >= 0 ) {

       c = k;
       goto success;

//    } else {
//
//       OldRS232 = RS232;
//       ChangeBaud = 1;
//       rstint();
//       RS232 &= 0x1f;
//       RS232 |= (7<<5);
//       init_rs232();
//       init_vct();
//      RS232 = OldRS232;
    }
 }

 while ( ( c = receive() ) != '>' ) {

success:

   if ( ( c ) && ( ( c >= SP ) && ( c < DEL ) ) ) {
      buf[i++] = c;
      if ( j < MICEBUFSIZE )  MICEBuf[ j++ ] = c;
   }

   if ( ( c == CR ) || ( c == LF ) ) {
      
      buf[0] = '\n';
      buf[i] = '\0';
      disableRS232();
      v_st( buf, VPLink );
      enableRS232();

      if ( j < MICEBUFSIZE )  MICEBuf[ j++ ] = c;

      while ( ( ( c =receive() ) == CR ) || ( c == LF ) )
	if ( j < MICEBUFSIZE )  MICEBuf[ j++ ] = c;

      i = 1;

      if ( c == '>' ) {

	 MICEBuf[j] = '\0';
	 break;

      } else  if ( ( c ) && ( ( c >= SP ) && ( c < DEL ) ) ) {
  
		 buf[i++] = c;
		 if ( j < MICEBUFSIZE )  MICEBuf[ j++ ] = c;
	      }
   }
 }

 receive();

 if ( ChangeBaud == 1 ) {

//    if ( baud == 8 )  SEND_str_no_CR("BAUDRATE384");
//    else if ( baud == 9 )  SEND_str_no_CR("BAUDRATE576");

    send( CR );
    while ( receive() != CR );
    
    rstint();
    init_rs232();
    if ( baud == 8 )  c384();
    else if ( baud == 9 )  c576();
    init_vct();

    send( CR );
    while ( receive() != HAND_SHAKE );
    FlushComm();
 }

 if ( strstr( KbdBuf, "INC" ) == NULL ) {

    KbdBuf[ KbdBufIdx = 0 ] = '\0';
    KbdBufLastIdx = -1;
 }

 return( OK );

}  /*  of LinkMICE()  */

/* return value:
	1-OK 
	OK (0) or ESC
*/

/*************************************
LinkMICE()
{
	int r=OK, rr=11, ddd, dd;
	char buf[100], *bufmax, *ptr, c;
	int cc;

        bufmax = &(buf[99]);

	if ( !PORT ) {
	   sscanf(link_mg2,"%d %s",&dd,buf);
	   ddd = max(5,min((32767 / dd), 50));
	   if(!PORT) FlushComm();
        }  else ddd = 5;

	if(upTX_DATA(CR) && LinkDelay(ddd) && (cc=LinkRx()) >= -1 ) {
		if(cc >= 0) {
			send(CR);
			send(CR);
			send(CR);
			send(CR);
			send(ESC);

			ptr = buf;

			while ((cc=LinkReceive()) != '>') {

			      if (cc == -1) return(ESC);

			      if ( ( cc!=LF ) && ( cc!=CR ) ) {
			         if ( (cc>=SP) && (ptr!=bufmax) ) *ptr++ = cc;
			      } else {
				*ptr = '\0';
				if(ptr != buf) {
	                                v_stpl( rr++,0,buf,VPLink );
					ptr = buf;
				}
			      }
			}

			if(LinkReceive() == -1) return(ESC);
			LinkDelay(ddd);
			while((cc=LinkRx()) >= -1) {
				if(cc >= 0) {
					while((cc=LinkReceive()) != '>') {
						if(cc == -1) return(ESC);
					}
					if(LinkReceive() == -1) return(ESC);
				} else if(cc == -1) return(ESC);
				LinkDelay(ddd);
			}
		} else return(ESC);
	} else {
		upTX_DATA('M');
		LinkDelay(1);
		upTX_DATA(CR);
		LinkDelay(ddd);
	       do {
		if((c=LinkRx()) >= 0) {
			r=OK;
			if(c >= SP) {
				buf[0] = c;
				ptr = buf + 1;
			} else ptr = buf;
			do {
				while((c=LinkReceive()) != '>' && c!=LF && c!=CR && c!=-1) {
			                if ( (c>=SP) && (ptr!=bufmax) ) *ptr++ = c;
				}
				if(c == -1) return(ESC);
				*ptr = '\0';
				if(ptr != buf) {
	                                v_stpl( rr++,0,buf,VPLink );
					ptr = buf;
				}
			} while(c != '>');
			if (LinkReceive() == -1)  return(ESC); else  break;
		} else if(c == -1) r = ESC; else r = 1 - OK;
	       } while ( r == ( 1 - OK ) );
	}

	return(r);
}
*************************************/

LinkDelay(n)
int n;
{  int i;
	while(n--)
          for ( i=1; i<=10000; i++ );
	return(TRUE);
}

LinkTx(c)
char c;
{
		if((c=upTX_DATA()) >= 0) return(1);
	return(-1);
}

/* ret >= 0:   data from MICE */
/* ret = -1:   user press ESC to terminate */
/* ret = -2:   receive fail */
LinkRx()
{
	char c;

	if (c = chk_kb()) {
           if ( c==ESC )  return(-1);
	   else	 upTX_DATA(USDtoupper(c));
        }
	if( ( c=upRX_DATA() ) >= 0 ) { printf("%c..%d..",c,c); return(c); }
	else return(-2);
}

/* ret >= 0:   data from MICE */
/* ret = -1:   user press ESC to terminate */
LinkReceive()
{
	int c;
	while(1) {
		if((c=LinkRx()) >= -1) return(c);
	}
}

FlushComm()
{
 int i;

// if (!FPORT) for ( i=1; i<=512; i++ )  rx_data();
}
