;  /*-----------------------------------------------------------------------*/
;  /*  io.asm								    */
;  /*-----------------------------------------------------------------------*/


.MODEL	   LARGE, C
.286

;  /* CORE 90.08.09 Add CORE_NEC Definition To Pre-Processer */
CORE_NEC  equ   0

;  /*-----------------------------------------------------------------------*/
;  /*  data segment							    */
;  /*-----------------------------------------------------------------------*/

DGROUP     GROUP    _DATA, c_common

_DATA      SEGMENT  WORD PUBLIC 'DATA'

	   EXTRN    PORT:word, RS232_COM:word
	   EXTRN    THR:word, RBR:word, IER:word, IIR:word
	   EXTRN    LCR:word, MCR:word, LSR:word, MSR:word
	   EXTRN    IRQ:word, IRQCMPL:word
	   EXTRN    VEC_NO:word
; /* CORE 90.08.09 Add PORTC EXTRN Define */
if	CORE_NEC
	   EXTRN    PORTC:word
endif	; /* CORE_NEC */

_DATA      ENDS

c_common   SEGMENT  WORD PUBLIC 'BSS'

	   COMM     NEAR sflag:word, NEAR ctrls:word, NEAR rxptr:word
	   COMM     NEAR rxcnt:word, NEAR bfptr:word
	   COMM     NEAR intvc1:word, NEAR intvc2:word
	   COMM     NEAR buffer:word, NEAR sym_tab:word, NEAR tr_buf_recs:word
	   COMM     NEAR cnt_flag:word, NEAR spa_flag:word, NEAR ext_ptr:word
	   COMM     NEAR tunit:word, NEAR lsa_ptr:word
	   COMM     NEAR full:word, NEAR oddev:word, NEAR fr_cnt:word
	   COMM     NEAR time_it:word
	   COMM     NEAR bt_cmd:word
	   COMM     NEAR ext_buf:word, NEAR data_bt:word
	   COMM     NEAR etr:word, NEAR ext:word
	   COMM     NEAR etr_tot:word, NEAR ext_tot:word

c_common   ENDS

;  /*-----------------------------------------------------------------------*/
;  /*  code segment							    */
;  /*-----------------------------------------------------------------------*/

           PUBLIC   c192, c384, c576, disableRS232, enableRS232
           PUBLIC   _IoErr

IO_SEG     SEGMENT  WORD PUBLIC 'CODE'

           ASSUME   cs:IO_SEG, ds:DGROUP

;  /*************************************************************************/
;  /*
;  /*************************************************************************/

_IoErr PROC FAR
	mov al,3h	;return code=Fail system call in progress
	iret
_IoErr ENDP

disableRS232	PROC	FAR

LOCAL
;           cmp  PORT,0          ;use serial port to link MICE?
;           jne  no_disable
;           push dx
;           mov  dx,3fch         ;com1
;           cmp  RS232_COM,1
;           jnz  disable
;           mov  dx,2fch         ;com2
;disable:   mov  al,08h
;           out  dx,al
;           pop  dx
;no_disable:
           ret

disableRS232	ENDP

;  /*************************************************************************/
;  /*
;  /*************************************************************************/

enableRS232	PROC	FAR

LOCAL
;           cmp  PORT,0          ;use serial port to link MICE?
;           jne  no_enable
;           push dx
;           mov  dx,3fdh         ;com1
;           cmp  RS232_COM,1
;           jnz  enable
;           mov  dx,2fdh         ;com2
;enable:    in   al,dx
;           mov  al,0bh
;           dec  dx
;           out  dx,al
;           pop  dx
;no_enable:
           ret

enableRS232	ENDP

;  /*************************************************************************/
;  /*  set RS-232 baud rate to be 19200					    */
;  /*************************************************************************/

c192       PROC     FAR

LOCAL

;/* CORE 90.08.08 Delete c192 Function (NEC Can't Support) */
if	CORE_NEC
else	; /* CORE_NEC */

DLAB	   EQU	    80H			;Bit set for baud rate access
B19200	   EQU	    6			;Clock divider for 19.2k baud

	   push	    ds
	   push	    es
	   push	    di
	   push	    si
	   MOV	    DX,LCR		;READ BAUD REGISTER
	   IN	    AL,DX
	   PUSH	    AX			;Save value
	   OR	    AL,DLAB		;Set the DLAB bit
	   MOV	    DX,LCR
	   OUT	    DX,AL
	   MOV	    AL,B19200		;Set 19200 baud rate
	   MOV	    DX,RBR
	   OUT	    DX,AL
	   XOR	    AL,AL		;Init next register

	   mov	    bx,RBR
	   inc	    bx
	   mov	    dx,bx

	   OUT	    DX,AL
	   POP	    AX
	   MOV	    DX,LCR		;Restore baud register
	   OUT	    DX,AL
	   pop	    si
	   pop	    di
	   pop	    es
	   pop	    ds

endif	; /* CORE_NEC */

           ret

c192       ENDP

;  /*************************************************************************/
;  /*  set RS-232 baud rate to be 38400					    */
;  /*************************************************************************/

c384       PROC     FAR

LOCAL

;/* CORE 90.08.08 Delete c384 Function (NEC Can't Support) */
if	CORE_NEC
else	; /* CORE_NEC */

DLAB	   EQU	    80H			;Bit set for baud rate access
B38400	   EQU	    3			;Clock divider for 38.4k baud

	   push	    ds
	   push	    es
	   push	    di
	   push	    si
	   MOV	    DX,LCR		;READ BAUD REGISTER
	   IN	    AL,DX
	   PUSH	    AX			;Save value
	   OR	    AL,DLAB		;Set the DLAB bit
	   MOV	    DX,LCR
	   OUT	    DX,AL
	   MOV	    AL,B38400		;Set 38400 baud rate
	   MOV	    DX,RBR
	   OUT	    DX,AL
	   XOR	    AL,AL		;Init next register

	   mov	    bx,RBR
	   inc	    bx
	   mov	    dx,bx

	   OUT	    DX,AL
	   POP	    AX
	   MOV	    DX,LCR		;Restore baud register
	   OUT	    DX,AL
	   pop	    si
	   pop	    di
	   pop	    es
	   pop	    ds

endif	; /* CORE_NEC */

           ret

c384       ENDP

;  /*************************************************************************/
;  /*  set RS-232 baud rate to be 57600					    */
;  /*************************************************************************/

c576       PROC     FAR

LOCAL

;/* CORE 90.08.08 Delete c576 Function (NEC Can't Support) */
if	CORE_NEC
else	; /* CORE_NEC */

DLAB	   EQU	    80H			;Bit set for baud rate access
B57600	   EQU	    2			;Clock divider for 38.4k baud

	   push	    ds
	   push	    es
	   push	    di
	   push	    si
	   MOV	    DX,LCR		;READ BAUD REGISTER
	   IN	    AL,DX
	   PUSH	    AX			;Save value
	   OR	    AL,DLAB		;Set the DLAB bit
	   MOV	    DX,LCR
	   OUT	    DX,AL
	   MOV	    AL,B57600		;Set 57600 baud rate
	   MOV	    DX,RBR
	   OUT	    DX,AL
	   XOR	    AL,AL		;Init next register

	   mov	    bx,RBR
	   inc	    bx
	   mov	    dx,bx

	   OUT	    DX,AL
	   POP	    AX
	   MOV	    DX,LCR		;Restore baud register
	   OUT	    DX,AL
	   pop	    si
	   pop	    di
	   pop	    es
	   pop	    ds

endif	; /* CORE_NEC */

           ret

c576       ENDP

;  /*************************************************************************/
;  /*									    */
;  /*************************************************************************/

send_char  PROC     FAR

LOCAL

	   push	    ax
bflop1:
	   mov	    dx,MSR		;check modem status register
	   in	    al,dx
if	CORE_NEC
	   and      al,84h		;wait for DSR
	   cmp      al,84h
	   jnz	    bflop1
else	; /* CORE_NEC */
	   and	    al,20h		;wait for DSR
	   jz	    bflop1
	   mov	    dx,LSR
bflop:
	   in	    al,dx
	   and	    al,20h		;wait for transmit empty
	   jz	    bflop
endif	; /* CORE_NEC */
	   pop	    ax
	   mov	    dx,THR		;send the character
	   out	    dx,al

	   ret

send_char  ENDP

;  /*************************************************************************/
;  /*  send a character to RS-232					    */
;  /*************************************************************************/

tx_data    PROC     FAR

LOCAL

	   cli
	   cmp	    rxcnt,0		;receive buffer empty?
	   jnz	    tx_begin
	   sti
	   cmp	    sflag,1		;ctrl-s already send?
	   jnz	    tx_begin
	   mov	    sflag,0		;reset sflag
	   mov	    al,011h		;send out XON
	   call	    send_char
	   jmp	    next_time
tx_begin:
	   mov	    ax,6[bp]
	   push	    ax
	   sti
wf_mice_rdy:
	   cmp	    ctrls,0
	   jnz	    wf_mice_rdy
	   mov	    dx,MSR		;check modem status register
	   in	    al,dx
if	CORE_NEC
	   and      al,84h		;wait for DSR
	   cmp      al,84h
	   jnz	    end_tx2
else	; /* CORE_NEC */
	   and	    al,20h		;wait for DSR
	   jz	    end_tx2
	   mov	    dx,LSR
	   in	    al,dx
	   and	    al,20h		;transmitter holding register empty?
	   jz	    end_tx2
endif	; /* CORE_NEC */
	   mov	    dx,THR		;send the data
	   pop	    ax
	   out	    dx,al
	   mov	    ah,0
	   jmp	    end_tx3
end_tx2:
	   pop	    ax
next_time:
	   mov	    ah,80h
end_tx3:

           ret

tx_data    ENDP

IO_SEG     ENDS

           END
