
/*--------------------------------------------------------------------------*/
/*  menu2.c  								    */
/*--------------------------------------------------------------------------*/
// This file includes the routines for processing the TRACE
// pulldown menus.

#include  "system.h"
#include  "menu.h"
#include  "usd3.h"
#include  "gblext.h"
#include  "oldext.h"
#include  "usym1.h"
#include  "usym3.h"
#include  "dialog.h"
#include  "dlgext.h"
#include  "funcdecl.h"
#include  "funcext.h"

/* USD-III V2.0x */
#define PULLDOWN	1
#define DIALOG		2
extern int pulldown_or_dialog;
/* USD-III V2.0x */

extern FUNCLIS usd3dlg[];  
extern char FormMsg[]       ; 
extern char FormMsgFld[]    ; 
extern char TFormMsg[]      ; 
extern char TFormMsgFld[]   ; 
extern char BoolFldMsg[]    ; 
extern char BoolFldMsgFld[] ;
extern int retcode;

MFILEPTR tmpMFile;
char *SepLineFromLongString();
int StripBlanks();
char qualifystatus[] = "SP SR SW UP UR UW AK AW";

struct blkrange {
	UCHAR op;
	UCHAR start[14];
	UCHAR end[14];
};

struct bobo {             // form : bo 
	UCHAR gblop[8];		    
	UCHAR f0;         // SP, I	
	UCHAR f1;         // SD, O	
	UCHAR f2;         // UP, S	
	UCHAR f3;         // UD, R	
	UCHAR f4;         //   , W   
	struct blkrange br[16];	    
};				    
				    
struct trilevel {		    
	UCHAR op[10];		    
	UCHAR logic[221];	    
	UCHAR trace;		    
	UCHAR timer;		    
};
				    
struct ts1ts1 {         // form : ts
	struct trilevel tl[8];	    
	UCHAR trigger;		    
	UCHAR gtrace;		    
	UCHAR gtimer;		    
	UCHAR triggerseq[221];	    
	UCHAR runends;		    
	UCHAR delay[9];
	UCHAR count[5];
};
static struct ts1ts1 oldts;

/****************************************************************************/
/*  TRACE menu S/W Breakpoint menu-item					    */
/****************************************************************************/

MN_T_SW( TraMenuCopy )
MFORMPTR  TraMenuCopy;
{
	TSW *datap;
	char tbuf[100], buf[30];
	UCHAR adr1[6];
	int i,j,k;
	DFIELDPTR fldptr;
	WINDOWPTR msgwnp;

	VV_ERR = 0;
	datap = &tsw;
	i = -1;
	while (SwBreak[++i].exists) ;
    	if( i > 0) {
		tmpMFile = mf_def(i+3,41);
		if (tmpMFile == NULLP) {
			ErrorProc();
			return(EXITMENU);
		}
	}
	
	DlgFmPtr = dl_fmget("TSw",datap,NULLP,tmpMFile,VVDLibp);
 	if (DlgFmPtr == NULLP) {
		ErrorProc();
		mf_free(tmpMFile);
		return(EXITMENU);
	}
	ShowShadow(DlgFmPtr->wnp);
	fldptr = (DFIELDPTR) i_namptr("action",DlgFmPtr);
	sf_msg(BoolFldMsgFld,fldptr);
    	
	if( i > 0) {
		mf_rowins("*SWBpaddr",APPEND_ROW,tmpMFile);
		i = -1;
		while (SwBreak[++i].exists)  {
			sprintf(tbuf,"%3d. ",i+1);
			if (SwBreak[i].sym[0]) strcat(tbuf,SwBreak[i].sym);
			else {
				for (j=env.Maddrunit-1,k=0; j>=0; j--,k+=8)
					adr1[j]=(SwBreak[i].address >> k) & 0xff;
				adr_ascii(adr1,env.Maddrunit,buf);
				strcat(tbuf,buf);
			}
			mf_rowins(tbuf,APPEND_ROW,tmpMFile);
		}
		fldptr = (DFIELDPTR) i_namptr("bpaddr",DlgFmPtr);
		sf_clist("*SWBpaddr",CLWRAP|CLAUTOMOVE,tmpMFile,fldptr);
		scl_attinact(LFLDACTOFF,fldptr->clistp);
		scl_attact(LFLDACTON,fldptr->clistp);
		sw_bdratt(LFLDACTOFF,fldptr->clistp->wnp);
		scl_help("*BpAddr",fldptr->clistp);
		if (i > 11) sw_sb(AUTOUPD,VSBAR,fldptr->clistp->wnp);
	}

	msgwnp = wn_def(vs_rowq()-1,0,1,vs_colq(),LMESSAGE,BDR_NULLP);
	wn_up(msgwnp);
	v_st(TFormMsg,msgwnp);
	pulldown_or_dialog = DIALOG;
	retcode = fm_proc(0,DlgFmPtr);
	pulldown_or_dialog = PULLDOWN;
	wn_dn(msgwnp);
	wn_free(msgwnp);
	fm_free(DlgFmPtr);
	if (i > 0)  mf_free(tmpMFile);

	if (retcode == AC_EXIT)  {
		ExecDlgFlag = 1;
		if (datap->action == FALSE) {
			strcat(DlgBuf,"BRE ");
			strcat(DlgBuf,datap->bpaddr);
			strcat(DlgBuf,"\r");
		} else {
			sscanf(datap->bpaddr,"%d %*s",&i);
			for (j=env.Maddrunit-1,k=0; j>=0; j--,k+=8)
				adr1[j]=(SwBreak[i-1].address >> k) & 0xff;
			adr_ascii(adr1,env.Maddrunit,buf);
			i = CheckIsBKPT(buf);
			if (i >= 0) {
				strcat(DlgBuf,"CLE ");
				itoa(i+1,tbuf,10);
				strcat(DlgBuf,tbuf);
				strcat(DlgBuf,"\r");
			}
		}
	}
			
	if (retcode == AC_EXIT) return( EXITMENU );
	else if (retcode == AC_QUIT) return(SAMELEVEL);

}  /*  of MN_T_SW()  */

/****************************************************************************/
/*  TRACE menu Break On Read menu-item						    */
/****************************************************************************/

MN_T_BREAK( TraMenuCopy )
MFORMPTR  TraMenuCopy;
{
	struct bobo  *bop,ov;
	TBREAK *datap;
	WINDOWPTR msgwnp;
	DFIELDPTR fldptr;
	int i, j;
	char *ptr1,*ptr2,*ptr3;
	int mtflag;

	VV_ERR = 0;
	datap = &tbreak;
	bop = (struct bobo *) &tbreak;
	if (env.Mmodel  == 39) DlgFmPtr = dl_fmget("TBreakC186",datap,usd3dlg,CListMFilePtr,VVDLibp);
	else                   DlgFmPtr = dl_fmget("TBreak",datap,usd3dlg,CListMFilePtr,VVDLibp);
 	if (DlgFmPtr == NULLP) {
		ErrorProc();
		return(EXITMENU);
	}
	ShowShadow(DlgFmPtr->wnp);
// setting field message
	fldptr = (DFIELDPTR) i_namptr("gblop",DlgFmPtr);
	sf_msg(TFormMsgFld,fldptr);
//	if (env.Mmodel  == 39) j = 6; else j = 5;
	for (i=1; i < 6; i++) {
		fldptr = (DFIELDPTR) i_numptr(i,DlgFmPtr);
		sf_msg(BoolFldMsgFld,fldptr);
	}
	for (i=6; i < DlgFmPtr->itemq-1; i+=3) {
		fldptr = (DFIELDPTR) i_numptr(i,DlgFmPtr);
		sf_msg(BoolFldMsgFld,fldptr);
	}
// getting MICE settings
	do_1_cmd_save("DEBUGON",MICEBuf,(MICEBUFSIZE+1));
	do_1_cmd_save("INI",MICEBuf,(MICEBUFSIZE+1));
	memset(datap,NULL,sizeof(TBREAK));
	datap->f0 = TRUE;
	datap->f1 = TRUE;
	datap->f2 = TRUE;
	datap->f3 = TRUE;
	datap->f4 = TRUE;
	if ((strstr(MICEBuf,"Read-Before-Write") != NULL) &&
	    (strstr(MICEBuf,"disabled") != NULL)) 
		strcpy(datap->gblop,"DISABLE");
	else if (strstr(MICEBuf,"No address range") != NULL)
		strcpy(datap->gblop,"ENABLE");
	else if (strstr(MICEBuf,"The ranges") != NULL) {
		strcpy(datap->gblop,"SET");
		if (env.Mmodel == 39) 
			ptr2 = ptr1 = strstr(MICEBuf,"Bus Status :");
		else    ptr2 = ptr1 = strstr(MICEBuf,"Memory type :");
		ptr1 = SepLineFromLongString(ptr1);
		ptr2 += 13;
		if (env.Mmodel == 39) {
			if (strstr(ptr2,"I") != NULL)  datap->f0 = TRUE;
			else                           datap->f0 = FALSE;
			if (strstr(ptr2,"O") != NULL)  datap->f1 = TRUE;
			else                           datap->f1 = FALSE;
			if (strstr(ptr2,"S") != NULL)  datap->f2 = TRUE;
			else                           datap->f2 = FALSE;
			if (strstr(ptr2,"R") != NULL)  datap->f3 = TRUE;
			else                           datap->f3 = FALSE;
			if (strstr(ptr2,"W") != NULL)  datap->f4 = TRUE;
			else                           datap->f4 = FALSE;
		} else {
			if (strstr(ptr2,"SP") != NULL) datap->f0 = TRUE;
			else                           datap->f0 = FALSE;
			if (strstr(ptr2,"SD") != NULL) datap->f1 = TRUE;
			else                           datap->f1 = FALSE;
			if (strstr(ptr2,"UP") != NULL) datap->f2 = TRUE;
			else                           datap->f2 = FALSE;
			if (strstr(ptr2,"UD") != NULL) datap->f3 = TRUE;
			else                           datap->f3 = FALSE;
		}
		for (i=0; i < 16; i++) {
			ptr2 = ptr1;
			ptr1 = SepLineFromLongString(ptr1);
			if ((*ptr2 == '\0') || (*ptr2 == '>')) break;
			bop->br[i].op = TRUE;
			sscanf(ptr2,"%*s %s %s %*s",bop->br[i].start,bop->br[i].end);
			StripBlanks(bop->br[i].start);
			StripBlanks(bop->br[i].end);
		}
	}
	do_1_cmd_save("DEBUGOFF",MICEBuf,(MICEBUFSIZE+1));
	memcpy(&ov,datap,sizeof(TBREAK));

	msgwnp = wn_def(vs_rowq()-1,0,1,vs_colq(),LMESSAGE,BDR_NULLP);
	wn_up(msgwnp);
	v_st(FormMsg,msgwnp);
	pulldown_or_dialog = DIALOG;
	retcode = fm_proc(0,DlgFmPtr);
	pulldown_or_dialog = PULLDOWN;
	wn_dn(msgwnp);
	wn_free(msgwnp);
	fm_free(DlgFmPtr);

 	if (retcode == AC_EXIT)  {
		ExecDlgFlag = 1;
		StripBlanks(datap->gblop);
		if ((strstr(datap->gblop,"SET") != NULL) &&
		    (strlen(datap->gblop) == 3))  {
			if (strstr(ov.gblop,"DIS") != NULL)
				strcat(DlgBuf,"INI EN\r");
// mtflag  0x01=sp  0x02=sd  0x08=up  0x10=ud               for 68K-series
// mtflag  0x01=I   0x02=O   0x08=S   0x10=R    0x20=W      for 80c186
			mtflag = 0;
			if (datap->f0 != ov.f0) mtflag |= 0x01;
			if (datap->f1 != ov.f1) mtflag |= 0x02;
			if (datap->f2 != ov.f2) mtflag |= 0x08;
			if (datap->f3 != ov.f3) mtflag |= 0x10;
			if (env.Mmodel == 39)
				if (datap->f4 != ov.f4) mtflag |= 0x20;
			if ((env.Mmodel == 39) && (mtflag > 0)) {
				strcat(DlgBuf,"INI");
 				if (datap->f0 == TRUE) strcat(DlgBuf," I");
				if (datap->f1 == TRUE) strcat(DlgBuf," O");
				if (datap->f2 == TRUE) strcat(DlgBuf," S");
				if (datap->f3 == TRUE) strcat(DlgBuf," R");
				if (datap->f4 == TRUE) strcat(DlgBuf," W");
				strcat(DlgBuf,"\r");
			} else if (mtflag > 0) {
				strcat(DlgBuf,"INI");
 				if (datap->f0 == TRUE) strcat(DlgBuf," SP");
				if (datap->f1 == TRUE) strcat(DlgBuf," SD");
				if (datap->f2 == TRUE) strcat(DlgBuf," UP");
				if (datap->f3 == TRUE) strcat(DlgBuf," UD");
				strcat(DlgBuf,"\r");
			}
			for (i=0; i < 16; i++) {
				mtflag = 0;
				StripBlanks(bop->br[i].start);
				StripBlanks(bop->br[i].end);
				if ((strcmp(bop->br[i].start,ov.br[i].start) != 0) ||
				    (strcmp(bop->br[i].end,ov.br[i].end) != 0)) mtflag |= 0x01;
				if (bop->br[i].op != ov.br[i].op) mtflag |= 0x02;
				if (mtflag > 0) {
					strcat(DlgBuf,"INI ");
					strcat(DlgBuf,bop->br[i].start);
					strcat(DlgBuf," ");
					strcat(DlgBuf,bop->br[i].end);
					if (bop->br[i].op == FALSE) strcat(DlgBuf," CL\r");
					else strcat(DlgBuf,"\r");
				}
			}
		} else if (bop->gblop != ov.gblop) {
			strcat(DlgBuf,"INI ");
			strcat(DlgBuf,bop->gblop);
			strcat(DlgBuf,"\r");
		}
	}

	if (retcode == AC_EXIT) return( EXITMENU );
	else if (retcode == AC_QUIT) return(SAMELEVEL);

}  /*  of MN_T_BREAK()  */

TBreakBegForm(dfmptr)
DFORMPTR dfmptr;
{
	int i,curitem=0;
	DFIELDPTR fldptr,pp;

	if (strstr(DlgFmPtr->name,"TBreak") != NULL) {
		fldptr = (DFIELDPTR) i_numptr(curitem,DlgFmPtr);
		fld_get(fldptr->datap,curitem,DlgFmPtr);
		if ((strstr(fldptr->datap,"SET") != NULL) &&
			(strlen(fldptr->datap) == 3) ) {
			for (i=0; i < 5; i++ ) {
				if ((env.Mmodel != 39) && (i == 4)) break;
				pp = (DFIELDPTR) i_numptr(++curitem,DlgFmPtr);
				sf_opt(SKIP,OFF,pp);
			}
		} else {
			for (i=0; i < 5; i++ ) {
				pp = (DFIELDPTR) i_numptr(++curitem,DlgFmPtr);
				if ((env.Mmodel != 39) && (i == 4)) 
					sf_opt(SKIP,OFF,pp);
				else sf_opt(SKIP,ON,pp);
			}
		}
		curitem = 6;
	}  else curitem = 7;
	for (i=0; i < 16; i++,curitem++) {
		fldptr = (DFIELDPTR) i_numptr(curitem,DlgFmPtr);
		fld_get(fldptr->datap,curitem,DlgFmPtr);
		if (*((UCHAR *)(fldptr->datap)) == TRUE) {
			pp = (DFIELDPTR) i_numptr(++curitem,DlgFmPtr);
			sf_opt(SKIP,OFF,pp);
			pp = (DFIELDPTR) i_numptr(++curitem,DlgFmPtr);
			sf_opt(SKIP,OFF,pp);
		} else {
			pp = (DFIELDPTR) i_numptr(++curitem,DlgFmPtr);
			sf_opt(SKIP,ON,pp);
			pp = (DFIELDPTR) i_numptr(++curitem,DlgFmPtr);
			sf_opt(SKIP,ON,pp);
		}
	}
	return(TRUE);
}

BreakOpEnd(dfmptr)
DFORMPTR dfmptr;
{
	DFIELDPTR fldptr,pp;
	int i,curitem=0;

	fldptr  = (DFIELDPTR) curitemp(DlgFmPtr);
	fld_get(fldptr->datap,curitemnum(DlgFmPtr),DlgFmPtr);
	if ((strstr(fldptr->datap,"SET") != NULL) && (strlen(fldptr->datap) == 3)) {
		for (i=0; i < 5; i++ ) {
			if ((env.Mmodel != 39) && (i == 4)) break;
			pp = (DFIELDPTR) i_numptr(++curitem,DlgFmPtr);
			sf_opt(SKIP,OFF,pp);
		}
	} else {
		for (i=0; i < 5; i++ ) {
			pp = (DFIELDPTR) i_numptr(++curitem,DlgFmPtr);
			if ((env.Mmodel != 39) && (i == 4)) 
				sf_opt(SKIP,OFF,pp);
			else sf_opt(SKIP,ON,pp);
		}
	}
	for (i=0,curitem=6; i < 16; i++,curitem++) {
		fldptr = (DFIELDPTR) i_numptr(curitem,DlgFmPtr);
		fld_get(fldptr->datap,curitem,DlgFmPtr);
		if (*((UCHAR *)(fldptr->datap)) == TRUE) {
			pp = (DFIELDPTR) i_numptr(++curitem,DlgFmPtr);
			sf_opt(SKIP,OFF,pp);
			pp = (DFIELDPTR) i_numptr(++curitem,DlgFmPtr);
			sf_opt(SKIP,OFF,pp);
		} else {
			pp = (DFIELDPTR) i_numptr(++curitem,DlgFmPtr);
			sf_opt(SKIP,ON,pp);
			pp = (DFIELDPTR) i_numptr(++curitem,DlgFmPtr);
			sf_opt(SKIP,ON,pp);
		}
	}
	return(TRUE);
}

CCOperationEnd(dummyptr)
DFORMPTR  dummyptr;
{
	DFIELDPTR fldptr;
	DFIELDPTR   memop;
	int curitem;

	curitem = curitemnum(DlgFmPtr);
	fldptr  = (DFIELDPTR) i_numptr(curitem,DlgFmPtr);
	fld_get(fldptr->datap,curitemnum(DlgFmPtr),DlgFmPtr);
	if (*((UCHAR *)(fldptr->datap)) == FALSE) {  // if op fld == clear
		memop =  (DFIELDPTR)i_numptr(curitem+1,DlgFmPtr);
		sf_opt(SKIP, ON, memop);
		memop =  (DFIELDPTR)i_numptr(curitem+2,DlgFmPtr);
		sf_opt(SKIP, ON, memop);
	} else {
		memop =  (DFIELDPTR)i_numptr(curitem+1,DlgFmPtr);
		sf_opt(SKIP, OFF, memop);
		memop =  (DFIELDPTR)i_numptr(curitem+2,DlgFmPtr);
		sf_opt(SKIP, OFF, memop);
	}
	return(TRUE);
}

/****************************************************************************/
/*  TRACE menu Event menu-item						    */
/****************************************************************************/

MN_T_EVENT( TraMenuCopy )
MFORMPTR  TraMenuCopy;
{
	TEVENT *datap;
	WINDOWPTR msgwnp;
	DFIELDPTR fldptr;

	VV_ERR = 0;
	datap = &tevent;
	DlgFmPtr = dl_fmget("TEvent",datap,usd3dlg,NULLP,VVDLibp);
 	if (DlgFmPtr == NULLP) {
		ErrorProc();
		return(EXITMENU);
	}
	ShowShadow(DlgFmPtr->wnp);

	fldptr = (DFIELDPTR) i_namptr("action",DlgFmPtr);
	sf_msg(BoolFldMsgFld,fldptr);

	msgwnp = wn_def(vs_rowq()-1,0,1,vs_colq(),LMESSAGE,BDR_NULLP);
	wn_up(msgwnp);
	v_st(FormMsg,msgwnp);
	pulldown_or_dialog = DIALOG;
	retcode = fm_proc(0,DlgFmPtr);
	pulldown_or_dialog = PULLDOWN;
	wn_dn(msgwnp);
	wn_free(msgwnp);
	fm_free(DlgFmPtr);

 	if (retcode == AC_EXIT)  {
		ExecDlgFlag = 1;
		if (env.MICEGroup == MICE2) strcat(DlgBuf,"H");
		else strcat(DlgBuf,"EV ");
		if (datap->action == FALSE) {
			strcat(DlgBuf,datap->eventno);
			strcat(DlgBuf," ");
			strcat(DlgBuf,datap->eventarg);
			strcat(DlgBuf,"\r");
		} else  {
			if (env.MICEGroup == MICE2) strcat(DlgBuf,"0");
			strcat(DlgBuf,datap->eventno);
			if (env.MICEGroup == MICE2) strcat(DlgBuf,"\r");
			else strcat(DlgBuf," CL\r");
		}
	}
			
	if (retcode == AC_EXIT) return( EXITMENU );
	else if (retcode == AC_QUIT) return(SAMELEVEL);

}  /*  of MN_T_EVENT()  */

TEventGetArg(dfmptr)
DFORMPTR dfmptr;
{
	char *sptr, *ptr, c, tttcmd[10];
	int i;

	memset(tttcmd,NULL,10);
	strcpy(tttcmd,((env.Mmodel >= MICE_3_BOUND) ? "EV" : "H"));
	i = ((env.Mmodel >= MICE_3_BOUND) ? 2 : 1);
	fld_get((PTR)(tevent.eventno),i_namnum("eventno",DlgFmPtr),DlgFmPtr); 
	memcpy(&tttcmd[i],tevent.eventno,1);
	do_1_cmd_save(tttcmd,MICEBuf,(MICEBUFSIZE+1));
	if (strchr(MICEBuf,'!') != NULL) return(TRUE);

	if ((sptr=strstr(MICEBuf,tttcmd)) == NULL) return(TRUE);
	if ((ptr=strchr(sptr,')')) == NULL) 
		if ((ptr=strchr(sptr,'=')) == NULL) return(TRUE);
	ptr += 2;
	sptr = ptr;
	for (;;ptr++)
		if (*ptr == 0x0a) {
			*ptr = '\0';
			break;
		}
	if (strstr(sptr,"clear") != NULL) *sptr = '\0';
	if (*sptr != '\0') strcpy(tevent.eventarg,sptr);
	else tevent.eventarg[0] = '\0';
	i=memo_upd((PTR)(tevent.eventarg),i_namnum("eventarg",DlgFmPtr),DlgFmPtr);
	return(TRUE);

}

/****************************************************************************/
/*  TRACE menu Trigger Level menu-item						    */
/****************************************************************************/

MN_T_TRIGGER( TraMenuCopy )
MFORMPTR  TraMenuCopy;
{
	TTRIGGER *datap;
	struct ts1ts1 *tsp,*ov;
	WINDOWPTR msgwnp;
	DFIELDPTR fldptr;
	char *ptr1,*ptr2,*ptr3,temp[10];
	int i,bbflag;
	char ln[9],tb[10];
	
	VV_ERR = 0;
	datap = &ttrigger;
	tsp = (struct ts1ts1 *)&ttrigger;
	ov  = &oldts;
	DlgFmPtr = dl_fmget("TTrigger",datap,usd3dlg,CListMFilePtr,VVDLibp);
 	if (DlgFmPtr == NULLP) {
		ErrorProc();
		return(EXITMENU);
	}
	ShowShadow(DlgFmPtr->wnp);

// setting field message
	for (i=0; i < 31; i+=4) {
		fldptr = (DFIELDPTR) i_numptr(i,DlgFmPtr);
		sf_msg(TFormMsgFld,fldptr);
		fldptr = (DFIELDPTR) i_numptr(i+1,DlgFmPtr);
		sf_msg(FormMsgFld,fldptr);
	}
	fldptr = (DFIELDPTR) i_namptr("triggerseq",DlgFmPtr);
	sf_msg(FormMsgFld,fldptr);
	fldptr = (DFIELDPTR) i_namptr("delay",DlgFmPtr);
	sf_msg(TFormMsgFld,fldptr);
	fldptr = (DFIELDPTR) i_namptr("count",DlgFmPtr);
	sf_msg(FormMsgFld,fldptr);

// get MICE setting
	do_1_cmd_save("TRI",MICEBuf,(MICEBUFSIZE+1));
	ptr1 = MICEBuf;
	for (ptr1=MICEBuf; *ptr1 != '\0'; ptr1++)
		if ((*ptr1 != 0x0a) && (*ptr1 != 0x0d)) *ptr1 = toupper(*ptr1);
	ptr2 = ptr1 = MICEBuf;
	ptr1 = SepLineFromLongString(ptr1);
	if (strstr(ptr2,"CLEAR") != NULL) {
		datap->trigger = FALSE;
		datap->gtrace = TRUE;
		datap->gtimer = TRUE;
		datap->triggerseq[0] = '\0';
		datap->runends = FALSE;
		strcpy(datap->delay,"COUNT");
		strcpy(datap->count,"0000");
	} else {
		datap->trigger = TRUE;
		if (strstr(ptr2,"RUN") != NULL) {
			datap->runends = TRUE;
			ptr2 += 12;
		} else {
			datap->runends = FALSE;
			ptr2 += 8;
		}
		if ((ptr3=strstr(ptr2,"DELAY")) != NULL) {
			sscanf(ptr3,"%*s %s",datap->count);
			strcpy(datap->delay,"COUNT");
			*(--ptr3) = '\0';
		}
		strcpy(datap->triggerseq,ptr2);
		StripBlanks(datap->triggerseq);
	}
	ptr2 = ptr1;
	ptr1 = SepLineFromLongString(ptr1);
	if ((ptr3=strstr(ptr2,"TRACE")) != NULL)
		sscanf(ptr3+5," %s ",temp);
	if (strstr(temp,"ON") != NULL) datap->gtrace = TRUE;
	else                           datap->gtrace = FALSE;
	if ((ptr3=strstr(ptr2,"TIMER")) != NULL)
		sscanf(ptr3+5," %s %*s %*s",temp);
	if (strstr(temp,"ON") != NULL) datap->gtimer = TRUE;
	else                           datap->gtimer = FALSE;
	for (i=0; i < 8; i++) {
		ptr2 = ptr1;
		ptr1 = SepLineFromLongString(ptr1);
		if (strstr(ptr2,"CLEAR") != NULL) {
			strcpy(tsp->tl[i].op,"CLEAR");
			tsp->tl[i].timer = TRUE;
			tsp->tl[i].trace = TRUE;
			tsp->tl[i].logic[0] = '\0';
		} else {
			ptr3 = strstr(ptr2,"TIMER");
			if (strstr(ptr3,"ON") != NULL) tsp->tl[i].timer = TRUE;
			else tsp->tl[i].timer = FALSE;
			*ptr3 = '\0';
			ptr3 = strstr(ptr2,"TRACE");
			if (strstr(ptr3,"ON") != NULL) tsp->tl[i].trace = TRUE;
			else tsp->tl[i].trace = FALSE;
			*ptr3 = '\0';
			ptr2 +=10;
			strcpy(tsp->tl[i].logic,ptr2);
			StripBlanks(tsp->tl[i].logic);
			strcpy(tsp->tl[i].op,"SET");
		}
	}
	memcpy((void *)&oldts,(void *)&ttrigger,sizeof(struct ts1ts1));

	msgwnp = wn_def(vs_rowq()-1,0,1,vs_colq(),LMESSAGE,BDR_NULLP);
	wn_up(msgwnp);
	v_st(BoolFldMsg,msgwnp);
	pulldown_or_dialog = DIALOG;
	retcode = fm_proc(0,DlgFmPtr);
	pulldown_or_dialog = PULLDOWN;
	wn_dn(msgwnp);
	wn_free(msgwnp);
	fm_free(DlgFmPtr);

 	if (retcode == AC_EXIT)  {
		ExecDlgFlag = 1;
		for (i=0,bbflag=0; i < 8; i++)  
			if (strstr(tsp->tl[i].op,"CLEAR ALL") != NULL) bbflag++;
		if (bbflag > 0) strcat(DlgBuf,"T L CL\r");
		else {
// 		bbflag= 0x01 : timer : count
// 		bbflag= 0x02 : trace : delay
// 		bbflag= 0x08 : logic : runends	      
// 		bbflag= 0x10 : op    : triggerseq
			strcpy(ln,"ABCDEFGH");		
			strcpy(tb,"T L # ");
			for (i=0; i < 8; i++) {
				tb[4] = ln[i];   bbflag = 0;
				if (strstr(tsp->tl[i].op,"SET") != NULL) {
					if (tsp->tl[i].trace != ov->tl[i].trace)
						bbflag |= 0x02;
					if (tsp->tl[i].timer != ov->tl[i].timer)
						bbflag |= 0x01;
					StripBlanks(tsp->tl[i].logic);
					if (strcmp(tsp->tl[i].logic,ov->tl[i].logic) != 0)
						bbflag |= 0x08;
					if (bbflag != 0) {
						strcat(DlgBuf,tb);
						strcat(DlgBuf,tsp->tl[i].logic);
						if ((bbflag & 0x02) == 0x02)  {
							if (tsp->tl[i].trace == TRUE)
								strcat(DlgBuf," T ON");
							else    strcat(DlgBuf," T OF");
						}
						if ((bbflag & 0x01) == 0x01) {
							if (tsp->tl[i].timer == TRUE)
								strcat(DlgBuf," TI ON");
							else    strcat(DlgBuf," TI OF");
						}
						strcat(DlgBuf,"\r");
					}
				} else if ((strstr(tsp->tl[i].op,"CLEAR") != NULL) &&
					   (strcmp(tsp->tl[i].op,ov->tl[i].op) != 0)) {
						strcat(DlgBuf,tb);
						strcat(DlgBuf," CL\r");
				}
			}
		}
		if (datap->trigger == TRUE) {
			bbflag = 0;
			if (datap->gtrace != ov->gtrace) bbflag |= 0x01;
			if (datap->gtimer != ov->gtimer) bbflag |= 0x02;
			if (bbflag > 0) {
				strcat(DlgBuf,"T ");
				if ((bbflag & 0x01) == 0x01) {
					if (datap->gtrace == TRUE) strcat(DlgBuf,"T ON");
					else strcat(DlgBuf,"T OF");
				}
				if ((bbflag & 0x02) == 0x02) {
					if (datap->gtimer == TRUE) strcat(DlgBuf," TI ON");
					else strcat(DlgBuf," TI OF");
				}
				strcat(DlgBuf,"\r");
			}
			bbflag = 0;
			if (strcmp(datap->count,ov->count) != 0) bbflag |= 0x01;
			if (strcmp(datap->delay,ov->delay) != 0) bbflag |= 0x02;
			if (datap->runends != ov->runends) bbflag |= 0x08;
			StripBlanks(datap->triggerseq);
			if (strcmp(datap->triggerseq,ov->triggerseq) != 0)
				bbflag |= 0x10;
			if (bbflag > 0) {
				if (datap->runends == TRUE) strcat(DlgBuf,"T RU ");
				else strcat(DlgBuf,"T ");
				strcat(DlgBuf,datap->triggerseq);
				if ((bbflag & 0x03) <= 0x03) {
					if (strstr(datap->delay,"COU") == NULL) {
						strcat(DlgBuf," ");
						strcat(DlgBuf,datap->delay);
					} else if (strstr(datap->delay,"COU") != NULL) {
						strcat(DlgBuf," DEL ");
						strcat(DlgBuf,datap->count);
					}
				}
				strcat(DlgBuf,"\r");
			}
		} else if ((datap->trigger == FALSE) && (datap->trigger != ov->trigger)) 
			strcat(DlgBuf,"TRI CL\r");
	}

	if (retcode == AC_EXIT) return( EXITMENU );
	else if (retcode == AC_QUIT) return(SAMELEVEL);

}  /*  of MN_T_TRIGGER()  */

StripBlanks(ptr)
char *ptr;
{
	char *sptr,*eptr;
	
	for (sptr=ptr; (*ptr != '\0') && (*ptr == 0x20); ptr++) ;
	if ((sptr != ptr) && (*ptr != '\0'))  strcpy(sptr,ptr);
	else if (*ptr == '\0')  {
		*sptr = '\0';
		return;
	}
	ptr = sptr + strlen(sptr) - 1;
	for (eptr=ptr; (ptr >= sptr) && (*ptr == 0x20); ptr--);
	if (eptr != ptr) {
		ptr++; *ptr = '\0';
	}
}

TTriggerBegForm(dfmptr)
DFORMPTR dfmptr;
{
	DFIELDPTR fldptr,pp;
	int i, curitem;

	for (i=0,curitem=-1; i < 8; i++) {
		fldptr = (DFIELDPTR) i_numptr(++curitem,DlgFmPtr);
		fld_get(fldptr->datap,curitem,DlgFmPtr);
		if (strstr(fldptr->datap,"CLEAR") == NULL) {  // set
			pp = (DFIELDPTR) i_numptr(++curitem,DlgFmPtr);
			sf_opt(SKIP, OFF, pp);
			pp = (DFIELDPTR) i_numptr(++curitem,DlgFmPtr);
			sf_opt(SKIP, OFF, pp);
			pp = (DFIELDPTR) i_numptr(++curitem,DlgFmPtr);
			sf_opt(SKIP, OFF, pp);
		} else {
			pp = (DFIELDPTR) i_numptr(++curitem,DlgFmPtr);
			sf_opt(SKIP, ON, pp);
			pp = (DFIELDPTR) i_numptr(++curitem,DlgFmPtr);
			sf_opt(SKIP, ON, pp);
			pp = (DFIELDPTR) i_numptr(++curitem,DlgFmPtr);
			sf_opt(SKIP, ON, pp);
		}
	}
	fldptr = (DFIELDPTR) i_namptr("trigger",DlgFmPtr);
	fld_get(fldptr->datap,i_namnum("trigger",DlgFmPtr),DlgFmPtr);
	if (*((UCHAR *)(fldptr->datap)) == TRUE) { 
//	if (fldptr->datap == TRUE) {  // SET
		pp = (DFIELDPTR) i_namptr("gtrace",DlgFmPtr);
		sf_opt(SKIP,OFF,pp);
		pp = (DFIELDPTR) i_namptr("gtimer",DlgFmPtr);
		sf_opt(SKIP,OFF,pp);
		pp = (DFIELDPTR) i_namptr("runends",DlgFmPtr);
		sf_opt(SKIP,OFF,pp);
		pp = (DFIELDPTR) i_namptr("triggerseq",DlgFmPtr);
		sf_opt(SKIP,OFF,pp);
		pp = (DFIELDPTR) i_namptr("delay",DlgFmPtr);
		sf_opt(SKIP,OFF,pp);
		pp = (DFIELDPTR) i_namptr("count",DlgFmPtr);
		sf_opt(SKIP,OFF,pp);
	} else {    // CLEAR
		pp = (DFIELDPTR) i_namptr("gtrace",DlgFmPtr);
		sf_opt(SKIP,ON,pp);
		pp = (DFIELDPTR) i_namptr("gtimer",DlgFmPtr);
		sf_opt(SKIP,ON,pp);
		pp = (DFIELDPTR) i_namptr("runends",DlgFmPtr);
		sf_opt(SKIP,ON,pp);
		pp = (DFIELDPTR) i_namptr("triggerseq",DlgFmPtr);
		sf_opt(SKIP,ON,pp);
		pp = (DFIELDPTR) i_namptr("delay",DlgFmPtr);
		sf_opt(SKIP,ON,pp);
		pp = (DFIELDPTR) i_namptr("count",DlgFmPtr);
		sf_opt(SKIP,ON,pp);
	}
	return(TRUE);
}

TriggerOpEnd(dfmptr)
DFORMPTR dfmptr;
{
	DFIELDPTR fldptr;
	FIELDPTR pp;
	int curitem;

	curitem = curitemnum(dfmptr);
	fldptr = (DFIELDPTR) i_numptr(curitem,DlgFmPtr);
	fld_get(fldptr->datap,curitemnum(DlgFmPtr),DlgFmPtr);
	if (strstr(fldptr->datap,"CLEAR") == NULL) {  // set
		pp = (FIELDPTR) i_numptr(curitem+1,DlgFmPtr);
		sf_opt(SKIP, OFF, pp);
		pp = (FIELDPTR) i_numptr(curitem+2,DlgFmPtr);
		sf_opt(SKIP, OFF, pp);
		pp = (FIELDPTR) i_numptr(curitem+3,DlgFmPtr);
		sf_opt(SKIP, OFF, pp);
	} else {
		pp = (FIELDPTR) i_numptr(curitem+1,DlgFmPtr);
		sf_opt(SKIP, ON, pp);
		pp = (FIELDPTR) i_numptr(curitem+2,DlgFmPtr);
		sf_opt(SKIP, ON, pp);
		pp = (FIELDPTR) i_numptr(curitem+3,DlgFmPtr);
		sf_opt(SKIP, ON, pp);
	}
	return(TRUE);
}

TriggerLogicEnd(dfmptr)
DFORMPTR dfmptr;
{
	DFIELDPTR fldptr,curptr;
	int curitem;
	char *ptr;

	curitem = curitemnum(dfmptr);
	curptr = (DFIELDPTR) i_numptr(curitem,DlgFmPtr);
	memo_get(curptr->datap,curitemnum(DlgFmPtr),DlgFmPtr);
	if ((strlen(curptr->datap) > 0) && ((UCHAR *)(curptr->datap) != '\0')) {
		fldptr = (DFIELDPTR) i_numptr(curitem+1,DlgFmPtr);
		sf_opt(SKIP,OFF,fldptr);
		fldptr = (DFIELDPTR) i_numptr(curitem+2,DlgFmPtr);
		sf_opt(SKIP,OFF,fldptr);
	} else {
		fldptr = (DFIELDPTR) i_numptr(curitem+1,DlgFmPtr);
		sf_opt(SKIP,ON,fldptr);
		fldptr = (DFIELDPTR) i_numptr(curitem+2,DlgFmPtr);
		sf_opt(SKIP,ON,fldptr);
	}
	return(TRUE);
}


/****************************************************************************/
/*  TRACE menu Trace Control menu-item					    */
/****************************************************************************/

MN_T_TRACE( TraMenuCopy )
MFORMPTR  TraMenuCopy;
{
	TTRACE *datap;
	UCHAR temp[100],*ptr1,*ptr2, unit[5];
	WINDOWPTR msgwnp;
	DFIELDPTR fldptr;

	if (HaveLAM2) return(LAM2Trace());   

	temp[0] = '\0';
	VV_ERR = 0;
  	datap = &ttrace;
	memset(datap,NULL,sizeof(ttrace));
	DlgFmPtr = dl_fmget("TTrace",datap,usd3dlg,CListMFilePtr,VVDLibp);
 	if (DlgFmPtr == NULLP) {
		ErrorProc();
		return(EXITMENU);
	}
	ShowShadow(DlgFmPtr->wnp);
	fldptr = (DFIELDPTR) i_namptr("delay",DlgFmPtr);
	sf_msg(TFormMsgFld,fldptr);
	fldptr = (DFIELDPTR) i_namptr("eventseq",DlgFmPtr);
	sf_msg(TFormMsgFld,fldptr);
	fldptr = (DFIELDPTR) i_namptr("timebase",DlgFmPtr);
	sf_msg(TFormMsgFld,fldptr);
	fldptr = (DFIELDPTR) i_namptr("count",DlgFmPtr);
	sf_msg(FormMsgFld,fldptr);
	fldptr = (DFIELDPTR) i_namptr("addx",DlgFmPtr);
	sf_msg(FormMsgFld,fldptr);
	fldptr = (DFIELDPTR) i_namptr("status",DlgFmPtr);
	sf_msg(FormMsgFld,fldptr);
	
/* start getting TRACE setting from MICE */
	do_1_cmd_save("TRA",MICEBuf,(MICEBUFSIZE+1));
	ptr1 = MICEBuf;
	for (ptr1=MICEBuf; *ptr1 != '\0'; ptr1++) {
		if (*ptr1 == 0x0a || *ptr1 == 0x0d) *ptr1 = 0x20;
		else *ptr1 = toupper(*ptr1);
	}
/* trigger setting */
	ptr1 = strstr(MICEBuf,"TRIGGER");
	ptr2 = strstr(MICEBuf,"CYCLE QUAL");
	ptr1 += 8;
	memset(temp,NULL,100);
	memcpy(temp,ptr1,strlen(ptr1)-strlen(ptr2));
	if (strstr(temp,"CLEAR") != NULL) {
		datap->trigger = FALSE;
		datap->runends = FALSE;
		datap->eventseq[0] = '\0';
		datap->delay[0] = '\0';
		datap->count[0] = '\0';
	}
	else {
		datap->trigger = TRUE;
		if ((ptr1=strstr(temp,"RUN")) != NULL) {
			datap->runends = TRUE;
			ptr1 += 4;
		} else ptr1 = temp;
		memset(datap->eventseq,NULL,sizeof(datap->eventseq));
		if ((ptr2=strstr(ptr1,"FORWARD")) != NULL) {
			strncpy(datap->eventseq,ptr1,strlen(ptr1)-strlen(ptr2));
			strcpy(datap->delay,"FORWARD");
			datap->count[0] = '\0';
		} else if ((ptr2=strstr(ptr1,"BACKWARD")) != NULL) {
			strncpy(datap->eventseq,ptr1,strlen(ptr1)-strlen(ptr2));
			strcpy(datap->delay,"BACKWARD");
			datap->count[0] = '\0';
		} else if ((ptr2=strstr(ptr1,"CENTER")) != NULL) {
			strncpy(datap->eventseq,ptr1,strlen(ptr1)-strlen(ptr2));
			strcpy(datap->delay,"CENTER");
			datap->count[0] = '\0';
		} else if ((ptr2=strstr(ptr1,"DELAY")) != NULL) {
			strncpy(datap->eventseq,ptr1,strlen(ptr1)-strlen(ptr2));
		 	strcpy(datap->delay,"COUNT");
			ptr2 += 6;
			strcpy(datap->count,ptr2);
		} else {
			strcpy(datap->eventseq,ptr1);
			strcpy(datap->delay,"BACKWARD");
			datap->count[0] = '\0';
		}
		datap->eventseq[sizeof(datap->eventseq)-1] = '\0';
		datap->count[sizeof(datap->count)-1] = '\0';
	}
/* cycle setting */
	ptr1 = strstr(MICEBuf,"CYCLE");
	ptr1 += 17;
	ptr2 = strstr(MICEBuf,"TIMEBASE");
	memset(temp,NULL,100);
	memcpy(temp,ptr1,strlen(ptr1)-strlen(ptr2));
	if (strstr(temp,"ALL ADDRESSES") != NULL) {
		datap->cycle = FALSE;
		datap->addx[0] = '\0';
		datap->status[0] = '\0';
	}
	else   	{
		datap->cycle = TRUE;
		sscanf(temp," %s %s",datap->addx,datap->status);
		if ((ptr1=strstr(temp,datap->addx)) != NULL)  {
			ptr1 += strlen(datap->addx)+1;
			strcpy(datap->status,ptr1);
		}
	}
/* timebase setting */
	ptr1 = strstr(MICEBuf,"TIMEBASE");
	ptr2 = strstr(MICEBuf,"SYNC");
	ptr1 += 8;
	memset(temp,NULL,100);
	memcpy(temp,ptr1,strlen(ptr1)-strlen(ptr2));
	if ((ptr1=strchr(temp,'=')) != NULL) {
		ptr1++;
		sscanf(ptr1," %s ",datap->timebase);
		if (strstr(ptr1,"MS,") != NULL)  {
			if (strcmp(datap->timebase,"1") == 0)
				strcpy(datap->timebase,"1000");
			else if (strcmp(datap->timebase,"10") == 0)
				strcpy(datap->timebase,"10000");
		}
		if ((ptr2=strstr(temp,"GO")) != NULL)           datap->timer = TRUE;
		else if ((ptr2=strstr(temp,"EVENT")) != NULL)   datap->timer = FALSE;
	}
/* synchronization setting */
	memset(temp,NULL,sizeof(temp));
	ptr2 = strstr(MICEBuf,"SYNC");
	if ((ptr1=strstr(ptr2,"IN")) != NULL) ptr1 += 2;
	memcpy(temp,ptr1,5);
	if (strstr(temp,"OFF") != NULL) datap->synci = FALSE;
	else if (strstr(temp,"ON") != NULL) datap->synci = TRUE;

	if ((ptr1=strstr(ptr2,"OUT")) != NULL) ptr1 += 3;
	if (strstr(ptr1,"OFF") != NULL) datap->synco = FALSE;
	else if (strstr(ptr1,"ON") != NULL) datap->synco = TRUE;
/* finish getting the TRACE setting from MICE */

	msgwnp = wn_def(vs_rowq()-1,0,1,vs_colq(),LMESSAGE,BDR_NULLP);
	wn_up(msgwnp);
	v_st(BoolFldMsg,msgwnp);
	pulldown_or_dialog = DIALOG;
	retcode = fm_proc(0,DlgFmPtr);
	pulldown_or_dialog = PULLDOWN;
	wn_dn(msgwnp);
	wn_free(msgwnp);
	fm_free(DlgFmPtr);

	if (retcode == AC_EXIT)  {
		ExecDlgFlag = 1;
	/* TRIGGER COMMAND */
		strcat(DlgBuf,"T ");
		if (datap->trigger == TRUE) {
			if (strncmp(datap->delay,"BACK",4) == 0) strcpy(temp," BACK");
			else if (strncmp(datap->delay,"CEN",3) == 0) strcpy(temp," CEN");
			else if (strncmp(datap->delay,"FOR",3) == 0) strcpy(temp," FO");
			else if (strncmp(datap->delay,"COU",3) == 0) strcpy(temp," DEL ");
			if (datap->runends == TRUE) strcat(DlgBuf,"R ");
			if (datap->eventseq[0] != '\0') strcat(DlgBuf,datap->eventseq);
			if (temp[0] != '\0') strcat(DlgBuf,temp);
			if (strstr(temp,"DEL") != NULL) strcat(DlgBuf,datap->count);
		} else strcat(DlgBuf,"CL");
		strcat(DlgBuf,"\r");

	/*  QUALIFY COMMAND */
		strcat(DlgBuf,"Q ");
		datap->status[16] = '\0'; /* fill null in the end of status buffer */
		if (datap->cycle == TRUE) {
			if (datap->addx[0] != '\0') strcat(DlgBuf,datap->addx);
			if (datap->status[0] != '\0') {
				strcat(DlgBuf," ");
				strcat(DlgBuf,datap->status);
			}
		} else strcat(DlgBuf," CL");
		strcat(DlgBuf,"\r");

	/* TIMEBASE COMMAND */
		if (datap->timebase[0] != '\0') {
			strcat(DlgBuf,"TI ");
			if (datap->timer == TRUE) strcat(DlgBuf,"GO ");
			else if (datap->timer == FALSE) strcat(DlgBuf,"EVENT ");
			strcat(DlgBuf,datap->timebase);
			strcat(DlgBuf,"\r");
		}

	/* SYNC COMMAND */
		if (datap->synci == TRUE) strcat(DlgBuf,"SY I O\r");
		else if (datap->synci == FALSE) strcat(DlgBuf,"SY I OF\r");

		if (datap->synco == TRUE) strcat(DlgBuf,"SY OU O\r");
		else if (datap->synco == FALSE) strcat(DlgBuf,"SY OU OF\r");
	}

	if (retcode == AC_EXIT) return( EXITMENU );
	else if (retcode == AC_QUIT) return(SAMELEVEL);

}  /*  of MN_T_TRACE()  */

TraceTriggerEnd(dfmptr)
DFORMPTR dfmptr;
{
	DFIELDPTR fldptr,curptr;

	curptr = (DFIELDPTR)i_namptr("trigger",dfmptr);
	fld_get(curptr->datap,curitemnum(dfmptr),dfmptr);    
	if (*((UCHAR *)(curptr->datap)) == FALSE) { // clear
		if (HaveLAM2) {
			fldptr = (DFIELDPTR) i_namptr("gtrace",dfmptr);
			sf_opt(SKIP,ON,fldptr);
			fldptr = (DFIELDPTR) i_namptr("gtimer",dfmptr);
			sf_opt(SKIP,ON,fldptr);
		}
		fldptr = (DFIELDPTR) i_namptr("runends",dfmptr);
		sf_opt(SKIP,ON,fldptr);
		if (HaveLAM2) fldptr = (DFIELDPTR) i_namptr("triggerseq",dfmptr);
		else fldptr = (DFIELDPTR) i_namptr("eventseq",dfmptr);
		sf_opt(SKIP,ON,fldptr);
		fldptr = (DFIELDPTR) i_namptr("delay",dfmptr);
		sf_opt(SKIP,ON,fldptr);
		fldptr = (DFIELDPTR) i_namptr("count",dfmptr);
		sf_opt(SKIP,ON,fldptr);
	} else {
		if (HaveLAM2) {
			fldptr = (DFIELDPTR) i_namptr("gtrace",dfmptr);
			sf_opt(SKIP,OFF,fldptr);
			fldptr = (DFIELDPTR) i_namptr("gtimer",dfmptr);
			sf_opt(SKIP,OFF,fldptr);
		}
		fldptr = (DFIELDPTR) i_namptr("runends",dfmptr);
		sf_opt(SKIP,OFF,fldptr);
		if (HaveLAM2) fldptr = (DFIELDPTR) i_namptr("triggerseq",dfmptr);
		else fldptr = (DFIELDPTR) i_namptr("eventseq",dfmptr);
		sf_opt(SKIP,OFF,fldptr);
		fldptr = (DFIELDPTR) i_namptr("delay",dfmptr);
		sf_opt(SKIP,OFF,fldptr);
		fldptr = (DFIELDPTR) i_namptr("count",dfmptr);
		sf_opt(SKIP,OFF,fldptr);
	}
	return(TRUE);
}

TraceDelayEnd(dfmptr)
DFORMPTR dfmptr;
{
	DFIELDPTR fldptr,curptr;
	
	curptr = (DFIELDPTR) i_namptr("delay",dfmptr);
	fld_get(curptr->datap,curitemnum(dfmptr),dfmptr);
	if (strstr(curptr->datap,"COU") == NULL)  {
		fldptr = (DFIELDPTR) i_namptr("count",dfmptr);
		sf_opt(SKIP,ON,fldptr);
		memset(ttrace.count,NULL,sizeof(ttrace.count));
		fld_upd(ttrace.count,i_namnum("count",DlgFmPtr),DlgFmPtr);
	} else {
		fldptr = (DFIELDPTR) i_namptr("count",dfmptr);
		sf_opt(SKIP,OFF,fldptr);
	}
	return(TRUE);
}

TraceCycleEnd(dfmptr)
DFORMPTR dfmptr;
{
	DFIELDPTR fldptr,curptr;

	curptr = (DFIELDPTR) i_namptr("cycle",dfmptr);
	fld_get(curptr->datap,curitemnum(dfmptr),dfmptr);
	if (*((UCHAR *)(curptr->datap)) == FALSE) {
		fldptr = (DFIELDPTR) i_namptr("addx",dfmptr);
		sf_opt(SKIP,ON,fldptr);
		fldptr = (DFIELDPTR) i_namptr("status",dfmptr);
		sf_opt(SKIP,ON,fldptr);
	} else {
		fldptr = (DFIELDPTR) i_namptr("addx",dfmptr);
		sf_opt(SKIP,OFF,fldptr);
		fldptr = (DFIELDPTR) i_namptr("status",dfmptr);
		sf_opt(SKIP,OFF,fldptr);
	}
	return(TRUE);
}

TraceTBEnd(dfmptr)
DFORMPTR dfmptr;
{
	DFIELDPTR fldptr,curptr;
	UCHAR ttt[2];

	curptr = (DFIELDPTR) i_namptr("timebase",dfmptr);
	fld_get(curptr->datap,curitemnum(dfmptr),dfmptr);
	memset(ttt,NULL,2);
	strncpy(ttt,curptr->datap,1);
	if (ttt[0] == '\0') {
		fldptr = (DFIELDPTR) i_namptr("timer",dfmptr);
		sf_opt(SKIP,ON,fldptr);
	} else {
		fldptr = (DFIELDPTR) i_namptr("timer",dfmptr);
		sf_opt(SKIP,OFF,fldptr);
	}
	return(TRUE);
}


LAM2Trace()
{
	TLAM2TRACE *datap;
	WINDOWPTR msgwnp;
	DFIELDPTR fldptr;
	char *ptr1,*ptr2,*ptr3;
	int i;
	struct {
		char f1[30];
		char f2[30];
		char f3[30];
		char f4[30];
		char f5[30];
		char f6[30];
		char f7[30];
	} t;
	
	VV_ERR = 0;
	datap = &tlam2trace;
	memset(datap,NULL,sizeof(tlam2trace));
	DlgFmPtr = dl_fmget("TLAM2Trace",datap,usd3dlg,CListMFilePtr,VVDLibp);
 	if (DlgFmPtr == NULLP) {
		ErrorProc();
		return(EXITMENU);
	}
	ShowShadow(DlgFmPtr->wnp);

	fldptr = (DFIELDPTR) i_namptr("cycle1",DlgFmPtr);
	sf_msg(TFormMsgFld,fldptr);
	fldptr = (DFIELDPTR) i_namptr("cycle2",DlgFmPtr);
	sf_msg(TFormMsgFld,fldptr);
	fldptr = (DFIELDPTR) i_namptr("timebase",DlgFmPtr);
	sf_msg(TFormMsgFld,fldptr);
	fldptr = (DFIELDPTR) i_namptr("synci",DlgFmPtr);
	sf_msg(BoolFldMsgFld,fldptr);
	fldptr = (DFIELDPTR) i_namptr("synco",DlgFmPtr);
	sf_msg(BoolFldMsgFld,fldptr);

// get MICE settings
// get cycle setting
	do_1_cmd_save("Q",MICEBuf,(MICEBUFSIZE+1));
//	for (ptr3=MICEBuf; *ptr3 != '\0'; ptr3++)  *ptr3 = toupper(*ptr3);
	ptr2 = strstr(MICEBuf,">");
	*ptr2 = '\0';
	ptr2 = ptr1 = MICEBuf;
	ptr1 = SepLineFromLongString(ptr1);
	if ((ptr2=strstr(ptr2,"1 :")) != NULL) {
		ptr2 += 3;
		memset(&t,NULL,sizeof(t));
		if (strstr(ptr2,"All address and status") != NULL) {
			if (strstr(ptr2,"Enable") != NULL)
				strcpy(datap->cycle1,"ENABLE");
			else if (strstr(ptr2,"Disable") != NULL)
				strcpy(datap->cycle1,"DISABLE");
			datap->addx1[0] = '\0';
			datap->status1[0] = '\0';
			datap->tracebit1[0] = '\0';
		} else {
			memset(&t,NULL,sizeof(t));
			if ((ptr3=strstr(ptr2,"Range")) == NULL) {
				i = sscanf(ptr2," %s %s %s %s %s",t.f1,t.f2,t.f3,t.f4,t.f5);
				if (i == 2 || i == 4) datap->status1[0] = '\0';
				else {
					StripBlanks(t.f2);
					strcpy(datap->status1,t.f2);
				}
				if (i == 2) strcpy(datap->cycle1,t.f2);
				if (i == 3) strcpy(datap->cycle1,t.f3);
				if (i == 4) {
					StripBlanks(t.f3);
					StripBlanks(t.f4);
					strcpy(datap->cycle1,t.f4);
					strcpy(datap->tracebit1,t.f3);
				}
				if (i == 5) {
					StripBlanks(t.f4);
					StripBlanks(t.f5);
					strcpy(datap->cycle1,t.f5);
					strcpy(datap->tracebit1,t.f4);
				}
				ptr3 = strtok(ptr2," ");
				if (ptr3) strcpy(datap->addx1,ptr3);
			} else {
				i = sscanf(ptr3," %s %s %s %s %s %s %s",t.f1,t.f2,t.f3,t.f4,t.f5,t.f6,t.f7);
				if (i == 4 || i == 6) datap->status1[0] = '\0';
				else {
					StripBlanks(t.f4);
					strcpy(datap->status1,t.f4);
				}
				if (i == 4) strcpy(datap->cycle1,t.f4);
				if (i == 5) strcpy(datap->cycle1,t.f5);
				if (i == 6) {
					StripBlanks(t.f5);
					StripBlanks(t.f6);
					strcpy(datap->cycle1,t.f6);
					strcpy(datap->tracebit1,t.f5);
				}
				if (i == 7) {
					StripBlanks(t.f6);
					StripBlanks(t.f7);
					strcpy(datap->cycle1,t.f7);
					strcpy(datap->tracebit1,t.f6);
				}
				ptr2 = strstr(ptr3+5,t.f4);
				*ptr2 = '\0';
				strcpy(datap->addx1,ptr3);
			}
		}
	}
// cycle qualify 2:
	ptr2 = ptr1;
	if ((ptr2=strstr(ptr2,"2 :")) != NULL) {
		ptr2 += 3;
		memset(&t,NULL,sizeof(t));
		if (strstr(ptr2,"All address and status") != NULL) {
			if (strstr(ptr2,"Enable") != NULL)
				strcpy(datap->cycle2,"ENABLE");
			else if (strstr(ptr2,"Disable") != NULL)
				strcpy(datap->cycle2,"DISABLE");
			datap->addx2[0] = '\0';
			datap->status2[0] = '\0';
			datap->tracebit2[0] = '\0';
		} else {
			memset(&t,NULL,sizeof(t));
			if ((ptr3=strstr(ptr2,"Range")) == NULL) {
				i = sscanf(ptr2," %s %s %s %s %s",t.f1,t.f2,t.f3,t.f4,t.f5);
				if (i == 2 || i == 4) datap->status2[0] = '\0';
				else {
					StripBlanks(t.f2);
					strcpy(datap->status2,t.f2);
				}
				if (i == 2) strcpy(datap->cycle2,t.f2);
				if (i == 3) strcpy(datap->cycle2,t.f3);
				if (i == 4) {
					StripBlanks(t.f3);
					StripBlanks(t.f4);
					strcpy(datap->cycle2,t.f4);
					strcpy(datap->tracebit2,t.f3);
				}
				if (i == 5) {
					StripBlanks(t.f4);
					StripBlanks(t.f5);
					strcpy(datap->cycle2,t.f5);
					strcpy(datap->tracebit2,t.f4);
				}
				ptr3 = strtok(ptr2," ");
				if (ptr3) strcpy(datap->addx2,ptr3);
			} else {
				i = sscanf(ptr3," %s %s %s %s %s %s %s",t.f1,t.f2,t.f3,t.f4,t.f5,t.f6,t.f7);
				if (i == 4 || i == 6) datap->status2[0] = '\0';
				else {
					StripBlanks(t.f4);
					strcpy(datap->status2,t.f4);
				}
				if (i == 4) strcpy(datap->cycle2,t.f4);
				if (i == 5) strcpy(datap->cycle2,t.f5);
				if (i == 6) {
					StripBlanks(t.f5);
					StripBlanks(t.f6);
					strcpy(datap->cycle2,t.f6);
					strcpy(datap->tracebit2,t.f5);
				}
				if (i == 7) {
					StripBlanks(t.f6);
					StripBlanks(t.f7);
					strcpy(datap->cycle2,t.f7);
					strcpy(datap->tracebit2,t.f6);
				}
				ptr2 = strstr(ptr3+5,t.f4);
				*ptr2 = '\0';
				strcpy(datap->addx2,ptr3);
			}
		}
	}
// get timebase
	do_1_cmd_save("TI",MICEBuf,(MICEBUFSIZE+1));
	ptr1 = MICEBuf;
	memset(&t,NULL,sizeof(t));
	ptr2 = strstr(ptr1,"=");
	ptr2++;
	sscanf(ptr2,"%s %s",t.f1,t.f2);
	if (strstr(t.f2,"ms") != NULL) strcpy(datap->timebase,"1000");
	else strcpy(datap->timebase,t.f1);
// get sync
	do_1_cmd_save("SYN",MICEBuf,(MICEBUFSIZE+1));
	for (ptr3=MICEBuf; *ptr3 != '\0'; ptr3++)  *ptr3 = toupper(*ptr3);
	ptr2 = ptr1 = MICEBuf;
	if ((ptr2=strstr(ptr2,"IN")) != NULL)  {
		ptr2 += 2;
		sscanf(ptr2,"%s",t.f1);
		if (strstr(t.f1,"ON") != NULL) datap->synci = TRUE;
		else datap->synci = FALSE;
	}
	if ((ptr2=strstr(ptr2,"OUT")) != NULL) {
		ptr2 += 3;
		sscanf(ptr2,"%s",t.f2);
		if (strstr(t.f2,"ON") != NULL) datap->synco = TRUE;
		else datap->synco = FALSE;
	}

	msgwnp = wn_def(vs_rowq()-1,0,1,vs_colq(),LMESSAGE,BDR_NULLP);
	wn_up(msgwnp);
	v_st(FormMsg,msgwnp);
	pulldown_or_dialog = DIALOG;
	retcode = fm_proc(0,DlgFmPtr);
	pulldown_or_dialog = PULLDOWN;
	wn_dn(msgwnp);
	wn_free(msgwnp);
	fm_free(DlgFmPtr);

 	if (retcode == AC_EXIT)  {
		ExecDlgFlag = 1;
	/*  QUALIFY 1 COMMAND */
		if ((strstr(datap->cycle1,"SET") != NULL)  &&
		    (strstr(datap->cycle1,"RESET") == NULL)) {
			if (datap->addx1[0] != '\0') {
				strcat(DlgBuf,"Q 1 ");
				i = sscanf(datap->addx1,"%s %s %s",t.f1,t.f2,t.f3);
				if ((i == 2) && (strstr(t.f1,"ra") == NULL) &&
					        (strstr(t.f1,"RA") == NULL))
					strcat(DlgBuf,"RA ");
				strcat(DlgBuf,datap->addx1);
				if (datap->status1[0] != '\0') {
					strcat(DlgBuf," ");
					strcat(DlgBuf,datap->status1);
				}
				if (datap->tracebit1[0] != '\0') {
					if (strstr(datap->tracebit1,"EX") == NULL)
						strcat(DlgBuf," EX");
					strcat(DlgBuf," ");
					strcat(DlgBuf,datap->tracebit1);
				}
				strcat(DlgBuf,"\r");
			}
		} else {
			strcat(DlgBuf,"Q 1 ");
			strncat(DlgBuf,datap->cycle1,2);
			strcat(DlgBuf,"\r");
		}
	/*  QUALIFY 2 COMMAND */
		if ((strstr(datap->cycle2,"SET") != NULL)  &&
		    (strstr(datap->cycle2,"RESET") == NULL)) {
			if (datap->addx2[0] != '\0') {
				strcat(DlgBuf,"Q 2 ");
				i = sscanf(datap->addx2,"%s %s %s",t.f1,t.f2,t.f3);
				if ((i == 2) && (strstr(t.f1,"ra") == NULL) &&
					        (strstr(t.f1,"RA") == NULL))
					strcat(DlgBuf,"RA ");
				strcat(DlgBuf,datap->addx2);
				if (datap->status2[0] != '\0') {
					strcat(DlgBuf," ");
					strcat(DlgBuf,datap->status2);
				}
				if (datap->tracebit2[0] != '\0') {
					if (strstr(datap->tracebit2,"EX") == NULL)
						strcat(DlgBuf," EX");
					strcat(DlgBuf," ");
					strcat(DlgBuf,datap->tracebit2);
				}
				strcat(DlgBuf,"\r");
			}
		} else {
			strcat(DlgBuf,"Q 2 ");
			strncat(DlgBuf,datap->cycle2,2);
			strcat(DlgBuf,"\r");
		}

	/* TIMEBASE COMMAND */
		if (datap->timebase[0] != '\0') {
			strcat(DlgBuf,"TI ");
			strcat(DlgBuf,datap->timebase);
			strcat(DlgBuf,"\r");
		}

	/* SYNC COMMAND */
		if (datap->synci == TRUE) strcat(DlgBuf,"SY I O\r");
		else if (datap->synci == FALSE) strcat(DlgBuf,"SY I OF\r");

		if (datap->synco == TRUE) strcat(DlgBuf,"SY OU O\r");
		else if (datap->synco == FALSE) strcat(DlgBuf,"SY OU OF\r");
	}

	if (retcode == AC_EXIT) return( EXITMENU );
	else if (retcode == AC_QUIT) return(SAMELEVEL);

}

char *SepLineFromLongString(bufstart)
char *bufstart;
{
	while ((*bufstart != 0x0a) && (*bufstart != '>') && (*bufstart != '\0')) bufstart++;
	if ((*bufstart != '\0') && (*bufstart != '>'))  {
		if ((*bufstart == 0x0a) || (*bufstart == 0x0d))
			*bufstart = '\0';
		bufstart += 2;
	}
	return (bufstart);
}

LAM2CycleEnd(dfmptr)
DFORMPTR dfmptr;
{
	DFIELDPTR fldptr,curptr;
	int curitem;

	curitem = curitemnum(dfmptr);
	curptr = (DFIELDPTR) i_numptr(curitem,DlgFmPtr);
	fld_get(curptr->datap,curitemnum(DlgFmPtr),DlgFmPtr);
	if ((strstr(curptr->datap,"SET") != NULL) && (strlen(curptr->datap) == 3)) {
//	if (strncmp(curptr->datap,"SET",3) == 0) {
		fldptr = (DFIELDPTR) i_numptr(curitem+1,DlgFmPtr);
		sf_opt(SKIP,OFF,fldptr);
		fldptr = (DFIELDPTR) i_numptr(curitem+2,DlgFmPtr);
		sf_opt(SKIP,OFF,fldptr);
		fldptr = (DFIELDPTR) i_numptr(curitem+3,DlgFmPtr);
		sf_opt(SKIP,OFF,fldptr);
	} else {
		fldptr = (DFIELDPTR) i_numptr(curitem+1,DlgFmPtr);
		sf_opt(SKIP,ON,fldptr);
		fldptr = (DFIELDPTR) i_numptr(curitem+2,DlgFmPtr);
		sf_opt(SKIP,ON,fldptr);
		fldptr = (DFIELDPTR) i_numptr(curitem+3,DlgFmPtr);
		sf_opt(SKIP,ON,fldptr);
	}
	return(TRUE);
}

CycleAddxEnd(dfmptr)
DFORMPTR dfmptr;
{
	DFIELDPTR fldptr,curptr;
	int curitem;

	curitem = curitemnum(dfmptr);
	curptr = (DFIELDPTR) i_numptr(curitem,DlgFmPtr);
	memo_get(curptr->datap,curitemnum(DlgFmPtr),DlgFmPtr);
	if (strlen(curptr->datap) > 0) {
		fldptr = (DFIELDPTR) i_numptr(curitem+1,DlgFmPtr);
		sf_opt(SKIP,OFF,fldptr);
		fldptr = (DFIELDPTR) i_numptr(curitem+2,DlgFmPtr);
		sf_opt(SKIP,OFF,fldptr);
	} else {
		fldptr = (DFIELDPTR) i_numptr(curitem+1,DlgFmPtr);
		sf_opt(SKIP,ON,fldptr);
		fldptr = (DFIELDPTR) i_numptr(curitem+2,DlgFmPtr);
		sf_opt(SKIP,ON,fldptr);
	}
	return(TRUE);
}

CycleStatusEnd(dfmptr)
DFORMPTR dfmptr;
{
	DFIELDPTR fldptr,curptr;
	int curitem;

	curitem = curitemnum(dfmptr);
	curptr = (DFIELDPTR) i_numptr(curitem,DlgFmPtr);
	memo_get(curptr->datap,curitemnum(DlgFmPtr),DlgFmPtr);
	if (strlen(curptr->datap) > 0) {
		fldptr = (DFIELDPTR) i_numptr(curitem+1,DlgFmPtr);
		sf_opt(SKIP,OFF,fldptr);
	} else {
		fldptr = (DFIELDPTR) i_numptr(curitem+1,DlgFmPtr);
		sf_opt(SKIP,ON,fldptr);
	}
	return(TRUE);
}

/****************************************************************************/
/*  TRACE menu Backward Trace menu-item					    */
/****************************************************************************/

MN_T_BACKWARD( TraMenuCopy )
MFORMPTR  TraMenuCopy;
{
	TBACKWARD *datap;
	WINDOWPTR msgwnp;
	DFIELDPTR fldptr;

	VV_ERR = 0;
	datap = &tbackward;
	DlgFmPtr = dl_fmget("TBackward",datap,NULLP,CListMFilePtr,VVDLibp);
 	if (DlgFmPtr == NULLP) {
		ErrorProc();
		return(EXITMENU);
	}
	ShowShadow(DlgFmPtr->wnp);
	fldptr = (DFIELDPTR) i_namptr("runends",DlgFmPtr);
	sf_msg(BoolFldMsgFld,fldptr);

	msgwnp = wn_def(vs_rowq()-1,0,1,vs_colq(),LMESSAGE,BDR_NULLP);
	wn_up(msgwnp);
	v_st(FormMsg,msgwnp);
	pulldown_or_dialog = DIALOG;
	retcode = fm_proc(0,DlgFmPtr);
	pulldown_or_dialog = PULLDOWN;
	wn_dn(msgwnp);
	wn_free(msgwnp);
	fm_free(DlgFmPtr);

	if (retcode == AC_EXIT)  {
		ExecDlgFlag = 1;
		strcat(DlgBuf,"B ");
		if (datap->runends == TRUE) strcat(DlgBuf,"R ");
		strcat(DlgBuf,datap->addx);
		if (datap->count[0] != '\0') {
			strcat(DlgBuf," ");
			strcat(DlgBuf,datap->count);
			if (datap->qualifier[0] != '\0') {
				strcat(DlgBuf," ");
				strcat(DlgBuf,datap->qualifier);
			}
		}
		strcat(DlgBuf,"\r");
	}

	if (retcode == AC_EXIT) return( EXITMENU );
	else if (retcode == AC_QUIT) return(SAMELEVEL);

}  /*  of MN_T_BACKWARD()  */

/****************************************************************************/
/*  TRACE menu Forward Trace menu-item					    */
/****************************************************************************/

MN_T_FORWARD( TraMenuCopy )
MFORMPTR  TraMenuCopy;
{
	TFORWARD *datap;
	WINDOWPTR msgwnp;
	DFIELDPTR fldptr;

	VV_ERR = 0;
	datap = &tforward;
	DlgFmPtr = dl_fmget("TForward",datap,NULLP,CListMFilePtr,VVDLibp);
 	if (DlgFmPtr == NULLP) {
		ErrorProc();
		return(EXITMENU);
	}
	ShowShadow(DlgFmPtr->wnp);
 	fldptr = (DFIELDPTR) i_namptr("runends",DlgFmPtr);
	sf_msg(BoolFldMsgFld,fldptr);

	msgwnp = wn_def(vs_rowq()-1,0,1,vs_colq(),LMESSAGE,BDR_NULLP);
	wn_up(msgwnp);
	v_st(FormMsg,msgwnp);
	pulldown_or_dialog = DIALOG;
	retcode = fm_proc(0,DlgFmPtr);
	pulldown_or_dialog = PULLDOWN;
	wn_dn(msgwnp);
	wn_free(msgwnp);
	fm_free(DlgFmPtr);

	if (retcode == AC_EXIT)  {
		ExecDlgFlag = 1;
		strcat(DlgBuf,"F ");
		if (datap->runends == TRUE) strcat(DlgBuf,"R ");
		strcat(DlgBuf,datap->addx);
		if (datap->count[0] != '\0') {
			strcat(DlgBuf," ");
			strcat(DlgBuf,datap->count);
			if (datap->qualifier[0] != '\0') {
				strcat(DlgBuf," ");
				strcat(DlgBuf,datap->qualifier);
			}
		}
		strcat(DlgBuf,"\r");
	}

	if (retcode == AC_EXIT) return( EXITMENU );
	else if (retcode == AC_QUIT) return(SAMELEVEL);

}  /*  of MN_T_FORWARD()  */

/****************************************************************************/
/*  TRACE menu Go menu-item						    */
/****************************************************************************/

MN_T_GO( TraMenuCopy )
MFORMPTR  TraMenuCopy;
{
	ExecDlgFlag = 1;
	strcat(DlgBuf,"G\r");
	return( EXITMENU );

}  /*  of MN_T_GO()  */

/****************************************************************************/
/*  TRACE menu Halt menu-item						    */
/****************************************************************************/

MN_T_HALT( TraMenuCopy )
MFORMPTR  TraMenuCopy;
{
	ExecDlgFlag = 1;
	if (env.MICEGroup == MICE2) strcat(DlgBuf,"H\r");
	else strcat(DlgBuf,"HA\r");
	return( EXITMENU );

}  /*  of MN_T_HALT()  */

/****************************************************************************/
/*  TRACE menu List menu-item						    */
/****************************************************************************/

MN_T_LIST( TraMenuCopy )
MFORMPTR  TraMenuCopy;
{
	TLIST *datap;
	WINDOWPTR msgwnp;
	DFIELDPTR fldptr;
	char tbuf[100], *ptr;

	VV_ERR = 0;
	datap = &tlist;

	strcpy(tbuf,((env.Mmodel >= MICE_3_BOUND) ? "L N" : "LN"));
	do_1_cmd_save(tbuf,MICEBuf,(MICEBUFSIZE+1));
	if (strchr(MICEBuf,'!') == NULL) {
		if (env.MICEGroup == MICE2)  {
			if ((ptr=strstr(MICEBuf,"AT STEP")) != NULL) {
				sscanf(ptr+7," %s ",tbuf);
				if (strlen(tbuf) > 4) strcpy(datap->totalframe,"0");
				else strcpy(datap->totalframe,tbuf);
			} else strcpy(datap->totalframe,"0");
		} else {
			if ((ptr=strstr(MICEBuf,"empty")) != NULL)
				strcpy(datap->totalframe,"0");
			else {
				ptr=strchr(MICEBuf,'=');
				memcpy(datap->totalframe,ptr+2,4);
			}
		}
	}

	DlgFmPtr = dl_fmget("TList",datap,usd3dlg,CListMFilePtr,VVDLibp);
 	if (DlgFmPtr == NULLP) {
		ErrorProc();
		return(EXITMENU);
	}
	ShowShadow(DlgFmPtr->wnp);
	fldptr = (DFIELDPTR) i_namptr("format",DlgFmPtr);
	sf_msg(TFormMsgFld,fldptr);

	msgwnp = wn_def(vs_rowq()-1,0,1,vs_colq(),LMESSAGE,BDR_NULLP);
	wn_up(msgwnp);
	v_st(FormMsg,msgwnp);
	pulldown_or_dialog = DIALOG;
	retcode = fm_proc(0,DlgFmPtr);
	pulldown_or_dialog = PULLDOWN;
	wn_dn(msgwnp);
	wn_free(msgwnp);
	fm_free(DlgFmPtr);

	tbuf[0] = '\0';
	if (retcode == AC_EXIT)  {
		ExecDlgFlag = 1;
		ptr = datap->format;
		for (; *ptr != '\0'; ptr++) *ptr = toupper(*ptr);
		if (strstr(datap->format,"BOTH") != NULL)  {
			if (env.MICEGroup == MICE2) strcpy(tbuf," Z");
			else strcpy(tbuf," S");
		}
		else if ((strstr(datap->format,"ASSEMBLY") != NULL) ||
			 (strstr(datap->format,"CODE") != NULL)) {
			if (env.MICEGroup == MICE2) strcpy(tbuf," S");
			else strcpy(tbuf," I");
		}
		else if ((strstr(datap->format,"CYCLE") != NULL) ||
			 (strstr(datap->format,"RECORD") != NULL)) strcpy(tbuf," C");
		strcat(DlgBuf,"L");
		if (strcmp(tbuf," C") == 0)  {
			if (env.MICEGroup == MICE2) {
				if (datap->frame[0] != '\0') {
					strcat(DlgBuf," ");
					strcat(DlgBuf,datap->frame);
					if (datap->begaddr[0] != '\0') {
						strcat(DlgBuf," ");
						strcat(DlgBuf,datap->begaddr);
						if (datap->endaddr[0] != '\0') {
							strcat(DlgBuf," ");
							strcat(DlgBuf,datap->endaddr);
							if (datap->status[0] != '\0') {
								strcat(DlgBuf," ");
								strcat(DlgBuf,datap->status);
							}
						} /* end if (datap->endaddr) */
					} /* end if (datap->begaddr) */
				} /* end if (datap->frame) */
			} else {  /* (env.MICEGroup != MICE2) */
				if (datap->frame[0] != '\0') {
					strcat(DlgBuf," ");
					strcat(DlgBuf,datap->frame);
					if (datap->begaddr[0] != '\0') {
						strcat(DlgBuf," ");
						strcat(DlgBuf,datap->begaddr);
						strcat(DlgBuf," ");
						strcat(DlgBuf,datap->endaddr);
					}
					if (datap->status[0] != '\0') {
						strcat(DlgBuf," ");
						strcat(DlgBuf,datap->status);
					}
					if (datap->tracebits[0] != '\0') {
						if (HaveLAM2) strcat(DlgBuf," EX");
						strcat(DlgBuf," ");
						strcat(DlgBuf,datap->tracebits);
					}
				}
			} /* end else */
		} else if (
			tbuf[0] != '\0') {
			strcat(DlgBuf,tbuf);
			if (datap->frame[0] != '\0') {
				strcat(DlgBuf," ");
				strcat(DlgBuf,datap->frame);
			}
		} else if (datap->frame[0] != '\0') {
			strcat(DlgBuf," ");
			strcat(DlgBuf,datap->frame);
		}
		strcat(DlgBuf,"\r");
	} /* end if (AC_EXIT)  */

	if (retcode == AC_EXIT) return( EXITMENU );
	else if (retcode == AC_QUIT) return(SAMELEVEL);

}  /*  of MN_T_LIST()  */

ListFormatEnd(dfmptr)
DFORMPTR dfmptr;
{
	DFIELDPTR fldptr,curptr;
	char *ptr;

	curptr = (DFIELDPTR) i_namptr("format",dfmptr);
	fld_get(curptr->datap,curitemnum(dfmptr),dfmptr);
	for (ptr=curptr->datap; *ptr != '\0'; ptr++) *ptr = toupper(*ptr);
	if (strstr(curptr->datap,"CYCLE RECORD") == NULL) {
		fldptr = (DFIELDPTR) i_namptr("begaddr",dfmptr);
		sf_opt(SKIP,ON,fldptr);
		fldptr = (DFIELDPTR) i_namptr("endaddr",dfmptr);
		sf_opt(SKIP,ON,fldptr);
		fldptr = (DFIELDPTR) i_namptr("status",dfmptr);
		sf_opt(SKIP,ON,fldptr);
		fldptr = (DFIELDPTR) i_namptr("tracebits",dfmptr);
		sf_opt(SKIP,ON,fldptr);
	} else {
		fldptr = (DFIELDPTR) i_namptr("begaddr",dfmptr);
		sf_opt(SKIP,OFF,fldptr);
		fldptr = (DFIELDPTR) i_namptr("endaddr",dfmptr);
		sf_opt(SKIP,OFF,fldptr);
		fldptr = (DFIELDPTR) i_namptr("status",dfmptr);
		sf_opt(SKIP,OFF,fldptr);
		fldptr = (DFIELDPTR) i_namptr("tracebits",dfmptr);
		sf_opt(SKIP,OFF,fldptr);
	}
	return(TRUE);
}


