/*--------------------------------------------------------------------------*/
/*  usd3.c								    */
/*--------------------------------------------------------------------------*/

#include  <signal.h>
#include  "system.h"
#include  "menu.h"
#include  <vv_main.h>
#include  "usd3.h"
#include  "gbl.h"
#include  "oldgbl.h"
#include  "usym1.h"
#include  "usym2.h"
#include  "funcext.h"
#include  "dos16.h"

/****************************************************************************/
/*  Main Procedure							    */
/****************************************************************************/

int  (*OldCtrlCHandler)();
extern int  USD3CtrlCHandler();
extern int MAXFlag, COMVPMax;

main( argc, argv )
int   argc;
char  *argv[];
{
 PTR	     TmpMemory;

 if ( argc > 2 ) { ErrorCondition = TOO_MANY_ARGUMENT; goto End5; }

 InitIoErr();
 InitMouse();/* USD-III V2.0x */
 init_vv();
   if (_vid_scr.vbufp == 0L)
      _vid_scr.vbufp =
         D16SegAbsolute(vid_getmode() == MONO ? 0xB0000 : 0xB8000, 0x8000);
 OldVideoMode = vid_getmode();
 vs_clr();
 OldCtrlCHandler = signal( SIGINT, USD3CtrlCHandler );

 /*  initialize global variables  */

 if ( ! InitGbl() ) { goto End4; }

 /*  manage the initialization of MICE  */

 if ( ! InitMICE() ) { goto End3; }

 /*  create menus  */

 if ( ! CreateMenu() ) { ErrorCondition = MEM_INSUFFICIENT; goto End2; }

 /*  create viewports  */

 if ( ! CreateVP() ) { ErrorCondition = MEM_INSUFFICIENT; goto End1; }

 ScrnDisplay = 1;

 if ( ( TmpMemory = malloc( 5 * 1024 ) ) == NULLP ) { ErrorCondition = MEM_INSUFFICIENT; goto End1; }
 else  free( TmpMemory );

 /*  set initial display of each viewport  */

 if (!MAXFlag) {
 	InitVPDisplay();
 } else {
 	InitVPDisplay();
//	InitNewCmd();
//	d_o_prompt();
	COMVPMax = 1;
   VP[ActVP].Ptr->titleatt = LVPTITLEINACT;

   wn_dn( VP[TopVP].Ptr );
   wn_dn( VP[CODVP].Ptr );

//   if ( STAVPIsUp = wn_isup(VP[STAVP].Ptr)) wn_dn(VP[STAVP].Ptr);
//   else  if ( DATVPIsUp = wn_isup(VP[DATVP].Ptr)) wn_dn(VP[DATVP].Ptr);
		    
//   COMVPyOrg   = VP[COMVP].yOrg;
//   COMVPxOrg   = VP[COMVP].xOrg;
//   COMVPHeight = VP[COMVP].Height;
//   COMVPWidth  = VP[COMVP].Width;

   sw_opt( WNECHO, OFF, VP[COMVP].Ptr );
   sw_bdr( &SingleVPBdr, VP[COMVP].Ptr );
   wn_mod_no_pre_wn_unset( VP[REGVP].yOrg, VP[REGVP].xOrg, 23, VP[REGVP].Width, VP[COMVP].Ptr );
   wn_mod_no_pre_wn_unset( VP[COMVP].yOrg=VP[REGVP].yOrg, VP[COMVP].xOrg=VP[REGVP].xOrg, VP[COMVP].Height=23, VP[REGVP].Width, VP[COMVP].Ptr );

   if ( VP[COMVP].Ptr->r < (VP[COMVP].Ptr->row_org+20) ) {

	sw_msorg( 0, VP[COMVP].Ptr->col_org, VP[COMVP].Ptr );
	wn_msadj( VP[COMVP].Ptr );
	csr_plwn( VP[COMVP].Ptr );
   }

    sw_opt( WNECHO, ON, VP[COMVP].Ptr );
    wn_upd( VP[COMVP].Ptr );
    ActVP = COMVP;
    VP[COMVP].Ptr->titleatt = LVPTITLEACT;
    v_titleatt( NULLP, LVPTITLEACT, VP[COMVP].Ptr );
 }
 
/*  check whether there is a command file appeared in the command line  */

 if ( argc == 2 ) {

    strcpy( KbdBuf, "INC " );
    strcat( KbdBuf, argv[1] );
    strcat( KbdBuf, "\r" );
    KbdBufIdx = 0; 
    KbdBufLastIdx = strlen( KbdBuf ) -1; 
 }

 for ( ; ; ) {
                          ////kbdbufidx initialed by 0
   if ( ( Keyin = KbdBuf[ KbdBufIdx++ ] ) == '\0' ) {

      KbdBuf[ KbdBufIdx = 0 ] = '\0';
      KbdBufLastIdx = -1;
      Keyin = get_key();
   }

   KeyinAnalysis();

   if ( ExitUSD3 )  break;
 }

 /*  destroy viewports  */

 DestroyVP();

End1 :

 DestroyMenu();

End2 :

 WmClose();

End3 :

 FreeGbl();

End4 :

 vs_clr();
 USD3vid_setmode( OldVideoMode );
 exit_vv();

End5 :

 switch( ErrorCondition ) {

   case TOO_MANY_ARGUMENT      : printf( "\nError! Too many arguments.\n" );
				 break;

   case MEM_INSUFFICIENT       : printf( "\nError! Insufficient memory to run USD3.\n" );
				 break;

   case CANNOT_LOAD_HANDLER    : printf( "\nError! Can't install RS-232 handler.\n" );
				 break;

   case USD3DLG_TXT_OPEN_ERR   : printf( "\nError! Can't open \"USD3DLG.TXT\".\n" );
				 break;

   case USD3CMD_TXT_OPEN_ERR   : printf( "\nError! Can't open \"USD3CMD.TXT\".\n" );
				 break;

   case USD3CLST_TXT_OPEN_ERR  : printf( "\nError! Can't open \"USD3CLST.TXT\".\n" );
				 break;

   case USD3DLG_LIB_OPEN_ERR   : printf( "\nError! Can't open \"USD3DLG.LIB\".\n" );
				 break;

   case CMDWORDFILE_OPEN_ERR   : if ( env.MICEGroup == MICE2 )
				    printf( "\nError! Can't open \"MICE2CMD.TXT\".\n" );
				 else
				    printf( "\nError! Can't open \"MICE3CMD.TXT\".\n" );
 }

 signal( SIGINT, OldCtrlCHandler );

}  /*  of Main()  */

/**************************************************************************
**
** Name : USD3vid_setmode()
**
** Function :
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

USD3vid_setmode(int mode)
{
unsigned char far* vbufsave;

   vbufsave = _vid_scr.vbufp;
   vid_setmode(mode);
   if (_vid_scr.vbufp == 0L)       /* under DPMI ? */
      _vid_scr.vbufp = vbufsave;   /* restore original value */
}
