/*--------------------------------------------------------------------------*/
/*  wusym1.c								    */
/*--------------------------------------------------------------------------*/

#include  "system.h"
#include  "usd3.h"
#include  "gblext.h"
#include  "oldext.h"
#include  "usym1.h"
#include  "usym3.h"
#include  "funcext.h"
#include  "dos16.h"

#define    MSK_ABS   0x00
#define    MSK_PHY   0x08
#define    MSK_MOD   0x02
#define    MSK_GBL   0x01
#define    MSK_UNK   0x00
#define    MSK_PCY   0x10
#define    MSK_PCN   0x00
#define    MSK_GRY   0x20
#define    MSK_GRN   0x00

#define    MSG_ON    ON
#define    MSG_OFF   OFF

#define U8 unsigned char
#define U16 unsigned int
#define U32 unsigned long

int (*absaddr)();
int absad86();
int absadh8();
int RecLoc[INDEX_RANGE];

extern struct attribute env;
extern struct pcstatus  PC;
long tell();
unsigned char absad[6];
extern int InxInSatable, InxInAstable;
int AddrIndexCompCnt, AddrComp(),aIndexComp(),bComp();
extern unsigned char *aentry;

/****************************************************************************/
/***** init_all(): build the input file names and initial the environment ***/
/****************************************************************************/
init_all(fname,msgon)
char *fname;
int msgon;
{
	char *tmp;

	for (tmp=fname; *tmp != NULL; tmp++) *tmp = toupper(*tmp);	
	strcpy(fnsy,fname);
	if ((tmp = strrchr(fnsy,'.')) == NULL)  strcat(fnsy,".USD");
	else    strcpy(tmp,".USD");
	return (build_all(msgon));
}


/******************************************************************************/
/******** build_all()                                                    ******/
/******************************************************************************/

build_all(msgon)
int msgon;
{

//	if (SymLoaded == OK) free_all();
	return(build_perm_table(msgon));
}


/*****************************************************************************/
/****** free_all()                                                      ******/
/*****************************************************************************/

free_all()
{
	free(modpos);
	free(GblSXTbl);
	free(GblAXTbl);
	free(modinxcnt);
	free(ModInxHead);
	D16MemFree(astable);
	close(fdsy);
	if (addinx > 0)  {
	for (; addinx > 0; addinx--)  
		free(addtable[addinx].name);
		memset(addtable,NULL,sizeof(struct addonitem)*ADDON);
	}
	addinx = modcnt = gblsymcnt = env.Saddrunit = env.Sabsflag = 0;
	return;
}

/************************************************************************/
/***** build_perm_table(): check the input files and build the module ***/
/*****                     table                                      ***/
/************************************************************************/

build_perm_table(msgon)
int msgon;
{
	int  i, cnt, *iinnxx;
	char tbuf[100],*tptr,*cptr;
	struct two_long addrpos,gblinxpos;
	long lpos, ll1;
	unsigned int ui;
	int fdtmp;

	VPOut = COMVP;
	memset(tbuf,NULL,100);
	if ((fdtmp=open(fnsy,O_BINARY|O_RDONLY)) == -1 ) {
		if (msgon == MSG_ON) prn_ferr(15);
		return(SymLoaded);
	}
	read(fdtmp,tbuf,20);
	if (strcmp(tbuf,"*MICROTEK 1991 USD3*") != 0)  {
		if (msgon == MSG_ON) prn_ferr(28);
		close(fdtmp);
		return(SymLoaded);
	}
	close(fdtmp);

	if (SymLoaded == OK) free_all();
	fdsy=open(fnsy,O_BINARY|O_RDONLY);
	lseek(fdsy,(long)-4,2);
	read(fdsy,(unsigned char *)&lpos,sizeof(long));
	lseek(fdsy,lpos,0);
/* starting reading the junk */
	read(fdsy,(unsigned char *)&env,4);
	read(fdsy,(unsigned char *)&modcnt,sizeof(int));
	read(fdsy,(unsigned char *)&totalinxcnt,sizeof(int));
	read(fdsy,(unsigned char *)&totalsymcnt,sizeof(int));
	read(fdsy,(unsigned char *)&gblsymcnt,sizeof(int));
	read(fdsy,(unsigned char *)&adrinxcnt,sizeof(int));
	if (gblsymcnt != 0)  {
		read(fdsy,(unsigned char *)&gblinxpos,sizeof(struct two_long));
		gblinxcnt = (gblsymcnt / INDEX_RANGE) + 2;
	}
	if (totalsymcnt > 0)
		read(fdsy,(unsigned char *)&addrpos,sizeof(struct two_long));
	adrreclen = 2 + 4 + env.Saddrunit;
	absaddr = absad86;
	if (env.Sabsflag)  {
		if (env.Maddrid != 4 && env.Maddrid != 6 && env.Mmodel != 34
			&& env.Mmodel != 40)  {
			if (msgon == MSG_ON) prn_ferr(28);
			return(FAIL);
		}
		if (env.Maddrid == 4 && env.Mmodel == 40) absaddr = absadh8;
		else if (env.Maddrid == 3 && env.Mmodel == 34) env.Sabsflag = 0;
		else absaddr = absad86;
	}
	else if (env.Maddrid == 4 || env.Maddrid == 6)  {
		if (env.Mmodel == 40 && env.Saddrunit == 3)
			 env.Sabsflag = 1;
		else {
	       		if (msgon == MSG_ON)   prn_ferr(28);
			return(FAIL);
		}
	}
/* checking if enough memory? */
/* sizeof modpos, modinxcnt, module_index_array, all the indexes */
	if ((tptr=malloc(modcnt*sizeof(long) + modcnt*sizeof(int) +
			 (modcnt+1) * sizeof(struct module_index) +
			 (totalinxcnt+1) * sizeof(struct symindex) +
			 (adrinxcnt+1) * sizeof(struct adrindex) )) == NULL) {
		if (msgon == MSG_ON) prn_ferr(67);
		close(fdsy);
		return(FAIL);
	} else {
		lpos = addrpos.ll2 - addrpos.ll1;
		if (lpos > 0xffff) cptr = D16HugeAlloc(lpos);
		else cptr = malloc((unsigned int)lpos);
		if (cptr == NULL) {
			if (msgon == MSG_ON) prn_ferr(67);
			free(tptr);
			close(fdsy);
			return(FAIL);
		} else {
			if (lpos > 0xffff) D16MemFree(cptr);
			else free(cptr);
			free(tptr);
		}
	}
/* starting loading the module positions array and module index count array */	
	if ((modpos=malloc(modcnt*sizeof(long))) == NULL) { 
		if (msgon == MSG_ON) prn_ferr(67);
		close(fdsy);
		return(FAIL);
	}
	read(fdsy,(unsigned char *)modpos,sizeof(long)*modcnt);
	if ((modinxcnt=malloc(modcnt*sizeof(int))) == NULL) { 
		if (msgon == MSG_ON) prn_ferr(67);
		free(modpos);
		close(fdsy);
		return(FAIL);
	}
	read(fdsy,(unsigned char *)modinxcnt,sizeof(int)*modcnt);
/* allocating the module index array */
	if ((ModInxHead=(struct module_index *)malloc((modcnt+1)*sizeof(struct module_index))) == NULL) {
		if (msgon == MSG_ON) prn_ferr(67);
		free(modpos);
		free(modinxcnt);
		close(fdsy);
		return(FAIL);
	}
/* allocating memory for all indexes */
	if ((SXPtr=(struct symindex *)malloc((totalinxcnt+1)*sizeof(struct symindex))) == NULL) {
		if (msgon == MSG_ON) prn_ferr(67);
		free(modpos);
		free(modinxcnt);
		free(ModInxHead);
		close(fdsy);
		return(FAIL);
	}
	if ((AXPtr=(struct adrindex *)malloc(adrinxcnt*sizeof(struct adrindex))) == NULL) {
		if (msgon == MSG_ON) prn_ferr(67);
		free(modpos);
		free(modinxcnt);
		free(ModInxHead);
		free(SXPtr);
		close(fdsy);
		return(FAIL);
	}
/* loading the global indexes if there is any global symbol */
	GblSXTbl = SXPtr;
	GblAXTbl = AXPtr;
	if (gblsymcnt > 0) {
		lseek(fdsy,gblinxpos.ll2,0);
		read(fdsy,(unsigned char *)SXPtr,sizeof(struct symindex)*gblinxcnt);
		SXPtr += gblinxcnt;
	}
/* loading all the address indexes */
	if (totalsymcnt > 0) {
		lseek(fdsy,addrpos.ll2,0);
		read(fdsy,(unsigned char *)AXPtr,sizeof(struct adrindex)*adrinxcnt);
	}
/* loading the module info and all the indexes */
	if (modcnt <= NO_MODULE) {
		neverswapmodule = 1;
		cnt = modcnt;
	}
	else cnt = NO_MODULE;
	for (CurModSAInx=ModInxHead,i=0; i < modcnt ; i++)   {
		if ((!neverswapmodule) && i>=NO_MODULE) 
			lseek(fdsy,modpos[i]+sizeof(struct module),0);
		else {
			lseek(fdsy,(modpos)[i],0);
			read(fdsy,(unsigned char *)&gblmod[i],sizeof(struct module));
		}
		CurModSAInx->cnt = modinxcnt[i];
		CurModSAInx->sxptr = SXPtr;
		read(fdsy,(unsigned char *)SXPtr,sizeof(struct symindex)*CurModSAInx->cnt);
		SXPtr += modinxcnt[i];
		CurModSAInx++;
	}
	CurModSAInx->cnt = -1;

/* loading address entries into memory */
	lpos = addrpos.ll2 - addrpos.ll1;
//	if (lpos >= 0xffff)
		astable = (unsigned char *) D16HugeAlloc(lpos);
//	else astable = (unsigned char *) malloc((unsigned int)lpos);
	if (astable == NULL) {
		if (msgon == MSG_ON) prn_ferr(67);
		free(modpos);
		free(modinxcnt);
		free(ModInxHead);
		free(SXPtr);
		close(fdsy);
		return(FAIL);
	}
	lseek(fdsy,addrpos.ll1,0);
	for (ll1=0L; lpos > 0; lpos-=ll1)  {
		if (lpos > 64000L)  ui = 64000;
		else                ui = (unsigned int) lpos;
		read(fdsy,astable+ll1,ui);
		ll1 += (long) ui;
	}
	

/* DEBUG: Displaying what is read from TBLfile 
{ char ttmmpp[20]; struct inxfpos *zptr;

	sprintf(tbuf,"\r\nAddress Unit=  %-4X bytes,  Segment Flag= %-4X (1:segmented,0:others)",env.Saddrunit,env.Sabsflag);
	DisplayStr(tbuf);
	sprintf(tbuf,"\r\nTotal module count= %-4X /D%-3d, Total Index Count= %-4X /D%-3d",modcnt,modcnt,totalinxcnt,totalinxcnt);
	DisplayStr(tbuf);
	sprintf(tbuf,"\r\nTotal symbol count= %-4X /D%-3d, addr Index Count= %-4X /D%-3d",totalsymcnt,totalsymcnt,adrinxcnt,adrinxcnt);
	DisplayStr(tbuf);
	sprintf(tbuf,"\r\nGlobal symbol count= %-4X /D %-5d",gblsymcnt,gblsymcnt);
	DisplayStr(tbuf);
	sprintf(tbuf,"\r\n\r\nfpos for the inx of gbl symbols: sym/addr= %-8lX / %-8lX",gblinxpos.ll1,gblinxpos.ll2);
	DisplayStr(tbuf);
	sprintf(tbuf,"\r\n\r\nfpos for the inx of addr entry : sym/addr= %-8lX / %-8lX",addrpos.ll1,addrpos.ll2);
	DisplayStr(tbuf);
	chk_hlt();

	DisplayStr("\r\n\r\nfpos for modules: [Decimal]");
	for (i=0; i < modcnt; i++) {
		chk_hlt();
		if ((i%3) == 0) DisplayStr("\r\n   ");
		sprintf(tbuf,"[%4d]= %-8lX   ",i,modpos[i]);
		DisplayStr(tbuf);
	}
	if ((i-1)%3 == 0) DisplayStr("\r\n");

	DisplayStr("\r\n\r\nindex count for modules: [Decimal]");
	for (i=0; i < modcnt; i++) {
		chk_hlt();
		if ((i%3) == 0) DisplayStr("\r\n   ");
		sprintf(tbuf,"[%4d]= D %-5d   ",i,modinxcnt[i]);
		DisplayStr(tbuf);
	}
	if ((i-1)%3 == 0) DisplayStr("\r\n");

	memset(ttmmpp,NULL,20);
	SXPtr = GblSXTbl;
	AXPtr = GblAXTbl;
	DisplayStr("\r\n\r\nIndexes for addresses:");
	for (cnt=0; cnt < adrinxcnt; cnt++,AXPtr++) {
		chk_hlt();
		addr2str(AXPtr->addr,ttmmpp);
		sprintf(tbuf,"\r\n[addr] cnt= %X fpos= %-8lX addr= %s",AXPtr->cnt,AXPtr->fpos,ttmmpp);
		DisplayStr(tbuf);
	}

	DisplayStr("\r\n\r\nAddress entries in table:\r\n");
	for (i=0,cnt=0; i < totalsymcnt; i++) {
		chk_hlt();
		zptr = (struct inxfpos *) &astable[cnt];
		cnt += 6;
sprintf(tbuf,"%4d / %-8lX [%X %X %X %X]",zptr->inx,zptr->fpos,astable[cnt],astable[cnt+1],astable[cnt+2],astable[cnt+3]);
		DisplayStr(tbuf);
		cnt += env.Saddrunit;
		if ((i%2) == 1) DisplayStr("\r\n");
		else DisplayStr("       ");
	}
}
	
	DisplayStr("\r\n\r\nIndexes for global symbols:");
	for (cnt=0; cnt < gblinxcnt; cnt++,SXPtr++) {
		chk_hlt();
		sprintf(tbuf,"\r\n[gbl] cnt= %X fpos= %lX name= %s",SXPtr->cnt,SXPtr->fpos,SXPtr->name);
		DisplayStr(tbuf);
	}

	DisplayStr("\r\nindexes for each module: [Decimal]");
	for (i=0; i < modcnt; i++) {
		chk_hlt();
		CurModSAInx = ModInxHead + i;
		sprintf(tbuf,"\r\n[%d] cnt= %X sx= %lX ",i,CurModSAInx->cnt,CurModSAInx->sxptr);
		DisplayStr(tbuf);
		SXPtr = CurModSAInx->sxptr;
		for (cnt=0; cnt < CurModSAInx->cnt; cnt++,SXPtr++) {
			chk_hlt();
			sprintf(tbuf,"\r\n     [%d] cnt= %X fpos= %lX name= %s",cnt,SXPtr->cnt,SXPtr->fpos,SXPtr->name);
			DisplayStr(tbuf);
		}
	}
}
  end debug */

	free(modinxcnt);    
	CurModSAInx = ModInxHead;
	memset(&commod,NULL,sizeof(struct module));
	memcpy(&commod,&gblmod[0],sizeof(struct module));
	if(msgon == MSG_ON) {
		memset(tbuf,NULL,70);
		VPOut = COMVP;
		sprintf(tbuf,"\r\nSymbol table is loaded OK from file %s.",fnsy);
		DisplayStr(tbuf);
	}
	return(OK);
}

/**************************************************************************/
/***** NameToMod(name)                                              *******/
/**************************************************************************/

NameToMod(name)
char *name;
{
	int i,j,zz,act;

	if (neverswapmodule) act = modcnt;
	else {
		act = NO_MODULE;
		swap_module(0);
	}
	for (i=0; i < modcnt; i+=act)    {
		for (j=0; j < act; j++)   {
			if ((zz=strcmp(gblmod[j].mod_name,name)) == 0)   {
				memset(&commod,NULL,sizeof(struct module));
				memcpy(&commod,&gblmod[j],sizeof(struct module));
				return(FOUND);	
			}
		}  
		if (!neverswapmodule)  
			swap_module(gblmod[act-1].mod_inx+1);
	}   
	return(MISS);
}

/***************************************************************************/
/**** swap_module(finx)                                                *****/
/***************************************************************************/

swap_module(finx)
int finx;
{
	int i,j;

	if (finx == -1) return;
	if (commod.mod_inx == finx) return(OK);
	if (finx >= modcnt) return(OK);
	if (modcnt > NO_MODULE) i = NO_MODULE;
	else i = modcnt;
	if ((finx >= gblmod[0].mod_inx) && (finx <= gblmod[i-1].mod_inx)) {
		j = finx - gblmod[0].mod_inx;
		memset(&commod,NULL,sizeof(struct module));
		memcpy(&commod,&gblmod[j],sizeof(struct module));
		return(OK);
	}
	if ((j=modcnt-finx) >= NO_MODULE)  j = finx;
	else j = modcnt - NO_MODULE;
	for (i=0; i < NO_MODULE; i++, j++)  {
		lseek(fdsy,modpos[j],0);
		read(fdsy,(unsigned char *)&(gblmod[i]),sizeof(struct module));
	}  
	i = finx - gblmod[0].mod_inx;
	memset(&commod,NULL,sizeof(struct module));
	memcpy(&commod,&(gblmod[i]),sizeof(struct module));
	return(OK);
}

/**************************************************************************/
/***** SymToAddr()                                                  *******/
/**************************************************************************/

SymToAddr() 
{
	if ((comsym.mask & MSK_GBL) == MSK_GBL) {
		return(find_gblsym_byn());
	} else if ((comsym.mask & MSK_MOD) == MSK_MOD){
		return(find_mod_byn(comsym.modx));
	} else {
		if (find_gblsym_byn() == FOUND) return(FOUND);
		return(find_all_mod_byn());
	}
}

/**************************************************************************/
/***** find_gblsym_byn()                                               ****/
/**************************************************************************/

find_gblsym_byn()
{
	if (addinx > 0)  {
		if (find_addon_byn() == FOUND) return(FOUND);
	}
	if (gblsymcnt == 0) return(MISS);
	if (swap_symaddr(-1) == FAIL) return(MISS);
	return(find_symaddr()); 

}


/***************************************************************************/
/***** find_addon_byn()                                                *****/
/***************************************************************************/

find_addon_byn()
{
	int i;

	if (addinx == 0) return(MISS);
	for (i=0; i < addinx; i++) {
		if (strcmp(comsym.name,addtable[i].name) == 0)  {
			comsym.mask |= MSK_GBL;
			comsym.modx = -1;
			memcpy(comsym.addr,addtable[i].addr,env.Maddrunit);
			return(FOUND);
		}
	}
	return(MISS);
}

/***************************************************************************/
/***** find_all_mod_byn()                                             ******/
/***************************************************************************/

find_all_mod_byn()
{
	int i;

	for (i=0; i < modcnt; i++,CurModSAInx++) {
		if (CurModSAInx->cnt == 0) continue;
		if (CurModSAInx->cnt == -1) CurModSAInx = ModInxHead;
		if (swap_symaddr(0) == FAIL) continue;
		if (find_symaddr() == FOUND) return(FOUND);
	}
	return(MISS);
}

/************************************************************************/
/***** find_mod_byn(modinx) : for symbol listing                    *****/
/************************************************************************/

find_mod_byn(modinx)
int modinx;
{
	CurModSAInx = ModInxHead + modinx;
	if (CurModSAInx->cnt == 0) return(MISS);
	if (swap_symaddr(0) == FAIL) return(MISS);
	return(find_symaddr());
}

/**************************************************************************/
/***** swap_symaddr()                                                ******/
/**************************************************************************/

swap_symaddr(tt)
int tt;
{
	int i,a,cnt;

	if (tt == -1)  {
		cnt = gblinxcnt;
		SXPtr = GblSXTbl;
	} else {
		cnt = CurModSAInx->cnt;
		SXPtr = CurModSAInx->sxptr;
	}
	if (cnt == 0) return(FAIL);
	for (i=0; i < cnt; i++) {
		a = strcmp(comsym.name,(SXPtr+i)->name);
		if (a == 0) break;
		else if (a < 0) {
			i--;
			break;
		}
	}
	if (i == cnt) return(FAIL);
	else if (i < 0) return(FAIL);
	else if (i == cnt-1) i--;
	SXPtr += i;
	lseek(fdsy,SXPtr->fpos,0);
	read(fdsy,&satable[0],SXPtr->cnt*symreclen);
	return(OK);
}

/***************************************************************************/
/***** find_symaddr()                                                  *****/
/***************************************************************************/

find_symaddr()
{
	int i,j,k,a;
	char nn[42];

	for (i=0,k=0,InxInSatable=-1; k < SXPtr->cnt; k++) {
		j = (int) satable[i];
		memset(nn,NULL,42);
		memcpy(nn,&satable[i+1],j);
		if ((a=strcmp(comsym.name,nn)) == 0)  {
			InxInSatable = i;
			i += j + 1;
			memcpy(comsym.addr,&satable[i],env.Saddrunit);
			if (env.Maddrunit > env.Saddrunit)
				AddrAlign(comsym.addr,env.Saddrunit,env.Maddrunit,'E');
			else if (env.Maddrunit < env.Saddrunit)
				AddrAlign(comsym.addr,env.Saddrunit,env.Maddrunit,'S');
			return(FOUND);
		} else if (a < 0) break;
		i += j+env.Saddrunit+1;          
	}
	return(MISS);

}

/**************************************************************************/
/***** AddrToSym()                                                  *******/
/**************************************************************************/

AddrToSym(itemno)
int *itemno;
{
	int i,j,done=0,ret;
	unsigned char tar1[6];

	memcpy(saveaddr,comsym.addr,env.Maddrunit);
	memset(tar1,NULL,6);
	if (env.Maddrunit > env.Saddrunit)  
		AddrAlign(comsym.addr,env.Maddrunit,env.Saddrunit,'S');
	else if (env.Maddrunit < env.Saddrunit)
		AddrAlign(comsym.addr,env.Maddrunit,env.Saddrunit,'E');

   // 08/08/95 for Bugs
   // 08/08/95 , Change by Gates Hua , for PPR
AD2500:
   if ( ((env.Saddrunit==4)&&(env.Maddrunit==3)) ||
       ((env.Saddrunit==3)&&(env.Maddrunit==4)) ) {
   int ii, i, j, k, a;
   long count;
   char absad1[6], nn[42];

      if ( (env.Saddrunit==3)&&(env.Maddrunit==4) )
         memcpy(absad1, &comsym.addr[1], 3);
      else
         memcpy(absad1, comsym.addr, env.Saddrunit);
      for (ii=0; ii<modcnt; ii++) {
         swap_module(ii);
         CurModSAInx = ModInxHead + ii;
         if (CurModSAInx->cnt == 0) continue;
         SXPtr = CurModSAInx->sxptr;
         count = 0;
         lseek(fdsy, SXPtr->fpos,0);
read_sa: read(fdsy, &satable[0], SXPtr->cnt * symreclen);
      for (i = 0, k = 0; k < SXPtr->cnt; k++) {
         if ( (j = (int) satable[i]) > 40 || !j ) {
            i=-2;
            break;
         }
         memset(nn, NULL, 42);
         memcpy(nn, &satable[i+1], j);
         if ( (a=memcmp(absad1, &satable[i+j+1], env.Saddrunit)) == 0) {
            memset(comsym.name,0,40);
            sprintf(comsym.name, "%s", nn);
            return(1);
         }
         i += j + 1;
         i += env.Saddrunit ;
         count += j+1+env.Saddrunit;
      }
      if ( i != -2 ) {
         lseek(fdsy, SXPtr->fpos+count,0);
         goto read_sa;
      }
    } // end of module
   return(MISS);
   }  // end of AD2500

    *itemno = 0;
	if (addinx > 0) if (find_addon_bya() > 0) return(1);

	if (((comsym.mask & MSK_PHY) == MSK_PHY) && env.Sabsflag)   {
		(*absaddr)(comsym.addr,env.Saddrunit);
		memcpy(tar1,absad,env.Saddrunit);
	}
	else memcpy(tar1,comsym.addr,env.Saddrunit);

	if (totalsymcnt <= 0) return(MISS);
	if (memcmp(tar1,GblAXTbl[0].addr,env.Maddrunit) < 0) return(MISS);
	if ((i=memcmp(tar1,GblAXTbl[adrinxcnt-1].addr,env.Maddrunit)) > 0) return(MISS);
	else if (i == 0) AXPtr = &GblAXTbl[adrinxcnt-2];
	else {
		AXPtr = GblAXTbl;
		AddrIndexCompCnt = 0;
		AXPtr = (struct adrindex *) lfind((char *)tar1,(char *)GblAXTbl,&adrinxcnt,sizeof(struct adrindex),aIndexComp);
		if (AXPtr == NULL) return(MISS);
		else if (AXPtr != GblAXTbl) AXPtr = &(GblAXTbl[AddrIndexCompCnt-2]);
	}
	return(find_addrsym(itemno));
}

aIndexComp(s1,s2)
unsigned char *s1;
struct adrindex *s2;
{
	int i;
	AddrIndexCompCnt++;
	i = memcmp(s1,s2->addr,env.Maddrunit);
	if (i >= 0) return(1);
	else return(0);
}

/*****************************************************************************/
/***** find_addon_bya()                                                  *****/
/*****************************************************************************/

find_addon_bya()
{
	int i;
	unsigned char temp[6];
	struct addonitem *aptr;

	if (addinx == 0) return(MISS);
	if (((comsym.mask & MSK_PHY) == MSK_PHY) && env.Sabsflag)  {
		(*absaddr)(saveaddr,env.Maddrunit);
		memcpy(temp,absad,6);
	}
	else memcpy(temp,saveaddr,env.Maddrunit);
	memset(comsym.name,NULL,40);

	aptr = (struct addonitem *)lfind((char *)temp,(char *)addtable,&addinx,sizeof(struct addonitem),bComp);
	
	if (aptr == NULL) return(MISS);
	else {
		strcpy(comsym.name,aptr->name);
		comsym.modx = -1;
		comsym.mask != MSK_GBL;
		return(FOUND);
	}
}

bComp(s1,s2)
unsigned char *s1;
struct addonitem *s2;
{
	int i;

	if (env.Sabsflag)   (*absaddr)(s2->addr,env.Maddrunit);
	else    memcpy(absad,s2->addr,env.Maddrunit);
	i = memcmp(s1,absad,env.Maddrunit);
	if (i == 0) {
		if (!env.Sabsflag) return(0);
		else return(memcmp(saveaddr,s2->addr,env.Maddrunit));
	} else return(i);
}

/*****************************************************************************/
/***** find_addrsym(*ptr)                                                *****/
/*****************************************************************************/

find_addrsym(itemno)
int *itemno;
{
	unsigned char tar1[6],*sptr,*fptr;
	char tmpsym[symreclen],*cptr;
	struct inxfpos *iptr;
	int i;
        unsigned long ip;

	memset(tar1,NULL,6);
 	if (((comsym.mask & MSK_PHY) == MSK_PHY) && env.Sabsflag)   
		memcpy(tar1,absad,env.Saddrunit);
	else    memcpy(tar1,comsym.addr,env.Saddrunit);
	memset(comsym.name,NULL,40);
//      sptr = astable + adrreclen * (int)(AXPtr->fpos);
        InxInAstable=0;
        if ((ip = adrreclen * AXPtr->fpos) > 0xffff)
           sptr = (U8 *)((U32)astable + ((ip&0xffff0000L)<<3) + (U16)ip);
        else sptr = astable + ip;
	fptr=(unsigned char *) lfind(tar1,sptr,&(AXPtr->cnt),adrreclen,AddrComp);
	aentry = fptr;
	if (fptr == NULL) return(MISS);
 	if (((comsym.mask & MSK_PHY) == MSK_PHY) && env.Sabsflag)  {
		do {
			iptr = (struct inxfpos *)fptr;
			lseek(fdsy,iptr->fpos,0);
			read(fdsy,tmpsym,symreclen);
			if (memcmp(saveaddr,&tmpsym[(int)tmpsym[0]+1],env.Saddrunit) == 0) {
				memcpy(comsym.name,&tmpsym[1],(int)tmpsym[0]);
				aentry = fptr;
				memcpy(absad,tar1,6);
				return(1);
			}  else fptr += adrreclen;
		} while (memcmp(tar1,fptr+6,env.Saddrunit) == 0);
		return(MISS);
	} else {
		iptr = (struct inxfpos *)fptr;
		lseek(fdsy,iptr->fpos,0);
		read(fdsy,tmpsym,symreclen);
		memcpy(comsym.name,&tmpsym[1],(int)tmpsym[0]);
		return(1);
	}
}

AddrComp(s1,s2)
unsigned char *s1,*s2;
{
	InxInAstable++;
	return(memcmp(s1,s2+6,env.Saddrunit));
}

/***************************************************************************/
/***** AddrAlign(): shrink or extend the input address to the length  ******/
/*****              of symbol file or mice                            ******/
/***************************************************************************/

AddrAlign(addr,slen,elen,tag)
unsigned char *addr;
int slen,elen;
char tag;
{
	unsigned char temp[6];
	int i,j;

	memset(temp,NULL,6);
	memcpy(temp,addr,6);
	memset(addr,NULL,6);
	switch(tag) {
		case 'S':
			if (slen <= elen) break;
			if (env.Sabsflag) {
				if ((slen>6) || (elen<4))  break;
				memcpy(addr,temp,2);
				memcpy(&addr[2],&temp[slen-(elen-2)],elen-2);
			}
			else {
				if (slen-elen > 1) break;
				memcpy(addr,&temp[slen-elen],elen);
			}
			break;

		case 'E':
			if (slen >= elen) break;
			if (env.Sabsflag) {
				if ((slen!=4) && (elen!=6)) break;
				memcpy(addr,temp,2);
				memcpy(&addr[elen-(slen-2)],&temp[2],slen-2);
			}
			else {
				if (slen-elen > 1) break;
				memcpy(&addr[elen-slen],temp,slen);
			}
			break;
	}
	return(OK);
}

/*************************************************************************/
/***** absadh8(addr): calculate the absolute address for h8 cpu    *******/
/*************************************************************************/

absadh8(addr,unit)
unsigned char *addr;
int unit;
{
	memset(absad,NULL,6);
	memcpy(absad,addr,3);
	return;
}

/***************************************************************************/
/***** absad86(addr): calculate the absolute address for 86 series cpus ****/
/***************************************************************************/

absad86(addr,unit)
unsigned char *addr;
int unit;
{
	unsigned long cs,ip;
	
	cs = ip = 0L;
	cs = (unsigned long)addr[0];
	cs = (cs << 8) + addr[1];
	ip = (unsigned long)addr[2];
	ip = (ip << 8) + addr[3];
        if (unit == 6)  {	
		ip = (ip << 8) + addr[4];
		ip = (ip << 8) + addr[5];
	}
	cs = cs << 4;
	cs += ip;
	memset(absad,NULL,6);
	absad[0] = (unsigned char)(cs >> 24);
	absad[1] = (unsigned char)(cs >> 16);
	absad[2] = (unsigned char)(cs >> 8);
	absad[3] = (unsigned char)cs;
	return;
}

addr2str(s1,s2)
unsigned char *s1;
char *s2;
{
	extern char hhex[];
	int i,k;

	for (i=0,k=0; i < env.Maddrunit; i++,s1++) {
		s2[k++] = hhex[(((*s1) & 0xf0) >> 4)];
		s2[k++] = hhex[(*s1) & 0x0f];
/* h8 */	if (i == 0 && env.Mmodel == 40) s2[k++] = hhex[16];
		if (i == 1 && env.Sabsflag && env.Mmodel != 40) s2[k++] = hhex[16];
	}
}
