
/***************************************************************************
**
**    $Header:   D:/USD3V/LOG/SRC/ASSEMBLE.C__   1.2   12 Jun 1996 08:42:42   ZJRD  $
**
**    $Log:   D:/USD3V/LOG/SRC/ASSEMBLE.C__  $
** 
**    Rev 1.2   12 Jun 1996 08:42:42   ZJRD
** No change.
** 
**    Rev 1.1   24 May 1996 09:42:24   ZJRD
** No change.
** 
**    Rev 1.0   11 Dec 1995 13:51:46   ZJRD
** Initial revision.
** 
****************************************************************************/
/*--------------------------------------------------------------------------*/
/*  assemble.c								    */
/*--------------------------------------------------------------------------*/


#include  "system.h"
#include  "usd3.h"
#include  "gblext.h"
#include  "oldext.h"
#include  "usym1.h"
#include  "usym3.h"
#include  "funcext.h"

#define LABEL_WIDTH	50
#define TAB_OLD		-1
#define CR_OLD 		-2
#define TAB_NEW		-3
#define CR_NEW 		-4

int cbar_index, bbr_index, cbr_index, A_phy_index, IF_EXIST[3], save_addr;
long bbr, cbr, car, bar;
unsigned int cbar;
struct area{
	int  if_exist;
	char name;
	long base;
	long start;
	long end;
};
struct area AREA[3];
char curr_buf[COMBUFCOL+1], ORIGINAL[150], label[LABEL_WIDTH+1];
char upA_CMD[110];

int keyin_count;	/* i1 */
int line_width;		/* i2 */
int src_pos;		/* i3 */
int src_now, lab_now;
int current_pos;	/*  0: source field, 1: label field  */
char tmp_csip[16];
int a_cmdidx;
int first_TAB;
extern int APflag;

assemble_cmd()
{
	int r, i;
	char c1,tmpbuf[20];
	if(env.Mmodel == M_64180) {
		send_ESC();
		send_jump();
		set_area_64180();
		SEND_str_no_CR(CmdSendBuf);
	}
	d_putc(send_CR());
	comsym.mask = MSK_PHY;
	A_phy_index= env.mmu[0];

	CmdFileBuf[0] = a_cmdidx = 0;

/* 11-17-89 amy */
	memset(tmpbuf,NULL,20);
	memcpy(tmpbuf,CmdBuf,17);
	strlwr(tmpbuf);
	APflag = 0;
	if (strncmp(tmpbuf,"assemble physical",17) == 0) {
		if (env.Mmodel == 33 || env.Mmodel == 41) APflag = 1;
	}
/* amy */

	r = A_cmd();
	in_get_str2 = 0;
	if(r == ESC) send_ESC();
	return(TRUE);
}

A_cmd()
{
	char cmd_input_end=0,  c, c1, c2, *ptr, *ptr11, *ptr1,*ptr2;
	char ascii_adr[18];
	char sym_temp[32], *ptr_sym, old_tmp_csip[16], a_cmd0, a_cmd1;
	unsigned long temp, temp1;
	int i,j,k,r,ii,src_len,VPtmp,tmp_src_now,A_in_symbol,A_in_definebyte;
	char SpaceLine1[79];

	for ( i=0;i<=77;i++ ) SpaceLine1[i]=' ';
	SpaceLine1[78]='\0';

	src_pos = env.pos[6];
	line_width = VP[COMVP].Maxc - src_pos + 1;
	src_len = (env.Mmodel==MICE_3_BOUND || env.Mmodel==NEW_Z80)
		? 31 : (line_width+(env.Mmodel>MICE_3_BOUND)*VP[COMVP].Maxc-1);

A_NEXT_2:
	first_TAB = 1;
	lab_now = current_pos = 0;
	while(1) {
		c = chk_hlt();
		if(c == ESC) return(ESC);
		c = receive();
		if(c == HAND_SHAKE) break;
		a_d_putc(c);
		if(c == '>') {
			receive();
			cmd_input_end = 1;
			break;
		}
	}
	if(!cmd_input_end) {
		ptr = (char *) MICEBuf;
		ptr11 = ORIGINAL;
		keyin_count = label[0] = ORIGINAL[0] = save_addr = A_in_symbol = A_in_definebyte = 0;
		get_label_addr(ascii_adr);
		in_get_str2 = 1;
		a_DisplayCMDCURSOR();
		while(1) {
			c = a_getc_mpds();
COM:
			if(c == ESC) {
				in_get_str2 = 0;
				if(cmd_flag) {
					logb('\\');
					logb(CR);
					logb(LF);
				}
				a_d_putc('\\');
				a_EraseCMDCURSOR();
				send(ESC);
				while((c1=receive()) != HAND_SHAKE) a_d_putc(c1);
				return(0);
			} else if(c == BS) {
				if(ptr!=MICEBuf) {
					ptr--;
					ptr11--;
					keyin_count--;
					if(keyin_count < line_width)
						A_DisplayCharAndShowCursor(BS);
					A_in_symbol = *ptr;
					if(*ptr11 == DEFINE_BYTE) A_in_definebyte = 1 - A_in_definebyte;
				}
				continue;
			} else if(c == NAME) {
				if(!A_in_definebyte) A_in_symbol++;
				*ptr++ = 0;
				*ptr11++ = c;
				keyin_count++;
				A_DisplayCharAndShowCursor(c);
			} else if(c == DEFINE_BYTE && !A_in_symbol) {
				A_in_definebyte = 1 - A_in_definebyte;
				*ptr++ = 0;
				*ptr11++ = c;
				keyin_count++;
				A_DisplayCharAndShowCursor(c);
			} else if(c == TAB && !APflag) {
				*ptr = '\0';
				*ptr11 = '\0';
				A_DisplayCharAndShowCursor(TAB);
				if(!save_addr) conv_addr(ascii_adr);
				c = get_sym();
				if(c == ESC) return(ESC);
				A_DisplayCharAndShowCursor(TAB);
				if(c==TAB_NEW || c==CR_NEW) {
					comsym.mask = MSK_PHY;
					strcpy(comsym.name,label);
					if(insert_symbol(MSG_OFF) == FAIL) {
						tmp_src_now = VP[COMVP].Ptr->c;
						JournalCh(CR);
						JournalStr(SpaceLine);
						JournalCh(CR);
						JournalStr(label);
						JournalStr("\n\r");
						JournalStr(curr_buf);
						prn_ferr(46);
						first_TAB = 1;
						lab_now = current_pos = label[0] = 0;
						a_d_prntf("\r\n");
						a_d_prntf(curr_buf);
						a_d_prntf( ORIGINAL);
						VP[COMVP].Ptr->c = tmp_src_now;
						a_DisplayCMDCURSOR();
					} else sym_flag = save_addr = 1;
				}
			} else if(c>=0x20 && c<=0x7e || c==CR) {
to_MICE:
				if((ptr-MICEBuf) > src_len) c = CR;
				if(!isalnum(c) && c!='_') A_in_symbol = 0;
				*ptr++ = A_in_symbol;
				if(!A_in_symbol && !A_in_definebyte) c = USDtoupper(c);
				*ptr11++ = c;
				keyin_count++;
				if(c == CR) {
/* 4-13-87 sym2adr() in 'A' cmd, it's different between MOV, JMP with segment */
					*ptr11++='\0'; /* --- by Charles --- */
					A_in_definebyte = 0;
					A_CMD0(ORIGINAL,&a_cmd0,&a_cmd1);
					/*if(a_cmd0 != CR) --- by Charles --- */{
						in_get_str2 = 0;
						if(label[0]) {
							if(cmd_flag) {
								logb(NAME);
								LogOneCmdLine(label);
							}
							JournalCh(CR);
							JournalStr(SpaceLine1);
							JournalCh(CR);
							JournalStr(label);
							JournalCh(':');
							JournalStr("\n\r");
							JournalStr(curr_buf);
						}
					       	JournalStr(ORIGINAL);
						if(a_cmd0 != CR) {
							a_EraseCMDCURSOR();
							a_d_putc(CR);
						}
						ptr = ORIGINAL - 1;
						ptr1= upA_CMD - 1;
						do {
							c1 = *++ptr;
							if(c1 == LF) {
								ptr += src_pos;
								c1 = *ptr;
							}
							if(cmd_flag) logb(c1);
							if(c1 == NAME && !A_in_definebyte) {
								ptr_sym = sym_temp - 1;
								do {
									c2 = *++ptr;
									if(c2 == LF) {
										ptr += src_pos;
										c2 = *ptr;
									}
									if(cmd_flag) logb(c2);
									*++ptr_sym = c2;
								} while(c2!=','&&c2!=']'&&c2!=')'&&c2!='['&&c2!='('&&c2!=CR) ;
								*ptr_sym = '\0';
								r = A_sym2adr(sym_temp,comsym.addr);
								if(r == FOUND) {
									j=env.Maddrunit;
									if(env.Maddrid == I8086 || env.Maddrid == M_3_386) {
if(a_cmd0=='J'||(a_cmd0=='C'&&a_cmd1=='A')||(a_cmd0=='B'&&a_cmd1=='R')) {
											ptr2 = tmp_csip - 1;
											for(i=0 ; i<j ; i++) {
												*++ptr2 = hex[(comsym.addr[i]>>4)&0xf];
												*++ptr2 = hex[comsym.addr[i]&0xf];
/* amy */
												if (env.Mmodel==40 && i==0) *++ptr2=':';
												else if(i == 1) *++ptr2 = ':';
											}
											for(i=0 ; i<4 ; i++) {
												if(tmp_csip[i] != curr_buf[i])
													break;
											}
/* skip the same segment */								ii = (i == 4) ? 5 : 0;
											for(i=ii ; i<env.Mcsiplen ; i++)
												*++ptr1 = tmp_csip[i];
										} else {
/* 10-5-87 combine segment & offset to physical address except "JMP" ("BR" for V25), "CALL" */
											i = 2 + (env.Maddrid==M_3_386) * 2;
											temp=comsym.addr[0];
											temp=(temp << 8)+comsym.addr[1];
											temp1=comsym.addr[i];
											temp1=(temp1<<8)+comsym.addr[i+1];
											temp=(temp << 4) + temp1;
											for(i=0,k=12 ; i<4 ; i++,k-=4)
												*++ptr1 = hex[(temp>>k) & 0xf];
										}
									} else {
										for(i=0 ; i<j ; i++) {
											*++ptr1 = hex[(comsym.addr[i]>>4)&0xf];
											*++ptr1 = hex[comsym.addr[i]&0xf];
										}
									}
									*++ptr1 = c2;
									if(c2 == CR) break;
								} else if(r == ESC) {
									if(cmd_flag) {
										logb('\\');
										logb(CR);
										logb(LF);
									}
									send(ESC);
									while((c1=receive()) != HAND_SHAKE) a_d_putc(c1);
									return(ESC);
								} else {
									if(cmd_flag) logb(LF);
r_MICE2:
									prn_ferr(r);
									send(CR); /* for current address re_display! */
									goto A_NEXT_2;
								}
							} else {
								*++ptr1 = (A_in_definebyte) ? c1 : USDtoupper(c1);
								if(c1 == DEFINE_BYTE)
									A_in_definebyte = 1 - A_in_definebyte;
							}
						} while(c1 != CR) ;
						if(cmd_flag) logb(LF);
						ptr2 = upA_CMD - 1;
						if(r_in_define_byte(upA_CMD) == 1) {
							r = 44;
							goto r_MICE2;
						}
						while((c1=*++ptr2) != CR) {
							send(c1);
							while(receive() != c1) ;
						}
						send(CR);
						break;
					}/* else {
						ptr = (char *) MICEBuf;
						ptr11 = ORIGINAL;
						A_in_symbol = A_in_definebyte = keyin_count = 0;
					} --- by Charles --- */
				} else A_DisplayCharAndShowCursor(c);
			} else if ( c==LF ) {
				  send(LF);
				  break;
			}
		} /* end of while */
		goto A_NEXT_2;
	}
	return(0);
}

A_CMD0(ptr,pacmd0,pacmd1)
char *ptr, *pacmd0, *pacmd1;
{
	char c;
	while((c=*ptr++) == SP) ;
	*pacmd0 = USDtoupper(c);
	*pacmd1 = USDtoupper(*ptr);
}

/* get label address and if any new-symbol hit, display its name */
get_label_addr(p_ascii_adr)
char *p_ascii_adr;
{
	if(save_addr==1 && MICEBuf[0]==CR && (env.Mmodel>MICE_3_BOUND && env.Mmodel!=NEW_Z80)) return;

	if ( VP[COMVP].Ptr->r > (COMBUFROW-1) ) {

	   VP[COMVP].Ptr->r -= 1;
           v_stcpy( curr_buf, FROM_WN, ROW, VP[COMVP].Ptr );
	   VP[COMVP].Ptr->r += 1;

	} else  v_stcpy( curr_buf, FROM_WN, ROW, VP[COMVP].Ptr );

	curr_buf[src_pos] = '\0';
	strncpy(p_ascii_adr,&(curr_buf[env.mmu[0]]),env.Mcsiplen);
}

conv_addr(ptr)
char *ptr;
{
	char k1, k2;
	int i;
	if(env.Mmodel==I_8048||env.Mmodel==I_8050||env.Mmodel==M_64180||env.Mmodel==M_68008) {
		for(i=0 ; i<env.Maddrunit ; i++,ptr++) {
			k1 = *ptr;
			k2 = *++ptr;
			if(i == 0) {
				k2 = k1;
				k1 = '0';
				ptr--;
			}
			if(isdigit(k1)) k1 -= '0';
			else k1 = k1 - 'A' + 10;
			if(isdigit(k2)) k2 -= '0';
			else k2 = k2 - 'A' + 10;
			comsym.addr[i] = (k1<<4) + k2;
		}
	} else {
		for(i=0 ; i<env.Maddrunit ; i++,ptr++) {
/* amy */
			if(env.Mmodel!=40 &&
			  (env.Maddrid==I8086 || env.Maddrid==M_3_386) &&
			  i==2) ptr++;
			else if (env.Mmodel==40 && i==1) ptr++;
			k1 = asc__h(*ptr);
			k2 = asc__h(*++ptr);
			comsym.addr[i] = (k1<<4) + k2;
		}
	}
}

a_getc_mpds()
{
	char c;
	if(cmdfile_flag) {
			if((c=CmdFileBuf[a_cmdidx++]) == NULL) {
				if(cmd_file(-1) != END) {
					c = CmdFileBuf[0];
					a_cmdidx = 1;
					return(c);
				} else end_cmd_file();
			} else return(c);
	}
	disableRS232();
	c = get_key();
	enableRS232();
	return(c);
}

/******* return value:
       ESC:      terminate A_cmd
       TAB_OLD:  source field, label field toggle only
       CR_OLD :  no label modified, CR pressed
       TAB_NEW:  source field, label field toggle, label modified
       CR_NEW :  source field, label field toggle, label modified, CR pressed
*******/
get_sym()
{
	char bbb[80], c;
	int VPtmp;
	int i, j=0;
/* for ^B log to indicate a label creation here */
	while((c=label[j++])!=SP && c) ;
	j--;
	i = j;
	a_DisplayCMDCURSOR();
	while(1) {
		c = a_getc_mpds();
		switch(c) {
			case BS :
				if(i > 0) {
					A_DisplayCharAndShowCursor(BS);
					i--;
				}
				break;
			case ESC:
			case TAB:
			case CR:
RET:
				a_EraseCMDCURSOR();
				label[i] = '\0';
				if(i != j && i) {
					if(c == CR) c = CR_NEW;
					else if(c == TAB) c = TAB_NEW;
				} else {
					if(c == CR) c = CR_OLD;
					else if(c == TAB) c = TAB_OLD;
				}
				if(i > 0) {
					if(c != ESC) A_DisplayCharAndShowCursor(':');
					else a_d_putc_no_journal(':');
				}
				return(c);
			default :
				if(isalnum(c) || c=='_' && i<LABEL_WIDTH) {
					label[i++] = c;
					A_DisplayCharAndShowCursor(c);
				}
		}
	}
}

A_sym2adr(sym,addr)
char *sym;
int *addr;
{
	int r;
	r = sym2adr(sym,addr);
	if(r == FOUND) r = phy_log_64180();
	else r = 19;
	return(r);
}

phy_log_64180()
{
	unsigned long aaddrr;
	int i, j, r=FOUND;
	if(env.Mmodel == M_64180) {
		aaddrr = comsym.addr[0];
		aaddrr = (aaddrr<<16) + (comsym.addr[1]<<8) + comsym.addr[2];
		for(i=0 ; i<3 ; i++) {
			if(AREA[i].if_exist && AREA[i].start<=aaddrr && AREA[i].end>=aaddrr)
				break;
		}
		if(i >= 3) r = 36;
		else {
			aaddrr -= AREA[i].base;
			for(i=2,j=0 ; i>=0 ; i--,j+=8)
				comsym.addr[i] = aaddrr >> j & 0xff;
		}
	}
	return(r);
}

send_jump()
{
	do_1_cmd_save("JUMP ?",MICEBuf,80);
	cbar_index = env.mmu[2];
	bbr_index  = env.mmu[3];
	cbr_index  = env.mmu[4];
	get_MMU();
}

/***
	IF_EXIST[0], IF_EXIST[1], IF_EXIST[2]
	COMMON 0,    COMMON 1,    BANK AREA
****/
get_MMU()
{
	cbar = asc2hex(MICEBuf[cbar_index],MICEBuf[cbar_index+1]);
	car = ((cbar & 0xf0) >> 4) << 12;
	bar = (cbar & 0xf) << 12;
	if(car == 0) {
		IF_EXIST[0] = IF_EXIST[2] = 0;
		IF_EXIST[1] = 1;
	} else if(bar == 0) {
		IF_EXIST[1] = IF_EXIST[2] = 1;
		IF_EXIST[0] = 0;
	} else {
		IF_EXIST[0] = IF_EXIST[1] = IF_EXIST[2] = 1;
	}
	bbr  = asc2hex(MICEBuf[bbr_index],MICEBuf[bbr_index+1]);
	cbr  = asc2hex(MICEBuf[cbr_index],MICEBuf[cbr_index+1]);
	bbr <<= 12;
	cbr <<= 12;
}

/******
>Jump ?
01234567890123456789012345678901234567890123456789
 CBAR= F0     BBR= 00     CBR= 00     PC= 0000
>BASe
 First  priority base : Common area 0
01234567890123456789012345678901234567890123456789
 Second priority base : Bank area
*****/

set_area_64180()
{
	char *ptr1, *ptr2;
	int i;
	do_1_cmd_save("BASE",MICEBuf,160);
	ptr1 = index(MICEBuf,':');
	if(ptr1) {
		AREA[0].name = *(ptr1 + 2);
		if(AREA[0].name == 'C') AREA[0].name = *(ptr1 + 14);
		ptr2 = index(ptr1+1,':');
		if(ptr2) {
			AREA[1].name = *(ptr2 + 2);
			if(AREA[1].name == 'C') AREA[1].name = *(ptr2 + 14);
			AREA[2].name=('0'+'1'+'B')- AREA[0].name - AREA[1].name;
		}
		for(i=0 ; i<3 ; i++) {
			switch(AREA[i].name) {
				case '0':
					AREA[i].if_exist = IF_EXIST[0];
					AREA[i].base = 0;
					AREA[i].start= 0;
					AREA[i].end  = bar - 1;
					break;
				case '1':
					AREA[i].if_exist = IF_EXIST[1];
					AREA[i].base = cbr;
					AREA[i].start= car + cbr;
					AREA[i].end  = 0xffff + cbr;
					break;
				case 'B':
					AREA[i].if_exist = IF_EXIST[2];
					AREA[i].base = bbr;
					AREA[i].start= bar + bbr;
					AREA[i].end  = car - 1 + bbr;
			}
		}
	}
}

A_DisplayCharAndShowCursor(c)
{
	a_EraseCMDCURSOR();
	a_d_putc_no_journal(c);
	a_DisplayCMDCURSOR();
}

a_d_putc(Ch)
{
	JournalCh(Ch);
	a_d_putc_no_journal(Ch);
}

a_d_putc_no_journal(Ch)
char  Ch;
{
	disableRS232();
	switch ( Ch ) {
		case  BS  :
		case  DEL :
		case  KEY_DEL :
			if ( VP[COMVP].Ptr->c != 0 ) {

			   VP[COMVP].Ptr->c -= 1;
			   v_ch( ' ', VP[VPOut].Ptr );
			   VP[COMVP].Ptr->c -= 1;
			}
			break;
		case  TAB : 
			if(first_TAB) {
				VPOut = COMVP;
				a_d_putc_no_journal( (char) CR );
				v_stcpy( SpaceLine, TO_WN, ENDROW, VP[VPOut].Ptr );
				a_d_prntf_no_journal( "\r\n" );
				a_d_prntf_no_journal( curr_buf );
				a_d_prntf_no_journal( ORIGINAL );
				first_TAB = 0;
			}
			if ( current_pos == 0 ) {
				src_now = VP[COMVP].Ptr->c;
				VP[COMVP].Ptr->c=lab_now-((label[0]!=0)?1:0);
				--VP[COMVP].Ptr->r;
				current_pos = 1;
			} else {
				lab_now = VP[COMVP].Ptr->c;
				VP[COMVP].Ptr->c = src_now;
				++VP[COMVP].Ptr->r;
				current_pos = 0;
			}
			break;
		case  CR  :
			VP[COMVP].Ptr->c = 0;
			break;
		case  LF  :
			v_st( "\n ", VP[COMVP].Ptr );
			VP[COMVP].Ptr->c = 0;
			break;
		default   :
			if ( ( Ch < SP ) || ( Ch >= DEL ) ) break;
			if ( VP[COMVP].Ptr->c <= (COMBUFCOL-1) )
			   v_ch( Ch, VP[COMVP].Ptr );
			break;
	}
	enableRS232();
}

a_d_prntf(str)
char *str;
{
	char c;
	while(c = *str++) a_d_putc(c);
}

a_d_prntf_no_journal(str)
char *str;
{
	char c;
	while(c = *str++) a_d_putc_no_journal(c);
}

a_DisplayCMDCURSOR()
{
 csr_plwn( VP[COMVP].Ptr );
}

a_EraseCMDCURSOR()
{
}
