
/***************************************************************************
**
**    $Header:   D:/USD3V/LOG/SRC/COVER.C__   1.2   12 Jun 1996 08:42:44   ZJRD  $
**
**    $Log:   D:/USD3V/LOG/SRC/COVER.C__  $
** 
**    Rev 1.2   12 Jun 1996 08:42:44   ZJRD
** No change.
** 
**    Rev 1.1   24 May 1996 09:41:42   ZJRD
** No change.
** 
**    Rev 1.0   11 Dec 1995 13:51:32   ZJRD
** Initial revision.
** 
****************************************************************************/
#include        "system.h"
#include	"menu.h"
#include	"usd3.h"
#include	"gblext.h"
#include	"oldext.h"
#include	"usym1.h"
#include	"usym3.h"
#include        "dialog.h"
#include	"funcdecl.h"
#include	"funcext.h"
#include	"cover.h"

// The following settings for color and mono modes will overwrite those
// from VVD and the other dialog boxes.
// So, these settings determine the colors in SPACoverage dialog.

UCHAR ddcc[3] = { catt_def(0xe,0x1),		// LFORMS     yellow on blue
		  catt_def(0x1,0xe),		// LFLDACTON  blue on yellow
		  catt_def(0xe,0x3) };          // LFLDACTOFF yellow on cyan
	  
UCHAR ddmm[3]  = { NORMAL|HIGH_INT,		// LFORMS
		   REVERSE,			// LFLDACTON
		   UNDERLINE };			// LFLDACTOFF

UCHAR EV7OldSetting[30];

extern UCHAR DlgColorLATT[];

SPACover()
{
	extern int have_mouse_driver;
	int i,have_mouse_driver_save;
	unsigned char *coverage_buf;
	CO *datap;
	DFIELDPTR fldptr;
	WINDOWPTR msgwnp;
	MEMOPTR mptr;
	KEYFP clist_f10_fp, pgup_temp, pgdn_temp;

	have_mouse_driver_save = have_mouse_driver;
	HideCursor();
	have_mouse_driver = 0;

	coverage_buf = MICEBuf;
	data_in_cover_buf = 0;
	VV_ERR = 0;
	datap = &co;
	cco = (struct coco *) &co;

	if (env.Mmodel == 39)  DlgFmPtr = dl_fmget("SPACoverageC186",datap,usd3dlg,CListMFilePtr,VVDLibp);
	else                   DlgFmPtr = dl_fmget("SPACoverage",datap,usd3dlg,CListMFilePtr,VVDLibp);
 	if (DlgFmPtr == NULLP)	return(EXITMENU);
	sw_updnfp(wn_expset,wn_expunset,DlgFmPtr->wnp);

	kt_rplkey( KEY_F7,  KeyF7Clear, FMKTP );
	kt_rplkey( KEY_F8,  KeyF8Reset, FMKTP );
	kt_rplkey( KEY_F9,  KeyF9List,  FMKTP );
	kt_rplkey( KEY_F10, KeyF10Exec, FMKTP );
	kt_rplkey( KEY_F7,  KeyF7Clear, TTMEMOKTP );
	kt_rplkey( KEY_F8,  KeyF8Reset, TTMEMOKTP );
	kt_rplkey( KEY_F9,  KeyF9List,  TTMEMOKTP );
	kt_rplkey( KEY_F10, KeyF10Exec, TTMEMOKTP );
	kt_rplkey( KEY_SPACE,  CoverClistSP, CLKTP );
	kt_rplkey( KEY_F7,  CoverClistF7, CLKTP );
	kt_rplkey( KEY_ESC, k_quit, CLKTP );
	pgup_temp = kt_rplkey( KEY_PGUP, SpaClstCtlPgUp, CLKTP );
	pgdn_temp = kt_rplkey( KEY_PGDN, SpaClstCtlPgDn, CLKTP );

	if (vid_getmode() == MONO)
		memcpy((DlgFmPtr->wnp->lattarray+26),ddmm,3);
	else    memcpy((DlgFmPtr->wnp->lattarray+26),ddcc,3);

	spa_cover_mess_wn1 = wn_def(22, 0, 3, 80, LMESSAGE, &spa_cover_lower_bdr);
	sw_opt( POPUP, ON, spa_cover_mess_wn1);
	wn_up(spa_cover_mess_wn1);
	ShowMessWn(spa_cover_mess1, spa_cover_mess2, 6);
	list_mfp = mf_def(100, 25);
	mf_rd("usd3clst.txt", list_mfp);
	clistp = cl_def(1, 0, 22, 25, &spa_cover_upper_left_bdr, "*SPA_COVER", list_mfp);
	scl_help("*SPACoverageClist", clistp);
	SetWnAtt(clistp->wnp, LMESSAGE, LMESSAGE, spa_cover_list_title, LMESSAGE, TOPCENTER);
	clistp->act_att = LBLA_WHI;
	DlgFmPtr->wnp->bdrp = (BORDERPTR) &spa_cover_upper_bdr;
	SetDataFromMice(coverage_buf);
	fm_up(DlgFmPtr);
	do {
		CodeCoverBranchFlag = 0;
		retcode = fm_rd(0,DlgFmPtr);
		switch (retcode) {
			case AC_QUIT:
				break;
			case AC_EXIT:
				switch (CodeCoverBranchFlag) {
					case F7_CLEAR:
						CodeCoverF7Clear();
						break;
					case F8_RESET:
						CodeCoverF8Reset();
						break;
					case F9_LIST:
						if (data_in_cover_buf==1) 
							CodeCoverF9List(coverage_buf);
						else ShowExecMess(spa_cover_mess5[5]);
						break;
					case F10_EXEC:
						if (CheckAllRangeClr())	{
							ShowExecMess(spa_cover_mess5[2]);
							break;
						}
						CodeCoverF10Exec(coverage_buf);
						if (data_in_cover_buf==1) 
							CodeCoverF9List(coverage_buf);
						else ShowExecMess(spa_cover_mess5[5]);
						break;
				}
		}
		fm_upd(DlgFmPtr);
		ShowMessWn(spa_cover_mess1, spa_cover_mess2, 6);
	} while (retcode == AC_EXIT);
	if (retcode == AC_QUIT) {
		fm_dn(DlgFmPtr);
		fm_free(DlgFmPtr);
	}
	wn_dn(spa_cover_mess_wn1);
	wn_free(spa_cover_mess_wn1);
	cl_free(clistp);
	mf_free(list_mfp);
	kt_rplkey( KEY_F7,    NULLFP, CLKTP );
	kt_rplkey( KEY_SPACE, NULLFP, CLKTP );
	kt_rplkey( KEY_ESC, ClistQuit, CLKTP );
	kt_rplkey( KEY_PGUP, pgup_temp, CLKTP );
	kt_rplkey( KEY_PGDN, pgdn_temp, CLKTP );
	if (init_status_for_cover == 1)
		do_1_cmd_save("INI ENABLE",MICEBuf,(MICEBUFSIZE+1));
	else if ( (init_status_for_cover == 0) && (data_in_cover_buf==0) )
		do_1_cmd_save("COV DISABLE",MICEBuf,(MICEBUFSIZE+1));

	have_mouse_driver = have_mouse_driver_save;
	ShowCursor();

	return( EXITMENU );
}

KeyF7Clear(dummyptr)
KEYCTRLPTR  dummyptr;
{
	CodeCoverBranchFlag = F7_CLEAR;
	k_exit((KEYCTRLPTR)DlgFmPtr);
	return(1);
}

KeyF8Reset(dummyptr)
KEYCTRLPTR  dummyptr;
{
	CodeCoverBranchFlag = F8_RESET;
	k_exit((KEYCTRLPTR)DlgFmPtr);
	return(1);
}

KeyF9List(dummyptr)
KEYCTRLPTR  dummyptr;
{
	CodeCoverBranchFlag = F9_LIST;
	k_exit((KEYCTRLPTR)DlgFmPtr);
	return(1);
}

KeyF10Exec(dummyptr)
KEYCTRLPTR  dummyptr;
{
	CodeCoverBranchFlag = F10_EXEC;
	k_exit((KEYCTRLPTR)DlgFmPtr);
	return(1);
}

CodeCoverF7Clear()
{
	unsigned char com[32];
	int i,j;

	memset(&co,NULL,sizeof(co));
	strcpy(com, "COV CLEAR");
	SendCommend(com);
	while (receive() != HAND_SHAKE);
}

CodeCoverF8Reset()
{
	unsigned char com[32];

	strcpy(com, "COV RESET");
	SendCommend(com);
	while (receive() != HAND_SHAKE);
}

CodeCoverF9List(coverage_buf)
unsigned char *coverage_buf;
{
	int retcode, choiceno=0, assembly_or_dump = 0;
	int i, j, kk, to_execute;
	unsigned char ad_start[14], ad_end[14], *buf_ptr;

	max_cl_item = mf_rowq(list_mfp);
	spa_cover_clist = 1;
	InitCoverF9Wn();
	buf_ptr = &coverage_buf[REC_BUF_ADD_BGN+choiceno*2*cover_addr_len];
	for (j=0; j<cover_addr_len; j++) {
		cover_addr_argv[j] = buf_ptr[j];
		cover_addr_argv[j+cover_addr_len+1] = buf_ptr[j+cover_addr_len];
		end_addr_of_range_accessed[j] = buf_ptr[j+cover_addr_len];
	}
	cover_addr_argv[cover_addr_len] = ' ';
	cover_addr_argv[2*cover_addr_len+1] = '\0';
	end_addr_of_range_accessed[cover_addr_len] = '\0';
	if (env.Mmodel == 39) {
		InsertStrIntoStr(cover_addr_argv, "000:", 0);
		InsertStrIntoStr(cover_addr_argv, "000:", 10);
		InsertStrIntoStr(end_addr_of_range_accessed, "000:", 0);
	}
	SpaClistCR();
	spa_cover_toggle_status = 0;
	do {
		ShowMessWn(spa_cover_mess3, spa_cover_mess4, 6);
		retcode = SpaCoverClProc(choiceno, clistp);
		choiceno = cl_curnum(clistp);
		buf_ptr = &coverage_buf[REC_BUF_ADD_BGN+choiceno*2*cover_addr_len];
		for (j=0; j<cover_addr_len; j++) {
			cover_addr_argv[j] = buf_ptr[j];
			cover_addr_argv[j+cover_addr_len+1] = buf_ptr[j+cover_addr_len];
			end_addr_of_range_accessed[j] = buf_ptr[j+cover_addr_len];
		}
		cover_addr_argv[cover_addr_len] = ' ';
		cover_addr_argv[2*cover_addr_len+1] = '\0';
		end_addr_of_range_accessed[cover_addr_len] = '\0';
		if (env.Mmodel == 39) {
			InsertStrIntoStr(cover_addr_argv, "000:", 0);
			InsertStrIntoStr(cover_addr_argv, "000:", 10);
			InsertStrIntoStr(end_addr_of_range_accessed, "000:", 0);
		}
		if (retcode == AC_EXIT) {
			SpaClistCR();
			spa_cover_toggle_status = 0;
		}
	} while (retcode != AC_QUIT);
	spa_cover_clist = 0;
	CloseCoverF9Wn();
}

CodeCoverF10Exec(coverage_buf)
unsigned char *coverage_buf;
{
	int i, j, coverage_buf_count, clist_item_rowq, rec_count=0;
	char mem_type[15], command[32];
	unsigned char temp, ad_start[14], ad_end[14], clist_item[30], temp_str[80], sym_hex_conv[20], sym_hex_conv1[20];

        SaveEv7Old(EV7OldSetting);
	SendCommend("COV CLEAR");
	while (receive() != HAND_SHAKE);
	SendCommend("EV 7 CLEAR");
	while (receive() != HAND_SHAKE);
	mem_type[0] = '\0';
	if (env.Mmodel == 39) {
		if (cco->f0 == TRUE) strcat(mem_type, "I ");
		if (cco->f1 == TRUE) strcat(mem_type, "O ");
		if (cco->f2 == TRUE) strcat(mem_type, "S ");
		if (cco->f3 == TRUE) strcat(mem_type, "R ");
		if (cco->f4 == TRUE) strcat(mem_type, "W ");
	} else {
		if (cco->f0 == TRUE) strcat(mem_type, "SP ");
		if (cco->f1 == TRUE) strcat(mem_type, "SD ");
		if (cco->f2 == TRUE) strcat(mem_type, "UP ");
		if (cco->f3 == TRUE) strcat(mem_type, "UD ");
	}
	SpaCoverSetMemType(mem_type);
	for (i=0; i<16; i++) {
		if (cco->br[i].op == TRUE) {
			if ( ( SpaCoverSymToAddr(cco->br[i].start, sym_hex_conv, 1) != FOUND ) ||
			     ( SpaCoverSymToAddr(cco->br[i].end, sym_hex_conv1, 1) != FOUND ) )
				return;
			SpaCoverSetRange(sym_hex_conv, sym_hex_conv1);
		}/* else if (cco->br[i].op == FALSE) {
			RemoveSpaceInStr(cco->br[i].start);
			RemoveSpaceInStr(cco->br[i].end);
			if ( (strlen(cco->br[i].start)!=0) && (strlen(cco->br[i].end)!=0) ) {
				if ( ( SpaCoverSymToAddr(cco->br[i].start, sym_hex_conv) != FOUND ) ||
				     ( SpaCoverSymToAddr(cco->br[i].end, sym_hex_conv1) != FOUND ) )
					return;
				SpaCoverClearRange(cco->br[i].start, cco->br[i].end);
			}
		}*/
	}
	if ( SpaCoverSymToAddr(cco->end, sym_hex_conv, 0) != FOUND )  return;
	SetBreakPoint(sym_hex_conv);
	if ( SpaCoverSymToAddr(cco->start, sym_hex_conv, 0) != FOUND )  return;
	strcpy(command, "GO ");
	strcat(command, sym_hex_conv);
	v_printf( spa_cover_mess_wn1, "\n %s", spa_cover_mess5[1]);
	SendCommend(command);
	i=0;
	do {
		temp = receive();
		if ( (temp >= 0x20) && (temp <= 0x7f) ) {
			temp_str[i] = (unsigned char) temp;
			i++;
		} else if (temp == 0x0d) {
			temp_str[i] = '\n';
			temp_str[i+1] = 0;
			if ( (strstr(temp_str, "halt") != NULL) ||
			     (strstr(temp_str, "can't step") != NULL) )
			{
				send(KEY_ESC);
				while (receive() != HAND_SHAKE);
				ShowExecMess(spa_cover_mess5[0]);
				DoCoverageusdCmd(coverage_buf);
				return;
			}
			i = 0;
		}
	} while (temp != HAND_SHAKE);
	SendCommend("COVERAGEUSD ");
	do {
		temp = receive();
	} while (temp != KEY_ENTER);
	coverage_buf_count = 0;
	do {
		temp = receive();
		if ( ( (temp<=90) && (temp>=65) ) || ( (temp<=57) && (temp>=48) ) ) {
			coverage_buf[coverage_buf_count] = temp;
			coverage_buf_count++;
		}
		if (rec_count==2047) {
			send(KEY_ESC);
			while (receive() != HAND_SHAKE);
			break;
		}
	} while (temp != HAND_SHAKE);
	sscanf(coverage_buf, "%2x%2x%2x", &percent_of_coverage1, &percent_of_coverage2, &cover_addr_len);
	cover_num_of_block_access = (coverage_buf_count - REC_BUF_ADD_BGN)/(cover_addr_len*2);
	if (cover_num_of_block_access == 0) data_in_cover_buf=0;
	else data_in_cover_buf=1;
	clist_item_rowq = mf_rowq(list_mfp);
	for (i=1; i<clist_item_rowq; i++) mf_rowdel(1, list_mfp);
	for (i=0, coverage_buf_count=REC_BUF_ADD_BGN; i<cover_num_of_block_access; i++) {
		for (j=0; j<cover_addr_len; j++) {
			ad_start[j] = coverage_buf[coverage_buf_count+j];
			ad_end[j] = coverage_buf[coverage_buf_count+j+cover_addr_len];
		}
		ad_start[j] = ad_end[j] = '\0';
		strcpy(clist_item, ad_start);
		strcat(clist_item, " - ");
		strcat(clist_item, ad_end);
		mf_rowins(clist_item, APPEND_ROW, list_mfp);
		coverage_buf_count += 2*cover_addr_len;
	}
	/*ShowExecMess(spa_cover_mess5[3]);*/
        RecoverEV7(EV7OldSetting);
}

ShowMessWn(messptr1, messptr2, mess_num)
char *messptr1[], *messptr2[];
int mess_num;
{
	extern int mono_flag;
	int i, j, hili_color;

	if (mono_flag == 0) hili_color = LBRO_BLU;
	else hili_color = LFLDACTOFF;
	wn_clr(spa_cover_mess_wn1);
	for (i=0, j=0; i<mess_num; i++) {
		v_stattpl( 0,  j+1, messptr1[i], LFORMS, STATT, spa_cover_mess_wn1);
		j = j + strlen( messptr1[i] );
		v_stattpl( 0,  j+1, messptr2[i], hili_color, STATT, spa_cover_mess_wn1);
		j = j + strlen( messptr2[i] ) + 1;
	}
}

int FASTCALL SpaCoverClProc(start_item, clistp)
int start_item;
CLISTPTR clistp;
{
	int retval = 0;
	ULONG list_up;
	MFILEPTR mfp;
	UCHAR *mfkwdp;

	mfp = clistp->wnp->mfp;
	mfkwdp = mfp->kwdp;

	if (!(mf_kwdset(clistp->kwdp, mfp)))
		goto spa_cl_proc_end;

	if (!(list_up = wn_isup(clistp->wnp)))
		if (!(retval = cl_up(clistp)))
			 goto spa_cl_proc_end;

	retval = SpaCoverClRd(start_item, clistp);

spa_cl_proc_end:
	mf_kwdset(mfkwdp, mfp);

	return(retval);
}

SetWnAtt(wnp, att, bdratt, title, titleatt, titleloc)
WINDOWPTR	wnp;
UCHAR		att, bdratt, *title, titleatt;
int		titleloc;
{
	wnp->att = att;
	wnp->bdratt = bdratt;
	wnp->title = title;
	wnp->titleatt = titleatt;
	wnp->titleloc = titleloc;
}

InitCoverF9Wn()
{
	int	i;

	csr_hide();

	spa_cover_top_wn = wn_def(0, 0, 1, 80, LWHI_BLU, BDR_NULLP);

	spa_cover_toggle_status = 0;
	for (i=0; i<10; i++) {
		spa_cover_assembly.data_in_buffer[i] = 0;
		spa_cover_dump.data_in_buffer[i] = 0;
	}
	spa_cover_assembly.current_page = 0;
	spa_cover_assembly.current_status = 1;
	spa_cover_dump.current_page = 0;
	spa_cover_dump.current_status = 1;
	if ( (spa_cover_wnstk.stack_ptr==0) || (spa_cover_wnstk.stack_ptr==2) )
		spa_cover_assembly.max_page = 9;
	else if ( (spa_cover_wnstk.stack_ptr==1) || (spa_cover_wnstk.stack_ptr==3) )
		spa_cover_dump.max_page = 9;

	spa_cover_assembly.wnp = wn_def(1, 24, 22, 56, LMESSAGE, &spa_cover_upper_right_bdr);
	spa_cover_assembly.wnp_f = wn_def(1, 0, 22, 80, LMESSAGE, &spa_cover_upper_bdr);
	sw_opt( POPUP, ON, spa_cover_assembly.wnp);
	sw_opt( POPUP, ON, spa_cover_assembly.wnp_f);
	for (i=0; i<10; i++) spa_cover_assembly.msp[i] = ms_def(20, 80, LMESSAGE);
	sw_msbuf(spa_cover_assembly.msp[0], spa_cover_assembly.wnp);
	sw_msbuf(spa_cover_assembly.msp[0], spa_cover_assembly.wnp_f);
	SetWnAtt(spa_cover_assembly.wnp, LMESSAGE, LMESSAGE, spa_cover_assembly_title, LMESSAGE, TOPCENTER);
	SetWnAtt(spa_cover_assembly.wnp_f, LMESSAGE, LMESSAGE, spa_cover_assembly_title, LMESSAGE, TOPCENTER);

	spa_cover_dump.wnp = wn_def(1, 24, 22, 56, LMESSAGE, &spa_cover_upper_right_bdr);
	spa_cover_dump.wnp_f = wn_def(1, 0, 22, 80, LMESSAGE, &spa_cover_upper_bdr);
	sw_opt( POPUP, ON, spa_cover_dump.wnp);
	sw_opt( POPUP, ON, spa_cover_dump.wnp_f);
	for (i=0; i<10; i++) spa_cover_dump.msp[i] = ms_def(20, 80, LMESSAGE);
	sw_msbuf(spa_cover_dump.msp[0], spa_cover_dump.wnp);
	sw_msbuf(spa_cover_dump.msp[0], spa_cover_dump.wnp_f);
	SetWnAtt(spa_cover_dump.wnp, LMESSAGE, LMESSAGE, spa_cover_dump_title, LMESSAGE, TOPCENTER);
	SetWnAtt(spa_cover_dump.wnp_f, LMESSAGE, LMESSAGE, spa_cover_dump_title, LMESSAGE, TOPCENTER);

	spa_cover_wnstk.stack_ptr = 0;
	spa_cover_wnstk.four_spa_f9_wn[0].wnptr = spa_cover_assembly.wnp;
	spa_cover_wnstk.four_spa_f9_wn[0].F7_pressed = 2;
	spa_cover_wnstk.four_spa_f9_wn[0].SP_pressed = 1;
	spa_cover_wnstk.four_spa_f9_wn[1].wnptr = spa_cover_dump.wnp;
	spa_cover_wnstk.four_spa_f9_wn[1].F7_pressed = 3;
	spa_cover_wnstk.four_spa_f9_wn[1].SP_pressed = 0;
	spa_cover_wnstk.four_spa_f9_wn[2].wnptr = spa_cover_assembly.wnp_f;
	spa_cover_wnstk.four_spa_f9_wn[2].F7_pressed = 0;
	spa_cover_wnstk.four_spa_f9_wn[2].SP_pressed = 3;
	spa_cover_wnstk.four_spa_f9_wn[3].wnptr = spa_cover_dump.wnp_f;
	spa_cover_wnstk.four_spa_f9_wn[3].F7_pressed = 1;
	spa_cover_wnstk.four_spa_f9_wn[3].SP_pressed = 2;

	wn_up(spa_cover_top_wn);
	v_printf( spa_cover_top_wn, "                    %d.%d %% of memory accessed in program ranges", percent_of_coverage1, percent_of_coverage2);
	cl_up(clistp);
	wn_up(spa_cover_assembly.wnp);
}

CloseCoverF9Wn()
{
	int i;

	for (i=spa_cover_wnstk.stack_ptr; i >= 0; i--)
		wn_dn(spa_cover_wnstk.four_spa_f9_wn[i].wnptr);
	cl_dn(clistp);
	wn_dn(spa_cover_top_wn);
	wn_free(spa_cover_assembly.wnp);
	wn_free(spa_cover_top_wn);
	for (i=0; i<10; i++) {
		ms_free(spa_cover_assembly.msp[i]);
		ms_free(spa_cover_dump.msp[i]);
	}
	csr_show();
}

SpaCoverDisassembly(wnp, cover_addr_argv)
WINDOWPTR wnp;
unsigned char *cover_addr_argv;
{
	unsigned char com[32];

	strcpy(com, "D ");
	strcat(com, cover_addr_argv);
	SendCommend(com);
	ReceiveDispFromMice(wnp);
}

SpaCoverMemoryDump(wnp, cover_addr_argv)
WINDOWPTR wnp;
unsigned char *cover_addr_argv;
{
	unsigned char com[32];

	strcpy(com, "M ");
	strcat(com, cover_addr_argv);
	SendCommend(com);
	ReceiveDispFromMice(wnp);
}

SendCommend(commend)
char *commend;
{
	int i, j, rec_char;

	for (i=0; i<strlen(commend); i++) {
		send(commend[i]);
	}
	send(KEY_ENTER);
}

ReceiveDispFromMice(wnp)
WINDOWPTR wnp;
{
	int rec_char, i=0, win_rows = 0, kbinput, addr_count;
	unsigned char temp[85], c186_seg[5], c186_off[5], c186_temp[12], c186_temp_line[85];

	
	while (receive() != 0x0d);
	sw_opt( WNECHO, OFF, spa_cover_wnstk.four_spa_f9_wn[spa_cover_wnstk.stack_ptr].wnptr );
	do {
		rec_char = receive();
		if ( (rec_char >= 0x20) && (rec_char <= 0x7f) ) {
			temp[i] = (unsigned char) rec_char;
			i++;
			if (rec_char == 0x3e) {
				if ( (spa_cover_wnstk.stack_ptr==0) || (spa_cover_wnstk.stack_ptr==2) ) {
					spa_cover_assembly.current_status = 1;
					spa_cover_assembly.max_page = spa_cover_assembly.current_page;
				} else if ( (spa_cover_wnstk.stack_ptr==1) || (spa_cover_wnstk.stack_ptr==3) ) {
					spa_cover_dump.current_status = 1;
					spa_cover_dump.max_page = spa_cover_dump.current_page;
				}
			}
		} else if (rec_char == 0x0d) {
			temp[i] = '\n';
			temp[i+1] = 0;
			if ( strstr(temp, "completed") == NULL ) {
				if ( (env.Mmodel == 39) && (win_rows != 0) ) {
					sscanf(temp, "%4s:%4s", c186_seg, c186_off);
					LogicalToPhysicalAddr(c186_seg, c186_off, c186_temp);
					strcat(c186_temp, "     ");
					strcpy(c186_temp_line, temp);
					for(addr_count=0; addr_count<strlen(c186_temp); addr_count++)
						c186_temp_line[addr_count]=c186_temp[addr_count];
					v_st(c186_temp_line, wnp);
				} else v_st(temp, wnp);
				win_rows += 1;
			}
			i = 0;
			if ( win_rows == 20 ) {
				if ( (spa_cover_wnstk.stack_ptr==0) || (spa_cover_wnstk.stack_ptr==2) )
					sscanf(temp, "%s", spa_cover_assembly.next_page_start_addr);
				else if ( (spa_cover_wnstk.stack_ptr==1) || (spa_cover_wnstk.stack_ptr==3) )
					sscanf(temp, "%s", spa_cover_dump.next_page_start_addr);
				win_rows = 0;
				send(KEY_ESC);
				while (receive() != HAND_SHAKE);
				break;
			}
		}
	} while (rec_char != HAND_SHAKE);
	sw_opt( WNECHO, ON, spa_cover_wnstk.four_spa_f9_wn[spa_cover_wnstk.stack_ptr].wnptr );
	wn_upd( spa_cover_wnstk.four_spa_f9_wn[spa_cover_wnstk.stack_ptr].wnptr );
}

InitMiceSpaCover()
{
	unsigned char com[32];

	strcpy(com, "COV ENABLE");
	SendCommend(com);
	while (receive() != HAND_SHAKE);
}

SpaCoverSetRange(addr1, addr2)
char *addr1, *addr2;
{
	unsigned char com[32];

	strcpy(com, "COV ");
	strcat(com, addr1);
	strcat(com, " ");
	strcat(com, addr2);
	SendCommend(com);
	while (receive() != HAND_SHAKE);
}

SpaCoverClearRange(addr1, addr2)
char *addr1, *addr2;
{
	unsigned char com[32];

	strcpy(com, "COV ");
	strcat(com, addr1);
	strcat(com, " ");
	strcat(com, addr2);
	strcat(com, " ");
	strcat(com, "CLEAR");
	SendCommend(com);
	while (receive() != HAND_SHAKE);
}

SpaCoverSetMemType(mem_type)
char *mem_type;
{
	unsigned char com[32];

	strcpy(com, "COV ");
	strcat(com, mem_type);
	SendCommend(com);
	while (receive() != HAND_SHAKE);
}

SetBreakPoint(addr)
char *addr;
{
	char command[15];

	strcpy(command, "EV 7 ");
	strcat(command, addr);
	SendCommend(command);
	while (receive() != HAND_SHAKE);
}

CoverClistF7(dummyptr)
KEYCTRLPTR  dummyptr;
{
	int i, obj_wn, cur_wn;

	cur_wn = spa_cover_wnstk.stack_ptr;
	obj_wn = spa_cover_wnstk.four_spa_f9_wn[cur_wn].F7_pressed;
	if (cur_wn < obj_wn) {
		for (i=(cur_wn+1); i<=obj_wn; i++)
			wn_up(spa_cover_wnstk.four_spa_f9_wn[i].wnptr);
		spa_cover_wnstk.stack_ptr = obj_wn;
	} else if (cur_wn > obj_wn) {
		for (i=cur_wn; i>obj_wn; i--)
			wn_dn(spa_cover_wnstk.four_spa_f9_wn[i].wnptr);
		spa_cover_wnstk.stack_ptr = obj_wn;
	}
	spa_cover_wnstk.four_spa_f9_wn[obj_wn].wnptr->row_org = spa_cover_wnstk.four_spa_f9_wn[cur_wn].wnptr->row_org;
	spa_cover_wnstk.four_spa_f9_wn[obj_wn].wnptr->col_org = spa_cover_wnstk.four_spa_f9_wn[cur_wn].wnptr->col_org;
	spa_cover_wnstk.four_spa_f9_wn[obj_wn].wnptr->r = spa_cover_wnstk.four_spa_f9_wn[cur_wn].wnptr->r;
	spa_cover_wnstk.four_spa_f9_wn[obj_wn].wnptr->c = spa_cover_wnstk.four_spa_f9_wn[cur_wn].wnptr->c;
	wn_upd(spa_cover_wnstk.four_spa_f9_wn[obj_wn].wnptr);
	if ( (cur_wn==2) || (cur_wn==3) ) {
		mf_disp(clistp->wnp);
		/*v_chattrow(clistp->wnp->r, clistp->wnp->c, (UCHAR)0,  clistp->wnp->att, clistp->len, ATT, clistp->wnp);*/
		v_attq(clistp->act_att, clistp->len, clistp->wnp);
	}
	return(1);
}

CoverClistSP(dummyptr)
KEYCTRLPTR  dummyptr;
{
	int i, obj_wn, cur_wn;

	cur_wn = spa_cover_wnstk.stack_ptr;
	obj_wn = spa_cover_wnstk.four_spa_f9_wn[cur_wn].SP_pressed;
	if (cur_wn < obj_wn) {
		for (i=(cur_wn+1); i<=obj_wn; i++)
			wn_up(spa_cover_wnstk.four_spa_f9_wn[i].wnptr);
		spa_cover_wnstk.stack_ptr = obj_wn;
	} else if (cur_wn > obj_wn) {
		for (i=cur_wn; i>obj_wn; i--)
			wn_dn(spa_cover_wnstk.four_spa_f9_wn[i].wnptr);
		spa_cover_wnstk.stack_ptr = obj_wn;
	}
	if (spa_cover_toggle_status == 0) {
		SpaClistCR();
		spa_cover_toggle_status = 1;
	}
	return(1);
}

int FASTCALL SpaCoverClRd(start_item, clistp)
int start_item;
CLISTPTR clistp;
{
    int retval = 0;                     /*default return value (error)        */
    static int key=KEY_ENTER;           /*keycode                             */
    int keyret;                         /*return value from kt_proc()         */
    int row_high;                       /*currently highlighted row           */
    int row_org;                        /*previous window coordinates in mf   */
    int r;                              /*previous virtual cursor row         */
    int row_q;                          /*#of rows in window                  */
    int len;                            /*length of highlight                 */
    WINDOWPTR wnp;                      /*variables to avoid indirection      */
    MFILEPTR mfp;
    UCHAR act_att;
    UCHAR inact_att;
    UCHAR * mfkwdp;                     /*temporary storage                   */
    UCHAR * kwdp;
    int titemnum;
    int tr, tc;

    wnp = clistp->wnp;                  /*avoid indirection                   */
    inact_att = wnp->att;
    act_att = clistp->act_att;
    mfp = wnp->mfp;
    kwdp = clistp->kwdp;
    len = clistp->len;
    row_q = wn_rowq(wnp);               /*avoid repeated calculation          */
    mfkwdp = mfp->kwdp;                 /*save old keyword                    */
    csr_rd(&tr, &tc);                   /*save the physical cursor position   */
    csr_mv(vs_rowq(), 0);               /*hide the cursor                     */

    if (!(mf_kwdset(kwdp, mfp)))        /*change memory file keyword info     */
        goto SPA_COVER_CLIST_END;

    if (start_item < wnp->row_org ||    /*if active item not already visible  */
        start_item >= wnp->row_org + row_q)
    {                                   /*make it visible                     */
        if (start_item < row_q)
            wnp->row_org = 0;
        else if (mfp->vln_q - start_item < row_q)
            wnp->row_org = mfp->vln_q - row_q;
        else
            wnp->row_org = start_item;
    }

    wnp->r = start_item - wnp->row_org; /*move virtual cursor to active item  */
    clistp->nextact = AC_CONTINUE;
    row_high = FALSE;
    titemnum = clistp->itemnum;
    clistp->itemnum = start_item;
if ( (spa_cover_wnstk.stack_ptr==0) || (spa_cover_wnstk.stack_ptr==1) )
    mf_disp(wnp);                       /*display choice list                 */

    while (clistp->nextact != AC_EXIT && clistp->nextact != AC_QUIT)
    {
if ( (spa_cover_wnstk.stack_ptr==0) || (spa_cover_wnstk.stack_ptr==1) )
        if (!row_high)
        {
            v_attq(act_att, len, wnp);  /*highlight active row                */
            row_high = TRUE;
        }

        if (_csrvis)                    /*if cursor is not hidden             */
            csr_plwn(wnp);              /*place it on the current line        */
        spa_clist_key_old = key;
        if (continue_enter==0) key = ki();                     /*get a keystroke                     */
        else {
              continue_enter=0;
              key = KEY_ENTER;
        }
        spa_clist_key_new = key;
        if ( ( (spa_clist_key_old == KEY_ENTER) || (spa_clist_key_old == KEY_ESC) ) && (spa_clist_key_new == KEY_ENTER) ) {
              continue_enter=1;
              key = KEY_DN;
        }
        row_org = wnp->row_org;         /*save window position                */
        r = wnp->r;                     /*save virtual cursor's row           */
        clistp->nextact = AC_CONTINUE;  /*ensure nextact is not AC_NEXT       */

        if ((keyret = kt_proc(key, SYSKTP, (PTR)clistp)) == -1)
            keyret = kt_proc(key, CLKTP, (PTR)clistp);
        if (!keyret)                    /*zero returned from the key function */
            goto SPA_COVER_CLIST_END;

        wnp->col_org = 0;               /*force cursor to stay at column 0    */
        wnp->c = 0;
                                        /*if window origin moves              */
        if (clistp->nextact == AC_NEXT || row_org != wnp->row_org)
        {
if ( (spa_cover_wnstk.stack_ptr==0) || (spa_cover_wnstk.stack_ptr==1) ) {
            mf_disp(wnp);               /*redraw window                       */
            row_high = FALSE;
}
        }
        else if (r != wnp->r)           /*virtual cursor changed row          */
        {
                                        /*unhighlight old item                */
if ( (spa_cover_wnstk.stack_ptr==0) || (spa_cover_wnstk.stack_ptr==1) ) {
            v_chattrow(r, wnp->c, (UCHAR)0, inact_att, len, ATT, wnp);
            row_high = FALSE;
}
        }
					/*maintain the current item number    */
        clistp->itemnum = wnp->row_org + wnp->r;
    }

    if (row_high)                       /*unhighlight row if highlighted      */
if ( (spa_cover_wnstk.stack_ptr==0) || (spa_cover_wnstk.stack_ptr==1) )
        v_chattrow(r, wnp->c, (UCHAR)0, inact_att, len, ATT, wnp);
     
    if (clistp->nextact != AC_EXIT)     /*if user did not exited normally     */
                                        /*restore the original row            */
        clistp->itemnum = titemnum;

    retval = clistp->nextact;

SPA_COVER_CLIST_END:
    mf_kwdset(mfkwdp, mfp);             /*restore keyword information         */
    csr_mv(tr, tc);                     /*restore cursor                      */

    return(retval);
}

SetDataFromMice(coverage_buf)
unsigned char *coverage_buf;
{
	CO *datap;
	char *ptr1,*ptr2,*ptr3;
	int i, ini_on, cov_on;

	datap = &co;
	do_1_cmd_save("INI",MICEBuf,(MICEBUFSIZE+1));
	if (strstr(MICEBuf,"disabled") == NULL) init_status_for_cover = 1;
	else {
		do_1_cmd_save("COV",MICEBuf,(MICEBUFSIZE+1));
		if (strstr(MICEBuf,"disabled") == NULL) init_status_for_cover = 2;
		else init_status_for_cover = 0;
	}
	InitMiceSpaCover();
	do_1_cmd_save("DEBUGON",MICEBuf,(MICEBUFSIZE+1));
	do_1_cmd_save("COV",MICEBuf,(MICEBUFSIZE+1));
	memset(datap,NULL,sizeof(CO));
	datap->f0 = TRUE;
	datap->f1 = TRUE;
	datap->f2 = TRUE;
	datap->f3 = TRUE;
	datap->f4 = TRUE;
	if (strstr(MICEBuf,"No address range") != NULL) {
		send(KEY_ESC);
		while (receive() != HAND_SHAKE);
		do_1_cmd_save("DEBUGOFF",MICEBuf,(MICEBUFSIZE+1));
		return;
	} else if (strstr(MICEBuf,"The ranges") != NULL) {
		if (env.Mmodel == 39) 
			ptr2 = ptr1 = strstr(MICEBuf,"Bus Status :");
		else    ptr2 = ptr1 = strstr(MICEBuf,"Memory type :");
		ptr1 = SepLineFromLongString(ptr1);
		ptr2 += 13;
		if (env.Mmodel == 39) {
			if (strstr(ptr2,"I") != NULL)  datap->f0 = TRUE;
			else                           datap->f0 = FALSE;
			if (strstr(ptr2,"O") != NULL)  datap->f1 = TRUE;
			else                           datap->f1 = FALSE;
			if (strstr(ptr2,"S") != NULL)  datap->f2 = TRUE;
			else                           datap->f2 = FALSE;
			if (strstr(ptr2,"R") != NULL)  datap->f3 = TRUE;
			else                           datap->f3 = FALSE;
			if (strstr(ptr2,"W") != NULL)  datap->f4 = TRUE;
			else                           datap->f4 = FALSE;
		} else {
			if (strstr(ptr2,"SP") != NULL) datap->f0 = TRUE;
			else                           datap->f0 = FALSE;
			if (strstr(ptr2,"SD") != NULL) datap->f1 = TRUE;
			else                           datap->f1 = FALSE;
			if (strstr(ptr2,"UP") != NULL) datap->f2 = TRUE;
			else                           datap->f2 = FALSE;
			if (strstr(ptr2,"UD") != NULL) datap->f3 = TRUE;
			else                           datap->f3 = FALSE;
		}
		for (i=0; i < 16; i++) {
			if (ptr1 == 0L) break;
			ptr2 = ptr1;
			ptr1 = SepLineFromLongString(ptr1);
			if ((*ptr2 == '\0') || (*ptr2 == '>'))  break;
			cco->br[i].op = TRUE;
			sscanf(ptr2,"%*s %s %s %*s",cco->br[i].start,cco->br[i].end);
			StripBlanks(cco->br[i].start);
			StripBlanks(cco->br[i].end);
		}
	}
	do_1_cmd_save("DEBUGOFF",MICEBuf,(MICEBUFSIZE+1));
	DoCoverageusdCmd(coverage_buf);
}

CheckAllRangeClr()
{
	int i, retval;

	retval = 1;
	for (i=0; i<16; i++) if (cco->br[i].op == TRUE) retval = 0;
	return(retval);
}

ShowExecMess(str)
char *str;
{
	v_printf( spa_cover_mess_wn1, "\n %s", str);
	while( ki() != KEY_ESC );
}

int SpaCoverSymToAddr(org_str, addr, ftype)
char *org_str;
char *addr;
int  ftype;
{
	int retval, i, j;
	int temp[15];
	char sym_only[14], error_str[90];

	retval = FOUND;
	RemoveSpaceInStr(org_str);
	if (org_str[0] == '%') {
		strcpy(sym_only, &org_str[1]);
		strcpy(comsym.name, sym_only);
		retval = SymToAddr();
		if(retval == FOUND) {
			memcpy(temp, comsym.addr, env.Maddrunit);
			SpaCoverAddrToStr(temp, addr);
		} else {
			strcpy(error_str, sym_only);
			strcat(error_str, spa_cover_mess5[4]);
			ShowExecMess(error_str);
			retval = 0;
		}
	} else {
		strcpy(addr, org_str);
		if ((strlen(org_str) == 0) && (ftype == 1) ) {
		   retval = 0;
		   ShowExecMess("address missing !");
		}
		for (i=0; i<strlen(org_str); i++)
			if (org_str[i] != ':') {
				if ( (org_str[i] < '0') ||
				     ( (org_str[i] > '9') && (org_str[i] < 'A') ) ||
				     ( (org_str[i] > 'F') && (org_str[i] < 'a') ) ||
				     (org_str[i] > 'f')   )
				{
					strcpy(error_str, org_str);
					strcat(error_str, spa_cover_mess5[4]);
					ShowExecMess(error_str);
					retval = 0;
					break;
				}
			}
	}
	return(retval);
}

SpaCoverAddrToStr(s1,s2)
unsigned char *s1;
char *s2;
{
	extern char hhex[];
	int i,k;

	for (i=0,k=0; i < env.Maddrunit; i++,s1++) {
		s2[k++] = hhex[(((*s1) & 0xf0) >> 4)];
		s2[k++] = hhex[(*s1) & 0x0f];
		if (i == 0 && env.Mmodel == 40) s2[k++] = hhex[16];
		if (i == 1 && env.Sabsflag && env.Mmodel != 40) s2[k++] = hhex[16];
	}
	s2[k] = '\0';
}

RemoveSpaceInStr(str)
char *str;
{
	char temp[14];
	int i, j;

	for (i=0, j=0; i<=strlen(str); i++) {
		if (str[i] == ' ') continue;
		else temp[j++] = str[i] ;
	}
	temp[j] = '\0';
	strcpy(str, temp);
}

SpaClstCtlPgUp()
{
	if ( (spa_cover_wnstk.stack_ptr==0) || (spa_cover_wnstk.stack_ptr==2) ) {
		if ( spa_cover_assembly.current_page > 0 ) {
			spa_cover_assembly.current_page -= 1;
			sw_msbuf(spa_cover_assembly.msp[spa_cover_assembly.current_page], spa_cover_assembly.wnp);
			sw_msbuf(spa_cover_assembly.msp[spa_cover_assembly.current_page], spa_cover_assembly.wnp_f);
			if (spa_cover_wnstk.stack_ptr==0) wn_upd(spa_cover_assembly.wnp);
			else wn_upd(spa_cover_assembly.wnp_f);
			spa_cover_assembly.current_status = 0;
		}
	} else if ( (spa_cover_wnstk.stack_ptr==1) || (spa_cover_wnstk.stack_ptr==3) ) {
		if (spa_cover_dump.current_page > 0) {
			spa_cover_dump.current_page -= 1;
			sw_msbuf(spa_cover_dump.msp[spa_cover_dump.current_page], spa_cover_dump.wnp);
			sw_msbuf(spa_cover_dump.msp[spa_cover_dump.current_page], spa_cover_dump.wnp_f);
			if (spa_cover_wnstk.stack_ptr==1) wn_upd(spa_cover_dump.wnp);
			else wn_upd(spa_cover_dump.wnp_f);
			spa_cover_dump.current_status = 0;
		}
	}
}

SpaClstCtlPgDn()
{
	if ( (spa_cover_wnstk.stack_ptr==0) || (spa_cover_wnstk.stack_ptr==2) ) {
		if ( (spa_cover_assembly.current_page < 9) && (spa_cover_assembly.current_status == 0) && (spa_cover_assembly.current_page < spa_cover_assembly.max_page) ) {
			spa_cover_assembly.current_page += 1;
			sw_msbuf(spa_cover_assembly.msp[spa_cover_assembly.current_page], spa_cover_assembly.wnp);
			sw_msbuf(spa_cover_assembly.msp[spa_cover_assembly.current_page], spa_cover_assembly.wnp_f);
			if (spa_cover_wnstk.stack_ptr==0) wn_upd(spa_cover_assembly.wnp);
			else wn_upd(spa_cover_assembly.wnp_f);
			if (spa_cover_assembly.data_in_buffer[spa_cover_assembly.current_page] == 0 ) {
				if (spa_cover_wnstk.stack_ptr==0) wn_clr(spa_cover_assembly.wnp);
				else wn_clr(spa_cover_assembly.wnp_f);
				strcat(spa_cover_assembly.next_page_start_addr, " ");
				strcat(spa_cover_assembly.next_page_start_addr, end_addr_of_range_accessed);
				SpaCoverDisassembly(spa_cover_wnstk.four_spa_f9_wn[spa_cover_wnstk.stack_ptr].wnptr, spa_cover_assembly.next_page_start_addr);
				spa_cover_assembly.data_in_buffer[spa_cover_assembly.current_page] = 1;
			}
		} else if (spa_cover_assembly.current_page == 9) spa_cover_assembly.current_status = 1;
	} else if ( (spa_cover_wnstk.stack_ptr==1) || (spa_cover_wnstk.stack_ptr==3) ) {
		if ( (spa_cover_dump.current_page < 9) && (spa_cover_dump.current_status == 0) && (spa_cover_dump.current_page < spa_cover_dump.max_page) ) {
			spa_cover_dump.current_page += 1;
			sw_msbuf(spa_cover_dump.msp[spa_cover_dump.current_page], spa_cover_dump.wnp);
			sw_msbuf(spa_cover_dump.msp[spa_cover_dump.current_page], spa_cover_dump.wnp_f);
			if (spa_cover_wnstk.stack_ptr==1) wn_upd(spa_cover_dump.wnp);
			else wn_upd(spa_cover_dump.wnp_f);
			if (spa_cover_dump.data_in_buffer[spa_cover_dump.current_page] == 0 ) {
				if (spa_cover_wnstk.stack_ptr==1) wn_clr(spa_cover_dump.wnp);
				else wn_clr(spa_cover_dump.wnp_f);
				strcat(spa_cover_dump.next_page_start_addr, " ");
				strcat(spa_cover_dump.next_page_start_addr, end_addr_of_range_accessed);
				SpaCoverMemoryDump(spa_cover_wnstk.four_spa_f9_wn[spa_cover_wnstk.stack_ptr].wnptr, spa_cover_dump.next_page_start_addr);
				spa_cover_dump.data_in_buffer[spa_cover_dump.current_page] = 1;
			}
		} else if (spa_cover_dump.current_page == 9) spa_cover_dump.current_status = 1;
	}
}

SpaClistCR()
{
	int i;

	if ( (spa_cover_wnstk.stack_ptr==0) || (spa_cover_wnstk.stack_ptr==2) ) {
		for (i=0; i<10; i++) spa_cover_assembly.data_in_buffer[i] = 0;
		spa_cover_assembly.current_page = 0;
		spa_cover_assembly.current_status = 0;
		spa_cover_assembly.max_page = 9;
		sw_msbuf(spa_cover_assembly.msp[0], spa_cover_assembly.wnp);
		sw_msbuf(spa_cover_assembly.msp[0], spa_cover_assembly.wnp_f);
		if (spa_cover_wnstk.stack_ptr==0) wn_clr(spa_cover_assembly.wnp);
		else wn_clr(spa_cover_assembly.wnp_f);
		SpaCoverDisassembly(spa_cover_wnstk.four_spa_f9_wn[spa_cover_wnstk.stack_ptr].wnptr, cover_addr_argv);
		spa_cover_assembly.data_in_buffer[0] = 1;
	} else if ( (spa_cover_wnstk.stack_ptr==1) || (spa_cover_wnstk.stack_ptr==3) ) {
		for (i=0; i<10; i++) spa_cover_dump.data_in_buffer[i] = 0;
		spa_cover_dump.current_page = 0;
		spa_cover_dump.current_status = 0;
		spa_cover_dump.max_page = 9;
		sw_msbuf(spa_cover_dump.msp[0], spa_cover_dump.wnp);
		sw_msbuf(spa_cover_dump.msp[0], spa_cover_dump.wnp_f);
		if (spa_cover_wnstk.stack_ptr==1) wn_clr(spa_cover_dump.wnp);
		else wn_clr(spa_cover_dump.wnp_f);
		SpaCoverMemoryDump(spa_cover_wnstk.four_spa_f9_wn[spa_cover_wnstk.stack_ptr].wnptr, cover_addr_argv);
		spa_cover_dump.data_in_buffer[0] = 1;
	}
}

InsertStrIntoStr(main_str, sub_str, n)
int n;
char *main_str, *sub_str;
{
	char temp[80];
	int i;

	strcpy(temp, main_str+n+1);
	main_str[n+1] = 0;
	strcat(main_str, sub_str);
	strcat(main_str, temp);
}

LogicalToPhysicalAddr(seg_addr, off_addr, phy_addr)
unsigned char *seg_addr, *off_addr, *phy_addr;
{
	unsigned long seg, off, phy;
	unsigned char *stop_at, temp[10];
	int i;

	sscanf(seg_addr, " %lx ",&seg);
	sscanf(off_addr, " %lx ",&off);
	phy = (seg << 4) + off;
	ultoa(phy, phy_addr, 16);
	if (strlen(phy_addr)==6) for (i=0; i<6; i++) phy_addr[i] = phy_addr[i+1];
	else while (strlen(phy_addr)<5) InsertStrIntoStr(phy_addr, "0", -1);
	for (i=0; i<strlen(phy_addr); i++) phy_addr[i]=toupper(phy_addr[i]);
}

DoCoverageusdCmd(coverage_buf)
unsigned char *coverage_buf;
{
	int i, j, coverage_buf_count, clist_item_rowq, rec_count=0;
	unsigned char temp, ad_start[14], ad_end[14], clist_item[30];

	SendCommend("COVERAGEUSD ");
	do {
		temp = receive();
	} while (temp != KEY_ENTER);
	coverage_buf_count = 0;
	do {
		temp = receive();
		if ( ( (temp<=90) && (temp>=65) ) || ( (temp<=57) && (temp>=48) ) ) {
			coverage_buf[coverage_buf_count] = temp;
			coverage_buf_count++;
		}
		if (rec_count==2047) {
			send(KEY_ESC);
			while (receive() != HAND_SHAKE);
			break;
		}
	} while (temp != HAND_SHAKE);
	sscanf(coverage_buf, "%2x%2x%2x", &percent_of_coverage1, &percent_of_coverage2, &cover_addr_len);
	cover_num_of_block_access = (coverage_buf_count - REC_BUF_ADD_BGN)/(cover_addr_len*2);
	if (cover_num_of_block_access == 0) data_in_cover_buf=0;
	else data_in_cover_buf=1;
	clist_item_rowq = mf_rowq(list_mfp);
	for (i=1; i<clist_item_rowq; i++) mf_rowdel(1, list_mfp);
	for (i=0, coverage_buf_count=REC_BUF_ADD_BGN; i<cover_num_of_block_access; i++) {
		for (j=0; j<cover_addr_len; j++) {
			ad_start[j] = coverage_buf[coverage_buf_count+j];
			ad_end[j] = coverage_buf[coverage_buf_count+j+cover_addr_len];
		}
		ad_start[j] = ad_end[j] = '\0';
		strcpy(clist_item, ad_start);
		strcat(clist_item, " - ");
		strcat(clist_item, ad_end);
		mf_rowins(clist_item, APPEND_ROW, list_mfp);
		coverage_buf_count += 2*cover_addr_len;
	}
}

SaveEv7Old(oldSetting)
UCHAR *oldSetting;
{
        UCHAR com[20], rec[200], theSetting[80], *temp;
        int i=0;

 /*       strcpy(com, "EV7");
	SendCommend(com);
        while ( (rec[i++]=receive()) != HAND_SHAKE);
        rec[i] = 0;
        temp = strstr(rec, "EV7 (Execution)");
        temp += 16;
        strcpy(oldSetting, "EV7 ");
        strcat(oldSetting, temp);*/
}

RecoverEV7(com)
UCHAR *com;
{
        SendCommend("EV7 CLEAR");
        while (receive() != HAND_SHAKE);
}
