
/***************************************************************************
**
**    $Header:   D:/USD3V/LOG/SRC/DOS16.H__   1.2   12 Jun 1996 08:42:48   ZJRD  $
**
**    $Log:   D:/USD3V/LOG/SRC/DOS16.H__  $
** 
**    Rev 1.2   12 Jun 1996 08:42:48   ZJRD
** No change.
** 
**    Rev 1.1   24 May 1996 09:41:52   ZJRD
** No change.
** 
**    Rev 1.0   11 Dec 1995 13:51:38   ZJRD
** Initial revision.
** 
****************************************************************************/
/***************************************************************************
 *
 *  dos16.h -- Definitions and structures for protected mode
 *
 *
 *  $Revision:   1.2  $
 *  $Date:   12 Jun 1996 08:42:48  $
 *  $Logfile:   D:/USD3V/LOG/SRC/DOS16.H__  $
 *  $Log$
 *  
 *     Rev 1.24   05 Oct 1990 20:07:06   JBW
 *  Added xbufadj to d16info.
 *  
 *     Rev 1.23   01 Oct 1990 18:34:38   JAB
 *  Added D16GetSelIncr () for DPMI compatibility.
 *
 *     Rev 1.22   21 Sep 1990 15:40:48   JAB
 *  Added D16PhysAddress ()
 *
 *     Rev 1.21   21 Sep 1990 12:47:42   JBW
 *  Removed names from argument prototypes so will work with MSC 4.
 *
 *     Rev 1.20   20 Sep 1990 16:54:56   JAB
 *  Welcome D16Lock, D16Unlock, D16Reside, D16UnReside (from VM-land) for use
 *  under DPMI or VM.
 *
 *     Rev 1.19   19 Sep 1990 15:35:14   JAB
 *  Changed #define names FORTRAN, PASCAL, MODULA2 to be different to avoid
 *  conflicts with C language keywords.
 *
 *     Rev 1.18   07 Sep 1990 17:57:12   JAB
 *  Added semi-colon...
 *
 *     Rev 1.17   07 Sep 1990 17:53:54   JAB
 *  Added prototype for D16ExpLoad ()
 *
 *     Rev 1.16   07 Sep 1990 17:42:32   JAB
 *  Handle redefines of _loadds, huge, far in a more friendly way
 *
 *     Rev 1.15   20 Aug 1990 16:15:30   JAB
 *  Another instance of incompatibility with lattice 3.20 is worked around...
 *
 *     Rev 1.14   19 Aug 1990 16:44:34   ACB
 *  intflag definition is not 'far' for KERNEL
 *
 *     Rev 1.13   17 Aug 1990 18:42:04   JAB
 *  Removed thinks that MSC4.0 doesn't like...
 *
 *     Rev 1.12   17 Aug 1990 17:16:24   JAB
 *  Added machinery for building language-independent DOS16M function library.
 *
 *     Rev 1.11   11 Jun 1990 14:37:10   JBW
 *  Added d16info.miscellaneous D16misc_extra_mem bit.  True if using
 *  non-contiguous extended/shadow RAM, just below 16MB on some computers.
 *
 *     Rev 1.10   08 Jun 1990 18:41:42   JBW
 *  Added d16info.miscellaneous, and defined D16misc_AT_compat, which is true
 *  if computer has an AT-compatible user architecture.
 *
 *     Rev 1.9   07 Jun 1990 17:12:24   JBW
 *  DPMI compatability.  Corrected tabbing.
 *  Added d16info.machine_type.  This represents the basic architecture
 *  using .swmode numbering (1 = NEC, 2 = PS/2, 3 = 386-AT, ... 9 = 286-AT, etc.)
 *  except for environments (never 0 for DPMI, never 11 for VCPI).
 *
 *     Rev 1.5   03 Jan 1990 14:31:24   JAB
 *  Added conditional to use _far instead of far with Metaware.
 *
 *     Rev 1.4   03 Jan 1990 13:24:58   JBW
 *  Changed comment describing access to current passup frame (PUF).
 *
 *     Rev 1.3   19 Oct 1989 15:27:28   JBW
 *  In NOFAR compilers, #define NearPtr *  breaks the TSF structure.
 *  Now, if NOFAR, .prev_tsf is declared unsigned.
 *
 *     Rev 1.2   09 Oct 1989 12:23:50   JBW
 *  added D16INFO.slow_A20
 *
 *     Rev 1.1   04 Oct 1989 17:33:40   JBW
 *  Added MSW_bits and package_info_p to _d16info structure.
 *
 *     Rev 1.0   19 Sep 1989 09:22:44   ben
 *  Initial revision.
 *
 *
 *  Copyright (c) 1987, 1988, 1989 Rational Systems, Incorporated
 *  All Rights Reserved
 *
 */

#ifdef NOCDECL              /* Lattice 3.20 has no cdecl keyword */
#define cdecl
#endif

#ifdef D16L                 /* Most compilers have no _loadds           */
 #define _loadds _loadds    /* This is important only when compiling    */
#else                       /* the library, not when calling it.        */
 #define _loadds
#endif

#ifdef NOHUGE               /* Lattice 3.20 has no huge keyword */
 #define huge far
#endif

#ifndef DOS16_INCLUDED
#define DOS16_INCLUDED

#ifdef NOFAR                        /* NOFAR assumes large model */
#define FarPtr  *
#define HugePtr  *
/* NearPtr                             doesn't work in NOFAR large model */
#define cdecl
#define Near
#else   /*================================================================*/
#ifdef __HIGHC__
#define FarPtr  * _far
#define HugePtr  * _huge
#define NearPtr  * _near
#define cdecl
#define Near
#else   /*================================================================*/
#define FarPtr  far *
#define HugePtr  huge *
#define NearPtr  near *
#define Near  near
#endif  /*================================================================*/
#endif

#ifdef __WATCOMC__
/* define pragma for 'cdecl' keyword to match Microsoft conventions */
#pragma aux cdecl "_*" parm caller []\
   value struct float struct routine [ax]  modify [ax bx cx dx es];
#endif

#ifdef KERNEL
#define NODPMI 1
#endif

#ifdef NODPMI               /* Kernel uses old constants for selectors */
#define gdt_sel 0x8         /* selector for gdt */
#define idt_sel 0x10        /* selector for idt */
#define kernel_sel 0x18     /* selector for run time kernel code */
#define kernel_data_sel 0x20    /* selector for kernel data */
#define psp_sel 0x28        /* selector for PSP */
#define env_sel 0x30        /* selector for Environment */
#define mem0_sel 0x38       /* selector for physical memory 0 */
#define gdti_sel 0x50       /* selector for gdt auxiliary information segment */
#define debug_gdt (0x60/8)  /* scratch desc for debugging */
#define debug_sel 0x60
#define kernelx_sel 0x70    /* kernel code in extended memory */
#define user_sel 0x80       /* first user selecter (user_gdt << 3) */
#define user_gdt 16         /* first user gdt index */
#else                       /* programs reference system selectors indirectly */
#define gdt_sel __d16_selectors.gdt         /* selector for gdt */
#define idt_sel __d16_selectors.idt         /* selector for idt */
#define kernel_sel __d16_selectors.kernel   /* selector for run time kernel code */
#define kernel_data_sel __d16_selectors.kerneld /* selector for kernel data */
#define psp_sel __d16_selectors.psp         /* selector for PSP */
#define env_sel __d16_selectors.env         /* selector for Environment */
#define mem0_sel __d16_selectors.mem0       /* selector for physical memory 0 */
#define gdti_sel __d16_selectors.gdti       /* sel for gdt info seg */
#define kernelx_sel __d16_selectors.kernelx /* kernel code in extended memory */
#define user_sel __d16_selectors.user       /* first user selecter */
#define user_gdt (user_sel >> 3)            /* first user gdt index */
#endif

#define acc_code 0x9A   /* present, priv 0, code, read, accessed */
#define acc_cmask 0x83
#define acc_data 0x92   /* present, priv 0, data, write, accessed */
#define acc_dmask 0x83
#define acc_DPL 0x60    /* privilege level bits */
#define acc_LDT 0x82    /* Local Descriptor Table type */
#define acc_INT 0x8E    /* interrupt gate */
#define acc_TSS 0x85    /* tss descriptor */
#define acc_write 0x02  /* writable data, readable code access */

#define is_code(a)      (((a) & 0x18) == 0x18)
#define is_data(a)      (((a) & 0x18) == 0x10)
#define is_system(a)    (((a) & 0x10) == 0)
#define Present     0x80
#define is_present(a)  (((a) & Present) != 0)

#define SelMask 0xFFF8          /* lose ring and table bits */

#define MPreferExt 0            /* prefer, but not force, extended */
#define MPreferLow 1            /* prefer, but not force, conventional memory */
#define MForceExt 2             /* force extended */
#define MForceLow 3             /* force conventional */
#define MTransparent 4          /* force conventional, allocate selectors for */
                                /*   transparent addressing */
#define MTransStack 5           /* transparent, but aligned for use as stack */

typedef union {
    char FarPtr p;              /* treat as pointer */
    void FarPtr pv;
    struct {                    /* treat as selector/offset */
        unsigned off;
        unsigned sel;
        } w;
    long l;                     /* treat as arithmetic item */
    } FPTR;

extern struct {
    int d16ptr_ver;             /* structure version, for extensions */
    unsigned gdt;               /* descriptor table (gdt OR ldt, by host) */
    unsigned idt;
    unsigned kernel;
    unsigned kerneld;
    unsigned psp;
    unsigned env;
    unsigned mem0;
    unsigned biosdata;
    unsigned rsvd0;
    unsigned gdti;
    unsigned rsvd1[3];
    unsigned kernelx;
    unsigned rsvd2;
    unsigned user;
    } __d16_selectors;

typedef struct _intvect
    {
    unsigned off;
    unsigned sel;
    } INTVECT;

typedef struct _gdt
    {
    unsigned gdtlen;
    unsigned gdtaddr;
    unsigned char gdtaddr_hi;
    unsigned char gdtaccess;
    unsigned gdtreserved;
    } GDT;

typedef struct _idt
    {
    unsigned idtoffset;
    unsigned idtsel;
    unsigned char idtun1;
    unsigned char idtaccess;
    unsigned idtreserved;
    } IDT;

typedef struct tsf_struct TSF;

struct tsf_struct
    {
#ifdef NOFAR
    unsigned prev_tsf;
#else
    TSF NearPtr prev_tsf;
#endif
    unsigned ss, ds, es;
    unsigned di, si, bp, sp;
    unsigned bx, dx, cx, ax;
    int int_id, int_code;
    unsigned ip, cs, flags;
    } ;

typedef struct _d16regs {
    unsigned ds, es;
    unsigned di, si, bp, sp;    /* note: sp is ignored */
    unsigned bx, dx, cx, ax;
    } D16REGS;                  /* general registers, for D16rmInterrupt() */

#define CarryFlag 0x1           /* flags register mask for carry flag */

typedef struct
    {
    int version;        /* DOS/16M version * 100 */
    unsigned passdn0;   /* offset to int 0 passdown in kernel seg */
    unsigned passdn255; /* offset of last passdown */
    FPTR PassupIntP;    /* pointer to passup interrupt index */
    FPTR xfer_buff;     /* area where data transfers are buffered */
    unsigned xfer_bsize;    /* transfer buffer size */
    unsigned delay_286; /* switch delay for 286 cpus */
    unsigned delay_386; /* switch delay for 386 cpus */
    int switch_control; /* switch technique control flags (see SwCtrl) */
    char FarPtr (cdecl FarPtr D16MStkP)();  /* pointer to D16MoveStack function */
    unsigned (cdecl FarPtr D16ToRMP)(); /* pointer to D16ToReal function */
    int (cdecl FarPtr D16ToPMP)();      /* rm! pointer to D16ToProtected function */
    int (cdecl FarPtr D16rmInP)(int, D16REGS FarPtr, D16REGS FarPtr);
                /* pointer to D16rmInterrupt function */
    unsigned bannerp;   /* true if display standard startup message */
    unsigned D16rdata;  /* real mode DOS/16M data segment */
    char FarPtr versionp;   /* pointer to DOS/16M version string in kernel data */
    char swmode;        /* switch mode number */
    char cpumod;        /* cpu type (2 = 286, 3 = 386) */
    unsigned copyright; /* offset of DOS/16M copyright string */
    unsigned dbginfop;
    unsigned char D16_intno;    /* inter-DOS/16M communications */
    char A20, A20_rigor, A20_orig;
    unsigned last_delseg;   /* last deleted segment (for fault suppression) */
    TSF FarPtr FarPtr tsp_ptr;  /* ptr to TSF pointer */
    char has_87;        /* true if coprocessor present and not emulating */
    char slow_A20;      /* A20 resets not synchronized */
    unsigned MSW_bits;  /* bits OR-ed into MSW going to protected mode */
                /* !! Note:  you should always preserve the */
                /* bits in this word that you are not using. */
    void FarPtr package_info_p; /* package information */
    char machine_type;      /* same as .swmode, except never VCPI or DPMI */
    char miscellaneous;     /* information flags (see D16misc_ below) */
    unsigned xbufadj;		/* transfer buffer size adjustment */
    } D16INFO ;

/* defines for bits in d16info.miscellaneous */
#define D16misc_AT_compat 0x01      /* flag if AT-compatible user architecture */
#define D16misc_extra_mem 0x02      /* extra memory just below 16MB in use */

typedef struct {            /* PassUp interrupt registers */
    /* usage:  ((PUF FarPtr)(*_d16info.tsp_ptr) - 1)->pu_xx */
    unsigned pu_ss;         /* real mode ss */
    unsigned pu_es;         /* real mode es */
    unsigned pu_ds;         /* real mode ds */
    unsigned pu_rsvd;
    unsigned pu_ip;         /* real mode interrupt return frame */
    unsigned pu_cs;
    unsigned pu_flags;
    } PUF;

#ifndef NOFAR              /* (can not address these in Lattice 3.10) */

#ifdef KERNEL
    extern D16INFO _d16info;
#else
#ifdef __HIGHC__
    extern D16INFO _far _d16info;
#else
    extern D16INFO far _d16info;
#endif
#endif /* KERNEL */

#define D16MoveStack(new_sp, context)   (*_d16info.D16MStkP)(new_sp, context)
#define D16ToReal()                     (*_d16info.D16ToRMP)()
#define D16ToProtected(pcs, pss, pds, pes)  (*_d16info.D16ToPMP)(pcs, pss, pds, pes)
#define D16rmInterrupt(intno, inrs, outrs)  (*_d16info.D16rmInP)(intno, inrs, outrs)
#endif  /* NOFAR */

/* bits in _d16info.switch_control */
#define SwCtrl_A20 0x01     /* force A20 line 0 on 386's in real mode */
#define BIOS16_inPM 0x04    /* dont defer BIOS int 16 function 1 */
#define MemInit00 0x20      /* set newly allocated memory to 0x00 */
#define MemInitFF 0x40      /* set newly allocated memory to 0xFF */
#define RotateSelector 0x80 /* do not quickly reuse cancelled selectors */


#define RMCALL_INT 0x18     /* "resident Basic" interrupt used by rmRCall */
#define MAX_PASSUP_INDEX 8  /* number of passup interrupts supported */
#define PASSUP_INDEX_INC 4  /* sizeof passup element */

#define gdti_locked  0x80       /* in gdti */
#define gdti_reside  0x40       /* in gdti */
#define gdti_special 0x20       /* in gdti */
#define gdti_alias   0x10       /* in gdti */
#define gdti_block   0x02       /* in gdti */
#define gdti_owner   0x01       /* in gdti */

#endif   /*  DOS16_INCLUDED    */

#ifndef DOS16LIB_INCLUDED
#define DOS16LIB_INCLUDED

#undef  FP_SEG
#undef  FP_OFF
#define FP_SEG(p)   (*((unsigned short FarPtr) &(p) + 1))
#define FP_OFF(p)   (*(unsigned short FarPtr) &(p))

#define NULL_PTR     ((void *) 0)

#define acc_ref_bit 1       /* descriptor referenced bit */

#ifndef D16L_M2
 #ifndef D16L_FOR
  #ifndef D16L_PAS
   #ifndef D16L_DLL
#define RSIAPI cdecl _loadds far
   #endif
  #endif
 #endif
#endif

#ifdef D16L_M2
 #define RSIAPI pascal _loadds far
#endif

#ifdef D16L_FOR
 #define RSIAPI pascal _loadds far
#endif

#ifdef D16L_PAS
 #define RSIAPI pascal _loadds far
#endif

#ifdef D16L_DLL
 #define RSIAPI cdecl _loadds far
#endif

#ifdef KERNEL
extern int cdecl _intflag(int);
#else
extern int cdecl far _intflag (int);
#endif

extern int cdecl far __DOS (unsigned, D16REGS FarPtr);
extern int cdecl far __INT31 (unsigned, unsigned, D16REGS FarPtr);
extern int cdecl far _is_pm ();
extern int cdecl far chainint (void (far *) ());

#ifndef NO_PROTO
extern  int RSIAPI D16GetAccess (void far *);
extern  int RSIAPI D16SetAccess (void far *,int);
extern  int RSIAPI D16SegProtect (void far *,int);
extern  void far *RSIAPI D16SegDSAlias (void (far *) ());
extern  void (far *RSIAPI D16SegCSAlias (void far *)) ();
extern  int RSIAPI D16CallDebug (char far *);
extern  int RSIAPI D16SegCancel (void far *);
extern  int RSIAPI D16GetROMCheksum (unsigned long far *);
extern  int RSIAPI D16GetDelay (unsigned int far *);
extern  int RSIAPI D16SetDelay (unsigned int);
extern  int RSIAPI D16GetDesc (unsigned int,struct _gdt far *);
extern  int RSIAPI D16SetDesc (unsigned int,struct _gdt far *);
extern  unsigned int RSIAPI D16SegLimit (void far *);
extern  int RSIAPI D16rmGetVector (unsigned int,struct _intvect far *);
extern  int RSIAPI D16pmGetVector (unsigned int,struct _intvect far *);
extern  void huge *RSIAPI huge_alloc (unsigned int, unsigned int);
extern  void huge *RSIAPI D16HugeAlloc (long);
extern  long RSIAPI D16HugeResize (void far *,long);
extern  void huge *RSIAPI D16SelReserve (int);
extern  int RSIAPI D16isDOS16M (void );
extern  int RSIAPI D16isDPMI (void );
extern  int RSIAPI D16MemStrategy (int);
extern  void far *RSIAPI D16MemAlloc (unsigned int);
extern  int RSIAPI D16MemFree (void far *);
extern  long RSIAPI D16ExtAvail (void );
extern  long RSIAPI D16LowAvail (void );
extern  void far *RSIAPI D16SegRealloc (void far *);
extern  void far *RSIAPI D16SegTransparent (unsigned int, unsigned int);
extern  void far *RSIAPI D16SegDataPtr (void far *, unsigned int);
extern  int RSIAPI D16SegResize (void far *, unsigned int);
extern  int RSIAPI D16Overload (int, struct tsf_struct far *);
extern  int RSIAPI D16Execute (struct tsf_struct far *,char far *);
extern  int RSIAPI D16IntStrategy (int);
extern  int RSIAPI D16Passdown (int);
extern  int RSIAPI D16Passup (int);
extern  int RSIAPI D16pmInterrupt (int, struct _d16regs far *, struct _d16regs far *);
extern  unsigned long RSIAPI D16AbsAddress (void far *);
extern  void far *RSIAPI D16SegAbsolute (long, unsigned int);
extern  void far *RSIAPI D16ProtectedPtr (void far *, unsigned int);
extern  long RSIAPI D16ExtReserve (long);
extern  void far *RSIAPI D16RealPtr (void far *);
extern  int RSIAPI D16rmRCall (unsigned int, unsigned int, struct _d16regs far *,struct _d16regs far *);
extern  unsigned int RSIAPI D16NewSelector (void );
extern  int RSIAPI D16FreeSelector (unsigned int);
extern  int RSIAPI D16rmInstall (unsigned int, unsigned int, unsigned int, struct _intvect far *);
extern  int RSIAPI D16pmInstall (unsigned int, unsigned int, unsigned int, struct _intvect far *);
extern  int RSIAPI D16pmSetVector (int, char far *, char far *);
extern  int RSIAPI D16rmSetVector (int, char far *,char far *);
extern  void RSIAPI D16TermFunction (void (_loadds cdecl far *) ());
extern  int RSIAPI D16ExpLoad (int, TSF far *);
extern  int RSIAPI D16Lock (void far *);
extern  int RSIAPI D16UnLock (void far *);
extern  int RSIAPI D16Reside (void far *);
extern  int RSIAPI D16UnReside (void far *);
extern  long RSIAPI D16PhysAddress (long);
extern  int RSIAPI D16GetSelIncr ();

#endif  /*  NO_PROTO          */
#endif  /*  DOS16LIB_INCLUDED */

#ifdef NOCDECL              /* Lattice 3.20 has no cdecl keyword */
#undef cdecl
#endif

#undef _loadds

#ifdef NOHUGE               /* Lattice 3.20 has no huge keyword */
#undef huge
#endif
