
/***************************************************************************
**
**    $Header:   D:/USD3V/LOG/SRC/DOWNLOAD.H__   1.2   12 Jun 1996 08:42:50   ZJRD  $
**
**    $Log:   D:/USD3V/LOG/SRC/DOWNLOAD.H__  $
** 
**    Rev 1.2   12 Jun 1996 08:42:50   ZJRD
** No change.
** 
**    Rev 1.1   24 May 1996 09:41:50   ZJRD
** No change.
** 
**    Rev 1.0   11 Dec 1995 13:51:38   ZJRD
** Initial revision.
** 
****************************************************************************/
/*--------------------------------------------------------------------------*/
/*  download.h								    */
/*--------------------------------------------------------------------------*/


/*--------------------------------------------------------------------------*/
/*  "NEMO.H" in USD-II							    */
/*--------------------------------------------------------------------------*/


#define uchar unsigned char 
#define ushort unsigned short
#define ulong unsigned long
#define TYPEDEF typedef
#define STRUCT struct

/*  Offset value in FERR table  */
 
#define FERR_INVALID_DOWNLOAD_FILE    38
#define FERR_FILE_READ_ERROR          41


/*--------------------------------------------------------------------------*/
/*  "OMF286.H" in USD-II						    */
/*--------------------------------------------------------------------------*/


/*

[] Generalized Addresses and Internal Names

    *) Virtual address(selector, offset)  
                        --->  Generalized address(internal name, offset)

    *) Internal Names

                            3        13          bits
         GDT selector       0       index

                            3        13          bits
         segment            1       index

                            3        13          bits
         gate               2       index

                            3        13          bits
         external symbol    3       index

                            3        13          bits
         descriptor table   4       index

                                     16          bits
         descriptor                 index

                                     16          bits
         type                       index

    *) For (Segment, Gate, External, Type, Descriptor, Descriptor table)
       internal names, the index is the position of the corresponding
       definition within the (SEGDEF, GATDEF, EXTDEF, TYPDEF, DESCRP or TBLDEF)
       section.
       Internal names of Debug Segments in loadable and bootloadable modules
       refer to positions in the DEBTXT table of contents(SEGDEF is absent 
       from loadable and boot-loadable modules)
       The GDT selector internal name's index is the index of the corresponding
       descriptor in the GDT.

    *) Descriptor and Type internal names can be identified by their context

    *) Three special Descriptor internal names

        *) GDT$IN = FFFFH              - for GDT
        *) IDT$IN = FFFEH              - for IDT
        *) TSS$IN$DEFAULT = FFFDH      - initial task state segment

    *) CONST$IN = FFFCH

        *) If internal name = CONST$IN then offset contains the value of the
           constant.
           
    
[] Download

    *) Download information

        * Code and Data
        * GDT table and LDT table    ????

    *) Must setting CPU registers according download information   ???
    
*/

TYPEDEF STRUCT
    {
        ulong tspace;
        ushort no_of_descrp;
        uchar built;
        uchar date[8];
        uchar time[8];
        uchar mod_creat[41];
        ushort TSS_sel;
    } L_MODHDR;

/* for MSC compile 3-20-89, TYPEDEF STRUCT
    {
        uchar tab_of_cont[40];
        uchar *section[];
    } L_PARTITION; */

/* for MSC compile 3-20-89, TYPEDEF STRUCT
    {
        ulong DESCRP_loc;
        ulong LODTXT_loc;
        ulong LODFIX_loc;
        ulong DESNAM_loc;
        ulong DEBTXT_loc;
        ulong DEBFIX_loc;
        ulong ALIAS_loc;
        ulong last_loc;
        ulong next_part_loc;
        ulong reserved;
    } TAB_OF_CONT_1; */

TYPEDEF STRUCT
    {
        ulong ITXT_loc;
        uchar reserved_1[24];
        ulong last_loc;
        ulong next_part_loc;
        ulong reserved_2;
    } TAB_OF_CONT_2;


/* for MSC compile 3-20-89, TYPEDEF STRUCT
    {
        uchar *text_item[];
    } L_LODTXT; */

TYPEDEF STRUCT
    {
        ulong offset;
        ushort descrp_IN;
        ushort length;
        uchar *text;
    } TEXT_ITEM;

/* for MSC compile 3-20-89, TYPEDEF STRUCT
    {
        uchar *itxt_block[];
    } L_ITXT; */

TYPEDEF STRUCT
    {
        ushort offset;
        ushort descrp_IN;
        ushort iteration_count;
        uchar *txt_template; 
    } ITXT_BLOCK;

TYPEDEF STRUCT
    {
        ushort template_length;
        uchar *template_value;
    } L_TXT_TEMPLATE;

TYPEDEF STRUCT
    {
        uchar *tab_of_cont;
        uchar *text;
    } L_DEBTXT;

TYPEDEF STRUCT
    {
        ushort no_of_deb_seg;
        ushort length;
        ulong *location;
    } DEBTXT_TAB_OF_CONT;

TYPEDEF STRUCT
    {
        uchar *alias;
    } L_ALIAS;

TYPEDEF STRUCT
    {
        ushort main_in_name;
        ushort no_of_alias;
        ushort *alias_in_name;
    } ALIAS;

/*********  For  All OMF286 module  *********/

#define TYPE_LINKABLE       0xa0
#define TYPE_LIBRARY        0xa1
#define TYPE_BOOTLOADABLE   0xa2
#define TYPE_LOADABLE       0xa3
#define TYPE_STL            0x06

#define BOOT_286   0xA2
#define BOOT_386   0xB2

/*  Internal name  */

#define IN_GDT_selector     0x00
#define IN_segment          0x01
#define IN_gate             0x02
#define IN_external_symbol  0x03
#define IN_descriptor_table 0x04
#define IN_descriptor           
#define IN_type             
    
#define IN_GDT$IN           0xffff
#define IN_IDT$IN           0xfffe
#define IN_TSS$IN$DEFAULT   0xfffd
#define IN_CONST$IN         0xfffc           

/*  Generalized address  */

TYPEDEF STRUCT
    {
        ulong offset;
        ushort selector;
    } GA;

TYPEDEF STRUCT
    {
        ulong offset;
        ushort in_name;
    } G_ADDR;

TYPEDEF STRUCT
    {
        ulong real_addr;
        ushort length;
        uchar *text;
    } ABSTXT;

/* for MSC compile 3-20-89, TYPEDEF STRUCT
    {
        uchar *descriptor[];
    } DESCRP; */

/*  Hardware portion for descriptor  */

TYPEDEF STRUCT
    {
        ushort limit;
        ushort base;
        ushort dpl_type;
        ushort reserved;
    } HW_PORTION;

TYPEDEF STRUCT
    {
        ushort limit;
        ulong base;
        uchar p;               /*  1= Segment is mapped into physical memory. 
                                   0= No mapping to physical memory exists,
                                         base and limit are not used.
                                      Segment privilege attribute used in
                                         privilege test               */
                                     
        uchar dpl;             /*  Descriptor privilege level  */
        uchar s;               /*  1= Code or Data segment descriptor
                                   0= Non-segment descriptor           */
        uchar type;            /*  For Data Segment:

                                      Bit 2:  Executable(E)
                                              0= Data segment descriptor is:
                                          1:  Expansion Direction(ED)
                                              0= Grow up segment, offset must
                                                 be <= Limit
                                              1= Grow down segment, offset must
                                                 be > Limit
                                          0:  Writable(W)
                                              0= Data segment may not be written
                                              1= Data segment may be written.
                                              
                                   For Code Segment:

                                      Bit 2:  Executable(E)
                                              0= Code segment descriptor is:
                                          1:  Conforming(C)
                                              1= Code segment may only be
                                                 executed when CPL >= DPL
                                          0:  Readable(R)
                                              0= Code segment may not be read
                                              1= Code segment may be read
                               */
        uchar a;               /*  0= Segment has been accessed
                                   1= Segment selector has been loaded into
                                      segment register or used by selector test
                                      instructions             */
    } X_HW_PORTION;

/*********  For  Bootloadable module  *********/

/*****   Only for OMF386    ???   ******/

/*  Boot file header  */

TYPEDEF STRUCT
    {
        uchar boot_ftype;
        ulong boot_tspace;
        uchar boot_date[8];
        uchar boot_time[8];
        uchar boot_creator[41];
        ushort boot_gdtl;
        ulong boot_gdtb;
        ushort boot_idtl;
        ulong boot_idtb;
        ushort boot_tss;
        ulong boot_abstxt;
        ulong boot_debtxt;
        ulong boot_last;
        ulong boot_next;
        uchar boot_rsrv[12];
    } BOOT_MOD_HDR;

/*  Absolute text section  */

TYPEDEF STRUCT
    {
        ulong abs_adr;
        ulong abs_len;
    } BOOT_ABS;

/*  Debug text section table of constant  */

TYPEDEF STRUCT
    {
        ushort deb_segcnt;
        ushort deb_len;
        ulong deb_modules;
        ulong deb_types;
        ulong deb_symbols;
        ulong deb_lines;
        ulong deb_publics;
        ulong deb_externals;
        ulong deb_unknown;
    } BOOT_DEB;

/*  Module header  */

TYPEDEF STRUCT
    {
        ushort mod_idt;
        GA mod_code;
        GA mod_types;
        GA mod_symbols;
        GA mod_lines;
        GA mod_publics;
        GA mod_ext;
        GA mod_unk1;
        uchar mod_unk2;
        ushort mod_flno;
        uchar mod_xltype;
        uchar mod_verno[4];
        uchar mod_name[256];
    } BOOT_MOD;

/*  Public symbols  */

TYPEDEF STRUCT
    {
        ulong pub_offset;
        ushort pub_selector;
        ushort pub_typ_idx;
        uchar pub_wd_cnt;
        uchar pub_name[256];
    } BOOT_PUB;
    

/*********  For  Loadable module  *********/

/*****   Only for OMF386    ???   ******/

/*  Loadable file header  */

TYPEDEF STRUCT
    {
        uchar l_ftype;
        ulong l_tspace;
        ushort l_no_of_descrp;
        uchar built;
        uchar l_date[8];
        uchar l_time[8];
        uchar l_creator[41];
        ushort l_tss;
        ulong l_descrp_itxt;
        ulong l_lodtxt;
        ulong l_lodfix;
        ulong l_desnam;
        ulong l_debtxt;
        ulong l_debfix;
        ulong l_alias;
        ulong l_last;
        ulong l_next;
        uchar l_rsrv[4];
    } L_HDR;

/*  Debug text section table of constant  */

TYPEDEF STRUCT
    {
        ushort deb_segcnt;
        ushort deb_len;
        ulong deb_modules;
        ulong deb_types;
        ulong deb_symbols;
        ulong deb_lines;
        ulong deb_publics;
        ulong deb_externals;
        ulong deb_unknown;
    } L_DEB;

/*  Module header  */

TYPEDEF STRUCT
    {
        ushort mod_idt;
        GA mod_code;
        GA mod_types;
        GA mod_symbols;
        GA mod_lines;
        GA mod_publics;
        GA mod_ext;
        GA mod_unk1;
        uchar mod_unk2;
        ushort mod_flno;
        uchar mod_xltype;
        uchar mod_verno[4];
        uchar mod_name[256];
    } L_MOD;

/*  Public symbols  */

TYPEDEF STRUCT
    {
        ulong pub_offset;
        ushort pub_selector;
        ushort pub_typ_idx;
        uchar pub_wd_cnt;
        uchar pub_name[256];
    } L_PUB;
    

TYPEDEF STRUCT
    {
        uchar hw[6];
        ushort sw_word;          /* bit  15 - 3 : unuse
                                              2 : 1= huge
                                              1 : 1= absolute
                                              0 : 1= expandable
                                 */
    } L_DESCRIPTOR;

/*********  For  STL module  *********/

TYPEDEF STRUCT
    {
        uchar hw[6];
    } STL_DESCRIPTOR;


/*--------------------------------------------------------------------------*/
/*  "OMF_DWN.H" in USD-II						    */
/*--------------------------------------------------------------------------*/


#define REGINT       0x70
#define PIDATA       0x86
#define DAT_TYP      0x84
#define MOD_END_REC  0x8A
#define max_32       32
#define bmax_224     224

/* Temerarily reduce Buffer Size to fit 64K limitation, Will recover */

#define max_rd       1024
#define ext_addr_typ 0x02
