
/***************************************************************************
**
**    $Header:   D:/USD3V/LOG/SRC/KEYBOARD.C__   1.2   12 Jun 1996 08:43:38   ZJRD  $
**
**    $Log:   D:/USD3V/LOG/SRC/KEYBOARD.C__  $
** 
**    Rev 1.2   12 Jun 1996 08:43:38   ZJRD
** No change.
** 
**    Rev 1.1   24 May 1996 09:42:36   ZJRD
** No change.
** 
**    Rev 1.0   11 Dec 1995 13:51:50   ZJRD
** Initial revision.
** 
****************************************************************************/
/*--------------------------------------------------------------------------*/
/*  keyboard.c								    */
/*--------------------------------------------------------------------------*/


#include  "system.h"
#include  "usd3.h"
#include  "gblext.h"
#include  "oldext.h"
#include  "usym1.h"
#include  "usym3.h"
#include  "funcext.h"

extern int in_a_cmd;
extern int MAXFlag;

/****************************************************************************/
/*									    */
/****************************************************************************/

KeyinAnalysis()
{
 if	  ( ( ( Keyin >= KEY_F10 ) && ( Keyin <= KEY_F1 ) ) ||
	    ( ( Keyin >= KEY_CF10 ) && ( Keyin <= KEY_CF1 ) ) )  KEY_F1_F10();
 else  if ( ( Keyin==KEY_UP ) || ( Keyin==KEY_DN ) )  KEY_UP_DN();
 else  if ( ( Keyin >= -50 ) && ( Keyin <= -16 ) )  KEY_AF_AH();
 else  if ( ( Keyin >= KEY_SF10 ) && ( Keyin <= KEY_SF1 ) )  KEY_SF1_SF10();
 else  KEY_DEFAULT();

}  /*  of KeyinAnalysis()  */

/****************************************************************************/
/*									    */
/****************************************************************************/

int  COMVPMax = 0;

KEY_F1_F10()
{
/* USD-III 2.0x */ extern int cursor_appear_or_not;
 WINDOWPTR   MsgWnp;
 static int  COMVPyOrg, COMVPxOrg, COMVPHeight, COMVPWidth;
 static int  OldMaskRedrawFlag, STAVPIsUp, DATVPIsUp;
 int	     COMVPr, COMVPc, COMVProw_org, COMVPcol_org;
 DFORMPTR    DFormPtr;
 DFIELDPTR   DFieldPtr;
 char	     ResetMICE[2];
 int	     i;

 if ( ( Keyin >= KEY_F7 ) && ( Keyin <= KEY_F2 ) )  AbortCurrentCmd();

 switch ( Keyin ) {

   case  KEY_F1  : /*  "HElp USD3" command  */

		   MsgWnp = wn_def( 24, 0, 1, 80, LMESSAGE, BDR_NULLP );
		   wn_up( MsgWnp );
		   v_stpl( 0, 1, "Cursor keys to scroll, <ESC> to quit", MsgWnp );

		   wn_up( CmdHelpWnp );
		   mf_browse( CmdHelpWnp );
		   wn_dn( CmdHelpWnp );

		   wn_dn( MsgWnp );
		   wn_free( MsgWnp );

		   csr_plwn( VP[COMVP].Ptr );

		   break;

   case  KEY_F2  : /*  MICE-II "r" command and MICE-III "RESet" command  */

		   ResetMICE[0] = 'Y';
		   ResetMICE[1] = '\0';

		   DFormPtr  = fm_def( 10, 29, 5, 21, LWHI_RED, BDR_DLNP );
		   DFieldPtr = fld_def( 1, 3, "Reset MICE? ", FADJACENT, "!", F_STRING, ResetMICE, DFormPtr );
		   sf_attact( LRED_WHI, DFieldPtr );
		   sf_attinact( LWHI_RED, DFieldPtr );

/* USD-III V2.0x */sfm_opt( VERIFYEXIT|VERIFYQUIT, OFF, DFormPtr );

		   i = fm_proc( 0, DFormPtr );
		   fm_free( DFormPtr );
		   csr_plwn( VP[COMVP].Ptr );

		   if ( ( i != AC_QUIT ) && ( ResetMICE[0] == 'Y' ) ) {

		      if ( env.MICEGroup == MICE2 )  {
		      	resetMICE2();
                        RedrawFlag = ~MaskRedrawFlag;
                        UpdateVP();
		      } else {
		      	strcpy( FuncKeyBuf, "RES\r" );
              	ExecFuncKey();
              }
		   }
		   break;

   case  KEY_F3  : /*  "IStep" command  */

		   strcpy( FuncKeyBuf, "IS\r" );
		   ExecFuncKey();

		   break;

   case  KEY_F4  : /*  "IStep Over" command  */

		   strcpy( FuncKeyBuf, "IS O\r" );
		   ExecFuncKey();

		   break;

   case  KEY_F5  : /*  switches between BREAKPOINT, REGISTER, and TRACE viewports  */

		   if ( COMVPMax )  break;

		   if ( ActVP == TopVP ) {

		      VP[ActVP].Ptr->titleatt = LVPTITLEINACT;
		      ActVP = -1;
		   }

		   wn_dn( VP[TopVP].Ptr );

		   if ( TopVP == BREVP )  TopVP = REGVP;
		   else  if ( TopVP == REGVP )  TopVP = TRAVP;
		   else  TopVP = BREVP;

		   wn_up( VP[TopVP].Ptr );

		   if ( wn_isup( VP[STAVP].Ptr ) || wn_isup( VP[DATVP].Ptr ) ) {

		      v_bdr_csr_plwn( &LeftVPBdr, VP[CODVP].Ptr );
		      v_bdr_csr_plwn( &BottomVPBdr, VP[COMVP].Ptr );
		      if ( wn_isup( VP[STAVP].Ptr ) )  v_bdr_csr_plwn( &RightVPBdr, VP[STAVP].Ptr );
		      else  v_bdr_csr_plwn( &RightVPBdr, VP[DATVP].Ptr );

		   } else {

		      v_bdr_csr_plwn( &MiddleVPBdr, VP[CODVP].Ptr );
		      v_bdr_csr_plwn( &BottomVPBdr, VP[COMVP].Ptr );
		   }

		   if ( ActVP == -1 ) {

		      ActVP = TopVP;
		      VP[ActVP].Ptr->titleatt = LVPTITLEACT;
		      v_titleatt( NULLP, LVPTITLEACT, VP[ActVP].Ptr );
		   }

		   if	    ( ( TopVP == BREVP ) && ( ! ( MaskRedrawFlag & REDRAWBRE ) ) )
			    UpdateBREVP( 0 );
		   else  if ( ( TopVP == REGVP ) && ( ! ( MaskRedrawFlag & REDRAWREG ) ) )
			    UpdateREGVP();
		   else  if ( ( TopVP == TRAVP ) && ( ! ( MaskRedrawFlag & REDRAWTRA ) ) )
			    UpdateTRAVP( 0 );

/* USD-III 2.0x */
if ( (cursor_appear_or_not == 0) && ( csr_isvisible() == 1 ) )
	csr_hide();
else if ( (cursor_appear_or_not == 1) && ( csr_isvisible() == 0 ) )
	csr_show();
		   break;

   case  KEY_F6  : /*  toggles On/Off STACK viewport  */

		   if ( COMVPMax )  break;

		   if ( wn_isup( VP[STAVP].Ptr ) ) {

		      wn_dn( VP[STAVP].Ptr );
			 
		      VP[CODVP].Width = VP[REGVP].Width - VP[DATVP].Width;
		      wn_mod_no_pre_wn_unset( VP[CODVP].yOrg, VP[CODVP].xOrg, VP[CODVP].Height, VP[CODVP].Width, VP[CODVP].Ptr );
			 
		      v_bdr_csr_plwn( &BottomVPBdr, VP[COMVP].Ptr );

		      wn_up( VP[DATVP].Ptr );
		      if ( ! ( MaskRedrawFlag & REDRAWDAT ) )  UpdateDATVP();

		      if ( ActVP == STAVP ) {

			 VP[STAVP].Ptr->titleatt = LVPTITLEINACT;
			 ActVP = DATVP;
			 VP[DATVP].Ptr->titleatt = LVPTITLEACT;
			 v_titleatt( NULLP, LVPTITLEACT, VP[DATVP].Ptr );
		      }

		   } else  if ( wn_isup( VP[DATVP].Ptr ) ) {

		      wn_dn( VP[DATVP].Ptr );
			 
		      VP[CODVP].Width = VP[REGVP].Width;
		      sw_bdr( &MiddleVPBdr, VP[CODVP].Ptr );
		      wn_mod_no_pre_wn_unset( VP[CODVP].yOrg, VP[CODVP].xOrg, VP[CODVP].Height, VP[CODVP].Width, VP[CODVP].Ptr );
			 
		      v_bdr_csr_plwn( &BottomVPBdr, VP[COMVP].Ptr );

		      if ( ActVP == DATVP ) {

			 VP[DATVP].Ptr->titleatt = LVPTITLEINACT;
			 ActVP = CODVP;
			 VP[CODVP].Ptr->titleatt = LVPTITLEACT;
			 v_titleatt( NULLP, LVPTITLEACT, VP[CODVP].Ptr );
		      }

		   } else {

		      VP[CODVP].Width = VP[REGVP].Width - VP[STAVP].Width;
		      sw_bdr( &LeftVPBdr, VP[CODVP].Ptr );
		      wn_mod_no_pre_wn_unset( VP[CODVP].yOrg, VP[CODVP].xOrg, VP[CODVP].Height, VP[CODVP].Width, VP[CODVP].Ptr );

		      v_bdr_csr_plwn( &BottomVPBdr, VP[COMVP].Ptr );

		      wn_up( VP[STAVP].Ptr );
		      if ( ! ( MaskRedrawFlag & REDRAWSTA ) )  UpdateSTAVP();
		   }

/* USD-III 2.0x */
if ( (cursor_appear_or_not == 0) && ( csr_isvisible() == 1 ) )
	csr_hide();
else if ( (cursor_appear_or_not == 1) && ( csr_isvisible() == 0 ) )
	csr_show();
		   break;

   case  KEY_F7  : /*  toggles Maximum/Original size of COMMAND viewport  */

		   if ( ! COMVPMax ) {

		      COMVPMax = 1;

		      VP[ActVP].Ptr->titleatt = LVPTITLEINACT;

/*		      OldMaskRedrawFlag = MaskRedrawFlag;
		      MaskRedrawFlag = REDRAWBRE | REDRAWCOD | REDRAWREG |
			 	       REDRAWSTA | REDRAWTRA;
*/
		      wn_dn( VP[TopVP].Ptr );
		      wn_dn( VP[CODVP].Ptr );

		      if ( STAVPIsUp = wn_isup( VP[STAVP].Ptr ) )
			 wn_dn( VP[STAVP].Ptr );
		      else  if ( DATVPIsUp = wn_isup( VP[DATVP].Ptr ) )
			       wn_dn( VP[DATVP].Ptr );
			    
		      COMVPyOrg   = VP[COMVP].yOrg;
		      COMVPxOrg   = VP[COMVP].xOrg;
		      COMVPHeight = VP[COMVP].Height;
		      COMVPWidth  = VP[COMVP].Width;

		      sw_opt( WNECHO, OFF, VP[COMVP].Ptr );
		      sw_bdr( &SingleVPBdr, VP[COMVP].Ptr );
		      wn_mod_no_pre_wn_unset( VP[REGVP].yOrg, VP[REGVP].xOrg, 23, VP[REGVP].Width, VP[COMVP].Ptr );
/* USD-III 2.0x */ wn_mod_no_pre_wn_unset( VP[COMVP].yOrg=VP[REGVP].yOrg, VP[COMVP].xOrg=VP[REGVP].xOrg, VP[COMVP].Height=23, VP[REGVP].Width, VP[COMVP].Ptr );

		      if ( VP[COMVP].Ptr->r < (VP[COMVP].Ptr->row_org+20) ) {

			 sw_msorg( 0, VP[COMVP].Ptr->col_org, VP[COMVP].Ptr );
			 wn_msadj( VP[COMVP].Ptr );
			 csr_plwn( VP[COMVP].Ptr );
		      }

		      sw_opt( WNECHO, ON, VP[COMVP].Ptr );
		      wn_upd( VP[COMVP].Ptr );

		      ActVP = COMVP;
		      VP[COMVP].Ptr->titleatt = LVPTITLEACT;
		      v_titleatt( NULLP, LVPTITLEACT, VP[COMVP].Ptr );

		   } else {

			  COMVPMax = 0;

/*		      MaskRedrawFlag = OldMaskRedrawFlag;
*/
				if (MAXFlag) {
					MAXFlag = 0;
					CreateVP();
				 	InitVPDisplay();
		      } else {
					wn_up( VP[TopVP].Ptr );
			      wn_up( VP[CODVP].Ptr );
			      
			      sw_opt( WNECHO, OFF, VP[COMVP].Ptr );
		   	   sw_bdr( &BottomVPBdr, VP[COMVP].Ptr );
		      	wn_mod_no_pre_wn_unset( VP[COMVP].yOrg = COMVPyOrg,
					      VP[COMVP].xOrg = COMVPxOrg,
					      VP[COMVP].Height = COMVPHeight,
					      VP[COMVP].Width = COMVPWidth,
					      VP[COMVP].Ptr );
			      wn_msadj( VP[COMVP].Ptr );
			      csr_plwn( VP[COMVP].Ptr );
			      sw_opt( WNECHO, ON, VP[COMVP].Ptr );
		   	   wn_upd( VP[COMVP].Ptr );

			      if ( STAVPIsUp )
				 		wn_up( VP[STAVP].Ptr );
			      else  if ( DATVPIsUp )
				      wn_up( VP[DATVP].Ptr );

			      RedrawFlag = ~MaskRedrawFlag;
			      UpdateVP();
		   	}
			}

/* USD-III 2.0x */
if ( (cursor_appear_or_not == 0) && ( csr_isvisible() == 1 ) )
	csr_hide();
else if ( (cursor_appear_or_not == 1) && ( csr_isvisible() == 0 ) )
	csr_show();
		   break;

   case  KEY_F8  : /*  change "active viewport"  */

		   if ( COMVPMax )  break;

		   VP[ActVP].Ptr->titleatt = LVPTITLEINACT;
		   v_titleatt( NULLP, LVPTITLEINACT, VP[ActVP].Ptr );

		   if  ( ActVP == TopVP )  ActVP = CODVP;
		   else  if ( ActVP == CODVP )
			    if ( wn_isup( VP[STAVP].Ptr ) )  ActVP = STAVP;
			    else  if ( wn_isup( VP[DATVP].Ptr ) )  ActVP = DATVP;
			    else  ActVP = COMVP;
		   else  if ( ( ActVP == STAVP ) || ( ActVP == DATVP ) )  ActVP = COMVP;
		   else  ActVP = TopVP;

		   VP[ActVP].Ptr->titleatt = LVPTITLEACT;
		   v_titleatt( NULLP, LVPTITLEACT, VP[ActVP].Ptr );

		   break;

   case  KEY_F9  : if ( COMVPMax )  break;

		   if ( (ActVP==CODVP) || (ActVP==STAVP) || (ActVP==DATVP) )

		      if ( VP[COMVP].Height != 3 )
			 ZoomVP( BOTTOMSIDE, ZOOMDOWN );
		      else  ZoomVP( TOPSIDE, ZOOMUP );

		   else  if ( ActVP==COMVP )
			    ZoomVP( TOPSIDE, ZOOMUP );
			 else  if ( (ActVP==BREVP) || (ActVP==REGVP) || (ActVP==TRAVP) )
				  ZoomVP( BOTTOMSIDE, ZOOMDOWN );

		   GetCodeVPRange( PARTIAL );

		   break;

   case  KEY_F10 : if ( COMVPMax )  break;

		   if ( (ActVP==CODVP) || (ActVP==STAVP) || (ActVP==DATVP) )
		      ZoomVP( BOTTOMSIDE, ZOOMUP );
		   else  if ( ActVP==COMVP )  ZoomVP( TOPSIDE, ZOOMDOWN );
			 else  if ( (ActVP==BREVP) || (ActVP==REGVP) || (ActVP==TRAVP) )
				  ZoomVP( BOTTOMSIDE, ZOOMUP );

		   GetCodeVPRange( PARTIAL );

		   break;
   
   case  KEY_CF8 : if ( ActVP == COMVP ) {

		      COMVPr = VP[COMVP].Ptr->r;
		      COMVPc = VP[COMVP].Ptr->c;
		      COMVProw_org = VP[COMVP].Ptr->row_org;
		      COMVPcol_org = VP[COMVP].Ptr->col_org;
		   }

/* CORE 90.08.10 Change Arrow Charactor */

#ifdef  NEC_PC9801
		   if       ( ActVP == BREVP )  v_titleatt( "     \036\037     ", 0, VP[BREVP].Ptr );
		   else  if ( ActVP == CODVP )  v_titleatt( "  \036\037  ", 0, VP[CODVP].Ptr );
		   else  if ( ActVP == COMVP )  v_titleatt( "   \036\037    ", 0, VP[COMVP].Ptr );
		   else  if ( ActVP == REGVP )  v_titleatt( "    \036\037    ", 0, VP[REGVP].Ptr );
		   else  if ( ActVP == STAVP )  v_titleatt( "  \036\037   ", 0, VP[STAVP].Ptr );
		   else  if ( ActVP == DATVP )  v_titleatt( "  \036\037  ", 0, VP[DATVP].Ptr );
		   else	 v_titleatt( "  \036\037   ", 0, VP[TRAVP].Ptr );
#else /* NEC_PC9801 */
		   if       ( ActVP == BREVP )  v_titleatt( "     \030\031     ", 0, VP[BREVP].Ptr );
		   else  if ( ActVP == CODVP )  v_titleatt( " \030\031\033\032 ", 0, VP[CODVP].Ptr );
		   else  if ( ActVP == COMVP )  v_titleatt( "   \030\031    ", 0, VP[COMVP].Ptr );
		   else  if ( ActVP == REGVP )  v_titleatt( "    \030\031    ", 0, VP[REGVP].Ptr );
		   else  if ( ActVP == STAVP )  v_titleatt( "  \030\031   ", 0, VP[STAVP].Ptr );
		   else  if ( ActVP == DATVP )  v_titleatt( "  \030\031  ", 0, VP[DATVP].Ptr );
		   else	 v_titleatt( "  \030\031   ", 0, VP[TRAVP].Ptr );
#endif /* NEC_PC9801 */


		   MsgWnp = wn_def( 24, 0, 1, 80, LMESSAGE, BDR_NULLP );
		   wn_up( MsgWnp );
		   if ( ( ActVP == BREVP ) || ( ActVP == TRAVP ) || ( ActVP == CODVP ) )
		      v_stpl( 0, 1, "Cursor keys to scroll, <ESC> to quit, <Ctrl-PgUp/PgDn> for prev/next buffer", MsgWnp );
		   else
		      v_stpl( 0, 1, "Cursor keys to scroll, <ESC> to quit", MsgWnp );

/* USD-III 2.0x */ 
if ( ( VP[ActVP].Ptr->r < VP[ActVP].Ptr->row_org ) ||
     ( VP[ActVP].Ptr->r > VP[ActVP].Ptr->row_org + VP[ActVP].Height - 3 ) )
   VP[ActVP].Ptr->r = VP[ActVP].Ptr->row_org;

		   wn_browse( VP[ActVP].Ptr );

		   wn_dn( MsgWnp );
		   wn_free( MsgWnp );

		   if       ( ActVP == BREVP )  v_titleatt( " BREAKPOINT ", 0, VP[BREVP].Ptr );
		   else  if ( ActVP == CODVP )  v_titleatt( " CODE ", 0, VP[CODVP].Ptr );
		   else  if ( ActVP == COMVP )  v_titleatt( " COMMAND ", 0, VP[COMVP].Ptr );
		   else  if ( ActVP == REGVP )  v_titleatt( " REGISTER ", 0, VP[REGVP].Ptr );
		   else  if ( ActVP == STAVP )  v_titleatt( " STACK ", 0, VP[STAVP].Ptr );
		   else  if ( ActVP == DATVP )  v_titleatt( " DATA ", 0, VP[DATVP].Ptr );
		   else	 v_titleatt( " TRACE ", 0, VP[TRAVP].Ptr );

		   if ( ActVP == CODVP )  GetCodeVPRange( PARTIAL );

		   if ( ActVP == COMVP ) {

		      VP[COMVP].Ptr->r = COMVPr;
		      VP[COMVP].Ptr->c = COMVPc;
		      sw_msorg( COMVProw_org, COMVPcol_org, VP[COMVP].Ptr );
/* USD-III 2.0x */ wn_msadj( VP[COMVP].Ptr );
		      wn_upd( VP[COMVP].Ptr );
		   }

/* USD-III 2.0x */
		   if ( ActVP != COMVP ) {
		   	if ( cursor_appear_or_not==1 ) csr_plwn( VP[COMVP].Ptr );
		   	else if ( csr_isvisible() == 1 ) csr_hide();
		   } else {
			csr_plwn(VP[COMVP].Ptr);
		   	if ( cursor_appear_or_not==0 )
				cursor_appear_or_not==1;
		   }

		   break;
   
/* CORE 90.08.14 */

#ifndef  NEC_PC9801

   case  KEY_CF9 : if ( (++VP[ActVP].BackgrndColor) > YELCOLOR )
		      VP[ActVP].BackgrndColor = BLACOLOR;
		   else  if ( VP[ActVP].BackgrndColor == BROCOLOR )
			    VP[ActVP].BackgrndColor = CYACOLOR;

		   sw_att( COLOR( VP[ActVP].TextColor, VP[ActVP].BackgrndColor ), VP[ActVP].Ptr );
		   ms_clratt( COLOR( VP[ActVP].TextColor, VP[ActVP].BackgrndColor ), VP[ActVP].Buf );

		   v_chattrow( 0, 0,
			       ' ', COLOR( VP[ActVP].TextColor, VP[ActVP].BackgrndColor ),
			       ENDWN, ATT, VP[ActVP].Ptr );

		   if ( ActVP == CODVP )  MarkPC( CurrentPC );

		   break;
   
#endif

   case  KEY_CF10: if ( (++VP[ActVP].TextColor) > YELCOLOR )
		      VP[ActVP].TextColor = BLACOLOR;
		   else  if ( VP[ActVP].TextColor == BROCOLOR )
			    VP[ActVP].TextColor = CYACOLOR;

/* CORE 90.08.14 */

#ifdef  NEC_PC9801

		   if ( VP[ActVP].TextColor == BLACOLOR )  VP[ActVP].TextColor++;

#endif

		   sw_att( COLOR( VP[ActVP].TextColor, VP[ActVP].BackgrndColor ), VP[ActVP].Ptr );
		   ms_clratt( COLOR( VP[ActVP].TextColor, VP[ActVP].BackgrndColor ), VP[ActVP].Buf );

		   v_chattrow( 0, 0,
			       ' ', COLOR( VP[ActVP].TextColor, VP[ActVP].BackgrndColor ),
			       ENDWN, ATT, VP[ActVP].Ptr );

		   if ( ActVP == CODVP )  MarkPC( CurrentPC );

		   break;
   
   default	 : break;
 }

}  /*  of KEY_F1_F10()  */

/****************************************************************************/
/*  zoom viewport							    */
/****************************************************************************/

ZoomVP( Side, Direction )
int  Side, Direction;
{
/* USD-III 2.0x */ extern int cursor_appear_or_not;
 int  TmpActVP;

 /*  the sequences of redrawing viewports in processing zooming facility :
     ( BREVP | REGVP | TRAVP ) ---> CODVP ---> COMVP ---> ( STAVP | DATVP ) */

 switch ( ActVP ) {

   case BREVP :
   case REGVP :
   case TRAVP :	if ( Side == TOPSIDE )  /*  TOPSIDE, ZOOMUP or ZOOMDOWN  */

		   /*  bell()  */;

		else {  /*  BOTTOMSIDE, ZOOMUP or ZOOMDOWN  */

		   if ( Direction == ZOOMUP ) {	 /*  BOTTOMSIDE, ZOOMUP  */

		      if ( VP[ActVP].Height == 3 )  /*  bell()  */;

		      else {

			 wn_mod_no_pre_wn_unset( VP[BREVP].yOrg, VP[BREVP].xOrg, --VP[BREVP].Height, VP[BREVP].Width, VP[BREVP].Ptr );
			 wn_mod_no_pre_wn_unset( VP[REGVP].yOrg, VP[REGVP].xOrg, --VP[REGVP].Height, VP[REGVP].Width, VP[REGVP].Ptr );
			 wn_mod_no_pre_wn_unset( VP[TRAVP].yOrg, VP[TRAVP].xOrg, --VP[TRAVP].Height, VP[TRAVP].Width, VP[TRAVP].Ptr );

			 if ( --VP[CODVP].Ptr->row_org < 0 )  ++VP[CODVP].Ptr->row_org;
			 wn_mod_no_pre_wn_unset( --VP[CODVP].yOrg, VP[CODVP].xOrg, ++VP[CODVP].Height, VP[CODVP].Width, VP[CODVP].Ptr );

			 v_bdr_csr_plwn( &BottomVPBdr, VP[COMVP].Ptr );

			 if ( --VP[STAVP].Ptr->row_org < 0 )  ++VP[STAVP].Ptr->row_org;
			 wn_mod_no_pre_wn_unset( --VP[STAVP].yOrg, VP[STAVP].xOrg, ++VP[STAVP].Height, VP[STAVP].Width, VP[STAVP].Ptr );
			 if ( --VP[DATVP].Ptr->row_org < 0 )  ++VP[DATVP].Ptr->row_org;
			 wn_mod_no_pre_wn_unset( --VP[DATVP].yOrg, VP[DATVP].xOrg, ++VP[DATVP].Height, VP[DATVP].Width, VP[DATVP].Ptr );
		      }

		   } else {  /*  BOTTOMSIDE, ZOOMDOWN  */

		      if ( VP[CODVP].Height == 3 ) {

			 if ( VP[COMVP].Height != 3 ) {

			    TmpActVP = ActVP;
			    ActVP = CODVP;
			    ZoomVP( BOTTOMSIDE, ZOOMDOWN );
			    ActVP = TmpActVP;
			    ZoomVP( BOTTOMSIDE, ZOOMDOWN );

			 } else  /*  bell()  */ ;

		      } else {

			 wn_mod_no_pre_wn_unset( VP[BREVP].yOrg, VP[BREVP].xOrg, ++VP[BREVP].Height, VP[BREVP].Width, VP[BREVP].Ptr );
			 wn_mod_no_pre_wn_unset( VP[REGVP].yOrg, VP[REGVP].xOrg, ++VP[REGVP].Height, VP[REGVP].Width, VP[REGVP].Ptr );
			 wn_mod_no_pre_wn_unset( VP[TRAVP].yOrg, VP[TRAVP].xOrg, ++VP[TRAVP].Height, VP[TRAVP].Width, VP[TRAVP].Ptr );

			 ++VP[CODVP].Ptr->row_org;
			 wn_mod_no_pre_wn_unset( ++VP[CODVP].yOrg, VP[CODVP].xOrg, --VP[CODVP].Height, VP[CODVP].Width, VP[CODVP].Ptr );

			 v_bdr_csr_plwn( &BottomVPBdr, VP[COMVP].Ptr );

			 ++VP[STAVP].Ptr->row_org;
			 wn_mod_no_pre_wn_unset( ++VP[STAVP].yOrg, VP[STAVP].xOrg, --VP[STAVP].Height, VP[STAVP].Width, VP[STAVP].Ptr );
			 ++VP[DATVP].Ptr->row_org;
			 wn_mod_no_pre_wn_unset( ++VP[DATVP].yOrg, VP[DATVP].xOrg, --VP[DATVP].Height, VP[DATVP].Width, VP[DATVP].Ptr );
		      }
		   }
		}

		break;

   case CODVP :
   case STAVP :
   case DATVP : if ( Side == TOPSIDE ) {  /*  TOPSIDE, ZOOMUP or ZOOMDOWN  */

		   if ( Direction == ZOOMUP ) {	 /*  TOPSIDE, ZOOMUP  */

		      if ( VP[TopVP].Height == 3 )  /*  bell()  */;

		      else {

			 wn_mod_no_pre_wn_unset( VP[BREVP].yOrg, VP[BREVP].xOrg, --VP[BREVP].Height, VP[BREVP].Width, VP[BREVP].Ptr );
			 wn_mod_no_pre_wn_unset( VP[REGVP].yOrg, VP[REGVP].xOrg, --VP[REGVP].Height, VP[REGVP].Width, VP[REGVP].Ptr );
			 wn_mod_no_pre_wn_unset( VP[TRAVP].yOrg, VP[TRAVP].xOrg, --VP[TRAVP].Height, VP[TRAVP].Width, VP[TRAVP].Ptr );

			 if ( --VP[CODVP].Ptr->row_org < 0 )  ++VP[CODVP].Ptr->row_org;
			 wn_mod_no_pre_wn_unset( --VP[CODVP].yOrg, VP[CODVP].xOrg, ++VP[CODVP].Height, VP[CODVP].Width, VP[CODVP].Ptr );

			 v_bdr_csr_plwn( &BottomVPBdr, VP[COMVP].Ptr );

			 if ( --VP[STAVP].Ptr->row_org < 0 )  ++VP[STAVP].Ptr->row_org;
			 wn_mod_no_pre_wn_unset( --VP[STAVP].yOrg, VP[STAVP].xOrg, ++VP[STAVP].Height, VP[STAVP].Width, VP[STAVP].Ptr );
			 if ( --VP[DATVP].Ptr->row_org < 0 )  ++VP[DATVP].Ptr->row_org;
			 wn_mod_no_pre_wn_unset( --VP[DATVP].yOrg, VP[DATVP].xOrg, ++VP[DATVP].Height, VP[DATVP].Width, VP[DATVP].Ptr );
		      }

		   } else {  /*  TOPSIDE, ZOOMDOWN  */

		      if ( VP[CODVP].Height == 3 ) {

			 if ( VP[COMVP].Height != 3 ) {

			    ZoomVP( BOTTOMSIDE, ZOOMDOWN );
			    ZoomVP( TOPSIDE, ZOOMDOWN );

			 } else  /*  bell()  */ ;

		      } else {

			 wn_mod_no_pre_wn_unset( VP[BREVP].yOrg, VP[BREVP].xOrg, ++VP[BREVP].Height, VP[BREVP].Width, VP[BREVP].Ptr );
			 wn_mod_no_pre_wn_unset( VP[REGVP].yOrg, VP[REGVP].xOrg, ++VP[REGVP].Height, VP[REGVP].Width, VP[REGVP].Ptr );
			 wn_mod_no_pre_wn_unset( VP[TRAVP].yOrg, VP[TRAVP].xOrg, ++VP[TRAVP].Height, VP[TRAVP].Width, VP[TRAVP].Ptr );

			 ++VP[CODVP].Ptr->row_org;
			 wn_mod_no_pre_wn_unset( ++VP[CODVP].yOrg, VP[CODVP].xOrg, --VP[CODVP].Height, VP[CODVP].Width, VP[CODVP].Ptr );

			 v_bdr_csr_plwn( &BottomVPBdr, VP[COMVP].Ptr );

			 ++VP[STAVP].Ptr->row_org;
			 wn_mod_no_pre_wn_unset( ++VP[STAVP].yOrg, VP[STAVP].xOrg, --VP[STAVP].Height, VP[STAVP].Width, VP[STAVP].Ptr );
			 ++VP[DATVP].Ptr->row_org;
			 wn_mod_no_pre_wn_unset( ++VP[DATVP].yOrg, VP[DATVP].xOrg, --VP[DATVP].Height, VP[DATVP].Width, VP[DATVP].Ptr );
		      }
		   }

		} else {  /*  BOTTOMSIDE, ZOOMUP or ZOOMDOWN  */

		   if ( Direction == ZOOMUP ) {	 /*  BOTTOMSIDE, ZOOMUP  */

		      if ( VP[CODVP].Height == 3 ) {

			 if ( VP[TopVP].Height != 3 ) {

			    ZoomVP( TOPSIDE, ZOOMUP );
			    ZoomVP( BOTTOMSIDE, ZOOMUP );

			 } else  /*  bell()  */ ;

		      } else {

			 wn_mod_no_pre_wn_unset( VP[CODVP].yOrg, VP[CODVP].xOrg, --VP[CODVP].Height, VP[CODVP].Width, VP[CODVP].Ptr );

			 if ( --VP[COMVP].Ptr->row_org < 0 )  ++VP[COMVP].Ptr->row_org;
			 wn_mod_no_pre_wn_unset( --VP[COMVP].yOrg, VP[COMVP].xOrg, ++VP[COMVP].Height, VP[COMVP].Width, VP[COMVP].Ptr );

			 wn_mod_no_pre_wn_unset( VP[STAVP].yOrg, VP[STAVP].xOrg, --VP[STAVP].Height, VP[STAVP].Width, VP[STAVP].Ptr );
			 wn_mod_no_pre_wn_unset( VP[DATVP].yOrg, VP[DATVP].xOrg, --VP[DATVP].Height, VP[DATVP].Width, VP[DATVP].Ptr );
		      }

		   } else {  /*  BOTTOMSIDE, ZOOMDOWN  */

		      if ( VP[COMVP].Height == 3 )  /*  bell()  */;

		      else {

			 wn_mod_no_pre_wn_unset( VP[CODVP].yOrg, VP[CODVP].xOrg, ++VP[CODVP].Height, VP[CODVP].Width, VP[CODVP].Ptr );

			 if ( ++VP[COMVP].Ptr->row_org > VP[COMVP].Ptr->r )  --VP[COMVP].Ptr->row_org;
			 wn_mod_no_pre_wn_unset( ++VP[COMVP].yOrg, VP[COMVP].xOrg, --VP[COMVP].Height, VP[COMVP].Width, VP[COMVP].Ptr );

			 wn_mod_no_pre_wn_unset( VP[STAVP].yOrg, VP[STAVP].xOrg, ++VP[STAVP].Height, VP[STAVP].Width, VP[STAVP].Ptr );
			 wn_mod_no_pre_wn_unset( VP[DATVP].yOrg, VP[DATVP].xOrg, ++VP[DATVP].Height, VP[DATVP].Width, VP[DATVP].Ptr );
		      }
		   }
		}

		break;

   case COMVP :	if ( Side == TOPSIDE ) {  /*  TOPSIDE, ZOOMUP or ZOOMDOWN  */

		   if ( Direction == ZOOMUP ) {	 /*  TOPSIDE, ZOOMUP  */

		      if ( VP[CODVP].Height == 3 ) {

			 if ( VP[TopVP].Height != 3 ) {

			    TmpActVP = ActVP;
			    ActVP = CODVP;
			    ZoomVP( TOPSIDE, ZOOMUP );
			    ActVP = TmpActVP;
			    ZoomVP( TOPSIDE, ZOOMUP );

			 } else  /*  bell()  */ ;

		      } else {

			 wn_mod_no_pre_wn_unset( VP[CODVP].yOrg, VP[CODVP].xOrg, --VP[CODVP].Height, VP[CODVP].Width, VP[CODVP].Ptr );

			 if ( --VP[COMVP].Ptr->row_org < 0 )  ++VP[COMVP].Ptr->row_org;
			 wn_mod_no_pre_wn_unset( --VP[COMVP].yOrg, VP[COMVP].xOrg, ++VP[COMVP].Height, VP[COMVP].Width, VP[COMVP].Ptr );

			 wn_mod_no_pre_wn_unset( VP[STAVP].yOrg, VP[STAVP].xOrg, --VP[STAVP].Height, VP[STAVP].Width, VP[STAVP].Ptr );
			 wn_mod_no_pre_wn_unset( VP[DATVP].yOrg, VP[DATVP].xOrg, --VP[DATVP].Height, VP[DATVP].Width, VP[DATVP].Ptr );
		      }

		   } else {  /*  TOPSIDE, ZOOMDOWN  */

		      if ( VP[COMVP].Height == 3 )  /*  bell()  */;

		      else {

			 wn_mod_no_pre_wn_unset( VP[CODVP].yOrg, VP[CODVP].xOrg, ++VP[CODVP].Height, VP[CODVP].Width, VP[CODVP].Ptr );

			 if ( ++VP[COMVP].Ptr->row_org > VP[COMVP].Ptr->r )  --VP[COMVP].Ptr->row_org;
			 wn_mod_no_pre_wn_unset( ++VP[COMVP].yOrg, VP[COMVP].xOrg, --VP[COMVP].Height, VP[COMVP].Width, VP[COMVP].Ptr );

			 wn_mod_no_pre_wn_unset( VP[STAVP].yOrg, VP[STAVP].xOrg, ++VP[STAVP].Height, VP[STAVP].Width, VP[STAVP].Ptr );
			 wn_mod_no_pre_wn_unset( VP[DATVP].yOrg, VP[DATVP].xOrg, ++VP[DATVP].Height, VP[DATVP].Width, VP[DATVP].Ptr );
		      }
		   }

		} else  /*  BOTTOMSIDE, ZOOMUP or ZOOMDOWN  */

		   /*  bell()  */;

 }  /*  of switch ( ActVP )  */

/* USD-III 2.0x */
if ( (cursor_appear_or_not == 0) && ( csr_isvisible() == 1 ) )
	csr_hide();
else if ( (cursor_appear_or_not == 1) && ( csr_isvisible() == 0 ) )
	csr_show();

}  /*  of ZoomVP()  */

/****************************************************************************/
/*									    */
/****************************************************************************/

KEY_UP_DN()
{
 AbortCurrentCmd();

 FuncKeyBuf[0] = '\0';

 if ( Keyin == KEY_UP ) {  /*  see last command  */

    if ( his_flag == 0 )  his_flag = out_flag + 1;
    out_flag = 0;
    history(2);

    ExecFuncKey();

 } else {  /*  see next command  */

    if ( his_flag == 0 )  his_flag = out_flag + 1;
    out_flag = 0;
    history(3);

    ExecFuncKey();
 }

}  /*  of KEY_UP_DN()  */

/****************************************************************************/
/*									    */
/****************************************************************************/

KEY_AF_AH()
{
/* USD-III 2.0x */ extern int current_menubar_item, next_menubar_item, next_menubar_item, need_next_mn_rd;
/* USD-III 2.0x */ extern int current_status, current_x, current_y;
 WINDOWPTR   MsgWnp;
 int	     i;

 if	  ( Keyin ==  KEY_AF )  i = 0;
 else  if ( Keyin ==  KEY_AS )  i = 1;
 else  if ( Keyin ==  KEY_AM )  i = 2;
 else  if ( Keyin ==  KEY_AE )  i = 3;
 else  if ( Keyin ==  KEY_AT )  i = 4;
 else  if ( Keyin ==  KEY_AY )  i = 5;
 else  if ( Keyin ==  KEY_AO )  i = 6;
 else  if ( Keyin ==  KEY_AP )  i = 7;
 else  if ( Keyin ==  KEY_AL )  i = 8;
 else  return;

 AbortCurrentCmd();

 DlgBuf[0] = '\0';
 ExecDlgFlag = 0;
 Entry_Duration_Time_Cover_Lsa = 0;

 MsgWnp = wn_def( 24, 0, 1, 80, LMESSAGE, BDR_NULLP );
 wn_up( MsgWnp );
 v_stpl( 0, 1, "<F1> for help, Cursor keys to move, <ESC> to quit, <CR> to select", MsgWnp );

/* USD-III V2.0x */ need_next_mn_rd = 0;

do {

 current_menubar_item = i;

 mn_rd( i, MenuBar );

 if ( !need_next_mn_rd ) break;
 else
    if ( need_next_mn_rd == 1 ) {
       i = next_menubar_item;
       need_next_mn_rd = 0;
    } else {
	ShowCursor();
	do {
		ButtonStatusAndMousePosition(&current_status, &current_x, &current_y);
		if (current_status != 1) goto do_wn_dn;
		current_x /= 8;
		current_y /= 8;
		i = MenubarItemNo(current_x, current_y);
		if ( ( i >= 0 ) && ( i <= 8 ) ) {
			HideCursor();
			break;
		}
	} while ( 1 );
    }
} while (1);

do_wn_dn:

 wn_dn( MsgWnp );
 wn_free( MsgWnp );

 if ( ExecDlgFlag )  ExecDlg();

 else  if ( Entry_Duration_Time_Cover_Lsa == 5 )  MN_L_LSA1();

       else  if ( Entry_Duration_Time_Cover_Lsa != 0 ) {

         	if ( ( spa_support_or_not == 0 ) && ( Entry_Duration_Time_Cover_Lsa != 4 ) ) {

         	   prn_ferr( 75 );
         	   d_o_prompt();
         	   InitNewCmd();

         	} else {

         	   if	    ( Entry_Duration_Time_Cover_Lsa == 1 )  MN_P_ENTRY1();
         	   else  if ( Entry_Duration_Time_Cover_Lsa == 2 )  MN_P_DURATION1();
         	   else  if ( Entry_Duration_Time_Cover_Lsa == 3 )  MN_P_TIME1();
         	   else  if ( Entry_Duration_Time_Cover_Lsa == 4 )  MN_P_COVERAGE1();
         	}
	     }

 csr_plwn( VP[COMVP].Ptr );

}  /*  of KEY_AF_AH()  */

/****************************************************************************/
/*									    */
/****************************************************************************/

KEY_SF1_SF10()
{
 int  i;

 AbortCurrentCmd();

 strcpy( FuncKeyBuf, SoftKeyBuf[ KEY_SF1 - Keyin ] );
 strcat( FuncKeyBuf, "\r" );

 /*  change ';' to CR  */

 i = 0;

 while ( FuncKeyBuf[i] != '\0' ) {

   if ( FuncKeyBuf[i] == '\073' )  FuncKeyBuf[i] = '\015';
   i++;
 }

 ExecFuncKey();

}  /*  of KEY_SF1_SF10()  */

/****************************************************************************/
/*									    */
/****************************************************************************/

KEY_DEFAULT()
{
 int   OldCmdBufIdx;
 int   ErrorCode;
 int   i, j, k;
 char  c;

 OldCmdBufIdx = CmdBufIdx;

 /*  send user's keyin to the MICE  */

 if ( ( ErrorCode = MICEEchoKeyin() ) < 0 ) { /*  display user's keyin  */

    VPOut = COMVP;
    EraseCMDCURSOR();

    if ( echo_flag == 1 ) {

       if ( ( i = CmdBufIdx - OldCmdBufIdx ) < 0 ) {  /*  user pressed the BS or DEL key  */

	  for ( j = 1; j <= (-1) * i; j++ )  DisplayCh( (char) BS );

	  if ( CmdArguChk && ( CmdBufIdx < CmdArguChkIdx ) ) {

	     CmdArguChk = 0;
	     CmdArguChkIdx = -1;
	     DisplayCmdWord( CmdWordChkIdx );

	  } else  if ( CmdWordChk && ( CmdBufIdx < CmdWordChkIdx ) ) {

		     CmdWordChk = 0;
		     CmdWordChkIdx = -1;
		     wn_dn( CmdHelpVP );
		  }

       } else  if ( i > 0 ) {

		  DisplayStr( &( CmdBuf[ OldCmdBufIdx+1 ] ) );

		  if ( (!CmdWordChk) && ( Keyin != CR ) ) {

	  	     for ( j = OldCmdBufIdx + 1; j <= CmdBufIdx; j++ )
		       if ( CmdBuf[j] != SP ) { DisplayCmdWord( j ); break; }
		  }
	       }

       if ( ( Keyin == SP ) && ( CmdWordChk ) && ( !CmdArguChk ) )
          k=DisplayCmdArgu( CmdBufIdx );  ////
          if(k==29) Keyin=CR;             ////
       if ( Keyin != CR )  DisplayCMDCURSOR();
    }

    if ( Keyin == CR ) {  /*  execute the command  */

       in_a_cmd = 1;
       WmCharCR( Parser() );          ////bug here
       InitNewCmd();
       DisplayCMDCURSOR();
       UpdateVP();
       in_a_cmd = 0;

    } else  if ( Keyin == ESC )  InitNewCmd();  /* abort the command */

 } else {  /*  print error messages  */

    LogOneCmdLine(CmdKeyinBuf);

    if ( ErrorCode == 100 ) {  /*  turn MICE power off, then turn it on  */

       VPOut = COMVP;
       EraseCMDCURSOR();
       while ( ( c = receive() ) != HAND_SHAKE )  if ( c )  DisplayCh(c);
       send_ESC();
       InitNewCmd();
       KbdBuf[ KbdBufIdx = 0 ] = '\0';
       KbdBufLastIdx = -1;
       DisplayCMDCURSOR();
       RedrawFlag = REDRAWREG | REDRAWSTA | REDRAWCOD | REDRAWTRA | REDRAWDAT;
       UpdateVP();

    } else  if ( ErrorCode == 99 ) {  /*  for MICE-II command line limitation: 60 characters  */

	       usd_prn_ferr = 1;
	       EraseCMDCURSOR();
	       DisplayStr( &( CmdBuf[ OldCmdBufIdx+1 ] ) );
	       InitNewCmd();
	       DisplayCMDCURSOR();

	    } else {

	       EraseCMDCURSOR();
	       prn_ferr( ErrorCode );
	       InitNewCmd();
	       d_o_prompt();
	    }
 }

}  /*  of KEY_DEFAULT()  */

/****************************************************************************/
/*  execute commands generated from the function key or the softkey	    */
/****************************************************************************/

ExecFuncKey()
{
 strcpy( KbdBuf, FuncKeyBuf );
 KbdBufIdx = 0; 
 KbdBufLastIdx = strlen( KbdBuf ) - 1; 

}  /*  of ExecFuncKey()  */

/****************************************************************************/
/*  execute commands generated from the dialog-box or the menu-item	    */
/****************************************************************************/

ExecDlg()
{
 strcpy( KbdBuf, DlgBuf );
 KbdBufIdx = 0; 
 KbdBufLastIdx = strlen( KbdBuf ) - 1; 

}  /*  of ExecDlg()  */

/****************************************************************************/
/*									    */
/****************************************************************************/

AbortCurrentCmd()
{
 if ( CmdBufIdx >= 0 ) {  /*  abort current command  */

    send_ESC();
    InitNewCmd();

    /*  simulate d_o_prompt()  */

    VPOut = COMVP;
    DisplayCh( (char) CR );
    v_stcpy( SpaceLine, TO_WN, ENDROW, VP[VPOut].Ptr );
    DisplayCh( (char) CR );
    DisplayStr( prompt );
    DisplayCMDCURSOR();
 }

}  /*  of AbortCurrentCmd()  */
