
/***************************************************************************
**
**    $Header:   D:/USD3V/LOG/SRC/LIB2.C__   1.2   12 Jun 1996 08:43:40   ZJRD  $
**
**    $Log:   D:/USD3V/LOG/SRC/LIB2.C__  $
** 
**    Rev 1.2   12 Jun 1996 08:43:40   ZJRD
** USD3 Version 2.7
** 
**    Rev 1.1   24 May 1996 09:42:34   ZJRD
** No change.
** 
**    Rev 1.0   11 Dec 1995 13:51:50   ZJRD
** Initial revision.
** 
****************************************************************************/
/*--------------------------------------------------------------------------*/
/*  lib2.c								    */
/*--------------------------------------------------------------------------*/


#include  "system.h"
#include  "menu.h"
#include  "usd3.h"
#include  "gblext.h"
#include  "oldext.h"
#include  "usym1.h"
#include  "usym3.h"
#include  "cpucode.h"
#include  "funcext.h"
#include  <signal.h>

#define PC_ONLY 0
#define NO_PC	2
#define EMPTY	20

extern int tick_count;
extern int  donotlog;
extern int FPORT;
extern int cmdfile_end_flag;

more_proc()
{
 v_stcpy( LastCOMVPLine, FROM_WN, ROW, VP[COMVP].Ptr );
 more_encounter = ( strnicmp(LastCOMVPLine,"[ More ]",8) == 0 ) ? 1 : 0;
}

send_CR()
{
	char c;
	send(CR);
	while((c=receive())!=CR && c!=LF) ;
	while((c=receive())==CR || c==LF || !c) ;
	d_prntf("\n\r");
	return(c);
}

getc_mpds()
{
	char c;
	if(cmdfile_flag) {
			if(cmd_file(-1) != END) {
				c = CmdFileBuf[0];
				return(c);
			} else end_cmd_file();
	}
	c = get_key();
	return(c);
}

/****************************************************************************/
/*  wait a keyboard input						    */
/****************************************************************************/

/* USD-III V2.0x */
#define PULLDOWN	1
#define DIALOG		2
extern int pulldown_or_dialog;
extern int mouse_have_been_pressed, mouse_not_released;
extern int special_dialog;
/* USD-III V2.0x */

get_key()
{
//  char  cmd0 = cmd_argv[0][0];          /* DOS/16M */
    char  cmd0;                           /* DOS/16M */
    int   Keyin;

   if (cmd_argc == 0) cmd0 = '\0';    // DOS/16M 
   else cmd0 = cmd_argv[0][0];

/* USD-III V2.0x */ ShowCursor();
 do {
/* USD-III V2.0x */ pulldown_or_dialog = PULLDOWN;
/* USD-III V2.0x */ special_dialog = 0;
     Keyin = 0;
     mouse_have_been_pressed = mouse_not_released = 0;
   	 if (ki_chk() != 0)	Keyin = ki();
     else   MouseSVR(&Keyin);

     if ( ( Keyin == 3 ) || ( Keyin == -1 ) ) { /*  CTRL-C or CTRL-BREAK  */
/* USD-III V2.0x */HideCursor();
/* USD-III V2.0x */pulldown_or_dialog = DIALOG;
/* USD-III V2.0x */special_dialog = 1;
	if ( AbortUSD3() ) {
	   DestroyVP();
	   DestroyMenu();
	   WmClose();
	   FreeGbl();
	   vs_clr();
	   USD3vid_setmode( OldVideoMode );
	   exit_vv();
	   exit(-1);

	} else {
/* USD-III V2.0x */ShowCursor();
/* USD-III V2.0x */pulldown_or_dialog = PULLDOWN;
/* USD-III V2.0x */special_dialog = 0;
           continue;
        }
     }
     else if (Keyin != 0) {
/* USD-III V2.0x */HideCursor();
           if ( ((Keyin>='a')&&(Keyin<='z')) && cmd0!='A' && cmd0!='U' && !in_symbol && !define_byte )
	      return( USDtoupper( Keyin ) );
	   else  return( Keyin );
     }

 } while ( 1 );

}  /*  of get_key()  */

/****************************************************************************/
/*  check keyboard input and get it if it existed			    */
/****************************************************************************/

chk_kb()
{
 int  Keyin;

//                     02-12-1991, Modified by Harris, for Mouse Functions
// if ( ki_chk() ) {
//
//    Keyin = ki();
//
//    if ( ( Keyin == 3 ) || ( Keyin == -1 ) )  /*  CTRL-C or CTRL-BREAK  */
//
//       if ( AbortUSD3() ) {
//
//	  DestroyVP();
//	  DestroyMenu();
//	  WmClose();
//	  FreeGbl();
//	  vs_clr();
//	  USD3vid_setmode( OldVideoMode );
//	  exit_vv();
//	  exit(-1);
//
//       } else  return( 0 );
//
//    else  return( Keyin );
//
// } else  return( 0 );

	Keyin = 0;
	if ( ki_chk() )	Keyin = ki();
	else		ChkMouseLBAndEsc(&Keyin);/*MouseSVR(&Keyin);*/
	if ( ( Keyin == 3 ) || ( Keyin == -1 ) ) {
		pulldown_or_dialog = DIALOG;
		special_dialog = 1;
		if ( AbortUSD3() ) {
			DestroyVP();
			DestroyMenu();
			WmClose();
			FreeGbl();
			vs_clr();
			USD3vid_setmode( OldVideoMode );
			exit_vv();
			exit(-1);
		} else {
			pulldown_or_dialog = PULLDOWN;
			special_dialog = 0;
			return( 0 );
		}
	} else return( Keyin );

}  /*  of chk_kb()  */

/****************************************************************************/
/*									    */
/****************************************************************************/

chk_hlt()
{
	char c=0;
//	char cmd0=cmd_argv[0][0];  // DOS/16M
	char cmd0;

   if (cmd_argc == 0) cmd0 = '\0';    // DOS/16M 
   else cmd0 = cmd_argv[0][0];

RE_CHK_KB:

	disableRS232();

	if(c = chk_kb())
		do {
			switch(c) {
				case CTRL_S:
					while((c=get_key())!=CTRL_Q && c!=ESC);
				case CTRL_Q:
				case ESC:
					if (cmdfile_flag) cmdfile_end_flag = 1;
					goto RET;
				case SP:
					if((cmd0=='S' || cmd0=='C') && cmdfile_flag == 0) {
						fast_step = 1 - fast_step;
						if(fast_step) goto RET;
						else break;
					}
				default:
					if ( (++KbdBufLastIdx) < CMDBUFSIZE ) {

					   KbdBuf[ KbdBufLastIdx ] = c;
					   KbdBuf[ KbdBufLastIdx+1 ] = '\0';
					} else  --KbdBufLastIdx;

					c = 0;
					goto RE_CHK_KB;
			}
			c = get_key();
		} while(1) ;
RET:
	enableRS232();
	return(c);

}  /*  of chk_hlt()  */

DisplayCharAndShowCursor(c)
{
	EraseCMDCURSOR();
	d_putc(c);
	DisplayCMDCURSOR();
}

get_str2(buf,len)
char *buf;
int len;
{
	int r=END, r1;
	char *ptr11, c1;
	in_get_str2 = 1;
	if(cmdfile_flag == 1) {
		while((r=cmd_file(-1))!=END && (r1=CMDFILEget_str2(CmdFileBuf,len))==(END+10));
	}
	if(r == END) r = STDINget_str2(buf,len);
	else {
		if(!r1) {
			if(CmdFileBuf[0] == ESC) r = ESC;
			else {
				get_str2_BuftoUpper(CmdFileBuf);
				d_putc(LF);
				strcpy(buf,CmdFileBuf);
			}
		} else r = r1;
	}
	if(cmd_flag) {
		if(r) {
			if(r == ESC) logb('\\');
			else logb(r);
		} else {
			ptr11 = (char *)buf;
			while((c1=*ptr11++)!=CR && c1!=LF) logb(c1);
		}
		logb(CR);
		logb(LF);
	}
	in_get_str2 = 0;
	return(r);
}

CMDFILEget_str2(buf,len)
char *buf;
int len;
{
	char *ptr, *ptr11, *ptr22, a, c, flag[100];
	int i, j, in_def=0, in_sym=0;
	char cmd0=cmd_argv[0][0];
	more_proc();
	if(cmd0=='S' || cmd0=='C' || (env.Mmodel<MICE_3_BOUND&&cmd0=='I')) {
		c = buf[0];
		if(c==CR || c==LF || c==ESC || (cmd0=='S'&&index(env.step,c))) goto RET1;
		else c = END + 10;
	} else {
		ptr = flag;
		*ptr = in_sym;
		ptr11 = (char *) buf;
		while(c = *ptr11++) {
			switch(c) {
				case SP:
/* 10-5-87 */				if(R_2_386 && env.Mmodel==25) continue;
					if(more_encounter==1 || R_2_386) goto RET1;
					if(in_sym) in_sym = 0;
					*ptr++ = in_sym;
					d_putc(c);
					break;
				case CR:
					if(more_encounter == 0) {
//						d_putc(CR);
if(usd_strncmp(cmd_argv[0],"DOUBLE",3) && usd_strncmp(cmd_argv[0],"FLOAT",2) &&
(env.Mmodel>=MICE_3_BOUND || (cmd0!='M'&&cmd0!='R'&&cmd0!='X'))) {
	if((env.Mmodel!=HC6811 && env.Mmodel!=I_8048 && env.Mmodel!=I_8050) || CmdSendBuf[0]!='r' ) d_putc(LF);
}
						c = 0;
					}
					goto RET1;
				case LF:
					if(more_encounter == 0) {
						if(usd_strncmp(cmd_argv[0],"DOUBLE",3) && usd_strncmp(cmd_argv[0],"FLOAT",2)) {
							d_putc(c);
							d_putc(CR);
						}
						c = 0;
					} else c = CR;
				case ESC:
					goto RET1;
				default:
					if(!R_2_386 && (c>0x20&&c<=0x7e&&more_encounter!=1)) {
						if(c == DEFINE_BYTE && !in_sym){
							in_def = 1 - in_def;
							*ptr++ = 0;
						}
						if(c == NAME && !in_def) {
							in_sym = 1;
							*ptr++ = 0;
						}
						if(!isalnum(c) && c!='_') in_sym = 0;
						if(!in_sym && !in_def) c=USDtoupper(c);
						*ptr++ = in_sym;
						d_putc(c);
					}
			}
		}
		c = END + 10;
	}
RET1:
	return(c);
}

STDINget_str2(buf,len)
char *buf;
int len;
{
	char *ptr, *ptr11, a, c, flag[100];
	int i, j, in_def=0, in_sym=0;
	char cmd0=cmd_argv[0][0];
	more_proc();
	DisplayCMDCURSOR();
/* 4-13-87 prevent the input data from user when MICE-II 'I' command */
	if(cmd0=='S' || cmd0=='C' || (env.Mmodel<MICE_3_BOUND&&cmd0=='I')) {
		while(1) {
/* 4-22-87 prevent input from user when MICE-II 'I' command (in stdin mode )
			but get key by getc_mpds()        (in cmd_file mode)
***			if(!(c=chk_kb()) && (cmd0=='S' || cmd0=='C')) { }       ***/
			if(!(c=chk_kb()) && (cmd0=='S' || cmd0=='C' || cmd0=='I')) {
				c = (fast_step) ? CR : getc_mpds();
			}
			switch(c) {
				case SP:
					if(cmd0=='S' || cmd0=='C') {
						fast_step = 1 - fast_step;
						if(fast_step == 0) break;
						c = CR;
					} else break;
				case LF:
				case CR:
				case ESC:
					goto RET1;
				case CTRL_S:
					while((c=get_key())!=CTRL_Q && c!=ESC) ;
					if(c==ESC) {
						goto RET1;
					}
				case CTRL_Q:
					if(fast_step) {
						c = CR;
						goto RET1;
					} else break;
				default:
					if(cmd0 == 'S') {

						if (index(env.step,c)!=NULL) goto RET1;
/****************************			ptr11 = env.step;
						while(*ptr11++) {
							if(c == *ptr11) {
								goto RET1;
							}
						}
****************************/
					}
					break;
			}
		}
	} else {
		ptr = flag;
		*ptr = in_sym;
		ptr11 = (char *) buf;
		*ptr11 = CR;
		while(1) {
			switch(c=getc_mpds()) {
				case ESC:
					if(env.Mmodel==HC6811 && (cmd0=='X'|| CmdSendBuf[0]=='r')) break;
					goto RET1;
				case BS:
					if(!R_2_386 && ptr11 != buf) {
						ptr--;
						ptr11--;
						DisplayCharAndShowCursor(BS);
						in_sym = *ptr;
						if(*ptr11 == DEFINE_BYTE) in_def = 1 - in_def;
					}
					continue;
				case CTRL_S:
					if (R_2_386) continue;
					while((c=get_key())!=CTRL_Q && c!=ESC) ;
					if(c==ESC) goto RET1;
				case CTRL_Q:
					continue;
				case SP:
/* 10-5-87 */				if(R_2_386 && env.Mmodel==25) continue;
					if(more_encounter==1 || R_2_386) goto RET1;
					if(in_sym) in_sym = 0;
					*ptr++ = in_sym;
					*ptr11++ = c;
					DisplayCharAndShowCursor(c);
					break;
				case CR:
					if(more_encounter == 0) {
						*ptr11++=c;
/**************** debug *********************/	*ptr11 = '\0';
/********************************** 5-04-89 	DisplayCharAndShowCursor(c); */
/**************** 5-22-89 */			EraseCMDCURSOR();
/********************************** 5-04-89 */	d_putc(CR);
if(usd_strncmp(cmd_argv[0],"DOUBLE",3) && usd_strncmp(cmd_argv[0],"FLOAT",2) &&
(env.Mmodel>=MICE_3_BOUND || (cmd0!='M'&&cmd0!='R'&&cmd0!='X'))) {
	if((env.Mmodel!=HC6811 && env.Mmodel!=I_8048 && env.Mmodel!=I_8050) || CmdSendBuf[0]!='r' ) d_putc(LF);
}
						c = 0;
					}
					goto RET1;
				case LF:
					if(more_encounter == 0) {
						*ptr11++=c;
/**************** debug *********************/	*ptr11 = '\0';
/**************** 5-22-89 */			EraseCMDCURSOR();
						if(usd_strncmp(cmd_argv[0],"DOUBLE",3) && usd_strncmp(cmd_argv[0],"FLOAT",2)) {
							DisplayCharAndShowCursor(c);
							DisplayCharAndShowCursor(CR);
						}
						c = 0;
					} else c = CR;
					goto RET1;
				default:
					if(!R_2_386 && (c>0x20&&c<=0x7e&&more_encounter!=1)) {
						if(c == DEFINE_BYTE && !in_sym){
							in_def = 1 - in_def;
							*ptr++ = 0;
						}
						if(c == NAME && !in_def) {
							in_sym = 1;
							*ptr++ = 0;
						}
						if(!isalnum(c) && c!='_') in_sym = 0;
						if(!in_sym && !in_def) c=USDtoupper(c);
						*ptr++ = in_sym;
						if((ptr11-buf) >=len) {
							*ptr11++ = c;
							*ptr11++ = CR;
							DisplayCharAndShowCursor(c);
/**************** 5-22-89 */				EraseCMDCURSOR();
							d_prntf("\n\r");
							c = 0;
							goto RET1;
						} else {
							*ptr11++ = c;
							DisplayCharAndShowCursor(c);
						}
					}
			}
		}
	}
RET1:
	EraseCMDCURSOR();
	return(c);
}

get_str2_BuftoUpper(s)
char *s;
{
	char c, *p= s - 1;
	int in_sym=0, in_def=0;
	while(c = *++p) {
		if(c == DEFINE_BYTE && !in_sym) in_def = 1 - in_def;
		else if(c == NAME && !in_def) in_sym = 1;
		else if(!isalnum(c) && c!='_') in_sym = 0;
		*p = (!in_sym && !in_def) ? USDtoupper(c) : c;
	}
}

r_in_define_byte(p)
char *p;
{
	char c;
	int flag = 0;
	if(env.Mmodel < MICE_3_BOUND) {
		while((c= *p++) != CR && c != LF) {
			if(c == DEFINE_BYTE) flag = 1 - flag;
			if(c == 'r' && flag) return(1);
		}
	}
	return(0);
}

save_curs(rp,cp)
int *rp, *cp;
{
	*rp = VP[COMVP].Ptr->r;
	*cp = VP[COMVP].Ptr->c;
}

set_cur(r,c)
{
	VP[COMVP].Ptr->r = r;
	VP[COMVP].Ptr->c = c;
}

open_a_o(str,fdptr,flag)
char *str, flag;
LPINT fdptr;
{
	char c, tmp_cmd_flag, bbuu[80];
	int mode=OF_CREATE|OF_WRITE;
	long ll=0L;

	tmp_cmd_flag = cmd_flag;
	cmd_flag = 0;
	if((*fdptr=UsdOpenFile((LPSTR)str,O_RDONLY)) != -1) {
        close(*fdptr);
		if(flag == 'I') {
aa:
			d_prntf("\r\nFile already existed, overwrite? [Y/N] ");
			c = get_str2(bbuu,10);
			if(c == ESC) goto ret;
			c = bbuu[0];
			if(c=='N' || c=='n') {
				c = ESC;
				goto ret;
			} else if(c!='Y' && c!='y') goto aa; 
		} else if(flag=='A' || flag=='a') mode = OF_READWRITE;
	}
	if ( ( *fdptr = open( (LPSTR)str, mode|O_BINARY, S_IREAD|S_IWRITE ) ) == -1 ) {
		prn_ferr(15);
		c = 1 - OPEN_OK;
	} else {
		c = OPEN_OK;
		if(flag=='A' || flag=='a') ll = _llseek(*fdptr,0L,SEEK_END);
	}
	cmd_flag = tmp_cmd_flag;
ret:
	return(c);
}

JournalCh(c)
char c;
{
	int c1;
	if(!c) return;
	if(c == TAB) c = NAME;
	if(out_flag == 1 && VPOut==COMVP) {
		if(c == BS) {
			if(!log_cnt) {
				_llseek(fd_out_log,(long)(-1),1);
			} else --log_cnt;
		} else if(c == LF) {
			if(logc_last() == CR) logc(LF);
			else {
				logc(CR);
				logc(LF);
			}
		} else if(c == CR) {
			if((c1=logc_last())!=CR && c1!=LF) logc(CR);
		} else logc(c);
	}
	if(keep_it_for_IF && VPOut==COMVP) {
		c = USDtoupper(c);
		if(d_buf_idx >= D_BUF_SIZE) {
			d_buf[D_BUF_SIZE] = '\0';
			keep_it_for_IF = 0;
		} else if (c) d_buf[d_buf_idx++] = c;
	}
}

JournalStr(ptr)
char *ptr;
{
	char c, *str=ptr;
	if(out_flag == 1 && VPOut==COMVP) {
		while(c = *str++) JournalCh(c);
	}
	if(keep_it_for_IF && VPOut==COMVP) {
		while(c = *ptr++) {
			c = USDtoupper(c);
			if(d_buf_idx >= D_BUF_SIZE) {
				d_buf[D_BUF_SIZE] = '\0';
				keep_it_for_IF = 0;
				break;
			} else if (c) d_buf[d_buf_idx++] = c;
		}
	}
}

JournalHistory()
{
	char buf[CMDBUFSIZE+1];
	if(his_flag != 0) {
		out_flag = his_flag - 1;
		his_flag = 0;
		if(out_flag) {
/* debug
{
char bbb[200];
int VPtmp;
VPtmp = VPOut;
VPOut = COMVP;
sprintf(bbb,
"\n\rVP[COMVP].Ptr->c=%d,VP[COMVP].Ptr->r=%d\n\rCmdKeyinBuf[0]=%x,CmdKeyinBuf[1]=%x,CmdKeyinBufIdx=%d", VP[COMVP].Ptr->c,VP[COMVP].Ptr->r,CmdKeyinBuf[0],CmdKeyinBuf[1],CmdKeyinBufIdx);
d_prntf(bbb);
VPOut = VPtmp;
}
debug */
			if(VP[COMVP].Ptr->c > COMBUFCOL) {
				strcpy(buf,CmdKeyinBuf);
				buf[CmdKeyinBufIdx+1] = '\0';
			} else {
				v_stcpy( LastCOMVPLine, FROM_WN, ROW, VP[COMVP].Ptr );
				strncpy( buf, LastCOMVPLine, VP[COMVP].Ptr->c );
				buf[ VP[COMVP].Ptr->c ] = '\0';
			}
			JournalStr(buf);
		}
	}
}

logc_last()
{
	int i;
	i = (log_cnt + 511 ) % 512;
	return(O_BUF[i]);
}

logc(c)
char c;
{
	if(log_cnt == 512) {
		_lwrite(fd_out_log,(LPSTR)O_BUF,512);
		log_cnt=0;
	}
	O_BUF[log_cnt++]=c;
}

logb(c)
char c;
{
	if(b_cnt == 512) {
		_lwrite(fd_cmd_log,(LPSTR)BAT_BUF,512);
		b_cnt = 0;
	}
	BAT_BUF[b_cnt++]=c;
}

LogOneCmdLine(s)
char *s;
{
	int VPtmp;
	char bbb[80], c;

if ( donotlog ) { donotlog = 0; return; }

	if(cmd_flag == 1 && CmdSendBuf[0] != 'r') {
		CmdKeyinBuf[CmdKeyinBufIdx+1] = '\0';
		while((c = *s++) && c!=CR) logb(c);
		if(c == CR) *--s = '\0';
		logb(CR);
		logb(LF);
	}
}

#include <time.h>

TimeDelayinSec( Second )
double  Second;
{
 time_t  StartTime, EndTime;

 time( &StartTime );
 while ( Second > difftime( time(&EndTime), StartTime ) );
}

SetCodeVPData()
{
	int i, j, ii, VPtmp, rr=FAIL;
	unsigned long l2, l2l2;
	char cmd[30], b1[30], b2[30], c, *ptr, *ptr1, bbb[200];
	struct pcstatus pcpc;

	CurrentCODBuf = LastCODBuf = 0;
//	cmd[0] = (env.Mmodel >= MICE_3_BOUND) ? 'D' : 'Z';
	if (env.Mmodel >= MICE_3_BOUND) cmd[0] = 'D';
	else cmd[0] = 'Z';
	cmd[1] = SP;
	cmd[2] = '\0';
	GetCodeVPRange(NONE);

	GetPC(&PC);
	memmove(&pcpc,&PC,sizeof(struct pcstatus));
	if (pcpc.flag != OK) CODBuf[0][0] = NULL;
	else {
		strcpy(b1,pcpc.ascii);
/* 8-18-89	ptr = b1 + (env.Mmodel==I_8048||env.Mmodel==I_8050||env.Mmodel==M_64180||env.Mmodel==M_68008); */
/* 8-18-89 */	ptr = b1;

		strcpy( CODBufAddr[0], ptr );
		strcat(cmd,ptr);
		strcat(cmd," ");
		for(i=1,ii=0,l2=pcpc.addr[ii] ; i<env.Maddrunit ; i++)
			l2 = (l2<<8) + pcpc.addr[i];
		l2l2 = l2 + 0xff;

/* exceed addr boundary */
		if((long)(l2l2 & env.addr_limit) < (long)(l2 & env.addr_limit)) 
			cmd[1] = '\0';
		else if (( env.CpuType == 2 || env.CpuType == 3) &&
			(((l2l2 & 0xffff0000) >> 12)+(l2l2 & 0xffff)) > 0xfffff)
			cmd[1] = '\0';
		else {
			for(i=env.Maddrunit-1,j=0 ; i>=ii ; i--,j+=8)
				pcpc.addr[i] = l2l2 >> j & 0xff;

			adr_ascii(pcpc.addr,env.Maddrunit,b2);

/* vvvvv  Charles Hwang  vvvvv */

			if ( ( env.Maddrid==I8086 && env.Mmodel!=M_3_H8 ) ||
				 env.Maddrid==M_3_386							 )  ptr=b2+5;
			else if ( env.Mmodel == M_3_H8 ) ptr = b2 + 3;

/* ^^^^^  Charles Hwang  ^^^^^ */

			else ptr = b2 + (env.Mmodel==I_8048||env.Mmodel==I_8050||env.Mmodel==M_64180||env.Mmodel==M_68008);

			strcat(cmd,ptr);
		}

		if(sym_flag) {
			opr_adr = 1;
			if(env.Mmodel == M_64180) {
				send_ESC();
				send_jump();
			}
		}
again:
		CodeVPRange.LFcount = 0;
		CODBuf[0][0] = NULL;
		c = SEND_str(cmd);

		if((addinx || SymLoaded == OK) && sym_flag) {
			to_symbol(CODVP,c);
			ptr = &(CODBuf[0][strlen(CODBuf[0])]);
		} else {
try_again:
			while(c != 'L' && c != 'A' && c!=HAND_SHAKE) c = receive();
			if(c != HAND_SHAKE) {
				ptr = CODBuf[0];
				*ptr++ = c;
				for(i=0 ; i<3 ; i++) {
					*ptr++ = receive();
					*ptr = '\0';
				}
				if(!strcmp(CODBuf[0],"Addr") || !strcmp(CODBuf[0],"LOC ")) {
					while(CodeVPRange.LFcount<CODBUFROW && (c=receive()) != HAND_SHAKE) {
						if(c) *ptr++ = c;
						if(c == LF) CodeVPRange.LFcount++;
					}
					if(*--ptr != LF) {
						ptr++;
						CodeVPRange.LFcount++;
					}
					*ptr = '\0';
				} else {
					c = '0';
					CODBuf[0][0] = NULL;
					goto try_again;
				}
			}
		}
		while((ptr = rindex(CODBuf[0],LF)) > CODBuf[0]) {
			ptr1 = ptr;
			while(!ishex(c = *++ptr1) && c) ;
			if(c) for(i=1 ; i<=3 && (c= *++ptr1)&&ishex(c) ; ) i++;
			if(!c || i < 3) {
				*ptr = '\0';
				CodeVPRange.LFcount--;
			} else break;
		}

		if ( (env.Mmodel < MICE_3_BOUND) || (env.Mmodel == 31) || (env.Mmodel == 36) )
		   send_ESC();
		else  { send(0x13); TimeDelayinSec( 0.25 ); send_ESC(); }

		if(ValidateResult(CODBuf[0],'Z') == TRUE) {
			rr = OK;
			strcpy(CodeVPRange.buf_start,b1);
        } else if(!cmd[1]) CODBuf[0][0] = NULL;
		else {
			cmd[1] = '\0';
			goto again;
		}
	}
	if ( rr == FAIL ) {
	   CODBufAddr[0][0] = '\0';
	   CurrentCODBuf = (--LastCODBuf);
	}
	return(rr);
}

SetCodeVPData1()
{
	int i, j, ii, VPtmp, rr=FAIL;
	unsigned long l2, l2l2;
	char cmd[30], b1[30], b2[30], c, *ptr, *ptr1, bbb[200];
	struct pcstatus pcpc;

//	CurrentCODBuf = LastCODBuf = 0;
	cmd[0] = (env.Mmodel >= MICE_3_BOUND) ? 'D' : 'Z';
	cmd[1] = SP;
	cmd[2] = '\0';
	GetCodeVPRange(NONE);

//	GetPC(&PC);
//	memmove(&pcpc,&PC,sizeof(struct pcstatus));
	pcpc.flag = OK;
	strcpy(pcpc.ascii,CODBufAddr[CurrentCODBuf]);
	str2addr(pcpc.ascii,pcpc.addr);
	if (pcpc.flag != OK) CODBuf[CurrentCODBuf][0] = NULL;
	else {
		strcpy(b1,pcpc.ascii);
/* 8-18-89	ptr = b1 + (env.Mmodel==I_8048||env.Mmodel==I_8050||env.Mmodel==M_64180||env.Mmodel==M_68008); */
/* 8-18-89 */	ptr = b1;

//		strcpy( CODBufAddr[CurrentCODBuf], ptr );
		strcat(cmd,ptr);
		strcat(cmd," ");
		for(i=1,ii=0,l2=pcpc.addr[ii] ; i<env.Maddrunit ; i++)
			l2 = (l2<<8) + pcpc.addr[i];
/*		if ( env.Mmodel == M_3_H8 )
		   l2l2 = l2 + 0x80;
		else */  l2l2 = l2 + 0xff;

/* exceed addr boundary */
		if((long)(l2l2 & env.addr_limit) < (long)(l2 & env.addr_limit)) 
			cmd[1] = '\0';
		else if (( env.CpuType == 2 || env.CpuType == 3) &&
			(((l2l2 & 0xffff0000) >> 12)+(l2l2 & 0xffff)) > 0xfffff)
			cmd[1] = '\0';
		else {
			for(i=env.Maddrunit-1,j=0 ; i>=ii ; i--,j+=8)
				pcpc.addr[i] = l2l2 >> j & 0xff;

			adr_ascii(pcpc.addr,env.Maddrunit,b2);

/* vvvvv  Charles Hwang  vvvvv */

			if ( ( env.Maddrid==I8086 && env.Mmodel!=M_3_H8 ) ||
				 env.Maddrid==M_3_386							 )  ptr=b2+5;
			else if ( env.Mmodel == M_3_H8 ) ptr = b2 + 3;

/* ^^^^^  Charles Hwang  ^^^^^ */

			else ptr = b2 + (env.Mmodel==I_8048||env.Mmodel==I_8050||env.Mmodel==M_64180||env.Mmodel==M_68008);

			strcat(cmd,ptr);
		}

		if(sym_flag) {
			opr_adr = 1;
			if(env.Mmodel == M_64180) {
				send_ESC();
				send_jump();
			}
		}
again:
		CodeVPRange.LFcount = 0;
		CODBuf[CurrentCODBuf][0] = NULL;
		c = SEND_str(cmd);

		if((addinx || SymLoaded == OK) && sym_flag) {
			to_symbol(CODVP,c);
			ptr = &(CODBuf[CurrentCODBuf][strlen(CODBuf[CurrentCODBuf])]);
		} else {
try_again:
			while(c != 'L' && c != 'A' && c!=HAND_SHAKE) c = receive();
			if(c != HAND_SHAKE) {
				ptr = CODBuf[CurrentCODBuf];
				*ptr++ = c;
				for(i=0 ; i<3 ; i++) {
					*ptr++ = receive();
					*ptr = '\0';
				}
				if(!strcmp(CODBuf[CurrentCODBuf],"Addr") || !strcmp(CODBuf[CurrentCODBuf],"LOC ")) {
					while(CodeVPRange.LFcount<CODBUFROW && (c=receive()) != HAND_SHAKE) {
						if(c) *ptr++ = c;
						if(c == LF) CodeVPRange.LFcount++;
					}
					if(*--ptr != LF) {
						ptr++;
						CodeVPRange.LFcount++;
					}
					*ptr = '\0';
				} else {
					c = '0';
					CODBuf[CurrentCODBuf][0] = NULL;
					goto try_again;
				}
			}
		}
		while((ptr = rindex(CODBuf[CurrentCODBuf],LF)) > CODBuf[CurrentCODBuf]) {
			ptr1 = ptr;
			while(!ishex(c = *++ptr1) && c) ;
			if(c) for(i=1 ; i<=3 && (c= *++ptr1)&&ishex(c) ; ) i++;
			if(!c || i < 3) {
				*ptr = '\0';
				CodeVPRange.LFcount--;
			} else break;
		}

		if ( (env.Mmodel < MICE_3_BOUND) || (env.Mmodel == 31) || (env.Mmodel == 36) )
		   send_ESC();
		else  { send(0x13); TimeDelayinSec( 0.25 ); send_ESC(); }

		if(ValidateResult(CODBuf[CurrentCODBuf],'Z') == TRUE) {
			rr = OK;
			strcpy(CodeVPRange.buf_start,b1);
		} else if(!cmd[1]) CODBuf[CurrentCODBuf][0] = NULL;
		else {
			cmd[1] = '\0';
			goto again;
		}
	}
	if ( rr == FAIL ) {
	   CODBufAddr[CurrentCODBuf][0] = '\0';
	   CurrentCODBuf = (--LastCODBuf);
	}
	return(rr);
}

ValidateResult(s,code)
char *s, code;
/*** code:
	'Z'	SetCodeVPData()
	'L'	SetTraceVPData()
	'R'	GetPC()
***/
{
int r;
    strupr(s);
	if (*s == NULL) r = EMPTY;
    else if (strstr(s,"ERROR") != NULL) {
		if(code == 'R') r = NO_PC;
        else if(code =='Z')             //by chris, 6/11/1996, for PM2I6007 bug
            r = TRUE;                   //not care error message
        else r = FALSE;
	} else if (strstr(s,"STEP") != NULL) r = FALSE;
	else if (strstr(s,"HALT") != NULL) r = FALSE;
	else r = TRUE;
	return(r);
/*
	if (strstr(s, "error") != NULL) {
		if (code == 'R') return(NO_PC);
		return (FALSE);
	}
	else if (strstr(s, "step") != NULL) return (FALSE);
	else if (strstr(s, "halt") != NULL) return (FALSE);
	else if (strstr(s, "Guarded") != NULL) return (FALSE);
	else return (TRUE);
 */
}

GetCodeVPRange(flag)
			/* flag=ALL:     whole buffer refresh */
			/* flag=PARTIAL: scroll CODVP screen only */
			/* flag=NONE:   reset CodeVPRange */
int flag;
{

	char *ptr, *ptr1;
	int i, ii, ll;
	int oldrow;
	char LastCODVPLine[ CODBUFCOL+1 ];

	if(flag == NONE) CodeVPRange.flag = FAIL;
	else {
		ii= LABELINDENT + ((env.Maddrid==I8086 || env.Maddrid==M_3_386) ? 5 : 0)+ env.mmu[1];

/* vvvvv  Charles Hwang  vvvvv */

		if ( env.Mmodel == M_3_H8 ) ii = ii - 2;

/* ^^^^^  Charles Hwang  ^^^^^ */

		if(env.Maddrid==I8086 || env.Maddrid==M_3_386) ll = env.Miplen;
		else ll = env.Mcsiplen - (env.Mmodel==I_8048||env.Mmodel==I_8050||env.Mmodel==M_64180||env.Mmodel==M_68008);

		if(flag == ALL) {
			oldrow = VP[CODVP].Ptr->r;
			VP[CODVP].Ptr->r = CodeVPRange.LFcount-1;
			v_stcpy( LastCODVPLine, FROM_WN, ROW, VP[CODVP].Ptr );
			ptr1= LastCODVPLine;
			ptr = ptr1 + ii;
			if(*ptr == NAME) {
				VP[CODVP].Ptr->r -= 1;
				v_stcpy( LastCODVPLine, FROM_WN, ROW, VP[CODVP].Ptr );
				ptr= LastCODVPLine;
			}
			strncpy(CodeVPRange.buf_end,ptr,ll);
			CodeVPRange.flag = OK;
			VP[CODVP].Ptr->r = oldrow;
		}

		if( VP[CODVP].Ptr->row_org >= CodeVPRange.LFcount ) {
			strncpy(CodeVPRange.scr_start,"FFFFFFFF",ll);
			CodeVPRange.scr_start[ll] = '\0';
		} else {
			oldrow = VP[CODVP].Ptr->r;
			VP[CODVP].Ptr->r = VP[CODVP].Ptr->row_org;
			v_stcpy( LastCODVPLine, FROM_WN, ROW, VP[CODVP].Ptr );
			ptr1= ptr=  LastCODVPLine + ii;
			i = 0;
			while(ishex(*ptr1++)) i++;
			if(i < 3) {
				VP[CODVP].Ptr->r += 1;
				v_stcpy( LastCODVPLine, FROM_WN, ROW, VP[CODVP].Ptr );
				ptr1 = ptr = LastCODVPLine + ii;
				i = 0;
				while(ishex(*ptr1++)) i++;
				if(i < 3) {
					VP[CODVP].Ptr->r += 1;
					v_stcpy( LastCODVPLine, FROM_WN, ROW, VP[CODVP].Ptr );
					ptr1 = ptr = LastCODVPLine + ii;
				}
			}
			strncpy(CodeVPRange.scr_start,ptr,ll);
			VP[CODVP].Ptr->r = oldrow;
		}

		if( VP[CODVP].Ptr->row_org >= CodeVPRange.LFcount ) {
			strncpy(CodeVPRange.scr_end,"00000000",ll);
			CodeVPRange.scr_end[ll] = '\0';
		} else {
			oldrow = VP[CODVP].Ptr->r;
			i = MIN( (VP[CODVP].Ptr->row_org+wn_rowq(VP[CODVP].Ptr)-1), CodeVPRange.LFcount-1 );
			VP[CODVP].Ptr->r = i;
			v_stcpy( LastCODVPLine, FROM_WN, ROW, VP[CODVP].Ptr );
			ptr1 = ptr = LastCODVPLine + ii;
			i = 0;
			while(ishex(*ptr1++)) i++;
			if(i < 3) {
				VP[CODVP].Ptr->r -= 1;
				v_stcpy( LastCODVPLine, FROM_WN, ROW, VP[CODVP].Ptr );
				ptr1 = ptr = LastCODVPLine + ii;
				i = 0;
				while(ishex(*ptr1++)) i++;
				if(i < 3) {
					VP[CODVP].Ptr->r -= 1;
					v_stcpy( LastCODVPLine, FROM_WN, ROW, VP[CODVP].Ptr );
					ptr1 = ptr = LastCODVPLine + ii;
				}
			}
			strncpy(CodeVPRange.scr_end,ptr,ll);
			VP[CODVP].Ptr->r = oldrow;
		}
	}
}

#define BKPT_SIGN '*'

SetBKPTinCodeVP()
{
	int i, ii, j;
	char *ptr, *ptr1;
	char LastCODVPLine[ CODBUFCOL+1 ];
	int oldrow, oldcol;

	oldrow = VP[CODVP].Ptr->r;
	oldcol = VP[CODVP].Ptr->c;

	for ( i=0, j=0;	i<CodeVPRange.LFcount; i++, j=0, ptr1 = ( ptr += (VP[CODVP].Maxc+2) ) )	{

	    VP[CODVP].Ptr->r = i;
	    v_stcpy( LastCODVPLine, FROM_WN, ROW, VP[CODVP].Ptr );
	    ptr1 = ptr = LastCODVPLine + LABELINDENT + env.mmu[1];

	    while(ishex(*ptr1++)) j++;

	    if ( j>=3 && CheckIsBKPT(ptr)>=0 ) {

	       VP[CODVP].Ptr->c = 0;
	       v_ch( BKPT_SIGN, VP[CODVP].Ptr );

/*	       *(ptr - 1 - env.mmu[1]) = BKPT_SIGN;	 */

	    }
	}

	VP[CODVP].Ptr->r = oldrow;
	VP[CODVP].Ptr->c = oldcol;
}

adr_ascii(adr,len,buf)
unsigned char *adr;
int len;
char *buf;
{
	int i, ii;
	for(i=0,ii=0 ; i<len ; i++) {
		buf[ii++] = hex[(adr[i]>>4)&0xf];
		buf[ii++] = hex[adr[i]&0xf];

/* vvvvv  Charles Hwang  vvvvv */

		if( i==1 && ( (env.Maddrid==I8086 && env.Mmodel!=M_3_H8) ||
					  env.Maddrid==M_3_386 )
		  ) buf[ii++] = ':';

		if( i==0 && env.Mmodel==M_3_H8 ) buf[ii++] = ':';

/* ^^^^^  Charles Hwang  ^^^^^ */

	}
	buf[ii] = '\0';
}

MarkBKPTinCodeVP(str,ch)
char *str, ch;
{
	struct pcstatus pp, *ppp;
	int i;

	ppp = &pp;
	strcpy(ppp->ascii,str);
	if(CodeVPRange.flag==OK && (i=LocatePCLine(ppp)) < CodeVPRange.LFcount)
		MarkBKPT(i,ch);
}

MarkNewPCinCodeVP()
{
	struct pcstatus *ppp;
	int r, i;

	if ( CurrentCODBuf > 0 ) {
	   CurrentCODBuf = 1;
	   GetPrevCodePage();
	}

	if( wn_isup(VP[CODVP].Ptr) && (RedrawFlag&REDRAWCOD) && (!(MaskRedrawFlag&REDRAWCOD)) && CodeVPRange.flag==OK) {
		GetPC(ppp = &PC);
		if(PC.flag == OK) {
			if((r = InCodeVPScreen(ppp)) == YES) {
				i = LocatePCLine(ppp);
				if(i < CodeVPRange.LFcount) {
					MarkPC(i);
					RedrawFlag &= ~REDRAWCOD;
				}
			} else if(r == PC_ONLY && InCodeVPBuf(ppp) == YES && 
			((i=LocatePCLine(ppp)) < CodeVPRange.LFcount) && OnePageMore(i)== TRUE){
				NewPCPage(i);
				RedrawFlag &= ~REDRAWCOD;
				GetCodeVPRange(PARTIAL);
			}
		}
	}
}

InCodeVPScreen(ppp)
struct pcstatus *ppp;
{
	unsigned long ips, ipe, ip;
	char bbb[100];
	int VPtmp;

	sscanf(CodeVPRange.scr_end,"%lx",&ipe);

/* vvvvv  Charles Hwang  vvvvv */

	if( (env.Maddrid==I8086 && env.Mmodel!=M_3_H8) || env.Maddrid == M_3_386) {
		if(strncmp(ppp->ascii,CodeVPRange.buf_start,4)) return(NO);
		sscanf(ppp->ascii+5,"%lx",&ip);
	} else if( env.Mmodel==M_3_H8 ) {
		if(strncmp(ppp->ascii,CodeVPRange.buf_start,2)) return(NO);
		sscanf(ppp->ascii+3,"%lx",&ip);

/* ^^^^^  Charles Hwang  ^^^^^ */

	} else sscanf(ppp->ascii,"%lx",&ip);

	sscanf(CodeVPRange.scr_start,"%lx",&ips);
	return((ip <= ipe && ip >= ips) ? YES : PC_ONLY);
}

InCodeVPBuf(ppp)
struct pcstatus *ppp;
{
	unsigned long ips, ipe, ip;
	char bbb[100];
	int VPtmp;

/* vvvvv  Charles Hwang  vvvvv */

	if( (env.Maddrid==I8086 && env.Mmodel!=M_3_H8) || env.Maddrid == M_3_386) {
		sscanf(CodeVPRange.buf_start+5,"%lx",&ips);
		sscanf(ppp->ascii+5,"%lx",&ip);
	} else if( env.Mmodel==M_3_H8 ) {
		sscanf(CodeVPRange.buf_start+3,"%lx",&ips);
		sscanf(ppp->ascii+3,"%lx",&ip);

/* ^^^^^  Charles Hwang  ^^^^^ */

	} else {
		sscanf(CodeVPRange.buf_start,"%lx",&ips);
		sscanf(ppp->ascii,"%lx",&ip);
	}
	sscanf(CodeVPRange.buf_end,"%lx",&ipe);
	return((ip <= ipe && ip >= ips) ? YES : NO);
}

LocatePCLine(ppp)
struct pcstatus *ppp;
{
	char bbb[80], buf[60], *ptr1, *ptr2;
	int j, VPtmp;
	char LastCODVPLine[ CODBUFCOL+1 ];
	int oldrow;

	oldrow = VP[CODVP].Ptr->r;
	ptr2 = ppp->ascii;

	for( j=0 ; j<CodeVPRange.LFcount ; j++ ) {

		VP[CODVP].Ptr->r = j;
		v_stcpy( LastCODVPLine, FROM_WN, ROW, VP[CODVP].Ptr );
		if ( env.Mmodel == 34 )	/* for MICE-8 64180 */
			ptr1 = LastCODVPLine + LABELINDENT;
		else
			ptr1 = LastCODVPLine + LABELINDENT + env.mmu[1];

		if(!strncmp(ptr1,ptr2,strlen(ptr2))) break;
	}

	VP[CODVP].Ptr->r = oldrow;
	return(j);
}

OnePageMore(i)
int i;
{
	return(((i + VP[CODVP].Height - 2) <= CodeVPRange.LFcount) ? TRUE : FALSE);
}

/*____________________________________________________________________________*/
CheckIsBKPT(ptr)
char *ptr;
{
	unsigned long addr, cs386p;
	if(!index(ptr,':')) {
		sscanf(ptr,"%lx",&addr);
	} else {
		sscanf(ptr,"%lx:%lx",&cs386p,&addr);
		addr = (cs386p << 16) | (addr & 0xffff);
	}
	return(IsBKPT(addr,cs386p));
}

char TraceVPCmd[]= "L 000";
/*                  0123456789 */

SetTraceVPData(flag)
                           /* flag=0:           reset TraceVP content */
                           /* flag=TRAVP_NEXT:  show next page of TraceVP */
                           /* flag=TRAVP_PREV:  show previous page of TraceVP */
int flag;
{
	int i, start, end=-1, rr=OK;
	char c, *ptr, *ptr1, b1[100];
	char *tmp;
	int totalframe;

	MICEBuf[0] = NULL;

	if(flag == 0) {

		if ( env.Mmodel >= MICE_3_BOUND )
		   do_1_cmd_save( "L N", MICEBuf, (MICEBUFSIZE+1) );
		else  do_1_cmd_save( "LN", MICEBuf, (MICEBUFSIZE+1) );

		if (strchr(MICEBuf,'!') == NULL) {

			if (env.MICEGroup == MICE2)  {
				if ((ptr=strstr(MICEBuf,"AT STEP")) != NULL) 
					sscanf(ptr+7,"%x",&totalframe);
				else totalframe = 0;
			} else {
				if ((ptr=strstr(MICEBuf,"empty")) != NULL)
					totalframe = 0;
				else {
					ptr=strchr(MICEBuf,'=');
					sscanf(ptr+1,"%x",&totalframe);
				}
			}

			if ( ( totalframe < 0 ) || ( totalframe > 0x7ff ) )
				totalframe = 0;
			if ( ( start = ( totalframe - TRABUFROW + 2 ) ) < 0 )
				start = 0;
			sprintf(TraceVPCmd+2,"%3X",start);

		} else {
			start = 0;
			strcpy(TraceVPCmd+2,"000");
		}

		TraceVPRange.flag = FAIL;

	} else if(flag == TRAVP_NEXT) {
		if ( TraceVPRange.end+1 > 0x7ff )  return(rr);
		start = min(TraceVPRange.end+1,0x7ff);
		sprintf(b1,"%3x",start);
		strcpy(TraceVPCmd+2,b1);
	} else if(flag == TRAVP_PREV) {
		if(TraceVPRange.start) {
			start = max(TraceVPRange.start-TRABUFROW+1,0);
			sprintf(b1,"%3x",start);
			strcpy(TraceVPCmd+2,b1);
		} else return(rr);
	}
	TraceVPRange.LFcount = 0;
	for (tmp=TraceVPCmd; *tmp != NULL; tmp++) *tmp = ch_toupper(*tmp);	
/*	AnsiUpper((LPSTR)TraceVPCmd); */
	c = SEND_str(TraceVPCmd);
	{
try_again:
		while(c != 'F' && c!=HAND_SHAKE) c = receive();
		if(c != HAND_SHAKE) {
			ptr = MICEBuf;
			*ptr++ = c;
			for(i=0 ; i<4 ; i++) {
				*ptr++ = receive();
				*ptr = '\0';
			}
			if(!strcmpi(MICEBuf,"FRAME")) {
more_page:
				while(TraceVPRange.LFcount<TRABUFROW && (c=receive()) != HAND_SHAKE) {
					if(c) *ptr++ = c;
					if(c == LF) TraceVPRange.LFcount++;
				}
				if(c == HAND_SHAKE && *--ptr != '>') {
					while ( *--ptr != CR );
					send(CR);
					while ( receive() != CR );
					while ( receive() != CR );
					*ptr++ = CR;
					goto more_page;
				}
				if(*--ptr != LF) {
					ptr++;
					TraceVPRange.LFcount++;
				}
				*ptr = '\0';
			} else {
				c = '0';
				MICEBuf[0] = NULL;
				goto try_again;
			}
		}
	}
	while((ptr = rindex(MICEBuf,LF)) > MICEBuf) {
		ptr1 = ptr;
		while(!ishex(c = *++ptr1) && c) ;
		if(c) for(i=1 ; i<=3 && (c= *++ptr1)&&ishex(c) ; ) i++;
		if(!c || i < 3) {
			*ptr = '\0';
			TraceVPRange.LFcount--;
		} else {
			sscanf(ptr,"%x %s",&end,b1);
			break;
		}
	}
	send_ESC();
	if((rr=ValidateResult(MICEBuf,'L')) == TRUE || rr==EMPTY) {
		if(rr == TRUE) {
			TraceVPRange.flag = OK;
			TraceVPRange.start = start;
			TraceVPRange.end = end;
		}
		rr = OK;
	} else rr = FAIL;
/******* debug
DisplayTraceVPRange();
if(rr == OK) d_prntf("\n\rreturn OK");
else d_prntf("\n\rreturn FAIL");
debug *******/
	return(rr);
}

int ChkMode()
{
unsigned long rx_4B();
unsigned long l;
int c;	
extern int Pmode;

//	if (Pmode) return(1);
	send_ESC();
	if (env.CpuCode == M80386) send_str2("R CR");
	else if (env.CpuCode == M80286) send_str2("R MS");
	else return(0);
	send(CR);
	if (env.CpuCode == M80386) {
		while ((c=receive()) != '=') 
			if (c == HAND_SHAKE) return(0);
		l = rx_4B();
		Pmode = l & 1;
		return (Pmode);
	}
	while ((c=receive()) != ' ');
	l = rx_long();
	send_ESC();
	Pmode = l & 1;
	return (Pmode);
}	

unsigned long rx_4B()
{
unsigned long l=0;
int i, c;
	for (i=0;i < 8;) {
		c=receive();
		if (c == HAND_SHAKE) return(l);
		if (isxdigit(c)) {
			c=asc__h(c);
			l = (l<<4) + c;
			i++;
		}
	}
	while(receive() != HAND_SHAKE);
	return(l);
}

/****************************************************************************/
/*  save screen layout which including menu-bar and viewports		    */
/****************************************************************************/

SaveScrnLayout()
{
 int  i;

/* CORE 90.08.16 */

#ifdef NEC_PC9801 /*NEC_PC9801*/

 wi_sav( MenuBar->wnp );

#else /*NEC_PC9801*/

 mn_dn( MenuBar );

#endif /*NEC_PC9801*/

 for ( i = BREVP; i <= DATVP; i++ ) {

     if ( wn_isup( VP[i].Ptr ) ) {

	VPIsSet[i] = TRUE;
	wn_dn( VP[i].Ptr );

     } else  VPIsSet[i] = FALSE;
 }

 wn_dn( FuncKeyVP );
 vs_clr();

}  /*  of SaveScrnLayout()  */

/****************************************************************************/
/*  restore screen layout which including menu-bar and viewports	    */
/****************************************************************************/

RestoreScrnLayout()
{
 if ( ColorMode == FALSE ) {

    USD3vid_setmode( MONO );

 } else {

    USD3vid_setmode( CO80 );
    vid_hibg( ON );
 }

 vs_clr();

/* CORE 90.08.16 */

#ifdef NEC_PC9801 /*NEC_PC9801*/

 wi_unsav( MenuBar->wnp );

#else /*NEC_PC9801*/

 mn_up( MenuBar );

#endif /*NEC_PC9801*/

 if ( VPIsSet[REGVP] )  wn_up( VP[REGVP].Ptr );
 if ( VPIsSet[BREVP] )  wn_up( VP[BREVP].Ptr );
 if ( VPIsSet[TRAVP] )  wn_up( VP[TRAVP].Ptr );
 if ( VPIsSet[CODVP] )  wn_up( VP[CODVP].Ptr );
 if ( VPIsSet[COMVP] )  wn_up( VP[COMVP].Ptr );
 if ( VPIsSet[STAVP] )  wn_up( VP[STAVP].Ptr );
 else  if ( VPIsSet[DATVP] )  wn_up( VP[DATVP].Ptr );

 wn_up( FuncKeyVP );

}  /*  of RestoreScrnLayout()  */

/****************************************************************************/
/*  the dialog box is used to decide to retry or cancel to link MICE	    */
/****************************************************************************/

LinkMICEDlgBox( Title )
char  *Title;
{
 CLISTPTR  CListPtr;
 int	   Selection = ABORTLINKMICE;

 CListPtr = cl_def( 10, 25, 4, 30, BDR_DLNP, "*Linking MICE", CListMFilePtr );
 sw_title( Title, LCLINACT, TOPCENTER, CListPtr->wnp );

 if ( (cl_proc(0,CListPtr)==AC_EXIT) && (cl_curnum(CListPtr)==RETRYLINKMICE) )
    Selection = RETRYLINKMICE;
 
 cl_free( CListPtr );
 
 return( Selection );

}  /* of LinkMICEDlgBox()  */

/****************************************************************************/
/*  decide whether the user want to abort USD-III			    */
/****************************************************************************/

int  AskAbortUSD3 = 0;

AbortUSD3()
{
 DFORMPTR   DFormPtr;
 DFIELDPTR  DFieldPtr;
 char	    Abort[2];
 extern int  COMVPMax;
 int i;
 
 AskAbortUSD3 = 1;
 Abort[0] = 'Y';
 Abort[1] = '\0';

 DFormPtr  = fm_def( 10, 28, 5, 24, LWHI_RED, BDR_DLNP );
 DFieldPtr = fld_def( 1, 3, "Abort USD-III? ", FADJACENT, "!", F_STRING, Abort, DFormPtr );
 if (DFieldPtr == NULLP) return(FALSE);
 sf_attact( LRED_WHI, DFieldPtr );
 sf_attinact( LWHI_RED, DFieldPtr );

/* USD-III V2.0x */ sfm_opt( VERIFYEXIT|VERIFYQUIT, OFF, DFormPtr );
 
 if (!(fm_up( DFormPtr ))) return(FALSE);

 i = fm_rd( 0, DFormPtr );
 if ( i == AC_QUIT ) {
    fm_dn( DFormPtr );
    fm_free( DFormPtr );
// DOS/16M
    if ( VPLink != NULL ) csr_plwn( VPLink );
    else  if ( VP[COMVP].Ptr != NULL )  csr_plwn( VP[COMVP].Ptr );
    return( FALSE );
 }

 if (!i) return(FALSE); /* Error */

 if ( Abort[0] == 'Y' ) {

    if ( ScrnDisplay && !COMVPMax && ( VerUSAV() == TRUE ) )  usave_cmd( "" );
    fm_dn( DFormPtr );
    fm_free( DFormPtr );
    return( TRUE );

 } else {

    fm_dn( DFormPtr );
    fm_free( DFormPtr );
// DOS/16M
    if ( VPLink != NULL ) csr_plwn( VPLink );
    else  if ( VP[COMVP].Ptr != NULL )  csr_plwn( VP[COMVP].Ptr );
    return( FALSE );
 }

}  /*  of AbortUSD3()  */

/****************************************************************************/
/*									    */
/****************************************************************************/

VerUSAV()
{
 DFORMPTR   DFormPtr;
 DFIELDPTR  DFieldPtr;
 char	    DoUSAV[2];
 
/* USD-III V2.0x */
 DoUSAV[0] = 'Y';
 DoUSAV[1] = '\0';

 if (FPORT) return(FALSE);
 DFormPtr  = fm_def( 14, 23, 5, 34, LWHI_RED, BDR_DLNP );
 DFieldPtr = fld_def( 1, 3, "Save screen and softkey? ", FADJACENT, "!", F_STRING, DoUSAV, DFormPtr );
 sf_attact( LRED_WHI, DFieldPtr );
 sf_attinact( LWHI_RED, DFieldPtr );

/* USD-III V2.0x */ sfm_opt( VERIFYEXIT|VERIFYQUIT, OFF, DFormPtr );
 
 if ( fm_proc( 0, DFormPtr ) == AC_QUIT ) {

    fm_free( DFormPtr );
//    csr_plwn( VP[COMVP].Ptr );
    return( FALSE );
 }

 fm_free( DFormPtr );

 if ( DoUSAV[0] == 'Y' )  return( TRUE );
 else {
//   csr_plwn( VP[COMVP].Ptr );
   return( FALSE );
 }

}  /*  of VerUSAV()  */

#include <sys\timeb.h>

GetTime(lp)
long *lp;
{
/*********
	long l1, l2;
	struct regs *INREG_ptr=&INREG, *OUTREG_ptr=&OUTREG;
	INREG_ptr->AX = 0x2c00;
	sysint(0x21,INREG_ptr,OUTREG_ptr);
	l1 = (OUTREG_ptr->CX >> 8) & 0xff;
	l1 *= 3600;
	l2 = OUTREG_ptr->CX & 0xff;
	*lp = l1 + l2 * 60 + ((OUTREG_ptr->DX >> 8) & 0xff);
*******/
	struct timeb ttt;
	ftime(&ttt);
	*lp = ttt.time;
}

pause_delay(i)
int i;
{
	long ll, lll;
	GetTime(&ll);
	lll = ll + i;
	do {
		if(chk_hlt() == ESC || down_ESC_send) {
			down_ESC_send = 0;
			break;
		}
		GetTime(&ll);
	} while(ll < lll) ;
}

tick_delay(delay_count)
int delay_count;
{
	int r = 1 - END;
	char c;
	long ll;
	int VPtmp;
	char bbb[80];

	USDSetTimer(delay_count);

	do {
//		if((r=chk_hlt()) == ESC || down_ESC_send) {
//			down_ESC_send = 0;
//			break;
//		}
		GetTime(&ll);
	} while(r!=END && ll<tick_deadline) ;

//	tick_count = 0;
}

any_G_mesg()
{
/********/
	char c, r=0, end_c;
	if((c=upRX_DATA()) >= 0) {
get_next_mesg:
		while(c != HAND_SHAKE) {
			d_putc(c);
			if(c == LF || c == CR) break;
			if(c =='=' || c =='y') r = END;
			c = receive();
		}
		if(c != HAND_SHAKE) {
			end_c = (env.Mmodel<=MICE_3_BOUND || env.Mmodel==NEW_Z80)
				? HAND_SHAKE : (0x17-c);
			while((c=receive()) != end_c) {
				d_putc(c);
				if(c=='=' || c=='y') r = END;
			}
			if(c != HAND_SHAKE) d_putc(c);
			if(env.Mmodel < MICE_3_BOUND) r = END;
		}
		if(env.Mmodel>=MICE_3_BOUND && (c=upRX_DATA())>=0) goto get_next_mesg;
	}
	return(r);
/********/
/*	return(1-END); */
}

USDSetTimer(i)
int i;
{
	long ll;
	GetTime(&ll);
	tick_deadline = ll + i;
}

WmTimer()
{
}

send_1_rec(ptr,rec_len)
unsigned char *ptr;
int rec_len;
{
	char c;
	int i;

/*	if(PORT == 1) { */

		for(i=0 ; i<rec_len ; i++)
			Bsend(*ptr++);

/*	} else {
		WriteComm(RS232_port,(LPSTR)ptr,rec_len);
		if(c = chk_kb()) {
			if(c == ESC) down_ESC_send = ON;
		}
	} */

}

/****************************************************************************/
/*  USD-III command : DOS						    */
/****************************************************************************/

#include <errno.h>
#include <process.h>

dos_cmd()
{
 char  *DosCmd;
 int   i, j;

 send_ESC();

 SaveScrnLayout();

 if ( cmd_argc == 1 ) {

    printf( "\n\r*****  To return to USD-III, type \"exit\".  *****\n\r" );
    i = spawnlp( P_WAIT, "COMMAND.COM", "COMMAND.COM", NULL );

 } else {

    DosCmd = CmdBuf;
    while ( (*(DosCmd++)) != 'S' );
    i = system( DosCmd );
    if ( i != -1 ) {
       printf( "\n\r*****  Press any key to return to USD-III.  *****" );
       ki();
    }
 }

 RestoreScrnLayout();

 if ( i == -1 )

    switch( errno ) {

      case ENOENT  : DisplayStr( "\r\n Error! Cannot find \"COMMAND.COM\"." );

		     break;

      case ENOMEM  : DisplayStr( "\r\n Not enough memory to load \"COMMAND.COM\"!" );

		     break;

      default	   : DisplayStr( "\r\n Not enough memory to load \"COMMAND.COM\"!" );
    }

 InitMouse();
 return( TRUE );

}  /*  of dos_cmd()  */

/****************************************************************************/
/*  USD-III command : IStep						    */
/****************************************************************************/

int  pre_chk_hlt;

istep_cmd()
{
	long i=0, count=-2, StepCount=1;
	int StepOver=FALSE, StepForever=FALSE, is=cmd_argc;
	char cmd[10], bbb[80], c, ccc, tmp_out_flag;
	unsigned long tmpRedrawFlag = RedrawFlag;

	pre_chk_hlt = 0;

	send_ESC();
	while(--is > 0) {
		if(!usd_strncmp(cmd_argv[is],"OVER",1)) StepOver = TRUE;
		else if(!usd_strncmp(cmd_argv[is],"FOREVER",2)) StepForever = TRUE;
		else StepCount = sscanf(cmd_argv[is],"%lx",&count);
/* IStep [Over] [FOrever | count] */
		if((StepForever == TRUE && count != -2) || !count) {
			prn_ferr(25);
			return(TRUE);
		} else if(count > 0) StepCount = count;
	}
	tmp_out_flag = out_flag;
	out_flag = 0;
	ccc = (StepOver==TRUE && env.Mmodel>=MICE_3_BOUND) ? 'C' : CR;
	StaBufRow = VP[STAVP].Height - 2;
	d_prntf("\n\r");
	do {
		VPOut = COMVP;

		if ( ccc == 'C' ) {

			do_1_cmd_no_save("S");
			send('C');
			while(receive_3() != HAND_SHAKE) 
				if (chk_hlt() == ESC) {
					send_ESC();
					break;
				}
		} else {

			do_1_cmd_no_save("S");
		/* env.Mmodel=8 for 6809 and =7 for ZS8 */
			if (env.CpuType!=5 && env.Mmodel!=8 && env.Mmodel!=7 && 
				env.CpuCode != M68HC11)
				do_1_cmd_no_save("");
		}

        pause_delay(1);
        send(ESC);
//        while(receive_2() != HAND_SHAKE) ;
		sprintf(bbb,"\r%-8lX step!",++i);
		d_prntf(bbb);
		--StepCount;
		RedrawFlag = tmpRedrawFlag; /* restore RedrawFlag */
		MarkNewPCinCodeVP();
		if(!StepCount) RedrawFlag &= ~REDRAWSTA;
		UpdateVP();
		if ( pre_chk_hlt || ( chk_hlt() == ESC ) )  break;
	} while(StepForever==TRUE || StepCount);
	out_flag = tmp_out_flag;
	StaBufRow = STABUFROW;
	RedrawFlag = REDRAWSTA;
	UpdateVP();
	return(TRUE);
}

extern int  (*OldCtrlCHandler)();

USD3CtrlCHandler()
{
 signal( SIGINT, SIG_IGN );

 /* USD-III V2.0x */HideCursor();
 /* USD-III V2.0x */pulldown_or_dialog = DIALOG;
 /* USD-III V2.0x */special_dialog = 1;
 if ( AbortUSD3() ) {
    DestroyVP();
    DestroyMenu();
    WmClose();
    FreeGbl();
    vs_clr();
    USD3vid_setmode( OldVideoMode );
    exit_vv();
    signal( SIGINT, OldCtrlCHandler );
    exit(-1);

 } else {
   /* USD-III V2.0x */ShowCursor();
   /* USD-III V2.0x */pulldown_or_dialog = PULLDOWN;
   /* USD-III V2.0x */special_dialog = 0;
 }

 signal( SIGINT, USD3CtrlCHandler );
}
