
/***************************************************************************
**
**    $Header:   D:/USD3V/LOG/SRC/MENU1.C__   1.2   12 Jun 1996 08:43:42   ZJRD  $
**
**    $Log:   D:/USD3V/LOG/SRC/MENU1.C__  $
** 
**    Rev 1.2   12 Jun 1996 08:43:42   ZJRD
** No change.
** 
**    Rev 1.1   24 May 1996 09:42:28   ZJRD
** No change.
** 
**    Rev 1.0   11 Dec 1995 13:51:48   ZJRD
** Initial revision.
** 
****************************************************************************/
/*--------------------------------------------------------------------------*/
/*  menu1.c  								    */
/*--------------------------------------------------------------------------*/
// This file includes the routines for processing the FILE, SETUP, MEMORY,
// and EMULATION pulldown menus.

#include  "system.h"
#include  "menu.h"
#include  "usd3.h"
#include  "gblext.h"
#include  "oldext.h"
#include  "usym1.h"
#include  "usym3.h"
#include  "dialog.h"
#include  "dlggbl.h"
#include  "funcdecl.h"
#include  "funclist.h"
#include  "funcext.h"

/* USD-III V2.0x */
#define PULLDOWN	1
#define DIALOG		2
extern int pulldown_or_dialog;
/* USD-III V2.0x */

char FormMsg[]       = " <F1> for help, <ESC> to quit, <F6> to clear, <F10> to execute";
char FormMsgFld[]    = "<F1> for help, <ESC> to quit, <F6> to clear, <F10> to execute";
char TFormMsg[]      = " <F1> for help, <ESC> to quit, <F2> to show choices, <F6> to clear, <F10> exec";  
char TFormMsgFld[]   = "<F1> for help, <ESC> to quit, <F2> to show choices, <F6> to clear, <F10> exec";  
char BoolFldMsg[]    = " <F1> for help, <ESC> to quit, <SPACE> to toggle the option, <F10> to execute";
char BoolFldMsgFld[] = "<F1> for help, <ESC> to quit, <SPACE> to toggle the option, <F10> to execute";
int retcode;
UCHAR selection[DATBUFROW];
int selcnt=0,rowcnt;
int MarkIt(),ShowMonData();
extern UCHAR GblDlgColor[];
extern UCHAR GblDlgMono[];

extern  MFILEPTR tmpMFile;

//*-----------------------------------------------------------------------
//*-----------------------------------------------------------------------

ShowShadow(wnp)
WINDOWPTR wnp;
{
/* CORE 90.08.14 Test */
#ifndef NEC_PC9801
	sw_updnfp(wn_expset,wn_expunset,wnp);
	if (vid_getmode() == MONO) memcpy((wnp->lattarray+26),GblDlgMono,3);
	else memcpy((wnp->lattarray+26),GblDlgColor,3);
//	sw_shad(CH_MEDSHADE,LSHADOW,BOTTOMRIGHT,wnp);  
#endif
}

ErrorProc()
{
	WINDOWPTR wnp;
	char temp[20];

	wnp = wn_def(10,16,5,50,LWHI_RED,BDR_DLNP);
	sw_bdratt(LWHI_RED,wnp);
	wn_up(wnp);

	switch (VV_ERR)  {
		case MEMLACK:
			v_st("\nInsufficient memory!\n",wnp);
			break;
		case ERRCLOSE:
			v_st("\nError closing dialog library!\n",wnp);
			break;
		case ERROPEN:
			v_st("\nError opening file!\n",wnp);
			break;
		case FILETOOBIG:
			v_st("\nFile too big to load!\n",wnp);
			break;
		case DL_LIBCOR:
			v_st("\nUnable to access dialog library!\n",wnp);
			break;
		case DL_LOCKED:
			v_st("\nPlease remove USD3DLG.VV$ directory.\n",wnp);
			break;
		case FL_NLIB:
			v_st("\nUnable to find dialog libray file!\n",wnp);
			break;
		case FL_NUNLOCKED:
			v_st("\nFL_NUNLOCKED",wnp);
			sprintf(temp,"\nError code: %d",VV_ERR);
			v_st(temp,wnp);
			break;
		default:
			sprintf(temp,"\nError code: %d",VV_ERR);
			v_st(temp,wnp);
			break;
	}  /* end switch */
	v_st("\nPress any key to continue ... ",wnp);
	ki();
	wn_dn(wnp);
	wn_free(wnp);
	return;
}

/****************************************************************************/
/*  FILE menu Download menu-item					    */
/****************************************************************************/

MN_F_DOWNLOAD( FilMenuCopy )
MFORMPTR  FilMenuCopy;
{
	FDOWNLOAD *datap;
	CLISTPTR clp;
	UCHAR keyword[10];
	DFIELDPTR fldptr;
	WINDOWPTR msgwnp;

	VV_ERR = 0;
	datap = &fdownload;

	DlgFmPtr = dl_fmget("FDownload",datap,usd3dlg,CListMFilePtr,VVDLibp);
 	if (DlgFmPtr == NULLP) {
		ErrorProc();
		return(EXITMENU);
	}
	ShowShadow(DlgFmPtr->wnp);

	if (env.Mmodel == 32) strcpy(keyword,"*68000");
	else if (env.Mmodel==25 || env.Mmodel==33 || env.Mmodel==41)
		strcpy(keyword,"*80386");
	else memset(keyword,NULL,10);
	fldptr = (DFIELDPTR) i_namptr("mode",DlgFmPtr);

	if (strcmp(keyword,"*68000")==0 || strcmp(keyword,"*80386")==0) {
		sf_clist(keyword,CLWRAP|CLAUTOMOVE,CListMFilePtr,fldptr);
		scl_attinact(LFLDACTOFF,fldptr->clistp);
		scl_attact(LFLDACTON,fldptr->clistp);
		sw_bdratt(LFLDACTOFF,fldptr->clistp->wnp);
		scl_help("*DownloadFormat",fldptr->clistp);
		sf_msg(TFormMsgFld,fldptr);
	} else 	{
		sf_opt(SKIP,ON,fldptr);
		DlgFmPtr->itemq--;
	}

	msgwnp = wn_def(vs_rowq()-1,0,1,vs_colq(),LMESSAGE,BDR_NULLP);
	wn_up(msgwnp);
	v_st(FormMsg,msgwnp);
	pulldown_or_dialog = DIALOG;
	retcode = fm_proc(0,DlgFmPtr);
	pulldown_or_dialog = PULLDOWN;
	wn_dn(msgwnp);
	wn_free(msgwnp);
	fm_free(DlgFmPtr);

	if (keyword[0] != NULL) cl_free(fldptr->clistp);
	keyword[0] = '\0';
	if (retcode == AC_EXIT)  {
		if (datap->filename[0] != '\0') {
			ExecDlgFlag = 1;
			strcpy(DlgBuf,"DO ");
			strcat(DlgBuf,datap->filename);
			strcat(DlgBuf," ");
			if (env.Mmodel == 32) {
				if      (stricmp(datap->mode,"User Program") == 0) strcpy(keyword,"UP");
				else if (stricmp(datap->mode,"User Data") == 0)    strcpy(keyword,"UD");
				else if (stricmp(datap->mode,"Supervisor Program") == 0) strcpy(keyword,"SP");
				else if (stricmp(datap->mode,"Supervisor Data") == 0)    strcpy(keyword,"SD");
			} else if (env.Mmodel==25 || env.Mmodel==33 || env.Mmodel==41) {
				if (strstr(datap->mode,"Protecting") != NULL) strcpy(keyword,"P");
				else keyword[0] = '\0';
			}
			strcat(DlgBuf,keyword);
			strcat(DlgBuf,"\r");
		}
	}

	if (retcode == AC_EXIT) return( EXITMENU );
	else if (retcode == AC_QUIT) return(SAMELEVEL);

}  /*  of MN_F_DOWNLOAD()  */

/****************************************************************************/
/*  FILE menu Upload menu-item						    */
/****************************************************************************/

MN_F_UPLOAD( FilMenuCopy )
MFORMPTR  FilMenuCopy;
{
	FUPLOAD *datap;
	CLISTPTR clp;
	UCHAR keyword[10];
	DFIELDPTR fldptr;
	WINDOWPTR msgwnp;

	VV_ERR = 0;
	datap = &fupload;
	DlgFmPtr = dl_fmget("FUpload",datap,usd3dlg,CListMFilePtr,VVDLibp);
 	if (DlgFmPtr == NULLP) {
		ErrorProc();
		return(EXITMENU);
	}
	ShowShadow(DlgFmPtr->wnp);

	memset(keyword,NULL,10);
	if      (env.Mmodel == 32) strcpy(keyword,"*68000");
	else if (env.Mmodel == 16) strcpy(keyword,"*8052");
	else if (env.Mmodel == 35) {
		do_1_cmd_save("ID",MICEBuf,(MICEBUFSIZE+1));
		if (strstr(MICEBuf,"3.3") != NULL)
			strcpy(keyword,"*68030");
	}

	fldptr = (DFIELDPTR) i_namptr("mode",DlgFmPtr);
	if ((strcmp(keyword,"*68000")==0) || (strcmp(keyword,"*8052")==0)
	    || (strcmp(keyword,"*68030")==0)) {
		sf_clist(keyword,CLWRAP|CLAUTOMOVE,CListMFilePtr,fldptr);
		scl_attinact(LFLDACTOFF,fldptr->clistp);
		scl_attact(LFLDACTON,fldptr->clistp);
		sw_bdratt(LFLDACTOFF,fldptr->clistp->wnp);
		scl_help("*UploadFormat",fldptr->clistp);
		sf_msg(TFormMsgFld,fldptr);
	} else  {
		sf_opt(SKIP,ON,fldptr);
		DlgFmPtr->itemq--;
	}

	msgwnp = wn_def(vs_rowq()-1,0,1,vs_colq(),LMESSAGE,BDR_NULLP);
	wn_up(msgwnp);
	v_st(FormMsg,msgwnp);
	pulldown_or_dialog = DIALOG;
	retcode = fm_proc(0,DlgFmPtr);
	pulldown_or_dialog = PULLDOWN;
	wn_dn(msgwnp);
	wn_free(msgwnp);
	fm_free(DlgFmPtr);

	if (keyword[0] != NULL) cl_free(fldptr->clistp);
	if (retcode == AC_EXIT)  {
		if (datap->filename[0] != '\0') {
			ExecDlgFlag = 1;
			strcpy(DlgBuf,"UP ");
			strcat(DlgBuf,datap->filename);
			strcat(DlgBuf," ");
			if (env.Mmodel == 32) {
				if      (strcmp(datap->mode,"User Program") == 0) strcpy(keyword,"UP");
				else if (strcmp(datap->mode,"User Data") == 0)    strcpy(keyword,"UD");
				else if (strcmp(datap->mode,"Supervisor Program") == 0) strcpy(keyword,"SP");
				else if (strcmp(datap->mode,"Supervisor Data") == 0)    strcpy(keyword,"SD");
			} else if (env.Mmodel == 16) {
				if (strstr(datap->mode,"External") != NULL) strcpy(keyword,"X");
				else strcpy(keyword,"P");
			} else if (env.Mmodel == 35) {
				if (strcpy(datap->mode,"Physcial") != NULL) strcpy(keyword,"PHY");
				else strcpy(keyword,"LOG");
			}
			strcat(DlgBuf,keyword);
			strcat(DlgBuf,"\r");
		}
	}

	if (retcode == AC_EXIT) return( EXITMENU );
	else if (retcode == AC_QUIT) return(SAMELEVEL);

}  /*  of MN_F_UPLOAD()  */

/****************************************************************************/
/*  FILE menu Include menu-item						    */
/****************************************************************************/

MN_F_INCLUDE( FilMenuCopy )
MFORMPTR  FilMenuCopy;
{
	FINCLUDE *datap;
	WINDOWPTR msgwnp;

	VV_ERR = 0;
	datap = &finclude;
	DlgFmPtr = dl_fmget("FInclude",datap,NULLP,NULLP,VVDLibp);
 	if (DlgFmPtr == NULLP) {
		ErrorProc();
		return(EXITMENU);
	}
	ShowShadow(DlgFmPtr->wnp);

	msgwnp = wn_def(vs_rowq()-1,0,1,vs_colq(),LMESSAGE,BDR_NULLP);
	wn_up(msgwnp);
	v_st(FormMsg,msgwnp);
	pulldown_or_dialog = DIALOG;
	retcode = fm_proc(0,DlgFmPtr);
	pulldown_or_dialog = PULLDOWN;
	wn_dn(msgwnp);
	wn_free(msgwnp);
	fm_free(DlgFmPtr);

	if (retcode == AC_EXIT)  {
		if (datap->filename[0] != '\0') {
			ExecDlgFlag = 1;
			strcpy(DlgBuf,"INC ");
			strcat(DlgBuf,datap->filename);
			if (datap->arguments[0] != '\0') {
				strcat(DlgBuf," (");
				strcat(DlgBuf,datap->arguments);
				strcat(DlgBuf,")");
			}
			strcat(DlgBuf,"\r");
		}
	}

	if (retcode == AC_EXIT) return( EXITMENU );
	else if (retcode == AC_QUIT) return(SAMELEVEL);

}  /*  of MN_F_INCLUDE()  */

/****************************************************************************/
/*  FILE menu Log File menu-item					    */
/****************************************************************************/

MN_F_LOG( FilMenuCopy )
MFORMPTR  FilMenuCopy;
{
	FLOG *datap;
	DFIELDPTR fldptr;
	WINDOWPTR msgwnp;

	VV_ERR = 0;
  	datap = &flog;
	DlgFmPtr = dl_fmget("FLog",datap,NULLP,NULLP,VVDLibp);
 	if (DlgFmPtr == NULLP) {
		ErrorProc();
		return(EXITMENU);
	}
	ShowShadow(DlgFmPtr->wnp);
	fldptr = (DFIELDPTR) i_namptr("append",DlgFmPtr);
	sf_msg(BoolFldMsgFld,fldptr);
	memset(datap->filename,NULL,20);   
	memcpy(datap->filename,log_cmd_file,12);

	msgwnp = wn_def(vs_rowq()-1,0,1,vs_colq(),LMESSAGE,BDR_NULLP);
	wn_up(msgwnp);
	v_st(FormMsg,msgwnp);
	pulldown_or_dialog = DIALOG;
	retcode = fm_proc(0,DlgFmPtr);
	pulldown_or_dialog = PULLDOWN;
	wn_dn(msgwnp);
	wn_free(msgwnp);
	fm_free(DlgFmPtr);

	if (retcode == AC_EXIT)  {
		if (datap->filename[0] != '\0') {
			ExecDlgFlag = 1;
			strcpy(DlgBuf,"LOG ");
			strcat(DlgBuf,datap->filename);
			if (datap->append == TRUE) strcat(DlgBuf," APPEND");
			strcat(DlgBuf,"\r");
		}
	}

	if (retcode == AC_EXIT) return( EXITMENU );
	else if (retcode == AC_QUIT) return(SAMELEVEL);

}  /*  of MN_F_LOG()  */

/****************************************************************************/
/*  FILE menu DOS      menu-item					    */
/****************************************************************************/

MN_F_DOS( FilMenuCopy )
MFORMPTR  FilMenuCopy;
{
	ExecDlgFlag = 1;
	strcat(DlgBuf,"DOS\r");
	return( EXITMENU );

}  /*  of MN_F_DOS()  */

/****************************************************************************/
/*  FILE menu QUIT     menu-item					    */
/****************************************************************************/

MN_F_QUIT( FilMenuCopy )
MFORMPTR  FilMenuCopy;
{
	ExecDlgFlag = 1;
	strcat(DlgBuf,"QUIT\r");
	return( EXITMENU );

}  /*  of MN_F_QUIT()  */

/****************************************************************************/
/*  FILE menu VERSION    menu-item					    */
/****************************************************************************/

MN_F_VERSION( FilMenuCopy )
MFORMPTR  FilMenuCopy;
{
	return( SAMELEVEL );

}  /*  of MN_F_VERSION()  */

/***************************************************************************/
/* FILE menu Close Log/Journal File dialog                                 */
/***************************************************************************/

MN_F_CLOSE_LOGJOU( FilMenuCopy )
MFORMPTR  FilMenuCopy;
{
	FCLOSELOGJOU *datap;
	DFIELDPTR fldptr;
	WINDOWPTR msgwnp;

	VV_ERR = 0;
	datap = &fcloselogjou;
	DlgFmPtr = dl_fmget("FCloselogjou",datap,NULLP,NULLP,VVDLibp);
 	if (DlgFmPtr == NULLP) {
		ErrorProc();
		return(EXITMENU);
	}
	ShowShadow(DlgFmPtr->wnp);
	memset(datap->logfile,NULL,13);
	memset(datap->joufile,NULL,13);
	memcpy(datap->logfile,log_cmd_file,12);
	memcpy(datap->joufile,log_out_file,12);
	if (log_cmd_file[0] != '\0') datap->log = FALSE;
	if (log_out_file[0] != '\0') datap->journal = FALSE;

	msgwnp = wn_def(vs_rowq()-1,0,1,vs_colq(),LMESSAGE,BDR_NULLP);
	wn_up(msgwnp);
	v_st(BoolFldMsg,msgwnp);
	pulldown_or_dialog = DIALOG;
	retcode = fm_proc(0,DlgFmPtr);
	pulldown_or_dialog = PULLDOWN;
	wn_dn(msgwnp);
	wn_free(msgwnp);
	fm_free(DlgFmPtr);

	if (retcode == AC_EXIT)  {
		ExecDlgFlag = 1;
		if (datap->log == TRUE) {
			if (log_cmd_file[0] != '\0') strcat(DlgBuf,"LOG CLOSE\r");
		}
		if (datap->journal == TRUE) {
			if (log_out_file[0] != '\0') strcat(DlgBuf,"JOU CLOSE\r");
		}
	}

	if (retcode == AC_EXIT) return( EXITMENU );
	else if (retcode == AC_QUIT) return(SAMELEVEL);
}

/****************************************************************************/
/*  FILE menu Journal File menu-item					    */
/****************************************************************************/

MN_F_JOURNAL( FilMenuCopy )
MFORMPTR  FilMenuCopy;
{
	FJOURNAL *datap;
	DFIELDPTR fldptr;
	WINDOWPTR msgwnp;

	VV_ERR = 0;
	datap = &fjournal;
	DlgFmPtr = dl_fmget("FJournal",datap,NULLP,NULLP,VVDLibp);
 	if (DlgFmPtr == NULLP) {
		ErrorProc();
		return(EXITMENU);
	}
	ShowShadow(DlgFmPtr->wnp);
	fldptr = (DFIELDPTR) i_namptr("append",DlgFmPtr);
	sf_msg(BoolFldMsgFld,fldptr);
	memset(datap->filename,NULL,20);
	memcpy(datap->filename,log_out_file,12);

	msgwnp = wn_def(vs_rowq()-1,0,1,vs_colq(),LMESSAGE,BDR_NULLP);
	wn_up(msgwnp);
	v_st(FormMsg,msgwnp);
	pulldown_or_dialog = DIALOG;
	retcode = fm_proc(0,DlgFmPtr);
	pulldown_or_dialog = PULLDOWN;
	wn_dn(msgwnp);
	wn_free(msgwnp);
	fm_free(DlgFmPtr);

	if (retcode == AC_EXIT)  {
		if (datap->filename[0] != '\0') {
			ExecDlgFlag = 1;
			strcpy(DlgBuf,"JO ");
			strcat(DlgBuf,datap->filename);
			if (datap->append == TRUE) strcat(DlgBuf," APPEND");
			strcat(DlgBuf,"\r");
		}
	}

	if (retcode == AC_EXIT) return( EXITMENU );
	else if (retcode == AC_QUIT) return(SAMELEVEL);

}  /*  of MN_F_JOURNAL()  */

/****************************************************************************/
/*  SETUP menu Map menu-item						    */
/****************************************************************************/

MN_S_MAP( SetMenuCopy )
MFORMPTR  SetMenuCopy;
{
	SMAP *datap;
	WINDOWPTR msgwnp;

	VV_ERR = 0;
	datap = &smap;
	DlgFmPtr = dl_fmget("SMap",datap,usd3dlg,NULLP,VVDLibp);
 	if (DlgFmPtr == NULLP) {
		ErrorProc();
		return(EXITMENU);
	}
	ShowShadow(DlgFmPtr->wnp);

	msgwnp = wn_def(vs_rowq()-1,0,1,vs_colq(),LMESSAGE,BDR_NULLP);
	wn_up(msgwnp);
	v_st(FormMsg,msgwnp);
	pulldown_or_dialog = DIALOG;
	retcode = fm_proc(0,DlgFmPtr);
	pulldown_or_dialog = PULLDOWN;
	wn_dn(msgwnp);
	wn_free(msgwnp);
	fm_free(DlgFmPtr);

	if (retcode == AC_EXIT)  {
		ExecDlgFlag = 1;
		if (env.MICEGroup == MICE2) strcat(DlgBuf,"*M");
		else strcat(DlgBuf,"MA");
		if (datap->mapbeg[0] != '\0')  {
			strcat(DlgBuf," ");
			strcat(DlgBuf,datap->mapbeg);
			strcat(DlgBuf," ");
			strcat(DlgBuf,datap->mapend);
			strcat(DlgBuf," ");
			strcat(DlgBuf,datap->mapattr);
		} else if (datap->mapattr[0] != '\0') {
			strcat(DlgBuf," ");
			strcat(DlgBuf,datap->mapattr);
		}
		strcat(DlgBuf,"\r");
	}
			
	if (retcode == AC_EXIT) return( EXITMENU );
	else if (retcode == AC_QUIT) return(SAMELEVEL);

}  /*  of MN_S_MAP()  */

SMapBegFmShow(dfmptr)
DFORMPTR dfmptr;
{
	WINDOWPTR wnp,msgwnp;
	char tbuf[220],*ptr,*sptr,c;

	strcpy(tbuf,((env.Mmodel >= MICE_3_BOUND) ? "MA" : "*M"));
	do_1_cmd_save(tbuf,MICEBuf,(MICEBUFSIZE+1));
	if (strchr(MICEBuf,'!') != NULL) return(TRUE);

	wnp = wn_def(CENTER_WN,CENTER_WN,19,78,LCYA_BLU,BDR_SLNP);
	sw_title(" MEMORY SETTING ",LBRO_BLU,TOPCENTER,wnp);
	wn_up(wnp);
	msgwnp = wn_def(vs_rowq()-1,0,1,vs_colq(),LMESSAGE,BDR_NULLP);
	wn_up(msgwnp);
	v_st("<ESC> to exit",msgwnp);

	sptr=MICEBuf;
	while (*sptr == 0x20) sptr++;
	ptr=sptr-1;
	do {
		while ((c=*++ptr) && c!=LF && c!=CR && c!='\0') ;
		if (c == LF)   {
			*ptr = '\0';
			if (*sptr != '\0') v_st(sptr,wnp);
			if ((c=*++ptr) == CR) sptr = ptr+1;
		}
	} while (c != '\0');
	wn_browse(wnp);
	wn_dn(wnp);
	wn_free(wnp);
	wn_dn(msgwnp);
	wn_free(msgwnp);
	return(TRUE);
}

/****************************************************************************/
/*  SETUP menu Recall menu-item						    */
/****************************************************************************/

MN_S_RECALL( SetMenuCopy )
MFORMPTR  SetMenuCopy;
{
	ExecDlgFlag = 1;
	if (env.MICEGroup == MICE2) strcat(DlgBuf,"*RE\r");
	else strcat(DlgBuf,"REC\r");
	return( EXITMENU );

}  /*  of MN_S_RECALL()  */

/****************************************************************************/
/*  SETUP menu Save menu-item						    */
/****************************************************************************/

MN_S_SAVE( SetMenuCopy )
MFORMPTR  SetMenuCopy;
{
	ExecDlgFlag = 1;
	if (env.MICEGroup == MICE2) strcat(DlgBuf,"*S\r");
	else strcat(DlgBuf,"SA\r");
	return( EXITMENU );

}  /*  of MN_S_SAVE()  */

/****************************************************************************/
/*  MEMORY menu Checksum menu-item					    */
/****************************************************************************/

MN_M_CHECKSUM( MemMenuCopy )
MFORMPTR  MemMenuCopy;
{
	MCHECKSUM *datap;
	WINDOWPTR msgwnp;

	VV_ERR = 0;
	datap = &mchecksum;
	DlgFmPtr = dl_fmget("MChecksum",datap,NULLP,NULLP,VVDLibp);
 	if (DlgFmPtr == NULLP) {
		ErrorProc();
		return(EXITMENU);
	}
	ShowShadow(DlgFmPtr->wnp);

	msgwnp = wn_def(vs_rowq()-1,0,1,vs_colq(),LMESSAGE,BDR_NULLP);
	wn_up(msgwnp);
	v_st(FormMsg,msgwnp);
	pulldown_or_dialog = DIALOG;
	retcode = fm_proc(0,DlgFmPtr);
	pulldown_or_dialog = PULLDOWN;
	wn_dn(msgwnp);
	wn_free(msgwnp);
	fm_free(DlgFmPtr);

	if (retcode == AC_EXIT)  {
		ExecDlgFlag = 1;
		if (env.MICEGroup == MICE2) strcat(DlgBuf,"T ");
		else strcat(DlgBuf,"CH ");
		strcat(DlgBuf,datap->checkbegin);
		strcat(DlgBuf," ");
		strcat(DlgBuf,datap->checkend);
		if (env.MICEGroup == MICE2) strcat(DlgBuf," S\r");
		else strcat(DlgBuf,"\r");
	}
			
	if (retcode == AC_EXIT) return( EXITMENU );
	else if (retcode == AC_QUIT) return(SAMELEVEL);

}  /*  of MN_M_CHECKSUM()  */

/****************************************************************************/
/*  MEMORY menu Compare menu-item					    */
/****************************************************************************/

MN_M_COMPARE( MemMenuCopy )
MFORMPTR  MemMenuCopy;
{
	MCOMPARE *datap;
	WINDOWPTR msgwnp;

	VV_ERR = 0;
	datap = &mcompare;
	DlgFmPtr = dl_fmget("MCompare",datap,NULLP,NULLP,VVDLibp);
 	if (DlgFmPtr == NULLP) {
		ErrorProc();
		return(EXITMENU);
	}
	ShowShadow(DlgFmPtr->wnp);

	msgwnp = wn_def(vs_rowq()-1,0,1,vs_colq(),LMESSAGE,BDR_NULLP);
	wn_up(msgwnp);
	v_st(FormMsg,msgwnp);
	pulldown_or_dialog = DIALOG;
	retcode = fm_proc(0,DlgFmPtr);
	pulldown_or_dialog = PULLDOWN;
	wn_dn(msgwnp);
	wn_free(msgwnp);
	fm_free(DlgFmPtr);

	if (retcode == AC_EXIT)  {
		ExecDlgFlag = 1;
		if (env.MICEGroup == MICE2) strcat(DlgBuf,"T ");
		else strcat(DlgBuf,"COM ");
		strcat(DlgBuf,datap->compbeg);
		strcat(DlgBuf," ");
		strcat(DlgBuf,datap->compend);
		strcat(DlgBuf," ");
		strcat(DlgBuf,datap->compdest);
		if (env.MICEGroup == MICE2) strcat(DlgBuf," V\r");
		else strcat(DlgBuf,"\r");
	}
			
	if (retcode == AC_EXIT) return( EXITMENU );
	else if (retcode == AC_QUIT) return(SAMELEVEL);

}  /*  of MN_M_COMPARE()  */

/****************************************************************************/
/*  MEMORY menu Copy menu-item						    */
/****************************************************************************/

MN_M_COPY( MemMenuCopy )
MFORMPTR  MemMenuCopy;
{
	MCOPY *datap;
	WINDOWPTR msgwnp;

	VV_ERR = 0;
	datap = &mcopy;
	DlgFmPtr = dl_fmget("MCopy",datap,NULLP,NULLP,VVDLibp);
 	if (DlgFmPtr == NULLP) {
		ErrorProc();
		return(EXITMENU);
	}
	ShowShadow(DlgFmPtr->wnp);

	msgwnp = wn_def(vs_rowq()-1,0,1,vs_colq(),LMESSAGE,BDR_NULLP);
	wn_up(msgwnp);
	v_st(FormMsg,msgwnp);
	pulldown_or_dialog = DIALOG;
	retcode = fm_proc(0,DlgFmPtr);
	pulldown_or_dialog = PULLDOWN;
	wn_dn(msgwnp);
	wn_free(msgwnp);
	fm_free(DlgFmPtr);

	if (retcode == AC_EXIT)  {
		ExecDlgFlag = 1;
		if (env.MICEGroup == MICE2) strcat(DlgBuf,"T ");
		else strcat(DlgBuf,"CO ");
		strcat(DlgBuf,datap->copybeg);
		strcat(DlgBuf," ");
		strcat(DlgBuf,datap->copyend);
		if (env.MICEGroup == MICE2) {
			strcat(DlgBuf," ");
			strcat(DlgBuf,datap->copydest);
		} else if (datap->copydest[0] != '\0')  {
			strcat(DlgBuf," ");
			strcat(DlgBuf,datap->copydest);
		}
		strcat(DlgBuf,"\r");
	}
			
	if (retcode == AC_EXIT) return( EXITMENU );
	else if (retcode == AC_QUIT) return(SAMELEVEL);

}  /*  of MN_M_COPY()  */

/****************************************************************************/
/*  MEMORY menu Disassembly menu-item					    */
/****************************************************************************/

MN_M_DISASSEMBLY( MemMenuCopy )
MFORMPTR  MemMenuCopy;
{
	MDISASSEMBLY *datap;
	WINDOWPTR msgwnp;

	VV_ERR = 0;
	datap = &mdisassembly;
	DlgFmPtr = dl_fmget("MDisassembly",datap,NULLP,NULLP,VVDLibp);
 	if (DlgFmPtr == NULLP) {
		ErrorProc();
		return(EXITMENU);
	}
	ShowShadow(DlgFmPtr->wnp);

	msgwnp = wn_def(vs_rowq()-1,0,1,vs_colq(),LMESSAGE,BDR_NULLP);
	wn_up(msgwnp);
	v_st(FormMsg,msgwnp);
	pulldown_or_dialog = DIALOG;
	retcode = fm_proc(0,DlgFmPtr);
	pulldown_or_dialog = PULLDOWN;
	wn_dn(msgwnp);
	wn_free(msgwnp);
	fm_free(DlgFmPtr);

	if (retcode == AC_EXIT)  {
		ExecDlgFlag = 1;
		if (env.MICEGroup == MICE2) strcat(DlgBuf,"Z");
		else strcat(DlgBuf,"D");
		if (datap->disasmbeg[0] != '\0') {
			strcat(DlgBuf," ");
			strcat(DlgBuf,datap->disasmbeg);
			if (datap->disasmend[0] != '\0') {
				strcat(DlgBuf," ");
				strcat(DlgBuf,datap->disasmend);
			}
		}
		strcat(DlgBuf,"\r");
	}
			
	if (retcode == AC_EXIT) return( EXITMENU );
	else if (retcode == AC_QUIT) return(SAMELEVEL);

}  /*  of MN_M_DISASSEMBLY()  */

/****************************************************************************/
/*  MEMORY menu Dump menu-item						    */
/****************************************************************************/

MN_M_DUMP( MemMenuCopy )
MFORMPTR  MemMenuCopy;
{
	MDUMP *datap;
	WINDOWPTR msgwnp;

	VV_ERR = 0;
	datap = &mdump;
	DlgFmPtr = dl_fmget("MDump",datap,NULLP,NULLP,VVDLibp);
 	if (DlgFmPtr == NULLP) {
		ErrorProc();
		return(EXITMENU);
	}
	ShowShadow(DlgFmPtr->wnp);

	msgwnp = wn_def(vs_rowq()-1,0,1,vs_colq(),LMESSAGE,BDR_NULLP);
	wn_up(msgwnp);
	v_st(FormMsg,msgwnp);
	pulldown_or_dialog = DIALOG;
	retcode = fm_proc(0,DlgFmPtr);
	pulldown_or_dialog = PULLDOWN;
	wn_dn(msgwnp);
	wn_free(msgwnp);
	fm_free(DlgFmPtr);

	if (retcode == AC_EXIT)  {
		ExecDlgFlag = 1;
		strcat(DlgBuf,"M");
		if (datap->dumpbeg[0] != '\0') {
			strcat(DlgBuf," ");
			strcat(DlgBuf,datap->dumpbeg);
			if (datap->dumpend[0] != '\0') {
				strcat(DlgBuf," ");
				strcat(DlgBuf,datap->dumpend);
			}
		}
		strcat(DlgBuf,"\r");
	}
			
	if (retcode == AC_EXIT) return( EXITMENU );
	else if (retcode == AC_QUIT) return(SAMELEVEL);

}  /*  of MN_M_DUMP()  */

/****************************************************************************/
/*  MEMORY menu Fill menu-item						    */
/****************************************************************************/

MN_M_FILL( MemMenuCopy )
MFORMPTR  MemMenuCopy;
{
	MFILL *datap;
	WINDOWPTR msgwnp;

	VV_ERR = 0;
	datap = &mfill;
	DlgFmPtr = dl_fmget("MFill",datap,NULLP,NULLP,VVDLibp);
 	if (DlgFmPtr == NULLP) {
		ErrorProc();
		return(EXITMENU);
	}
	ShowShadow(DlgFmPtr->wnp);

	msgwnp = wn_def(vs_rowq()-1,0,1,vs_colq(),LMESSAGE,BDR_NULLP);
	wn_up(msgwnp);
	v_st(FormMsg,msgwnp);
	pulldown_or_dialog = DIALOG;
	retcode = fm_proc(0,DlgFmPtr);
	pulldown_or_dialog = PULLDOWN;
	wn_dn(msgwnp);
	wn_free(msgwnp);
	fm_free(DlgFmPtr);

	if (retcode == AC_EXIT)  {
		ExecDlgFlag = 1;
		if (env.MICEGroup == MICE2) strcat(DlgBuf,"M ");
		else strcat(DlgBuf,"F ");
		strcat(DlgBuf,datap->fillbeg);
		strcat(DlgBuf," ");
		strcat(DlgBuf,datap->fillend);
		strcat(DlgBuf," ");
		strcat(DlgBuf,datap->data);
		strcat(DlgBuf,"\r");
	}
			
	if (retcode == AC_EXIT) return( EXITMENU );
	else if (retcode == AC_QUIT) return(SAMELEVEL);

}  /*  of MN_M_FILL()  */

/****************************************************************************/
/*  MEMORY menu Search menu-item					    */
/****************************************************************************/

MN_M_SEARCH( MemMenuCopy )
MFORMPTR  MemMenuCopy;
{
	MSEARCH *datap;
	WINDOWPTR msgwnp;

	VV_ERR = 0;
	datap = &msearch;
	DlgFmPtr = dl_fmget("MSearch",datap,NULLP,NULLP,VVDLibp);
 	if (DlgFmPtr == NULLP) {
		ErrorProc();
		return(EXITMENU);
	}
	ShowShadow(DlgFmPtr->wnp);

	msgwnp = wn_def(vs_rowq()-1,0,1,vs_colq(),LMESSAGE,BDR_NULLP);
	wn_up(msgwnp);
	v_st(FormMsg,msgwnp);
	pulldown_or_dialog = DIALOG;
	retcode = fm_proc(0,DlgFmPtr);
	pulldown_or_dialog = PULLDOWN;
	wn_dn(msgwnp);
	wn_free(msgwnp);
	fm_free(DlgFmPtr);

	if (retcode == AC_EXIT)  {
		ExecDlgFlag = 1;
		if (env.MICEGroup == MICE2) strcat(DlgBuf,"M ");
		else strcat(DlgBuf,"SE ");
		strcat(DlgBuf,datap->searchbeg);
		strcat(DlgBuf," ");
		strcat(DlgBuf,datap->searchend);
		strcat(DlgBuf," ");
		strcat(DlgBuf,datap->data);
		if (env.MICEGroup == MICE2) strcat(DlgBuf," S\r");
		else strcat(DlgBuf,"\r");
	}
			
	if (retcode == AC_EXIT) return( EXITMENU );
	else if (retcode == AC_QUIT) return(SAMELEVEL);

}  /*  of MN_M_SEARCH()  */

/****************************************************************************/
/*  MEMORY menu Test menu-item						    */
/****************************************************************************/

MN_M_TEST( MemMenuCopy )
MFORMPTR  MemMenuCopy;
{
	MTEST *datap;
	WINDOWPTR msgwnp;

	VV_ERR = 0;
	datap = &mtest;
	DlgFmPtr = dl_fmget("MTest",datap,NULLP,NULLP,VVDLibp);
 	if (DlgFmPtr == NULLP) {
		ErrorProc();
		return(EXITMENU);
	}
	ShowShadow(DlgFmPtr->wnp);

	msgwnp = wn_def(vs_rowq()-1,0,1,vs_colq(),LMESSAGE,BDR_NULLP);
	wn_up(msgwnp);
	v_st(FormMsg,msgwnp);
	pulldown_or_dialog = DIALOG;
	retcode = fm_proc(0,DlgFmPtr);
	pulldown_or_dialog = PULLDOWN;
	wn_free(msgwnp);
	fm_free(DlgFmPtr);

	if (retcode == AC_EXIT)  {
		ExecDlgFlag = 1;
		if (env.MICEGroup == MICE2) strcat(DlgBuf,"T ");
		else strcat(DlgBuf,"TE ");
		strcat(DlgBuf,datap->testbeg);
		strcat(DlgBuf," ");
		strcat(DlgBuf,datap->testend);
		if (env.MICEGroup == MICE2) strcat(DlgBuf," M\r");
		else strcat(DlgBuf,"\r");
	}
			
	if (retcode == AC_EXIT) return( EXITMENU );
	else if (retcode == AC_QUIT) return(SAMELEVEL);

}  /*  of MN_M_TEST()  */

/****************************************************************************/
/*  MEMORY menu MONITOR menu-item               			    */
/****************************************************************************/

MN_M_MONITOR( MemMenuCopy )
MFORMPTR  MemMenuCopy;
{
	MMONITOR *datap;
	WINDOWPTR msgwnp;
	DFIELDPTR fldptr;
	int i;
	char tt[10];
	KEYFP tmpF2;

	VV_ERR = 0;
	datap = &mmonitor;
	if (datap->operation == FALSE) datap->variable[0] = '\0';
	DlgFmPtr = dl_fmget("MMonitor",datap,usd3dlg,CListMFilePtr,VVDLibp);
 	if (DlgFmPtr == NULLP) {
		ErrorProc();
		return(EXITMENU);
	}
	ShowShadow(DlgFmPtr->wnp);
	fldptr = (DFIELDPTR) i_namptr("element",DlgFmPtr);
	sf_msg(FormMsgFld,fldptr);

	if (NextMonVarEntry > 0) tmpF2 = kt_rplkey(KEY_F2,(KEYFP) ShowMonData,TTMEMOKTP);
	msgwnp = wn_def(vs_rowq()-1,0,1,vs_colq(),LMESSAGE,BDR_NULLP);
	wn_up(msgwnp);
	v_st(TFormMsg,msgwnp);
	pulldown_or_dialog = DIALOG;
	retcode = fm_proc(0,DlgFmPtr);
	pulldown_or_dialog = PULLDOWN;
	wn_free(msgwnp);
	fm_free(DlgFmPtr);
	if (NextMonVarEntry > 0) kt_rplkey(KEY_F2,tmpF2,TTMEMOKTP);

	if (retcode == AC_EXIT)  {
		ExecDlgFlag = 1;
		if (strstr(datap->operation,"ALL") != NULL)
			strcat(DlgBuf,"NOM\r");
		else if (strstr(datap->operation,"SET") != NULL) {
			strcat(DlgBuf,"MON ");
			strcat(DlgBuf,datap->variable);
			strcat(DlgBuf," ");
			strcat(DlgBuf,datap->element);
			strcat(DlgBuf," ");
			strcat(DlgBuf,datap->type);
			strcat(DlgBuf,"\r");
		} else if (strstr(datap->operation,"CLEAR") != NULL) {
			for (i=rowcnt-1; i >= 0; i--) {
				if (selection[i]) {
					sprintf(tt,"NOM %d\r",i+1);
					strcat(DlgBuf,tt);
				}
			}
		}
	}
			
	memset(selection,NULL,sizeof(selection));
	if (retcode == AC_EXIT) return( EXITMENU );
	else if (retcode == AC_QUIT) return(SAMELEVEL);
}

ShowMonData(keyptr)
KEYCTRLPTR keyptr;
{
	KEYFP tmpEnter,tmpESC;
	CLISTPTR clistp;
	WINDOWPTR msgwnp;
	MEMOPTR memoptr;
	DFIELDPTR fldptr;
	int i,j;
	int lc[DATBUFROW+1];
	MFILEPTR tmpMFile;
	UCHAR rowbuf[30],tt[5];

	fldptr = (DFIELDPTR) i_namptr("operation",DlgFmPtr);
	fld_get(fldptr->datap,i_namnum("operation",DlgFmPtr),DlgFmPtr);
	if (strstr(fldptr->datap,"SET") != NULL) return(TRUE);
	else if (strstr(fldptr->datap,"ALL") != NULL) return(TRUE);
	else if (strcmp(fldptr->datap,"") == 0) return(TRUE);
	if (NextMonVarEntry == 0) return(TRUE);

	memoptr = (MEMOPTR) i_namptr("variable",DlgFmPtr);
	if (memoptr->datap[0] != '\0')  {
		memoptr->datap[0] = '\0';
		memo_upd(memoptr->datap,i_namnum("variable",DlgFmPtr),DlgFmPtr);
	}
		
	memset(lc,NULL,sizeof(lc));
	memset(selection,NULL,sizeof(selection));
	for (i=0,rowcnt=0; i < NextMonVarEntry; i++) {
		if (MonVar[i].Num != 0) rowcnt++;
		else lc[rowcnt]++;
	}
	tmpMFile = mf_def(rowcnt+1,28);
	if (tmpMFile == NULLP) {
		ErrorProc();
		return(EXITMENU);
	}
	for (i=0,j=1; i < NextMonVarEntry; i++) {
		if (MonVar[i].Num != 0) {
			memset(rowbuf,NULL,30);
			sprintf(rowbuf,"  %2d. ",MonVar[i].Num);
			if (MonVar[i].Sym[0] != NULL) strcat(rowbuf,MonVar[i].Sym);
			else strcat(rowbuf,MonVar[i].Addr);
			strcat(rowbuf," ");
			if (lc[j] != 0) {
				sprintf(tt," %d ",lc[j]+1);
				strcat(rowbuf,tt);
			}
			if      (MonVar[i].Type == 0) strcat(rowbuf,"BYTE");
			else if (MonVar[i].Type == 1) strcat(rowbuf,"WORD");
			else if (MonVar[i].Type == 2) strcat(rowbuf,"LONG");
//			if (selection[j-1]) rowbuf[0] = 251;
			mf_rowins(rowbuf,APPEND_ROW,tmpMFile);
			j++;
		}
	}  // end for: to insert row to mem file

	if (rowcnt > 10) i = 10;
	else i = rowcnt;
	memoptr = (MEMOPTR) i_namptr("variable",DlgFmPtr);
	clistp = cl_def(memoptr->wnp->rb+1,memoptr->wnp->cb-8,i+2,32,BDR_SLNP,NULLP,tmpMFile);
	if (clistp == NULLP) {
		ErrorProc();
		mf_free(tmpMFile);
		return(EXITMENU);
	}
	scl_opt(CLWRAP,ON,clistp);
	scl_attinact(LFLDACTOFF,clistp);
	scl_attact(LFLDACTON,clistp);
	sw_bdratt(LFLDACTOFF,clistp->wnp);
	scl_help("*MonitorVariable",clistp);
	if (rowcnt > 10) sw_sb(AUTOUPD,VSBAR,clistp->wnp);
	tmpEnter = kt_rplkey(KEY_ENTER,(KEYFP) MarkIt,CLKTP);
	tmpESC = kt_rplkey(KEY_ESC,k_quit,CLKTP);
	
	memset(lc,NULL,sizeof(lc));
	msgwnp = wn_def(vs_rowq()-1,0,1,vs_colq(),LMESSAGE,BDR_NULLP);
	wn_up(msgwnp);
	v_st("<F1> for help, <ESC> to quit, <CR> to select, <F10> to exit",msgwnp);
	cl_up(clistp);
	while (((retcode=cl_rd(cl_curnum(clistp),clistp)) != AC_EXIT) && (retcode != AC_QUIT)) ;
	cl_dn(clistp);
	cl_free(clistp);
	mf_free(tmpMFile);
	wn_dn(msgwnp);
	wn_free(msgwnp);

	kt_rplkey(KEY_ENTER,tmpEnter,CLKTP);
	kt_rplkey(KEY_ESC,tmpESC,CLKTP);
	
	if (retcode == AC_EXIT) {
		if (selcnt > 0) {
			strcpy(memoptr->datap,"<< selected >>");
			memo_upd(memoptr->datap,curitemnum(DlgFmPtr),DlgFmPtr);
		}
	} else memset(selection,NULL,sizeof(selection));

	return(TRUE);
}

MarkIt(keyptr)
KEYCTRLPTR  keyptr;
{
	CLISTPTR clistp;
	UCHAR rowbuf[30];
	int i;

	clistp = (CLISTPTR) keyptr;
	i = cl_curnum(clistp);
	cl_curtxt(rowbuf,clistp);
	if ((rowbuf[0] == 0x20) && !selection[i]) {
		rowbuf[0] = 251;
		selection[i] = 1;
		selcnt++;
	} else if ((rowbuf[0] == 251) && selection[i]) {
		rowbuf[0] = 0x20;
		selection[i]--;
		selcnt--;
	}
	cli_rpl(rowbuf,cl_curnum(clistp),clistp);
	cl_upd(clistp);
	kv_dn(keyptr);
	return(1);
}

MonitorOpEnd(dfmptr)
DFORMPTR dfmptr;
{
	DFIELDPTR fldptr;
	MEMOPTR memoptr;

	fldptr = (DFIELDPTR) i_namptr("operation",DlgFmPtr);
	fld_get(fldptr->datap,i_namnum("operation",DlgFmPtr),DlgFmPtr);
	if (strstr(fldptr->datap,"CLEAR") != NULL) {
		memoptr = (MEMOPTR) i_namptr("variable",dfmptr);
		memoptr->datap[0] = '\0';
		memo_upd(memoptr->datap,i_namnum("variable",dfmptr),dfmptr);
		if (strstr(fldptr->datap,"ALL") != NULL) 
			sf_opt(SKIP,ON,memoptr);
		else    sf_opt(SKIP,OFF,memoptr);
		fldptr = (DFIELDPTR) i_namptr("element",dfmptr);
		fld_upd(fldptr->datap,i_namnum("element",dfmptr),dfmptr);
		sf_opt(SKIP,ON,fldptr);
		fldptr = (DFIELDPTR) i_namptr("type",dfmptr);
		fld_upd(fldptr->datap,i_namnum("type",dfmptr),dfmptr);
		sf_opt(SKIP,ON,fldptr);
	} else if (strstr(fldptr->datap,"SET") != NULL) {
		memoptr = (MEMOPTR) i_namptr("variable",dfmptr);
		memoptr->datap[0] = NULL;
		memo_upd(memoptr->datap,i_namnum("variable",dfmptr),dfmptr);
		sf_opt(SKIP,OFF,memoptr);
		fldptr = (DFIELDPTR) i_namptr("element",dfmptr);
		strcpy(fldptr->datap,"");
		fld_upd(fldptr->datap,i_namnum("element",dfmptr),dfmptr);
		sf_opt(SKIP,OFF,fldptr);
		fldptr = (DFIELDPTR) i_namptr("type",dfmptr);
		strcpy(fldptr->datap,"");
		fld_upd(fldptr->datap,i_namnum("type",dfmptr),dfmptr);
		sf_opt(SKIP,OFF,fldptr);
	}
	return(TRUE);
}

MonitorVarBegin(dfmptr)
DFORMPTR dfmptr;
{
	DFIELDPTR fldptr;
	
	fldptr = (DFIELDPTR) i_namptr("operation",dfmptr);
	fld_get(fldptr->datap,i_namnum("operation",dfmptr),dfmptr);
	if ((strstr(fldptr->datap,"CLEAR") != NULL) &&
	    (strstr(fldptr->datap,"ALL")   == NULL))
		ShowMonData((KEYCTRLPTR)dfmptr);
	return(TRUE);
}


/****************************************************************************/
/*  EMULATION menu Istep menu-item					    */
/****************************************************************************/

MN_E_ISTEP( EmuMenuCopy )
MFORMPTR  EmuMenuCopy;
{
	ExecDlgFlag = 1;
	strcat(DlgBuf,"IS\r");
	return( EXITMENU );

}  /*  of MN_E_ISTEP()  */

/****************************************************************************/
/*  EMULATION menu Istep Over menu-item					    */
/****************************************************************************/

MN_E_ISTEP_OVER( EmuMenuCopy )
MFORMPTR  EmuMenuCopy;
{
	ExecDlgFlag = 1;
	strcat(DlgBuf,"IS O\r");
	return( EXITMENU );

}  /*  of MN_E_ISTEP_OVER()  */

/****************************************************************************/
/*  EMULATION menu Istep Forever menu-item				    */
/****************************************************************************/

MN_E_ISTEP_FOREVER( EmuMenuCopy )
MFORMPTR  EmuMenuCopy;
{
	ExecDlgFlag = 1;
	strcat(DlgBuf,"IS FO\r");
	return( EXITMENU );

}  /*  of MN_E_ISTEP_FOREVER()  */

/****************************************************************************/
/*  EMULATION menu Istep Over Forever menu-item				    */
/****************************************************************************/

MN_E_ISTEP_OVER_FOREVER( EmuMenuCopy )
MFORMPTR  EmuMenuCopy;
{
	ExecDlgFlag = 1;
	strcat(DlgBuf,"IS O FO\r");
	return( EXITMENU );

}  /*  of MN_E_ISTEP_OVER_FOREVER()  */

/****************************************************************************/
/*  EMULATION menu Cycle menu-item					    */
/****************************************************************************/

MN_E_CYCLE( EmuMenuCopy )
MFORMPTR  EmuMenuCopy;
{
	ExecDlgFlag = 1;
	strcat(DlgBuf,"C\r");
	return( EXITMENU );

}  /*  of MN_E_CYCLE()  */


