
/***************************************************************************
**
**    $Header:   D:/USD3V/LOG/SRC/MENU3.C__   1.2   12 Jun 1996 08:43:46   ZJRD  $
**
**    $Log:   D:/USD3V/LOG/SRC/MENU3.C__  $
** 
**    Rev 1.2   12 Jun 1996 08:43:46   ZJRD
** No change.
** 
**    Rev 1.1   24 May 1996 09:41:36   ZJRD
** No change.
** 
**    Rev 1.0   11 Dec 1995 13:51:28   ZJRD
** Initial revision.
** 
****************************************************************************/
/*--------------------------------------------------------------------------*/
/*  menu3.c  								    */
/*--------------------------------------------------------------------------*/
// This file includes the routines for processing the SYMBOL, OPTION, SPA, 
// and LSA pulldown menus.
#include  "system.h"
#include  "menu.h"
#include  "usd3.h"
#include  "gblext.h"
#include  "oldext.h"
#include  "usym1.h"
#include  "usym3.h"
#include  "dialog.h"
#include  "dlgext.h"
#include  "funcdecl.h"
#include  "funcext.h"

/* USD-III V2.0x */
#define PULLDOWN	1
#define DIALOG		2
extern int pulldown_or_dialog;
/* USD-III V2.0x */

extern FUNCLIS usd3dlg[];  
extern char FormMsg[]       ; 
extern char FormMsgFld[]    ; 
extern char TFormMsg[]      ; 
extern char TFormMsgFld[]   ; 
extern char BoolFldMsg[]    ; 
extern char BoolFldMsgFld[] ;
extern int retcode;

extern MFILEPTR tmpMFile;

UCHAR selection[DATBUFROW];
UCHAR GblDlgColor[3]= { catt_def(0xe,0x1),	// LFORMS     yellow on blue
		        catt_def(0x1,0xe),	// LFLDACTON  blue on yellow
		        catt_def(0xe,0x3) };	// LFLDACTOFF yellow on cyan
UCHAR GblDlgMono[3]  = { NORMAL,           	// LFORMS
		         REVERSE,		// LFLDACTON
		         UNDERLINE };	     	// LFLDACTOFF

/****************************************************************************/
/*  SYMBOL menu List menu-item						    */
/****************************************************************************/

MN_Y_LIST( SymMenuCopy )
MFORMPTR  SymMenuCopy;
{
	ExecDlgFlag = 1;
	strcat(DlgBuf,"SYM A\r");
	return( EXITMENU );

}  /*  of MN_Y_LIST()  */

/****************************************************************************/
/*  SYMBOL menu Load menu-item						    */
/****************************************************************************/

MN_Y_LOAD( SymMenuCopy )
MFORMPTR  SymMenuCopy;
{
	YLOAD *datap;
	WINDOWPTR msgwnp;

	VV_ERR = 0;
	datap = &yload;
	DlgFmPtr = dl_fmget("YLoad",datap,NULLP,NULLP,VVDLibp);
 	if (DlgFmPtr == NULLP) {
		ErrorProc();
		return(EXITMENU);
	}
	ShowShadow(DlgFmPtr->wnp);

	msgwnp = wn_def(vs_rowq()-1,0,1,vs_colq(),LMESSAGE,BDR_NULLP);
	wn_up(msgwnp);
	v_st(FormMsg,msgwnp);
	pulldown_or_dialog = DIALOG;
	retcode = fm_proc(0,DlgFmPtr);
	pulldown_or_dialog = PULLDOWN;
	wn_dn(msgwnp);
	wn_free(msgwnp);
	fm_free(DlgFmPtr);

	if (retcode == AC_EXIT)  {
		if (datap->filename[0] != '\0') {
			ExecDlgFlag = 1;
			strcat(DlgBuf,"LOA ");
			strcat(DlgBuf,datap->filename);
			strcat(DlgBuf,"\r");
		}
	}

	if (retcode == AC_EXIT) return( EXITMENU );
	else if (retcode == AC_QUIT) return(SAMELEVEL);

}  /*  of MN_Y_LOAD()  */

/****************************************************************************/
/*  SYMBOL menu Create menu-item					    */
/****************************************************************************/

MN_Y_CREATE( SymMenuCopy )
MFORMPTR  SymMenuCopy;
{
	YCREATE *datap;
	WINDOWPTR msgwnp;
	char *ptr;

	VV_ERR = 0;
	datap = &ycreate;
	DlgFmPtr = dl_fmget("YCreate",datap,NULLP,NULLP,VVDLibp);
 	if (DlgFmPtr == NULLP) {
		ErrorProc();
		return(EXITMENU);
	}
	ShowShadow(DlgFmPtr->wnp);

	msgwnp = wn_def(vs_rowq()-1,0,1,vs_colq(),LMESSAGE,BDR_NULLP);
	wn_up(msgwnp);
	v_st(FormMsg,msgwnp);
	pulldown_or_dialog = DIALOG;
	retcode = fm_proc(0,DlgFmPtr);
	pulldown_or_dialog = PULLDOWN;
	wn_dn(msgwnp);
	wn_free(msgwnp);
	fm_free(DlgFmPtr);

	if (retcode == AC_EXIT)  {
		if ((datap->symname[0] != '\0') &&
		    (datap->addr[0] != '\0')) {
			ExecDlgFlag = 1;
			strcat(DlgBuf,"CR ");
			if ((ptr=strchr(datap->symname,'%')) != NULL)
				strcat(DlgBuf,datap->symname);
			else  {
				strcat(DlgBuf,"%");
				strcat(DlgBuf,datap->symname);
			}
			strcat(DlgBuf," ");
			strcat(DlgBuf,datap->addr);
			strcat(DlgBuf,"\r");
		}
	}

	if (retcode == AC_EXIT) return( EXITMENU );
	else if (retcode == AC_QUIT) return(SAMELEVEL);

}  /*  of MN_Y_CREATE()  */

/****************************************************************************/
/*  SYMBOL menu Delete menu-item					    */
/****************************************************************************/

MN_Y_DELETE( SymMenuCopy )
MFORMPTR  SymMenuCopy;
{
	YDELETE *datap;
	WINDOWPTR msgwnp;		    
	DFIELDPTR fldptr;
	int i;
	char *ptr;

	VV_ERR = 0;
	datap = &ydelete;
    	if (addinx > 0) {
		tmpMFile = mf_def(addinx+3,41);
		if (tmpMFile == NULLP) {
			ErrorProc();
			return(EXITMENU);
		}
	}
	DlgFmPtr = dl_fmget("YDelete",datap,NULLP,tmpMFile,VVDLibp);
 	if (DlgFmPtr == NULLP) {
		ErrorProc();
		mf_free(tmpMFile);
		return(EXITMENU);
	}
	ShowShadow(DlgFmPtr->wnp);
    	if (addinx > 0) {
		mf_rowins("*DelSymbol",APPEND_ROW,tmpMFile);
	       	for (i=0; i < addinx; i++) mf_rowins(addtable[i].name,APPEND_ROW,tmpMFile);
		fldptr = (DFIELDPTR) i_namptr("symname",DlgFmPtr);
		sf_clist("*DelSymbol",CLWRAP|CLAUTOMOVE,tmpMFile,fldptr);
		scl_attinact(LFLDACTOFF,fldptr->clistp);
		scl_attact(LFLDACTON,fldptr->clistp);
		sw_bdratt(LFLDACTOFF,fldptr->clistp->wnp);
		scl_help("*symname",fldptr->clistp);
		if (addinx > 13) sw_sb(AUTOUPD,VSBAR,fldptr->clistp->wnp);
	}

	msgwnp = wn_def(vs_rowq()-1,0,1,vs_colq(),LMESSAGE,BDR_NULLP);
	wn_up(msgwnp);
	v_st(TFormMsg,msgwnp);
	pulldown_or_dialog = DIALOG;
	retcode = fm_proc(0,DlgFmPtr);
	pulldown_or_dialog = PULLDOWN;
	wn_dn(msgwnp);
	wn_free(msgwnp);
	fm_free(DlgFmPtr);
	if (addinx > 0)  mf_free(tmpMFile);

	if (retcode == AC_EXIT)  {
		if (datap->symname[0] != '\0') {
			ExecDlgFlag = 1;
			strcat(DlgBuf,"DEL ");
			if ((ptr=strchr(datap->symname,'%')) != NULL)
				strcat(DlgBuf,datap->symname);
			else  {
				strcat(DlgBuf,"%");
				strcat(DlgBuf,datap->symname);
			}
			strcat(DlgBuf,"\r");
		} 
	}
		 
	if (retcode == AC_EXIT) return( EXITMENU );
	else if (retcode == AC_QUIT) return(SAMELEVEL);

}  /*  of MN_Y_DELETE()  */

/****************************************************************************/
/*  SYMBOL menu Module menu-item					    */
/****************************************************************************/

MN_Y_MODULE( SymMenuCopy )
MFORMPTR  SymMenuCopy;
{
	ExecDlgFlag = 1;
	strcat(DlgBuf,"MODU\r");
	return( EXITMENU );

}  /*  of MN_Y_MODULE()  */

/****************************************************************************/
/*  SYMBOL menu SSAVE   menu-item					    */
/****************************************************************************/

MN_Y_SSAVE( SymMenuCopy )
MFORMPTR  SymMenuCopy;
{
	YSSAVE *datap;
	WINDOWPTR msgwnp;		    

	VV_ERR = 0;
	datap = &yssave;
	DlgFmPtr = dl_fmget("YSsave",datap,NULLP,NULLP,VVDLibp);
 	if (DlgFmPtr == NULLP) {
		ErrorProc();
		return(EXITMENU);
	}
	ShowShadow(DlgFmPtr->wnp);

	msgwnp = wn_def(vs_rowq()-1,0,1,vs_colq(),LMESSAGE,BDR_NULLP);
	wn_up(msgwnp);
	v_st(FormMsg,msgwnp);
	pulldown_or_dialog = DIALOG;
	retcode = fm_proc(0,DlgFmPtr);
	pulldown_or_dialog = PULLDOWN;
	wn_dn(msgwnp);
	wn_free(msgwnp);
	fm_free(DlgFmPtr);

	if (retcode == AC_EXIT)  {
		if (datap->filename[0] != '\0') {
			ExecDlgFlag = 1;
			strcat(DlgBuf,"SS ");
			strcat(DlgBuf,datap->filename);
			strcat(DlgBuf,"\r");
		} 
	}

	if (retcode == AC_EXIT) return( EXITMENU );
	else if (retcode == AC_QUIT) return(SAMELEVEL);

}  /*  of MN_Y_SSAVE()  */

/****************************************************************************/
/*  SYMBOL menu SRECALL   menu-item					    */
/****************************************************************************/

MN_Y_SRECALL( SymMenuCopy )
MFORMPTR  SymMenuCopy;
{
	YSRECALL *datap;
	WINDOWPTR msgwnp;		    

	VV_ERR = 0;
	datap = &ysrecall;
	DlgFmPtr = dl_fmget("YSrecall",datap,NULLP,NULLP,VVDLibp);
 	if (DlgFmPtr == NULLP) {
		ErrorProc();
		return(EXITMENU);
	}
	ShowShadow(DlgFmPtr->wnp);

	msgwnp = wn_def(vs_rowq()-1,0,1,vs_colq(),LMESSAGE,BDR_NULLP);
	wn_up(msgwnp);
	v_st(FormMsg,msgwnp);
	pulldown_or_dialog = DIALOG;
	retcode = fm_proc(0,DlgFmPtr);
	pulldown_or_dialog = PULLDOWN;
	wn_dn(msgwnp);
	wn_free(msgwnp);
	fm_free(DlgFmPtr);

	if (retcode == AC_EXIT)  {
		if (datap->filename[0] != '\0') {
			ExecDlgFlag = 1;
			strcat(DlgBuf,"SR ");
			strcat(DlgBuf,datap->filename);
			strcat(DlgBuf,"\r");
		} 
	}

	if (retcode == AC_EXIT) return( EXITMENU );
	else if (retcode == AC_QUIT) return(SAMELEVEL);

}  /*  of MN_Y_SRECALL()  */

/****************************************************************************/
/*  SYMBOL menu Symbol Query menu-item					    */
/****************************************************************************/

MN_Y_SYMBOL( SymMenuCopy )
MFORMPTR  SymMenuCopy;
{
	YSYMBOL *datap;
	WINDOWPTR msgwnp;
	char *ptr;

	VV_ERR = 0;
	datap = &ysymbol;
	DlgFmPtr = dl_fmget("YSymbol",datap,NULLP,NULLP,VVDLibp);
 	if (DlgFmPtr == NULLP) {
		ErrorProc();
		return(EXITMENU);
	}
	ShowShadow(DlgFmPtr->wnp);

	msgwnp = wn_def(vs_rowq()-1,0,1,vs_colq(),LMESSAGE,BDR_NULLP);
	wn_up(msgwnp);
	v_st(FormMsg,msgwnp);
	pulldown_or_dialog = DIALOG;
	retcode = fm_proc(0,DlgFmPtr);
	pulldown_or_dialog = PULLDOWN;
	wn_dn(msgwnp);
	wn_free(msgwnp);
	fm_free(DlgFmPtr);

	if (retcode == AC_EXIT)  {
		if (datap->symname[0] != '\0') {
			ExecDlgFlag = 1;
			strcat(DlgBuf,"QUE ");
			if ((ptr=strchr(datap->symname,'%')) != NULL)
				strcat(DlgBuf,datap->symname);
			else  {
				strcat(DlgBuf,"%");
				strcat(DlgBuf,datap->symname);
			}
			strcat(DlgBuf,"\r");
		}
	}

	if (retcode == AC_EXIT) return( EXITMENU );
	else if (retcode == AC_QUIT) return(SAMELEVEL);

}  /*  of MN_Y_SYMBOL()  */

/****************************************************************************/
/*  SYMBOL menu Address Query menu-item					    */
/****************************************************************************/

MN_Y_ADDRESS( SymMenuCopy )
MFORMPTR  SymMenuCopy;
{
	YADDRESS *datap;
	WINDOWPTR msgwnp;

	VV_ERR = 0;
	datap = &yaddress;
	DlgFmPtr = dl_fmget("YAddress",datap,NULLP,NULLP,VVDLibp);
 	if (DlgFmPtr == NULLP) {
		ErrorProc();
		return(EXITMENU);
	}
	ShowShadow(DlgFmPtr->wnp);

	msgwnp = wn_def(vs_rowq()-1,0,1,vs_colq(),LMESSAGE,BDR_NULLP);
	wn_up(msgwnp);
	v_st(FormMsg,msgwnp);
	pulldown_or_dialog = DIALOG;
	retcode = fm_proc(0,DlgFmPtr);
	pulldown_or_dialog = PULLDOWN;
	wn_dn(msgwnp);
	wn_free(msgwnp);
	fm_free(DlgFmPtr);

	if (retcode == AC_EXIT)  {
		if (datap->addr[0] != '\0') {
			ExecDlgFlag = 1;
			strcat(DlgBuf,"QUE ");
			strcat(DlgBuf,datap->addr);
			strcat(DlgBuf,"\r");
		}
	}

	if (retcode == AC_EXIT) return( EXITMENU );
	else if (retcode == AC_QUIT) return(SAMELEVEL);

}  /*  of MN_Y_ADDRESS()  */

/***************************************************************************/
/* OPTIONS menu Toggle-Status dialog box                                   */
/***************************************************************************/
MN_O_TOGGLE( OptMenuCopy )
MFORMPTR  OptMenuCopy;
{
	OTOGGLE *datap,oset;
	WINDOWPTR msgwnp;
	DFIELDPTR fldptr;

	VV_ERR = 0;
	datap = &otoggle;
	memset(datap,NULL,sizeof(otoggle));
	DlgFmPtr = dl_fmget("OToggle",datap,NULLP,NULLP,VVDLibp);
 	if (DlgFmPtr == NULLP) {
		ErrorProc();
		return(EXITMENU);
	}
	ShowShadow(DlgFmPtr->wnp);

	if (sym_flag == 1)    datap->symbol  = oset.symbol   = TRUE;
	if (cmd_flag == 1)    datap->log     = oset.log      = TRUE;
	if (out_flag == 1)    datap->journal = oset.journal  = TRUE;
	if (noRAM == 0)       datap->swbp    = oset.swbp     = TRUE;

	msgwnp = wn_def(vs_rowq()-1,0,1,vs_colq(),LMESSAGE,BDR_NULLP);
	wn_up(msgwnp);
	v_st(BoolFldMsg,msgwnp);
	pulldown_or_dialog = DIALOG;
	retcode = fm_proc(0,DlgFmPtr);
	pulldown_or_dialog = PULLDOWN;
	wn_dn(msgwnp);
	wn_free(msgwnp);
	fm_free(DlgFmPtr);

	if (retcode == AC_EXIT)  {
		if (datap->symbol != oset.symbol) {
			ExecDlgFlag = 1;
			if (datap->symbol == TRUE) strcat(DlgBuf,"OPT S ON\r");
			else strcat(DlgBuf,"OPT S OF\r");
		}
		if (datap->log == TRUE) {
			if ((log_cmd_file[0] != '\0') && (datap->log != oset.log)) {
				strcat(DlgBuf,"OPT L ON\r");
				ExecDlgFlag = 1;
			}
		} else {
			if ((log_cmd_file[0] != '\0') && (datap->log != oset.log)) {
				strcat(DlgBuf,"OPT L OF\r");
				ExecDlgFlag = 1;
			}
		}
		if (datap->journal == TRUE) {
			if ((log_out_file[0] != '\0') && (datap->journal != oset.journal)) {
				strcat(DlgBuf,"OPT J ON\r");
				ExecDlgFlag = 1;
			}
		} else {
			if ((log_out_file[0] != '\0') && (datap->journal != oset.journal)) {
				strcat(DlgBuf,"OPT J OF\r");
				ExecDlgFlag = 1;
			}
		}
		if (datap->swbp != oset.swbp) {
			if (datap->swbp == TRUE) strcat(DlgBuf,"OPT B ON\r");
			else strcat(DlgBuf,"OPT B OF\r");
			ExecDlgFlag = 1;
		}
	}

	if (retcode == AC_EXIT) return( EXITMENU );
	else if (retcode == AC_QUIT) return(SAMELEVEL);

}

/****************************************************************************/
/*  OPTIONS menu Update Viewport menu-item				    */
/****************************************************************************/

MN_O_UPDATE( OptMenuCopy )
MFORMPTR  OptMenuCopy;
{
	OUPDATE *datap,ostatus;
	UCHAR upd[3];
	WINDOWPTR msgwnp;
	DFIELDPTR fldptr;

	VV_ERR = 0;
	datap = &oupdate;
	DlgFmPtr = dl_fmget("OUpdate",datap,NULLP,NULLP,VVDLibp);
 	if (DlgFmPtr == NULLP) {
		ErrorProc();
		return(EXITMENU);
	}
	ShowShadow(DlgFmPtr->wnp);

	if (!(MaskRedrawFlag&REDRAWBRE)) ostatus.bp    = datap->bp    = TRUE;
	else                             ostatus.bp    = datap->bp    = FALSE;
	if (!(MaskRedrawFlag&REDRAWCOD)) ostatus.code  = datap->code  = TRUE;
	else                             ostatus.code  = datap->code  = FALSE;
	if (!(MaskRedrawFlag&REDRAWREG)) ostatus.reg   = datap->reg   = TRUE;
	else                             ostatus.reg   = datap->reg   = FALSE;
	if (!(MaskRedrawFlag&REDRAWSTA)) ostatus.stack = datap->stack = TRUE;
	else                             ostatus.stack = datap->stack = FALSE;
	if (!(MaskRedrawFlag&REDRAWTRA)) ostatus.trace = datap->trace = TRUE;
	else                             ostatus.trace = datap->trace = FALSE;
	if (!(MaskRedrawFlag&REDRAWDAT)) ostatus.data  = datap->data  = TRUE;
	else                             ostatus.data  = datap->data  = FALSE;

	msgwnp = wn_def(vs_rowq()-1,0,1,vs_colq(),LMESSAGE,BDR_NULLP);
	wn_up(msgwnp);
	v_st(BoolFldMsg,msgwnp);
	pulldown_or_dialog = DIALOG;
	retcode = fm_proc(0,DlgFmPtr);
	pulldown_or_dialog = PULLDOWN;
	wn_dn(msgwnp);
	wn_free(msgwnp);
	fm_free(DlgFmPtr);

	if (retcode == AC_EXIT)  {
		if (ostatus.bp != datap->bp) {
			if (datap->bp == TRUE) 	strcat(DlgBuf,"UPD B ON\r");
			else strcat(DlgBuf,"UPD B OF\r");
			ExecDlgFlag = 1;
		}
		if (ostatus.code != datap->code) {
			if (datap->code == TRUE) strcat(DlgBuf,"UPD COD ON\r");
			else strcat(DlgBuf,"UPD COD OF\r");
			ExecDlgFlag = 1;
		}
		if (ostatus.reg != datap->reg) {
			if (datap->reg == TRUE) strcat(DlgBuf,"UPD R ON\r");
			else strcat(DlgBuf,"UPD R OF\r");
			ExecDlgFlag = 1;
		}
		if (ostatus.stack != datap->stack) {
			if (datap->stack == TRUE) strcat(DlgBuf,"UPD S ON\r");
			else strcat(DlgBuf,"UPD S OF\r");
			ExecDlgFlag = 1;
		}
		if (ostatus.trace != datap->trace) {
			if (datap->trace == TRUE) strcat(DlgBuf,"UPD T ON\r");
			else strcat(DlgBuf,"UPD T OF\r");
			ExecDlgFlag = 1;
		}
		if (ostatus.data != datap->data) {
			if (datap->data == TRUE) strcat(DlgBuf,"UPD D ON\r");
			else strcat(DlgBuf,"UPD D OF\r");
			ExecDlgFlag = 1;
		}
	}

	if (retcode == AC_EXIT) return( EXITMENU );
	else if (retcode == AC_QUIT) return(SAMELEVEL);

}  /*  of MN_O_UPDATE()  */

/****************************************************************************/
/*  OPTIONS menu Define Softkey menu-item				    */
/****************************************************************************/

MN_O_DEFINE( OptMenuCopy )
MFORMPTR  OptMenuCopy;
{
	WINDOWPTR msgwnp;

	VV_ERR = 0;
	DlgFmPtr = dl_fmget("ODefine",(ODEFINE *)SoftKeyBuf[0],NULLP,NULLP,VVDLibp);
 	if (DlgFmPtr == NULLP) {
		ErrorProc();
		return(EXITMENU);
	}
	ShowShadow(DlgFmPtr->wnp);

	msgwnp = wn_def(vs_rowq()-1,0,1,vs_colq(),LMESSAGE,BDR_NULLP);
	wn_up(msgwnp);
	v_st(FormMsg,msgwnp);
	pulldown_or_dialog = DIALOG;
	retcode = fm_proc(0,DlgFmPtr);
	pulldown_or_dialog = PULLDOWN;
	wn_dn(msgwnp);
	wn_free(msgwnp);
	fm_free(DlgFmPtr);

	ExecDlgFlag = 0;
	if (retcode == AC_EXIT) return( EXITMENU );
	else if (retcode == AC_QUIT) return(SAMELEVEL);

}  /*  of MN_O_DEFINE()  */

/****************************************************************************/
/*  OPTIONS menu Usave menu-item				    */
/****************************************************************************/

MN_O_USAVE( OptMenuCopy )
MFORMPTR  OptMenuCopy;
{
	WINDOWPTR msgwnp;
	OUSAVE *datap;

	VV_ERR = 0;
	datap = &ousave;
	DlgFmPtr = dl_fmget("OUsave",datap,NULLP,NULLP,VVDLibp);
 	if (DlgFmPtr == NULLP) {
		ErrorProc();
		return(EXITMENU);
	}
	ShowShadow(DlgFmPtr->wnp);

	msgwnp = wn_def(vs_rowq()-1,0,1,vs_colq(),LMESSAGE,BDR_NULLP);
	wn_up(msgwnp);
	v_st(BoolFldMsg,msgwnp);
	pulldown_or_dialog = DIALOG;
	retcode = fm_proc(0,DlgFmPtr);
	pulldown_or_dialog = PULLDOWN;
	wn_dn(msgwnp);
	wn_free(msgwnp);
	fm_free(DlgFmPtr);

	if (retcode == AC_EXIT) {
		ExecDlgFlag = 1;
		if ((datap->screen == TRUE) && (datap->softkey == TRUE))
			strcat(DlgBuf,"USAV\r");
		else if ((datap->screen == TRUE) && (datap->softkey == FALSE))
			strcat(DlgBuf,"USAV W\r");
		else if ((datap->screen == FALSE) && (datap->softkey == TRUE))
			strcat(DlgBuf,"USAV K\r");
		else ExecDlgFlag = 0;
	}

	if (retcode == AC_EXIT) return( EXITMENU );
	else if (retcode == AC_QUIT) return(SAMELEVEL);

}  /*  of MN_O_USAVE()  */

/****************************************************************************/
/*  OPTIONS menu Urecall menu-item				    */
/****************************************************************************/

MN_O_URECALL( OptMenuCopy )
MFORMPTR  OptMenuCopy;
{
	WINDOWPTR msgwnp;
	OURECALL *datap;

	VV_ERR = 0;
	datap = &ourecall;
	DlgFmPtr = dl_fmget("OUrecall",datap,NULLP,NULLP,VVDLibp);
 	if (DlgFmPtr == NULLP) {
		ErrorProc();
		return(EXITMENU);
	}
	ShowShadow(DlgFmPtr->wnp);

	msgwnp = wn_def(vs_rowq()-1,0,1,vs_colq(),LMESSAGE,BDR_NULLP);
	wn_up(msgwnp);
	v_st(BoolFldMsg,msgwnp);
	pulldown_or_dialog = DIALOG;
	retcode = fm_proc(0,DlgFmPtr);
	pulldown_or_dialog = PULLDOWN;

	if (retcode == AC_EXIT) {
		ExecDlgFlag = 1;
		if ((datap->screen == TRUE) && (datap->softkey == TRUE))
			strcat(DlgBuf,"UREC\r");
		else if ((datap->screen == TRUE) && (datap->softkey == FALSE))
			strcat(DlgBuf,"UREC W\r");
		else if ((datap->screen == FALSE) && (datap->softkey == TRUE))
			strcat(DlgBuf,"UREC K\r");
		else ExecDlgFlag = 0;
	}

	if (retcode == AC_EXIT) return( EXITMENU );
	else if (retcode == AC_QUIT) return(SAMELEVEL);

}  /*  of MN_O_URECALL()  */

/****************************************************************************/
/*  OPTIONS menu dialog color menu-item	                        	    */
/****************************************************************************/

MN_O_DLGCOLOR( OptMenuCopy )
MFORMPTR  OptMenuCopy;
{    
	UCHAR curset[3],curmon[3],curstr[2][2];
	UCHAR atttbl[256][2],attary[256];
	UCHAR fg,bg,att[3];
	int mono,keyin,i,j,curfld=0,currow=3;
	WINDOWPTR msgwnp,cwnp;

// get the original values from USD3.SAV or USD3DLG.LIB

	strcpy(curstr[0],"");
	strcpy(curstr[1]," ");
	memcpy(curset,GblDlgColor,3);
	memcpy(curmon,GblDlgMono,3);

	for (i=0; i < 16; i++) {    // background
		if ((j=(i%3)) == 0) bg = NORMAL;
		else if (j == 1)    bg = UNDERLINE;
		else if (j == 2)    bg = REVERSE;
		for (j=0; j < 16; j++)  {	  // foreground
			if ((mono=(j%4)) == 0)   fg = 0;
			else if (mono == 1)      fg = HIGH_INT;
			else if (mono == 2)      fg = BLINK;
			else if (mono == 3)      fg = BLINK|HIGH_INT;
			atttbl[i*16+j][0] = (bg|fg);
			atttbl[i*16+j][1] = catt_def(j,i);
		}
	}

	if (vid_getmode() == MONO) {
		i = 0;  memcpy(att,curmon,3);
	} else { i = 1; memcpy(att,curset,3);
	}
	latt_init(i,256,2,atttbl[0],attary);

	msgwnp = wn_def(vs_rowq()-1,0,1,vs_colq(),LMESSAGE,BDR_NULLP);
	wn_up(msgwnp);
	v_st("<>/<> change field, <F9> foreground color, <F10> background color, <CR> exit",msgwnp);

	cwnp = wn_def(4,18,11,45,curset[0],BDR_DLNP);
	sw_latt(attary,cwnp);
	sw_title(" CHANGING DIALOG BOX COLOR ",curset[0],TOPCENTER,cwnp);
	wn_up(cwnp);
	v_stattnop(1,5,"Changing colors for ...",curset[0],22,STATT,cwnp);
	v_stattnop(3,9,curstr[0],curset[0],2,STATT,cwnp);
	v_stattnop(3,12," text including border  ",curset[0],24,STATT,cwnp);
	v_stattnop(5,12,"  text in active field  ",curset[1],24,STATT,cwnp);
	v_stattnop(7,12," text in inactive field ",curset[2],24,STATT,cwnp);
	bg = (curset[0] & 0xf0) >> 4;
	fg = curset[0] & 0x0f;
	i = 0;
	retcode = 5;
	while (1) {
		keyin = DialogColorKi(cwnp, &curfld);
		
		switch (keyin) {
			case 0x30:
				v_stattnop(currow,9,curstr[1],curset[0],2,STATT,cwnp);
				curfld = 0;
				currow = 3;
				v_stattnop(currow,9,curstr[0],curset[0],2,STATT,cwnp);
				bg = (curset[curfld] & 0xf0) >> 4;
				fg = curset[curfld] & 0x0f;
				break;

			case 0x31:
				v_stattnop(currow,9,curstr[1],curset[0],2,STATT,cwnp);
				curfld = 1;
				currow = 5;
				v_stattnop(currow,9,curstr[0],curset[0],2,STATT,cwnp);
				bg = (curset[curfld] & 0xf0) >> 4;
				fg = curset[curfld] & 0x0f;
				break;

			case 0x32:
				v_stattnop(currow,9,curstr[1],curset[0],2,STATT,cwnp);
				curfld = 2;
				currow = 7;
				v_stattnop(currow,9,curstr[0],curset[0],2,STATT,cwnp);
				bg = (curset[curfld] & 0xf0) >> 4;
				fg = curset[curfld] & 0x0f;
				break;

			case KEY_DN:
DnArrowKey:
				v_stattnop(currow,9,curstr[1],curset[0],2,STATT,cwnp);
				curfld++;
				if (curfld == 3) curfld = 0;
				if (curfld == 0) currow = 3;
				else if (curfld == 1)  currow = 5;
				else if (curfld == 2)  currow = 7;
				v_stattnop(currow,9,curstr[0],curset[0],2,STATT,cwnp);
				bg = (curset[curfld] & 0xf0) >> 4;
				fg = curset[curfld] & 0x0f;
				break;

			case KEY_UP:
				v_stattnop(currow,9,curstr[1],curset[0],2,STATT,cwnp);
				curfld--;
				if (curfld < 0 ) curfld = 2;
				if (curfld == 0) currow = 3;
				else if (curfld == 1)  currow = 5;
				else if (curfld == 2)  currow = 7;
				v_stattnop(currow,9,curstr[0],curset[0],2,STATT,cwnp);
				bg = (curset[curfld] & 0xf0) >> 4;
				fg = curset[curfld] & 0x0f;
				break;

			case KEY_F9:
		       		fg++;
				if (fg > 15) fg = 0;
				curset[curfld] = catt_def(fg,bg);
				if (vid_getmode() == MONO) 
					curmon[curfld] = atttbl[curset[curfld]][0];
				if (curfld == 0) {
					sw_att(curset[0],cwnp);
					sw_bdratt(curset[0],cwnp);
					sw_title(" CHANGING COLORS FOR DIALOG BOX ",
						  curset[0],TOPCENTER,cwnp);
					v_bdr(BDR_DLNP,cwnp);
					v_chattrow(0,0,' ',curset[0],
						   ENDWN,ATT,cwnp);
				}
				v_stattnop(5,12,"  text in active field  ",
					   curset[1],24,ATT,cwnp);
				v_stattnop(7,12," text in inactive field ",
					   curset[2],24,ATT,cwnp);
				break;
				
			case KEY_F10:
		       		bg++;
				if (bg > 15) bg = 0;
				curset[curfld] = catt_def(fg,bg);
				if (vid_getmode() == MONO) 
					curmon[curfld] = atttbl[curset[curfld]][0];
				if (curfld == 0) {
					sw_att(curset[0],cwnp);
					sw_bdratt(curset[0],cwnp);
					sw_title(" CHANGING COLORS FOR DIALOG BOX ",
						  curset[0],TOPCENTER,cwnp);
					v_bdr(BDR_DLNP,cwnp);
					v_chattrow(0,0,' ',curset[curfld],
						   ENDWN,ATT,cwnp);
				}
				v_stattnop(5,12,"  text in active field  ",
					   curset[1],24,ATT,cwnp);
				v_stattnop(7,12," text in inactive field ",
					   curset[2],24,ATT,cwnp);
				break;
				
			case KEY_ENTER:
				if (curfld < 2) goto DnArrowKey;
				memcpy(GblDlgColor,curset,3);
				memcpy(GblDlgMono, curmon,3);
				retcode = AC_EXIT;
				break;

			case KEY_ESC:
				retcode = AC_QUIT;
				break;

 			case KEY_F1:
				sw_mf(DlgMFilePtr,HELP_WNP);
				mf_kwdset( "*ODlgColor",DlgMFilePtr );
				wn_up(HELP_WNP);
				v_stpl(1,LEFT_TEXT,"Cursor keys to scroll, <ESC> to quit", msgwnp );
				mf_browse(HELP_WNP);
				wn_dn(HELP_WNP);
				v_stpl(1,LEFT_TEXT,"<>/<> change field, <F9> foreground color, <F10> background color, <CR> exit",msgwnp);
				break;

			default:
				break;
		} 
		if (retcode == AC_EXIT || retcode == AC_QUIT) break;
	}

	wn_dn(cwnp);
	wn_free(cwnp);
	wn_dn(msgwnp);
	wn_free(msgwnp);
	ExecDlgFlag = 0;
     	if (retcode == AC_EXIT) {
/*		if (vid_getmode() == MONO) 
		     memcpy(&DlgColorLATT[26],GblDlgMono,3);
		else memcpy(&DlgColorLATT[26],GblDlgColor,3);*/
	}

	if (retcode == AC_EXIT) return( EXITMENU );
	else if (retcode == AC_QUIT) return(SAMELEVEL);

}

/****************************************************************************/
/*  SPA menu-bar Entry menu-item					    */
/****************************************************************************/

MN_P_ENTRY( SpaMenuCopy )
MFORMPTR  SpaMenuCopy;
{
 Entry_Duration_Time_Cover_Lsa = 1;
 return( EXITMENU );

}  /*  of MN_P_ENTRY()  */

MN_P_ENTRY1()
{
 SaveScrnLayout();

 start_up1();
 spa1();

 RestoreScrnLayout();

}  /*  of MN_P_ENTRY1()  */

/****************************************************************************/
/*  SPA menu-bar Duration menu-item					    */
/****************************************************************************/

MN_P_DURATION( SpaMenuCopy )
MFORMPTR  SpaMenuCopy;
{
 Entry_Duration_Time_Cover_Lsa = 2;
 return( EXITMENU );

}  /*  of MN_P_DURATION()  */

MN_P_DURATION1()
{
 SaveScrnLayout();

 start_up1();
 spa2();

 RestoreScrnLayout();

}  /*  of MN_P_DURATION1()  */

/****************************************************************************/
/*  SPA menu-bar Time menu-item						    */
/****************************************************************************/

MN_P_TIME( SpaMenuCopy )
MFORMPTR  SpaMenuCopy;
{
 Entry_Duration_Time_Cover_Lsa = 3;
 return( EXITMENU );

}  /*  of MN_P_TIME()  */

MN_P_TIME1()
{
 SaveScrnLayout();

 start_up1();
 spa3();

 RestoreScrnLayout();

}  /*  of MN_P_TIME1()  */

/****************************************************************************/
/*  SPA menu-bar Coverage menu-item					    */
/****************************************************************************/

MN_P_COVERAGE( SpaMenuCopy )
MFORMPTR  SpaMenuCopy;
{
 Entry_Duration_Time_Cover_Lsa = 4;
 return( EXITMENU );

}  /*  of MN_P_COVERAGE()  */

MN_P_COVERAGE1()
{
 SaveScrnLayout();
 SPACover();
 RestoreScrnLayout();

}  /*  of MN_P_COVERAGE1()  */

/****************************************************************************/
/*  LSA menu-bar Lsa menu-item						    */
/****************************************************************************/

MN_L_LSA( LsaMenuCopy )
MFORMPTR  LsaMenuCopy;
{
 Entry_Duration_Time_Cover_Lsa = 5;
 return( EXITMENU );

}  /*  of MN_L_LSA()  */

MN_L_LSA1()
{
 SaveScrnLayout();

 start_up1();
 logst();

 RestoreScrnLayout();

}  /*  of MN_L_LSA1()  */
