
/***************************************************************************
**
**    $Header:   D:/USD3V/LOG/SRC/MOUSEDRV.C__   1.2   12 Jun 1996 08:43:48   ZJRD  $
**
**    $Log:   D:/USD3V/LOG/SRC/MOUSEDRV.C__  $
** 
**    Rev 1.2   12 Jun 1996 08:43:48   ZJRD
** No change.
** 
**    Rev 1.1   24 May 1996 09:42:58   ZJRD
** No change.
** 
**    Rev 1.0   11 Dec 1995 13:52:02   ZJRD
** Initial revision.
** 
****************************************************************************/
#include <dos.h>
#include <stdio.h>
#include <graph.h>
#include "funcext.h"
#include "system.h"
#include "usd3.h"
#include "gblext.h"
#include "mouse.h"

void Int33h(M1, M2, M3, M4)
int *M1, *M2, *M3, *M4;
{
	union REGS M_INREG, M_OUTREG;
	union REGS *M_INREG_ptr=&M_INREG, *M_OUTREG_ptr=&M_OUTREG;

	M_INREG_ptr->x.ax = *M1;
	M_INREG_ptr->x.bx = *M2;
	M_INREG_ptr->x.cx = *M3;
	M_INREG_ptr->x.dx = *M4;

	if (have_mouse_driver==1) {
		int86(0x33,M_INREG_ptr,M_OUTREG_ptr);
		*M1 = M_OUTREG_ptr->x.ax;
		*M2 = M_OUTREG_ptr->x.bx;
		*M3 = M_OUTREG_ptr->x.cx;
		*M4 = M_OUTREG_ptr->x.dx;
	} else {
		*M1 = 0;
		*M2 = 0;
		*M3 = 0;
		*M4 = 0;
	}
}

void ResetAndStatus(M1, M2)
int *M1, *M2;
{
	int M3, M4;

	*M1 = 0;
	*M2 = 0;
	M3 = 0;
	M4 = 0;
	Int33h(M1, M2, &M3, &M4);
}

void ShowCursor()
{
	int M1, M2, M3, M4;

	M1 = 1;
	M2 = 0;
	M3 = 0;
	M4 = 0;
	Int33h(&M1, &M2, &M3, &M4);
}

void HideCursor()
{
	int M1, M2, M3, M4;

	M1 = 2;
	M2 = 0;
	M3 = 0;
	M4 = 0;
	Int33h(&M1, &M2, &M3, &M4);
}

void ButtonStatusAndMousePosition(M2, M3, M4)
int *M2, *M3, *M4;
{
	int M1;

	M1 = 3;
	*M2 = 0;
	*M3 = 0;
	*M4 = 0;
	Int33h(&M1, M2, M3, M4);
}

void SetMouseCursorPosition(M3, M4)
int M3, M4;
{
	int M1, M2;

	M1 = 4;
	M2 = 0;
	Int33h(&M1, &M2, &M3, &M4);
}

void GetButtonPressInfomation(M1, M2, M3, M4)
int *M1, *M2, *M3, *M4;
{

	*M1 = 5;
	*M3 = 0;
	*M4 = 0;
	Int33h(M1, M2, M3, M4);
}

void GetButtonReleaseInfomation(M1, M2, M3, M4)
int *M1, *M2, *M3, *M4;
{

	*M1 = 6;
	*M3 = 0;
	*M4 = 0;
	Int33h(M1, M2, M3, M4);
}

void SetMinMaxHorizontal(M3, M4)
int M3, M4;
{
	int M1, M2;

	M1 = 7;
	M2 = 0;
	Int33h(&M1, &M2, &M3, &M4);
}

void SetMinMaxVertical(M3, M4)
int M3, M4;
{
	int M1, M2;

	M1 = 8;
	M2 = 0;
	Int33h(&M1, &M2, &M3, &M4);
}

void SetTextCursor(M2, M3, M4)
int M2, M3, M4;
{
	int M1;

	M1 = 10;
	Int33h(&M1, &M2, &M3, &M4);
}

void ReadMouseMotionCounters(M3, M4)
int *M3, *M4;
{
	int M1, M2;

	M1 = 11;
	M2 = 0;
	*M3 = 0;
	*M4 = 0;
	Int33h(&M1, &M2, M3, M4);
}

void InitMouse()
{
	int mouse_status, number_of_button;

	
	have_mouse_driver = 1;
	ResetAndStatus(&mouse_status, &number_of_button);
	if(mouse_status == -1) {
		have_mouse_driver = 1;
		SetTextCursor(0, SCREEN_MASK, CURSOR_MASK);
		SetMinMaxHorizontal(MINHORIZONTAL,MAXHORIZONTAL);
		SetMinMaxVertical(MINVERTICAL,MAXVERTICAL);
	} else have_mouse_driver = 0;
}

int CheckLBClick(item_no_addr)
int *item_no_addr;
{
	int which_boarder, up_or_down_key;

	if ( press_y == VP[1].yOrg) which_boarder = 1;
	else if ( press_y == VP[2].yOrg) which_boarder = 2;
	else which_boarder = 0;
	if (which_boarder != 0) {
		ButtonStatusAndMousePosition(&current_status, &current_x, &current_y);
		current_x /= 8;
		current_y /= 8;
		while ( (current_status == 1) && (COMVPMax == 0) ) {
			ZoomDragSVR(&which_boarder);
			ButtonStatusAndMousePosition(&current_status, &current_x, &current_y);
			current_x /= 8;
			current_y /= 8;
		}
	} else {
		ButtonStatusAndMousePosition(&current_status, &current_x, &current_y);
		current_x /= 8;
		current_y /= 8;
		while ( (current_status == 1) && ((up_or_down_key = ScrollKeyPressed()) != -1) ) {
			ScrollVPLine(VP[ActVP].Ptr, up_or_down_key);
			TimeDelay(10);
			ButtonStatusAndMousePosition(&current_status, &current_x, &current_y);
			current_x /= 8;
			current_y /= 8;
		}
	}
/*	release_m2 = 0;
	GetButtonReleaseInfomation(&release_m1, &release_m2, &release_x, &release_y);
	release_x /= 8;
	release_y /= 8;
	if ( (up_or_down_key = ScrollKeyPressed()) != -1 ) {
	        HideCursor();
		ScrollVPLine(VP[ActVP].Ptr, up_or_down_key);
		ShowCursor();
	}*/
	press_m2 = 0;
	GetButtonPressInfomation(&press_m1, &press_m2, &press_x, &press_y);
	press_x /= 8;
	press_y /= 8;
	if (press_m2 > 0) {
		*item_no_addr = press_x;
		return( WhichAreaPressed() );
	} else {
		press_m2 = 1;
		GetButtonPressInfomation(&press_m1, &press_m2, &press_x, &press_y);
		press_x = 0;
		press_y = 0;
		if (press_m2 > 0) {
			*item_no_addr = 0;
			return(8);
		} else 	return(0);
	}

}

int MouseSVR(Keyin_addr)
int *Keyin_addr;
{
	int x_position;

	switch (CheckLBClick(&x_position)) {
		case 1:
			x_position = x_position / 8 + 1;
			FuncKeyNo(Keyin_addr, x_position);
			if ( wn_isup(CmdHelpVP) ) *Keyin_addr = 0;
			break;
		case 2:
			x_position = x_position / 8;
			MenuBarItemPos(Keyin_addr, x_position);
			mouse_have_been_pressed = mouse_not_released = 1;
			break;
		case 3:
		        HideCursor();
			if (TopVP == BREVP)  ToActivAnyOneVP(0);
			else if (TopVP == REGVP)  ToActivAnyOneVP(3);
			else ToActivAnyOneVP(5);
			ShowCursor();
			*Keyin_addr = 0;
			break;
		case 4:
		        HideCursor();
			ToActivAnyOneVP(2);
			ShowCursor();
			*Keyin_addr = 0;
			break;
		case 5:
		        HideCursor();
			ToActivAnyOneVP(1);
			ShowCursor();
			*Keyin_addr = 0;
			break;
		case 6:
		        HideCursor();
			ToActivAnyOneVP(4);
			ShowCursor();
			*Keyin_addr = 0;
			break;
		case 7:
		        HideCursor();
			ToActivAnyOneVP(6);
			ShowCursor();
			*Keyin_addr = 0;
			break;
		case 8:
			*Keyin_addr = 27;
			break;
		case 9:
		case 10:
		default:
			*Keyin_addr = 0;
	}
}

void FuncKeyNo(Keyin_addr, item_no)
int *Keyin_addr, item_no;
{
	*Keyin_addr = - (item_no +  58);
	if (*Keyin_addr == KEY_F2) {
		pulldown_or_dialog = DIALOG;
		special_dialog = 1;
	}
}

void MenuBarItemPos(Keyin_addr, x_position)
int *Keyin_addr, x_position;
{
	switch( MenubarItemNo(x_position, 0) ) {
		case 0:
			*Keyin_addr = KEY_AF;
			break;
		case 1:
			*Keyin_addr = KEY_AS;
			break;
		case 2:
			*Keyin_addr = KEY_AM;
			break;
		case 3:
			*Keyin_addr = KEY_AE;
			break;
		case 4:
			*Keyin_addr = KEY_AT;
			break;
		case 5:
			*Keyin_addr = KEY_AY;
			break;
		case 6:
			*Keyin_addr = KEY_AO;
			break;
		case 7:
			*Keyin_addr = KEY_AP;
			break;
		case 8:
			*Keyin_addr = KEY_AL;
			break;
		default:
			*Keyin_addr = 0;
	}
}

void ToActivAnyOneVP(which_vp)
int which_vp;
{
	VP[ActVP].Ptr->titleatt = LVPTITLEINACT;
	v_titleatt( NULLP, LVPTITLEINACT, VP[ActVP].Ptr );

	ActVP = which_vp;

	VP[ActVP].Ptr->titleatt = LVPTITLEACT;
	v_titleatt( NULLP, LVPTITLEACT, VP[ActVP].Ptr );

	if ( (cursor_appear_or_not == 0) && ( csr_isvisible() == 1 ) )
		csr_hide();
	else if ( (cursor_appear_or_not == 1) && ( csr_isvisible() == 0 ) )
		csr_show();

	csr_plwn( VP[COMVP].Ptr );
}

int WhichAreaPressed()
{
	int x, y;

	x = press_x;
	y = press_y;
	switch (y) {
		case 24 : return(1);
		case 0  : return(2);
		case 23 : return(0);
		default :
			if (COMVPMax == 1) return(0);
			if ( (y > 0) && (y < VP[1].yOrg) && (x != 0) )
				return(3);
			else if ( (y >= VP[2].yOrg) && (y < 23) && (x != 0) )
				return(4);
			else if ( (x > 0) && (x < (VP[1].xOrg+VP[1].Width)) )
				return(5);
			else if ( (wn_isup(VP[STAVP].Ptr)) && (x > VP[4].xOrg) )
				return(6);
			else if ( (wn_isup(VP[DATVP].Ptr)) && (x > VP[6].xOrg) )
				return(7);
			else	return(0);
	}
}

void ZoomDragSVR(which_boarder)
int *which_boarder;
{
	if ( (*which_boarder == 1) && (current_y != VP[1].yOrg) && (current_y >= 3) && (current_y <= 19) ) {
		HideCursor();
		if (current_y < VP[1].yOrg) ZoomVP( TOPSIDE, ZOOMUP );
		else if (current_y > VP[1].yOrg) ZoomVP( TOPSIDE, ZOOMDOWN );
		ShowCursor();
	} else if ( (*which_boarder == 2) && (current_y != VP[2].yOrg) && (current_y >= 5) && (current_y <= 21) ) {
		HideCursor();
		if (current_y < VP[2].yOrg) ZoomVP( TOPSIDE, ZOOMUP );
		else if (current_y > VP[2].yOrg) ZoomVP( TOPSIDE, ZOOMDOWN );
		ShowCursor();
	}
	GetCodeVPRange(2);
}

int ScrollKeyPressed()
{
	if ( VP[ActVP].Height <= 3 )  return(-1);
	if (COMVPMax == 0) {
		if ( ((current_y) == (VP[ActVP].yOrg+1)) && ((current_x) == (VP[ActVP].xOrg+VP[ActVP].Width-1)) )
			return(2);
		else if ( ((current_y) == (VP[ActVP].yOrg+VP[ActVP].Height-2)) && ((current_x) == (VP[ActVP].xOrg+VP[ActVP].Width-1)) )
			return(3);
		else return(-1);
	} else if (COMVPMax == 1) {
		if ( ( (current_y) == 2) && ( (current_x) == 79) )
			return(2);
		else if ( ( (current_y) == 22) && ( (current_x) == 79) )
			return(3);
		else return(-1);
	}
	return(-1);
}

void ScrollVPLine(wnp, up_or_down_key)
WINDOWPTR wnp;
int up_or_down_key;
{
	if (up_or_down_key == 2) { /* Up Arrow Key */
		if ( --wnp->row_org < 0 )
			++wnp->row_org;
		wn_upd(wnp);
		if ( ActVP == COMVP )
			if ( (wnp->r == (wnp->row_org+VP[ActVP].Height-2)) && (cursor_appear_or_not==1) ) {
					csr_hide();
					cursor_appear_or_not = 0;
			} else if ( (wnp->r == wnp->row_org) && (cursor_appear_or_not==0) ) {
					csr_show();
					cursor_appear_or_not = 1;
					csr_plwn(wnp);
			} else if ( cursor_appear_or_not==1 ) csr_plwn(wnp);
	} else if (up_or_down_key == 3) { /* Down Arrow Key */
		if ( ++wnp->row_org > ( VP[ActVP].Maxr - VP[ActVP].Height + 3 ) )
			--wnp->row_org;
		wn_upd(wnp);
		if ( ActVP == COMVP )
			if ( (wnp->r == (wnp->row_org+VP[ActVP].Height-3)) && (cursor_appear_or_not==0) ) {
					csr_show();
					cursor_appear_or_not = 1;
					csr_plwn(wnp);
			} else if ( (wnp->r == (wnp->row_org - 1)) && (cursor_appear_or_not==1) ) {
					csr_hide();
					cursor_appear_or_not = 0;
			} else if ( cursor_appear_or_not==1 ) csr_plwn(wnp);
	}
}

int PulldownDialogKi(fmp)
FORMPTR fmp;
{
	if (pulldown_or_dialog == PULLDOWN) return( PulldownKi(fmp) );
	else if (special_dialog == 0) return( DialogKi(fmp) );
	else if (special_dialog == 1) return( RedDialogKi() );
}

int PulldownKi(fmp)
FORMPTR fmp;
{
	int mouse_status, number_of_button;
	int item;

	ShowCursor();
wait_input:
	if ( !mouse_have_been_pressed ) {
		do {
			press_m2 = 1;
			GetButtonPressInfomation(&press_m1, &press_m2, &press_x, &press_y);
			press_x /= 8;
			press_y /= 8;
			if (press_m2 > 0) {
				HideCursor();
				ResetAndStatus(&mouse_status, &number_of_button);
				SetTextCursor(0, SCREEN_MASK, CURSOR_MASK);
				return( KEY_ESC );
			}
			ButtonStatusAndMousePosition(&current_status, &current_x, &current_y);
			current_x /= 8;
			current_y /= 8;
			if (current_status == 1) {
				mouse_have_been_pressed = mouse_not_released = 1;
				break;
			} else if ( ki_chk() != 0) {
				HideCursor();
				return( ki() );
			}
		} while ( 1 );
	}
	do {
		if (mouse_not_released) {
			ButtonStatusAndMousePosition(&current_status, &current_x, &current_y);
			current_x /= 8;
			current_y /= 8;
			switch ( AreaWhileLBDown(fmp, &item) ) {
				case LBDOWN_ANOTHER_ITEM:
					need_next_mn_rd = 1;
					next_menubar_item = item;
					HideCursor();
					return(KEY_ESC);
				case LBDOWN_MENUBAR_BLANK:
					need_next_mn_rd = 2;
					HideCursor();
					return(KEY_ESC);
				case LBDOWN_NOACTION:
					goto next_mouse_status;
				case LBDOWN_INSIDE_PULLDOWN:
					if ( ((item-500) != fmp->cur_item) && ((MenuItem[current_menubar_item][item-500]->flags & UNAVAILABLE) == 0) ) {
						HideCursor();
						return(item);
					} else goto next_mouse_status;
			}
		} else {
			mouse_have_been_pressed = mouse_not_released = 0;
			ButtonStatusAndMousePosition(&current_status, &current_x, &current_y);
			current_x /= 8;
			current_y /= 8;
			switch ( AreaWhileRelease(fmp) ) {
				case RELEASE_NOACTION:
					HideCursor();
					ResetAndStatus(&mouse_status, &number_of_button);
					SetTextCursor(0, SCREEN_MASK, CURSOR_MASK);
					return(KEY_ESC);
				case RELEASE_CURRENT_ITEM:
					goto wait_input;
				case RELEASE_INSIDE_PULLDOWN:
					if ( (MenuItem[current_menubar_item][item-500]->flags & UNAVAILABLE) == 0) {
						if ( (item == 507) && (current_menubar_item==0) ) {
							pulldown_or_dialog = DIALOG;
							special_dialog = 1;
						}
						HideCursor();
						return(KEY_ENTER);
					} else  goto wait_input;
			}
		}

next_mouse_status:
		ButtonStatusAndMousePosition(&current_status, &current_x, &current_y);
		current_x /= 8;
		current_y /= 8;
		if (current_status != 1)  mouse_not_released = 0;

	} while ( 1 );
}

int AreaWhileLBDown(fmp, item)
FORMPTR fmp;
int *item;
{
	int retval;

	if ( (current_x >= (fmp->wnp->cb-1) ) &&
             (current_x <= (fmp->wnp->ce+1) ) &&
             (current_y >= fmp->wnp->rb)      &&
             (current_y <= fmp->wnp->re)         )
	{
		*item = current_y - 2 + 500;
		retval = LBDOWN_INSIDE_PULLDOWN;

	} else if (current_y == 0) {
		if ( (*item = MenubarItemNo(current_x, current_y)) == -1 )  retval = LBDOWN_MENUBAR_BLANK;
		else if (current_menubar_item != *item)  retval = LBDOWN_ANOTHER_ITEM;
		else {
			*item = -1;
			retval = LBDOWN_NOACTION;
		}
	} else {
		*item = -1;
		retval = LBDOWN_NOACTION;
	}

	return( retval );
}

int AreaWhileRelease(fmp)
FORMPTR fmp;
{
	int retval;

	if ( (current_x >= (fmp->wnp->cb-1) ) &&
             (current_x <= (fmp->wnp->ce+1) ) &&
             (current_y >= fmp->wnp->rb)      &&
             (current_y <= fmp->wnp->re)         )
	{
		retval = RELEASE_INSIDE_PULLDOWN;

	} else if ( MenubarItemNo(current_x, current_y) != -1 )  retval = RELEASE_CURRENT_ITEM;
	else retval = RELEASE_NOACTION;

	return(retval);
}

int MenubarItemNo(x, y)
int x, y;
{
	int retval;

	if (current_y == 0) {
		if ( (current_x >= 4) && (current_x <= 7) ) {
				retval = 0;
		} else if ( (current_x >= 11) && (current_x <= 15) ) {
				retval = 1;
		} else if ( (current_x >= 19) && (current_x <= 24) ) {
				retval = 2;
		} else if ( (current_x >= 28) && (current_x <= 36) ) {
				retval = 3;
		} else if ( (current_x >= 40) && (current_x <= 44) ) {
				retval = 4;
		} else if ( (current_x >= 48) && (current_x <= 53) ) {
				retval = 5;
		} else if ( (current_x >= 57) && (current_x <= 63) ) {
				retval = 6;
		} else if ( (current_x >= 67) && (current_x <= 69) ) {
				retval = 7;
		} else if ( (current_x >= 73) && (current_x <= 75) ) {
				retval = 8;
		} else {
			retval = -1;
		}
	} else retval = -1;

	return(retval);
}

int DialogKi(fmp)
FORMPTR fmp;
{
	int item, execution_flag, in_dialog_box;
	DFIELDPTR fldptr;

	ShowCursor();
wait_input_dialog:
	if ( !mouse_have_been_pressed ) {
		do {
			press_m2 = 1;
			GetButtonPressInfomation(&press_m1, &press_m2, &press_x, &press_y);
			press_x /= 8;
			press_y /= 8;
			if (press_m2 > 0) {
				HideCursor();
				return( KEY_ESC );
			}
			ButtonStatusAndMousePosition(&current_status, &current_x, &current_y);
			current_x /= 8;
			current_y /= 8;
			if (current_status == 1) {
				mouse_have_been_pressed = mouse_not_released = 1;
				press_m2 = 0;
				GetButtonPressInfomation(&press_m1, &press_m2, &press_x, &press_y);
				press_x /= 8;
				press_y /= 8;
				if ( (press_m2 > 0) && (special_dialog != 1) ) {
					item = DialogItem(fmp, press_x, press_y);
					in_dialog_box = InDialogWin(fmp, press_x, press_y);
					if ( (item == -1) && (in_dialog_box == 1) )
						execution_flag = 1;
					else execution_flag = 0;
					if (item==fmp->cur_item) {
						fldptr = (DFIELDPTR) i_numptr(item, fmp);
						if (fldptr->type==F_BOOL) {
							HideCursor();
							return(599);
						} else if ( ( (fldptr->type==F_STRING) && (fldptr->clistp!=NULLP) ) ||
							    (fldptr->type==F_MEMO) ) {
							mouse_have_been_pressed = mouse_not_released = 1;
							HideCursor();
							return(KEY_F2);
						}
					}
				}
				break;
			} else if (ki_chk() != 0) {
				HideCursor();
				return( ki() );
			}
		} while ( 1 );
	}
	do {
		if (mouse_not_released) {
			item = DialogItem(fmp, current_x, current_y);
			fldptr=(DFIELDPTR) i_numptr(item,fmp);
			if ( (item != -1) && (item != fmp->cur_item) && ((fldptr->flags & SKIP) != SKIP) ) {
				HideCursor();
				return(item+500);
			} else  goto next_mouse_status_dialog;
		} else {
			mouse_have_been_pressed = mouse_not_released = 0;
			item=DialogItem(fmp, current_x, current_y);
			in_dialog_box=InDialogWin(fmp, current_x, current_y);
			if ( (item == -1) && (in_dialog_box==1) && (execution_flag == 1) ) {
				HideCursor();
				return(KEY_F10);
			} else if (in_dialog_box == 0) {
				HideCursor();
				return(KEY_ESC);
			} else 	goto wait_input_dialog;
		}

next_mouse_status_dialog:
		ButtonStatusAndMousePosition(&current_status, &current_x, &current_y);
		current_x /= 8;
		current_y /= 8;
		if (current_status != 1)  mouse_not_released = 0;

	} while ( 1 );
}

int DialogItem(fmp, x, y)
FORMPTR fmp;
int x, y;
{
	int i, retval;
	DFIELDPTR fldptr;
	MEMOPTR memoptr;

	retval = -1;
	for (i = 0; i < fmp->itemq; i++) {
		fldptr = (DFIELDPTR) i_numptr(i, fmp);
		if (fldptr->type == 10) { /* Memo Field */
			memoptr = (MEMOPTR) i_numptr(i,fmp);
			if ( ( y == memoptr->wnp->rb ) &&
			     ( x >= memoptr->wnp->cb ) &&
			     ( x <= memoptr->wnp->ce)    ) 
			{
				retval = i;
				break;
			}
		} else {
			if ( ( y == (fldptr->rb + fmp->wnp->rb) ) &&
			     ( x >= (fldptr->cb + fmp->wnp->cb) ) &&
			     ( x <= (fldptr->cb + fmp->wnp->cb + fldptr->len - 1)))
			{
				retval = i;
				break;
			}
		}
	}
	return(retval);
}

int InDialogWin(fmp, x, y)
FORMPTR fmp;
int x, y;
{
	int retval;

	if ( (x >= fmp->wnp->cb)  &&
             (x <= fmp->wnp->ce)  &&
             (y >= fmp->wnp->rb)  &&
             (y <= fmp->wnp->re)     )
	{
		retval = 1;
	} else  retval = 0;

	return(retval);
}

int CListKi(clistp)
CLISTPTR clistp;
{
	int item;

	ShowCursor();

wait_input_clist:
	if ( !mouse_have_been_pressed ) {
		do {
			press_m2 = 1;
			GetButtonPressInfomation(&press_m1, &press_m2, &press_x, &press_y);
			press_x /= 8;
			press_y /= 8;
			if (press_m2 > 0) {
				HideCursor();
				return( KEY_ESC );
			}
			ButtonStatusAndMousePosition(&current_status, &current_x, &current_y);
			current_x /= 8;
			current_y /= 8;
			if (current_status == 1) {
				mouse_have_been_pressed = mouse_not_released = 1;
				break;
			} else if ( ki_chk() != 0) {
				HideCursor();
				return( ki() );
			}
		} while ( 1 );
	}
	do {
		if (mouse_not_released) {
			ButtonStatusAndMousePosition(&current_status, &current_x, &current_y);
			current_x /= 8;
			current_y /= 8;
			if ( ((item = CListItem(clistp, current_x, current_y) ) > -1) &&
			     ((item+clistp->wnp->row_org) != clistp->itemnum) ) {
				HideCursor();
				return(item+500);
			} else if ( (current_status==1) && (item == -2) ) {  /* Up Arrow Key */
				TimeDelay(10);
				HideCursor();
				return(KEY_UP);
			} else if ( (current_status==1) && (item == -3) ) {  /* Down Arrow Key */
				TimeDelay(10);
				HideCursor();
				return(KEY_DN);
			} else goto next_mouse_status_clist;
		} else {
			mouse_have_been_pressed = mouse_not_released = 0;
			ButtonStatusAndMousePosition(&current_status, &current_x, &current_y);
			current_x /= 8;
			current_y /= 8;
			if ( (item=CListItem(clistp, current_x, current_y)) > -1 ) {
				HideCursor();
				return(KEY_ENTER);
			} else  if (item == -4) {
				HideCursor();
				return(KEY_F10);
			} else 	goto wait_input_clist;
		}

next_mouse_status_clist:
		ButtonStatusAndMousePosition(&current_status, &current_x, &current_y);
		current_x /= 8;
		current_y /= 8;
		if (current_status != 1)  mouse_not_released = 0;

	} while ( 1 );
}

CListItem(clistp, x, y)
CLISTPTR clistp;
int x, y;
{
	int retval;

	if ( (x >= (clistp->wnp->cb-2) )  &&
             (x <= (clistp->wnp->ce+2) )  &&
             (y >= (clistp->wnp->rb-1) )  &&
             (y <= (clistp->wnp->re+1) )     )
	{
		if ( (x >= (clistp->wnp->cb-1) )  &&
        	     (x <= (clistp->wnp->ce+1) )  &&
	             (y >= clistp->wnp->rb)  &&
        	     (y <= clistp->wnp->re)     )
		{
			retval = y - clistp->wnp->rb;
		} else if ( (clistp->wnp->sbarp != NULL) && (x == (clistp->wnp->ce+2) ) && (y == clistp->wnp->rb) )
			retval = -2;
		else if ( (clistp->wnp->sbarp != NULL) && (x == (clistp->wnp->ce+2) ) && (y == clistp->wnp->re) )
			retval = -3;
		else retval = -4;
	} else retval = -1;

	return(retval);
}

void TimeDelay(cen_sec)
int cen_sec;
{
	union REGS M_INREG, M_OUTREG;
	union REGS *M_INREG_ptr=&M_INREG, *M_OUTREG_ptr=&M_OUTREG;
	int start_time, end_time;

	M_INREG_ptr->x.ax = 0x2c00;
	int86(0x21,M_INREG_ptr,M_OUTREG_ptr);
	start_time = end_time = ((M_OUTREG_ptr->x.dx & 0xff00)>>8)*100 + (M_OUTREG_ptr->x.dx & 0x00ff);
	while ( ((end_time-start_time) < cen_sec) && ((end_time-start_time) >= 0) ) {
		int86(0x21,M_INREG_ptr,M_OUTREG_ptr);
		end_time = ((M_OUTREG_ptr->x.dx & 0xff00)>>8)*100 + (M_OUTREG_ptr->x.dx & 0x00ff);
	}
}

int RedDialogKi()
{
	int retval;

	ShowCursor();
	press_m2 = 0;
	GetButtonPressInfomation(&press_m1, &press_m2, &press_x, &press_y);
	press_m2 = 1;
	GetButtonPressInfomation(&press_m1, &press_m2, &press_x, &press_y);
	do {
		press_m2 = 0;
		GetButtonPressInfomation(&press_m1, &press_m2, &press_x, &press_y);
		press_x /= 8;
		press_y /= 8;
		if (press_m2 > 0) {
			retval = KEY_ENTER;
			break;
		} else {
			press_m2 = 1;
			GetButtonPressInfomation(&press_m1, &press_m2, &press_x, &press_y);
			press_x /= 8;
			press_y /= 8;
			if (press_m2 > 0) {
				retval = KEY_ESC;
				break;
			} else if ( ki_chk() != 0 ) {
				retval = ki();
				if (retval != 0x0d)
				   if ((retval < 0x20) || (retval > 0x7f)) retval = 0x20;
				break;
			}
		}
	} while (1);
	HideCursor();
	return(retval);
}

int HelpKi(helpwnp)
WINDOWPTR helpwnp;
{
	int item, tempki;

	ShowCursor();

wait_input_help:
	if ( !mouse_have_been_pressed ) {
		do {
			press_m2 = 1;
			GetButtonPressInfomation(&press_m1, &press_m2, &press_x, &press_y);
			press_x /= 8;
			press_y /= 8;
			if (press_m2 > 0) {
				HideCursor();
				return( KEY_ESC );
			}
			ButtonStatusAndMousePosition(&current_status, &current_x, &current_y);
			current_x /= 8;
			current_y /= 8;
			if (current_status == 1) {
				mouse_have_been_pressed = mouse_not_released = 1;
				break;
			} else if ( ki_chk() != 0) {
			    tempki = ki();
				if ((tempki == KEY_PGUP) ||
				    (tempki == KEY_PGDN) ||
				    (tempki == KEY_LEFT) ||
				    (tempki == KEY_RIGHT) ||
				    (tempki == KEY_UP) ||
				    (tempki == KEY_DN) ||
                    (tempki == KEY_HOME) ||
				    (tempki == KEY_END) ||
				    (tempki == KEY_ESC))
				{
                   HideCursor();
				   return( tempki );
				}
			}
		} while ( 1 );
	}
	do {
		if (mouse_not_released) {
			ButtonStatusAndMousePosition(&current_status, &current_x, &current_y);
			current_x /= 8;
			current_y /= 8;
			item = HelpUpOrDown(helpwnp, current_x, current_y);
			if ( (current_status==1) && (item == 0) ) {
				TimeDelay(10);
				HideCursor();
				return(KEY_UP);
			} else if ( (current_status==1) && (item == 1) ) {
				TimeDelay(10);
				HideCursor();
				return(KEY_DN);
			} else goto next_mouse_status_help;
		} else {
			mouse_have_been_pressed = mouse_not_released = 0;
			goto wait_input_help;
		}

next_mouse_status_help:
		ButtonStatusAndMousePosition(&current_status, &current_x, &current_y);
		current_x /= 8;
		current_y /= 8;
		if (current_status != 1)  mouse_not_released = 0;

	} while ( 1 );
}

int HelpUpOrDown(helpwnp, x, y)
WINDOWPTR helpwnp;
int x, y;
{
	int retval;

	if ( (x == (helpwnp->ce+2) ) && (y == helpwnp->rb) )
		retval = 0;
	else if ( (x == (helpwnp->ce+2) ) && (y == helpwnp->re) )
		retval = 1;
	else retval = -1;

	return(retval);
}

int DialogColorKi(wnp, curfld)
WINDOWPTR wnp;
int *curfld;
{
	int item, execution_flag, in_dialog_box;

	ShowCursor();
wait_input_dialog_color:
	if ( !mouse_have_been_pressed ) {
		do {
			ButtonStatusAndMousePosition(&current_status, &current_x, &current_y);
			current_x /= 8;
			current_y /= 8;
			if ( (current_status == 1) || (current_status == 2) ) {
				mouse_have_been_pressed = mouse_not_released = 1;
				press_m2 = 0;
				GetButtonPressInfomation(&press_m1, &press_m2, &press_x, &press_y);
				press_x /= 8;
				press_y /= 8;
				if ( press_m2 > 0 ) {
					item = DialogColorItem(press_x, press_y);
					in_dialog_box = InDialogColorWin(press_x, press_y);
					if ( (item == -1) && (in_dialog_box == 1) )
						execution_flag = 1;
					else execution_flag = 0;
					if (item == *curfld) {
						HideCursor();
						mouse_have_been_pressed = mouse_not_released = 0;
						return(KEY_F9);
					}
				}
				press_m2 = 1;
				GetButtonPressInfomation(&press_m1, &press_m2, &press_x, &press_y);
				press_x /= 8;
				press_y /= 8;
				if ( press_m2 > 0 ) {
					mouse_have_been_pressed = mouse_not_released = 0;
					item = DialogColorItem(press_x, press_y);
					execution_flag = 0;
					if (item == *curfld) {
						HideCursor();
						return(KEY_F10);
					} else if (current_status == 2) {
						HideCursor();
						return(KEY_ESC);
					}
				}
				break;
			} else if ( ki_chk() != 0) {
				HideCursor();
				return( ki() );
			}
		} while ( 1 );
	}
	do {
		if (mouse_not_released) {
			item = DialogColorItem(current_x, current_y);
			if ( (item != -1) && (item != *curfld) ) {
				HideCursor();
				return(item+0x30);
			} else  goto next_mouse_status_dialog_color;
		} else {
			mouse_have_been_pressed = mouse_not_released = 0;
			item = DialogColorItem(current_x, current_y);
			in_dialog_box = InDialogColorWin(current_x, current_y);
			if ( (item == -1) && (in_dialog_box==1) && (execution_flag == 1) ) {
				HideCursor();
				*curfld = 2;
				return(KEY_ENTER);
			} else if (in_dialog_box == 0) {
				HideCursor();
				return(KEY_ESC);
			} else 	goto wait_input_dialog_color;
		}

next_mouse_status_dialog_color:
		ButtonStatusAndMousePosition(&current_status, &current_x, &current_y);
		current_x /= 8;
		current_y /= 8;
		if (current_status != 1)  mouse_not_released = 0;

	} while ( 1 );
}

int DialogColorItem(x, y)
int x, y;
{
	if ( ( x > 54 ) || ( x < 31 ) ) return(-1);
	else if ( y ==  8 ) return(0);
	else if ( y == 10 ) return(1);
	else if ( y == 12 ) return(2);
	else return(-1);
}

int InDialogColorWin(x, y)
int x, y;
{
	int retval;

	if ( (y >= 4) && (y <= 14) && (x >= 18) && (x <= 62) ) retval = 1;
	else retval = 0;

	return(retval);
}

void ChkMouseLBAndEsc(keyin)
int *keyin;
{
	extern int HAND_SHAKE;

	press_m2 = 1;
	GetButtonPressInfomation(&press_m1, &press_m2, &press_x, &press_y);
	press_x /= 8;
	press_y /= 8;
	if (press_m2 > 0) *keyin = KEY_ESC;
}
