
/***************************************************************************
**
**    $Header:   D:/USD3V/LOG/SRC/OLDSYM.C__   1.2   12 Jun 1996 08:43:50   ZJRD  $
**
**    $Log:   D:/USD3V/LOG/SRC/OLDSYM.C__  $
** 
**    Rev 1.2   12 Jun 1996 08:43:50   ZJRD
** No change.
** 
**    Rev 1.1   24 May 1996 09:42:56   ZJRD
** No change.
** 
**    Rev 1.0   11 Dec 1995 13:52:00   ZJRD
** Initial revision.
** 
****************************************************************************/
/*--------------------------------------------------------------------------*/
/*  oldsym.c								    */
/*--------------------------------------------------------------------------*/


#include  "system.h"
#include  "usd3.h"
#include  "gblext.h"
#include  "oldext.h"
#include  "usym1.h"
#include  "usym3.h"
#include  "funcext.h"

#define CS_APPEND	1
#define ELSE		3
#define LAB		0
#define NO_CS_APPEND	0

char ADR_SYM[45], *ls_cmd0_ptr, cs_ip_386[18], result[160], *out_ptr;
int mice3_step, opr_pos, cbar_index, bbr_index, cbr_index, A_phy_index;
int IF_EXIST[3], absORcsip, to_symbolDest;
long bbr, cbr, car, bar;
unsigned int cbar;

extern char PROMPT[];

get_real_sym(no,start_sym,end_sym)
int no;
char *start_sym, *end_sym;
{
	int i, rr, j, ii;
	char *ptr, *ptr1, sym_temp[80];
	unsigned long asc_hex();
	unsigned long ll, l2;

	ptr1 = start_sym;
	sym_end[no] = end_sym;
	if((ptr=index(ptr1,'+')) || (ptr=index(ptr1,'-'))
	 ||(ptr=index(ptr1,'*')) || (ptr=index(ptr1,'/'))) {
		for(i=0 ; ptr1 < ptr ; ptr1++) sym_temp[i++] = *ptr1;
		sym_temp[i] = '\0';
		rr = sym2adr(sym_temp,comsym.addr);
		if(rr == FOUND) {
			ll = asc_hex(ptr + 1);
			if(env.Maddrunit == 6) {
				i = 3;
				ii= 2;
			} else {
				i = 1;
				ii= 0;
			}
			for(l2=comsym.addr[ii] ; i<env.Maddrunit ; i++)
				l2 = (l2<<8) + comsym.addr[i];
			switch(*ptr) {
				case '+':
					l2 += ll;
					break;
				case '-':
					l2 -= ll;
					break;
				case '*':
					l2 *= ll;
					break;
				case '/':
					l2 /= ll;
					break;
			}
			for(i=env.Maddrunit-1,j=0 ; i>=ii ; i--,j+=8)
				comsym.addr[i] = l2 >> j & 0xff;
		}
	} else {
		for(i=0 ; ptr1 < end_sym ; ptr1++) sym_temp[i++] = *ptr1;
		sym_temp[i] = '\0';
		rr = sym2adr(start_sym,comsym.addr);
	}
	return(rr);
}

sym_valid()
{
	return(-1);
}

#define    MSK_MOD   0x02
#define    MSK_GBL   0x01

sym2adr(sym,addr)
char *sym;
int *addr;
{
		char buf[80];
		int r;
		int VPtmp;
		comsym.mask = MSK_PHY;
		if(PC.flag == OK) {
			memmove(comsym.pc,PC.addr,env.Maddrunit);
			comsym.mask |= MSK_PCY;
		} else if(PC.flag == GO_RUN) comsym.mask |= MSK_GRY;

		if(ModuInCmd != NOT_IN_LOCAL) {
			comsym.mask |= MSK_MOD;
			comsym.modx = ModuInCmd;
		}

		strcpy(comsym.name,sym);
		r = SymToAddr();
		return(r);
}

get_csip(cmd0)
char cmd0;
{
	char c1, c2;
	int i, j, ii, jj;
	AppendToCmdBuf(ADDR_START);
	j = env.Maddrunit << 1;
	for(i=0,ii=0 ; i<j ; i++) {
		cs_ip[sym_no][ii++]=hex[(comsym.addr[i]>>4)&0xf];
		cs_ip[sym_no][ii++]=hex[comsym.addr[i]&0xf];
		if ( ( i==1 &&
			   ((env.Maddrid==I8086&&env.Mmodel!=M_3_H8)||env.Maddrid==M_3_386)
			 ) ||
			 ( i==0 && env.Mmodel==M_3_H8 )
		   )  cs_ip[sym_no][ii++] = ':';
	}
	if(env.Maddrid==I8086 || env.Maddrid==M_3_386) {
		if(cmd0 == 'L') {
			csip_abs(cs_ip[sym_no],cs_ip[sym_no]);
			ii = 0;
			jj = 5;
		} else {
			ii = (sym_no==1&&!strnicmp(cs_ip[0],cs_ip[1],4)) ? 5 : 0;
			jj = env.Mcsiplen;
		}
/* 8048 only low 3 hex, 64180 only low 5 hex, accept */
	} else {
		ii=(env.Mmodel==I_8048||env.Mmodel==I_8050||env.Mmodel==M_64180||env.Mmodel==M_68008);
		jj = j;
	}
	for(i=ii ; i<jj ; i++) {
		c2 = cs_ip[sym_no][i];
		put_buf_send(c2);
		do {
			c1 = receive();
			AppendToCmdBuf(c1);
		} while(c1 != c2) ;
	}
	AppendToCmdBuf(ADDR_END);
}

csip_abs(src,dest)
char *src, *dest;
{
	long abs_addr;
	unsigned cs, ip;
	unsigned char asc2hex();
	int i, j;
	for(i=0,j=5,cs=0,ip=0 ; i<4 ; i+=2,j+=2) {
		cs = (cs << 8) + asc2hex(src[i],src[i+1]);
		ip = (ip << 8) + asc2hex(src[j],src[j+1]);
	}
	abs_addr = cs;
	abs_addr = (abs_addr << 4) + ip;
	for(i=16,j=0 ; j<5 ; i-=4,j++)
		dest[j] = hex[abs_addr>>i & 0xf];
}

unsigned char asc2hex(a,b)
unsigned char a,b;
{
	unsigned char r;
	r = asc__h(a);
	r = (r << 4) | asc__h(b);
	return(r);
}

unsigned long asc_hex(p)
char *p;
{
	unsigned long ll=0L;
	char c;
	int cc;
	while(c=*p++) {
		if(isdigit(c)) cc = c - '0';
		else if(c<='F' && c>='A') cc = 10 + c - 'A';
		else if(c<='f' && c>='a') cc = 10 + c - 'a';
		else cc = 0;
		ll = (ll << 4) + cc;
	}
	return(ll);
}

adr2sym(ori_ptr,dest_ptr,ori_len,code)
char *ori_ptr, *dest_ptr;
int ori_len, code;
{
	int i, r, j, VPtmp;
	char bbb[80];
	comsym.mask = (absORcsip == PHY) ? MSK_PHY : MSK_ABS;
	if(code == LOCAL) comsym.mask |= MSK_PCY;
	else comsym.mask |= MSK_GRY;
	r = AddrToSym(&i);
/* debug 
{
	int VPtmp;
	char bbb[200];
	VPtmp = VPOut;
	VPOut = CODVP;
	sprintf(bbb,"\n\rin adr2sym(),r=%d,code=%d,mask=%x,addr=%x,%x,%x,%x,%x,%x\n\rpc.flag=%d,name= %s\n\r",r,code,comsym.mask,
	comsym.addr[0],comsym.addr[1],comsym.addr[2],comsym.addr[3],comsym.addr[4],comsym.addr[5],
	PC.flag,comsym.name);
	d_prntf(bbb);
	VPOut = VPtmp;
}
 debug */
	if(r >= FOUND) {
		*dest_ptr = NAME;
		j = strlen(comsym.name);
		strncpy(dest_ptr+1,comsym.name,j);
		out_ptr = dest_ptr + j + 1;
		*out_ptr = '\0';
		r = FOUND;
	}
	return(r);
}

to_symbol(flag,ch)
int flag;
char ch;
{
	int i, i1, i4, j, l1, code, a_s_index, moreflag=0, loop=-1;
	char *ptr, *ptr1, *ptr_tmp, c, c1, tmp1, tmp2, *z_src_ptr, tmpc;
	char cmd_temp[100], tmpMICEBuf[200];
	char opcode_high_4_bit, r;
	char *LS_CMD0();
	char cmd0=USDtoupper(cmd_argv[0][0]);

	CodeVPRange.LFcount = 0;
	to_symbolDest = flag;
	if(flag == CODVP) {
try_again:
		while(ch != 'L' && ch != 'A' && ch!='>') ch = receive();
		if(ch != '>') {
			ptr = CODBuf[CurrentCODBuf];
			*ptr++ = ch;
			for(i=0 ; i<3 ; i++) {
				tmpc = *ptr++ = receive();
				if (i==0 && tmpc!='d' && tmpc!='O') break;
				else if (i==1 && tmpc!='d' && tmpc!='C') break;
				else if (i==2 && tmpc!='r' && tmpc!=' ') break;
			}
			*ptr = '\0';
		       	if(strncmp(CODBuf[CurrentCODBuf],"Addr",i+1) && strncmp(CODBuf[CurrentCODBuf],"LOC ",i+1)) goto try_again;
			else {
				while((ch=receive()) != LF) *ptr++ = ch;
				*ptr = '\0';
				z_d_prntf(CODBuf[CurrentCODBuf]);
				if(ch == LF) z_d_prntf("\n\r");
			}
		} else return(0);
	}   /* end if (flag == CODVP) */
	do {
		loop++;
		if(chk_hlt() == ESC) {
			send_ESC();
			return(ESC);
		}
		i4 = env.pos[0];
		i = a_s_index = j = 0;
		mice3_step = 0;
		absORcsip = (env.Maddrid == I8086 || env.Maddrid == M_3_386) ? ABS : PHY;
		code = LOCAL;
		if (moreflag) {
			while ( (ch=receive()) != CR ) ;
			while ( (ch=receive()) != CR ) {
				if((ch == '>') && ((ch=receive()) == HAND_SHAKE)) return(ESC);
			}
			DisplayStr("\r               \r");
			moreflag = 0;
		}
/*		while ((c1=receive())!=LF && c1!=HAND_SHAKE && c1!='>') {
			if(c1>0) cmd_temp[i++] = c1;
		}
		cmd_temp[i] = '\0';	   */		 /**** kick out CR ****/

		do {
			c1 = receive();
			if (c1 != LF && c1!=HAND_SHAKE && c1!='>') {
				if (c1 > 0) cmd_temp[i++] = c1;
			} else break;
		} while(1);
		cmd_temp[i] = '\0';
		if (c1 == '>') {
			strcat(cmd_temp,">");
			strcpy(PROMPT,cmd_temp);
		}

		if (!loop && (c1==HAND_SHAKE)) return(0);

		if ((c1 == HAND_SHAKE) && (cmd_temp[i-1] != '>')) {
			if ((strstr(cmd_temp,"more") != NULL) ||
			    (strstr(cmd_temp,"MORE") != NULL) ||
			    (strstr(cmd_temp,"More") != NULL)) 	moreflag = 1;
		}
		while(cmd_temp[j++] == CR) ;
		a_s_index = i - j + 1;
		strcpy(tmpMICEBuf,cmd_temp+j-1);
		if((env.Mmodel==I_8048 || env.Mmodel==I_8050) && opr_adr==1) {
			for ( i = i4; i < i4+6; i++) tmpMICEBuf[i-3] = tmpMICEBuf[i];
			for (j=0; j <3 ; j++) tmpMICEBuf[--i] = ' ';
			i4 -= 3;
		}

		hex_addr_bin(tmpMICEBuf+env.mmu[1],comsym.pc);
		ptr = (char *)tmpMICEBuf - 1;
		out_ptr = result - 1;
		if (cmd0 == 'L' && cmd1 != 'S' && cmd1 != 'I' && cmd1 != 'Z') 
			opr_pos = 80;
		else opr_pos = env.pos[opr_adr+(cmd0=='L' && cmd1=='S')];
		if(opr_adr == 1) {
			i1 = 0;
			do {
				c = *++ptr;
				*++out_ptr = c;
			} while((c==' '||c==CR) && ++i1<4) ;
			if(i1 < 4) {
				ptr_tmp = ptr;
				ptr--;
				out_ptr--;
				if(env.Mmodel==I_8048 || env.Mmodel==I_8050) l1 = 3;
				else l1 = 4;
				for(i=0 ; i<l1 && ishex(*++out_ptr=*++ptr) ; i++) ;
				if(i == l1) {
					out_ptr -= (i-1);
					strncpy(cs_ip_386,&(tmpMICEBuf[env.mmu[0]]),env.Mcsiplen);
					r = ascii_long(env.Mcsiplen,NO_CS_APPEND,ADR_SYM,code,LAB);
					if(r == FOUND) {
						z_d_prntf(ADR_SYM);
						z_d_prntf("\n\r");
					}
					if(r == ESC) {
						if (cmd_argv[0][0] != 'L') {
							strcat(cmd_temp,">");
							strcpy(LastCOMVPLine,cmd_temp);
							strcpy(prompt,cmd_temp);
						}
						return(ESC);
					}
					if(env.mmu[0]) {
						ptr = (char *)tmpMICEBuf - 1;
						out_ptr = result - 1;
					} else {
						ptr    =ptr_tmp+  env.Mcsiplen-1-(env.Mmodel==I_8048 || env.Mmodel==I_8050);
						out_ptr=result+i1+env.Mcsiplen-1-(env.Mmodel==I_8048 || env.Mmodel==I_8050);
					}
				} 		 /* end if (i == l1) */
			}            /* end if (i1 < 4) */
		}                /* end if (opr_adr == 1) */
/*---------------------------------------------------------------*/
/*** 1. The branch instructions of 68020, 68000, 68008, 68010 has:
	Bcc, BRA, BSR,	 (high 4 bit of first opcode byte = 0110, the only)
	JMP, JSR
     2.	z_src_ptr+1 for "LCALL", "LJMP", "SJMP", "ACALL" case
     3. The return instructions of 68020, 68000, 68008, 68010 has:
     	RTM, RTE, RTD, RTS, RTR
---------------------------------------------------------------***/
		z_src_ptr = (char *) tmpMICEBuf + opr_pos - env.pos[7];
		if(opr_adr != 1) {
			if(env.Maddrid==M68020 || env.Maddrid==M68K || env.Maddrid==M6809) {
				if(*z_src_ptr=='J' || *z_src_ptr=='B') code=ALL;
				else code = ELSE;
			} else {
				if(*z_src_ptr=='J' || *(z_src_ptr+1)=='J'
				|| !strnicmp("CAL",z_src_ptr,3)
				|| !strnicmp("CAL",(z_src_ptr+1),3)
				|| !strnicmp("LOOP",z_src_ptr,4)
				|| (env.Maddrid==I8086 && *z_src_ptr=='B' && *(z_src_ptr+1)=='R')) {
					code = ALL;
					mice3_step=(env.Mmodel>MICE_3_BOUND && opr_adr==2);
				} else code = ELSE;
			}
		} else {  /* if (opr_adr == 1) */
			absORcsip = ((env.Maddrid==I8086 || env.Maddrid==M_3_386) &&
			*z_src_ptr!='J'&&*(z_src_ptr+1)!='J'&&strnicmp("BR",z_src_ptr,2)
			&& strnicmp("CA",z_src_ptr,2) && strnicmp("CAL",(z_src_ptr+1),3)
			&& strnicmp("LOOP",z_src_ptr,4))
			  ? ABS : PHY;
		}
		ptr_tmp = (char *)tmpMICEBuf + opr_pos;
		for( ; ++ptr<ptr_tmp  ; ) *++out_ptr = *ptr;
		ls_cmd0_ptr = LS_CMD0();
/* If "List Source" command, must be the trace frame line */
		if(env.Mmodel == M_64180 && *ls_cmd0_ptr=='0' && opr_adr==3)
			get_MMU();
		if(a_s_index > opr_pos) {
			ptr = (char *)tmpMICEBuf + opr_pos;
			out_ptr = result + opr_pos;
			if((*out_ptr=*ptr) == ' ') while((*++out_ptr=*++ptr) == ' ') ;
			else {
		     		do {
				    	c = *++ptr;
		    			*++out_ptr = c;
			    	} while(c!=' ' && c) ;
		    		if(c) {
			    		do {
				    		c = *++ptr;
					    	*++out_ptr = c;
				    	} while(c==' ' && c) ;
			    	}
			}
			while(*ptr != '\0') {
				if(*ptr==CR || *ptr==LF) *out_ptr++ = *ptr++;
				else {
					do {
						c = *ptr++;
						*out_ptr++ = c;
					} while(c!='\0' && ishex(c)==0) ;
					if(c == '\0') break;
					ptr_tmp = ptr - 1;
					i = 1;
	     				if(env.Mmodel==I_8048 || env.Mmodel==I_8050) l1 = 3;
					else l1 = 4;
					while(ishex(*out_ptr++=*ptr++)) i++;
					ptr--;
					out_ptr--;
					tmp1 = *(ptr_tmp-1);
					tmp2 = *(ptr_tmp-2);

					if (tmp1!='#' && tmp1!='=' && tmp2!='=' && 
					    i>=l1 && (i<=env.Mcsiplen||i==env.Mcsiplen))  {
						if ((env.Mmodel<=MICE_3_BOUND || env.Mmodel==NEW_Z80) || 
						    (opr_adr == 1) ||
						    (opr_adr==2 && (ls_cmd0_ptr==z_src_ptr ||
						                   (ishex(*ls_cmd0_ptr) && ishex(*(ls_cmd0_ptr+1)) ) ) ) ||
						    (opr_adr==3 && (cmd1=='I' || isalpha(*ls_cmd0_ptr))) ) {
							out_ptr -= i;
/* if(ascii_long(ptr_tmp,i,CS_APPEND,out_ptr,code,OPERAND)==ESC) */
							strncpy(cs_ip_386,ptr_tmp,env.Mcsiplen);

							if(ascii_long(i,CS_APPEND,out_ptr,code,OPERAND)==ESC) {
//							return(ESC);
								if (cmd_argv[0][0] != 'L') {
									strcat(cmd_temp,">");
									strcpy(LastCOMVPLine,cmd_temp);
									strcpy(prompt,cmd_temp);
								}
								return(ESC);
							}

//							{ send_ESC(); return(ESC); }
						}
					} /* end if (tmp1 != '#') */
				}     /* end if (*ptr == CR) else */
			}         /* end while (*ptr != '\0') */
		}			  /* end if (a_s_index > opr_pos) */
		*out_ptr = '\0';

/*** 6-09-87 suppress
case 1: (opr_adr==2)
>Step
LOC        OBJ              SOURCE CODE
00000126   66F4             BNE.B    %IN8
0000011C   3239 00F7 0031   MOVE.W   %USTAT,D1
			    Inst_2   operand_2
			    ^
			    |________ alpha char. allowed!
        0        1        2        3        4        5        6        7
Dn   0003928E FF00FFFF F9B78786 709A230C DABFFE00 10300084 00000001 62204C5C
An   BFFF0203 00000000 00040003 00000000 C0000111 %INBUF BFD5FFC0 0001FFE4
^
|
|___ alpha char. not allowed! (for MICE III, except Z80)

case 2: (opr_adr==3)
>List Source
FRAME ADDRESS     DATA     STATUS   TRACE BIT  TIMER
07F1  000FE19A      %DEMOEN     S      11111111  01.340 265
07F0  000FE198      1E89     S      11111111  01.340 265
^     MOV    AX,BX
|
|___ non-alpha char. not allowed! (for MICE III, except Z80)
***/
/**** 5-14-87, recover CBAR, BBR, CBR data of 64180 in Step command ****/

		if(env.Mmodel == M_64180 && opr_adr == 2) {
			ptr = (char *)tmpMICEBuf + cbar_index;
			ptr1= result + cbar_index;
			while(*ptr1++ = *ptr++) ;
		}
		z_d_prntf(result);
		if ( c1 == LF ) z_d_prntf("\n\r");
		else if ( c1 == HAND_SHAKE ) {
			int i;
			if ( (USDtoupper(cmd_argv[0][0])=='S') || (USDtoupper(cmd_argv[0][0])=='C') )
				for ( i=0; i<5000; i++ )
					if ( upRX_DATA()==LF ) {
						z_d_prntf("\n\r");
						if ( ki_chk() ) { c1=getc_mpds();send(c1); }
						goto cont;
					}
			c1 = getc_mpds();
			send(c1);
		} else if (c1 != '>') receive();
//		else    receive();
cont:;
	} while(c1 != '>' && CodeVPRange.LFcount<=CODBUFROW) ;
	if (c1 == '>') receive();
	return(0);
}

z_d_prntf(bbb)
char *bbb;
{
	if(to_symbolDest == CODVP) {
		if(bbb != CODBuf[CurrentCODBuf]) {
			strcat(CODBuf[CurrentCODBuf],bbb);
			if(index(bbb,LF)) CodeVPRange.LFcount++;
		}
	} else d_prntf(bbb);
}

char *LS_CMD0()
{
	char c, *ptr=result-1;
	while((c=*++ptr) != '\0' && !isalnum(c)) ;
	return(ptr);
}

log_phy_64180(lp)
unsigned long *lp;
{
	long aaa;
	if(*lp >= car)	aaa = cbr;
	else if(*lp >= bar) aaa = bbr;
	else aaa = 0L;
	*lp += aaa;
}

ascii_long(len,code,ptr1,code1,code2)
char *ptr1;
int code, code1, code2, len;
{
	int i, k, r;
	char src[20];
	char cmd0=USDtoupper(cmd_argv[0][0]);
	if((env.Maddrid==I8086 || env.Maddrid==M_3_386)) {
		if(code==NO_CS_APPEND || len>=env.Mcsiplen || mice3_step)
			absORcsip = PHY;
		if(absORcsip == PHY) {
			if(len <= env.Miplen) {
/* insert CS and ':' */		strncpy(src,ls_cmd0_ptr,5);
				strncpy(src+5,cs_ip_386,len);
				src[len + 5] = CR;
			} else {
				strncpy(src,cs_ip_386,len);
				src[len] = CR;
			}
			real_address(src,code2);
		} else {
			strncpy(src,cs_ip_386,len);
			src[len] = CR;
			real_address(src,code2);  /* absORcsip = ABS */
		}
	} else {
		if(env.Mmodel==I_8048 || env.Mmodel==I_8050 || env.Mmodel==M_68008 ||
		(env.Mmodel==M_64180 && ptr1==ADR_SYM)) len = (env.Maddrunit<<1) - 1;
		strncpy(src,cs_ip_386,len);
		src[len] = CR;
		real_address(src,code2);
	}
	if(cmd0 != 'A' || to_symbolDest == CODVP) {
		strncpy(out_ptr,cs_ip_386,len);
		out_ptr += len;
	}
	r = adr2sym(cs_ip_386,ptr1,len,code1);
	return(r);
}

real_address(ptr,code2)
char *ptr;
int code2;
{
	char c, *ptr1;
	int i, k, jj;
	char cmd0=USDtoupper(cmd_argv[0][0]);
	unsigned long a_s_addr;

	ptr1 = ptr;
	while((c = *ptr1++) != CR && c != ':') ;

	if(c==':' && env.Maddrid==M_3_386) {
		for(i=0 ; ishex(k= *ptr++) ; ) {
			if(k != ':')
				comsym.addr[i++] = (asc__h(k) << 4) + asc__h(*ptr++);
		}
	} else {
		for(a_s_addr=0L ; ishex(k=*ptr++) ; ) {
			if(k != ':')
				a_s_addr = (a_s_addr << 4) + asc__h(k);
		}
		if(env.Mmodel==M_64180 && cmd0 != 'A') {
			if(opr_adr == 2) get_MMU();
			if(code2 == OPERAND) log_phy_64180(&a_s_addr);
		}
		for(i=0,k=env.Maddrunit*8-8 ; i<env.Maddrunit ; i++,k-=8)
			comsym.addr[i] = (a_s_addr >> k) & 0xff;
	}
}

ExtSymAdr(in,out,code)
char *in, *out;
int code;
{
	char c, *ptr=in;
	if(*in == NAME) {
		while((c = *ptr++) != ADDR_START && c) ;
		if(c) {
			if(code == SYM) {
				*(ptr-1) = '\0';
				strcpy(out,in);
			} else {
				strcpy(out,ptr);
				if(ptr = index(out,ADDR_END)) *ptr = '\0';
			}
			return;
		}
	}
	strcpy(out,in);
}
