
/***************************************************************************
**
**    $Header:   D:/USD3V/LOG/SRC/OMF286.C__   1.2   12 Jun 1996 08:43:50   ZJRD  $
**
**    $Log:   D:/USD3V/LOG/SRC/OMF286.C__  $
** 
**    Rev 1.2   12 Jun 1996 08:43:50   ZJRD
** No change.
** 
**    Rev 1.1   24 May 1996 09:42:56   ZJRD
** No change.
** 
**    Rev 1.0   11 Dec 1995 13:52:00   ZJRD
** Initial revision.
** 
****************************************************************************/
/*--------------------------------------------------------------------------*/
/*  omf286.c								    */
/*--------------------------------------------------------------------------*/


#include  "system.h"
#include  "usd3.h"
#include  "gblext.h"
#include  "oldext.h"
#include  "usym1.h"
#include  "usym3.h"
#include  "funcext.h"
#include  "download.h"

#define max_32       32
#define bmax_224     224

/*  MIN  28/04/1988  */

extern int s0_down_flg;

/*  MIN  Temperarily reduce Buffer Size to fit 64K limitation, Will recover */

#ifdef  max_rd

#undef  max_rd
#define max_rd  256

#endif

extern unsigned char Badr_len;
extern unsigned char omf_buf[], intel_rec[],*ptr86;
extern unsigned long len_rec_send,len_86;
extern unsigned int rpt_flag;
extern unsigned long next_ip;
extern unsigned long s0_addr;

/*  MIN  */

BOOT_MOD_HDR boot_hdr;

int omf_typ;   /*  0: OMF286      1: OMF386  */
int mpu_typ;   /*  0: MICE-II 80286       1: MICE-III 80386  */

struct {
    int reserve[2];
    int addr[2];
    int lngh[2];
    int ad_ln[2];
    } delta = {{0,8},{0,1},{0,2},{0,3}};
    

/* MM */

#define ETX        0x03
extern int max_len, binary_down;
extern int file_fg;
extern jmp_buf fileblk;

mem_cpy(destn,src,count)

    char *destn,*src;
    int count;

{
    int i;
    
    for (i=0;i<count;i++) destn[i] = src[i];
}


x_mem_cpy(destn,src,count)

    char *destn,*src;
    int count;

{
    int i;
    
    for (i=0;i<count;i++) {
    	destn[i] = src[count-1-i];
    }
}


bin_to_hex(src,destn,count)

    uchar *src,*destn;
    int count;

{
    int i,ii;
    char temp;

    for (i=0,ii=0;i<count;i++) {
        destn[ii]=0x30+(src[i] >> 4);
        if (destn[ii] > 0x39) destn[ii] += 0x07;
        destn[ii+1]=0x30+(src[i] & 0x0f);
        if (destn[ii+1] > 0x39) destn[ii+1] += 0x07;
        ii += 2;
    }
}


ushort b2_to_us(ptr)

    uchar *ptr;

{
    ushort u_short;

    u_short = (ushort)ptr[1];
    u_short = (u_short << 8) + (ushort)ptr[0];
    return (u_short);

}


ulong b4_to_ul(ptr)

    uchar *ptr;

{
    ulong u_l;
    
    u_l = (ulong)ptr[3];
    u_l = (u_l << 8) + (ulong)ptr[2];
    u_l = (u_l << 8) + (ulong)ptr[1];
    u_l = (u_l << 8) + (ulong)ptr[0];
    
    return (u_l);

}
        

us_to_b2(u_sh,ptr)

	ushort u_sh;
    char *ptr;

{
    ptr[0]=(u_sh >> 8) & 0xff;
    ptr[1]=(u_sh & 0xff);
}
        

ul_to_b4(u_l,ptr)

	ulong u_l;
    char *ptr;

{
    ptr[0]=(u_l >> 24) & 0xff;
    ptr[1]=(u_l >> 16) & 0xff;
    ptr[2]=(u_l >> 8) & 0xff;
    ptr[3]=(u_l & 0xff);
}
        
        
/****************************************************************

    ret_sts=verify_checksum();

        int ret_sts;        : = ESC      ; ESC key pressed
                              = CTRL-C   ; CTRL-C key pressed
                              = -1       ; error return
                              = 1        ; normal return
                                                            
****************************************************************/
/*
verify_checksum()

{
    int i,k;
    uchar chksum;
    char c;

    lseek(fddown,1L,0);

    chksum=0;
    for (;;) {
        i = read(fddown,omf_buf,256);
        if (i < 0) {
             file_fg=FERR_FILE_READ_ERROR;
             longjmp(fileblk,-1);
        }
        for (k=0;k<i;k++) {
            chksum += omf_buf[k];
        }
        if (i < 256) break;
    }
    if (chksum==0) return (1);
    else {
        file_fg=FERR_INVALID_DOWNLOAD_FILE;
        longjmp(fileblk,-1);
    }
}
*/

dwn_rec()
{
    char c;
    int i, j, ii, flag, rr, cc;
    
    if (!binary_down) {
        ii = 2;
        cbuf[0] = intel_rec[0];
        cbuf[1] = intel_rec[1];
        for (i=2; i <= (intel_rec[2]+2); i++) {
            hex2asc(&cbuf[ii],intel_rec[i]);
            ii += 2;
        }
        if (intel_rec[0]=='S' && intel_rec[1]=='3') {
            for (i=0; i<(6+(delta.addr[mpu_typ] << 1)); i++) 
                DisplayCh(cbuf[i+(6-(delta.addr[mpu_typ] << 1))]);
/***** 5-19-89 *****/
save_curs(&rr,&cc);
set_cur(rr,cc-(6+(delta.addr[mpu_typ] << 1)));
/***** 5-19-89	for(i=0; i<(6+(delta.addr[mpu_typ] << 1)); i++) DisplayCh(BS); *****/
        }
        if(down_5_time(ii) == -1) return(-1);
    }
    else {
        hex2asc(&cbuf[4],(s0_addr>>24) & 0xff);
        hex2asc(&cbuf[6],(s0_addr>>16) & 0xff);
        hex2asc(&cbuf[8],(s0_addr>>8) & 0xff);
        hex2asc(&cbuf[10],s0_addr & 0xff);
        if (rpt_flag) {
            for (i=0;i<(6+(delta.addr[mpu_typ] << 1)); i++) 
                DisplayCh(cbuf[i+(6-(delta.addr[mpu_typ] << 1))]);
/***** 5-19-89 *****/
save_curs(&rr,&cc);
set_cur(rr,cc-(6+(delta.addr[mpu_typ] << 1)));
/* 5-19-89  for(i=0; i<(6+(delta.addr[mpu_typ] << 1)); i++) DisplayCh(BS); *****/
        }
        if(Bdown_5_time() == -1) return(-1);
    }
    return(0);
}


/****************************************************************

    ret_sts=boot_mod_header();

        int ret_sts;        : = ESC      ; ESC key pressed
                              = CTRL-C   ; CTRL-C key pressed
                              = -1       ; error return
                              = 1        ; normal return
                              
****************************************************************/
boot_mod_header()

{

    int i;
    uchar sum;
    char c;
        
    i = read(fddown,omf_buf,75);
    if (i < 0) {
        file_fg=FERR_FILE_READ_ERROR;
        longjmp(fileblk,-1);
    }
    if (i != 75) {
        file_fg=FERR_INVALID_DOWNLOAD_FILE;
        longjmp(fileblk,-1);
    }

    boot_hdr.boot_tspace=b4_to_ul(&omf_buf[0]);
    mem_cpy(boot_hdr.boot_date,&omf_buf[4],8);
    mem_cpy(boot_hdr.boot_time,&omf_buf[12],8);
    mem_cpy(boot_hdr.boot_creator,&omf_buf[20],41);
    boot_hdr.boot_gdtl=b2_to_us(&omf_buf[61]);
    boot_hdr.boot_gdtb=b4_to_ul(&omf_buf[63]);
    boot_hdr.boot_idtl=b2_to_us(&omf_buf[67]);
    boot_hdr.boot_idtb=b4_to_ul(&omf_buf[69]);
    boot_hdr.boot_tss=b2_to_us(&omf_buf[73]);

    return (1);
}


bin_eval_sum(ptr,byt_cnt)
    char *ptr;
    int byt_cnt;
{
    int i;
    uchar val;

    val=0;
    for(i=0;i<byt_cnt;i++) {
        val = val + ptr[i];
    }
    ptr[byt_cnt] = 0xff - val;
}

/****************************************************************

    ret_sts=partitions();

        int ret_sts;        : = ESC      ; ESC key pressed
                              = CTRL-C   ; CTRL-C key pressed
                              = -1       ; error return
                              = 1        ; normal return
                              
****************************************************************/

partitions()

{
    int i,j,one2many,rem;
    char c, cc;
    unsigned char  *ptr22,ch;

	lseek(fddown,76L,0);    
    
    boot_hdr.boot_next=1;
    for (;(boot_hdr.boot_next != 0);) {
    
        i = read(fddown,omf_buf,20+delta.reserve[omf_typ]);
        if (i < 0) {
            file_fg=FERR_FILE_READ_ERROR;
            longjmp(fileblk,-1);
        }
        if (i != (20+delta.reserve[omf_typ])) {
            file_fg=FERR_INVALID_DOWNLOAD_FILE;
            longjmp(fileblk,-1);
        }
    
        boot_hdr.boot_abstxt=b4_to_ul(&omf_buf[0]);
        boot_hdr.boot_debtxt=b4_to_ul(&omf_buf[4]);
        boot_hdr.boot_last=b4_to_ul(&omf_buf[8]);
        boot_hdr.boot_next=b4_to_ul(&omf_buf[12]);

/*  MIN  16/05/1988  */

        if (boot_hdr.boot_abstxt==0)
            next_ip=0;
        else if (boot_hdr.boot_debtxt==0 || 
                 (boot_hdr.boot_debtxt < boot_hdr.boot_abstxt)) {
			next_ip=boot_hdr.boot_last-boot_hdr.boot_abstxt;
        }
        else next_ip=boot_hdr.boot_debtxt-boot_hdr.boot_abstxt;

		if (boot_hdr.boot_abstxt != 0) lseek(fddown,boot_hdr.boot_abstxt,0);  

/*  MIN  */

/************************/

        for (;(next_ip > 0);) {
            i = read(fddown,omf_buf,5+delta.ad_ln[omf_typ]);
            if (i < 0) {
                file_fg=FERR_FILE_READ_ERROR;
                longjmp(fileblk,-1);
            }
            if (i != (5+delta.ad_ln[omf_typ])) {
                file_fg=FERR_INVALID_DOWNLOAD_FILE;
                longjmp(fileblk,-1);
            }

            next_ip -= (ulong)(5+delta.ad_ln[omf_typ]);

            if (omf_typ == 0) {                    /*  OMF286  */
                len_86 = (ulong)b2_to_us(&omf_buf[3]);
    
                s0_addr = omf_buf[2];
                s0_addr = (s0_addr << 8) + omf_buf[1];
                s0_addr = (s0_addr << 8) + omf_buf[0];

                if (binary_down) {
                    intel_rec[0]=0;
                    if (mpu_typ==0) {
                    	intel_rec[1]=0x90 + 0x03;
                    	x_mem_cpy(&intel_rec[2],omf_buf,3);
                    	bin_eval_sum(&intel_rec[1],4);
                    }
                    else {
                    	intel_rec[1]=0x90 + 0x04;
                    	x_mem_cpy(&intel_rec[3],omf_buf,3);
						intel_rec[2]=0;
                    	bin_eval_sum(&intel_rec[1],5);
                    }

/*
intel_rec[0]=0;
intel_rec[1]=0x60 + 0x04;
x_mem_cpy(&intel_rec[3],omf_buf,3);
intel_rec[2]=0;
bin_eval_sum(&intel_rec[1],5);
*/
                }
            }                                         /*  OMF386  */
            else {
                len_86 = b4_to_ul(&omf_buf[4]);
            
                s0_addr = omf_buf[3];
                s0_addr = (s0_addr << 8) + omf_buf[2];
                s0_addr = (s0_addr << 8) + omf_buf[1];
                s0_addr = (s0_addr << 8) + omf_buf[0];

                if (binary_down) {
                    intel_rec[0]=0;
                    intel_rec[1]=0x90 + 0x04;
                    x_mem_cpy(&intel_rec[2],omf_buf,4);
                    bin_eval_sum(&intel_rec[1],5);

/*
intel_rec[0]=0;
intel_rec[1]=0x60 + 0x04;
x_mem_cpy(&intel_rec[2],omf_buf,4);
bin_eval_sum(&intel_rec[1],5);
*/
                }
            }   
            if (binary_down) {
                if ((c=chk_hlt()) == ESC) {
                    prn_ferr(14);
                    return(c);
                }
                if (dwn_rec() == -1) {
                    return(-1);
                }
            }

            rpt_flag=TRUE;     
            
            for (;;) {

			    ptr22 = &omf_buf[0];

                if (len_86 == 0) break;

                if (len_86>=(ulong)max_len)
                    len_rec_send =  (ulong)max_len;
                else len_rec_send = len_86;

                if (len_86 > (ulong)max_rd) {
                    i = read(fddown,omf_buf,max_rd);
                    if (i < 0) {
                        file_fg=FERR_FILE_READ_ERROR;
                        longjmp(fileblk,-1);
                    }
                    if (i != max_rd) {
                        file_fg=FERR_INVALID_DOWNLOAD_FILE;
                        longjmp(fileblk,-1);
                    }

                    next_ip -= max_rd;

                    j = max_rd / max_len;
                    rem = max_rd % max_len;
                    for (i=1; i <= j; i++) {
                        if(cvnt_omf286(ptr22) == -1) return(-1);
                        if ((c=chk_hlt()) == ESC) {
                            prn_ferr(14);
                            return(c);
                        }
                        ptr22 = ptr86;
                        j = dwn_rec();
                        if (j==-1) return(-1);
                        s0_addr += max_len;
                    }
                    if (rem != 0) {
                        len_rec_send = (ulong)rem;
                        if(cvnt_omf286(ptr22) == -1) return(-1);
                        if ((c=chk_hlt()) == ESC ) {
                            prn_ferr(14);
                            return(c);
                        }
                        ptr22 = ptr86;
                        j = dwn_rec();
                        if (j==-1) return(-1);
                        s0_addr += rem;
                    }
                    len_86 = len_86 - max_rd;
                }
                else {
                    i = read(fddown,omf_buf,len_86);
                    if (i < 0) {
                        file_fg=FERR_FILE_READ_ERROR;
                        longjmp(fileblk,-1);
                    }
                    if (i != len_86) {
                        file_fg=FERR_INVALID_DOWNLOAD_FILE;
                        longjmp(fileblk,-1);
                    }

                    next_ip -= len_86;
                    one2many = (len_86) / max_len;
                    rem = (len_86)%max_len;
                    len_86=0;
                    for (i=1; i<=one2many; i++) {
                        if(cvnt_omf286(ptr22) == -1) return(-1);
                        if ((c=chk_hlt()) == ESC) {
                            prn_ferr(14);
                            return(c);
                        }
                        ptr22 = ptr86;
                        j = dwn_rec();
                        if (j==-1) return(-1);
                    }
                    if (rem != 0) {
                        len_rec_send = rem;
                  		if(cvnt_omf286(ptr22) == -1) return(-1);
                        if ((c=chk_hlt()) == ESC ) {
                            prn_ferr(14);
                            return(c);
                        }
                        ptr22 = ptr86;
                        j = dwn_rec();
                        if (j==-1) return(-1);
                    }
                }
            }   /*  end for */
            rpt_flag=FALSE;
        }
        
/************************/

    	lseek(fddown,boot_hdr.boot_next,0);    

    }
    return (1);        
}


/******************************************************************

    ret_sts=omf286_down(ptr);

        char *ptr;          : pointer of file name

        int ret_sts;        : = ESC      ; ESC key pressed
                              = CTRL-C   ; CTRL-C key pressed
                              = -1       ; error return
                              = 1        ; normal return
                              
******************************************************************/
omf286_down(ptr)
    char *ptr;
{
    int i,j,one2many,rem;
    char c, cc;
    unsigned char  ch;
    close(fddown);                   /*   because of calling program   */
    fddown = UsdOpenFile((LPSTR)ptr,OF_READ);
    for (i=0;i<5;i++) DisplayCh(' ');
    max_len = bmax_224;
/*
    if ((c=verify_checksum())!=1) return (c);
*/
    lseek(fddown,0L,0);
    i = read(fddown,omf_buf,1);
    if (i < 0) {
        file_fg=FERR_FILE_READ_ERROR;
        longjmp(fileblk,-1);
    }
    if (i != 1) {
        file_fg=FERR_INVALID_DOWNLOAD_FILE;
        longjmp(fileblk,-1);
    }
    boot_hdr.boot_ftype=omf_buf[0];
    if ((c=boot_mod_header())!=1) return (c);
    if ((c=partitions())!=1) return (c);
    rpt_flag=FALSE;
    if (s0_down_flg) {
	    if (binary_down) {
	        intel_rec[0]=0;
	        intel_rec[1]=0x90;
	        us_to_b2(boot_hdr.boot_gdtl,&intel_rec[2]);
	        ul_to_b4(boot_hdr.boot_gdtb,&intel_rec[4]);
	        us_to_b2(boot_hdr.boot_idtl,&intel_rec[8]);
	        ul_to_b4(boot_hdr.boot_idtb,&intel_rec[10]);
	        us_to_b2(boot_hdr.boot_tss,&intel_rec[14]);
	        bin_eval_sum(&intel_rec[0],16);
	        Badr_len=14;
	    }
	    else {
	        intel_rec[0]='S';
	        intel_rec[1]='0';
	        intel_rec[2]=19;
	        us_to_b2(boot_hdr.boot_gdtl,&intel_rec[3]);
	        ul_to_b4(boot_hdr.boot_gdtb,&intel_rec[5]);
	        us_to_b2(boot_hdr.boot_idtl,&intel_rec[9]);
	        ul_to_b4(boot_hdr.boot_idtb,&intel_rec[11]);
	        us_to_b2(boot_hdr.boot_tss,&intel_rec[15]);
	        bin_eval_sum(&intel_rec[2],19);
	    }
/* ??? */
	    if ((c=chk_hlt())==ESC ) {
	        prn_ferr(14);
	        return(c);
	    }
	    i = dwn_rec();
	    if (i == -1) return(-1);
    }
/* ??? */
/* MIN
    if (binary_down) {
        intel_rec[0]=0;
        intel_rec[1]=0x10;
        intel_rec[2]=0xff - 0x10;
    }
    else {
        intel_rec[0]='S';
        intel_rec[1]='7';
        intel_rec[2]=5;
        for(i=0;i<4;i++) intel_rec[i+3]=0;
        bin_eval_sum(&intel_rec[2],5);
    }
    if ((c=chk_hlt())==ESC ) {
        prn_ferr(14);
        return(c);
    }
    i = dwn_rec();
    if (i == -1) return(-1);
MIN  */
	if(!binary_down) down_OK();
    return (0);
}

/*****************************************

    ret_sts=cvnt_omf286(ptr);

        uchar *ptr;

        int ret_sts;

    Description:

*****************************************/
cvnt_omf286(ptr)
  unsigned char *ptr;

{
  unsigned int i, j,chksum=0;

/**   Data Record   **/

    if (binary_down) {
        chksum = intel_rec[0] = len_rec_send;
        for (i=1; i<= intel_rec[0]; i++) {
            intel_rec[i] = *ptr++;
            chksum = chksum + intel_rec[i];
        }
        intel_rec[i] = 0xff - chksum;
        ptr86 = ptr;
    }    
    else {
        intel_rec[0] = 'S';
        intel_rec[1] = '3';
        intel_rec[2] = len_rec_send+5;      /*    record length   */
        for (i=3;i<=6;i++)
            intel_rec[i] = (s0_addr >> ((6-i)*8)) & 0xff;  /* offset */
        for (i=7; i<(intel_rec[2]+7-5); i++) intel_rec[i] = *ptr++;
        ptr86 = ptr;
        bin_eval_sum(&intel_rec[2],intel_rec[2]);
    }
    return(0);
}

