
/***************************************************************************
**
**    $Header:   D:/USD3V/LOG/SRC/PMODE.H__   1.2   12 Jun 1996 08:43:52   ZJRD  $
**
**    $Log:   D:/USD3V/LOG/SRC/PMODE.H__  $
** 
**    Rev 1.2   12 Jun 1996 08:43:52   ZJRD
** No change.
** 
**    Rev 1.1   24 May 1996 09:42:54   ZJRD
** No change.
** 
**    Rev 1.0   11 Dec 1995 13:51:58   ZJRD
** Initial revision.
** 
****************************************************************************/
/***************************************************************************
 *
 *  pmode.h -- Definitions and structures for protected mode
 *
 *
 *  $Revision:   1.2  $
 *  $Date:   12 Jun 1996 08:43:52  $
 *  $Logfile:   D:/USD3V/LOG/SRC/PMODE.H__  $
 *  $Log$
 *  
 *     Rev 1.13   16 Oct 1990 16:18:22   JAB
 *  Added a new field to the EXP header, 'last_sel_used'
 *
 *     Rev 1.12   13 Sep 1990 17:49:26   DAVE
 *  Added first_reloc_sel field to EXP_header structure for new .EXP format.
 *
 *
 *     Rev 1.11   26 Apr 1990 15:40:26   SEAN
 *  Defined gtdi_sel.
 *
 *     Rev 1.10   11 Apr 1990 14:06:54   JBW
 *  Added XDT, modernized EXTFREE.
 *
 *     Rev 1.9   23 Mar 1990 11:27:48   DAVE
 *  Added cv_info_offset field.  Offset to Codeview information in .EXP file.
 *
 *     Rev 1.8   16 Mar 1990 10:42:30   SEAN
 *  Embarassing fix to last fix.
 *
 *     Rev 1.7   16 Mar 1990 10:39:34   SEAN
 *  Added guard against repeated inclusion using #define PMODE_INCLUDED.
 *
 *     Rev 1.6   13 Mar 1990 17:55:22   CHAS
 *  Add 16 byte gap between next_header_pos and remainder
 *
 *     Rev 1.5   12 Mar 1990 13:42:34   MIKE
 *  Returned dos16.h to pathwise as required for VCS...
 *
 *     Rev 1.4   12 Mar 1990 13:39:20   MIKE
 *  Changed dos16.h to be "local".
 *
 *     Rev 1.3   02 Mar 1990 17:41:48   JBW
 *  Name changes:  EXP => Phar_Lap_EXP, EXP_ParmBlock => Phar_Lap_EXP_ParmBlock.
 *  New structure/typedef:  EXP_header, is a complete definition of
 *  MAKEPM's .EXP header format.
 *
 *     Rev 1.2   02 Mar 1990 17:29:34   JBW
 *
 *     Rev 1.1   09 Oct 1989 13:31:26   JBW
 *  fixed nested include of DOS16.H to be <path-wise> instead of "local".
 *
 *     Rev 1.0   19 Sep 1989 09:26:00   ben
 *  Initial revision.
 *
 *
 *  Copyright (c) 1989 Rational Systems, Incorporated
 *  All Rights Reserved
 *
 */

#ifndef PMODE_INCLUDED
#define PMODE_INCLUDED
#include "dos16.h"

#undef FP_SEG
#undef FP_OFF
#define FP_SEG(p)    (*((unsigned short FarPtr) &(p) + 1))
#define FP_OFF(p)    (*(unsigned short FarPtr) &(p))

#define makeptr(s, o)  ( (void far *)((long)(s) << 16 | (unsigned)(o)) )

#define sel_mask 0xFFF8     /* descriptor table index */

#define carry_flag 1        /* cpu carry flag */

typedef struct xbrk_struct XBRK;
struct xbrk_struct
    {
    unsigned long min_xpara;    /* 0: start address of available */
    unsigned long max_xpara;    /* 4: max address of extended memory */
    union {                     /* 8: */
        unsigned w[2];
        XBRK far *p;
        } master_xbrk;          /* pointer to original xbrk struct */
    long xavail;                /* 12: paragraphs available in DOS/16M space */
    unsigned phyamt;            /* 16: physical amount of extm in K */
    unsigned pgtab;             /* 18: VCPI page table rm para */
    unsigned long max_linear;   /* 20: VCPI linear address high water mark */
    } ;

typedef struct              /* definition of Rational Systems .EXP file header */
    {
    /* formerly, following was referenced as EXE type */
    char marker[2];                 /* BW */
    unsigned last_page_bytes;
    unsigned pages_in_file;
    /* filesize = pages_in_file * 512 + last_page_bytes */
    int reserved1;
    int reserved2;
    unsigned min_alloc;             /* required memory, in KB */
    unsigned max_alloc;             /* max KB, implies private allocation */
    unsigned stack_seg;
    unsigned stack_ptr;
    unsigned first_reloc_sel;       /* Selector for start of huge relocation list. */
    unsigned init_ip;
    unsigned code_seg;
    unsigned runtime_gdt_size;      /* bytes */
    int MAKEPM_version;             /* version * 100, GLU = (version+10)*100 */
    /* end of EXE */
    long next_header_pos;           /* file position of next splice'd .EXP */
    long cv_info_offset;            /* Offset to start of Codeview info. */
    unsigned last_sel_used;         /* last selector value used */
    char reserved4[10];             /* reserved gap */
    /* formerly, following was referenced as gdtimage[0..1] */
    unsigned options;               /* switch_control options word */
    unsigned trans_stack_sel;       /* (obsolete) sel of transparent stack */
    unsigned exp_flags;             /* 0x0001: automatic selector assignment */
                                    /* 0x0002: this .EXP is a package */
    unsigned program_size;          /* (obsolete) size of program in para */
    unsigned gdtimage_size;         /* size of gdt in file (bytes) */
    unsigned first_selector;        /* gdt[first_sel] = gdtimage[0], 0 => 0x80 */
    char default_mem_strategy;
    char reserved5;
    unsigned transfer_buffer_size;  /* default in bytes, 0 => 8KB */
    /* formerly, the following was referenced as gdtimage[2..15] */
    char reserved6[48];
    char EXP_path[64];              /* 'pre-splice' .EXP file name */
    /* end of gdtimage[2..15] */
    /* gdtimage[16..gdtimage_size] follows immediately */
    /* program image follows gdtimage */
    } EXP_Header;

typedef struct
    {
    char marker[2];                 /* MZ */
    unsigned last_page_bytes;
    unsigned pages_in_file;
    /* filesize = pages_in_file*512+(last_page_bytes ? last_page_bytes-512 : 0)  */
    unsigned num_relocs;
    unsigned header_paras;
    unsigned min_alloc;
    unsigned max_alloc;
    unsigned stack_seg;
    unsigned stack_ptr;
    int checksum;
    unsigned init_ip;
    unsigned code_seg;
    unsigned reloc_offset;
    int overlay_number;
    } EXE;

typedef struct {
    char signature[2];              /* P2 or P3 */
    int level;
    unsigned HeaderBytes;
    long FileBytes;
    int checksum;
    long RunTimeParmBlock;
    long RunTimeParmBlockBytes;
    long RelocationTable;
    long RelocationTableBytes;
    long SegInfoTable;
    long SegInfoTableBytes;
    unsigned SITEntrySize;
    long ProgramLoadImage;
    long ProgramLoadImageBytes;
    long SymbolTable;
    long SymbolTableBytes;
    long ProgramGDT;
    long ProgramGDTBytes;
    long ProgramLDT;
    long ProgramLDTBytes;
    long ProgramIDT;
    long ProgramIDTBytes;
    long ProgramTSS;
    long ProgramTSSBytes;
    long MinExtraAlloc;
    long MaxExtraAlloc;
    long ProgramBaseOffset;
    long initialESP;
    unsigned initialSS;
    long initialEIP;
    unsigned initialCS;
    unsigned initialLDT;
    unsigned initialTSS;
    } Phar_Lap_EXP;

typedef struct {                /* for Phar Lap .EXP files */
    char signature[2];
    unsigned minreal, maxreal, minibuf, maxibuf, nistack;
    unsigned istksize;
    long realbreak;
    unsigned callbufs;
    } Phar_Lap_EXP_ParmBlock;

typedef struct
    {
    char int20[2];
    unsigned memtop;
    char rsvd1;
    char callDOS[5];
    INTVECT terminate;
    INTVECT CtrlC;
    INTVECT Critical;
    unsigned parent_psp;
    unsigned char unit_table[20];
    unsigned envseg;
    char far *saved_stack;
    int num_units;
    unsigned char far *unit_table_p;
    char rsvd4[24];
    char int21[2];
    char retf[1];
    char rsvd5[9];
    char fcb1[16];
    char fcb2[20];
    char command_line[128];
    } PSP;

typedef struct
    {
    unsigned ip, cs, flags;
    } IFRAME;

typedef struct
    {
    unsigned long addr;
    char name[33];      /* may be 0 to 32 chars, 0 terminated */
    } SYM;

typedef struct
    {
    unsigned offset;
    unsigned selector;
    } Fptr;

typedef struct {        /* extended memory free list structure */
    unsigned long free_next;        /* physical para addr */
    long free_size;                 /* paragraphs */
    char dos16m_id[8];
    } EXTFREE;

typedef struct {        /* easy-access descriptor table entry */
    unsigned long xdtaddr;
    unsigned xdtlimit;
    unsigned xdtlimit2;
    unsigned char xdtaccess;
    unsigned char xdtaccess2;
    } XDT;

typedef GDT far * GDTP;

#ifdef M_I86
/* intdos #define -- simulate return value of flags for Microsoft */
#define Intdos(inr, outr)  (intdos(inr, outr), *(int *)outr.x.cflag)
#define Intdosx(inr, outr, sr)  (intdosx(inr, outr, sr), *(int *)outr.x.cflag)
#else
#define Intdos intdos
#define Intdosx intdosx
#endif

typedef char far * GDTIP;

#endif
