
/***************************************************************************
**
**    $Header:   D:/USD3V/LOG/SRC/SWBKPT.C__   1.2   12 Jun 1996 08:43:56   ZJRD  $
**
**    $Log:   D:/USD3V/LOG/SRC/SWBKPT.C__  $
** 
**    Rev 1.2   12 Jun 1996 08:43:56   ZJRD
** No change.
** 
**    Rev 1.1   24 May 1996 09:42:48   ZJRD
** No change.
** 
**    Rev 1.0   11 Dec 1995 13:51:56   ZJRD
** Initial revision.
** 
****************************************************************************/
/*--------------------------------------------------------------------------*/
/*  swbkpt.c								    */
/*--------------------------------------------------------------------------*/


#include  "system.h"
#include  "usd3.h"
#include  "gblext.h"
#include  "oldext.h"
#include  "usym1.h"
#include  "usym3.h"
#include  "cpucode.h"
#include  "funcext.h"

char EV_BUF[20];
char PCstr[10];
unsigned char IRETD[]={0x66, 0xcf};
unsigned char tmpLOC[2];
unsigned char TrapCode3;
struct pcstatus mypc;
unsigned int tmpCS386;
int invalid;
int Pmode;
char REG_SS[]="SS";
char REG_SP[]="SP";
char REG_PS[]="PS";
char REG_PSW[]="PSW";
char REG_CP[]="CP";
char REG_IDT[]="IDT";

void SimIRET();
void SetReg();

breakpoint_cmd(addr, type, parameter)
unsigned long addr;
int type;
char *parameter;
{
int i, j, ii;
char *ptr, *ptr1;
unsigned long addr1;
unsigned long l, l1, l2;
unsigned long GetReg();

	invalid = 0;
	send_ESC();
	VPOut = COMVP;
	if (env.CpuCode == -1) {
		DisplayStr("\r\n S/W breakpoint not implemented yet!");
		return(TRUE);
	}
	if (type == -1) {
		if (noRAM) sprintf(EV_BUF,"\r\n S/W breakpoint toggle is OFF.\r\n");
		else {
			sprintf(EV_BUF,"\r\n S/W breakpoint toggle is ON.");
			DisplayStr(EV_BUF);
			if (env.MICEGroup == MICE3)
				sprintf(EV_BUF,"   EV%1d is reserved for USD-III.\r\n",HaveLAM2+5);
			else
				sprintf(EV_BUF,"   H3 is reserved for USD-III.\r\n");
		}
		DisplayStr(EV_BUF);
		if (!noRAM) {
		  if (env.CpuType != 4 && env.CpuType != 5) {
			sprintf(EV_BUF," The trap vector at location %X.", env.Toffset);
			DisplayStr(EV_BUF);
		  } 
          sprintf(EV_BUF,"   The handler routine at location %lX.\r\n", env.VectAdr);////bug 5031
		  DisplayStr(EV_BUF);
		}
		for (i=0;;i++) {
			if (chk_hlt() == ESC) {
				DisplayStr("\\");
				break;
			}
			if (!SwBreak[i].exists) break;
			sprintf(EV_BUF," %3d. ", i+1);
			DisplayStr(EV_BUF);
			if (env.CpuType != 2 && env.CpuCode != MH8 && 
				env.CpuType != 3) 
				sprintf(EV_BUF,"%-8lX", SwBreak[i].address);
			else {
				ii = (SwBreak[i].address & 0xffff0000) >> 16;
				sprintf(EV_BUF,"%4X:%-8X", ii, SwBreak[i].address & 0xffff);
			}
			DisplayStr(EV_BUF);
			if (i & 1) sprintf(EV_BUF,"\r\n");else sprintf(EV_BUF,"          ");
			DisplayStr(EV_BUF);
		}
		return(TRUE);
	}
	if (noRAM) {
		DisplayStr("\r\n S/W breakpoint disable!");
		return(TRUE);
	}
	if (env.CpuType == 2 || (env.CpuType == 3 && !ChkMode())) {
		l1 = (addr >> 12) & 0xffff0;
		l2 = addr & 0xffff;
		if ((l1+l2) >= 0x100000) {
			return(prn_ferr(51));
		}  
	}
	if (env.CpuCode == M64180) {
		if (addr > 0xffff) return(prn_ferr(50));
	}
	if ((env.Maddrid < 3 && addr > 0xffff) || 
		((env.Maddrid == 3 || env.CpuCode == MH8) && addr > 0xffffff)) 
		return(prn_ferr(51));
	addr1 = addr;
	if (type == 2) {
		if (env.MICEGroup == MICE3 && env.CpuCode == M8086) {
		 	if (ChkNEC()) l = GetReg(REG_PS);
			else l = GetReg(REG_CS);
		} else if (env.CpuCode == MH8) l = GetReg(REG_CP);
		else if (env.CpuCode == MV25) {
			if (ChkV25()) l = GetReg(REG_PS);else l = GetReg(REG_CS);
		} else l = GetReg(REG_CS);
		if (ChkMode()) CS386 = l;
		if (env.CpuCode != M80386) addr1 = (l << 16) + (addr1 & 0xffff);
	}
	if (BreakNumber && ChkMode() && tmpCS386 != CS386) {
		DisplayStr("\r\n All S/W breakpoint must be set in the same selector!");
		CS386 = tmpCS386;
		return(TRUE);
	}
	for (i=0;i<256;i++) {
		if (!SwBreak[i].exists) break;
		if (SwBreak[i].address == addr1) {
			DisplayStr("\r\n S/W breakpoint already be set!");
			return(TRUE);
		}
	}
	if (i == 256) {
		DisplayStr("\r\n No more breakpoint can be set!");
		return(TRUE);
	}
	GetBrkMem(addr1, &SwBreak[i].data1, type);
	/* No more RAM TEST, because MICE do something in SIZE problem */ 
	/* 
	if (MemTest(addr1, addr1+1)) {
		DisplayStr("\r\n S/W breakpoint cannot be set on ROM location!");
		 return(TRUE);
	}
	SetBrkMem(addr1, &SwBreak[i].data1, SwBreak[i].data3);
	*/
	if (invalid && ChkMode()) {
		DisplayStr("\r\n Invalid selector!");
		return(TRUE);
	}
	SwBreak[i].exists=1;
	SwBreak[i].cs386p = tmpCS386 = CS386;
	SwBreak[i].address = addr1;
	SwBreak[i+1].exists=0;
	ptr = parameter;
	ptr1 = SwBreak[i].sym;
	for (j=0;j < 40;j++) {
		*ptr1++ = *ptr++;
		if (!*ptr) break;
	}
	*ptr1 = '\0';
	BreakNumber++;
	adr2str(addr1,PCstr);
	MarkBKPTinCodeVP(PCstr, '*');
	MarkPC(CurrentPC);
	return(TRUE);
}

int allGetPC = 0;
go_cmd(run)
int run;
{
int i, c, d;
unsigned char *ptr,*ptr1;
int break_id, tick_temp;
char tx_buf[240];
unsigned long adr2hex(), myGetPC(), getRetPC();
unsigned long l, l2;

	break_id = 0;
	tick_temp = tick_count;
	send_ESC(); /* terminate the current command input */
	VPOut = COMVP;
	DisplayStr("\n\r");
	allGetPC = 1;
	if (!run && !noRAM && BreakNumber) {
//		if (!(Pmode=ChkMode())) init_sw();
		init_sw();
		if (!noRAM) set_EV5();
		if (env.MICEGroup == MICE3) for1step();
		else {
			l = myGetPC();
			for1step();
			if (env.CpuType == 5) {
				l2 = myGetPC();
				while (l2 < l+3) {
					for1step();
					l2 = myGetPC();
				}
			}
		}
		sw_set();
	}
	ptr = tx_buf;
	c = SEND_str(CmdSendBuf);
	if (env.MICEGroup != MICE2) *ptr++ = c;
//_settextposition(1,1);printf("c=%X [%c]",c,c);ki();
	for (;;) {
		if (chk_hlt() == ESC) {
			send(ESC);
			while((d=receive()) != HAND_SHAKE) *ptr++ = d;
			if (!run && !noRAM && BreakNumber) sw_restore();
			break;
		}
		if((c=upRX_DATA()) >= 0) {
			if (c == HAND_SHAKE) {
				if (env.MICEGroup == MICE2) {
					*ptr = 0;
					if (strstr(tx_buf, "AT") != NULL) {
						if (!noRAM && BreakNumber) sw_restore();
						break;
					}
					else if ((ptr1=strchr(tx_buf,'>')))
						*ptr1 = 0x0;
//					if (!BreakNumber) break;else continue;
					continue;
				}
				else if (env.CpuCode == MZ80) continue;
				else break;
			}
			if (env.MICEGroup == MICE3 && c == CR) {
				*ptr++ = CR;
				*ptr = 0;
				DisplayStr(tx_buf);
				ptr = tx_buf;
				continue;
			}
			if (c) *ptr++ = c;
			if (env.MICEGroup == MICE3) {
				if (c == 'V' || c == 'v') {
					if (env.CpuCode == MZ80) { 
						for (i=0;i < 4;i++) {
							c=receive();
							*ptr++ = c;
						}
					}
					c=receive();
					*ptr++ = c;
					if (c < '1' || c > '9') continue;
					c -= '0';
					break_id=c;
					while ((d=receive()) !=HAND_SHAKE) {
						*ptr++ = d;
						if (d == 'V' || d == 'v') {
							c=receive();
							*ptr++ = c;
							if (c < '1' || c > '9') continue;
							c -= '0';
							break_id=c;
						}
					}
					if (env.CpuCode == MZ80) {
						while (1) {
							if ((d=receive_3()) == -1) break; 
							*ptr++ = d;
							while ((d=receive()) != HAND_SHAKE) *ptr++ = d;
						}
					}
					if (!run && !noRAM && BreakNumber) sw_restore();
					if (c == HaveLAM2+5 && !noRAM && BreakNumber) {
						if (env.CpuCode == MZ80) SetPC(env.VectAdr+2);
						else if (env.CpuCode == MV25) SimIRET(); 
						else if (env.CpuType == 3 && ChkMode()) {
							l = GetReg(REG_CS);
							l = (l << 16) + env.VectAdr;
							GetBrkMem(l, &tmpLOC[0], 3);
							if (env.CpuCode == M80386) 
								SetBrkMem(l,&IRETD[0], 0);
							else
								SetBrkMem(l,&env.IRET[0], 0);
							for1step();
							SetBrkMem(l,&tmpLOC[0], 0);
						} else { 
							if (INTstatus()) {
								if (env.MICEGroup == MICE3) send_str("CON I D");
								else send_str("D I");
								for1step();
								if (env.MICEGroup == MICE3) send_str("CON I E");
								else send_str("E I");
							} else for1step();
						}
						if (env.CpuType == 2 || env.CpuType == 3 ||
							env.CpuType == 4 || env.CpuType == 8 ||
							env.CpuCode == MH8)  
						{
						  if (env.CpuCode != MV25) {
							if (env.CpuCode == M64180) l = myGetPC();
							else {
								GetPC(&mypc);
								l = adr2hex(mypc.addr);
							}
							if (env.CpuCode == MH8) 
								SetPC(l-2);
							else SetPC(l-1);
						  }
						}
					} else Pmode = 0;
					break;
				}
			} else {   // env.MICEGroup != MICE3
				if (c == '-') {
					c=receive();
					*ptr++ = c;
					c -= '0';
					break_id=c;
					while((d=receive()) != HAND_SHAKE) *ptr++ = d;
					if (!run && !noRAM && BreakNumber) sw_restore();
					if (c == 3 && !noRAM && BreakNumber) {
						if (env.CpuCode == M8085 || env.CpuCode == M6502) 
							SetPC(env.VectAdr+3);
						else SetPC(env.VectAdr+2);
						for1step();
						if (env.CpuType == 2 || env.CpuType == 4 ||
							env.CpuType == 5 || env.CpuType == 6 ||
							env.CpuType == 7) {
							GetPC(&mypc);
							l = adr2hex(mypc.addr);
							if (env.CpuCode == M8051) SetPC(l-3);
							else if (env.CpuCode == M68HC11 || 
								env.CpuCode == M6502 || env.CpuCode == M8048) 
								SetPC(l-2);
							else SetPC(l-1);
						}
					}
					break;
				}
				if (c == '!') {
					while((d=receive()) != HAND_SHAKE) *ptr++ = d;
					break;
				}
				if (c == '>')  ptr--;
			}
		} else {  // c < 0
 			if (env.MICEGroup == MICE3) {
 				*ptr = 0;
				DisplayStr(tx_buf);
				ptr = tx_buf;
			}
			if (cmdfile_flag) {
				if (tick_temp) {
					tick_delay(1);
					tick_temp--;
				}
				if (tick_temp) continue;
				else {
					send(ESC);
					while((d=receive()) != HAND_SHAKE) *ptr++ = d;
					if (!run && !noRAM && BreakNumber) sw_restore();
					break;
				}
			}
		}
	}   // end of forever for loop
//_settextposition(5,1);printf("get out of the forever loop");
	if (!noRAM && BreakNumber && 
			((env.MICEGroup == MICE3 && break_id == HaveLAM2+5) ||
			(env.MICEGroup == MICE2 && break_id == 3))) { 
		if (env.CpuCode == M64180) {
			l = myGetPC();
			sprintf(EV_BUF,"%lX", l);
		} else {
			GetPC(&mypc);
			sprintf(EV_BUF,"%s",mypc.ascii);
			l = adr2hex(mypc.addr);
		}
		i = ChkBreak(l);
		if (i != -1) DisplayStr("\r S/W breakpoint matched, program broke at ");
		else DisplayStr("\r Program broke at unexpected location, PC=");
		DisplayStr(EV_BUF);
	} else {
		*ptr = 0;
//_settextposition(6,1);printf("no swbkpt set: tx_buf=[%s]",tx_buf);
		DisplayStr(tx_buf); 
	}
	allGetPC = 0;
	tick_count = 0xffff; //reset tick_count as default value
	return(TRUE);
}

void SimIRET() {
unsigned long spPtr, retPC, retSR, getWordFromStack();
   spPtr = GetReg(REG_SS);
   spPtr = (spPtr << 16) + GetReg(REG_SP);
   retPC = getWordFromStack(spPtr+2);
   retPC = (retPC << 16) + getWordFromStack(spPtr);
   retSR = getWordFromStack(spPtr+4);
   SetReg(REG_SS, (int) (spPtr&0xFFFF0000L) >> 16);
   SetReg(REG_SP, (int) (spPtr+6)&0xFFFFL);
   SetReg(REG_PSW, (int) retSR);
   SetPC(retPC-1);
}

unsigned long getWordFromStack(addr)
unsigned long addr;
{
unsigned long rx_long();
unsigned long l;

	send('W');
	send(' ');
	send_csip(addr);
	send_CR_wait(CR);
	l=rx_long();
	send_ESC();
	return (l);
}

clear_cmd(id, count)
unsigned int id;
unsigned int count;
{
	send_ESC();
	if (!count) {
		id=1;
		count=BreakNumber; /* if count=0 then clear all */
	}
	if (BreakNumber < (id+count-1)) count = BreakNumber-id+1;
	if (count == 1) ClrBrk(id-1);
	else ClrBrkRange(id-1, count);
	return(TRUE);
}

ClrBrkRange(id, count)
int id, count;
{
int i;
	if (!SwBreak[id].exists) {
		return;
	}
	for (i=id;i<id+count;i++) {
		adr2str(SwBreak[i].address,PCstr);
		MarkBKPTinCodeVP(PCstr, ' ');
		MarkPC(CurrentPC);
	}
	for (i=id; i < 256; i++) {
		if (!SwBreak[i+count].exists) break;
		memcpy(&SwBreak[i],&SwBreak[i+count],sizeof(struct SwData));
	}
	if (count >= BreakNumber) BreakNumber = 0;
	else BreakNumber -= count;
	SwBreak[BreakNumber].exists = 0;
}

ClrBrk(id)
unsigned int id;
{
int i;
	if (!SwBreak[id].exists) {
		return;
	}
	adr2str(SwBreak[id].address,PCstr);
	MarkBKPTinCodeVP(PCstr, ' ');
	MarkPC(CurrentPC);
	for (i=id; i < 256; i++) {
		if (!SwBreak[i+1].exists) break;
		memcpy(&SwBreak[i],&SwBreak[i+1],sizeof(struct SwData));
	}
	SwBreak[i].exists = 0;
	BreakNumber--;
}

init_sw()
{
unsigned long GetReg();
unsigned long l, l1;
int Len, i;
static int  first_time_init_sw = TRUE;

	if (env.CpuCode == -1) {
		noRAM = 1;
		return;
	} 
 i = 1;

 if ( first_time_init_sw ) {

   first_time_init_sw = FALSE;

   if ( ! AbortTarget ) {

      do_1_cmd_save( "", MICEBuf, ( MICEBUFSIZE + 1 ) );
      Len = strlen( MICEBuf );

      if (  ( Len >= 4 ) && ( strcmpi( &( MICEBuf[Len-4] ), "RUN>" ) == 0 ) )
         i = 0;
   }
 }

 	if (!VNFlag && i) { 
		if (env.CpuType == 4) {
			env.TrapCode[0] = 0xc7+ env.VectAdr;
		}
		if (env.CpuType != 5 && env.CpuType != 4) {
                        if (env.CpuType == 1)  l  = GetReg(REG_VBR)+env.Toffset;
                        else  l  = env.Toffset;
			if (!noRAM) SetVect(env.VectAdr);
			if (env.CpuCode == M68HC11 || env.CpuCode == M6502)
                                SetVectMem( l ,&env.newVect[0],2);
            //06/28/95, Frank, Add"else":
            else if (env.CpuCode == MH8) {
                                SetVectMem( l , &env.newVect[2], 2);
                                 l  = 0x7c;
                                SetVectMem( l , &env.newVect[0], 4);
			}
			else if (env.CpuType == 3) {
				l1 = GetReg(REG_IDT); /* set IDT table for INT 3 */
				if (ChkMode()) {
                                         l  = l1+0x18;
//					l1 = GetReg(REG_CS); /* set IDT table for INT 3 */
					l1 = CS386; /* set IDT table for INT 3 */
					/* set selector:offset */
					send_str2("WO P ");
                                        send_286long( l );
					send(' ');
					env.VectAdr = 0x20;
					send_word(env.VectAdr);
					send(' ');
					send_word(l1);
			/* set P(segment present) = 1, DPL(descriptor privilege level) = 3 */
			/* TYPE as interrupt gate */
					if (env.CpuCode == M80386) send_str2(" EE00 0");
					else send_str2(" E600");
					send_CR_wait(HAND_SHAKE);
					noRAM = 0;
				} else {
                                         l  += l1;
                                        SetVectMem( l ,&env.newVect[0],4);
				}
			} else
                                SetVectMem( l ,&env.newVect[0],4);   ////by chris: l is a cliff value
		} else {
			if (env.CpuCode == M8051) TrapCode3 = env.IRET[1];
			SetVect(env.VectAdr);
		}
	} else noRAM = 1;
}

NewVectAdr()
{
int i, ii, j;
unsigned char see1,see2;////by chris;
	switch(env.CpuType) {
	case 0:
	case 1:
	case 8:
		for (i=3, ii=0;i >= 0;i--, ii++) {
			j = (env.VectAdr >> i*8) & 0xff;
			env.newVect[ii] = j;
		}
		break;
	case 2:
	case 3:
		for (i=0;i<4;i++) {
			j = (env.VectAdr >> i*8) & 0xff;
			env.newVect[i] = j;
		}
		break;
	case 5:
		if (env.CpuCode == M8051) {
			env.IRET[1] = (unsigned char) env.VectAdr & 0xff;
			env.TrapCode[1] = (unsigned char) (env.VectAdr >> 8) & 0xff;
		}
		if (env.CpuCode == M8048) {
			env.JmpHere[1]=env.TrapCode[1]=(unsigned char)env.VectAdr & 0xff;
			env.VectAdr &= 0x7ff;
			i = (env.VectAdr & 0x700) >> 3;
			env.JmpHere[0] |= i;
			env.TrapCode[0] |= i;
		}
		break;
	case 6:
		env.newVect[1] = (unsigned char)env.VectAdr & 0xff;
		env.newVect[0] = (unsigned char)env.VectAdr >> 8 & 0xff;
		break;
	case 7:
        see1=env.newVect[0] = env.JmpHere[1] = (unsigned char)env.VectAdr & 0xff;
        see2=env.newVect[1] = env.IRET[0] = (unsigned char)(env.VectAdr >> 8 & 0xff);////add by chris,8/1/95
        break;
	}
}

set_EV5()
{
unsigned long l;
unsigned long GetReg();
	if (env.CpuType == 3) Pmode = ChkMode();
	if (env.MICEGroup == MICE3 && env.CpuCode == M68010) l = GetReg(REG_VBR);
	if (env.MICEGroup == MICE3) event_cmd[2]='5'+HaveLAM2;
	else {
		event_cmd[0]='H';
		event_cmd[2]='3';
	}
	send_str2(event_cmd);
	send(' ');
	if (env.CpuCode == M68030) {
		send_str2("P ");
	}
	if (Pmode) {
		send_word(CS386);
		send(':');
	}
	if (env.CpuType == 2 || (env.CpuType == 3 && !Pmode) || env.CpuCode == MH8) 
		send_csip(env.VectAdr);
	else send_long(env.VectAdr);
	if (env.MICEGroup == MICE3 && 
		(env.CpuCode == M68000 || env.CpuCode == M68010))
		send_str2(SP_opt);
	if (env.MICEGroup == MICE3 && env.CpuCode == M68010) {
		send_str2(VB_opt);
		send_long(l);
	}
	send_CR_wait(HAND_SHAKE);
}

clear_EV5()
{
	if (env.MICEGroup == MICE3) {
		if (HaveLAM2) do_1_cmd_no_save("EV 7 CL");
		else do_1_cmd_no_save("EV 5 CL");
	}
	else do_1_cmd_no_save("H03");
}

SetVect(addr)
unsigned long addr;
{
	if (env.MICEGroup == MICE2 || env.CpuCode == MZ80) {
        SetVectMem(addr, env.JmpHere, 2);
        SetVectMem(addr+2, env.IRET, 2);
	} else if (env.CpuType != 3 || !ChkMode())
		SetVectMem(addr, env.IRET, 2);
}

SetVectMem(addr, buffer, i)
unsigned long addr;
unsigned char *buffer;
int i;
{
int j;
char c;
	if (env.MICEGroup == MICE2) {
		if (MemTest(addr, addr+i-1)) {
			noRAM=1;
			return(1);
		}
 		send('M');
	} else {
		if (env.CpuCode == MZ80) send_str2("MO");
		else send('B');
	}
	send(' ');
	if (env.CpuCode == M64180 || env.CpuCode == M68030) {
		send('P');
		send(' ');
	}
	if (env.MICEGroup == MICE3 && (env.CpuType == 1 || !env.CpuType)) 
		send_str2(SD_opt);
	if (env.CpuType == 2 || env.CpuCode == MH8) send_csip(addr);
	else {
		if (env.CpuType == 3) send_str2("P ");
		send_long(addr);
	}
	if (env.MICEGroup == MICE2 || env.CpuCode == MZ80) {
		send_CR_wait(HAND_SHAKE);
		if (env.CpuCode == M68000 || env.CpuCode == M68010) {
			for (j=0;j < i;j += 2) {
				send_byte(*buffer++);
				send_byte(*buffer++);
				send_CR_wait(HAND_SHAKE);
			}
		} else {
			for (j=0;j < i;j ++) {
				send_byte(*buffer++);
				send_CR_wait(HAND_SHAKE);
			}
		}
		send_ESC();
		noRAM=0;
		return;
	} else {
		for (j=0;j < i;j ++) {
			send(' ');
			send_byte(*buffer++);
		}
		send(CR);
		for (;;) {
			c=receive();
			if (c == '!' || c == '-') {
				while (receive() != HAND_SHAKE);
				noRAM=1;
				return;
			}
			if (c == HAND_SHAKE) {
				noRAM=0;
				return;
			}
		}
	}
}

GetBrkMem  (addr, buffer, type)
unsigned long addr;
unsigned char *buffer;
int type;
{
unsigned char c;
unsigned long rx_long();
unsigned long l;

	if (env.MICEGroup == MICE3) {
		if (env.CpuCode == MZ80) send_str2("MO");
		else send('B'); 
	} else send('M');
	send(' ');
	switch (type) {
	case 1: 
	case 2:
			send_csip(addr);
			break;
	case 3: 
	case 4:
			send_word(CS386);
			send(':');
			send_long(addr);
			break;
	default:
			send_long(addr);

	}
	send_CR_wait(CR);
	l=rx_long();
	if (env.MICEGroup == MICE2 && 
			(env.CpuCode == M68000 || env.CpuCode == M68010)) {
		c= (l >> 8) & 0xff;
		*buffer++=c;
		c= l & 0xff;
		*buffer++=c;
	} else {
		*buffer++ = l & 0xff;
		send(CR);
		*buffer++ = rx_long() & 0xff;
	}
	if (env.CpuCode == M8051) {
		send(CR);
		*buffer++ = rx_long() & 0xff;
	}
	send_ESC();
}

SetBrkMem(addr,buffer,d2)
unsigned long addr;
unsigned char *buffer;
unsigned char d2;
{
int i;
	if (env.CpuType == 3) Pmode = ChkMode();
	if (env.MICEGroup == MICE3) {
		if (env.CpuCode == MZ80) send_str2("MO");
		else send('B'); 
	} else send('M');
	send(' ');
	if (Pmode) {
		send_word(CS386);
		send(':');
		send_long(addr);
	} else if (env.CpuType == 2 || env.CpuCode == MH8 || env.CpuType == 3) 
		send_csip(addr); 
	else send_long(addr);
	send_CR_wait(HAND_SHAKE);
	if ((env.MICEGroup == MICE2) && 
		(env.CpuCode == M68000 || env.CpuCode == M68010)) {
		send_byte(*buffer++);
		send_byte(*buffer++);
		send_CR_wait(HAND_SHAKE);
	} else {
		send_byte(*buffer++);
		send_CR_wait(HAND_SHAKE);
		if (env.CpuType != 2 && env.CpuType != 3 && env.CpuType != 4) {
			send_byte(*buffer++);
			send_CR_wait(HAND_SHAKE);
			if (env.CpuCode == M8051) {
				send_byte(d2);
				send_CR_wait(HAND_SHAKE);
			}
		}
	}
	send_ESC();
}

sw_set()
{
int i;

	for (i=0;i<256;i++) {
		if (SwBreak[i].exists)
			SetBrkMem(SwBreak[i].address,&env.TrapCode[0], TrapCode3);
		else break;
	}
}

sw_restore()
{
int i;
	for (i=0;i<256;i++) {
		if (SwBreak[i].exists)
			SetBrkMem(SwBreak[i].address, &SwBreak[i].data1,
				SwBreak[i].data3);
		else break;
	}
}

send_CR_wait(c)
int c;
{
int d;
	send(CR);
	while((d=receive()) != c);
}

MemTest(l1,l2)
unsigned long l1, l2;
{
unsigned char c, cc, *ptr;
	ptr = MICEBuf;
	send('T');
	if (env.MICEGroup == MICE3) send('E');
	send(' ');
	if (env.CpuType == 2 || env.CpuType == 3) send_csip(l1);
	else send_long(l1);
	send(' ');
	send_long(l2);
	if (env.MICEGroup == MICE2) {
		send(' ');
		send('M');
	}
	send(CR);
	cc=0;
	while ((c=receive()) != HAND_SHAKE) if (c) *ptr++ = c;
	*ptr = 0;
	if ( strstr( MICEBuf,"at" ) != NULL ) cc = 1;
	else if ( strstr( MICEBuf,"ERROR" ) != NULL ) cc = 1;
	return(cc);
}

for1step()
{
	send('S');
	send_CR_wait(HAND_SHAKE);
	if (env.CpuType != 5 && env.CpuCode != MM6809 && env.CpuCode != M68HC11)
		send_CR_wait(HAND_SHAKE);
	send_ESC();
}

adr2str(addr, buf)
unsigned long addr;
char *buf;
{
char c;
int i, j;
	i = 3;
	if (env.CpuCode == M68008)
		i = 4;
	else if (env.CpuCode == M8048) i = 2;
	else if (env.CpuCode == M68000 || env.CpuCode == M68010 ||
		env.CpuCode == MH8) i = 5;
	else if (env.CpuCode == MM68020 || env.CpuCode == M68030 ||
		     env.CpuCode == M68030) i = 7;
	else if (env.CpuType == 2 || env.CpuType == 3) i = 7;
	for (; i >= 0; i--) {
		c=(addr>>i*4)&0xf;
		*buf++=hex[c];
		if (i == 4) {
			if (env.CpuCode == M80386) {
				*buf++=':';
				for (j=0;j<4;j++) *buf++='0';
			} else if (env.CpuType == 2 || env.CpuCode == MH8
						|| env.CpuType == 3) *buf++=':';
		}
	}
}

unsigned long adr2hex(buf)
unsigned char *buf;
{
int i, j;
unsigned char ii;
unsigned long l;
	l = 0;
	i = 2;
//	tmpCS386 = 0;
	if (env.CpuCode == M80386) {
		for (j=0; j < 2;j++) {
			ii = *buf++;
			tmpCS386 = (tmpCS386 << 8) + ii;
		}
	}
	if (!env.CpuType || env.CpuCode == M64180 || env.CpuCode == MH8) i = 3;
	if (env.CpuType == 1) {
		if (env.CpuCode == MM68020 || env.CpuCode == M68030) i = 4;
		else i = 3;
	} else if (env.CpuType == 2 || env.CpuType == 3) i = 4;
	for (j=0; j < i;j++) {
		ii = *buf++;
		l = (l << 8) + ii;
	}
	return(l);
}

send_long(addr)
unsigned long addr;
{
char c;
int i;
	if (env.CpuCode == M68008) i = 4;
	else if (env.CpuCode == M68000 || env.CpuCode == M68010) i = 5;
	else if (env.CpuCode == MM68020 || env.CpuCode == M68030 ||
			 env.CpuCode == M80386) i = 7;
	else if (env.CpuCode == M8048) i = 2;
	else i = 3;
	for (; i >= 0; i--) {
		c=(addr>>i*4)&0xf;
		send(hex[c]);
	}
}

send_csip(addr)
unsigned long addr;
{
	send_word(addr >> 16);
	send(':');
	send_long(addr & 0xffff);
}

send_286long(addr)
unsigned long addr;
{
char c;
int i;
	for (i=5; i >= 0; i--) {
		c=(addr>>i*4)&0xf;
		send(hex[c]);
	}
}

send_word(addr)
unsigned int addr;
{
char c;
int i;
	for (i=3; i >= 0; i--) {
		c=(addr>>i*4)&0xf;
		send(hex[c]);
	}
}

send_byte(d)
unsigned char d;
{
char c;
		c=(d>>4)&0xf;
		send(hex[c]);
		c=d&0xf;
		send(hex[c]);
}

unsigned long rx_long()
{
int c, i, j;
unsigned long l;
	l=0;
	i = 1;
	if (env.CpuCode == M80386) while (receive() != ':');
	if (env.MICEGroup == MICE2) i = 2;
	if (env.CpuCode == M64180) i = 3;
	for (j=0; j < i; j++) {
		while ((c=receive()) != ' ') {
			if (c == HAND_SHAKE) return(0xff);
		}
	}
	for (;;) {
		c=receive();
		if (c == 'v') invalid = 1;
		if (c == HAND_SHAKE) break;
		if (isxdigit(c)) {
			c=asc__h(c);
			l = (l<<4) + c;
		}
	}
	return(l);
}

SetPC(pc)
unsigned long pc;
{
	send('J');
	send(' ');
	if (env.CpuType == 3 && Pmode) { 
		send_long(pc);
	} else if (env.CpuType == 2 || env.CpuCode == MH8) send_csip(pc); 
	else send_long(pc);
	send(CR);
	while(receive() != HAND_SHAKE);
}

unsigned long GetReg(str)
char *str;
{
char *ptr, c;
unsigned long l;
unsigned long rx_4B();
	ptr = str;
	send('R');
	send(' ');
	while (c = *ptr++) send(c);
	send_CR_wait(CR);
	while ((c=receive()) != ' ');
	l = rx_4B();
	send_ESC();
	return(l);
}

void SetReg(str, data)
char *str;
int data;
{
char *ptr, c;
unsigned long l;
unsigned long rx_4B();
	ptr = str;
	send('R');
	send(' ');
	while (c = *ptr++) send(c);
	send_CR_wait(HAND_SHAKE);
	send_word(data);
	send_CR_wait(HAND_SHAKE);
	send_ESC();
}

ChkNEC()
{
int c, i;
	i = 1;
	send_str2("MO");
	send(CR);
	for (;;) {
		c=receive();
		if (c == '6') i=0;
		if (c == HAND_SHAKE) break;
	}
	return(i);
}

ChkV25()
{
int c, i;
	i = 1;
	send_str2("MO");
	send(CR);
	for (;;) {
		c=receive();
		if (c == 'I') i=0;
		if (c == HAND_SHAKE) break;
	}
	return(i);
}

send_str2(str)
char *str;
{
char c, *ptr;
	ptr=str;
	while (c = *ptr++) send(c);
}

ChkBreak(addr1)
unsigned long addr1;
{
int i, BP_id;
	BP_id = -1;
	for (i=0;i<256;i++) {
		if (!SwBreak[i].exists) break;
		if (SwBreak[i].address == addr1) {
			BP_id = i;
			break;
		}
	}
	return(BP_id);
}

unsigned long myGetPC ()
{
unsigned long l;

	GetPC(&mypc);
	l = adr2hex(mypc.addr);
	return(l);
}

unsigned long rx2_long()
{
int c, i, j;
unsigned long l;

	l=0;
	i = 3;
	for (j=0; j < i; j++) 
		while ((c=receive()) != ' ') 
			if (c == HAND_SHAKE) return(0xff);
	for (;;) {
		c=receive();
		if (c == ' ') break;
		if (isxdigit(c)) {
			c=asc__h(c);
			l = (l<<4) + c;
		}
	}
	while (receive() != HAND_SHAKE); 
	return(l);
}
