
/***************************************************************************
**
**    $Header:   D:/USD3V/LOG/SRC/UCO2.C__   1.2   12 Jun 1996 08:44:00   ZJRD  $
**
**    $Log:   D:/USD3V/LOG/SRC/UCO2.C__  $
** 
**    Rev 1.2   12 Jun 1996 08:44:00   ZJRD
** No change.
** 
**    Rev 1.1   24 May 1996 09:41:40   ZJRD
** No change.
** 
**    Rev 1.0   11 Dec 1995 13:51:30   ZJRD
** Initial revision.
** 
****************************************************************************/
/****************************************************************************

MICROTEK International Inc., Copyright reserved.

Product:      CONV3  --  USD-III
Module:       UCO2.C
Engineer:     Amy Wang
Description:  scanning OMF86, OMF85, OMF51

Record of Changes:
nnn: by who, MM/DD/YY, descriptions

001:
*****************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <malloc.h>
#include <conio.h>
#include <io.h>
#include <ctype.h>
#include <fcntl.h>
#include <string.h>
#include <search.h>
#include <errno.h>
#include "uco1.h"
#include "uco3.h"

/****************************************************************************/
/***** omf86()                                                           ****/
/****************************************************************************/

omf86()
{
        unsigned char addr[6];
        int i,j,k,br, wasSet=0;
        long lpos,blen;
        unsigned int bframe;
        unsigned long ultmp,dataloc=0;

        lseek(fdin,0L,0);
        do {
                if (kbhit()) getch();
                read(fdin,temp,3);
                len = (long)temp[2];
                len=(len<<8) + temp[1];
                switch(temp[0]) {              /* 1st byte of omf86 rec is the type */
                        case THEADR:
                                read(fdin,temp1,len);
                                if ( modsymcnt > 0)  {
                                   gblmod.mod_inx = ++modinx;
                                   ProcessModSym(fds2);
                                }
                                dataloc = 0;    bframe = 0;
                                ResetEnvironment();
                                i = temp1[0];
                                strncpy(gblmod.mod_name,&temp1[1],i);
                                gblmod.mod_name[i]='\0';
                                break;

                        case PUBDEF:
//                              if (inputFileInx == 0 ) {
                                   read (fdin,temp1,5);
                                   len -= 5;
                                   if ((len < (long)temp1[4]) || (temp1[0] ||
                                        temp1[1]))  {
                                      lseek(fdin,(long)len,1);
                                      break;
                                   }
                                   else {
                                      frame = (unsigned int) temp1[3];
                                      frame = (frame << 8) + temp1[2];
                                      cframe[0] = temp1[3];
                                      cframe[1] = temp1[2];
                                      len--;
                                      i=get_symbol((long)temp1[4],fds1); /*global symbol */
                                      gblsymcnt += i;
                                   }
//                              }
//                              else lseek(fdin,(long) len,1);
                                break;

                        case LOCSYM:
                                read(fdin,temp1,5);
                                if (temp1[0] || temp1[1])    {
                                        lseek(fdin,len-5,1);
                                        break;
                                }
                                frame = (unsigned int) temp1[3];
                                frame = (frame << 8) + temp1[2];
                                cframe[0] = temp1[3];
                                cframe[1] = temp1[2];
                                len -= 6;
                                if (len < (long)temp1[4]) break;
                                i=get_symbol((long)temp1[4],fds2);
                                modsymcnt += i;
                                break;

                        case DEBSYM:
                                read(fdin,temp1,6);
                                if (temp1[0] || temp1[1] || temp1[2])    {
                                        lseek(fdin,len-6,1);
                                        break;
                                }
                                frame = (unsigned int) temp1[4];
                                frame = (frame << 8) + temp1[3];
                                cframe[0] = temp1[4];
                                cframe[1] = temp1[3];
                                j = (int) temp1[5];
                                len -= 7;
                                if (len < (long)j) break;
                                i=get_symbol((long)j,fds2);
                                modsymcnt += i;
                                break;

                        case BLKDEF:
                                read(fdin,temp1,len);
                                if (temp1[0] || temp1[1]) break;
                                memset(tmpsym,NULL,symreclen);
                                tmpsym[0] = 0x0;
                                tmpsym[1] = temp1[4];
                                memcpy(&tmpsym[2],&temp1[5],(int)temp1[4]);
                                addr[0] = temp1[3];
                                addr[1] = temp1[2];
                                frame = (unsigned int)temp1[3];
                                frame = (frame << 8) + temp1[2];
                                bframe = frame;
                                ultmp = (unsigned long)frame;
                                i=4 + (int)temp1[4] + 1;
                                addr[2] = temp1[i+1];
                                addr[3] = temp1[i];
                                frame = (unsigned int)temp1[i+1];
                                frame = (frame << 8) + temp1[i];
                                ultmp = (ultmp << 16) + frame;
                                memcpy(&tmpsym[42],addr,AddrUnit);
                                write(fds2,tmpsym,symreclen);
                                modsymcnt++;
                                break;

                        case MODEND:
                                if ( modsymcnt > 0 ) {
                                   gblmod.mod_inx = ++modinx;
                                   ProcessModSym(fds2);
                                   dataloc = 0;    bframe = 0;
                                   ResetEnvironment();
                                }
/* now processing the global symbols */
                                if (inputFileInx== inputFileCnt-1)
                                   ProcessGblSym(fds1);
                                break;

                        case PIDATA:
                        case PEDATA:
                                if (dataloc == 0) dataloc = tell(fdin);
                                lseek(fdin,(long) len,1);
                                break;

                        default:
                                lseek(fdin,(long) len,1);
                } /* end switch */
        }   while (temp[0] != MODEND && temp[0] != ENDREC);

//      NormalExit();
        return;
}

/************************************************************************/
/*** get_symbol(slen,ffdd)                                           ****/
/************************************************************************/

get_symbol(slen,ffdd)
int ffdd;
long slen;
{
        int scnt,br,k;
        long i;
        unsigned int  ui;
        unsigned long ul;

        i = 0; scnt=0;
        do {
                memset(tmpsym,NULL,symreclen);
                i += (slen+4);
                do {
                        br=read(fdin,temp1,slen+4);
                } while (br == 0);
                tmpsym[0]=0x0;
                tmpsym[1]=(unsigned char)slen;
                memcpy(&tmpsym[2],temp1,slen);
                ul = (unsigned long) frame;
                ui = (unsigned int) temp1[slen+1];
                ui = (ui << 8) + temp1[slen];
                ul = (ul << 16) + ui;
                memcpy(&tmpsym[42],cframe,2);
                tmpsym[44] = temp1[slen+1];
                tmpsym[45] = temp1[slen];
                memcpy(srtbuf[srtinx++],tmpsym,symreclen);
                if (srtinx == mrgsymsz)  {
                        write(ffdd,srtbuf[0],symreclen*mrgsymsz);
                        memset(srtbuf[0],NULL,symreclen*mrgsymsz);
                        srtinx = 0;
                }

                br = (int)temp1[slen+2];
                if (br & 0x80)  {
                        read(fdin,temp1,1);
                        i++;
                        slen = (long)temp1[0];
                }
                else slen = (long)temp1[slen+3];
                scnt++;
        } while (i < len);
        k= symreclen * srtinx;
        br=write(ffdd,&srtbuf[0][0],k);
        memset(srtbuf[0],NULL,symreclen*srtinx);
        srtinx = 0;
        return(scnt);
}

/*=====================   OMF 51   ===========================================*/

#define       DATAREC       0x06
#define       FILEEND       0x04
#define       MODNAME       0x10
#define       SYMREC        0x12

struct sstack {
        int top;
        int item[20];
};
int blkinx=-1;

/*****************************************************************************/
/**** omf51()                                                            *****/
/*****************************************************************************/

omf51()
{
        unsigned int accmodlen=0,saveaddr=0xffff,slen,addr;
        int i;
        struct sstack blkstk;
        char *bblock[NO_BLOCK];

//      if (OpenTempFile(2) < 2) prn_exit("Error opening temp files!\r\n");
        lseek(fdin,0L,0);
        do {
                if (kbhit()) getch();
                read(fdin,temp,3);
                len = 0;
                memcpy(&len,&temp[1],2);
                switch (temp[0])  {
                        case OMF51_START:
                                lseek(fdin,len,1);
                                break;

                        case DATAREC:
                                lseek(fdin,len,1);
                                break;

                        case MODNAME:
                                read(fdin,temp1,2);
                                switch (temp1[0])  {
                                        case 0x00:   /* module start */
                                                modinx++;
                                                ResetEnvironment();
                                                blkinx=-1;    accmodlen = 0;    saveaddr = 0xffff;
                                                gblmod.mod_inx = modinx;
                                                memset(&blkstk,0xff,sizeof(blkstk));
                                                slen = (unsigned int)temp1[1];
                                                read(fdin,temp1,slen+1);
												if (slen >= 39) slen = 39;
                                                memcpy(gblmod.mod_name,temp1,slen);
                                                gblmod.mod_name[slen]='\0';
                                                break;
                                        case 0x02:   /* proc start */
                                                blkinx++;     blkcnt++;
                                                push(&blkstk,blkinx);
                                                slen = (unsigned int) temp1[1];
                                                read(fdin,temp1,slen+1);
                                                bblock[blkinx]=calloc(slen+1,sizeof(char));
                                                memset(bblock[blkinx],NULL,slen+1);
                                                memcpy(bblock[blkinx],temp1,slen);
                                                break;
                                        case 0x05:   /* proc end */
                                                if ((i=pop(&blkstk)) != -1)  free(bblock[i]);
                                                slen = (unsigned int) temp1[1];
                                                lseek(fdin,(long)slen+1,1);
                                                break;
                                        case 0x03:   /* module end */
                                                lseek(fdin,len-2,1);
                                                ProcessModSym(fds2);
                                                ResetEnvironment();
                                                break;
                                }  /* end switch temp1[0] */
                                break;

                        case SYMREC:
                                read(fdin,temp1,7);
                                switch (temp1[0])  {
                                        case 0x01:     /* global symbols */
                                                gblsymcnt += GetSymbol51(fds1);
                                                break;
                                        case 0x00:     /* module/local symbols */
                                                if (blkstk.top==-1 ||
                                                    blkstk.item[blkstk.top]==-1)
                                                        modsymcnt += GetSymbol51(fds2);
                                                else lseek(fdin,len-7,1);
                                                break;
                                        case 0x02:     /* segment symbols */
                                        case 0x03:     /* line number records */
                                                lseek(fdin,len-7,1);
                                                break;
                                }  /* end switch temp1[0]  */
                                break;

                        case FILEEND:
                                if (inputFileInx== inputFileCnt-1)
                                   ProcessGblSym(fds1);
                        default:
                                break;
                }   /* end switch */
        } while (temp[0] != FILEEND);
//      NormalExit();
        return;
}


/****************************************************************************/
/***** push()                                                            ****/
/****************************************************************************/

push(stk,ii)
struct sstack *stk;
int ii;
{
        (stk->top)++;
        if (stk->top >= 19) return(FAIL);
        stk->item[stk->top] = ii;
        return(OK);
}

/****************************************************************************/
/***** pop()                                                             ****/
/****************************************************************************/

pop(stk)
struct sstack *stk;
{
        int  ii;

        if (stk->top < 0) return(-1);
        ii = stk->item[stk->top];
        stk->item[stk->top] = 0x00;
        (stk->top)--;
        return(ii);
}

/****************************************************************************/
/***** GetSymbol51()                                                     ****/
/****************************************************************************/

GetSymbol51(ffdd)
int ffdd;
{
        long acclen=0;
        unsigned int addr,slen;
        int cnt=0,nameonly;

        len -= 7;
        addr = 0;
        memcpy(&addr,&temp1[3],2);
        slen = (unsigned int) temp1[6];
        memset(tmpsym,NULL,symreclen);
        tmpsym[42] = (unsigned char)(addr >> 8);
        tmpsym[43] = (unsigned char)addr;
        while (acclen < len-1)  {
                if (acclen+slen+6 >= len-1)  nameonly = 0;
                else nameonly = 6;
                acclen += read(fdin,temp1,slen+nameonly);
                tmpsym[1] = (unsigned char)(slen & 0xff);
                memcpy(&tmpsym[2],temp1,slen);
                memcpy(srtbuf[srtinx++],tmpsym,symreclen);
                cnt++;
                if (srtinx == mrgsymsz)  {
                        write(ffdd,srtbuf[0],symreclen*srtinx);
                        memset(srtbuf[0],NULL,symreclen*mrgsymsz);
                        srtinx = 0;
                }
                if (nameonly == 0) break;
                memset(tmpsym,NULL,symreclen);
                tmpsym[43] = temp1[slen+2];
                tmpsym[42] = temp1[slen+3];
                slen = (unsigned int)temp1[slen+5];
        }
        write(ffdd,srtbuf[0],symreclen*srtinx);
        memset(srtbuf[0],NULL,symreclen*mrgsymsz);
        srtinx = 0;
        lseek(fdin,1L,1);
        return(cnt);
}


/*============================== OMF85 ====================================*/

#define     HEADER     0x02
#define     CONTENT    0x06
#define     MODUEND    0x04
#define     ENDFILE    0x0e
#define     PUBSYM     0x16
#define     USERSYM    0x12
#define     MODNAME    0x10


omf85()
{
//      if (OpenTempFile(2) < 2) prn_exit("Error opening temp files!\r\n");
int slen;
        lseek(fdin,0L,0);
        do {
                if (kbhit()) getch();
                read(fdin,temp,3);
                len = 0;
                memcpy(&len,&temp[1],2);
                switch (temp[0])  {
                        case MODNAME:         /* 0x10 */
                                if (modsymcnt > 0 ) {
                                   gblmod.mod_inx = ++modinx;
                                   ProcessModSym(fds2);
                                }
                                ResetEnvironment();
                                read(fdin,temp1,len);
                                if (temp1[0] >= 39) slen = 39;
                                else slen = temp1[0];
								memcpy(gblmod.mod_name,&temp1[1],slen);
                                gblmod.mod_name[slen]='\0';
                                break;

                        case PUBSYM:          /* 0x16 */
                                gblsymcnt += GetSymbol85(fds1);
                                break;

                        case USERSYM:         /* 0x12 */
                                modsymcnt += GetSymbol85(fds2);
                                break;

                        case ENDFILE:         /* 0x0e */
                                lseek(fdin,len,1);
                                if ( modsymcnt > 0 ) {
                                   gblmod.mod_inx = ++modinx;
                                   ProcessModSym(fds2);
                                   ResetEnvironment();
                                }
                                if (inputFileInx== inputFileCnt-1)
                                   ProcessGblSym(fds1);
                                break;

                        case HEADER:          /* 0x02 */
                        case CONTENT:         /* 0x06 */
                        case MODUEND:         /* 0x04 */
                        default:
                                lseek(fdin,(long)len,1);
                                break;
                }  /* end switch */
        } while (temp[0] != ENDFILE);

//      NormalExit();
        return;

}


/****************************************************************************/
/***** GetSymbol85()                                                     ****/
/****************************************************************************/

GetSymbol85(ffdd)
int ffdd;
{
        long acclen=0;
        unsigned int slen;
        int cnt=0,nameonly;

        read(fdin,temp1,4);
        len -= 4;
        slen = (unsigned int) temp1[3];
        memset(tmpsym,NULL,symreclen);
        tmpsym[42] = temp1[2];
        tmpsym[43] = temp1[1];
        while (acclen < len-1)  {
                if (acclen+slen+4 >= len-1)  nameonly = 0;
                else nameonly = 4;
                acclen += read(fdin,temp1,slen+nameonly);
                tmpsym[1] = (unsigned char)(slen & 0xff);
                memcpy(&tmpsym[2],temp1,slen);
                memcpy(srtbuf[srtinx++],tmpsym,symreclen);
                cnt++;
                if (srtinx == mrgsymsz)  {
                        write(ffdd,srtbuf[0],symreclen*srtinx);
                        memset(srtbuf[0],NULL,symreclen*mrgsymsz);
                        srtinx = 0;
                }
                if (nameonly == 0) break;
                memset(tmpsym,NULL,symreclen);
                tmpsym[43] = temp1[slen+1];
                tmpsym[42] = temp1[slen+2];
                slen = (unsigned int)temp1[slen+3];
        }    /* end while */
        write(ffdd,srtbuf[0],symreclen*srtinx);
        memset(srtbuf[0],NULL,symreclen*mrgsymsz);
        srtinx = 0;
        lseek(fdin,2L,1);
        return(cnt);
}



