
/***************************************************************************
**
**    $Header:   D:/USD3V/LOG/SRC/USYM1.H__   1.2   12 Jun 1996 08:44:58   ZJRD  $
**
**    $Log:   D:/USD3V/LOG/SRC/USYM1.H__  $
** 
**    Rev 1.2   12 Jun 1996 08:44:58   ZJRD
** No change.
** 
**    Rev 1.1   24 May 1996 09:43:20   ZJRD
** No change.
** 
**    Rev 1.0   11 Dec 1995 13:52:10   ZJRD
** Initial revision.
** 
****************************************************************************/
/****************************************************************************/
/**** usym1.h : defining  all the constants and data structures for     *****/
/****            the symbol process                                     *****/
/****************************************************************************/

#define    MSK_ABS   0x00
#define    MSK_PHY   0x08
#define    MSK_MOD   0x02
#define    MSK_GBL   0x01
#define    MSK_UNK   0x00
#define    MSK_PCY   0x10
#define    MSK_PCN   0x00
#define    MSK_GRY   0x20
#define    MSK_GRN   0x00

#define     PLM_SOURCE	'0'
#define     C_SOURCE	'1'
#define     OTHERS	'2'
#define     MISS  0
#define     FOUND 1
#define     ABS   0
#define     PHY   1
#define     OK    0
#define     FAIL  -1
#define MAX(a,b)	((a) > (b) ? (a) : (b))
#define MIN(a,b)	((a) < (b) ? (a) : (b))
#define     symreclen   48
#define     NO_MODULE   500             
#define     INDEX_RANGE 100
#define     ADDON       300

struct  module {
		int           mod_inx;     /* the module index >= 0 */
		char          mod_name[40];
		int           mod_symno;   /* the number of module-wide symbol */
};

struct common_symbol {
	int                   modx;
	char                  mask;
	char                  name[41];
	unsigned char         addr[6];
	unsigned char         pc[6];
};

struct  two_int    {
	int   inx;
	int   cnt;
};

struct  two_long   {
	long  ll1;
	long  ll2;
};

struct addonitem {
	unsigned char addr[6];
	char    *name;
};

struct symindex  {
	long     fpos;
	int      cnt;
	char     name[40];
};

struct adrindex    {
	long             fpos;
	int              cnt;
	unsigned char    addr[6];
};

struct module_index {
	int	cnt;
	struct symindex *sxptr;
//	struct adrindex *axptr;
};

struct inxfpos {
	int    inx;
	long   fpos;
};

struct pcstatus {
	int  flag; 	     /*	OK(0):
				FAIL(-1):
				GO_RUN(1): */
	unsigned char addr[6];
	char ascii[14];
	char msg[80];
};

/* struct pcstatus  PC */

struct SwData {
	unsigned int exists;
	unsigned long address;
	unsigned int cs386p;
	unsigned char sym[41];
	unsigned char data1;
	unsigned char data2;
	unsigned char data3;
};

#define  SWBKPT_NO  256

struct  attribute {
	int Saddrunit;           /* addrunit from input data file */
	int Sabsflag;            /* 1:86-series,  0: others */
	int Scsiplen;            /* addr-len from input data file in ascii */
	int Maddrunit;           /* addrunit from mice model in unsigned char */
	int Mmodel;              /* mice model id */
	int Maddrid;             /* mice addr id. ex: 4 for 8086, 5 for 68020... */
	int Miplen;   /* ip len of the mice addr, 0: for cpu other than 86-series */
	int Mcsiplen;            /* addr-len from mice model in ascii */
	unsigned long addr_limit;/* address upper bound */
	int upload_handshake;
	int pos[30];             /* position get from "usd.fmt" */
	int mmu[12];             /* MMU pos for 64180 only */
	char getpc[20];          /* command line for get PC */

	int getpc_row;           /* for MICE-II, which "R PC" will cause error */
	int getpc_col;           /* for MICE-II, which "R PC" will cause error */

	char step[6];            /* valid sub-command char for "Step" command */
	char sp[15];             /* variable used for updating the STACK viewport */
	char ss[15];             /* variable used for updating the STACK viewport */
	int MICEGroup;           /* MICE2 for MICE-II, MICE3 for MICE-III */
	int ChipGroup;    /* CHIP86 for 86s, CHIP68 for 68Ks, CHIPELSE for others */
	int CpuCode;             /* for "BREAKPOINT" cmd */
	int CpuType;             /* for "BREAKPOINT" cmd */
	unsigned long VectAdr;   /* for "BREAKPOINT" cmd */
	unsigned char newVect[4];/* for "BREAKPOINT" cmd */
	int Toffset;             /* for "BREAKPOINT" cmd */
	unsigned char TrapCode[2];/* for "BREAKPOINT" cmd */
	unsigned char IRET[2];   /* for "BREAKPOINT" cmd */
    unsigned char JmpHere[2];/* for "BREAKPOINT" cmd */
};
	/* struct attribute env */

