
/***************************************************************************
**
**    $Header:   D:/USD3V/LOG/SRC/VIEWPORT.C__   1.2   12 Jun 1996 08:44:58   ZJRD  $
**
**    $Log:   D:/USD3V/LOG/SRC/VIEWPORT.C__  $
** 
**    Rev 1.2   12 Jun 1996 08:44:58   ZJRD
** No change.
** 
**    Rev 1.1   24 May 1996 09:43:16   ZJRD
** No change.
** 
**    Rev 1.0   11 Dec 1995 13:52:08   ZJRD
** Initial revision.
** 
****************************************************************************/
/*--------------------------------------------------------------------------*/
/*  viewport.c								    */
/*--------------------------------------------------------------------------*/


#include  "system.h"
#include  "usd3.h"
#include  "gblext.h"
#include  "oldext.h"
#include  "usym1.h"
#include  "usym3.h"
#include  "funcext.h"
#include  "cpucode.h"

extern UCHAR GblDlgColor[],GblDlgMono[];
UCHAR DlgColorLATT[102];

/****************************************************************************/
/*  USD-III command : UPDate						    */
/****************************************************************************/

update_cmd( VPName, UpdateFlag )
char  *VPName, *UpdateFlag;
{
 int  VPID, MaskFlag;

 send_ESC();

 /*  check if there are too many arguments  */

 if ( cmd_argc > 3 )  { prn_ferr( 70 ); return( TRUE ); }

 /*  list the status of each viewport's updating flag  */

 if ( VPName[0] == '\0' ) {

    if ( MaskRedrawFlag&REDRAWBRE ) DisplayStr( "\r\n BREAKPOINT viewport: OFF" );
    else  DisplayStr( "\r\n BREAKPOINT viewport: ON " );

    if ( MaskRedrawFlag&REDRAWCOD ) DisplayStr( "              CODE  viewport: OFF" );
    else  DisplayStr( "              CODE  viewport: ON" );

    if ( MaskRedrawFlag&REDRAWREG ) DisplayStr( "\r\n REGISTER   viewport: OFF" );
    else  DisplayStr( "\r\n REGISTER   viewport: ON " );

    if ( MaskRedrawFlag&REDRAWSTA ) DisplayStr( "              STACK viewport: OFF" );
    else  DisplayStr( "              STACK viewport: ON" );

    if ( MaskRedrawFlag&REDRAWTRA ) DisplayStr( "\r\n TRACE      viewport: OFF" );
    else  DisplayStr( "\r\n TRACE      viewport: ON " );

    if ( MaskRedrawFlag&REDRAWDAT ) DisplayStr( "              DATA  viewport: OFF" );
    else  DisplayStr( "              DATA  viewport: ON" );

    return( TRUE );
 }

 /*  check updating flag  */

 if	  ( usd_strncmp( UpdateFlag, "ON",  2 ) == NULL )  MaskFlag= 0;
 else  if ( usd_strncmp( UpdateFlag, "OFF", 2 ) == NULL )  MaskFlag= 1;
 else  { prn_ferr( 37 ); return( TRUE ); }

 /*  check viewport name and set MaskRedrawFlag  */

 if	  ( usd_strncmp( VPName, "BREAKPOINT", 1 ) == NULL )

	  if ( MaskFlag )  MaskRedrawFlag |= REDRAWBRE;

	  else { MaskRedrawFlag &= ( ~REDRAWBRE );
		 if ( wn_isup( VP[BREVP].Ptr ) )  UpdateBREVP( 0 );
	  }

 else  if ( usd_strncmp( VPName, "CODE",       3 ) == NULL )

	  if ( MaskFlag )  MaskRedrawFlag |= REDRAWCOD;

	  else { MaskRedrawFlag &= ( ~REDRAWCOD );
		 if ( wn_isup( VP[CODVP].Ptr ) )  UpdateCODVP();
	  }

 else  if ( usd_strncmp( VPName, "REGISTER",   1 ) == NULL )

	  if ( MaskFlag )  MaskRedrawFlag |= REDRAWREG;

	  else { MaskRedrawFlag &= ( ~REDRAWREG );
		 if ( wn_isup( VP[REGVP].Ptr ) )  UpdateREGVP();
	  }

 else  if ( usd_strncmp( VPName, "STACK",      1 ) == NULL )

	  if ( MaskFlag )  MaskRedrawFlag |= REDRAWSTA;

	  else { MaskRedrawFlag &= ( ~REDRAWSTA );
		 if ( wn_isup( VP[STAVP].Ptr ) )  UpdateSTAVP();
	  }

 else  if ( usd_strncmp( VPName, "TRACE",      1 ) == NULL )

	  if ( MaskFlag )  MaskRedrawFlag |= REDRAWTRA;

	  else { MaskRedrawFlag &= ( ~REDRAWTRA );
		 if ( wn_isup( VP[TRAVP].Ptr ) )  UpdateTRAVP( 0 );
	  }

 else  if ( usd_strncmp( VPName, "DATA",       1 ) == NULL )

	  if ( MaskFlag )  MaskRedrawFlag |= REDRAWDAT;

	  else { MaskRedrawFlag &= ( ~REDRAWDAT );
		 if ( wn_isup( VP[DATVP].Ptr ) )  UpdateDATVP();
	  }

 else  { prn_ferr( 60 ); return( TRUE ); }

 return( TRUE );

}  /*  of update_cmd()  */

/****************************************************************************/
/*  USD-III command : SOFtkey						    */
/****************************************************************************/

softkey_cmd( Kn, Command )
char  *Kn, *Command;
{
 int  KnBufIdx, i;

 send_ESC();

 /*  list all of the softkey definitions  */

 if ( Kn[0] == '\0' ) {

    DisplayStr( "\r\n K1  = " ); DisplayStr( SoftKeyBuf[0] );
    DisplayStr( "\r\n K2  = " ); DisplayStr( SoftKeyBuf[1] );
    DisplayStr( "\r\n K3  = " ); DisplayStr( SoftKeyBuf[2] );
    DisplayStr( "\r\n K4  = " ); DisplayStr( SoftKeyBuf[3] );
    DisplayStr( "\r\n K5  = " ); DisplayStr( SoftKeyBuf[4] );
    DisplayStr( "\r\n K6  = " ); DisplayStr( SoftKeyBuf[5] );
    DisplayStr( "\r\n K7  = " ); DisplayStr( SoftKeyBuf[6] );
    DisplayStr( "\r\n K8  = " ); DisplayStr( SoftKeyBuf[7] );
    DisplayStr( "\r\n K9  = " ); DisplayStr( SoftKeyBuf[8] );
    DisplayStr( "\r\n K10 = " ); DisplayStr( SoftKeyBuf[9] );

    return( TRUE );
 }

 /*  check softkey number  */

 if	  ( usd_strncmp( Kn, "K1",  2 ) == NULL )  KnBufIdx = 0;
 else  if ( usd_strncmp( Kn, "K2",  2 ) == NULL )  KnBufIdx = 1;
 else  if ( usd_strncmp( Kn, "K3",  2 ) == NULL )  KnBufIdx = 2;
 else  if ( usd_strncmp( Kn, "K4",  2 ) == NULL )  KnBufIdx = 3;
 else  if ( usd_strncmp( Kn, "K5",  2 ) == NULL )  KnBufIdx = 4;
 else  if ( usd_strncmp( Kn, "K6",  2 ) == NULL )  KnBufIdx = 5;
 else  if ( usd_strncmp( Kn, "K7",  2 ) == NULL )  KnBufIdx = 6;
 else  if ( usd_strncmp( Kn, "K8",  2 ) == NULL )  KnBufIdx = 7;
 else  if ( usd_strncmp( Kn, "K9",  2 ) == NULL )  KnBufIdx = 8;
 else  if ( usd_strncmp( Kn, "K10", 3 ) == NULL )  KnBufIdx = 9;
 else  { prn_ferr( 63 ); return( TRUE ); }

 strcpy( SoftKeyBuf[KnBufIdx], Command );

 return( TRUE );

}  /*  of softkey_cmd()  */

/****************************************************************************/
/*  USD-III command : USAVe						    */
/****************************************************************************/

usave_cmd( VPorKn )
char  *VPorKn;
{
 int  VPID;
 int  WorK;  /*  bit 1 : W, bit 0 : K  */
 extern int  AskAbortUSD3;

 if ( AskAbortUSD3 )  AskAbortUSD3 = 0;
 else  send_ESC();

 /*  check if there are too many arguments  */

 if ( cmd_argc > 2 )  { prn_ferr( 70 ); return( TRUE ); }

 if ( VPorKn[0] == '\0' )  WorK = 3;
 else  if ( usd_strncmp( VPorKn, "W", 1 ) == NULL )  WorK = 2;
 else  if ( usd_strncmp( VPorKn, "K", 1 ) == NULL )  WorK = 1;
 else  { prn_ferr( 37 ); return( TRUE ); }

 if ( ! wn_isup( VP[CODVP].Ptr ) ) { prn_ferr( 64 ); return( TRUE ); }

 /*  open "USD3.SAV" for writing  */

 if ( ( USD3SAVFileHan = open( "USD3.SAV", O_WRONLY ) ) == -1 )

    if ( ( USD3SAVFileHan = open( "USD3.SAV", O_CREAT | O_WRONLY, S_IREAD | S_IWRITE ) ) != -1 ) {
// 1 line: DLGCOLOR modified
       chsize( USD3SAVFileHan, (long) ( 7*VPINFOBUFSIZE + 10*(1+SOFTKEYBUFSIZE) + 7) );
       lseek( USD3SAVFileHan, (long) 0, SEEK_SET );
       write( USD3SAVFileHan, "0", 1 );
       lseek( USD3SAVFileHan, (long) ( 7 * VPINFOBUFSIZE ), SEEK_SET );
       write( USD3SAVFileHan, "0", 1 );
// 2 lines:  DLGCOLOR: writing color settings to USD3.SAV
       lseek( USD3SAVFileHan, (long) (10*(1+SOFTKEYBUFSIZE)), SEEK_SET );
       write( USD3SAVFileHan, "0", 1 );
       lseek( USD3SAVFileHan, (long) 0, SEEK_SET );

    } else { prn_ferr( 31 ); return( TRUE ); }

 /*  write viewport information ( screen layout ) to "USD3.SAV"  */

 if ( ( WorK & 2 ) != 0 ) {
    for ( VPID = BREVP; VPID <= DATVP; VPID++ ) WriteVPInfoToUSD3SAV( VPID );
// 3 lines: DLGCOLOR
	lseek( USD3SAVFileHan, (long) -6, SEEK_END );
	write(USD3SAVFileHan,GblDlgColor,3);
	write(USD3SAVFileHan,GblDlgMono,3);
 }  

 /*  write softkey definitions to "USD3.SAV"  */

 if ( ( WorK & 1 ) != 0 )  WriteSoftKeyToUSD3SAV();
 
 /*  close "USD3.SAV"  */

 close( USD3SAVFileHan );

 return( TRUE );

}  /*  of usave_cmd()  */

/****************************************************************************/
/*  write viewport information ( screen layout ) to "USD3.SAV"		    */
/****************************************************************************/

WriteVPInfoToUSD3SAV( VPID )
int  VPID;
{
 VPInfoBuf[0] = '1';
 VPInfoBuf[1] = VPID + '0';
 if ( wn_isup( VP[VPID].Ptr ) )	 VPInfoBuf[2] = '1';
 else  VPInfoBuf[2] = '0';
  
 if	 ( VPID == BREVP )
	 VPInfoBuf[3] = ( 1 - ( (MaskRedrawFlag&REDRAWBRE) ? 1 : 0 ) ) + '0';
 else if ( VPID == CODVP )
	 VPInfoBuf[3] = ( 1 - ( (MaskRedrawFlag&REDRAWCOD) ? 1 : 0 ) ) + '0';
 else if ( VPID == COMVP )
	 VPInfoBuf[3] = '1';  /*  this value has no meaning  */
 else if ( VPID == REGVP )
	 VPInfoBuf[3] = ( 1 - ( (MaskRedrawFlag&REDRAWREG) ? 1 : 0 ) ) + '0';
 else if ( VPID == STAVP )
	 VPInfoBuf[3] = ( 1 - ( (MaskRedrawFlag&REDRAWSTA) ? 1 : 0 ) ) + '0';
 else if ( VPID == TRAVP )
	 VPInfoBuf[3] = ( 1 - ( (MaskRedrawFlag&REDRAWTRA) ? 1 : 0 ) ) + '0';
 else if ( VPID == DATVP )
	 VPInfoBuf[3] = ( 1 - ( (MaskRedrawFlag&REDRAWDAT) ? 1 : 0 ) ) + '0';

 if	 ( VP[VPID].BackgrndColor == BLACOLOR )  VPInfoBuf[4] = '0';
 else if ( VP[VPID].BackgrndColor == BLUCOLOR )  VPInfoBuf[4] = '1';
 else if ( VP[VPID].BackgrndColor == MAGCOLOR )  VPInfoBuf[4] = '2';
 else if ( VP[VPID].BackgrndColor == REDCOLOR )  VPInfoBuf[4] = '3';
 else if ( VP[VPID].BackgrndColor == WHICOLOR )  VPInfoBuf[4] = '4';
 else if ( VP[VPID].BackgrndColor == CYACOLOR )  VPInfoBuf[4] = '6';
 else if ( VP[VPID].BackgrndColor == GRECOLOR )  VPInfoBuf[4] = '7';
 else if ( VP[VPID].BackgrndColor == YELCOLOR )  VPInfoBuf[4] = '8';

 if	 ( VP[VPID].TextColor == BLACOLOR )  VPInfoBuf[5] = '0';
 else if ( VP[VPID].TextColor == BLUCOLOR )  VPInfoBuf[5] = '1';
 else if ( VP[VPID].TextColor == MAGCOLOR )  VPInfoBuf[5] = '2';
 else if ( VP[VPID].TextColor == REDCOLOR )  VPInfoBuf[5] = '3';
 else if ( VP[VPID].TextColor == WHICOLOR )  VPInfoBuf[5] = '4';
 else if ( VP[VPID].TextColor == CYACOLOR )  VPInfoBuf[5] = '6';
 else if ( VP[VPID].TextColor == GRECOLOR )  VPInfoBuf[5] = '7';
 else if ( VP[VPID].TextColor == YELCOLOR )  VPInfoBuf[5] = '8';

 VPInfoBuf[6]  = ( VP[VPID].yOrg / 100 ) + '0';
 VPInfoBuf[7]  = ( ( VP[VPID].yOrg % 100 ) / 10 ) + '0';
 VPInfoBuf[8]  = ( VP[VPID].yOrg % 10 ) + '0';

 VPInfoBuf[9]  = ( VP[VPID].xOrg / 100 ) + '0';
 VPInfoBuf[10] = ( ( VP[VPID].xOrg % 100 ) / 10 ) + '0';
 VPInfoBuf[11] = ( VP[VPID].xOrg % 10 ) + '0';

 VPInfoBuf[12] = ( VP[VPID].Height / 100 ) + '0';
 VPInfoBuf[13] = ( ( VP[VPID].Height % 100 ) / 10 ) + '0';
 VPInfoBuf[14] = ( VP[VPID].Height % 10 ) + '0';

 VPInfoBuf[15] = ( VP[VPID].Width / 100 ) + '0';
 VPInfoBuf[16] = ( ( VP[VPID].Width % 100 ) / 10 ) + '0';
 VPInfoBuf[17] = ( VP[VPID].Width % 10 ) + '0';

 write( USD3SAVFileHan, VPInfoBuf, VPINFOBUFSIZE );

}  /*  of WriteVPInfoToUSD3SAV()  */

/****************************************************************************/
/*  write softkey definitions to "USD3.SAV"				    */
/****************************************************************************/

WriteSoftKeyToUSD3SAV()
{
 int  i;
    
 lseek( USD3SAVFileHan, (long) ( 7 * VPINFOBUFSIZE ), SEEK_SET );

 for ( i = 0; i <= 9; i++ ) {
	
     write( USD3SAVFileHan, "1", 1);
     write( USD3SAVFileHan, SoftKeyBuf[i], SOFTKEYBUFSIZE );
 }

}  /*  of WriteSoftKeyToUSD3SAV()  */

/****************************************************************************/
/*  USD-III command : URECall						    */
/****************************************************************************/

urecall_cmd( VPorKn )
char  *VPorKn;
{
 int   VPID;
 int   WorK;  /*  bit 1 : W, bit 0 : K  */
 char  c[2];

 send_ESC();

 /*  check if there are too many arguments  */

 if ( cmd_argc > 2 )  { prn_ferr( 70 ); return( TRUE ); }

 if ( VPorKn[0] == '\0' )  WorK = 3;
 else  if ( usd_strncmp( VPorKn, "W", 1 ) == NULL )  WorK = 2;
 else  if ( usd_strncmp( VPorKn, "K", 1 ) == NULL )  WorK = 1;
 else  { prn_ferr( 37 ); return( TRUE ); }

 if ( ! wn_isup( VP[CODVP].Ptr ) ) { prn_ferr( 64 ); return( TRUE ); }

 /*  open "USD3.SAV" for reading  */

 if ( ( USD3SAVFileHan = open( "USD3.SAV", O_RDONLY ) ) == -1 ) {

    prn_ferr( 15 );
    return( TRUE );
 }

 /*  read viewport information ( screen layout ) from "USD3.SAV"  */

 if ( ( WorK & 2 ) != 0 ) {

    read( USD3SAVFileHan, c, 1 );

    if ( c[0] == '1' ) {

       ReadVPInfoFromUSD3SAV();
       if ( wn_isup( VP[REGVP].Ptr ) )  UpdateREGVP();
       if ( wn_isup( VP[CODVP].Ptr ) )  UpdateCODVP();  else  GetPC(&PC);
       if ( wn_isup( VP[STAVP].Ptr ) )  UpdateSTAVP();
       if ( wn_isup( VP[BREVP].Ptr ) )  UpdateBREVP( 0 );
       if ( wn_isup( VP[TRAVP].Ptr ) )  UpdateTRAVP( 0 );
       if ( wn_isup( VP[DATVP].Ptr ) )  UpdateDATVP();
    }
 }

 /*  read softkey definitions from "USD3.SAV"  */

 if ( ( WorK & 1 ) != 0 ) {

    lseek( USD3SAVFileHan, (long) ( 7 * VPINFOBUFSIZE ), SEEK_SET );
    read( USD3SAVFileHan, c, 1 );

    if ( c[0] == '1' )  ReadSoftKeyFromUSD3SAV();
 }
 
 /*  close "USD3.SAV"  */

 close( USD3SAVFileHan );

 return( TRUE );

}  /*  of urecall_cmd()  */

/****************************************************************************/
/*  read viewport information ( screen layout ) from "USD3.SAV"		    */
/****************************************************************************/

ReadVPInfoFromUSD3SAV()
{
 int  STAVPIsUp = 0, DATVPIsUp = 0;
 int  VPID;

// 13 lines: DLGCOLOR

 long lpos;
 DFORMPTR  dfmptr;
    lpos = tell(USD3SAVFileHan);
    lseek(USD3SAVFileHan,(long)-6,SEEK_END);
    read(USD3SAVFileHan,GblDlgColor,3);
    read(USD3SAVFileHan,GblDlgMono,3);
    lseek(USD3SAVFileHan,lpos,SEEK_SET);
//    dfmptr = dl_fmget("FInclude",NULLP,NULLP,NULLP,VVDLibp);
//    memcpy(DlgColorLATT,dfmptr->wnp->lattarray,102);
//    fm_free(dfmptr);
//    lattp = (LIBATTPTR) _ckliblatt("USD3DLG.LIB");
//    if (lattp) {
//	    memcpy(DlgColorLATT,lattp->latt,102);
//	    if (vid_getmode() == MONO) 
//		    memcpy(&(lattp->latt[26]),GblDlgMono,3);
//	    else    memcpy(&(lattp->latt[26]),GblDlgColor,3);
//	}
    
 /*  hide all viewports  */

 for ( VPID = BREVP; VPID <= DATVP; VPID++ )
     if ( wn_isup( VP[VPID].Ptr ) )  wn_dn( VP[VPID].Ptr );

 VP[ActVP].Ptr->titleatt = LVPTITLEINACT;
 VP[ ActVP = COMVP ].Ptr->titleatt = LVPTITLEACT;
 MaskRedrawFlag = 0;
 lseek( USD3SAVFileHan, (long) 0, SEEK_SET );

 for ( VPID = BREVP; VPID <= DATVP; VPID++ ) {

     read( USD3SAVFileHan, VPInfoBuf, VPINFOBUFSIZE );

     if ( ( VPID == BREVP ) || ( VPID == REGVP ) || ( VPID == TRAVP ) )	{
	if ( VPInfoBuf[2] == '1' )  TopVP = VPID;
     } else  if ( ( VPID==STAVP ) && ( VPInfoBuf[2]=='1' ) )  STAVPIsUp = 1;
	     else  if ( ( VPID==DATVP ) && ( VPInfoBuf[2]=='1' ) )  DATVPIsUp = 1;

     if	       ( VPID == BREVP ) {
	if ( ! ( VPInfoBuf[3] - '0' ) )  MaskRedrawFlag |= REDRAWBRE;
     } else if ( VPID == CODVP ) {
	if ( ! ( VPInfoBuf[3] - '0' ) )  MaskRedrawFlag |= REDRAWCOD;
     } else if ( VPID == REGVP ) {
	if ( ! ( VPInfoBuf[3] - '0' ) )  MaskRedrawFlag |= REDRAWREG;
     } else if ( VPID == STAVP ) {
	if ( ! ( VPInfoBuf[3] - '0' ) )  MaskRedrawFlag |= REDRAWSTA;
     } else if ( VPID == TRAVP ) {
	if ( ! ( VPInfoBuf[3] - '0' ) )  MaskRedrawFlag |= REDRAWTRA;
     } else if ( VPID == DATVP ) {
	if ( ! ( VPInfoBuf[3] - '0' ) )  MaskRedrawFlag |= REDRAWDAT;
     }

     if	      ( VPInfoBuf[4] == '0' )  VP[VPID].BackgrndColor = BLACOLOR;
     else  if ( VPInfoBuf[4] == '1' )  VP[VPID].BackgrndColor = BLUCOLOR;
     else  if ( VPInfoBuf[4] == '2' )  VP[VPID].BackgrndColor = MAGCOLOR;
     else  if ( VPInfoBuf[4] == '3' )  VP[VPID].BackgrndColor = REDCOLOR;
     else  if ( VPInfoBuf[4] == '4' )  VP[VPID].BackgrndColor = WHICOLOR;
     else  if ( VPInfoBuf[4] == '6' )  VP[VPID].BackgrndColor = CYACOLOR;
     else  if ( VPInfoBuf[4] == '7' )  VP[VPID].BackgrndColor = GRECOLOR;
     else  if ( VPInfoBuf[4] == '8' )  VP[VPID].BackgrndColor = YELCOLOR;

     if	      ( VPInfoBuf[5] == '0' )  VP[VPID].TextColor = BLACOLOR;
     else  if ( VPInfoBuf[5] == '1' )  VP[VPID].TextColor = BLUCOLOR;
     else  if ( VPInfoBuf[5] == '2' )  VP[VPID].TextColor = MAGCOLOR;
     else  if ( VPInfoBuf[5] == '3' )  VP[VPID].TextColor = REDCOLOR;
     else  if ( VPInfoBuf[5] == '4' )  VP[VPID].TextColor = WHICOLOR;
     else  if ( VPInfoBuf[5] == '6' )  VP[VPID].TextColor = CYACOLOR;
     else  if ( VPInfoBuf[5] == '7' )  VP[VPID].TextColor = GRECOLOR;
     else  if ( VPInfoBuf[5] == '8' )  VP[VPID].TextColor = YELCOLOR;

     sw_att( COLOR( VP[VPID].TextColor, VP[VPID].BackgrndColor ), VP[VPID].Ptr );
     ms_clratt( COLOR( VP[VPID].TextColor, VP[VPID].BackgrndColor ), VP[VPID].Buf );
     v_chattrow( 0, 0, ' ', COLOR( VP[VPID].TextColor, VP[VPID].BackgrndColor ),
		 ENDWN, ATT, VP[VPID].Ptr );

     VP[VPID].yOrg   = ( VPInfoBuf[6]-'0'  ) * 100 + ( VPInfoBuf[7]-'0'  ) * 10 +
		       ( VPInfoBuf[8]-'0'  );
     VP[VPID].Height = ( VPInfoBuf[12]-'0' ) * 100 + ( VPInfoBuf[13]-'0' ) * 10 +
		       ( VPInfoBuf[14]-'0' );

     if ( VPID == STAVP ) {

        VP[STAVP].Width = CountSTAVPWidth();
        VP[STAVP].xOrg  = 80 - VP[STAVP].Width;

     } else {

        VP[VPID].Width = (VPInfoBuf[15]-'0')*100+(VPInfoBuf[16]-'0')*10+(VPInfoBuf[17]-'0');
        VP[VPID].xOrg  = (VPInfoBuf[9]- '0')*100+(VPInfoBuf[10]-'0')*10+(VPInfoBuf[11]-'0');
     }
 
     wn_mod_no_pre_wn_unset( VP[VPID].yOrg, VP[VPID].xOrg, VP[VPID].Height, VP[VPID].Width, VP[VPID].Ptr );
 }

 if ( STAVPIsUp	|| DATVPIsUp ) {

    sw_bdr( &LeftVPBdr, VP[CODVP].Ptr );
    if ( STAVPIsUp )  VP[CODVP].Width = VP[REGVP].Width - VP[STAVP].Width;
    else  VP[CODVP].Width = VP[REGVP].Width - VP[DATVP].Width;
    wn_mod_no_pre_wn_unset( VP[CODVP].yOrg, VP[CODVP].xOrg, VP[CODVP].Height, VP[CODVP].Width, VP[CODVP].Ptr );

 } else  sw_bdr( &MiddleVPBdr, VP[CODVP].Ptr );

 if ( ( wn_up( VP[TopVP].Ptr ) == 0 ) || ( wn_up( VP[CODVP].Ptr ) == 0 ) ||
      ( wn_up( VP[COMVP].Ptr ) == 0 ) || ( STAVPIsUp && ( wn_up( VP[STAVP].Ptr ) == 0 ) ) ||
      ( DATVPIsUp && ( wn_up( VP[DATVP].Ptr ) == 0 ) ) )
    return( FALSE );
 else  return( TRUE );

}  /*  of ReadVPInfoFromUSD3SAV()  */

/****************************************************************************/
/*  read softkey definitions from "USD3.SAV"				    */
/****************************************************************************/

ReadSoftKeyFromUSD3SAV()
{
 char  c[2];
 int   i;
    
 lseek( USD3SAVFileHan, (long) ( 7 * VPINFOBUFSIZE ), SEEK_SET );

 for ( i = 0; i <= 9; i++ ) {
	
     read( USD3SAVFileHan, c, 1 );
     read( USD3SAVFileHan, SoftKeyBuf[i], SOFTKEYBUFSIZE );
     SoftKeyBuf[i][ SOFTKEYBUFSIZE ] = '\0';
 }

}  /*  of ReadSoftKeyFromUSD3SAV()  */

/****************************************************************************/
/*  USD-III command : HElp						    */
/****************************************************************************/

help_cmd( USD3Help )
char  *USD3Help;
{
 WINDOWPTR  MsgWnp;

 if ( strcmp( USD3Help, "USD3" ) == 0 ) {

    send_ESC();

    MsgWnp = wn_def( 24, 0, 1, 80, LMESSAGE, BDR_NULLP );
    wn_up( MsgWnp );
    v_stpl( 0, 1, "Cursor keys to scroll, <ESC> to quit", MsgWnp );

    wn_up( CmdHelpWnp );
    mf_browse( CmdHelpWnp );
    wn_dn( CmdHelpWnp );

    wn_dn( MsgWnp );
    wn_free( MsgWnp );

    return( TRUE );

 }  else  return( FALSE );

}  /*  of help_cmd()  */

/****************************************************************************/
/*  USD-III command : QUIt	 					    */
/****************************************************************************/

/* USD-III V2.0x */
#define PULLDOWN	1
#define DIALOG		2
extern int  special_dialog, pulldown_or_dialog;
/* USD-III V2.0x */

quit_cmd()
{
 extern int  COMVPMax;

 send_ESC();

/* USD-III V2.0x */ pulldown_or_dialog = DIALOG;
/* USD-III V2.0x */ special_dialog = 1;

 if ( !COMVPMax && ( VerUSAV1() == TRUE ) )  usave_cmd( "" );

 DestroyVP();
 DestroyMenu();
 WmClose();
 FreeGbl();
 vs_clr();
 USD3vid_setmode( OldVideoMode );
 exit_vv();
 exit( 0 );

 return( TRUE );

}  /*  of quit_cmd()  */

/****************************************************************************/
/*									    */
/****************************************************************************/

VerUSAV1()
{
 DFORMPTR   DFormPtr;
 DFIELDPTR  DFieldPtr;
 char	    DoUSAV[2];
 
/* USD-III V2.0x */
 DoUSAV[0] = 'Y';
 DoUSAV[1] = '\0';

 DFormPtr  = fm_def( 10, 23, 5, 34, LWHI_RED, BDR_DLNP );
 DFieldPtr = fld_def( 1, 3, "Save screen and softkey? ", FADJACENT, "!", F_STRING, DoUSAV, DFormPtr );
 sf_attact( LRED_WHI, DFieldPtr );
 sf_attinact( LWHI_RED, DFieldPtr );

/* USD-III V2.0x */ sfm_opt( VERIFYEXIT|VERIFYQUIT, OFF, DFormPtr );
 
 if ( fm_proc( 0, DFormPtr ) == AC_QUIT ) {

    fm_free( DFormPtr );
//    csr_plwn( VP[COMVP].Ptr );
    return( FALSE );
 }

 fm_free( DFormPtr );

 if ( DoUSAV[0] == 'Y' )  return( TRUE );
 else {
//   csr_plwn( VP[COMVP].Ptr );
   return( FALSE );
 }

}  /*  of VerUSAV1()  */

/****************************************************************************/
/*  USD-III command : MONitor	 					    */
/****************************************************************************/

monitor_cmd( Var, TotalNumStr, TypeStr, Type2Str)
char  *Var, *TotalNumStr, *TypeStr, *Type2Str;
{
 char  Tmp[80], *Ptr;
 char  Sym[14], Addr[14];
 int   TotalNum = 1, Type = 0;
 int   i, j;
 extern int  COMVPMax;

 send_ESC();

 if ( cmd_argc == 1 )  goto MonEnd;

 /*  check if there are too many arguments  */

 if ( cmd_argc > 5 )  { prn_ferr( 70 ); return( TRUE ); }

 /*  get total number and type  */

 if ( TotalNumStr[0] != '\0' )

    if ( isdigit( TotalNumStr[0] ) ) {

       if ( TypeStr[0] != '\0' )
          if ( !usd_strncmp( TypeStr, "BYTE", 1 ) )  Type = 0;
          else  if ( !usd_strncmp( TypeStr, "WORD", 1 ) )  Type = 1;
          else  if ( !usd_strncmp( TypeStr, "LONG", 1 ) )  Type = 2;
          else  { prn_ferr( 70 ); return( TRUE ); }

       if ( Type2Str[0] != '\0' ) {
          if ( env.CpuCode != M8051) { prn_ferr( 70 ); return( TRUE ); }
          if ( Type2Str[0] == 'P')  Type |= 0x10;
          else if ( Type2Str[0] == 'X')  Type |= 0x20;
          else if ( Type2Str[0] != 'I')   { prn_ferr( 70 ); return( TRUE ); }
	   }

       i = strlen( TotalNumStr );
       for ( j = 0; j < i; j++ )
         if ( !isdigit( TotalNumStr[j] ) ) { prn_ferr( 70 ); return( TRUE ); }
       sscanf( TotalNumStr, "%d", &TotalNum );
       if ( TotalNum <= 0 )  { prn_ferr( 70 ); return( TRUE ); }
       
    } else {

       if ( TypeStr[0] != '\0' )  { prn_ferr( 70 ); return( TRUE ); }

       if ( !usd_strncmp( TotalNumStr, "BYTE", 1 ) )  Type = 0;
       else  if ( !usd_strncmp( TotalNumStr, "WORD", 1 ) )  Type = 1;
       else  if ( !usd_strncmp( TotalNumStr, "LONG", 1 ) )  Type = 2;
       else  { prn_ferr( 70 ); return( TRUE ); }
    }

 /*  get symbol and address  */

 if ( (Var[0]!='%') && (str2addr(Var,Addr)==FAIL) ) { prn_ferr( 70 ); return( TRUE ); }

 if ( Var[0] == '%' ) {

    strcpy( Tmp, Var );
    Ptr = strchr( Tmp, '[' ) + 1;
    *( strchr( Tmp, ']' ) ) = '\0';
    strcpy( Addr, Ptr );
    *( Ptr - 1 ) = '\0';
    Tmp[13] = '\0';
    strcpy( Sym, Tmp );
    
 } else {

    Sym[0] = '\0';

    if ( ( env.Maddrid == I8086 ) || ( env.Maddrid == M_3_386 ) ) {

       if ( strchr( Var, ':' ) == NULL ) {

	  if ( PC.flag == 0 ) {  /*  OK  */
	     strcpy( Tmp, PC.ascii );
	     *( strchr( Tmp, ':' ) + 1 ) = '\0';
	     strcpy( Addr, Tmp );
	  } else {
	     if ( env.Mmodel == M_3_H8 )  strcpy( Addr, "00:" );
	     else  strcpy( Addr, "0000:" );
	  }

	  strcat( Addr, Var );

       } else  strcpy( Addr, Var );

    } else  strcpy( Addr, Var );
 }

 /*  fill MonVar[]  */

 if ( (DATBUFROW-NextMonVarEntry) < TotalNum )  { prn_ferr( 32 ); return( TRUE ); }

 MonVar[NextMonVarEntry].Num = NextMonVarNum++;
 MonVar[NextMonVarEntry].Type = Type;
 strcpy( MonVar[NextMonVarEntry].Sym, Sym );
 strcpy( MonVar[NextMonVarEntry++].Addr, Addr );
 for ( i = 2; i <= TotalNum; i++ )  MonVar[NextMonVarEntry++].Num = 0;
 RedrawFlag = REDRAWDAT;

MonEnd :

 if ( wn_isup( VP[DATVP].Ptr ) )  return( TRUE );

 else {

    if ( COMVPMax )  return( TRUE );

    if ( wn_isup( VP[STAVP].Ptr ) ) {

       wn_dn( VP[STAVP].Ptr );
     
       VP[CODVP].Width = VP[REGVP].Width - VP[DATVP].Width;
       wn_mod_no_pre_wn_unset( VP[CODVP].yOrg, VP[CODVP].xOrg, VP[CODVP].Height, VP[CODVP].Width, VP[CODVP].Ptr );
     
       v_bdr_csr_plwn( &BottomVPBdr, VP[COMVP].Ptr );

       wn_up( VP[DATVP].Ptr );
       if ( ( cmd_argc == 1 ) && ( ! ( MaskRedrawFlag & REDRAWDAT ) ) )  UpdateDATVP();

       if ( ActVP == STAVP ) {

	  VP[STAVP].Ptr->titleatt = LVPTITLEINACT;
          ActVP = DATVP;
          VP[DATVP].Ptr->titleatt = LVPTITLEACT;
          v_titleatt( NULLP, LVPTITLEACT, VP[DATVP].Ptr );
       }

    } else {

       VP[CODVP].Width = VP[REGVP].Width - VP[DATVP].Width;
       sw_bdr( &LeftVPBdr, VP[CODVP].Ptr );
       wn_mod_no_pre_wn_unset( VP[CODVP].yOrg, VP[CODVP].xOrg, VP[CODVP].Height, VP[CODVP].Width, VP[CODVP].Ptr );

       v_bdr_csr_plwn( &BottomVPBdr, VP[COMVP].Ptr );

       wn_up( VP[DATVP].Ptr );
       if ( ( cmd_argc == 1 ) && ( ! ( MaskRedrawFlag & REDRAWDAT ) ) )  UpdateDATVP();
    }

    return( TRUE );
 }

}  /*  of monitor_cmd()  */

/****************************************************************************/
/*  USD-III command : NOMon	 					    */
/****************************************************************************/

nomon_cmd( NumStr1, NumStr2 )
char  *NumStr1, *NumStr2;
{
 int  Num1, Num2, DiffNum, HaveNum2 = 0, RemoveEntry, TotalEntry, i, j;

 send_ESC();

 /*  check if there are too many or too few arguments  */

 if ( cmd_argc > 3 )  { prn_ferr( 70 ); return( TRUE ); }

 /*  get number  */

 if ( NumStr1[0] == '\0' ) {

    NextMonVarEntry = 0;
    NextMonVarNum = 1;
    RedrawFlag = REDRAWDAT;
    return( TRUE );

 } else {

    i = strlen( NumStr1 );
    for ( j = 0; j < i; j++ )
      if ( !isdigit( NumStr1[j] ) )  { prn_ferr( 70 ); return( TRUE ); }
    sscanf( NumStr1, "%d", &Num1 );
    if ( Num1 <= 0 )  { prn_ferr( 70 ); return( TRUE ); }
 }

 if ( NumStr2[0] != '\0' ) {

    HaveNum2 = 1;
    i = strlen( NumStr2 );
    for ( j = 0; j < i; j++ )
      if ( !isdigit( NumStr2[j] ) )  { prn_ferr( 70 ); return( TRUE ); }
    sscanf( NumStr2, "%d", &Num2 );
    if ( ( Num2 <= 0 ) || ( Num2 < Num1 ) )  { prn_ferr( 70 ); return( TRUE ); }
 }

 /*  remove MonVar[]  */

 if ( Num1 >= NextMonVarNum )  { prn_ferr( 27 ); return( TRUE ); }
 if ( HaveNum2 && ( Num2 >= NextMonVarNum ) )  Num2 = NextMonVarNum - 1;

 if ( HaveNum2 )  DiffNum = Num2 - Num1 + 1;
 else  DiffNum = 1;

 for ( i = 0; i < NextMonVarEntry; i++ )
   if ( MonVar[i].Num == Num1 )  break;
 RemoveEntry = i;

 if ( HaveNum2 && ( Num2 > Num1 ) )
    for ( i++; i < NextMonVarEntry; i++ )
      if ( MonVar[i].Num == Num2 )  break;

 for ( i++; i < NextMonVarEntry; i++ )
   if ( MonVar[i].Num != 0 )  break;
 TotalEntry = i - RemoveEntry;

 if ( i < NextMonVarEntry )
    for ( j = RemoveEntry ; i < NextMonVarEntry; i++, j++ )
      if ( MonVar[i].Num != 0 ) {
	 MonVar[j].Num = MonVar[i].Num - DiffNum;
         MonVar[j].Type = MonVar[j].Type;
         strcpy( MonVar[j].Sym, MonVar[i].Sym );
         strcpy( MonVar[j].Addr, MonVar[i].Addr );
         MonVar[j].Type = MonVar[i].Type;
      } else  MonVar[j].Num = 0;

 NextMonVarEntry -= TotalEntry;
 NextMonVarNum -= DiffNum;

 RedrawFlag = REDRAWDAT;
 return( TRUE );

}  /*  of nomon_cmd()  */
