
/***************************************************************************
**
**    $Header:   D:/USD3V/LOG/SRC/VV_SYS.H__   1.2   12 Jun 1996 08:45:06   ZJRD  $
**
**    $Log:   D:/USD3V/LOG/SRC/VV_SYS.H__  $
** 
**    Rev 1.2   12 Jun 1996 08:45:06   ZJRD
** No change.
** 
**    Rev 1.1   24 May 1996 09:43:08   ZJRD
** No change.
** 
**    Rev 1.0   11 Dec 1995 13:52:04   ZJRD
** Initial revision.
** 
****************************************************************************/
/*  vv_sys.h

    ************* Copyright 1988 by Vermont Creative Software **************

Description

Basic system header file included in most higher level header files.

*/

/*  Do not allow to process the file more than once			      */
#ifndef VV_SYS
#define VV_SYS


/******************************************************************************/
/*  Include the subsidiary header files 				      */
/******************************************************************************/

/*  Include the environment definitions 				      */
#ifndef VV_ENV
#include <vv_env.h>
#endif

/*  Include stdio.h if not already included				      */
#ifndef EOF
#include <stdio.h>			/*try not to #include stdio.h twice   */
#endif

/*  Include operating system dependent header files			      */




/******************************************************************************/
/*									      */
/*  Preprocessor symbol definitions					      */
/*									      */
/******************************************************************************/

/*----------------------------------------------------------------------------*/
/*  VCS predefined data types						      */
/*----------------------------------------------------------------------------*/
#define UCHAR	     unsigned char	/*unsigned character		      */
#define UINT	     unsigned int	/*unsigned integer		      */
#define USHORT	     unsigned short	/*unsigned short integer	      */
#define ULONG	     unsigned long	/*unsigned long integer 	      */

/*----------------------------------------------------------------------------*/
/*  Environment-specific VCS predefined data types.			      */
/*----------------------------------------------------------------------------*/
#define FAR	     far		/*far modifier			      */
#define PTR	     void *		/*generic pointer		      */


#if _MSC_VER == 600	 		/*MSC 6.0 			      */
#ifdef NO_DEBUG_CODE			/*production library		      */
#define CDECL	    _cdecl
#ifndef FASTCALL
#define FASTCALL    _cdecl
#endif
#else					/*else development library	      */
#define CDECL	    _cdecl
#define FASTCALL    _cdecl
#endif					/*end NO_DEBUG_CODE		      */
#else					/*else not _MSC_VER == 600	      */
#ifndef CDECL				/*may be defined in MSC 5.xx	      */
#define CDECL
#endif
#define FASTCALL    
#endif					/*end _MSC_VER == 600		      */



#if __HIGHC__ || __386__
#define ISVR	    CDECL
#else
#define ISVR	    far CDECL
#endif

#ifdef LINT_ARGS
typedef void (ISVR *ISVRP)(void);      	/*pointer to interrupt service routine*/
#else
typedef void (ISVR *ISVRP)();		/*pointer to interrupt service routine*/
#endif


typedef int (FASTCALL * PFI)();	     	/*pointer to function returning int   */
typedef void (FASTCALL * PFV)();	/*pointer to function with no return  */

#ifdef LINT_ARGS
typedef int (FASTCALL * KEYFP)(PTR);	/*key function pointer		      */
#else
typedef int (FASTCALL * KEYFP)();   	/*key function pointer		      */
#endif

/*----------------------------------------------------------------------------*/
/*  Modifiers for global data, external data, and function prototypes that    */
/*  may vary among operating environments.				      */
/*----------------------------------------------------------------------------*/
#define GLOBAL
#define EXTERN	     extern
#define PROTOTYPE    extern

/*----------------------------------------------------------------------------*/
/*  If not already defined, then define NULLP and NULLFP		      */
/*----------------------------------------------------------------------------*/
#ifndef NULLP
#define NULLP	     (PTR) 0		/*NULL pointer to data		      */
#endif

#ifndef NULLFP
#define NULLFP	     (PFI) 0		/*NULL pointer to function	      */
#endif

/*----------------------------------------------------------------------------*/
/*  Maximum values							      */
/*----------------------------------------------------------------------------*/
#define SHORTMAX     32767
#define INTMAX	     32767
#define LONGMAX      2147483647L
#define USHORTMAX    0xFFFF
#define UINTMAX      0xFFFF
#define ULONGMAX     0xFFFFFFFFL
#define SHORTSTRMAX  "32767"
#define INTSTRMAX    "32767"
#define LONGSTRMAX   "2147483647"
#define USHORTSTRMAX "65535"
#define UINTSTRMAX   "65535"
#define ULONGSTRMAX  "4294967295"
#define EXPMAX	     307

#define VPSTMAXLEN   133		/*buffer size for use with v_printf() */

/******************************************************************************/
/*  Constants defined for convenience					      */
/******************************************************************************/

#define TAB	     '\t'               /*C definition of ASCII tab           */
#define NEWLINE      '\n'               /*C definition of ASCII newline       */
#define BACKSPACE    '\b'               /*C definition of ASCII backspace     */
#define SPACE	     ' '                /*white space character               */

#define AS_NEEDED    -1 		/*unlimited scrolling allowed	      */
#define ALL_ROWS     -1 		/*scroll all rows		      */
#define LAST_ROW     -1
#define LAST_COL     -1
#define APPEND_ROW   -1 		/*for memory file insert and row rpl  */
#define CENTER_WN    -1 		/*centers the window on the screen    */
#define SHAD_WNSIZE  -1         	/*size the shadow by the window	      */
#define TRANSPARENT  (UCHAR) 0		/*transparent shadow character	      */

/*----------------------------------------------------------------------------*/
/*  Definitions for the table of initialization functions		      */
/*----------------------------------------------------------------------------*/
#define USERINIT     0			/*User				      */
#define SYSINIT      1			/*System			      */
#define DEBUGINIT    2			/*Debugging			      */
#define HELPINIT     3			/*Help				      */
#define CLISTINIT    4			/*Choice lists			      */
#define FORMINIT     5			/*Forms 			      */
#define DESIGNINIT   6			/*Designer form library initialization*/

/*----------------------------------------------------------------------------*/
/*  Definitions for string placement					      */
/*----------------------------------------------------------------------------*/
#define LEFT_TEXT     0 		/*left justfies text in window	      */
#define CENTER_TEXT  -1 		/*centers text in window	      */
#define RIGHT_TEXT   -2 		/*right justifies text in window      */

/*----------------------------------------------------------------------------*/
/*  Definitions for directions						      */
/*									      */
/*  Warning:  The values of the following symbols are essential for v_line()  */
/*            and shadows to function properly.	     			      */
/*----------------------------------------------------------------------------*/

#define RIGHT	     0x0000
#define LEFT	     0x0001
#define DOWN	     0x0002
#define UP	     0x0003

#define BOTTOM       DOWN
#define TOP          UP

#define X_LINE	     0x0004
#define X_LINEBDR    0x0008   

/*----------------------------------------------------------------------------*/
/*  Definitions for use in specifying position of the window border text      */
/*----------------------------------------------------------------------------*/
#define TOPLEFT      1
#define TOPCENTER    2
#define TOPRIGHT     3
#define BOTTOMLEFT   4
#define BOTTOMCENTER 5
#define BOTTOMRIGHT  6

/*----------------------------------------------------------------------------*/
/*  Definitions for window explosion origins                                  */
/*----------------------------------------------------------------------------*/

#define EXPBOT      1
#define EXPTOP      2
#define EXPCTRHORZ  3
#define EXPLFT      4
#define EXPBOTLFT   5
#define EXPTOPLFT   6
#define EXPLFTCTR   7
#define EXPRT       8
#define EXPBOTRT    9
#define EXPTOPRT   10
#define EXPRTCTR   11
#define EXPCTRVERT 12
#define EXPBOTCTR  13
#define EXPTOPCTR  14
#define EXPCTR     15

/*----------------------------------------------------------------------------*/
/*  Window Flag Masks							      */
/*----------------------------------------------------------------------------*/
#define WORDWRAP     0x00000001L	/*word-wrap			      */
#define CLRENDROW    0x00000002L	/*auto clear to end of row	      */
#define CSADVANCE    0x00000004L	/*auto cs advance		      */
#define CSRPLACE     0x00000008L	/*enable auto place of csr at cs      */
#define POPUP	     0x00000010L	/*window is pop-up		      */
#define BUFFERED     0x00000020L	/*window is buffered		      */
#define WNECHO       0x00000040L        /*echo window to the destination      */
#define INSIDE	     0x00000080L	/*window dimensions are inside	      */
#define SET	     0x00000100L	/*window is set 		      */
#define TRACKING     0x00000200L	/*track buffered wn with cs	      */
#define VSECHO       0x00000400L	/*enable video screen updating	      */
#define HEAP_WN      0x00000800L	/*window has been allocated from heap */
#define SBARAUTO     0x00001000L	/*auto update of scroll bars	      */
#define HSBAR	     0x00002000L	/*window has a horizontal scroll bar  */
#define VSBAR	     0x00004000L	/*window has a vertical scroll bar    */
/* #define AVAILABLE  0x00008000L   unused, available 			      */
#define GROWUP       0x00010000L        /*upward growth allowed               */
#define GROWDN       0x00020000L        /*downward growth allowed             */
#define GROWRT       0x00040000L        /*rightward growth allowed            */
#define GROWLFT      0x00080000L        /*leftward growth allowed             */

#define FULL	     (~INSIDE)		/*opposite of INSIDE as argument      */
#define HVSBAR	     (HSBAR | VSBAR)	/*window has both scroll bars	      */
#define GROWMASK     (GROWUP | GROWDN | GROWRT | GROWLFT)
#define GROWNORM     16                 /* normalization shift factor         */

/*----------------------------------------------------------------------------*/
/*  Scroll bar drawing flag masks					      */
/*----------------------------------------------------------------------------*/
#define NO_SBARCORNER  0x0001		/*corner character not drawn	      */
#define NO_VSBAR       0x0002		/*vertical scroll bar not drawn       */
#define NO_HSBAR       0x0004		/*horizontal scroll bar not drawn     */

/*----------------------------------------------------------------------------*/
/*  Memory File Flag Masks						      */
/*----------------------------------------------------------------------------*/
#define TOPBOTMSG      0x0001		/*top and bottom of file messages     */
#define INDEXING       0x0002		/*keyworded file indexing enabled     */

/*----------------------------------------------------------------------------*/
/*  Memory file keyword codes						      */
/*----------------------------------------------------------------------------*/
#define KWD_STATIC    'S'
#define KWD_MANUAL    'M'
#define KWD_AUTO      'A'

/*----------------------------------------------------------------------------*/
/*  Window Parts Definitions						      */
/*----------------------------------------------------------------------------*/
#define ENDROW	    -1			/*to the end of current row	      */
#define ENDCOL	    -2			/*to the end of column		      */
#define ENDWN	    -3			/*from current row to end of wn       */
#define ROW	    -4			/*current row			      */
#define COL	    -5			/*current column		      */
#define WN	    -6			/*the whole window		      */
#define CH	     6			/*character			      */
					/*CH is used also as a move source    */
					/*must be 6 to conform _vcscpy()      */

/*----------------------------------------------------------------------------*/
/*  Move Type Definitions (Sources)					      */
/*----------------------------------------------------------------------------*/
#define VID	     0			/*video screen			      */
#define VST	     1			/*video string			      */

#define STATT	     2			/*string with attribute 	      */
#define CHATT	     3			/*character with attribute	      */
#define ATT	     4			/*attribute only		      */
#define ST	     5			/*string without attribute	      */
/*	CH	     6	 character without attribute #defined above as a part */

/*----------------------------------------------------------------------------*/
/*  Move Destinations							      */
/*----------------------------------------------------------------------------*/
#define TO_VID	     0x0000		/*to the video screen		      */
#define TO_VST	     0x0008		/*to the video string in memory       */
#define TO_ST	     0x0010		/*to the text string in memory	      */

/*----------------------------------------------------------------------------*/
/*  Move Directions							      */
/*----------------------------------------------------------------------------*/
#define FROM_WN      0			/*from window to string 	      */
#define TO_WN	     1			/*to window from string 	      */

/*----------------------------------------------------------------------------*/
/*  Cursor shapes							      */
/*----------------------------------------------------------------------------*/
#define BOT_LINE     0			/* a line at the bottom 	      */
#define BLOCK	     1			/* a full block 		      */
#define BOT_BLOCK    2			/* a block in the bottom half of the  */
					/* character box		      */
#define TOP_BLOCK    3			/* a block in the top half of the     */
					/* character box		      */

/*----------------------------------------------------------------------------*/
/*  Definitions for beeps						      */
/*----------------------------------------------------------------------------*/
#define BPERROR     0			/*indexes in _beeps[]		      */
#define BPNOACTION  1
#define BPAUTOMOVE  2

#define BPSHORT     3			/*predefined beep durations in 1/100's*/
#define BPMEDIUM    10			/*of a second			      */
#define BPLONG	    30
#define BPBELL	    -1

#define BPLOW	    100 		/*predefined beep pitches in Hz       */
#define BPMIDDLE    500
#define BPHIGH	    1000

/*----------------------------------------------------------------------------*/
/*  Boolean values							      */
/*----------------------------------------------------------------------------*/
#define YES	     1
#define NO	     0
#define ON	     1
#define OFF	     0
#define TRUE	     1
#define FALSE	     0

/*----------------------------------------------------------------------------*/
/*  Scroll bar options							      */
/*----------------------------------------------------------------------------*/
#define AUTOUPD      (-1)
#define MANUALUPD    (-2)

/*----------------------------------------------------------------------------*/
/*  Predefined date formats for convenience				      */
/*----------------------------------------------------------------------------*/

#define US_DATE      "MM/DD/YY"         /*US format for date                  */
#define EURO_DATE    "DD/MM/YY"         /*EUROPEAN format for date            */


/******************************************************************************/
/*  User accessible global variables					      */
/******************************************************************************/
#define VV_ERR	     _vv_err		/*Global error code		      */
#define VID_ECHO     _vid_echo		/*Video screen echo flag	      */
#define WN_WNP       (&_wn_wn) 		/*Generic window template pointer     */
#define FULL_WNP     (&_fullwn) 	/*Full video screen window pointer    */
#define MSG_WNP      (&_msgwn)		/*Message window pointer	      */
#define CLIST_WNP    (&_clist_wn)	/*choice list window		      */
#define HELP_WNP     (_help_wnp)	/*Help window pointer		      */
#define VID_SCRP     (&_vid_scr)	/*Video screen pointer		      */
#define LATT_SYS     _latt		/*System logical attribute array      */
#define TRT_END      _trt_end		/*Translation table end marker	      */

#define SYSDATEFMT   _datefmtp		/*system default date format	      */
#define SYSTIMEFMT   _timefmtp		/*system default time format	      */

#define BEGTERMSTAT  0			/*Dummy beginning terminal state      */
#define VVTERMSTAT   0			/*Dummy initialized terminal state    */

/*----------------------------------------------------------------------------*/
/*  Window borders							      */
/*----------------------------------------------------------------------------*/
#define BDR_NULLP    (BORDERPTR) NULLP	/*No border			      */
#define BDR_SLNP     &_bdr_sln		/*Single line border		      */
#define BDR_DLNP     &_bdr_dln		/*Double line border		      */
#define BDR_SPACEP   &_bdr_space	/*Space border			      */
#define BDR_DOTP     &_bdr_dot		/*Dot border			      */
#define BDR_STARP    &_bdr_star 	/*Star border			      */
#define BDR_SOLIDP   &_bdr_solid	/*Solid block border		      */

/*----------------------------------------------------------------------------*/
/*  Line definitions							      */
/*----------------------------------------------------------------------------*/
#define LINE_SLNP     &_bdr_sln 	/*Single line			      */
#define LINE_DLNP     &_bdr_dln 	/*Double line			      */
#define LINE_SPACEP   &_bdr_space	/*Space line			      */
#define LINE_DOTP     &_bdr_dot 	/*Dot line			      */
#define LINE_STARP    &_bdr_star	/*Star line			      */
#define LINE_SOLIDP   &_bdr_solid	/*Solid block line		      */

/*----------------------------------------------------------------------------*/
/*  Options not to check for during the system initialization		      */
/*  Meaningful only under PCDOS, always defined for portability 	      */
/*----------------------------------------------------------------------------*/
#define MSW	     0x0100		/* Microsoft Windows/TopView	      */
#define CGA_RETRACE  0x0200		/* Waiting for retrace on CGA	      */
#define KB_EXTEND    0x0400		/* BIOS extended keyboard support     */
#define PS2	     0x0800		/* PS/2 line of machines	      */
#define DOS_EXTEND   0x1000		/* DOS extenders		      */

/******************************************************************************/
/*  PCDOS and OS2 specific definitions					      */
/******************************************************************************/

/*----------------------------------------------------------------------------*/
/* Block-graphics characters						      */
/*----------------------------------------------------------------------------*/
#define CH_LIGHTSHADE  178		/*lightest shading character	      */
#define CH_MEDSHADE    177		/*medium shading character	      */
#define CH_DARKSHADE   176		/*dark shading character	      */
#define CH_BLOCK       219		/*solid block character		      */
#define CH_BOTBLOCK    220		/*bottom halfblock		      */
#define CH_TOPBLOCK    223		/*top halfblock			      */
#define CH_LFTBLOCK    221		/*left halfblock		      */
#define CH_RTBLOCK     222		/*right halfblock		      */

#ifdef	NEC_PC9801
#define LNCHARMIN    143    /* 0x8f */  /*Minimum line character              */
#define LNCHARMAX    159    /* 0x9f */  /*Maximum line character              */
#define LNCHARMIN2   224    /* 0xe0 */  /*Minimum line character              */
#define LNCHARMAX2   227    /* 0xe3 */  /*Maximum line character              */
#define LNCHARQ      36                 /*Number of line characters defined   */
#define LNCHARQ2      4                 /*Number of line characters defined   */
#else	/* NEC_PC9801 */
#define LNCHARMIN      179		/*Minimum line character	      */
#define LNCHARMAX      218		/*Maximum line character	      */
#define LNCHARQ        40 		/*Number of line characters defined   */
#endif	/* NEC_PC9801 */

/*----------------------------------------------------------------------------*/
/*  Predefined video adapters						      */
/*----------------------------------------------------------------------------*/
#ifdef	NEC_PC9801
#define NEC98CGA     0x0100		/*PC9801 original (640x200) mode      */
#define NEC98EGA     0x0200		/*PC9801 normal (640x400) mode        */
#define NEC98VGA     0x0400		/*PC9801 hiresolution (1024x756) mode */
/* CORE 90.08.08 Test */
#define MDA	     0x0001		/*Monochrome Display Adapter	      */
#define CGA	     0x0002		/*Color Graphics Adapter	      */
#define EGA	     0x0004		/*Enhanced Ggaphics Adapter	      */
#define PGS	     0x0008		/*Professional Graphics System	      */
#define VGA	     0x0010		/*Video Graphics Array		      */
#define MCGA	     0x0020		/*Monochrome Color Graphics Array     */
#else	/* NEC_PC9801 */
#define MDA	     0x0001		/*Monochrome Display Adapter	      */
#define CGA	     0x0002		/*Color Graphics Adapter	      */
#define EGA	     0x0004		/*Enhanced Ggaphics Adapter	      */
#define PGS	     0x0008		/*Professional Graphics System	      */
#define VGA	     0x0010		/*Video Graphics Array		      */
#define MCGA	     0x0020		/*Monochrome Color Graphics Array     */
#endif	/* NEC_PC9801 */

/*----------------------------------------------------------------------------*/
/*  Attribute values for the Monochrome Adapter 			      */
/*----------------------------------------------------------------------------*/
#ifdef	NEC_PC9801
#define NORMAL       0xe1               /*attribute base state                */
#define UNDERLINE    0x08               /*       ditto                        */
#define REVERSE      0x04               /*       ditto                        */
#define HIGH_INT     0x00               /*attribute added state               */
					/*PC9801 dose not used High Light     */
#define BLINK        0x02               /*attribute added state               */
#else	/* NEC_PC9801 */
#define NORMAL	     0x07		/*attribute base state		      */
#define UNDERLINE    0x01		/*	 ditto			      */
#define REVERSE      0x70		/*	 ditto			      */
#define HIGH_INT     0x08		/*attribute added state 	      */
#define BLINK	     0x80		/*attribute added state 	      */
#endif	/* NEC_PC9801 */

/*----------------------------------------------------------------------------*/
/* Color attribute values for the Color Adapters			      */
/*----------------------------------------------------------------------------*/
#ifdef	NEC_PC9801
#define BLACK   0
#define BLUE    1
#define GREEN   4
#define CYAN    5
#define RED     2
#define MAGENTA 3
#define BROWN   6
#define WHITE   7

#define LIGHT   0     /* PC98XL light,yellow non support ??? */
#define YELLOW  6     /* = LIGHT + BROWN                    */
#else	/* NEC_PC9801 */
#define BLACK	     0x00
#define BLUE	     0x01
#define GREEN	     0x02
#define CYAN	     0x03
#define RED	     0x04
#define MAGENTA      0x05
#define BROWN	     0x06
#define WHITE	     0x07

#define LIGHT	     0x08
#define YELLOW	     (LIGHT | BROWN)
#endif	/* NEC_PC9801 */

/*----------------------------------------------------------------------------*/
/* Predefined video modes						      */
/*----------------------------------------------------------------------------*/
#define BW40	     0			/*40 columns monochrome 	      */
#define CO40	     1			/*40 columns color		      */
#define BW80	     2			/*80 columns monochrome 	      */
#define CO80	     3			/*80 columns color		      */
#define MONO	     7			/*Monochrome adapters		      */


/*----------------------------------------------------------------------------*/
/*  Definitions to set the alternative number of screen rows		      */
/*----------------------------------------------------------------------------*/
#define VSROWQ	     (_vid_scr.row_q)
#define ROWQ_25      25

/*----------------------------------------------------------------------------*/
/*  Definitions for the interrupts used in the system			      */
/*----------------------------------------------------------------------------*/
#ifdef	NEC_PC9801
#define DOS_INT      ((USHORT) 0x0021)             /*DOS interrupt       INT 21H         */
#define VI_INT       ((USHORT) 0x0018)             /*Video interrupt     INT 18H         */
#define KI_INT       ((USHORT) 0x0018)             /*Keyboard interrupt  INT 18H         */
#else	/* NEC_PC9801 */
#define DOS_INT      ((USHORT) 0x0021)	/*DOS interrupt       INT 21H	      */
#define VI_INT	     ((USHORT) 0x0010)	/*Video interrupt     INT 10H	      */
#define KI_INT	     ((USHORT) 0x0016)	/*Keyboard interrupt  INT 16H	      */
#endif	/* NEC_PC9801 */

/*----------------------------------------------------------------------------*/
/*  DOS extender types							      */
/*----------------------------------------------------------------------------*/
#define OS_PHARLAP  1
#define OS_E286     2
#define OS_E386     3
#define OS_E386HB   4



/******************************************************************************/
/*  End of PCDOS and OS2 specific definitions				      */
/******************************************************************************/



/******************************************************************************/
/*  Logical attribute definitions					      */
/******************************************************************************/

/*  Quantity of physical attribute alternatives per logical attribute	      */
#define PATTQ	     2


/*  Quantity of logical attributes					      */

/* MICROTEK, 08/08/90 modified */

/* #define LATTQ     42 */
#define LATTQ	     139

#define LSYS	     0			/*System shell screen attribute       */
#define LNORMAL      1			/*Normal text			      */
#define LREVERSE     2			/*Reverse text			      */
#define LHIGHLITE    3			/*Highlighted text		      */
#define LURGENT      4			/*Attention ! (blink)		      */
#define LHELP	     5			/*Help message			      */
#define LERROR	     6			/*Error message 		      */
#define LMESSAGE     7			/*Informational message 	      */
#define LFLDINACT    8			/*Inactive Field		      */
#define LFLDACT      9			/*Active Field			      */
#define LFLDSKIP     10 		/*Skip Field			      */
#define LMNINACT     11 		/*Inactive Menu Item		      */
#define LMNACT	     12 		/*Active Menu Item		      */
#define LMNUNAVAIL   13 		/*Unavailable Menu Item 	      */
#define LMNSELCH     14 		/*Selection Character		      */
#define LCLINACT     15 		/*Inactive choice		      */
#define LCLACT	     16 		/*Active choice 		      */
#define LMARK	     17 		/*Mark				      */
#define LNODISPLAY   18 		/*No display (noecho)		      */
#define LARROW	     19 		/*Scroll bar arrows		      */
#define LCORNER      20 		/*Scroll bar corner		      */
#define LPAGERGN     21 		/*Scroll bar page region	      */
#define LTHUMB	     22 		/*Scroll bar thumb		      */
#define LSHADOW	     23 		/*Window shadows		      */
#define LDEBUG	     24 		/*Debugging windows		      */
#define LDEBUGMSG    25 		/*Debug message windows 	      */
#define LBLACK	     26 		/*logical color attribute	      */
#define LBLUE	     27 		/*logical color attribute	      */
#define LGREEN	     28 		/*logical color attribute	      */
#define LCYAN	     29 		/*logical color attribute	      */
#define LRED	     30 		/*logical color attribute	      */
#define LMAGENTA     31 		/*logical color attribute	      */
#define LBROWN	     32 		/*logical color attribute	      */
#define LWHITE	     33 		/*logical color attribute	      */

/* MICROTEK, 08/08/90 modified */

/* #define LAVR1     34
#define LAVR2	     35
#define LAVR3	     36 */
#define LFORMS	     34 		/*reserved logical attribute	      */
#define LFLDACTON    35 		/*reserved logical attribute	      */
#define LFLDACTOFF   36 		/*reserved logical attribute	      */

#define LAVR4	     37 		/*reserved logical attribute	      */
#define LAVR5	     38 		/*reserved logical attribute	      */
#define LAVR6	     39 		/*reserved logical attribute	      */
#define LAVR7	     40 		/*reserved logical attribute	      */
#define LAVR8	     41 		/*reserved logical attribute	      */

/* MICROTEK, 08/08/90 added */

#define  LBLA_BLA  50
#define  LBLA_BLU  51
#define  LBLA_MAG  52
#define  LBLA_RED  53
#define  LBLA_WHI  54
#define  LBLA_BRO  55
#define  LBLA_CYA  56
#define  LBLA_GRE  57
#define  LBLA_YEL  58

#define  LBLU_BLA  60
#define  LBLU_BLU  61
#define  LBLU_MAG  62
#define  LBLU_RED  63
#define  LBLU_WHI  64
#define  LBLU_BRO  65
#define  LBLU_CYA  66
#define  LBLU_GRE  67
#define  LBLU_YEL  68

#define  LMAG_BLA  70
#define  LMAG_BLU  71
#define  LMAG_MAG  72
#define  LMAG_RED  73
#define  LMAG_WHI  74
#define  LMAG_BRO  75
#define  LMAG_CYA  76
#define  LMAG_GRE  77
#define  LMAG_YEL  78

#define  LRED_BLA  80
#define  LRED_BLU  81
#define  LRED_MAG  82
#define  LRED_RED  83
#define  LRED_WHI  84
#define  LRED_BRO  85
#define  LRED_CYA  86
#define  LRED_GRE  87
#define  LRED_YEL  88

#define  LWHI_BLA  90
#define  LWHI_BLU  91
#define  LWHI_MAG  92
#define  LWHI_RED  93
#define  LWHI_WHI  94
#define  LWHI_BRO  95
#define  LWHI_CYA  96
#define  LWHI_GRE  97
#define  LWHI_YEL  98

#define  LBRO_BLA  100
#define  LBRO_BLU  101
#define  LBRO_MAG  102
#define  LBRO_RED  103
#define  LBRO_WHI  104
#define  LBRO_BRO  105
#define  LBRO_CYA  106
#define  LBRO_GRE  107
#define  LBRO_YEL  108

#define  LCYA_BLA  110
#define  LCYA_BLU  111
#define  LCYA_MAG  112
#define  LCYA_RED  113
#define  LCYA_WHI  114
#define  LCYA_BRO  115
#define  LCYA_CYA  116
#define  LCYA_GRE  117
#define  LCYA_YEL  118

#define  LGRE_BLA  120
#define  LGRE_BLU  121
#define  LGRE_MAG  122
#define  LGRE_RED  123
#define  LGRE_WHI  124
#define  LGRE_BRO  125
#define  LGRE_CYA  126
#define  LGRE_GRE  127
#define  LGRE_YEL  128

#define  LYEL_BLA  130
#define  LYEL_BLU  131
#define  LYEL_MAG  132
#define  LYEL_RED  133
#define  LYEL_WHI  134
#define  LYEL_BRO  135
#define  LYEL_CYA  136
#define  LYEL_GRE  137
#define  LYEL_YEL  138

/******************************************************************************/
/*  Error message definitions for the error handling system		      */
/******************************************************************************/

/*  Designer librarian successful completion value			      */
#define SUCCESS      -1

/*  Quantity of VCS defined error codes used to set VV_ERR		      */
#define VCSERRQ      96

/*  Runtime errors							      */
#define MEMLACK       1 		/*Insufficient memory		      */
#define ERROPEN       2 		/*Error opening file		      */
#define ERRREAD       3 		/*Error reading file		      */
#define ERRWRITE      4 		/*Error writing file		      */
#define ERRCLOSE      5 		/*Error closing file		      */
#define ERRPOS	      6 		/*attempt to reposition file pointer  */
#define ERRPOPEN      7 		/*Error opening pipe		      */
#define ERRPCLOSE     8 		/*Error closing pipe		      */
#define FILETOOBIG    9 		/*Too many lines in file	      */
#define KWDNOTFOUND  10 		/*Keyword not found		      */
#define ERRNAME      11 		/*File could not be renamed	      */
#define DL_LIBCOR    12 		/*Library file or program is corrupted*/
#define FL_NLIB      13 		/*File is not a library file	      */
#define FL_NUNLOCKED 14 		/*File could not be unlocked	      */
#define DL_LOCKED    15 		/*Designer library locked	      */
#define DL_READONLY  16 		/*Attempt to open READONLY file for   */
					/*writing			      */

/*  Development only error codes					      */
#define BADWNSTRUC   17 		/*Corrupted WINDOW structure	      */
#define BADMFSTRUC   18 		/*Corrupted MFILE structure	      */
#define BADSCRSTRUC  19 		/*Corrupted SCR structure	      */
#define BADCLSTRUC   20 		/*Corrupted CLIST structure	      */
#define BADFMSTRUC   21 		/*Corrupted FORM structure	      */
#define BADMNSTRUC   22 		/*Corrupted MENU structure	      */
#define BADITEMSTRUC 23 		/*Corrupted item structure	      */
#define BADBGSTRUC   24 		/*Corrupted background structure      */
#define WNBORDERLESS 25 		/*Invalid op. on borderless window    */
#define WNISUP	     26 		/*Window is already up		      */
#define WNNOTUP      27 		/*Window is not up		      */
#define WNNOTDIRECT  28 		/*Window is not direct display	      */
#define WNNOTPOPUP   29 		/*Window is not a pop-up	      */
#define WNTOOBIG     30 		/*Window too big for the buffer       */
#define WNTOOSMALL   31 		/*Window is too small		      */
#define MFROWNEG     32 		/*Memory file row is negative	      */
#define MFROWTOOBIG  33 		/*Memory file row number is too large */
#define STRTOOLONG   34 		/*String too long		      */
#define FULLTABLE    35 		/*Function table full		      */
#define NOMFILEPTR   36 		/*No MFILE pointer installed in window*/
#define NOKTP	     37 		/*Keytable pointer cannot be a NULLP  */
#define NOWNIMAGE    38 		/*No window image saved 	      */
#define NOSUCHFLD    39 		/*Field does not exist		      */
#define NOSUCHITEM   40 		/*No item with this number on form    */
#define BADPTR	     41 		/*NULLP is not allowed		      */
#define BADPARM      42 		/*Bad parameter value		      */
#define BADWNCOORD   43 		/*Bad window coordinates	      */
#define BADLINECOORD 44 		/*Bad line coordinates		      */
#define BADBOXCOORD  45 		/*Bad box coordinates		      */
#define BADTEXTCOORD 46 		/*Bad text coordinates		      */
#define BADFLDCOORD  47 		/*Bad field coordinates 	      */
#define BADPRPTCOORD 48 		/*Bad prompt coordinates	      */
#define BADSRCOORD   49 		/*Bad scrollable region coordinates   */
#define BADMEMOCOORD 50 		/*Bad memo coordinates		      */
#define BADMENUCOORD 51 		/*Bad menu coordinates		      */
#define BADDATE      52 		/*Invalid date string		      */
#define BADTIME      53 		/*Invalid time string		      */
#define BADFORMAT    54 		/*Invalid date/time format string     */
#define BADCLITEM    55 		/*No item with this number in list    */
#define BADFMTYPE    56 		/*Wrong type of form to add field to  */
#define BADPIC	     57 		/*Bad picture			      */
#define BADROW	     58 		/*Bad row number		      */
#define BADCOL	     59 		/*Bad data column number	      */
#define FMISUP	     60 		/*Form is on screen		      */
#define FMNOTUP      61 		/*Form is not on screen 	      */
#define FMISREADY    62 		/*Cannot add fields to ready forms    */
#define FMEMPTY      63 		/*No active items on the form	      */
#define NOTDFIELD    64 		/*Data field expected		      */
#define NOTMEMOFLD   65 		/*Memo field expected		      */
#define NOPICSYMFUNC 66 		/*No picture symbol function	      */
#define BADFLDTYPE   67 		/*Illegal operation for this fld type */
#define NOSCROLLBAR  68 		/*This window has no scroll bars      */
#define NORGSETFUNC  69 		/*No range set function 	      */
#define FLDDISABLED  70 		/*Field type has not been enabled     */
#define SROWNOTVIS   71 		/*Scrollable row not visible	      */
#define DL_ACCERR    72 		/*Invalid access code		      */
#define DL_LOCKERR   73 		/*Lock_status parameter was not LOCK  */
#define DR_KEYERR    74 		/*Directory record key was a null     */
#define FL_EOFILE    75 		/*End of file has been reached	      */
#define FL_PRVLOCKED 76 		/*File locked by a previous user      */
#define FL_NFOUND    77 		/*File not found		      */
#define DL_RCNTYPE   78 		/*Record was not the requested type   */
#define DR_PRVLOCKED 79 		/*Dir record locked by previous user  */
#define DR_CURLOCKED 80 		/*Dir record locked by current user   */
#define DR_NFOUND    81 		/*Dir record not found		      */
#define DR_NLOCKED   82 		/*Dir record not locked 	      */
#define DL_EORECS    83 		/*End of directory records has been   */
#define DL_DATAERR   84 		/*Data len greater than max allowed   */
#define FL_BADPATH   85 		/*Specified drive/path nonexistent    */
#define FL_NPERM     86 		/*User doesn't have req. permissions  */
#define NOSUCHSR     87 		/*Scrollable region does not exist    */
#define NOSUCHFUNC   88 		/*Function name not in function list  */
#define FUNCNOTRES   89 		/*Functions have not been resolved    */
#define DATANOTRES   90 		/*Data pointers have not been resolved*/
#define CLISTNOTRES  91 		/*Choice lists have not been resolved */
#define FMISVVD      92 		/*Cannot make VVD form READY	      */
#define LIBNOTFOUND  93 		/*Library name not found	      */
#define FMNOTRES     94 		/*Form not resolved		      */
#define FMNOTFOUND   95 		/*Form not found in list	      */

/******************************************************************************/
/*  System informational message definitions				      */
/******************************************************************************/

/*  Quantity of VCS informational messages				      */
#define VCSINFOQ     24

					/*reserve 0 for no message	      */
#define INITMEMLACK  1			/*Insufficient memory to initialize   */
#define ERR_OVVTC    2			/*Error opening VVTERMCAP file	      */
#define TERMNOTFOUND 3			/*No terminal description found       */
#define TERMTOOLONG  4			/*Terminal description too long       */
#define NOTERM	     5			/*Unable to determine terminal type   */
#define NODUMBTERM   6			/*VV cannot use a dumb terminal       */
#define BADTERMDEF   7			/*Bad terminal description	      */
#define NOCHANNEL    8			/*Unable to open IO channel	      */
#define ERR_QIO      9			/*QIO system service error	      */
#define HELPSTR      10 		/*Default help string		      */
#define TOFMSG	     11 		/*Top of memory file message	      */
#define BOFMSG	     12 		/*Bottom of memory file message       */
#define AM_STRING    13 		/*AM string			      */
#define PM_STRING    14 		/*PM string			      */
#define EXHELPMSG    15 		/*Press <Return> or <ESC> to exit help*/
#define SCRLHELPMSG  16 		/*Use cursor pad keys to scroll       */
#define EXITFORMMSG  17 		/*Do you want to exit this form       */
#define QUITFORMMSG  18 		/*Do you want to quit this form       */
#define EXCLISTMSG   19 		/*Cursor keys to ... exit choice menu */
#define DATA_HELP    20 		/*Data form default help string       */
#define SCROLL_HELP  21 		/*Scrollable subform help string      */
#define MENU_HELP    22 		/*Menu form help string 	      */
#define NOVIRVB      23 		/*No virtual video buffer	      */


/******************************************************************************/
/*									      */
/*  Data structure definitions						      */
/*									      */
/******************************************************************************/

/*----------------------------------------------------------------------------*/
/*  Major structure tags						      */
/*----------------------------------------------------------------------------*/
#define MF_TAG	     (((UINT) 'F' << 8) + 'M')
#define WN_TAG	     (((UINT) 'N' << 8) + 'W')
#define SCR_TAG      (((UINT) 'C' << 8) + 'S')
#define VIEW_TAG     (((UINT) 'W' << 8) + 'V')
#define HELP_TAG     (((UINT) 'P' << 8) + 'H')
#define CL_TAG	     (((UINT) 'L' << 8) + 'C')


typedef struct node_struct		/*NODE STRUCTURE		      */
{
    struct node_struct *prev_ndp;	/*previous node pointer 	      */
    struct node_struct *next_ndp;	/*next node pointer		      */
    PTR datap;				/*data pointer			      */
} NODE, *NODEPTR;

/* Note:								      */
/* A generic linked list node structure, which contains only previous and     */
/* next node pointers and a generic pointer can be cast to any desired type   */
/* to contain any data information.					      */

typedef struct border_struct		/*BORDER AND LINE STRUCTURE	      */
{
    UCHAR up_ch;			/*upper horizontal character	      */
    UCHAR low_ch;			/*lower horizontal character	      */
    UCHAR lft_ch;			/*left vertical character	      */
    UCHAR rt_ch;			/*right vertical character	      */
    UCHAR uplft_ch;			/*upper left corner character	      */
    UCHAR uprt_ch;			/*upper right corner character	      */
    UCHAR lowrt_ch;			/*lower right corner character	      */
    UCHAR lowlft_ch;			/*lower left corner character	      */
} BORDER, *BORDERPTR, *LINEPTR;

/* Note:								      */
/* The memory file structure and the memory file line structure may be	      */
/* substantialy changed in the next release. We strongly recommend to avoid   */
/* accessing the members of those structures directly.			      */

typedef struct mfline_struct		/*MEMORY FILE LINE STRUCTURE	      */
{
    UINT line_len;			/*length of a memory file line	      */
    UCHAR *line_st;			/*pointer to line string	      */
} MFLINE, *MFLINEPTR;

typedef struct mfkwd_struct		/*MEMORY FILE KEYWORD LINE STRUCTURE  */
{
    UINT line_len;			/*length of a memory file line	      */
    UCHAR *line_st;			/*pointer to line string	      */
    int sln_q;				/*section line quantity 	      */
    long file_offset;			/*offset in the disk file	      */
} MFKWD, *MFKWDPTR;

typedef struct mfile_struct		/*MEMORY FILE STRUCTURE 	      */
{
    UINT tag;				/*sentinel			      */
    UCHAR *fn;				/*file specifier		      */
    MFLINEPTR *farray;			/*pointer to the array of MFLINEPTR's */
    int fmaxline;			/*maximum number of lines allowed     */
    int fmaxcol;			/*maximum nuber of columns allowed    */
    int ln_q;				/*number of lines in file, including  */
					/*EOF (NULLP) line		      */
    int c_q;				/*max number of columns, equal to     */
					/*max length of line, including '\n'  */
    int flag;				/*memory file flags		      */
    UCHAR *kwdp;			/*keyword pointer		      */
    int vln_beg;			/*number of beginning line of the     */
					/*view section			      */
    int vln_q;				/*view section line quantity	      */
    int vc_q;				/*view section max line length	      */
    UCHAR * buf;			/*line buffer for keyworded files     */
    FILE * fp;				/*file pointer for keyworded files    */
} MFILE, *MFILEPTR;

typedef struct scr_struct		/*SCREEN STRUCTURE		      */
{
    UINT tag;				/*sentinel			      */
    int type;				/*move type destination 	      */
    int row_q;				/*row quantity			      */
    int col_q;				/*column quantity		      */
    UCHAR clratt;			/*clear attribute		      */
    UCHAR dummy;			/*word alignment dummy byte	      */
    UCHAR FAR *vbufp;			/*pointer to the screen buffer	      */
} SCR, *SCRPTR;

typedef struct sbar_struct		/*SCROLL BAR STRUCTURE		      */
{
    ULONG flags;			/*scroll bar flags		      */
    int hmin;				/*the horizontal range minimum	      */
    int hmax;				/*the horizontal range maximum	      */
    int hval;				/*the horizontal current value	      */
    int vmin;				/*the vertical range minimum	      */
    int vmax;				/*the vertical range maximum	      */
    int vval;				/*the vertical current value	      */
} SBAR, * SBARP;

typedef struct shadow_struct		/*SHADOW STRUCTURE		      */
{
    UINT flags;				/*shadow structure flags	      */
    int offset;				/*position relative to window	      */
    int len;				/*lenght of the shadow		      */
    int width;				/*width of the shadow		      */
    UCHAR att;				/*shadow attribute		      */
    UCHAR fillchar;			/*shadow fill character		      */
    UCHAR *savebufp;			/*underlying image storage	      */
} SHADOW, *SHADOWPTR;

typedef struct window_struct		/*WINDOW STRUCTURE		      */
{
    UINT tag;				/*sentinel			      */
    int id;				/*id number			      */
    int rb;				/*top row of window		      */
    int re;				/*bottom row of window		      */
    int cb;				/*left hand column of window	      */
    int ce;				/*right hand column of window	      */
    int r;				/*virtual cursor row-position	      */
    int c;				/*virtual cursor column-position      */
    int scrl_q; 			/*max number of lines to scroll       */
    int lft_mg; 			/*left margin			      */
    int rt_mg;				/*right margin			      */
    int top_mg; 			/*top margin			      */
    int bot_mg; 			/*bottom margin 		      */
    UCHAR *lattarray;			/*pointer to logical attribute array  */
    UCHAR att;				/*window video attribute	      */
    UCHAR bdratt;			/*video attribute attribute of border */
    BORDERPTR bdrp;			/*pointer to border struct	      */
    int vidpage;			/*graphics-card alpha mode page #     */
    ULONG flags;              	        /*window flags			      */
    int row_org;			/*origin row coordinate 	      */
    int col_org;			/*origin column coordinate	      */
    int horzscrlq;			/*horizontal scrolling quantity       */
    int vertscrlq;			/*vertical scrolling quantity	      */
    SCRPTR bufp;			/*buffer screen pointer 	      */
    SCRPTR destp;			/*destination screen pointer	      */
    MFILEPTR mfp;			/*memory file pointer		      */
    UCHAR *storp;			/*pointer to window storage	      */
    UCHAR *pop_storp;			/*pointer to pop-up window storage    */
    UCHAR *title;			/*pointer to window title	      */
    int titleloc;			/*location of window title	      */
    UCHAR titleatt;			/*attribute of window title	      */
    UCHAR dummy;			/*word alignment dummy variable       */
    SBARP sbarp;			/*scroll bar structure		      */
    KEYFP upfp;				/*pointer to set function	      */
    KEYFP dnfp;				/*pointer to unset function	      */
    SHADOW (*shadp)[2];			/*pointer to array of shadows	      */
    PTR userp[2];			/*two pointers reserved for users     */
} WINDOW, *WINDOWPTR;

typedef struct beep_struct		/*BEEP STRUCTURE		      */
{
    int duration;			/*duration of beep (1/100's of sec)   */
    int pitch;				/*pitch of beep (Hz)		      */
} BEEP, *BEEPPTR;

typedef struct vidio_struct		/*8086 REGISTER STRUCTURE	      */
{
    UINT ax, bx, cx, dx, si, di;
    USHORT es, ds;
} VIDIO, *VIDIOPTR;

typedef struct chext_struct		/*Extended characters conv. table     */
{
    UCHAR ch;
    UCHAR type;
} CHEXT;

typedef struct kt_struct		/*KEY TABLE STRUCTURE		      */
{
    int keycode;			/*key code value		      */
    KEYFP fp;				/*pointer to function to execute      */
} KT, *KTPTR;

typedef struct keyctrl_struct		/*KEYFUNCTION CONTROL STRUCTURE       */
{
    UINT tag;				/*structure tag 		      */
    WINDOWPTR wnp;			/*window pointer		      */
    int nextact;			/*next action code		      */
} KEYCTRL, *KEYCTRLPTR;

typedef struct help_struct		/*HELP STRUCTURE		      */
{
    UINT tag;				/*structure tag 		      */
    WINDOWPTR wnp;			/*window pointer		      */
    int nextact;			/*next action code		      */
    UCHAR *kwdp;			/*pointer to keyword string	      */
    struct help_struct *nexthelp;	/*pointer to next help structure      */
} HELP, *HELPPTR;

typedef struct clist_struct		/*CHOICE LIST STRUCTURE 	      */
{
    UINT tag;				/*structure tag 		      */
    WINDOWPTR wnp;			/*choice list window pointer	      */
    int nextact;			/*next action code		      */
    UCHAR *kwdp;			/*keyword associated with field       */
    int flags;				/*choice list flags		      */
    UCHAR *help;			/*choice list help keyword or message */
    UCHAR *fm_help;			/*form help keyword or message	      */
    int itemnum;			/*starting line in the list file      */
    int len;				/*length of highlight bar	      */
    UCHAR act_att;			/*attribute of highlight bar	      */
    UCHAR dummy;			/*word alignment dummy variable       */
} CLIST, *CLISTPTR;


/*----------------------------------------------------------------------------*/
/*  Operating system specific structures				      */
/*----------------------------------------------------------------------------*/


					/*TERMINAL CHARACTERISTICS STRUCTURE  */



typedef int TERMSTAT, *TERMSTATPTR;	/*dummy TERMSTAT definition for PCDOS */



/******************************************************************************/
/*									      */
/*  Function-like macros						      */
/*									      */
/******************************************************************************/


/* standard beep							      */

#define bell()			   (beep_vv(BPBELL, BPBELL))


/* build color physical attribute value from two colors 		      */

#ifdef	NEC_PC9801
#define catt_def98(fg, att)        ((fg << 5) | (att) | 0x01 )
#define catt_def(fg, att)          (fg << 5)
#else	/* NEC_PC9801 */
#define catt_def(fg, bg)	   (((UCHAR) (bg) << 4) + (UCHAR) (fg))
#endif	/* NEC_PC9801 */


/* test if cursor visible						      */

#define csr_isvisible() 	   (_csrvis)


/* move the virtual cursor						      */

#define cs_mv(row, col, wnp)	   ((wnp)->r = (row)), ((wnp)->c = (col))


/*  macros used for debugging and error handling system 		      */

#ifdef NO_DEBUG_CODE
#define INIT_MODULE(p)
#define EXIT_MODULE(p) if (_vv_err) (*_errfp)(p)
#define EXIT_NOERRH(p)
#else
#define INIT_MODULE(p) (*_finitfp)(p)
#define EXIT_MODULE(p) if (_vv_err) (*_errfp)(p); (*_fexitfp)(p)
#define EXIT_NOERRH(p) (*_fexitfp)(p)
#endif


/* set no initial checking for special hardware and software		      */

#define init_nochk(opt) 	   (_vnochk |= (opt))


/* maximum and minimum values						      */

#ifndef max
#define max(a, b)		   ((a) >= (b) ? (a) : (b))
#endif

#ifndef min
#define min(a, b)		   ((a) <= (b) ? (a) : (b))
#endif


/* number of columns of a memory file					      */

#define mf_colq(mfp)		   ((mfp)->vc_q)


/* number of rows of a memory file					      */

#define mf_rowq(mfp)		   ((mfp)->vln_q)


/* assign the clear attribute to a memory screen			      */

#define ms_clratt(att, scrp)	   ((scrp)->clratt = (att))


/* number of columns of a memory screen 				      */

#define ms_colq(scrp)		   ((scrp)->col_q)


/* free a memory screen 						      */

#define ms_free(scrp)		   (mem_free((PTR) scrp))


/* number of rows of a memory screen					      */

#define ms_rowq(scrp)		   ((scrp)->row_q)


/* linked list macros							      */

#define nd_next(nodep)		   ((nodep)->next_ndp)
#define nd_prev(nodep)		   ((nodep)->prev_ndp)
#define nd_first(headp) 	   ((headp)->next_ndp)
#define nd_last(headp)		   ((headp)->prev_ndp)

/* set the various beep durations and pitches				      */

#define se_beeps(i, d, p)	   (_beeps[(i)].duration = (d),\
_beeps[(i)].pitch = (p))

/*  Set the system date format						      */

#define se_datefmt(p)		   (SYSDATEFMT = (UCHAR *) (p))

/*  set the index file extension string                                       */

#define se_indext(p)               (_indext = (UCHAR *) (p))

/* install user initialization function 				      */

#define se_initfp(p)		   (_inittbl[USERINIT] = (p))


/* set memory file keyword character					      */

#define se_kwdch(c)		   (_kwdch = (UCHAR) (c))


/* set memory file keyword delimiter					      */

#define se_kwddelim(c)		   (_kwddelim = (UCHAR) (c))


/* set the printer configuration					      */

#define se_printer(nm, md)	   (_printname = (UCHAR *) (nm)), \
(_printmode = (UCHAR *) (md))


/* set VV response characters						      */

#define se_responsech(true, false) (_vv_yes = (true)), (_vv_no = (false))


/* set the number of spaces per tab for the string output functions	      */

#define se_tabq(a)		   (_vv_tabq = (a))


/*  set the system time format						      */

#define se_timefmt(p)		   (SYSTIMEFMT = (UCHAR *) (p))


/*  set string translation delimiters					      */

#define se_trdelim(beg, end)	   (_tr_beg = (UCHAR *) (beg)), \
(_tr_end = (UCHAR *) (end))


/*  set scroll bar globals						      */

#define se_sbch(c, u, d, l, r, p, t)  (_sbcorner = (c)), (_sbuparrow = (u)), \
(_sbdnarrow = (d)), (_sblftarrow = (l)), (_sbrtarrow = (r)), \
(_sbpagergn = (p)), (_sbthumb = (t))


#define se_sbcoversize(a)	  (_sbcoversize = (a))


/* set the animation step quantity                                            */

#define se_wnsetstepq(i) (_wnsetstepq = (i))


/*  turn ON/OFF terminal software handshaking flag			      */

#define se_xonflag(a)


/*  remove window shadows  						      */

#define shad_dn(wnp)		   (_shad_updn(DOWN, (wnp)))


/*  display window shadows    						      */

#define shad_up(wnp)		   (_shad_updn(UP, (wnp)))


/*  set a memory file option						      */

#define smf_opt(o, s, p)           ((s) ? ((p)->flag |= (o)) :\
((p)->flag &= ~(o)))


/*  macros for setting members of the window structure			      */

#define sw_att(attribute, wnp)	   ((wnp)->att = (attribute))

#define sw_bdratt(att, wnp)	   ((wnp)->bdratt = (att))

#define sw_latt(a, wnp) 	   ((wnp)->lattarray = (a))

#define sw_opt(o, s, p)            ((s) ? ((p)->flags |= (o)) :\
((p)->flags &= ~(o)))

#define sw_scrlq(a, wnp)	   ((wnp)->scrl_q = (a))

#define sw_title(stp, att, loc, wnp) ((wnp)->title = (UCHAR *) (stp), \
(wnp)->titleatt = (att), (wnp)->titleloc = (loc))

#define sw_updnfp(u, d, wnp)	   ((wnp)->upfp = (KEYFP) (u), \
(wnp)->dnfp = (KEYFP) (d))

#define sw_userp(p, wnp)	   ((wnp)->userp[0] = (PTR) (p))

#define sw_vidpage(vpage, wnp)	   ((wnp)->vidpage = (vpage))


/* free a string translation table					      */

#define trt_free(trtp)		   (mem_free((PTR) trtp))


/* return video display adapter used					      */

#define vid_adapter()		   (_vda)


/* call video interrupt 						      */

#define vid_int(vrip, vrop)	   (_sys_int(VI_INT, (vrip), (vrop)))


/* assign the clear attribute to the video screen			      */

#define vs_clratt(att)		   (_vid_scr.clratt = (att))


/* number of rows and columns of the video screen in the current mode	      */

#define vs_colq()		   (_vid_scr.col_q)

#define vs_rowq()		   (_vid_scr.row_q)


/* update the whole video screen					      */

#define vs_upd()		   (vs_updrgn(0, 0, LAST_ROW, LAST_COL))


/* maximum column number in window					      */

#define wn_collimit(wnp)	   ((wnp)->flags & BUFFERED ? (wnp)->bufp->\
col_q - 1 : (wnp)->ce - (wnp)->cb)


/* number of columns in window						      */

#define wn_colq(wnp)		   ((wnp)->ce - (wnp)->cb + 1)


/* take the window off the screen					      */

#define wn_dn(wnp)                 (*(wnp)->dnfp)(wnp)


/* test if window is set						      */

#define wn_isup(wnp)		   ((wnp)->flags & SET) 


/* maximum row number in window 					      */

#define wn_rowlimit(wnp)	   ((wnp)->flags & BUFFERED ? (wnp)->bufp->\
row_q - 1 : (wnp)->re - (wnp)->rb)


/* number of rows in window						      */

#define wn_rowq(wnp)		   ((wnp)->re - (wnp)->rb + 1)


/* put the window up on the screen					      */

#define wn_up(wnp)                 (*(wnp)->upfp)(wnp)


/* update window							      */

#define wn_upd(wnp)		   (wn_updrgn(0, 0, LAST_COL, LAST_ROW, (wnp)))


/* window user pointer							      */

#define wn_userp(wnp)		   ((wnp)->userp[0])


/* absolute value							      */

#define _abs(n) 		   ((n) > 0 ? (n) : -(n))


/* high and low byte of word						      */

#define _byte_high(a)		   (((a) >> 8) & 0x00FF)

#define _byte_low(a)		   ((a) & 0x00FF)


/*  manufacture a far pointer from offset and segment			      */

#define _sotofar(farp, off, seg)   \
((*(((USHORT *)&farp) + sizeof(UINT)/sizeof(USHORT)) = (USHORT) seg),\
(*(UINT *)&farp = (UINT)(off)))


/* high and low word of longword					      */

#define _word_high(a)		   (((a) >> 16) & 0x0000FFFFL)

#define _word_low(a)		   ((a) & 0x0000FFFFL)


/* obsolete macros to be removed in v2.1				      */

#define swb_echo(a, wnp)	   ((wnp)->flags = ((a) ? (wnp)->flags\
| WNECHO : (wnp)->flags & ~WNECHO))

#define swb_track(a, wnp)	   ((wnp)->flags = ((a) ? (wnp)->flags\
| TRACKING : (wnp)->flags & ~TRACKING))

#define sw_clreor(a, wnp)	   ((wnp)->flags = ((a) ? (wnp)->flags\
| CLRENDROW : (wnp)->flags & ~CLRENDROW))

#define sw_csadv(a, wnp)	   ((wnp)->flags = ((a) ? (wnp)->flags\
| CSADVANCE : (wnp)->flags & ~CSADVANCE))

#define sw_csrpl(a, wnp)	   ((wnp)->flags = ((a) ? (wnp)->flags\
| CSRPLACE : (wnp)->flags & ~CSRPLACE))

#define sw_popup(a, wnp)	   ((wnp)->flags = ((a) ? (wnp)->flags\
| POPUP : (wnp)->flags & ~POPUP))

#define sw_vsecho(a, wnp)	   ((wnp)->flags = ((a) ? (wnp)->flags\
| VSECHO : (wnp)->flags & ~VSECHO))

#define sw_wwrap(a, wnp)	   ((wnp)->flags = ((a) ? (wnp)->flags\
| WORDWRAP : (wnp)->flags & ~WORDWRAP))

#define mf_msg(a, mfp)		   ((mfp)->flag = ((a) ? (mfp)->flag\
| TOPBOTMSG : (mfp)->flag & ~TOPBOTMSG))


/******************************************************************************/
/*									      */
/*  Extern declaration for the system global variables			      */
/*									      */
/******************************************************************************/


EXTERN UCHAR _latt[];
EXTERN UCHAR _att_tbl[][PATTQ];
EXTERN CHEXT _chsettbl[];
EXTERN UCHAR *_months[];
EXTERN UCHAR _derrmsg[];
EXTERN BEEP _beeps[];
EXTERN UCHAR *_trt_end;
EXTERN UCHAR *_tr_beg;
EXTERN UCHAR *_tr_end;
EXTERN UCHAR *_dbdumpp;
EXTERN UCHAR *_datefmtp;
EXTERN UCHAR *_timefmtp;
EXTERN UCHAR *_printname;
EXTERN UCHAR *_printmode;
EXTERN BORDER _bdr_space, _bdr_star, _bdr_dot, _bdr_dln, _bdr_sln, _bdr_solid;
EXTERN WINDOW _clist_wn, _fullwn, _vcswn, _msgwn, _wn_wn, _helpwn;
EXTERN WINDOWPTR _help_wnp;
EXTERN SCR _vid_scr;
EXTERN UCHAR _vv_yes, _vv_no, _kwdch, _kwddelim;
EXTERN int _lattsw, _attrowq, _attcolq, _chsetext, _v_mode, _vid_echo;
EXTERN int _vv_err, _vpstlen, _vv_tabq, _vv_init, _csrvis, _vpbytes;
EXTERN int _wnsize, _scrsize, _mfsize, _hiderow, _hidecol, _sbarsize;
EXTERN UCHAR _sbuparrow, _sbdnarrow, _sblftarrow, _sbrtarrow, _sbcorner;
EXTERN UCHAR _sbpagergn, _sbthumb;
EXTERN int   _sbcoversize;
EXTERN UCHAR * _indext;
EXTERN short _wnsetstepq;
EXTERN ULONG _wnsteppause;

#ifdef	NEC_PC9801
EXTERN UCHAR _linecode2[];
#endif	/* NEC_PC9801 */
EXTERN UCHAR _linecode[];
EXTERN int _vda, _vnochk;
EXTERN UCHAR _v_retr;
EXTERN UCHAR _kb_ext;
EXTERN UINT _dos_extender;
EXTERN UCHAR FAR * _bios_seg;
EXTERN USHORT _code_mask;
EXTERN USHORT _vid_segs[][2];
EXTERN UINT FAR * _breaksp;
EXTERN USHORT _timer_scale;
EXTERN USHORT _vert_retrace;

/******************************************************************************/
/* for PC9801 save window
/******************************************************************************/
#ifdef	NEC_PC9801
EXTERN int use_vm_swap;
EXTERN int grph_enable;
#endif	/* NEC_PC9801 */



/******************************************************************************/
/*									      */
/*  Function prototypes and externals					      */
/*									      */
/******************************************************************************/


#ifdef LINT_ARGS

PROTOTYPE void FASTCALL abort_vv(void);
PROTOTYPE void FASTCALL beep_vv(int, int);
PROTOTYPE int FASTCALL ch_isalpha(UCHAR);
PROTOTYPE int FASTCALL ch_isdigit(UCHAR);
PROTOTYPE int FASTCALL ch_islower(UCHAR);
PROTOTYPE int FASTCALL ch_isspace(UCHAR);
PROTOTYPE int FASTCALL ch_istxt(UCHAR);
PROTOTYPE int FASTCALL ch_isupper(UCHAR);
PROTOTYPE UCHAR FASTCALL ch_tolower(UCHAR);
PROTOTYPE UCHAR FASTCALL ch_toupper(UCHAR);
PROTOTYPE void FASTCALL csr_hide(void);
PROTOTYPE void FASTCALL csr_mv(int, int);
PROTOTYPE int FASTCALL csr_mvwn(int, int, WINDOWPTR);
PROTOTYPE int FASTCALL csr_plwn(WINDOWPTR);
PROTOTYPE void FASTCALL csr_rd(int *, int *);
PROTOTYPE void FASTCALL csr_show(void);
PROTOTYPE void FASTCALL csr_type(int);
PROTOTYPE int FASTCALL cs_adj(WINDOWPTR);
PROTOTYPE long FASTCALL date_diff(UCHAR *, UCHAR *, UCHAR *);
PROTOTYPE int FASTCALL date_frjul(UCHAR *, long, UCHAR *);
PROTOTYPE int FASTCALL date_frnums(UCHAR *, int, int, int, UCHAR *);
PROTOTYPE int FASTCALL date_get(UCHAR *, UCHAR *);
PROTOTYPE int FASTCALL date_isleapyr(int);
PROTOTYPE int FASTCALL date_tonums(UCHAR *, int *, int *, int *, UCHAR *);
PROTOTYPE long FASTCALL date_tojul(UCHAR *, UCHAR *);
PROTOTYPE void FASTCALL exit_err(UCHAR *, UCHAR *);
PROTOTYPE void FASTCALL exit_vv(void);
PROTOTYPE void FASTCALL init_vv(void);
PROTOTYPE int FASTCALL latt_init(int, int, int, UCHAR *, UCHAR *);
PROTOTYPE void FASTCALL latt_rpl(UCHAR, UCHAR, UCHAR, UCHAR, UCHAR *);
PROTOTYPE void FASTCALL mem_free(PTR);
PROTOTYPE PTR FASTCALL mem_get(UINT);
PROTOTYPE UCHAR * FASTCALL mem_stblank(UINT);
PROTOTYPE int FASTCALL mf_clr(MFILEPTR);
PROTOTYPE MFILEPTR FASTCALL mf_def(int, int);
PROTOTYPE void FASTCALL mf_disp(WINDOWPTR);
PROTOTYPE void FASTCALL mf_free(MFILEPTR);
PROTOTYPE int FASTCALL mf_kwdload(UCHAR *, MFILEPTR);
PROTOTYPE int FASTCALL mf_kwdset(UCHAR *, MFILEPTR);
PROTOTYPE int FASTCALL mf_kwdunload(UCHAR *, MFILEPTR);
PROTOTYPE int FASTCALL mf_print(MFILEPTR);
PROTOTYPE int FASTCALL mf_rd(UCHAR *, MFILEPTR);
PROTOTYPE void FASTCALL mf_rowdel(int, MFILEPTR);
PROTOTYPE void FASTCALL mf_rowget(UCHAR *, int, MFILEPTR);
PROTOTYPE int FASTCALL mf_rowins(UCHAR *, int, MFILEPTR);
PROTOTYPE int FASTCALL mf_rowlen(int, MFILEPTR);
PROTOTYPE UCHAR * FASTCALL mf_rowp(int, MFILEPTR);
PROTOTYPE int FASTCALL mf_rowrpl(UCHAR *, int, MFILEPTR);
PROTOTYPE int FASTCALL mf_scrl(int, int, int, MFILEPTR);
PROTOTYPE int FASTCALL mf_search(UCHAR *, int, MFILEPTR);
PROTOTYPE int FASTCALL mf_sort(UCHAR *, MFILEPTR);
PROTOTYPE int FASTCALL mf_wr(UCHAR *, UCHAR *, MFILEPTR);
PROTOTYPE void FASTCALL ms_clr(SCRPTR);
PROTOTYPE SCRPTR FASTCALL ms_def(int, int, UCHAR);
PROTOTYPE int FASTCALL ms_print(SCRPTR);
PROTOTYPE int FASTCALL ms_rd(UCHAR *, SCRPTR);
PROTOTYPE int FASTCALL ms_wr(UCHAR *, UCHAR *, SCRPTR);
PROTOTYPE void FASTCALL nd_del(NODEPTR);
PROTOTYPE NODEPTR FASTCALL nd_inithd(void);
PROTOTYPE NODEPTR FASTCALL nd_ins(NODEPTR, UINT);
PROTOTYPE NODEPTR FASTCALL nd_numptr(int, NODEPTR);
PROTOTYPE int FASTCALL nd_ptrnum(NODEPTR, NODEPTR);
PROTOTYPE void CDECL re_breakfp(void);
PROTOTYPE void FASTCALL se_abortfp(ISVRP);
PROTOTYPE void FASTCALL se_breakfp(ISVRP, UINT *);
PROTOTYPE int FASTCALL shad_def(UCHAR, UCHAR, UINT, int, int, int, WINDOWPTR);
PROTOTYPE UCHAR * FASTCALL stp_begtxt(UCHAR *);
PROTOTYPE UCHAR * FASTCALL stp_endtxt(UCHAR *);
PROTOTYPE UCHAR * FASTCALL stp_find(UCHAR *, UCHAR *);
PROTOTYPE void FASTCALL st_delch(UCHAR *, UINT);
PROTOTYPE void FASTCALL st_delembwh(UCHAR *);
PROTOTYPE void FASTCALL st_delendwh(UCHAR *);
PROTOTYPE int FASTCALL st_extract(UCHAR *, UCHAR *, UINT, UINT);
PROTOTYPE UINT FASTCALL st_frint(int, UCHAR *);
PROTOTYPE UINT FASTCALL st_frlong(long, UCHAR *);
PROTOTYPE UINT FASTCALL st_frshort(short, UCHAR *);
PROTOTYPE void FASTCALL st_ins(UCHAR *, UCHAR *, UINT);
PROTOTYPE void FASTCALL st_insch(UCHAR, UINT, UCHAR *, UINT);
PROTOTYPE int FASTCALL st_isblank(UCHAR *);
PROTOTYPE void FASTCALL st_lft(UCHAR *, UINT, UINT);
PROTOTYPE void FASTCALL st_lftadj(UCHAR *);
PROTOTYPE void FASTCALL st_padblank(UCHAR *, UINT);
PROTOTYPE int FASTCALL st_rd(FILE *, UCHAR *, int, UCHAR, int);
PROTOTYPE UINT FASTCALL st_rev(UCHAR *);
PROTOTYPE void FASTCALL st_rt(UCHAR *, UINT, UINT);
PROTOTYPE void FASTCALL st_rtadj(UCHAR *);
PROTOTYPE void FASTCALL st_tolower(UCHAR *);
PROTOTYPE short FASTCALL st_toshort(UCHAR *);
PROTOTYPE void FASTCALL st_toupper(UCHAR *);
PROTOTYPE int FASTCALL st_wr(FILE *, UCHAR *);
PROTOTYPE void FASTCALL sw_adjq(int, int, WINDOWPTR);
PROTOTYPE void FASTCALL sw_bdr(BORDERPTR, WINDOWPTR);
PROTOTYPE void FASTCALL sw_dest(SCRPTR, WINDOWPTR);
PROTOTYPE void FASTCALL sw_dim(ULONG, WINDOWPTR);
PROTOTYPE void FASTCALL sw_exporg(short, WINDOWPTR);
PROTOTYPE void FASTCALL sw_mf(MFILEPTR, WINDOWPTR);
PROTOTYPE void FASTCALL sw_mforg(int, int, WINDOWPTR);
PROTOTYPE void FASTCALL sw_mgcol(int, int, WINDOWPTR);
PROTOTYPE void FASTCALL sw_mgrow(int, int, WINDOWPTR);
PROTOTYPE void FASTCALL sw_msbuf(SCRPTR, WINDOWPTR);
PROTOTYPE int FASTCALL sw_msorg(int, int, WINDOWPTR);
PROTOTYPE int FASTCALL sw_sb(int, ULONG, WINDOWPTR);
PROTOTYPE void FASTCALL sw_sbrange(int, int, ULONG, WINDOWPTR);
PROTOTYPE void FASTCALL sw_sbval(int, ULONG, WINDOWPTR);
PROTOTYPE int FASTCALL sw_shad(UCHAR, UCHAR, UINT, WINDOWPTR);
PROTOTYPE int FASTCALL time_delay(long);
PROTOTYPE long FASTCALL time_diff(UCHAR *, UCHAR *, UCHAR *);
PROTOTYPE int FASTCALL time_frnums(UCHAR *, int, int, int, UCHAR *);
PROTOTYPE int FASTCALL time_frsec(UCHAR *, long, UCHAR *);
PROTOTYPE int FASTCALL time_get(UCHAR *, UCHAR *);
PROTOTYPE int FASTCALL time_tonums(UCHAR *, int *, int *, int *, UCHAR *);
PROTOTYPE long FASTCALL time_tosec(UCHAR *, UCHAR *);
PROTOTYPE UCHAR *(* FASTCALL trt_def(int))[][2];
PROTOTYPE UCHAR * FASTCALL trt_rplst(UCHAR *, UCHAR *, UCHAR *(*)[][2]);
PROTOTYPE int FASTCALL tr_mf(MFILEPTR, UCHAR *(*)[][2]);
PROTOTYPE int FASTCALL tr_st(UCHAR *, UCHAR *(*)[][2]);
PROTOTYPE int FASTCALL ts_save(TERMSTATPTR);
PROTOTYPE int FASTCALL ts_set(TERMSTATPTR);
PROTOTYPE void FASTCALL vid_cgabdr(UCHAR);
PROTOTYPE void FASTCALL vid_ega43(int);
PROTOTYPE void FASTCALL vid_vga50(int);
PROTOTYPE int FASTCALL vid_getmode(void);
PROTOTYPE void FASTCALL vid_hibg(int);
PROTOTYPE void FASTCALL vid_setmode(int);
PROTOTYPE UCHAR FASTCALL vo_att(WINDOWPTR);
PROTOTYPE UCHAR FASTCALL vo_ch(WINDOWPTR);
PROTOTYPE void FASTCALL vs_clr(void);
PROTOTYPE void FASTCALL vs_refresh(void);
PROTOTYPE void FASTCALL vs_updrgn(int, int, int, int);
PROTOTYPE int FASTCALL v_attq(UCHAR, int, WINDOWPTR);
PROTOTYPE void FASTCALL v_bdr(BORDERPTR, WINDOWPTR);
PROTOTYPE void FASTCALL v_box(int, int, int, int, UCHAR, BORDERPTR, WINDOWPTR);
PROTOTYPE int FASTCALL v_ch(UCHAR, WINDOWPTR);
PROTOTYPE int FASTCALL v_chattcol(int, int, UCHAR, UCHAR, int, int, WINDOWPTR);
PROTOTYPE int FASTCALL v_chattrow(int, int, UCHAR, UCHAR, int, int, WINDOWPTR);
PROTOTYPE int FASTCALL v_chq(UCHAR, int, WINDOWPTR);
PROTOTYPE void FASTCALL v_line(int, int, int, int, UCHAR, LINEPTR, WINDOWPTR);
#ifdef V_PRINTF
PROTOTYPE int CDECL v_printf(WINDOWPTR, UCHAR *, UINT, UINT, UINT, UINT, UINT,
		       UINT, UINT, UINT, UINT, UINT, UINT, UINT, UINT, UINT,
		       UINT, UINT, UINT, UINT, UINT, UINT);
#else
PROTOTYPE int CDECL v_printf(WINDOWPTR, UCHAR *, ...);
#endif
PROTOTYPE UCHAR * FASTCALL v_st(UCHAR *, WINDOWPTR);
PROTOTYPE UCHAR * FASTCALL v_statt(UCHAR *, UCHAR, WINDOWPTR);
PROTOTYPE void FASTCALL v_stattnop(int, int, UCHAR *, UCHAR, int, int, 
				    WINDOWPTR);
PROTOTYPE UCHAR * FASTCALL v_stattpl(int, int, UCHAR *, UCHAR, int, WINDOWPTR);
PROTOTYPE UINT FASTCALL v_stcpy(UCHAR *, int, int, WINDOWPTR);
PROTOTYPE UCHAR * FASTCALL v_stpl(int, int, UCHAR *, WINDOWPTR);
PROTOTYPE UINT FASTCALL v_vstcpy(UCHAR *, int, int, WINDOWPTR);
PROTOTYPE UCHAR * FASTCALL vv_errmsg(UINT);
PROTOTYPE UCHAR * FASTCALL vv_infomsg(UINT);
PROTOTYPE int FASTCALL vv_spawn(UCHAR *);
PROTOTYPE void FASTCALL wi_rpl(WINDOWPTR);
PROTOTYPE int FASTCALL wi_sav(WINDOWPTR);
PROTOTYPE void FASTCALL wi_unsav(WINDOWPTR);
PROTOTYPE void FASTCALL wn_clr(WINDOWPTR);
PROTOTYPE WINDOWPTR FASTCALL wn_def(int, int, int, int, UCHAR, BORDERPTR);
PROTOTYPE void FASTCALL wn_dup(WINDOWPTR, WINDOWPTR);
PROTOTYPE int FASTCALL wn_expset(WINDOWPTR);
PROTOTYPE void FASTCALL wn_expunset(WINDOWPTR);
PROTOTYPE void FASTCALL wn_free(WINDOWPTR);
PROTOTYPE int FASTCALL wn_mod(int, int, int, int, WINDOWPTR);
PROTOTYPE int FASTCALL wn_msadj(WINDOWPTR);
PROTOTYPE int FASTCALL wn_mv(int, int, WINDOWPTR);
PROTOTYPE int FASTCALL wn_print(WINDOWPTR);
PROTOTYPE int FASTCALL wn_rollset(WINDOWPTR);
PROTOTYPE void FASTCALL wn_rollunset(WINDOWPTR);
PROTOTYPE int FASTCALL wn_sbdraw(WINDOWPTR);
PROTOTYPE void FASTCALL wn_sbrange(int *, int *, ULONG, WINDOWPTR);
PROTOTYPE int FASTCALL wn_sbthumb(ULONG, WINDOWPTR);
PROTOTYPE void FASTCALL wn_sbupd(int, int, ULONG, WINDOWPTR);
PROTOTYPE int FASTCALL wn_sbval(ULONG, WINDOWPTR);
PROTOTYPE void FASTCALL wn_scrl(int, int, WINDOWPTR);
PROTOTYPE int FASTCALL wn_sdef(int, int, int, int, UCHAR, BORDERPTR, WINDOWPTR);
PROTOTYPE int FASTCALL wn_set(WINDOWPTR);
PROTOTYPE UINT FASTCALL wn_size(ULONG, int, WINDOWPTR);
PROTOTYPE void FASTCALL wn_unset(WINDOWPTR);
PROTOTYPE int FASTCALL wn_updrgn(int, int, int, int, WINDOWPTR);
PROTOTYPE int FASTCALL wn_wr(UCHAR *, UCHAR *, WINDOWPTR);
PROTOTYPE void FASTCALL _db_dummy(UCHAR *);
PROTOTYPE int FASTCALL _dir_change(UCHAR *);
PROTOTYPE int FASTCALL _dir_make(UCHAR *);
PROTOTYPE int FASTCALL _dir_remove(UCHAR *);
PROTOTYPE short FASTCALL _drv_set(UINT);
PROTOTYPE int FASTCALL _dt_frnums(int, UCHAR **, UCHAR **);
PROTOTYPE int FASTCALL _dt_tonums(UCHAR **, UCHAR **);
PROTOTYPE int FASTCALL _d_fmtval(UCHAR *, UCHAR **);
PROTOTYPE int FASTCALL _d_tonums(UCHAR *, int *, int *, int *, UCHAR *);
PROTOTYPE void FASTCALL _fext_strip(UCHAR *);
PROTOTYPE void FASTCALL _init_sys(void);
PROTOTYPE int FASTCALL _liberr(int);
PROTOTYPE int CDECL _mf_rowcmp(MFLINEPTR *, MFLINEPTR *);
PROTOTYPE MFLINEPTR FASTCALL _mf_rowdef(UCHAR *);
PROTOTYPE int FASTCALL _shad_updn(int, WINDOWPTR);
PROTOTYPE void FASTCALL _sw_sbauto(ULONG, WINDOWPTR);
PROTOTYPE int FASTCALL _t_fmtval(UCHAR *);
PROTOTYPE int FASTCALL _t_tonums(UCHAR *, int *, int *, int *, UCHAR *);
PROTOTYPE void CDECL _vcscpy(UCHAR FAR *, UCHAR FAR *, UINT, int, UCHAR, 
				UCHAR *);
PROTOTYPE int FASTCALL _vf_date(int, int, int);
PROTOTYPE int FASTCALL _vf_time(int, int);
PROTOTYPE UINT FASTCALL _v_cpy(UCHAR *, int, int, int, WINDOWPTR);
PROTOTYPE void FASTCALL _v_fill(int, int, int, int, UCHAR, UCHAR, int, WINDOWPTR);
PROTOTYPE void FASTCALL _v_stcpy(int, int, UCHAR *, int, WINDOWPTR);
PROTOTYPE void FASTCALL _v_stnop(int, int, UCHAR *, UCHAR, int, int, WINDOWPTR);
PROTOTYPE UCHAR * FASTCALL _v_strow(UCHAR *, UCHAR, int, int, WINDOWPTR);
PROTOTYPE void FASTCALL _wi_swap(UCHAR *, WINDOWPTR);
PROTOTYPE int FASTCALL _wn_dupstruc(WINDOWPTR, WINDOWPTR);
PROTOTYPE int FASTCALL _wn_mfadj(WINDOWPTR);
PROTOTYPE int FASTCALL _wn_rgnfit(int, int, int, int, WINDOWPTR);
PROTOTYPE void FASTCALL _wn_sbauto(WINDOWPTR);
PROTOTYPE short FASTCALL _wn_setup(WINDOWPTR);

					/*Pointer variables		      */
EXTERN void (FASTCALL * _errfp)(UCHAR *);
EXTERN ISVRP _abortfp;
EXTERN void (FASTCALL * _finitfp)(UCHAR *);
EXTERN void (FASTCALL * _fexitfp)(UCHAR *);
EXTERN void (FASTCALL * _inittbl[])(void);
EXTERN ISVRP _breakfp;
EXTERN ISVRP _oldbreakfp;
#ifdef	NEC_PC9801
EXTERN void _init_bk(void);
EXTERN void _exit_bk(void);
EXTERN void (*_initbkgfp)(void);
EXTERN void (*_exitbkgfp)(void);
#endif	/* NEC_PC9801 */

/*----------------------------------------------------------------------------*/
/*  PCDOS specific functions						      */
/*----------------------------------------------------------------------------*/
PROTOTYPE void ISVR _abortsr(void);
PROTOTYPE unsigned long CDECL _biostickq(void);
PROTOTYPE void ISVR CDECL _breaksr(void);
PROTOTYPE int FASTCALL _chk_ega(void);
PROTOTYPE int FASTCALL _chk_extender(void);
PROTOTYPE int FASTCALL _chk_msw(void);
PROTOTYPE int FASTCALL _chk_ps2(void);
PROTOTYPE int FASTCALL _chk_xkb(void);
PROTOTYPE int CDECL _get_extender(void);
PROTOTYPE UCHAR CDECL _inb(USHORT);
PROTOTYPE void FASTCALL _init_timer(void);
PROTOTYPE void FASTCALL _init_vert(void);
PROTOTYPE UINT CDECL _inw(USHORT);
PROTOTYPE ISVRP _isr_rpl(ISVRP, USHORT);
PROTOTYPE void CDECL _outb(USHORT, UCHAR);
PROTOTYPE void CDECL _outw(USHORT, UINT);
PROTOTYPE int CDECL _sys_int(USHORT, VIDIOPTR, VIDIOPTR);
PROTOTYPE void FASTCALL _time_delay(USHORT);
PROTOTYPE USHORT CDECL _timertickq(void);


#else
extern void FASTCALL abort_vv();
extern void FASTCALL beep_vv();
extern int FASTCALL ch_isalpha();
extern int FASTCALL ch_isdigit();
extern int FASTCALL ch_islower();
extern int FASTCALL ch_isspace();
extern int FASTCALL ch_istxt();
extern int FASTCALL ch_isupper();
extern UCHAR FASTCALL ch_tolower();
extern UCHAR FASTCALL ch_toupper();
extern void FASTCALL csr_hide();
extern void FASTCALL csr_mv();
extern int FASTCALL csr_mvwn();
extern int FASTCALL csr_plwn();
extern void FASTCALL csr_rd();
extern void FASTCALL csr_show();
extern void FASTCALL csr_type();
extern int FASTCALL cs_adj();
extern long FASTCALL date_diff();
extern int FASTCALL date_frjul();
extern int FASTCALL date_frnums();
extern int FASTCALL date_get();
extern int FASTCALL date_isleapyr();
extern int FASTCALL date_tonums();
extern long FASTCALL date_tojul();
extern void FASTCALL exit_err();
extern void FASTCALL exit_vv();
extern void FASTCALL init_vv();
extern int FASTCALL latt_init();
extern void FASTCALL latt_rpl();
extern void FASTCALL mem_free();
extern PTR FASTCALL mem_get();
extern UCHAR * FASTCALL mem_stblank();
extern int FASTCALL mf_clr();
extern MFILEPTR FASTCALL mf_def();
extern void FASTCALL mf_disp();
extern void FASTCALL mf_free();
extern int FASTCALL mf_kwdload();
extern int FASTCALL mf_kwdset();
extern int FASTCALL mf_kwdunload();
extern int FASTCALL mf_print();
extern int FASTCALL mf_rd();
extern void FASTCALL mf_rowdel();
extern void FASTCALL mf_rowget();
extern int FASTCALL mf_rowins();
extern int FASTCALL mf_rowlen();
extern UCHAR * FASTCALL mf_rowp();
extern int FASTCALL mf_rowrpl();
extern int FASTCALL mf_scrl();
extern int FASTCALL mf_search();
extern int FASTCALL mf_sort();
extern int FASTCALL mf_wr();
extern void FASTCALL ms_clr();
extern SCRPTR FASTCALL ms_def();
extern int FASTCALL ms_print();
extern int FASTCALL ms_rd();
extern int FASTCALL ms_wr();
extern void FASTCALL nd_del();
extern NODEPTR FASTCALL nd_inithd();
extern NODEPTR FASTCALL nd_ins();
extern NODEPTR FASTCALL nd_numptr();
extern int FASTCALL nd_ptrnum();
extern void CDECL re_breakfp();
extern void FASTCALL se_abortfp();
extern void FASTCALL se_breakfp();
extern int FASTCALL shad_def();
extern UCHAR * FASTCALL stp_begtxt();
extern UCHAR * FASTCALL stp_endtxt();
extern UCHAR * FASTCALL stp_find();
extern void FASTCALL st_delch();
extern void FASTCALL st_delembwh();
extern void FASTCALL st_delendwh();
extern int FASTCALL st_extract();
extern UINT FASTCALL st_frint();
extern UINT FASTCALL st_frlong();
extern UINT FASTCALL st_frshort();
extern void FASTCALL st_ins();
extern void FASTCALL st_insch();
extern int FASTCALL st_isblank();
extern void FASTCALL st_lft();
extern void FASTCALL st_lftadj();
extern void FASTCALL st_padblank();
extern int FASTCALL st_rd();
extern UINT FASTCALL st_rev();
extern void FASTCALL st_rt();
extern void FASTCALL st_rtadj();
extern void FASTCALL st_tolower();
extern short FASTCALL st_toshort();
extern void FASTCALL st_toupper();
extern int FASTCALL st_wr();
extern void FASTCALL sw_adjq();
extern void FASTCALL sw_bdr();
extern void FASTCALL sw_dest();
extern void FASTCALL sw_dim();
extern void FASTCALL sw_exporg();
extern void FASTCALL sw_mf();
extern void FASTCALL sw_mforg();
extern void FASTCALL sw_mgcol();
extern void FASTCALL sw_mgrow();
extern void FASTCALL sw_msbuf();
extern int FASTCALL sw_msorg();
extern int FASTCALL sw_sb();
extern void FASTCALL sw_sbrange();
extern void FASTCALL sw_sbval();
extern int FASTCALL sw_shad();
extern int FASTCALL time_delay();
extern long FASTCALL time_diff();
extern int FASTCALL time_frnums();
extern int FASTCALL time_frsec();
extern int FASTCALL time_get();
extern int FASTCALL time_tonums();
extern long FASTCALL time_tosec();
extern UCHAR *(* FASTCALL trt_def())[][2];
extern UCHAR * FASTCALL trt_rplst();
extern int FASTCALL tr_mf();
extern int FASTCALL tr_st();
extern int FASTCALL ts_save();
extern int FASTCALL ts_set();
extern void FASTCALL vid_cgabdr();
extern void FASTCALL vid_ega43();
extern void FASTCALL vid_vga50();
extern int FASTCALL vid_getmode();
extern void FASTCALL vid_hibg();
extern void FASTCALL vid_setmode();
extern UCHAR FASTCALL vo_att();
extern UCHAR FASTCALL vo_ch();
extern void FASTCALL vs_clr();
extern void FASTCALL vs_refresh();
extern void FASTCALL vs_updrgn();
extern int FASTCALL v_attq();
extern void FASTCALL v_bdr();
extern void FASTCALL v_box();
extern int FASTCALL v_ch();
extern int FASTCALL v_chattcol();
extern int FASTCALL v_chattrow();
extern int FASTCALL v_chq();
extern void FASTCALL v_line();
extern int CDECL v_printf();
extern UCHAR * FASTCALL v_st();
extern UCHAR * FASTCALL v_statt();
extern void FASTCALL v_stattnop();
extern UCHAR * FASTCALL v_stattpl();
extern UINT FASTCALL v_stcpy();
extern UCHAR * FASTCALL v_stpl();
extern UINT FASTCALL v_vstcpy();
extern UCHAR * FASTCALL vv_errmsg();
extern UCHAR * FASTCALL vv_infomsg();
extern int FASTCALL vv_spawn();
extern void FASTCALL wi_rpl();
extern int FASTCALL wi_sav();
extern void FASTCALL wi_unsav();
extern void FASTCALL wn_clr();
extern WINDOWPTR FASTCALL wn_def();
extern void FASTCALL wn_dup();
extern int FASTCALL wn_expset();
extern void FASTCALL wn_expunset();
extern void FASTCALL wn_free();
extern int FASTCALL wn_mod();
extern int FASTCALL wn_msadj();
extern int FASTCALL wn_mv();
extern int FASTCALL wn_print();
extern int FASTCALL wn_rollset();
extern void FASTCALL wn_rollunset();
extern int FASTCALL wn_sbdraw();
extern void FASTCALL wn_sbrange();
extern int FASTCALL wn_sbthumb();
extern void FASTCALL wn_sbupd();
extern int FASTCALL wn_sbval();
extern void FASTCALL wn_scrl();
extern int FASTCALL wn_sdef();
extern int FASTCALL wn_set();
extern UINT FASTCALL wn_size();
extern void FASTCALL wn_unset();
extern int FASTCALL wn_updrgn();
extern int FASTCALL wn_wr();
extern void FASTCALL _db_dummy();
extern int FASTCALL _dir_change();
extern int FASTCALL _dir_make();
extern int FASTCALL _dir_remove();
extern short FASTCALL _drv_set();
extern int FASTCALL _dt_frnums();
extern int FASTCALL _dt_tonums();
extern int FASTCALL _d_fmtval();
extern int FASTCALL _d_tonums();
extern void FASTCALL _fext_strip();
extern void FASTCALL _init_sys();
extern int FASTCALL _liberr();
extern int CDECL _mf_rowcmp();
extern MFLINEPTR FASTCALL _mf_rowdef();
extern int FASTCALL _shad_updn();
extern void FASTCALL _sw_sbauto();
extern int FASTCALL _t_fmtval();
extern int FASTCALL _t_tonums();
extern void CDECL _vcscpy();
extern int FASTCALL _vf_date();
extern int FASTCALL _vf_time();
extern UINT FASTCALL _v_cpy();
extern void FASTCALL _v_fill();
extern void FASTCALL _v_stcpy();
extern void FASTCALL _v_stnop();
extern UCHAR * FASTCALL _v_strow();
extern void FASTCALL _wi_swap();
extern int FASTCALL _wn_dupstruc();
extern int FASTCALL _wn_mfadj();
extern int FASTCALL _wn_rgnfit();
extern void FASTCALL _wn_sbauto();
extern short FASTCALL _wn_setup();

					/*Pointer variables		      */
EXTERN void (*_errfp)();
EXTERN ISVRP _abortfp;
EXTERN void (*_finitfp)();
EXTERN void (*_fexitfp)();
EXTERN void (*_inittbl[])();
EXTERN ISVRP _breakfp;
EXTERN ISVRP _oldbreakfp;

/*----------------------------------------------------------------------------*/
/*  PCDOS specific functions						      */
/*----------------------------------------------------------------------------*/
extern void ISVR _abortsr();
extern unsigned long CDECL _biostickq();
extern void ISVR CDECL _breaksr();
extern int FASTCALL _chk_ega();
extern int FASTCALL _chk_extender(void);
extern int FASTCALL _chk_msw();
extern int FASTCALL _chk_ps2();
extern int FASTCALL _chk_xkb();
extern int CDECL _get_extender();
extern UCHAR CDECL _inb();
extern void FASTCALL _init_timer();
extern void FASTCALL _init_vert();
extern UINT CDECL _inw();
extern ISVRP _isr_rpl();
extern void CDECL _outb();
extern void CDECL _outw();
extern int CDECL _sys_int();
extern void FASTCALL _time_delay();
extern USHORT CDECL _timertickq();

#endif

#ifdef __WATCOMC__
/*----------------------------------------------------------------------------*/
/* Watcom C pragmas							      */
/* These make the compiler to generate code to pass arguments on the stack    */
/* using Microsoft C calling conventions.				      */
/*----------------------------------------------------------------------------*/
#pragma aux MS_C "_*"				       \
		parm caller []			       \
		value struct float struct routine [ax] \
		modify [ax bx cx dx es si di];
#pragma aux (MS_C) _vcscpy;
#pragma aux (MS_C) _abortsr;
#pragma aux (MS_C) _breaksr;
#pragma aux (MS_C) _inb;
#pragma aux (MS_C) _inw;
#pragma aux (MS_C) _outb;
#pragma aux (MS_C) _outw;
#pragma aux (MS_C) _sys_int;
#pragma aux (MS_C) v_printf;
#pragma aux (MS_C) _gencrc;
#pragma aux (MS_C) _get_extender;
#pragma aux (MS_C) _timertickq;
#pragma aux (MS_C) _biostickq;
#endif

#endif

