
/***************************************************************************
**
**    $Header:   D:/USD3V/LOG/SRC/WUSYM2.C__   1.2   12 Jun 1996 08:45:10   ZJRD  $
**
**    $Log:   D:/USD3V/LOG/SRC/WUSYM2.C__  $
** 
**    Rev 1.2   12 Jun 1996 08:45:10   ZJRD
** No change.
** 
**    Rev 1.1   24 May 1996 09:43:00   ZJRD
** No change.
** 
**    Rev 1.0   11 Dec 1995 13:52:02   ZJRD
** Initial revision.
** 
****************************************************************************/
/***************************************************************************
**
**    $Header:   D:/USD3V/LOG/SRC/WUSYM2.C__   1.2   12 Jun 1996 08:45:10   ZJRD  $
**
**    $Log$
** 
****************************************************************************/
/*--------------------------------------------------------------------------*/
/*  wusym2.c								    */
/*--------------------------------------------------------------------------*/

#include <conio.h>
#include  "system.h"
#include  "errno.h"
#include  "usd3.h"
#include  "gblext.h"
#include  "oldext.h"
#include  "usym1.h"
#include  "usym3.h"
#include  "funcext.h"

#define U8 unsigned char
#define U16 unsigned int
#define U32 unsigned long

/*  #define NO_MODULE 50    */

char hhex[17] = "0123456789ABCDEF:";
char hexx[23] = "0123456789ABCDEFabcdef";
char userheader[] = "$USD320-USERSYMBOLS$";
extern int RecLoc[];
extern unsigned char absad[];
extern struct attribute env;
extern struct pcstatus  PC;
extern int SymLoaded;
extern int (*absaddr)();
extern int absad86();
extern int absadh8();
extern int AddrIndexCompCnt, aIndexComp(),bComp(), AddrComp();
int sxcompare(),sycompare();
int InxInSatable, InxInAstable;
unsigned char *aentry;

/*****************************************************************************/
/****** load_cmd                                                        ******/
/*****************************************************************************/

load_cmd()
{
	MICEEchoESC();
	if (cmd_argc != 2)  {
		prn_ferr(70);
		return(TRUE);
	}
	SymLoaded = init_all(cmd_argv[1],MSG_ON);
	return(TRUE);
}

/*****************************************************************************/
/***** module_cmd                                                       ******/
/*****************************************************************************/

module_cmd(rangeflag)
int rangeflag;
{
	int i,j;
	char tbuf[100];

	MICEEchoESC();
	VPOut = COMVP;
	if (cmd_argc > 1)  {
		if (!(cmd_argc == 2 && rangeflag))  {
			prn_ferr(70);
			return(TRUE);
		}
	}
	sprintf(tbuf,"\r\nThe total number of modules: %d",modcnt);
	DisplayStr(tbuf);
	swap_module(0);
	for (i=0; i < modcnt; i++)   {
		if (chk_hlt() == ESC) {
			DisplayStr("\\");
			return(TRUE);
		}
		j = i - gblmod[0].mod_inx;
		sprintf(tbuf,"\r\n%7d. %s",i+1,gblmod[j].mod_name);
		DisplayStr(tbuf);
		if (j == NO_MODULE-1) 	 swap_module(i+1);
	}
	return(TRUE);
}

/*****************************************************************************/
/***** create_cmd()                                                      *****/
/*****************************************************************************/

create_cmd()
{
	int i,j,ColonExist=0;
	char name[42],*cptr,tbuf[200],temp[15];
	unsigned char addr[6];

	MICEEchoESC();
	VPOut = COMVP;
	if (cmd_argc != 3)  {
		prn_ferr(70);
		return(TRUE);
	}
	memset(name,NULL,42);
	memset(addr,NULL,6);
	if ((env.Sabsflag == -2) && (env.Saddrunit == -2))  {
		env.Saddrunit = env.Maddrunit;
		if ((env.Maddrid == 4) || (env.Maddrid == 6))    env.Sabsflag = 1;
		else env.Sabsflag = 0;
	}
	if ((cptr=strchr(cmd_argv[1],'%')) == NULL)  {
		prn_ferr(70);
		return(TRUE);
	}
	else cptr++;
	if (strlen(cptr) > 40) strncpy(name,cptr,40);
	else strcpy(name,cptr);
	if (str2addr(cmd_argv[2],addr) == FAIL) return(TRUE);
	memset(&comsym,NULL,sizeof(comsym));
	strcpy(comsym.name,name);
	memcpy(comsym.addr,addr,6);
	insert_symbol(MSG_ON);
	return(TRUE);
}

insert_symbol(msgon)
int msgon;
{
	unsigned char addr[6];
	char tbuf[200],temp[15];

	memset(addr,NULL,6);
	memcpy(addr,comsym.addr,6);

	if ((env.Sabsflag == -2) && (env.Saddrunit == -2))  {
		env.Saddrunit = env.Maddrunit;
		if ((env.Maddrid == 4) || (env.Maddrid == 6)) 
			env.Sabsflag = 1;
	}
	if (env.Sabsflag) {
		if (env.Maddrid == 4 && env.Mmodel == 40) 
			absaddr = absadh8;
		else absaddr = absad86;
	}

/* checking if the symbol exists in global table */
//	if (gblsymcnt != 0 || addinx != 0)  {
	if (addinx != 0)  {
		if (comsym.modx != -1) comsym.modx = -1;
		comsym.mask |= MSK_GBL;
//		if (find_gblsym_byn() == FOUND)  {
		if (find_addon_byn() == FOUND)  {
			memset(temp,NULL,15);
			addr2str(comsym.addr,temp);
			if (msgon == MSG_ON)  prn_ferr(20); 
			if (memcmp(comsym.addr,addr,env.Maddrunit) == 0) return(OK);
			else return(FAIL);
		}
	}	

/* inserting the address and symbol name to the addon table */
	if (addinx == ADDON) {
		if (msgon == MSG_ON) prn_ferr(23);
		return(FAIL);
	}
	memcpy(addtable[addinx].addr,addr,6);
	if ((addtable[addinx].name=malloc(strlen(comsym.name)+1)) == NULL) {
		if (msgon == MSG_ON)  prn_ferr(45);
		return(FAIL);
	}
	strcpy(addtable[addinx].name,comsym.name);
	addinx++;   
/* after inserting item to addon table, now do the sorting */
	if (addinx > 1)
		qsort((void *)addtable,addinx,sizeof(struct addonitem),sycompare);
	memset(temp,NULL,15);
	addr2str(addr,temp);
	sprintf(tbuf,"\r\nSymbol %s [%s] is created.",comsym.name,temp);
	if (msgon == MSG_ON)  DisplayStr(tbuf);
	return(OK);
}

sycompare(s1,s2)
unsigned char *s1,*s2;
{
	struct addonitem  *ss1,*ss2;

	ss1 = (struct addonitem *)s1;
	ss2 = (struct addonitem *)s2;
	return(memcmp(ss1->addr,ss2->addr,env.Maddrunit));
}
sxcompare(s1,s2)
unsigned char *s1,*s2;
{
	struct addonitem  *ss1,*ss2;

	ss1 = (struct addonitem *)s1;
	ss2 = (struct addonitem *)s2;
	return(strcmp(ss1->name,ss2->name));
}


/*****************************************************************************/
/***** delete_cmd()                                                      *****/
/*****************************************************************************/

delete_cmd()
{
	int i;
	char *cptr,name[42],tbuf[200],temp[15];
	HANDLE hhh;

	MICEEchoESC();
	VPOut = COMVP;
	if (cmd_argc != 2)  {
		prn_ferr(70);
		return(TRUE);
	}
	memset(name,NULL,42);
	memset(tbuf,NULL,70);
       
	ExtSymAdr(cmd_argv[1],tbuf,SYM);
       
	if ((cptr=strrchr(tbuf,'%')) == NULL)  {
		prn_ferr(70);
		return(TRUE);
	}
	else  cptr++;
	if (strlen(cptr) > 40) strncpy(name,cptr,40);
	else strcpy(name,cptr);

	for (i=0; i < addinx; i++)  
		if (strcmp(name,addtable[i].name) == 0) break;
	if (i >= addinx) {
		prn_ferr(74);
		return(TRUE);
	}
	memset(temp,NULL,15);
	addr2str(addtable[i].addr,temp);
	free(addtable[i].name);
	memcpy(&addtable[i],&addtable[addinx-1],sizeof(struct addonitem));
	addinx--;
	memset(&addtable[addinx],NULL,sizeof(struct addonitem));
	if (addinx > 1)
		qsort((void *)addtable,addinx,sizeof(struct addonitem),sycompare);
	memset(tbuf,NULL,70);
	sprintf(tbuf,"\r\n Symbol %s [%s] is deleted.",name,temp);
	DisplayStr(tbuf);
	return(TRUE);
}

/*****************************************************************************/
/****** symbol_cmd                                                       *****/
/*****************************************************************************/

symbol_cmd()
{
	int i,j,inxcnt,curflag=0,modflag=0;
	char *cptr,modname[42],tbuf[100];
	unsigned char pc[6];

	MICEEchoESC();
	VPOut = COMVP;
	memset(tbuf,NULL,70);
	memset(modname,NULL,42);
	if (cmd_argc == 1) modname[0] = 'A';
	else if (cmd_argc > 2)   {
		prn_ferr(70);
		return(TRUE);
	} else {
		modname[0] = '%';
		if ((cptr=strstr(cmd_argv[1],"%%")) == NULL) cptr = cmd_argv[1];
		else  {  modflag = 1;  cptr++;  cptr++; } 
		if (strchr(cptr,'%') != NULL)  {
			prn_ferr(70);
			return(TRUE);
		}
		if (strlen(cptr) > 40) strncpy(&modname[modflag],cptr,40);
		else strcpy(&modname[modflag],cptr);
	}
	if (chk_hlt() == ESC) {
		DisplayStr("\\");
		return(TRUE);
	}
	switch (modname[0])  {
		case 'G':
			memset(tbuf,0x20,74);
			sprintf(tbuf,"\r\nGlobal symbols newly created: %d symbols",addinx);
			DisplayStr(tbuf);
			if (addinx > 0)  {
				if (ListSymInAddon() == ESC) return(TRUE);
				DisplayStr("\r\n");
			}
			if (SymLoaded == OK) {
				memset(tbuf,0x20,74);
				sprintf(tbuf,"\r\nGlobal symbols from file: %d symbols",gblsymcnt);
				DisplayStr(tbuf);
				if (gblsymcnt == 0) break;
				if (ListSymInTbl(-1) == ESC) return(TRUE);
			}
			break;
		case '%':
			if (SymLoaded != OK) break;
			if (NameToMod(&modname[1]) == MISS)  {
				prn_ferr(72);	
				return(TRUE);	
			}
			sprintf(tbuf,"\r\nModule %s : %d symbols",commod.mod_name,commod.mod_symno);
			DisplayStr(tbuf);
			if (commod.mod_symno == 0) break;
			CurModSAInx = ModInxHead + commod.mod_inx;
			if (ListSymInTbl(0) == ESC) return(TRUE);
			break;
		case 'A':
			sprintf(tbuf,"\r\nGlobals newly created: %d symbols",addinx);
			DisplayStr(tbuf);
			if (addinx > 0)  {
				memset(tbuf,0x20,74);
				if (ListSymInAddon() == ESC) return(TRUE);
				DisplayStr("\r\n");
			}
			if (SymLoaded != OK) break;
			memset(tbuf,0x20,74);
			sprintf(tbuf,"\r\nGlobals from symbol file: %d symbols",gblsymcnt);
			DisplayStr(tbuf);
			if (gblsymcnt > 0)
				if (ListSymInTbl(-1) == ESC) return(TRUE);
			sprintf(tbuf,"\r\n\r\nTotal number of modules: %d ",modcnt);
			DisplayStr(tbuf);
			swap_module(0);
			for (CurModSAInx=ModInxHead,i=0; i < modcnt; i++,CurModSAInx++)  {
				j = i - gblmod[0].mod_inx;
				memset(tbuf,0x20,74);
				sprintf(tbuf,"\r\n\r\nModule %s: %d symbols",gblmod[j].mod_name,gblmod[j].mod_symno);
				if (chk_hlt() == ESC) {
					DisplayStr("\\");
					return(TRUE);
				}
				DisplayStr(tbuf);
				if (gblmod[j].mod_symno == 0) continue;
				if (ListSymInTbl(0) == ESC) return(TRUE);
				if (j == NO_MODULE - 1) swap_module(i+1);
				if (chk_hlt() == ESC) {
					DisplayStr("\\");
					return(TRUE);
				}
			}
			break;
		default:
			break;
	}
	return(TRUE);
}

ListSymInAddon()
{
	char str[38];
	int i,j,k,slen,alen,even=0;

	qsort((void *)addtable,addinx,sizeof(struct addonitem),sxcompare);
	alen = env.Saddrunit * 2 + 1;
	if (env.Sabsflag && ((env.Saddrunit >= 2) && (env.Saddrunit <= 4))) alen++;
	slen = 37 - alen - 1;    
	str[37] = '\0';
	for (i=0; i < addinx; i++) {
		memset(str,0x20,37);
		for (j=0,k=0; j < env.Maddrunit; j++) {
			str[k++] = hhex[((addtable[i].addr[j] & 0xf0) >> 4)];
			str[k++] = hhex[(addtable[i].addr[j] & 0x0f)];
			if (j == 0 && env.Mmodel == 40) str[k++] = hhex[16];
			if (j == 1 && env.Sabsflag && env.Mmodel != 40) str[k++] = hhex[16];
		}
		k++;
		if (strlen(addtable[i].name) > slen) 
			memcpy(&str[k],addtable[i].name,slen);
		else memcpy(&str[k],addtable[i].name,strlen(addtable[i].name));
		even++;
		if (even == 1)        DisplayStr("\r\n");
		else if (even == 2)   even = 0;
		if (chk_hlt() == ESC) {
			DisplayStr("\\");
			qsort((void *)addtable,addinx,sizeof(struct addonitem),sycompare);
			return(ESC);
		}
		DisplayStr(str);
	}
	qsort((void *)addtable,addinx,sizeof(struct addonitem),sycompare);
	return(OK);
}

ListSymInTbl(tt)
int tt;
{
	int i,j,k,l,m,inxcnt,alen,slen,even=0,lineCnt=0,c;
	char str[38];
	unsigned char temp[6];
	char tbuf[90];

	VPOut = COMVP;
	if (tt == -1) {
		inxcnt = gblinxcnt;
		SXPtr = GblSXTbl;
	} else {
		inxcnt = CurModSAInx->cnt;
		SXPtr = CurModSAInx->sxptr;
	}

	alen = env.Maddrunit * 2 + 1;
	if (env.Sabsflag && ((env.Maddrunit >= 3) && (env.Maddrunit <= 6))) alen++;
	slen = 37 - alen - 1;
	memset(str,0x20,37);
	str[37] = '\0';
	for (i=0; i < inxcnt-1; i++,SXPtr++) {
		lseek(fdsy,SXPtr->fpos,0);
		read(fdsy,&satable[0],SXPtr->cnt*symreclen);
		if (chk_hlt() == ESC) {
			DisplayStr("\\");
			return(ESC);
		}
		for (m=0,j=0; j < SXPtr->cnt; j++)  {
			memset(str,0x20,37);
			if (satable[m] > slen) 
				memcpy(&str[alen],&satable[m+1],slen);
			else memcpy(&str[alen],&satable[m+1],satable[m]);
			m += satable[m]+1;
			memset(temp,NULL,6);
			memcpy(temp,&satable[m],env.Saddrunit);
			if (env.Maddrunit > env.Saddrunit)
				AddrAlign(temp,env.Saddrunit,env.Maddrunit,'E');
			else if (env.Maddrunit < env.Saddrunit)
				AddrAlign(temp,env.Saddrunit,env.Maddrunit,'S');
			addr2str(temp,str);
			m += env.Saddrunit;
			even++;
			if (even == 1) {
 				DisplayStr("\r\n");
/*
 				lineCnt++;
 				if (lineCnt == 16) {
 					DisplayStr("[ More ]");
					while (!kbhit());
					if (getchar() == ESC) {
						DisplayStr("\\");
						return(ESC);
					}
					lineCnt = 0;
	 				DisplayStr("\r");
				}
	*/
			}
			else if (even ==2)   even = 0;
			if (chk_hlt() == ESC) {
				DisplayStr("\\");
				return(ESC);
			}
			DisplayStr(str);
		}  /* end for j */
	}  /* end for i */
	return(OK);
}

str2addr(s1,s2)
char *s1;
unsigned char *s2;
{
	int ColonExist=0,j,k,zz;
	char tbuf[200],*cptr;
	unsigned int cs;
	unsigned long ip;

/* check the valid hex digit */
	cptr = s1;
	while (*cptr != NULL)  {
		if (strchr(hexx,*cptr) == NULL)  {
			if (*cptr == ':' && env.Sabsflag) cptr++;
			else {
				prn_ferr(73);
				return(FAIL);
			}
		}
		else cptr++;
	}

/* get the ip length */
	if (env.Sabsflag == 1) {
		if (env.Maddrunit == 6)      j = 4;
		else j = 2;
	}
	else   j = env.Maddrunit;

/* get the ip string */
	if ((cptr=strchr(s1,':')) != NULL)  {
		ColonExist = 1;
		cptr++;
	}
	else cptr = s1;

/* check the length of cs string */
	if (env.Sabsflag && ColonExist)  {
		zz = strlen(s1) - strlen(cptr) - 1;
		if (env.Mmodel == 40) {
			if (zz > 2) {
				prn_ferr(73);
				return(FAIL);
			}
		}
		else if (zz > 4) {
			prn_ferr(73);
			return(FAIL);
		}
	}
/* check the length of ip string */
	if (strlen(cptr) > 2*j)  {
		prn_ferr(73);
		return(FAIL);
	}
/* get the cs:ip value for 86-series, and ip value for other models */
	if (ColonExist)   sscanf(s1," %lx : %lx ",&cs,&ip); 
	else sscanf(cptr," %lx ",&ip);

/* if no cs provided, get the cs from pc */
	if (!ColonExist && env.Sabsflag) {
		if (PC.flag == OK)  {
			cs = (unsigned int)PC.addr[0];
			if (env.Mmodel != 40)
				cs = (cs << 8) + (unsigned int)PC.addr[1];
		}
		else cs = 0;
	}

/* now do the converting job */
	if (env.Sabsflag)   {
		j = 0;
		if (env.Mmodel == 40) s2[j++] = (unsigned char) cs;
		else {
			s2[j++] = (unsigned char)(cs >> 8);
			s2[j++] = (unsigned char) cs;
		}
		if (env.Maddrunit <= 4) {
			s2[j++] = (unsigned char)(ip >> 8);
			s2[j++] = (unsigned char) ip;
		}
/*		else if (env.Maddrunit == 5) {
			s2[j++] = (unsigned char)(ip >> 16);
			s2[j++] = (unsigned char)(ip >> 8);
			s2[j++] = (unsigned char)ip;
		}
*/		else if (env.Maddrunit == 6) {
			s2[j++] = (unsigned char)(ip >> 24);
			s2[j++] = (unsigned char)(ip >> 16);
			s2[j++] = (unsigned char)(ip >> 8);
			s2[j++] = (unsigned char) ip;
		}
	}
	else  if (!env.Sabsflag && env.Maddrunit == 2)  {
		s2[0] = (unsigned char)(ip >> 8);
		s2[1] = (unsigned char) ip;
	}
	else if (!env.Sabsflag && env.Maddrunit == 3)  {
		s2[0] = (unsigned char)(ip >> 16);
		s2[1] = (unsigned char)(ip >> 8);
		s2[2] = (unsigned char) ip;
	}
	else if (!env.Sabsflag && env.Maddrunit == 4)  {
		s2[0] = (unsigned char)(ip >> 24);
		s2[1] = (unsigned char)(ip >> 16);
		s2[2] = (unsigned char)(ip >> 8);
		s2[3] = (unsigned char) ip;
	}
	return(OK);

}

/***************************************************************************/
/***** ssave_cmd                                                      ******/
/***************************************************************************/

ssave_cmd()
{
	int fd,i,*symlen,tcnt=0;
	char *name, *cptr;

	MICEEchoESC();
	VPOut = COMVP;
	if (cmd_argc != 2)   {
		prn_ferr(70);
		return(TRUE);
	}
	if ((access(cmd_argv[1],2) == -1) && (errno == EACCES))  {
		prn_ferr(22);
		DisplayStr("\rSymbols are not saved.");
		return(TRUE);
	}
	if ((fd=open(cmd_argv[1],O_RDWR|O_BINARY|O_CREAT|O_TRUNC, S_IREAD|S_IWRITE)) == -1) {
		prn_ferr(15);
		DisplayStr("\rSymbols are not saved.");
		return(TRUE);
	}
	write(fd,userheader,20);
	write(fd,(unsigned char *)&(env.Maddrunit),2);
	write(fd,(unsigned char *)&(env.Maddrid),2);
	write(fd,(unsigned char *)&(env.Mcsiplen),2);
	write(fd,(unsigned char *)&addinx,2);
	if (addinx <= 0) {
		close(fd);
		return(TRUE);
	}

	symlen = (int *)malloc(addinx*sizeof(int));
	if (symlen == NULL) {
		close(fd);
		unlink(cmd_argv[1]);
		prn_ferr(45);
		return(TRUE);
	}

	for (i=0; i < addinx; i++)
		tcnt += (symlen[i] = strlen(addtable[i].name));
	tcnt += addinx;

	cptr = name = (char *)malloc(tcnt);
	if (name == NULL) {
		close(fd);
		unlink(cmd_argv[1]);
		free(symlen);
		prn_ferr(45);
		return(TRUE);
	}

	for (i=0; i < addinx; cptr+=symlen[i]+1,i++) 
		strcpy(cptr,addtable[i].name);

	write(fd,(char *)&tcnt,2);
	write(fd,(char *)symlen,addinx*sizeof(int));
	write(fd,name,tcnt);
	write(fd,(char *)&addtable[0],sizeof(struct addonitem)*addinx);
	close(fd);
	free(symlen);
	free(name);
	return(TRUE);
}

/***************************************************************************/
/***** srecall_cmd                                                    ******/
/***************************************************************************/

srecall_cmd()
{
	int fd,*symlen,i, au,id,csip,tcnt,acnt;
	char *name, *cptr, tt[80];
	struct addonitem *tadd;

	MICEEchoESC();
	VPOut = COMVP;
	if (cmd_argc != 2)   {
		prn_ferr(70);
		return(TRUE);
	}
	if ((fd=open(cmd_argv[1],O_BINARY|O_RDONLY, S_IREAD)) == -1) {
		prn_ferr(15);
		return(TRUE);
	}
	read(fd,tt,28);
	if (strncmp(tt,userheader,20) != 0) {
		prn_ferr(42);
		close(fd);
		return(TRUE);
	}
	memcpy(&au,&tt[20],2);
	memcpy(&id,&tt[22],2);
	memcpy(&csip,&tt[24],2);
	memcpy(&acnt,&tt[26],2);
	if (acnt == 0) {
		close(fd);
		return(TRUE);
	}
	if ((au!=env.Maddrunit) || (id!=env.Maddrid) || (csip != env.Mcsiplen)) {
		prn_ferr(73);
		close(fd);
		return(TRUE);
	}
	if (env.Saddrunit == -2) env.Saddrunit = env.Maddrunit;
	if (env.Sabsflag == -2) {
		if (env.Maddrid == 4 || env.Maddrid == 6) env.Sabsflag = 1;
		else env.Sabsflag = 0;
	}
	read(fd,(char *)&tcnt,2);
	symlen = (int *) malloc(acnt*sizeof(int));
	name   = (char *) malloc(tcnt);
	tadd   = (struct addonitem *) malloc(acnt*sizeof(struct addonitem));
	if (!name || !symlen || !tadd) {
		close(fd);
		if (name)   free(name);
		if (symlen) free(symlen);
		if (tadd)   free(tadd);
		prn_ferr(45);
		return(TRUE);
	}
	read(fd,(char *)symlen,sizeof(int)*acnt);
	read(fd,name,tcnt);
	read(fd,(char *)tadd,acnt*sizeof(struct addonitem));
	for (csip=addinx,i=0,cptr=name; (i < acnt) && (addinx < ADDON); cptr+=symlen[i]+1,i++,addinx++) {
		/* checking if the symbol exists in global table */
		for (id=0,au=0; id < addinx; id++) 
			if (strcmp(addtable[id].name,cptr) == 0) au++;
		if (au)	addinx--;
		else {
			addtable[addinx].name = malloc(symlen[i]+1);
			if (addtable[addinx].name == NULL) {
				prn_ferr(45);
				break;
			}
			memcpy(addtable[addinx].addr,tadd[i].addr,6);
			strcpy(addtable[addinx].name,cptr);
		}
	}
	if ((i=addinx-csip) == 1) sprintf(tt,"\n 1 symbol is loaded from %s.",cmd_argv[1]);
	else if (i == 0) sprintf(tt,"\n No symbol is loaded from %s.",cmd_argv[1]);
	else sprintf(tt,"\n %d symbols are loaded from %s.",i,cmd_argv[1]);
	DisplayStr(tt);
	close(fd);
	free(name);
	free(symlen);
	free(tadd);
	return(TRUE);
}

/***************************************************************************/
/***** query_cmd                                                      ******/
/***************************************************************************/

query_cmd()
{
	MICEEchoESC();
	VPOut = COMVP;
	if (cmd_argc > 2)  {
		prn_ferr(70);
		return(TRUE);
	}
    DisplayStr("\r\n");
    if (strchr(cmd_argv[1],'%') == NULL) addrquery();
	else symquery(); 
	return(TRUE);
}


/*****************************************************************************/
/***** symquery                                                         ******/
/*****************************************************************************/

symquery()
{
	int i,j,foundflag=0,modflag=0,even=0;
	char modname[42],symname[42],*cptr,*cptr1,tbuf[80],astr[15];
	unsigned char addr[6];

	memset(symname,NULL,42);
	memset(modname,NULL,42);
	if ((cptr=strstr(cmd_argv[1],"%%")) == NULL) cptr = cmd_argv[1];
	else   {  cptr++; cptr++; modflag = 1;  }
	if ((cptr1=strchr(cptr,'%')) == NULL) {
		prn_ferr(70);
		return(TRUE);
	}
	if (modflag)  {
		for (i=0; *cptr != '%' && i < 40; i++,cptr++)   modname[i] = *cptr;
	}
	cptr1++;
	if (strlen(cptr1) > 40) strncpy(symname,cptr1,40);
	else strcpy(symname,cptr1);
	strcpy(comsym.name,symname);
	if (modflag)  {
		if (NameToMod(modname) == FOUND)  {
			comsym.modx = commod.mod_inx;
			comsym.mask |= MSK_MOD;
			if (find_mod_byn(commod.mod_inx) == FOUND)  {
				if (listnaddr(commod.mod_name) == ESC) return;
			}
			else prn_ferr(69);
			return(TRUE);
		} else {
			prn_ferr(69);
			return(TRUE);
		}
	}
	swap_module(0);
	for (i=0; i < modcnt; i++)  {
		j = i - gblmod[0].mod_inx;
		comsym.modx = gblmod[j].mod_inx;
		if (find_mod_byn(i) >= FOUND) { 
			foundflag = 1;
			if (listnaddr(gblmod[j].mod_name) == ESC)  return;
		}
		if (j == NO_MODULE-1) swap_module(i+1);
	}
	comsym.modx = -1;
	if (addinx > 0)  {
		j = 0;
		sprintf(tbuf,"\r\nGlobal newly created:\r\nAddress:  ");
		for (i=0; i < addinx; i++) {
			if (strcmp(comsym.name,addtable[i].name) == 0)  {
				if (!j) { DisplayStr(tbuf); j = 1; }
				foundflag = 1;
				memset(addr,NULL,6);
				memset(astr,NULL,15);
				memcpy(addr,&addtable[i],6);
				addr2str(addr,astr);
				memset(tbuf,0x20,33);
				tbuf[33] = '\0';
				memcpy(tbuf,astr,strlen(astr));
				DisplayStr(tbuf);
				even++;
				if (even == 2) {
					DisplayStr("\r\n          ");
					even = 0;
				}
			}
		}
		if (even == 1) DisplayStr("\r\n");
	}
	if (gblsymcnt > 0)  {
		if (swap_symaddr(-1) != FAIL)  {
			if (find_symaddr() >= FOUND)  {
				foundflag = 1;
				if (listnaddr(NULL) == ESC)  return;
			}
		}
	}
	if (!foundflag) prn_ferr(69);
	return(OK);
}


listnaddr(modname)
char *modname;
{
	int i,j,k,even=0;
	char str[34],astr[15],tbuf[80];
	unsigned char addr[6];

	if (InxInSatable == -1) return(OK);
	i = InxInSatable;
	j = (int)satable[i];
	str[33] = '\0';
	if (modname == NULL) sprintf(tbuf,"\r\nGlobal from symbol file:\r\nAddress:  ");
	else sprintf(tbuf,"\r\nModule:   %s\r\nAddress:  ",modname);
	DisplayStr(tbuf);
	memset(tbuf,NULL,80);
	memcpy(tbuf,&satable[i+1],j);
	while (strcmp(comsym.name,tbuf) == 0)  {
		memset(addr,NULL,6);
		memset(astr,NULL,15);
		i += j + 1;
		memcpy(addr,&satable[i],env.Saddrunit);
		if (env.Maddrunit > env.Saddrunit)
			AddrAlign(addr,env.Saddrunit,env.Maddrunit,'E');
		else if (env.Maddrunit < env.Saddrunit)
			AddrAlign(addr,env.Saddrunit,env.Maddrunit,'S');
		addr2str(addr,astr);
		memset(str,0x20,33);
		memcpy(str,astr,strlen(astr));
		DisplayStr(str);
		even++;
		if (even == 2) {
			DisplayStr("\r\n          ");
			even = 0;
		}
		i += env.Saddrunit;
		j = (int)satable[i];
		if ((i >= SXPtr->cnt*symreclen) || (j > 40)) break;
		memcpy(tbuf,&satable[i+1],j);
		tbuf[j] = '\0';
		if (chk_hlt() == ESC) {
			DisplayStr("\\");
			return(ESC);
		}
	}
	if (even == 1) DisplayStr("\r\n");
	return(OK);
}

/*****************************************************************************/
/***** addrquery                                                       *******/
/*****************************************************************************/

addrquery()
{
	int i,j,foundflag=0,item,even=0;
	char tbuf[80];
	unsigned char addr[6],temp[6],tmpsym[symreclen],*sptr,*fptr;
	struct inxfpos *iptr;
	struct addonitem *aptr;
        unsigned long ip;

	VPOut = COMVP;
	memset(addr,NULL,6);
	memset(&comsym,NULL,sizeof(comsym));
	if (str2addr(cmd_argv[1],addr) == FAIL)   {
		return(FAIL);
	}
	memcpy(comsym.addr,addr,6);
	if (env.Sabsflag) comsym.mask |= MSK_PHY;
	if (env.Maddrunit > env.Saddrunit)
		AddrAlign(comsym.addr,env.Maddrunit,env.Saddrunit,'S');
	else if (env.Maddrunit < env.Saddrunit)
		AddrAlign(comsym.addr,env.Maddrunit,env.Saddrunit,'E');
	memcpy(saveaddr,comsym.addr,6);

   // 08/08/95 for bugs
   // 08/08/95 Changed by Gates Hua , for PPR
AD2500:
   if ( ((env.Maddrunit==3)&&(env.Saddrunit==4))||
       ((env.Maddrunit==4)&&(env.Saddrunit==3))  ) {
   int ii, i, j, k, a;
   long count;
   char nn[42], mm[42], tmpBuf[80];

      if ( (env.Saddrunit==3)&&(env.Maddrunit==4) )
         memcpy(absad, &saveaddr[1], 3);
      else
         memcpy(absad, saveaddr, env.Saddrunit);
      for (ii=0; ii<modcnt; ii++) {
         swap_module(ii);
         CurModSAInx = ModInxHead + ii;
         if (CurModSAInx->cnt == 0) continue;
         SXPtr = CurModSAInx->sxptr;
         sprintf(tbuf," Module:   %s", gblmod[ii].mod_name);
         strcpy(tmpBuf, tbuf);
         count = 0;
         lseek(fdsy, SXPtr->fpos,0);
read_sa: read(fdsy, &satable[0], SXPtr->cnt * symreclen);
      for (i = 0, k = 0, InxInSatable = -1; k < SXPtr->cnt; k++) {
         if ( (j = (int) satable[i]) > 40 || !j ) {
            i=-2;
            break;
         }
         memset(nn, NULL, 42);
         memcpy(nn, &satable[i+1], j);
         if ( (a=memcmp(absad, &satable[i+j+1], env.Saddrunit)) == 0) {
            if ( strcmp(tmpBuf, tbuf) || strcmp(nn, mm) )   {
               strcat(tbuf, "\r\n   ");
               strcat(tbuf, nn);
               strcat(tbuf, "\r\n");
               DisplayStr(tbuf);
               sprintf(tbuf," Module:   %s", gblmod[ii].mod_name);
               strcpy(mm, nn);
            }
         }
         InxInSatable = i;
         i += j + 1;
         i += env.Saddrunit;
         count += j+1+env.Saddrunit;
      }
      if ( i != -2 ) {
         lseek(fdsy, SXPtr->fpos+count,0);
         goto read_sa;
      }
    } // end of module
   return(OK);
   }  // end of if

    if (((comsym.mask & MSK_PHY) == MSK_PHY) && env.Sabsflag)  {
		(*absaddr)(saveaddr,env.Maddrunit);
		memcpy(temp,absad,6);
	}  else memcpy(temp,saveaddr,env.Maddrunit);

// search additional table
	j = 0;
	if (addinx > 0) {
		memset(comsym.name,NULL,40);
		sprintf(tbuf,"\r\nGlobal newly created:\r\nSymbol:   ");

		aptr = (struct addonitem *)lfind((char *)temp,(char *)addtable,&addinx,sizeof(struct addonitem),bComp);
		
		if (aptr != NULL) {
			DisplayStr(tbuf);
			do {
				if (aptr->name == NULL) break;
				strcpy(tbuf,aptr->name);
				DisplayStr(tbuf);
				DisplayStr("\r\n          ");
				aptr++;
				j++;
				if (aptr == NULL) break;
				if (env.Sabsflag)   (*absaddr)(aptr->addr,env.Maddrunit);
				else memcpy(absad,aptr->addr,env.Maddrunit);
				if (memcmp(temp,absad,env.Maddrunit) != 0) break;
				else if (memcmp(saveaddr,aptr->addr,env.Maddrunit) != 0) break;
			} while (1); 
		}
		foundflag += j;
	}
		
// search symbol from file

	if (totalsymcnt == 0) {
		if (!foundflag) prn_ferr(68);
		return(OK);
	}
	if (memcmp(temp,GblAXTbl[0].addr,env.Maddrunit) < 0) {
		if (!foundflag)  prn_ferr(68);
		return(OK);
	}
	if ((i=memcmp(temp,GblAXTbl[adrinxcnt-1].addr,env.Maddrunit)) > 0) {
		if (!foundflag)  prn_ferr(68);
		return(OK);
	} else if (i == 0)  AXPtr = &GblAXTbl[adrinxcnt-2];
	else {
		AXPtr = GblAXTbl;
		AddrIndexCompCnt = 0;
		AXPtr = (struct adrindex *) lfind((char *)temp,(char *)GblAXTbl,&adrinxcnt,sizeof(struct adrindex),aIndexComp);
		if (AXPtr == NULL) {
			if (!foundflag) prn_ferr(68);
			return(OK);
		}
		if (AXPtr != GblAXTbl) AXPtr = &GblAXTbl[AddrIndexCompCnt-2];
	}
	InxInAstable = 0;
//      sptr = astable + adrreclen * (int)(AXPtr->fpos);
        if ((ip = adrreclen * AXPtr->fpos) > 0xffff)
            sptr = (U8 *)((U32)astable + ((ip&0xffff0000L)<<3) + (U16)ip);
        else sptr = astable + ip;
        aentry = (unsigned char *) lfind(temp,sptr,&(AXPtr->cnt),adrreclen,AddrComp);
	InxInAstable--;
	if (aentry == NULL) {
		if (!foundflag) prn_ferr(68);
		return(OK);
	}
	iptr = (struct inxfpos *)aentry;
	i = iptr->inx;    j = 0;
	do {
		iptr = (struct inxfpos *)aentry;
		if (i != iptr->inx) {
			j = 0;
			i = iptr->inx;
		}
		if (!j) {
			if (iptr->inx == -1)
				sprintf(tbuf,"\r\nGlobal from symbol file:\r\nSymbol:   ");
			else if (iptr->inx >= 0) {
				swap_module(iptr->inx);
				sprintf(tbuf,"\r\nModule:   %s\r\nSymbol:   ",commod.mod_name);
			}
		}
		lseek(fdsy,iptr->fpos,0);
		read(fdsy,tmpsym,symreclen);
	 	if (((comsym.mask & MSK_PHY) == MSK_PHY) && env.Sabsflag)  {
			if (memcmp(saveaddr,&tmpsym[(int)tmpsym[0]+1],env.Saddrunit) == 0) {
				if (!j) DisplayStr(tbuf);
				memset(tbuf,NULL,70);
				memcpy(tbuf,&tmpsym[1],(int)tmpsym[0]);
				strcat(tbuf,"\r\n          ");
				DisplayStr(tbuf);
				j++;  foundflag++;
			}
		} else {
			if (!j) DisplayStr(tbuf);
			memset(tbuf,NULL,70);
			memcpy(tbuf,&tmpsym[1],(int)tmpsym[0]);
			strcat(tbuf,"\r\n          ");
			DisplayStr(tbuf);
			j++;  foundflag++;
		}
		if (chk_hlt() == ESC) {
			DisplayStr("\\");
			return(ESC);
		}
		aentry += adrreclen;
		InxInAstable++;
		if (InxInAstable == AXPtr->cnt) break;
	} while (memcmp(temp,aentry+6,env.Saddrunit) == 0);
	if (!foundflag) prn_ferr(68);
	return(OK);
}

