/****************************************************************************
**
**  Name:  libmain.c
**
**  Description:
**     Contains the main entry/exit point of the Disassembly/Assembly/
**     Dequeuer DLL (DASM32.DLL).
**
**  Status:  PRELIMINARY
**
**  $Log:   S:/tbird/mt2_amd/abi186/libmain.c_v  $
** 
**    Rev 1.0   20 Mar 1998 10:14:14   Eric
** Initial revision.
** 
**    Rev 1.1   18 Apr 1997 15:26:26   Judy
** 
**    Rev 1.0   14 Nov 1996 10:56:10   gene
** Initial revision.
** 
**    Rev 1.0   14 Jun 1996 16:31:52   Judy
** Initial revision.
** 
**    Rev 1.6   08 Apr 1993 10:30:32   doug
** change dll to proper name
** 
**    Rev 1.5   19 Aug 1992 09:26:36   marilyn
** Now checks for errors from init routine.
** 
**    Rev 1.4   31 Jul 1992 15:05:32   marilyn
** Added hLib variable.
** 
**    Rev 1.3   17 Jul 1992 09:40:28   marilyn
** Added call to DadInit in libmain.
** 
**    Rev 1.2   14 May 1992 11:50:16   mindy
** added call to register dasm with error server
** 
**    Rev 1.1   18 Jan 1992 13:34:56   courtney
** Un-commented code in LibMain which unlocks the data segment for the DLL.
** 
**    Rev 1.0   14 Jan 1992 13:06:34   tom
** Initial revision.
**
**  $Header:   S:/tbird/mt2_amd/abi186/libmain.c_v   1.0   20 Mar 1998 10:14:14   Eric  $
**
*****************************************************************************/

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#ifndef _BASEWIND_
#include "basewind.h"
#endif

#ifndef _CLISRV_
#include "clisrv.h"
#endif

#ifndef _HOSTERRS_
#include "hosterrs.h"
#endif

/* Define symbol to exclude the WEP routine */
#define _BORLANDC_
                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/
HANDLE hLib;

                        /****************************
                         *                          *
                         *    EXTERNAL VARIABLES    *
                         *                          *
                         ****************************/

//extern RETCODE DadInit(VOID);

                        /****************************
                         *                          *
                         *     LOCAL PROTOTYPES     *
                         *                          *
                         ****************************/

                        /****************************
                         *                          *
                         *      EXECUTABLE CODE     *
                         *                          *
                         ****************************/

/**************************************************************************
**
** LibMain
**
** Description: Main entry point of DASM32.DLL
**
**	Parameters:
**    input:
**       hInstance:     Handle of the library instance
**       wDataSeg:      Value of Data Segment register
**       cbHeapSize:    Heap Size of the heap defined in the DEF
**       lpszCmdLine:   Command Line information (rarely used)
**
**    output:
**
***************************************************************************/
#pragma argsused
int FAR PASCAL LibMain(HANDLE hInstance, WORD wDataSeg, WORD cbHeapSize,
    LPSTR lpszCmdLine) {

    RETCODE err;

    /* the LIBENTRY initializes the local heap by calling LocalInit() and
       then calls LibMain.  The LocalInit() locks the data segment of the
       library when initialize; therefore LibMain needs to unlock */
    if (cbHeapSize != 0) /* the DLL Data segment is MOVEABLE */
       UnlockData(0);
    hLib = hInstance;
    //ErrInitDLL(MODULE_DISASSEMBLY,"dasm32.dll");

    //err = DadInit();
    //if (GOOD != err)
    //ErrDisplayError(err, FORCE_POPUP);
    return(TRUE);
}

#ifndef _BORLANDC_
/**************************************************************************
**
** WEP {Windows Exit Procedure}
**
** Description: DLL exit procedure to perform cleanup for the DLL before it
**              is unloaded. - not to be used with BC++ compiler.
**
**	Parameters:
**    input:
**       nParam:     Message to indicate whether all of Windows is shutting
**                   down or just the DLL itself.
**
**    output:
**       return a 1 to indicate success
**
***************************************************************************/
void FAR PASCAL WEP(int nParam) {

   switch(nParam) {
      case WEP_SYSTEMEXIT:
         /* System shutdown in progress. Respond accordingly */
         break;
      case WEP_FREE_DLL:
         /* The DLL use count is 0 */
         break;
      default:
         /* Undefined value - ignore */
         break;
   }
   return(TRUE);
}
#endif

/******************************** E O F ***********************************/
