#define _REG86_DEFINE_

#define REG_NO     14
#define MAX_INTERNAL_REG_NO    128  /* size of U16 int_regs[] array, for internal registers */
#define NUM_COP1   7    /* size of U16 cop1_regs[] array, for internal registers */
#define NUM_COP2   8*10 /* size of U8 cop2_regs[] array, for internal registers */
#define REG_MAX    115     /* include cpu, internal and coprocess regs */

#define REG_PC          (-3)
#define REG_SP          (-2)
#define REG_FP          (-1)

#define AX   0
#define BX   1
#define CX   2
#define DX   3
#define RSP   4
#define BP   5
#define SI   6
#define DI   7
#define DS   8
#define SS   9
#define ES   10
#define CS   11
#define IP   12
#define FLAGS   13
#define MAX_CPU_REG186_NUM 16

#define OF   14
#define DF   15
#define IF   16
#define TF   17
#define SF   18
#define ZF   19
#define AF   20
#define PF   21
#define CF   22

#define AL   23
#define BL   24
#define CL   25
#define DL   26
#define AH   27
#define BH   28
#define RCH     29
#define DH   30
#define SIZE_CPUREG   1+DH


/*******************************************************/
/*            Define Target CPU type              */
/**************************************************/
#define M8086   0
#define M8088   1
#define M80186  2
#define M80188  3
#define M186EA  4
#define M188EA  5
#define M186EB  6
#define M188EB  7
#define M80286  8
#define M186EM  9
#define M188EM  10

typedef enum {
   I86_REG,       /*  */
   I87_REG,       /*  */
   INTERNAL_REG,
   INT_REG_MASTER,
   INT_REG_SLAVE,
   INT_REG_186EB,
   INT_REG_186EC
} REG_MODE ;

