/****************************************************************************
**
**  Name:  bx.h
**
**  Description:
**     Header file for internal breakpoint and execution files.
**
**  Status:  CODED
**
**  $Log:   S:/tbird/mt2_amd/bkptexec/bx.h_v  $
** 
**    Rev 1.0   20 Mar 1998 10:37:52   Eric
** Initial revision.
** 
**    Rev 1.6   15 Oct 1997 16:01:36   Liu
** 
**    Rev 1.5   15 Oct 1997 11:39:40   Liu
** No change.
** 
**    Rev 1.4   11 Oct 1997 17:48:00   Liu
** 
**    Rev 1.3   09 Oct 1997 09:22:50   Liu
** No change.
** 
**    Rev 1.2   09 Oct 1997 09:01:58   Liu
** 
**    Rev 1.1   08 Oct 1997 15:41:40   Liu
** 
**    Rev 1.0   06 Oct 1997 13:38:38   Liu
** Initial revision.
** 
**    Rev 1.0   16 Dec 1996 14:51:40   Judy
** Initial revision.
** 
**    Rev 1.11   12 May 1993 09:58:50   nghia
** Added prototype for new function AddrHasNoBkpt for Breakpoint server PIP.
** 
**    Rev 1.10   03 Dec 1992 08:15:34   brucea
** Added: CreateCliBkptNum to this interface so bkptexec.c could access it
** 
** 
**    Rev 1.9   14 Sep 1992 17:36:32   brucea
** Added: prototype for BxCliResetAndGo
** 
**    Rev 1.8   15 Jun 1992 10:05:38   brucea
** Added: BxCliIsEmuHalted, BxCliRunAccess, BxSetRunAccess, BxClearRunAccess,
**    BxGetRunAccess
** 
**    Rev 1.7   20 Apr 1992 10:08:22   brucea
** Changed: statementTextPtr from DESCRIPTOR to LPSTR
** 
**    Rev 1.6   03 Apr 1992 18:56:18   brucea
** Revamped: BX_BREAKPOINT.  Added DESCRIPTORs for text of module reference name,
**    module name, function name, and source statement text.
** 
**    Rev 1.5   26 Mar 1992 18:15:46   brucea
** Added: headers for new cli functions: BxCliStepSrc, BxCliGoUntil, BxCliGoInto,
**    BxSendCliMessage (called from bkptexec.c)
** 
**    Rev 1.4   16 Mar 1992 13:25:06   brucea
** Added: syntax comment for bkptdelete ALL
** 
**    Rev 1.3   12 Mar 1992 23:18:52   brucea
** Changed: NOT_CLI from -1 to 0xFFFF
** Added: MAX_CLI_BKPT_NUMBER
** Removed: lineOffset from BX_BREAKPOINT; added funcAddrOffset
** Changed: name BkptChanged to BkptProgramBkpt
** Added: BxSetSrcBkptFromCli, BxSetBkptWithIndex, BxCallback
** 
** 
**    Rev 1.2   28 Feb 1992 07:41:28   doug
** added CLI as source of breakpoint set
** 
**    Rev 1.1   17 Feb 1992 07:57:04   doug
** the breakpoint change function is now shared between bkptexec.c and
** brkexcli.c
** 
**    Rev 1.0   01 Feb 1992 15:56:18   doug
** Initial revision.
**
**  $Header:   S:/tbird/mt2_amd/bkptexec/bx.h_v   1.0   20 Mar 1998 10:37:52   Eric  $
**
**  Copyright (C) 1991 Microtek International.  All rights reserved.
**
*****************************************************************************/

#define _BX_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/
#define MAX_STMT_TEXT 80

/* this is dependent on the declared size of <cliBkptNumber> */
#define NOT_CLI (0xFFFF)
#define MAX_CLI_BKPT_NUMBER 0x0000FFFE
#define MAX_NUM_BKPT 256

typedef enum {
/* Assumption: if bkpt set to BX_NOT_BEING USED, the address descriptor
   is not valid; i.e. no memory has been alloc'ed for the address */
   BX_NOT_BEING_USED, /* breakpoint is available; not in use */
   BX_SET_FROM_ASM, /* originally set from the assembly level */
   BX_SET_FROM_CLI, /* originally set from the command line interface */
   BX_SET_FROM_SRC, /* originally set from the source level */
   BX_SET_INTERNAL, /* set from an internal breakpoint routine (temporary) */
   BX_BPTYPE_DUMMY = 0x7FFF /* force a 16 bit enum size */
} BX_BPTYPE;

typedef struct {
   /* common breakpoint information */
   BX_BPTYPE  type;   /* type of breakpoint */
   BX_BPSTATE state;  /* current state of the breakpoint (enabled/disabled) */
   BX_BPLIFE  life;   /* lifetime of breakpoint (temp/permanent */
   DESCRIPTOR addr;   /* descriptor to represent address */

   /* symbol information; values invalid as long as symMatch == FALSE */
   BOOLEAN           symMatch;    /* true if asm addr has symbol that
				     matches */
   SYM_DESCRIPTOR    module;      /* module containing bkpt */
   SYM_DESCRIPTOR    function;    /* function containing bkpt */
   DESCRIPTOR        modRefName;  /* Module reference name; TMalloc'ed */
   DESCRIPTOR        modName;     /* Module name; TMalloc'ed */
   DESCRIPTOR        functionName;/* Function name; TMalloc'ed */
   U32           funcAddrOffset;  /* offset from func head to bkpt */
   LINENUM_TYPE      lineNumber;  /* closest line number */
   COLUMN_RANGE_TYPE columnRange; /* start and end column for statement */
   LPSTR             statementTextPtr;
				  /* bkpt source line text; TMalloc'ed */
   U16 cliBkptNumber;             /* number used if set by CLI,
				     or else NOT_CLI */
} BX_BREAKPOINT;

//Eric 10/7/97
typedef struct BKPT_TABLE_TAG {
   BX_BREAKPOINT          bkptTable[MAX_NUM_BKPT];
   struct BKPT_TABLE_TAG  *next;
} BKPT_TABLE;

/*
   NOTE: name DESCRIPTORs are always valid.  They may point to \0 if there is
   no name.
*/
typedef U16 BKPT_INDEX; /* index into breakpoint table */
typedef U16 BKPT_TABLE_COUNT; /* counts of breakpoint table number (Eric 10/9/97)*/
		       /****************************
                        *                          *
                        *    PUBLIC PROTOTYPES     *
                        *                          *
                        ****************************/

/*---------------------------------------------------------------------------
**  Name:  BxCliGo
**
**  Description:
**    To support the user command "go". This function is to check the
**    corresponding item SD_GO of the shared data base.
**
**  Status:  CODED
**
**  Parameters:
**    input:
**        cmdString:  cli command string to set source level breakpoint
**        argc:  number of arguments passed
**        argv:  values of the arguments
**    output:
**      None
**
**    Design Notes: Have to display the relative fields of the shared data
**                  template
----------------------------------------------------------------------------*/
RETCODE EXPORT BxCliGo(LPSTR cmdString, U32 argc, U32 argv[]);


/*---------------------------------------------------------------------------
**  Name:  BxCliResetAndGo
**
**  Description:
**    To support the user command "resetAndGo". This function is to check the
**    corresponding item SD_GR of the shared data base.  This function
**    resets the target, enables emulation, then releases reset to allow the
**    target to boot in real time.
**
**  Parameters:
**    input:
**        cmdString:  cli command string to set source level breakpoint
**        argc:  number of arguments passed
**        argv:  values of the arguments
**    output:
**      None
**
**    Design Notes: Have to display the relative fields of the shared data
**                  template
----------------------------------------------------------------------------*/
RETCODE EXPORT BxCliResetAndGo(LPSTR cmdString, U32 argc, U32 argv[]);


/*---------------------------------------------------------------------------
**  Name:  BxCliStep
**
**  Description:
**    To support the user command "step". This function is to check the
**    corresponding item SD_SINGLE_STEP of the shared data base.
**    Syntax:  <command> [ "forever" | count ]
**
**  Status:  CODED
**
**  Parameters:
**    input:
**      count : count to step
**
**    output: None
----------------------------------------------------------------------------*/
RETCODE EXPORT BxCliStep(LPSTR cmdString, U32 argc, U32 argv[]); 


/*---------------------------------------------------------------------------
**  BxCliStepSrc
**
**  Syntax:
**    SrcStep [INTO | OVER] [LINE | STMT] [FOREVER | <count>]
**
**    If parameters are missing, the function uses the last set value (or
**    default value) as the parameter.
**
----------------------------------------------------------------------------*/
RETCODE EXPORT BxCliStepSrc(LPSTR cmdString, U32 argc, U32 argv[]);


/*---------------------------------------------------------------------------
**  BxCliGoUntil
**
**  Syntax:
**    goUntil [CALL | RETURN] [LINE | STMT]
**
----------------------------------------------------------------------------*/
RETCODE EXPORT BxCliGoUntil(LPSTR cmdString, U32 argc, U32 argv[]);


/*---------------------------------------------------------------------------
**  BxCliGoInto 
**
**  Syntax:
**    goInto [CALL | RETURN] [LINE | STMT]
**
----------------------------------------------------------------------------*/
RETCODE EXPORT BxCliGoInto(LPSTR cmdString, U32 argc, U32 argv[]);


/*---------------------------------------------------------------------------
**  Name:  BxCliHalt
**
**  Description:
**    To support the user command "halt". This function is to check the
**    corresponding item SD_HALT of the shared data base.
**
**  Status:  CODED
**
**  Parameters:
**    input:
**        cmdString:  cli command string to set source level breakpoint
**        argc:  number of arguments passed
**        argv:  values of the arguments
**
**    output: None
----------------------------------------------------------------------------*/
RETCODE EXPORT BxCliHalt(LPSTR cmdString, U32 argc, U32 argv[]); 


/*---------------------------------------------------------------------------
**  Name:  BxCliIsEmuHalted
**
**  Description:
**    Used in CLI to test condition of emulator.
**    Returns GOOD (0) if this call is FALSE, i.e. if emulator is NOT halted.
**    Returns ER_BX_EMU_IS_HALTED (non-zero) if emulator is halted.
**    User can assign return code of this call to variable and test for
**    0 (not halted) or non-zero (halted).
**
**  Parameters:
**    input:
**        cmdString:  cli command string to set source level breakpoint
**        argc:  number of arguments passed
**        argv:  values of the arguments
**
**    output: None (except return codes; see above)
----------------------------------------------------------------------------*/
RETCODE EXPORT BxCliIsEmuHalted(LPSTR cmdString, U32 argc, U32 argv[]); 


/*---------------------------------------------------------------------------
**  BxCliRunning
**
**  Description:
**          Read/Get the current emulator state 
**
**  Status:  CODED
**
**  Parameters:
**    input:
**        cmdString:  cli command string to set source level breakpoint
**        argc:  number of arguments passed
**        argv:  values of the arguments
**
**    output: None
----------------------------------------------------------------------------*/
RETCODE EXPORT BxCliRunning(LPSTR cmdString, U32 argc, U32 argv[]);


/*---------------------------------------------------------------------------
**  BxCliCause
**
**  Description:
**    To support the user command "cause". This function gets
**    the cause of the last emulator halt(user halt or asynchronous).
**    The user can use this to check "user halt" as a cause also.
**
**  Status:  PRELIMINARY (FW not support yet, NO member in SDS)
**
**  Parameters:
**    input:
**        cmdString:  cli command string to set source level breakpoint
**        argc:  number of arguments passed
**        argv:  values of the arguments
**    output:
**      last cause of emulation start. (type ?)
----------------------------------------------------------------------------*/
RETCODE EXPORT BxCliCause(LPSTR cmdString, U32 argc, U32 argv[]);


/*---------------------------------------------------------------------------
** BxCliRunAccess
**
** Syntax:
**    bkpt_runaccess ON | OFF
**    
** Description:
**    runAccess ON ==> target commands, e.g. set or read memory, can occur
**       while the target is running
**              OFF ==> error generated if user calls commands while emu
**              is running
**
**  Parameters:
**    input:
**        cmdString:  cli command string to set source level breakpoint
**        argc:  number of arguments passed
**        argv:  values of the arguments
**    output:
**      none
----------------------------------------------------------------------------*/
RETCODE EXPORT BxCliRunAccess(LPSTR cmdString, U32 argc, U32 argv[]);


/*---------------------------------------------------------------------------
**  BxCliSetBkpt
**
**  Description:
**     Set an assembly level breakpoint via cli.
**
**     Syntax:  bkpt [#id] [TEMPORARY|PERMANENT] [ENABLE|DISABLE] [<address>]
**
**  Parameters:
**        cmdString:  cli command string to set source level breakpoint
**        argc:  number of arguments passed
**        argv:  values of the arguments
**
**     output: none
----------------------------------------------------------------------------*/
RETCODE EXPORT BxCliSetBkpt(LPSTR cmdString, U32 argc, U32 argv[]);  


/*---------------------------------------------------------------------------
**  BxCliDeleteBkpt
**
**  Description:
**     Delete a breakpoint defined by @id         
**
**     Syntax:  bkptdelete @<id>
**              bkptdelete ALL      removes all breakpoints
**
**  Parameters:
**        cmdString:  cli command string to set source level breakpoint
**        argc:  number of arguments passed
**        argv:  values of the arguments
**
**     output: none
----------------------------------------------------------------------------*/
RETCODE EXPORT BxCliDeleteBkpt(LPSTR cmdString, U32 argc, U32 argv[]);  


/****************************************************************************
**
**  BxCallback
**
**  Purpose:
**     Is called when event that the bkpt server has registered on occurs
*****************************************************************************/
RETCODE EXPORT BxCallback(U32 eventNum);


                       /****************************
                        *                          *
                        *      LOCAL PROTOTYPES    *
                        *                          *
                        ****************************/

/*---------------------------------------------------------------------------
**  BxSendCliMessage
**
**  Description:
**     Send a text string to CLI
----------------------------------------------------------------------------*/
RETCODE BxSendCliMessage(LPSTR msgPtr);

/****************************************************************************
**
**  BkptProgramBkpt
**
**  Description:
**     Call this routine when one breakpoint changes.
**
**  Parameters:
**     input:
**        desc:  descriptor of breakpoint
**     output:
**        none
**
*****************************************************************************/
RETCODE BkptProgramBkpt(BKPT_INDEX index);

/****************************************************************************
**
**  BxSetSrcBkptFromCli
**
**  Description:
**     Set a source level breakpoint via CLI; has already gotten address
**
**  Parameters:
**     input:
**        state:  initial state of the breakpoint
**        life:  temporary or permanent lifetime
**        module:  module where breakpoint is
**        actualLineNum:  line within module
**        actualColumnStart:  starting column within line
**        actualColumnEnd:  ending column within line
**        lineText:  null terminated string of line (statement/line text
**           will be extracted to show in breakpoint pop-up); use NULL if
**           no text to be displayed
**        addrRange: address desc of found address
**     output:
**        desc:  descriptor representing the breakpoint (use this to get
**           information and to ultimately remove the breakpoint)
**
*****************************************************************************/
RETCODE
BxSetSrcBkptFromCli(BKPT_INDEX     index,
                    BX_BPSTATE     state,
                    BX_BPLIFE      life,
                    SYM_DESCRIPTOR module,
                    LINENUM_TYPE   actualLineNum,
                    COLUMN_TYPE    actualColumnStart,
                    COLUMN_TYPE    actualColumnEnd,
                    LPSTR          lineText,
                    DESCRIPTOR     addrRangeDesc,
                    U16            cliBkptNum,
                    DESCRIPTOR FAR *desc);


/****************************************************************************
**
**  BxSetBkptWithIndex
**
*****************************************************************************/
RETCODE
BxSetBkptWithIndex(BKPT_INDEX     index,
                   BX_BPSTATE     state,
                   BX_BPLIFE      life,
                   DESCRIPTOR     addr,
                   U16            cliBkptNum,
                   DESCRIPTOR FAR *desc);


/****************************************************************************
**
**  GetAvailableBkpt
**
**  Description:
**     Find an available breakpoint in the table, if any.
**
**  Parameters:
**     input:
**        none
**     output:
**        index:  index of the breakpoint
**
*****************************************************************************/
RETCODE GetAvailableBkpt(BKPT_INDEX *index);

/****************************************************************************
**
**  AddrHasNoBkpt
**
**  Description:
**    Check to find out if there is breakpoint (except the temporary
**    internal) at the specified address in the table. If one exists,
**    returns warning ER_BX_ALREADY_HAS_BKPT, else returns GOOD.
**    NOTES: This routine will handle reporting the warning. Caller will not
**    need to report the warning, should return GOOD.
**
**  Parameters:
**     input:
**        bkptAddrDesc:    Address of requested breakpoint for duplication
**                         checking.
**        life:            Life of the requested breakpoint.
**     output:
**        none
**
*****************************************************************************/
RETCODE AddrHasNoBkpt(DESCRIPTOR bkptAddrDesc, BX_BPLIFE life);

/*---------------------------------------------------------------------------
** BxSetRunAccess - allows user to access target while in emulation
----------------------------------------------------------------------------*/
RETCODE BxSetRunAccess(VOID);

/*---------------------------------------------------------------------------
** BxClearRunAccess - prevents user from accessing target while in emulation
----------------------------------------------------------------------------*/
RETCODE BxClearRunAccess(VOID);

/*---------------------------------------------------------------------------
** BxGetRunAccess - returns run access state                       
----------------------------------------------------------------------------*/
RETCODE BxGetRunAccess(BOOLEAN *runAccess);

/*---------------------------------------------------------------------------
**  CreateCliBkptNum
**
**  Description:
**     create a new "@cliBkptNumber
**
**  Parameters:
**     input:
**        none
**     output:
**        num: a new cliBkptNumber
----------------------------------------------------------------------------*/
RETCODE CreateCliBkptNum(U16 *num);

/*---------------------------------------------------------------------------
** GetbkptTablePtr - get the current bkptTable access point and index
----------------------------------------------------------------------------*/
RETCODE GetbkptTablePtr(BKPT_TABLE **bkptTablePtr,
			BKPT_INDEX *bkptTableIndex,
			BKPT_INDEX index);

//******************************** E O F ***********************************/
