/****************************************************************************
**
**  Name:  version.c
**
**  Description:
**     Provide version number information.
**
**  $Log:   S:/tbird/mt2_amd/cliulib/version.c_v  $
** 
**    Rev 1.0   20 Mar 1998 11:07:46   Eric
** Initial revision.
** 
**    Rev 1.0   16 Dec 1996 16:12:42   Judy
** Initial revision.
** 
**    Rev 1.2   11 May 1994 14:55:34   STEVE
** Needed pointer to bug
** 
**    Rev 1.1   11 May 1994 14:27:50   tom
** New version fields added.
** 
**    Rev 1.0   23 Mar 1994 16:51:08   tom
** Add entry point to return version number
** 
**
**  $Header:   S:/tbird/mt2_amd/cliulib/version.c_v   1.0   20 Mar 1998 11:07:46   Eric  $
**
**  Copyright (C) 1994 Microtek International.  All rights reserved.
**
*****************************************************************************/

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#ifndef _BASEWIND_
#include "basewind.h"
#endif

#ifndef _CLIULIB_
#include "cliulib.h"
#endif

#ifndef _VERSIONS_
#include "versions.h"
#endif


                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *    EXTERNAL VARIABLES    *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *     LOCAL PROTOTYPES     *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *      EXECUTABLE CODE     *
                        *                          *
                        ****************************/

/*--------------------------------------------------------------------------
**  GetPowerViewsVersion
**
**  Purpose:
**     Return the PowerViews version.
**
**  Parameters:
**     major:  major version number.
**     minor:  minor version number.
**     bug:    bug version number.
**     string: ID string.
**     build:  build number.
----------------------------------------------------------------------------*/
RETCODE EXPORT GetPowerViewsVersion(U16 *major, U16 *minor, CHAR *bug,
   LPSTR string, U16 *build)
{
   *major = VER_MAJOR;
   *minor = VER_MINOR;
   *bug   = VER_BUG;
   lstrcpy(string, (LPSTR)VER_STRING);
   *build = VER_BUILD;
   return(GOOD);
}

/******************************** E O F ***********************************/
