/****************************************************************************
**
**  Name: wcommdlg.cpp
**
**  Description:
**     Definitions of routines in WCOMMDLG.H
**
**  $Log:   S:/tbird/mt2_amd/cliulib/wcommdlg.cpv  $
** 
**    Rev 1.0   20 Mar 1998 11:07:44   Eric
** Initial revision.
** 
**    Rev 1.0   16 Dec 1996 16:12:42   Judy
** Initial revision.
** 
**    Rev 1.0   14 Jul 1994 10:29:22   nghia
** Initial revision.
**
**  $Header:   S:/tbird/mt2_amd/cliulib/wcommdlg.cpv   1.0   20 Mar 1998 11:07:44   Eric  $
**
**  Copyright (C) 1994 Microtek International.  All rights reserved.
**
*****************************************************************************/

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#include <dlgs.h>     // to process HELP in HookProc

#ifndef _WCOMMDLG_
#include "wcommdlg.h"
#endif

#ifndef _DLGOBJ_
#include "dlgobj.h"
#endif

#ifndef _HOSTERRS_
#include "hosterrs.h"
#endif


                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *    EXTERNAL VARIABLES    *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *     LOCAL PROTOTYPES     *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *      EXECUTABLE CODE     *
                        *                          *
                        ****************************/
/*****************************************************************************
**
**  CommDlgGetFileName
**
*****************************************************************************/
RETCODE EXPORT CommDlgGetFileName(U32 parent, U16 helpId, U16 filterId,
                                  LPSTR initDir, BOOLEAN openDlg,
                                  LPSTR fileName) {

   // use stack based <CommFileDlg> object to support multiple session
   CommFileDlg newDlg((HWND)parent, helpId, filterId, initDir, openDlg);
   fileName[0] = '\0';
   
   if (newDlg.status != GOOD)
      return newDlg.status;
   // Get the file name and return it
   // NOTES: <CommFileDlg> object is destroyed as the function exits.
   return  newDlg.GetFileName(fileName);
}

/*****************************************************************************
**
**  CommDlgFileHookProc
**
*****************************************************************************/
#pragma argsused  // suppress compiler warning
UINT CALLBACK CommDlgFileHookProc(HWND hDlg, UINT msg, WPARAM wP, LPARAM lP) {
   
   switch(msg) {
      case WM_INITDIALOG:
         return TRUE;
      case WM_COMMAND:   
         if (wP == pshHelp) {
            RETCODE err;
            S16 dummy;
            WORD hlpId;
            
            // retrieve the Help-Context Id of object running <hDlg>
            if ((err = CommFileDlg::GetHelpId(hDlg, &hlpId)) != GOOD) {
               ErrDisplayFormattedError(err, FORCE_POPUP, NULL, NULL, NULL,
                                        MB_OK, &dummy);
               return TRUE;
            }
            // display help for dialog
            WinHelp(hDlg, "PWRVIEWS.HLP", HELP_CONTEXT, hlpId);
         }
   }
   // allow Windows standard processing.
   return FALSE; 
}   

/********************************** E O F ***********************************/
