/****************************************************************************
**
**  Name:  CPUCLI.H
**
**  Description:
**      CLI entry point prototypes.
**
**  Status:  PRELIMINARY
**
**  $Log:   S:/tbird/mt2_amd/cpu/cpucli.h_v  $
** 
**    Rev 1.0   20 Mar 1998 11:05:16   Eric
** Initial revision.
** 
**    Rev 1.0   16 Dec 1996 16:02:06   Judy
** Initial revision.
** 
**    Rev 1.10   26 Sep 1994 14:41:02   ernie
** Added support for config ignoreHLDA
** 
**    Rev 1.9   24 Jun 1994 08:25:18   dennis
** Added multiplexed and start bit fields to REGISTER_ENTRY structure to
** support registers that are part of other registers (i.e. AX is part of
** EAX).
** 
**    Rev 1.8   20 May 1994 07:23:54   dennis
** Added regIndex and visible parameters to the REGISTER_ENTRY structure.
** regIndex is the offset value from the shared data register member's base
** address (SD_REG00) found in sdprobe.h. visible = 0 means to not show the
** register in the CPU window, visible = 1 means to show it.
** 
**    Rev 1.7   18 May 1994 08:44:30   dennis
** Added S8 sigVal to the SIGNAL_ENTRY structure. This variable holds the
** offset value found in the cpu"proc".cfg file. This is an offset from the
** base signal value (SD_SIG00) found in sdprobe.h.
** 
**    Rev 1.6   25 Jun 1993 14:59:52   mindy
** 
**    Rev 1.5   17 Jun 1993 15:39:14   mindy
** Added register pair typedef
** 
**    Rev 1.4   30 Mar 1993 08:27:02   ernie
** 1. Added prototype for BuildTables() and InitCpuServer().
** 2. Removed unused defines.
** 3. General cleanup.
** 
**    Rev 1.3   14 Jul 1992 11:34:06   courtney
** Defines for processor tables.
** 
**    Rev 1.3   18 May 1992 08:47:38   mindy
** had to bump timeout value WAY to prevent timeout
** 
**    Rev 1.2   13 May 1992 09:04:36   nghia
** Added SendMessageToCli() for global reference.
** 
**    Rev 1.1   17 Apr 1992 16:21:56   nghia
** Added include from BKPTEXEC library for GetEmulationStatus().
** 
**    Rev 1.0   28 Feb 1992 12:05:26   nghia
** Initial revision.
**
**  $Header:   S:/tbird/mt2_amd/cpu/cpucli.h_v   1.0   20 Mar 1998 11:05:16   Eric  $
**
**  Copyright (C) 1991-2 Microtek International.  All rights reserved.
**
*****************************************************************************/
#define _CPUCLI_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#ifndef _BASEWIND_
#include "basewind.h"
#endif
#ifndef _CPU_
#include "cpu.h"
#endif
                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/

typedef struct {
   S8   assertedChar;
   S8   negatedChar;
   BOOLEAN displayAsChar;
   U32  mask;
   U16  shift;
} FLAG_TABLE;

/* Register Table Entry */
typedef struct {
   S8          regName[MAX_REGNAME];        /* name of register */
   U16         regWidth;        /* number of bits in register */
   U16         numberOfFlags;   /* 0 indicates display in numeric format */
   U16         presenterLine;
   FLAG_TABLE *flagTable;
   DESCRIPTOR  sdDesc;          /* sharedata descriptor */
   U16         regIndex;        /* index from SD_REG00 */
   U16         visible;         /* 1 = display in CPU window */
   BOOLEAN     multiplexed;     /* 1 indicates reg is part of another reg */
   U16         startBit;        /* starting bit position within reg */
} REGISTER_ENTRY;

typedef struct {
   S8          signalName[MAX_SIGNAME];     /* signal name */
   S8          sigVal;          /* index from SDN_SIG00 */
   DESCRIPTOR  sdDesc;          /* signal descriptor */
} SIGNAL_ENTRY;

/* Register Pair Table Entry */
typedef REG_ID REGISTER_PAIR_ENTRY[2];

                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/
#ifdef __cplusplus
extern "C" {
#endif

/**************************************************************************
**
** InitCServer
**
** Description: Initialize the commands for the Cpu Server.
**
** Parameters:
**    input:
**       cliHandle:  CLI Server Handle
**       dllHandle:  DLL Handle.
**
**    output:
**       return a 1 to indicate success
**
***************************************************************************/
RETCODE EXPORT InitCServer(HANDLE cliHandle, HANDLE dllHandle) ;


/***************************************************************************
**
**  CpuCliRegister
**
**  Status:  PRELIMINARY
**
**  description:
**     Cli interface to the register display, modify, init, enable/disable
**     group.
**
**
**  input:
**     <none>
**
**  output:
**     message:
**        register value(get register).
**     <none> : register modify, init.
**
*****************************************************************************/
RETCODE EXPORT  CpuCliRegister(LPSTR cmdString, U32 argc, U32 argv[]) ;

/***************************************************************************
**
**  CpuCliSignals
**
**  Status:  PRELIMINARY
**
**  description:
**     Cli interface to the signals display
**
**  input:
**     <none>
**
**  output:
**     message:
**        signals value(get signals).
**     <none> : signals modify
**
*****************************************************************************/
RETCODE EXPORT  CpuCliSignal(LPSTR cmdString, U32 argc, U32 argv[]) ;

/***************************************************************************
**
**  CpuCliResetCPU
**
**  Status:  PRELIMINARY
**
**  description:
**     Cli interface to reset the CPU
**
**  input:
**     none.
**
**  output:
**     none.
**
*****************************************************************************/
RETCODE EXPORT  CpuCliResetCPU(LPSTR cmdString, U32 argc, U32 argv[]);

/***************************************************************************
**
**  CpuCliFindRegName
**
**  Status:  PRELIMINARY
**
**  description:
**     Cli interface to find a register name by it numeric id.
**
**  input:
**     none.
**
**  output:
**     none.
**
*****************************************************************************/
RETCODE EXPORT  CpuCliFindRegName(LPSTR cmdString, U32 argc, U32 argv[]);

/****************************************************************************
**
**  SendMessageToCli.
**
**  Status:  TESTED
**
**  Description:
**     Send a text message to the CLI server.
**
**  Parameters:
**     input:
**        msgPtr        Message to be sent
**     output:
**        none
**
*****************************************************************************/
RETCODE SendMessageToCli(LPSTR msgPtr);

/****************************************************************************
**
**  BuildTables
**
**  Description:
**     Initialize register and signal description tables from config file
**
**  Parameters:
**        none
**
*****************************************************************************/
RETCODE EXPORT BuildTables(VOID);

/****************************************************************************
**
**  InitCpuServer
**
**  Description:
**     Initialize cpu server (other than cli-related stuff)
**
**  Parameters:
**        none
**
*****************************************************************************/
RETCODE EXPORT InitCpuServer(VOID);

/****************************************************************************
**
**  CpuSetIgnoreHLDA
**  CpuGetIgnoreHLDA
**
**  Description:
**     Set/get ignoreHLDA state.
**
**  Parameters:
**        ignoreHLDA  
**
*****************************************************************************/
RETCODE CpuSetIgnoreHLDA(BOOLEAN ignoreHLDA);
RETCODE CpuGetIgnoreHLDA(BOOLEAN *ignoreHLDA);

RETCODE EXPORT CliPause(LPSTR cmdString, U32 argc, U32 argv[]); //**Hera 12/09/96**/

#ifdef __cplusplus
}
#endif

/******************************** E O F ***********************************/
