/***************************************************************************
**
**  Name:  dq186.c
**
**  Description:
**     This is a dequeuer for Intel 80186/80188
**
**
**  Status:
**
**
**  $Header:
**
**  Copyright (C) 1991 Microtek International.  All rights reserved.
**
***************************************************************************/

//#ifndef _STRING_
//#include <strlib.h>
//#endif

#ifndef _BASEWIND_
#include "basewind.h"
#endif

#ifndef _DAD_SERVER_
#include "dasm.h"
#endif

#ifndef _PDASM86_
#include "pdasm86.h"
#endif

#ifndef _DADDEF86_
#include "daddef86.h"
#endif

#ifndef _DQ186_
#include "dq186.h"
#endif

#ifndef _HEAP_
#include "heap.h"
#endif

#ifndef _SSHARED_
#include "sshared.h"
#endif

#ifndef _SDPROBE_
#include "sdprobe.h"
#endif

#ifndef _SDNUM_
#include "sdnum.h"
#endif

#ifndef _TRACE_
#include "trace.h"
#endif

#ifndef __STDIO_H
#include <stdio.h>
#endif

#ifndef __DOS_H
#include <dos.h>
#endif

#include "string.h"


// temp variable start

BOOLEAN dsmAddrGiven;
S32 dsmAddr,lastFrame;
S16 accessSize;
// temp variable end

                        /****************************
                         *                          *
                         *     DEFINITIONS          *
                         *                          *
                         ****************************/
#define NULL_FRAME_NO 0x10000000l
#define FRAME_BUFF_LEN      0x40 // Read 64 frames data each times.
#define TRACE_FRAME_WIDTH     16 // the length of each trace frame.
#define END_TRACE_DATA       -10
#define MAX_SEARCH_DEPTH      0x10L
#define MAX_NUM_DQ          50

TRC_FRAME traceFrame;
                        /****************************
                         *                          *
                         *     EXTERNALS            *
                         *                          *
                         ****************************/

extern HANDLE cliServerHandle;

                        /****************************
                         *                          *
                         *     LOCAL VARIABLES      *
                         *                          *
                         ****************************/
#define READ_FRAMES_DATA     SDN_FIND_FLUSH_INSTS
#define SPACE_MASK           0x07
U8 *spaceString[] = {"AK","I","O","H","S","R","W"};

LOCAL char statusCode[8] = {
   'A', 'I', 'O', 'H', 'S', 'R', 'W', 'D'
};

                        /****************************
                         *                          *
                         *     LOCAL PROTOTYPES     *
                         *                          *
                         ****************************/

RETCODE ReadTraceFrame
        (DESCRIPTOR dqStateId,
         U8 *frameCunt,
         S32 startReadFrame,
         DQ_FRAME *dqFrame,
         SPACE_TYPE spaceType);
RETCODE SearchMatchAddress(DESCRIPTOR dqStateId,U32 searchAddr,S32 *matchFrame);

/////////////////////// Temporal function of trace //////////////////////////
VOID OutputStringToFile(LPSTR buffer,U16 textLen){
FILE *fStream;
U16 count;

   fStream = fopen("dqstring.log","w");
   count = fwrite(buffer, textLen, 1, fStream);
   fclose(fStream);
}

                        /****************************
                         *                          *
                         *     EXECUTABLE           *
                         *                          *
                         ****************************/

/****************************************************************************
**
** Name:  AdddqStateTable
**
****************************************************************************/
RETCODE AddDqStateTable(DESCRIPTOR dqStateId) {
DQ_STATE *dqState;
U32 numGotten;
U16 lp;
RETCODE err;
LPSTR buffer;

   if ((dqState = (DQ_STATE FAR *)dqStateId) == NULL)
      return ER_DAD_INVALID_ID_DESCRIPTOR;
   TrcReadFrameSet(dqState->traceId,dqState->frameReadStart);
   for (lp = 0; lp < MAX_FRAME_NO; lp++)
      dqState->frameArray[lp].frameNo = NULL_FRAME_NO;
   if ((err = TrcTraceReadRaw(dqState->traceId,FRAME_BUFF_LEN,
              (U32 far *)&numGotten, &buffer)) != GOOD) return(err);
   for (lp = 0; lp < numGotten; lp++) {
      memcpy(&(dqState->frameArray[lp]),
             (buffer+lp*TRACE_FRAME_WIDTH),TRACE_FRAME_WIDTH);
   }
   TFree(buffer);
   TrcReadFrameSet(dqState->traceId,dqState->frameReadStart);
   dqState->frameStart = dqState->frameArray[0].frameNo;
   dqState->frameReadStart = dqState->frameStart;
   dqState->frameEnd = dqState->frameArray[(U16)(numGotten - 1)].frameNo;
   dqState->frameCount = numGotten;
   return(GOOD);
}

/****************************************************************************
**
** Name:  CreatedqStateTable // Create Dis-continue Table
**
****************************************************************************/
RETCODE CreateDqStateTable (DESCRIPTOR dqStateId) {
DQ_STATE  *dqState;
S32 curFrame;
U16 tempBuffId;

   if ((dqState = (DQ_STATE FAR *)dqStateId) == NULL)
      return ER_DAD_INVALID_ID_DESCRIPTOR;
   TrcReadBufferGet(dqState->traceId,(U16 FAR *)&tempBuffId); // read current buffer ID
   dqState->traceBufId = tempBuffId; // read current buffer ID
   TrcReadFrameGet(dqState->traceId,&curFrame);
   dqState->frameReadStart = curFrame;
   return(AddDqStateTable(dqStateId));

}

/****************************************************************************
**
** Name:  DestroydqStateTable // Create
**
****************************************************************************/
RETCODE DestroyDqStateTable(DESCRIPTOR id) {
DQ_STATE *dqState;
RETCODE err;

   if ((dqState = (DQ_STATE FAR *)id) == NULL)
      return (ER_DAD_INVALID_ID_DESCRIPTOR);
   if ((err = TFree((LPSTR)dqState)) != GOOD)
      return err;
   return(GOOD);
}

/****************************************************************************
**
** Name:  CheckSpaceType
**
****************************************************************************/
RETCODE CheckSpaceType(SPACE_TYPE spaceType, U8 statusPin) {

   statusPin &= 0x0f;
   switch (spaceType) {
      case S_PROGRAM :
         if (statusPin == 0x0c) return(GOOD);
         break;
      case S_DATA :
         if ((statusPin  == 0x0d) || (statusPin  == 0x0e) ||
             (statusPin  == 0x09) || (statusPin  == 0x0a))
           return(GOOD);
         break;
      case S_DONT_CARE :
         return(GOOD);
      default :
         return(!GOOD);
   }
   return(!GOOD);
}

/****************************************************************************
**
** Name:  SkipTraceFrame
**
** input :
**       dataLen : size of bytes
**
****************************************************************************/
RETCODE SkipTraceFrame
        (DESCRIPTOR dqStateId,
         S8 frameLen,
         S32 startSkipFrame,
         SPACE_TYPE spaceType){
DQ_STATE FAR *dqState;
S32 curOffset,lp = 0;
U8 count = 0;
U16 traceBuf;
S32 oldest, newest, trig;
RETCODE err;

   if ((dqState = (DQ_STATE FAR *)dqStateId) == NULL)
      return (ER_DAD_INVALID_ID_DESCRIPTOR);
   TrcReadBufferGet(dqState->traceId,&traceBuf);
   if ((err = TrcTraceBufferInfoGet(dqState->traceId,&oldest,&newest,&trig))
      != GOOD) return(err);

   if ((traceBuf != dqState->traceBufId) ||  // different buffer ID.
       (startSkipFrame < dqState->frameStart)||
       (startSkipFrame > dqState->frameEnd)) { 
      if ((dqState->traceBuffCount < FRAME_BUFF_LEN) &&
          (startSkipFrame > dqState->frameEnd)) return(GOOD);
      dqState->frameReadStart = startSkipFrame;
      if ((err = AddDqStateTable(dqStateId)) != GOOD)
         return(err);
      dqState->traceBufId = traceBuf;
   }
   curOffset = (U16)(startSkipFrame - dqState->frameStart);
   count = 0;
   do {
      if (CheckSpaceType
          (spaceType, dqState->frameArray[(U16)curOffset].statusPin) == GOOD)
         count++;
      curOffset++;
      lp++;
      if (startSkipFrame+lp >= newest)
         return(!GOOD); // not find enough program frame.
   }while (count < frameLen);
   TrcReadFrameSet(dqState->traceId,startSkipFrame+lp);
   DadSetDqOffset(dqStateId,0);
   return(GOOD);


}

/****************************************************************************
**
** Name:  SkipTraceData
**
** input :
**       dataLen : size of bytes
**
****************************************************************************/
RETCODE SkipTraceData
        (DESCRIPTOR dqStateId,
         S8 dataLen,
         S32 startSkipFrame,
         SPACE_TYPE spaceType){
DQ_STATE FAR *dqState;
S32 curOffset,lp = 0;
U8 count = 0,remainByte;
U16 traceBuf;
S32 oldest, newest, trig;
RETCODE err;

   if ((dqState = (DQ_STATE FAR *)dqStateId) == NULL)
      return (ER_DAD_INVALID_ID_DESCRIPTOR);
   TrcReadBufferGet(dqState->traceId,&traceBuf);
   if ((err = TrcTraceBufferInfoGet(dqState->traceId,&oldest,&newest,&trig))
      != GOOD) return(err);

   if ((traceBuf != dqState->traceBufId) ||  // different buffer ID.
       (startSkipFrame < dqState->frameStart)||
       (startSkipFrame > dqState->frameEnd)) { 
      if ((dqState->traceBuffCount < FRAME_BUFF_LEN) &&
//          (startSkipFrame > dqState->frameEnd)) return(END_TRACE_DATA);
          (startSkipFrame > dqState->frameEnd)) return(GOOD);
      dqState->frameReadStart = startSkipFrame;
      if ((err = AddDqStateTable(dqStateId)) != GOOD)
         return(err);
      dqState->traceBufId = traceBuf;
   }
   curOffset = (U16)(startSkipFrame - dqState->frameStart);
   count = 0;
   DadGetDqOffset(dqStateId,&remainByte);
   if (remainByte == 1) {
     count++;
     curOffset++;
     lp++;
   }
   do {
      if (CheckSpaceType
          (spaceType, dqState->frameArray[(U16)curOffset].statusPin) == GOOD) {
         // if cpu is 188 count++;
         if (dqState->frameArray[(U16)curOffset].addr & 1)  /* odd address */
            count++;
         else {
            if (IS_BHE(dqState->frameArray[(U16)curOffset].statusPin))
               count++;
            else count+=2;
         }
      }
      curOffset++;
      lp++;
      if (startSkipFrame+lp >= newest)
         return(!GOOD); // not find enough program frame.
   }while (count < dataLen);
   if (count == dataLen)
      TrcReadFrameSet(dqState->traceId,startSkipFrame+lp);
   else TrcReadFrameSet(dqState->traceId,startSkipFrame+lp-1);

   if(count == (dataLen+1)) DadSetDqOffset(dqStateId,1);
   else DadSetDqOffset(dqStateId,0);
   return(GOOD);

}

/****************************************************************************
**
** Name:  ReadTraceFrame
**
****************************************************************************/
RETCODE ReadTraceFrame
        (DESCRIPTOR dqStateId,
         U8 *frameCount,
         S32 startReadFrame,
         DQ_FRAME *dqFrame,
         SPACE_TYPE spaceType){
DQ_STATE FAR *dqState;
S32 curOffset, oldest, newest, trig;
U8 count = 0;
U16 traceBuf;
RETCODE err;
DQ_FRAME *framePtr;


   framePtr = dqFrame;
   if ((dqState = (DQ_STATE FAR *)dqStateId) == NULL)
      return (ER_DAD_INVALID_ID_DESCRIPTOR);
   TrcReadBufferGet(dqState->traceId,&traceBuf);
   memset(dqFrame,0x7f,sizeof(DQ_FRAME)); /* initialize struct */
   if ((err = TrcTraceBufferInfoGet(dqState->traceId,&oldest,&newest,&trig))
      != GOOD) return(err);

   if ((dqState->traceBufId != traceBuf)||
       (startReadFrame < dqState->frameStart)||
       (startReadFrame > dqState->frameEnd)) {
      dqState->traceBufId = traceBuf;
      dqState->frameReadStart = startReadFrame;
      AddDqStateTable(dqStateId);
   }
   curOffset = (U16)(startReadFrame- dqState->frameStart);
   do {
      if (CheckSpaceType
          (spaceType, dqState->frameArray[(U16)curOffset].statusPin) == GOOD) {
         framePtr->frameNo = dqState->frameArray[(U16)curOffset].frameNo;
         framePtr->addr = dqState->frameArray[(U16)curOffset].addr;
         framePtr->data = dqState->frameArray[(U16)curOffset].data;
         framePtr->statusPin = dqState->frameArray[(U16)curOffset].statusPin;
         framePtr++;
         count++;
      }
      curOffset++;
      if (dqState->frameArray[(U16)curOffset].frameNo >= dqState->frameEnd) {
         if (curOffset == FRAME_BUFF_LEN) {
            dqState->frameReadStart = dqState->frameEnd;
            if ((err = AddDqStateTable(dqStateId)) != GOOD)
               return(err); // read trace frames from hardware.
            curOffset = 0;
         }
         //else return(END_TRACE_DATA);
         else return(GOOD);
      }
      if (startReadFrame+(*frameCount) >= newest)
         return(!GOOD); // not find enough program frame.
   }while (count < *frameCount);
   frameCount = count;
   return(GOOD);
}

/****************************************************************************
**
** Name:  ReadInstDataAndAddress
**
****************************************************************************/
RETCODE ReadInstDataAndAddress(
        DESCRIPTOR dqStateId,U8 *objCode,U8 *objLen, U32 *startAddr) {
DQ_STATE FAR *dqState;
DQ_FRAME dqFrame;
S32 curFrame;
U8 instPos,frameCount;
U16 remainByte;
RETCODE err;



   if ((dqState = (DQ_STATE FAR *)dqStateId) == NULL)
      return (ER_DAD_INVALID_ID_DESCRIPTOR);
   TrcReadFrameGet(dqState->traceId,&curFrame);
   DadGetDqOffset(dqStateId,&remainByte);
   instPos = *objLen = 0;
   dqState->frameReadStart = curFrame;
   do {
      frameCount = 1;
      if (err = ReadTraceFrame(dqStateId,&frameCount,curFrame,&dqFrame,S_PROGRAM))
         return(err);
      curFrame = dqFrame.frameNo + 1;
      if (instPos == 0) {
         *startAddr = dqFrame.addr;
         if (remainByte == 1) (*startAddr)++;
      }
      if (accessSize == ACCESSSIZE88) {   /* 80x88 */
         objCode[instPos] = LSB(dqFrame.data);
         instPos++;
         (*objLen)++;
      }
      else                             /* 80x86 */
      if (dqFrame.addr & 1) {                  /* odd address */
         objCode[instPos] = MSB(dqFrame.data);
         instPos++;
         (*objLen)++;
      }
      else                           /* even address */
         if (remainByte == 1) {
            objCode[instPos] = MSB(dqFrame.data);
            //objCode[instPos] = LSB(dqFrame.data);
            instPos++;
            (*objLen)++;
            remainByte = 0;
         }
         else {                      /* two bytes effective */
            objCode[instPos] = LSB(dqFrame.data);
            objCode[instPos+1] = MSB(dqFrame.data);
            instPos += 2;
            (*objLen)+=2;
         }
   }while (instPos < MAX_INST_LEN);
   return(GOOD);
}

TRACE_STATUS_PIN cycleSequence[3][10] = {
    // RRRRWWWWWW for 188
    READ_FLUSH, READ_FLUSH, READ_FLUSH, READ_FLUSH,
    WRITE_FLUSH, WRITE_FLUSH, WRITE_FLUSH, WRITE_FLUSH, WRITE_FLUSH, WRITE_FLUSH,
    // RRWWW for 186
    READ_FLUSH, READ_FLUSH,
    WRITE_FLUSH, WRITE_FLUSH, WRITE_FLUSH,
    0xffff,0xffff,0xffff,0xffff,
    // RRWWWWWW for 186
    READ_FLUSH, READ_FLUSH,
    WRITE_FLUSH, WRITE_FLUSH, WRITE_FLUSH, WRITE_FLUSH, WRITE_FLUSH, WRITE_FLUSH,
    0xffff,0xffff
};
INT_CYCLE_TYPE CheckIntCycle(DQ_FRAME dqFrame[],U32 *intAddr,U32 *toAddr) {
U16 lp;

   if (accessSize == ACCESSSIZE88) {
      for (lp = 0; lp < 10; lp++) {
         if ((dqFrame[lp].statusPin & 0x4f) != cycleSequence[0][lp])
            return(NO_INT);
      }
      *toAddr = ((((U32)(dqFrame[1].data & 0xff) << 8) +
                  (U32)(dqFrame[0].data & 0xff)      ) << 4) +
                  ((U32)(dqFrame[3].data & 0xff) << 8) +
                  (U32)(dqFrame[2].data & 0xff);
      *intAddr = ((((U32)(dqFrame[5].data & 0xff) << 8) +
                  (U32)(dqFrame[4].data & 0xff)      ) << 4) +
                  ((U32)(dqFrame[7].data & 0xff) << 8) +
                  (U32)(dqFrame[6].data & 0xff);
      return(INT_88);
   }
   else {
      for (lp = 0; lp < 5; lp++) {
         if ((dqFrame[lp].statusPin & 0x4f) != cycleSequence[1][lp])
            return(NO_INT);
      }
      if (((dqFrame[2].addr/2)*2) == dqFrame[2].addr) { //sp is even
         *toAddr = ((U32)dqFrame[1].data << 4) + dqFrame[0].data;
         *intAddr = ((U32)dqFrame[3].data << 4) + dqFrame[4].data;
         return(INT_86);
      }
      else { // sp is odd.
         for (lp = 5; lp < 8; lp++) {
            if ((dqFrame[lp].statusPin & 0x4f) != cycleSequence[2][lp])
               return(NO_INT);
         }
         *toAddr = ((U32)dqFrame[1].data << 4) + dqFrame[0].data;
         *intAddr = ((((U32)(dqFrame[5].data & 0xff) << 8) +
                     (U32)(dqFrame[4].data & 0xff)      ) << 4) +
                     ((U32)(dqFrame[7].data & 0xff) << 8) +
                     (U32)(dqFrame[6].data & 0xff);
         return(INT_86);

      }
   }

}
/****************************************************************************
**
** Name:  CheckInterrupt
**
****************************************************************************/
INST_TYPE CheckInterrupt(DESCRIPTOR dqStateId, S32 startCheckFrame, U32 nextAddr) {
DQ_STATE FAR *dqState;
DQ_FRAME dqFrame[10];
U32 intAddr,toAddr;
INT_CYCLE_TYPE intStatus = NO_INT;
S32 matchFrame;
U8 frameCount;

   if ((dqState = (DQ_STATE FAR *)dqStateId) == NULL)
      return (ER_DAD_INVALID_ID_DESCRIPTOR);

   dqState->frameReadStart = startCheckFrame;
   if (accessSize == ACCESSSIZE88) {
      frameCount = 10;
      ReadTraceFrame(dqStateId,&frameCount,startCheckFrame,&dqFrame,S_DATA);
      if (frameCount < 10) return(NORMAL_INST);
      intStatus = CheckIntCycle(dqFrame,&intAddr,&toAddr);
      if ((intStatus == INT_88) && (nextAddr == intAddr)) {
         SearchMatchAddress(dqStateId,toAddr,&matchFrame);
         TrcReadFrameSet(dqState->traceId,matchFrame);
         DadGetDqOffset(dqStateId,0);
         return(HW_INT);
      }
      else return(NORMAL_INST);
   }
   else {
      frameCount = 8;
      ReadTraceFrame(dqStateId,&frameCount,startCheckFrame,&dqFrame,S_DATA);
      if (frameCount < 5) return(NORMAL_INST);
      intStatus = CheckIntCycle(dqFrame,&intAddr,&toAddr);
      if ((intStatus == INT_86) && (nextAddr == intAddr)) {
         SearchMatchAddress(dqStateId,toAddr,&matchFrame);
         TrcReadFrameSet(dqState->traceId,matchFrame);
         DadGetDqOffset(dqStateId,0);
         return(HW_INT);
      }
      else return(NORMAL_INST);
   }
   return(NORMAL_INST);

}

/****************************************************************************
**
** Name:  PrintRemainsFrame
**
****************************************************************************/
VOID PrintRemainsFrame(DESCRIPTOR dqStateId,
                       S32 startFrame,S32 endFrame, LPSTR string) {
S32 offset,lp;
DQ_FRAME printFrame;
U8 frameCount,tempBuffer[80];


   offset = endFrame - startFrame;
   for (lp = 0; lp < offset; lp++){
      //ReadTraceFrame(dqStateId,offset,startFrame,&printFrame,S_DONT_CARE);
      frameCount = 1;
      ReadTraceFrame(dqStateId,&frameCount,startFrame+lp,&printFrame,S_DONT_CARE);
      if (((printFrame.statusPin & SPACE_MASK) != 4) &&
          (printFrame.frameNo != NULL_FRAME_NO)) {
         sprintf(tempBuffer,"%05ld    %08lX    %04X    %2s \r\n",
              printFrame.frameNo,
              printFrame.addr,
              printFrame.data,
              spaceString[printFrame.statusPin & SPACE_MASK]);
         strcat((LPSTR)string,(LPSTR)tempBuffer);
      }
   }
}
/***************************************************************************
**
**  Name: SearchMatchAddress
**
**  Description:
**
**  Input:
**
**  Output:
**
****************************************************************************/
RETCODE SearchMatchAddress(DESCRIPTOR dqStateId,U32 searchAddr,S32 *matchFrame) {
S32 flushFrame,lp;
DQ_FRAME dqFrame;
DQ_STATE FAR *dqState;
U16 bytesRemain;
U32 alignAddr;
U8 frameCount;

   if ((dqState = (DQ_STATE FAR *)dqStateId) == NULL)
      return (ER_DAD_INVALID_ID_DESCRIPTOR);
   TrcReadFrameGet(dqState->traceId,&flushFrame);
   //if (accessSize = ACCESSSIZE86) {
   //   if(searchAddr != (alignAddr = (searchAddr/2)*2)) bytesRemain = 1;
   //   else bytesRemain = 0;
   //}
   // else bytesRemain = 0;
   alignAddr = searchAddr;
   lp = 0;
   dqState->frameReadStart = flushFrame;
   do {
      frameCount = 1;
      ReadTraceFrame(dqStateId,&frameCount,flushFrame+1,&dqFrame,S_PROGRAM);
      if (dqFrame.addr == alignAddr) {
         *matchFrame = dqFrame.frameNo;
         TrcReadFrameSet(dqState->traceId,dqFrame.frameNo);
         //DadSetDqOffset(dqStateId,bytesRemain);
         DadSetDqOffset(dqStateId,0);
         break;
      }
      flushFrame = dqFrame.frameNo;
      lp++;
   }while (lp < MAX_SEARCH_DEPTH); // buffer depth : 10
   return(GOOD);
}

/***************************************************************************
**
**  Name: FindBranchSignals()
**
**  Description:
**
**  Input:
**
**  Output:
**
****************************************************************************/
RETCODE FindFlushSignals(DESCRIPTOR dqStateId,BOOLEAN *findFlush) {
DQ_STATE *dqState;
RETCODE err;
S32 curFrame;
U16 lp = 0;
DQ_FRAME dqFrame;
U8 frameCount;

   if ((dqState = (DQ_STATE FAR *)dqStateId) == NULL)
      return (ER_DAD_INVALID_ID_DESCRIPTOR);
   *findFlush = FALSE;
   TrcReadFrameGet(dqState->traceId,&curFrame);
   do {
      frameCount = 1;
      if (err = ReadTraceFrame(dqStateId,&frameCount,curFrame+lp,&dqFrame,S_DONT_CARE))
         return(err);
      if (ISFLUSH(dqFrame.statusPin)) {
         *findFlush = TRUE;
         break;
      }
      lp++;
   } while (lp <= MAX_SEARCH_DEPTH);
   TrcReadFrameSet(dqState->traceId,curFrame);
   return(GOOD);
}

/***************************************************************************
**
**  Name: CheckFlush(dqStateId, instNo)
**
**  Description:
**     check if flush occurs, and set correct end frame No. if necessary
**
**  Input:  current end frame No., codes, and No. of remain bytes
**
**  Output: number of remaining bytes, end frame No.
**
**  Return: 1 if flush, 0 if no flush, -1 if cannot judge
**
****************************************************************************/
CHECK_INST_TYPE CheckFlush(DESCRIPTOR dqStateId, DASM_INFO *dasmInfo,
                           U32 startAddr){
CHECK_INST_TYPE checkStatus;
S32 flushFrame,matchFrame;
INST_TYPE instKind;
U16 remainByte;
DQ_STATE FAR *dqState;
BOOLEAN findFlush;
U32 targetAddr;

   checkStatus = TRACE_INST;
   if ((dqState = (DQ_STATE FAR *)dqStateId) == NULL)
      return (ER_DAD_INVALID_ID_DESCRIPTOR);
   DadGetDqOffset(dqStateId,&remainByte);
   TrcReadFrameGet(dqState->traceId,&flushFrame);
   switch (dasmInfo->transfer) {
      case FALSE :
         //CheckInterrupt(dqStateId,flushFrame,startAddr+(U32)dasmInfo->bytesUsed);
         CheckInterrupt(dqStateId,flushFrame,startAddr);
         break;
      case TRUE :
         FindFlushSignals(dqStateId,&findFlush);
         if (findFlush == TRUE) {
            checkStatus = TRACE_TRANSFER_INST;
            AdrGetAddrOffset(dasmInfo->target,(U32 far *)&targetAddr);
            SearchMatchAddress(dqStateId,targetAddr,&matchFrame);
            TrcReadFrameSet(dqState->traceId,matchFrame);
         } else if (dasmInfo->conditional == FALSE) checkStatus = QUEUE_INST;
         break;
   }
   return(checkStatus);
}  /* end of CheckFlush() */


/****************************************************************************
**
** Name:  DqInst
**
****************************************************************************/
RETCODE DqInst(DESCRIPTOR dqStateId,U32 *numInst,S32 FAR *startFrame,
               S32 FAR *endFrame, LPSTR *buffer, LPSTR *buffIndex, U16 *indexLen) {
U8 objCode[30];
BOOLEAN dasmSym;
U16 trcBuffer,bufferDepth,countInst,codeOffset;
DASM_INFO dasmInfo;
S32 oldest,newest,trig,firstFrame,curFrame,printStartFrame,printEndFrame;
U32 startAddr,numFrames;
DQ_STATE FAR *dqState;
RETCODE retStatus;
LPSTR bufferPtr;
U8 tempBuffer[100],instText[50],objLen;
U16 remainByte;
DESCRIPTOR addrId;
CHECK_INST_TYPE checkStatus;
PROBE_TYPE cpuMode;


   if ((dqState = (DQ_STATE FAR *)dqStateId) == NULL)
      return (ER_DAD_INVALID_ID_DESCRIPTOR);

   bufferDepth = MAX_LINE_LENGTH*(*numInst)*2;

   if ((*buffer = TMalloc(bufferDepth)) == NULL)
      return(ER_OUT_OF_MEMORY);

   ProcReturnSpecificProcessor((PROBE_TYPE FAR *)&cpuMode);
   switch (cpuMode) {
      case I80C186_MP :
      case I80C186XL_MP :
      case I80C186EA_MP :
      case I80C186EB_MP :
      case I80C186EC_MP :
         accessSize = ACCESSSIZE86;
         break;
      case I80C188_MP :
      case I80C188XL_MP :
      case I80C188EA_MP :
      case I80C188EB_MP :
      case I80C188EC_MP :
          accessSize = ACCESSSIZE88;
   }
   DadSetDqOffset(dqStateId,0);
   bufferPtr = *buffer;
   _fmemset(bufferPtr,'\0',bufferDepth); /* initialize string */
   if ((retStatus = TrcFrameDisplayModeSet(dqState->traceId,TRIGGER_ALIGN))
         != GOOD) {
      TFree(*buffer);
      return(retStatus);
   }

   if ((retStatus = DadGetDasmSymbol(&dasmSym)) != GOOD) return(retStatus);
   *startFrame = *endFrame = 0;
   if((retStatus=TrcNumFramesGet(dqState->traceId, &numFrames))!=GOOD)
      return(retStatus);
   if( !numFrames ) return(ER_DQ_NO_FRAMES_AVAILABLE); /* no frames just get out! */

/*
** Retrieve information about trace buffer limits and requested range
*/
   if ((retStatus = TrcTraceBufferInfoGet(dqState->traceId,&oldest,&newest,&trig))
      != GOOD) return(retStatus);
   if ((retStatus = TrcReadFrameGet(dqState->traceId, &firstFrame)) != GOOD)
      return(retStatus);
   if ((retStatus = TrcReadBufferGet(dqState->traceId, &trcBuffer)) != GOOD)
      return(retStatus);

   *indexLen = 0;
   retStatus = GOOD;


   /////// from 040 code
   countInst = 0;
   curFrame = firstFrame;
   AdrCreateAddress((DESCRIPTOR FAR *)&addrId);
   AdrCreateAddress((DESCRIPTOR FAR *)&dasmInfo.target);
   buffIndex[0] = bufferPtr;
   while (curFrame <= newest) {

      if ((retStatus = ReadInstDataAndAddress(dqStateId,objCode,&objLen,
                       &startAddr)) != GOOD)
         if (objLen == 0) return(retStatus);
      AdrSetAddrOffset(addrId,startAddr);

      TrcReadFrameGet(dqState->traceId,&curFrame);
      printStartFrame = curFrame;
      if (countInst == 0) *startFrame = curFrame;

      instText[0] = 0;
      //retStatus = TraceBufInst(objCode,startAddr,dasmSym,instText,&dasmInfo);
      retStatus = DadGetDasmInstruction(addrId, ADDR_USE_16, objCode,
                                        instText,&dasmInfo);
      if (dasmInfo.bytesUsed > objLen) break;
      if (retStatus == GOOD) {
         if ((retStatus = TrcReadFrameGet(dqState->traceId, &curFrame)) != GOOD)
            return(retStatus);
         SkipTraceData(dqStateId,dasmInfo.bytesUsed,curFrame,S_PROGRAM);

         /* Check flush */
         checkStatus = CheckFlush(dqStateId, &dasmInfo, startAddr);

         /* Display instruction */
         _fmemset(tempBuffer,0,100); /* initialize struct */

         if ((instText[0] != '\0') && (checkStatus != QUEUE_INST)) {
            //wsprintf(tempBuffer, "%4ld  %08lx  %s\r\n", curFrame, startAddr, instText);
            wsprintf(tempBuffer, "%05ld  %08lx  %s\r\n",
                     curFrame, startAddr, instText);
            _fstrcat((LPSTR)(bufferPtr),(LPSTR)tempBuffer);
            buffIndex[++countInst] = bufferPtr +  _fstrlen(bufferPtr);
         }

         /* Check whether remaining bytes construct a complete instruction */
         DadGetDqOffset(dqStateId,&remainByte);
         if ((remainByte > 0) && (checkStatus != TRACE_TRANSFER_INST)) {
            codeOffset = dasmInfo.bytesUsed;
            instText[0] = 0;
            //retStatus = TraceBufInst(&objCode[codeOffset],startAddr+remainByte,dasmSym,
            //                         instText, &dasmInfo);
            AdrSetAddrOffset(addrId,startAddr+remainByte);
            retStatus = DadGetDasmInstruction(addrId, ADDR_USE_16,
                                        &objCode[codeOffset],instText,&dasmInfo);
            if (dasmInfo.bytesUsed == remainByte) {
               if ((instText[0] != '\0') && (checkStatus != QUEUE_INST)) {
                  //wsprintf(tempBuffer, "%4ld            %s\r\n", curFrame, instText);
                  //wsprintf(tempBuffer, "%4ld  %08lx  %s\r\n",
                  //         dqState->dqStartFrame, startAddr, instText);
                  wsprintf(tempBuffer, "%05ld            %s\r\n", curFrame, instText);
                  _fstrcat((LPSTR)(bufferPtr),(LPSTR)tempBuffer);
                  buffIndex[++countInst] = bufferPtr + _fstrlen(bufferPtr);
               }
               DadSetDqOffset(dqStateId,0);
               if ((retStatus = TrcReadFrameGet(dqState->traceId, &curFrame)) != GOOD)
                  return(retStatus);
               if ((retStatus = TrcReadFrameSet(dqState->traceId,curFrame+1)) != GOOD)
                  return(retStatus);
               CheckFlush(dqStateId, &dasmInfo,startAddr+remainByte);

            }
         }
         TrcReadFrameGet(dqState->traceId,&printEndFrame);
         if (printStartFrame != printEndFrame)
            PrintRemainsFrame(dqState,printStartFrame,printEndFrame,(bufferPtr));
      }
      else _fstrcat((LPSTR)(bufferPtr), (LPSTR)"   (??)");   /* cannot judge */
      if (countInst >= *numInst)  break;


   /*** Print checked frames ***/
      // for (i = curFrame+1; i <= endFrame; i++)
      //     DisplayFrame(dqStateId, i);
      if (curFrame == newest) break;
   }  /* end of while (Frame <= newest) */

   //AdrDestroyAddress(dasmInfo.target);
   //AdrDestroyAddress(addrId);
   *endFrame = printEndFrame;
   *indexLen = countInst;
   *numInst = countInst;

   /////// end 040 code

   return(retStatus);

}



/****************************************************************************
**
** Name:  DadForwardDqInst
**
****************************************************************************/
#define PRE_FRAME_LEN    7
RETCODE EXPORT DadForwardDqInst(DESCRIPTOR id,U32 numInst,S32 FAR *startFrame,
                        S32 FAR *endFrame, LPSTR *buffer, U16 FAR *textLen,
                        DESCRIPTOR **addrDesc) {

U32 instNo = numInst;
S32 curFrame,firstFrame,secondFrame;
S32 oldest, newest, trig;
DQ_STATE FAR *dqState;
RETCODE status;
LPSTR buffIndex[50];
U16 totalLen,lp,indexLen = 0;

   if ((dqState = (DQ_STATE FAR *)id) == NULL)
      return (ER_DAD_INVALID_ID_DESCRIPTOR);

   if ((status = TrcReadFrameGet(dqState->traceId, &curFrame)) != GOOD)
      return(status);

   if ((status = TrcTraceBufferInfoGet(dqState->traceId,&oldest,&newest,&trig))
      != GOOD) return(status);
   if ((curFrame-PRE_FRAME_LEN) > oldest) {
      if ((status = TrcReadFrameSet(dqState->traceId, curFrame-PRE_FRAME_LEN)) != GOOD)
         return(status);   // 10 is a test value.
   }
   else {
      if ((status = TrcReadFrameSet(dqState->traceId, oldest)) != GOOD)
         return(status);
   }
   instNo+=7;

   if((*addrDesc=(DESCRIPTOR *)TMalloc(sizeof(DESCRIPTOR)*MAX_NUM_DQ))
       == NULL) {
      TFree(*buffer);
      return(ER_OUT_OF_MEMORY);
   }
   for (lp = 0; lp < MAX_NUM_DQ; lp++) addrDesc[0][lp] = NULL;

   if ((status = DqInst(id,&instNo,startFrame,endFrame,buffer,buffIndex,&indexLen))
      != GOOD) return(status);

   lp = 0;
   while(indexLen > (lp+1)) {
      sscanf(buffIndex[lp]," %ld",&firstFrame);
      sscanf(buffIndex[lp+1]," %ld",&secondFrame);
      if (curFrame == firstFrame) break;
      else if((firstFrame < curFrame) && (secondFrame > curFrame)) break;
      lp++;
   };
   if ((indexLen- lp) > numInst) {
      buffIndex[(U16)(lp+numInst)] = 0;
      sscanf(buffIndex[(U16)(lp+numInst-1)]," %ld",endFrame);
      totalLen = 25; // temp data.
   }
   else {
      sscanf(buffIndex[indexLen-1]," %ld",endFrame);
      totalLen = indexLen - lp + 1;
   }
   if ((indexLen <= (lp+1)) && (curFrame > *endFrame)) {
      **buffer = 0;
      *textLen = 0;
      *startFrame = *endFrame = curFrame;
   }
   else {
      memcpy(*buffer,buffIndex[lp],strlen(buffIndex[lp]));
      *(*buffer+ strlen(buffIndex[lp])) = 0;
      *textLen = lstrlen(*buffer);
      sscanf(*buffer," %ld",startFrame);
   }

   for(lp = 0; lp < totalLen; lp++) {
      AdrCreateAddress(&addrDesc[0][lp]);
   }

   if ((status = TrcReadFrameSet(dqState->traceId, curFrame)) != GOOD)
      return(status);

   OutputStringToFile(*buffer,*textLen);

   return(GOOD);

}

/****************************************************************************
**
** Name:  DadBackwardDqInst
**
****************************************************************************/
RETCODE EXPORT DadBackwardDqInst(DESCRIPTOR id,U32 numInst,S32 FAR *startFrame,
                        S32 FAR *endFrame, LPSTR *buffer, U16 FAR *textLen,
                        DESCRIPTOR **addrDesc) {
U32 instNo = numInst;
S32 curFrame,preFrame;
DQ_STATE FAR *dqState;
RETCODE status;
LPSTR partBuff[5],tempBuff;//,headPtr
U16 lp,lp2,lp3;
U16 totalLen;
S16 tempSegment,tempOffset;
//S8 frmaeNoStr[10];
S32 oldest,newest,trig,firstFrame,secondFrame;
LPSTR buffIndex[50];
U16 indexLen[5],totalIndexLen = 0;
U32 indexOffset;
U16 stringLen;

   if ((dqState = (DQ_STATE FAR *)id) == NULL)
      return (ER_DAD_INVALID_ID_DESCRIPTOR);

   if ((status = TrcReadFrameGet(dqState->traceId, &curFrame)) != GOOD)
      return(status);

   if((*addrDesc=(DESCRIPTOR *)TMalloc(sizeof(DESCRIPTOR)*MAX_NUM_DQ))
       == NULL) {
      TFree(*buffer);
      return(ER_OUT_OF_MEMORY);
   }
   for (lp = 0; lp < MAX_NUM_DQ; lp++) addrDesc[0][lp] = NULL;

   instNo += numInst/5;
   if ((status = TrcTraceBufferInfoGet(dqState->traceId,&oldest,&newest,&trig))
      != GOOD) return(status);
   preFrame = curFrame - numInst*4;
   if (preFrame < oldest) preFrame = oldest;
   lp =0;
   do {
      if ((status = TrcReadFrameSet(dqState->traceId, preFrame)) != GOOD)
         return(status);
      if ((status = DqInst(id,&instNo,startFrame,endFrame,&partBuff[lp],
             &buffIndex[totalIndexLen],&indexLen[lp]))
      != GOOD) return(status);
      totalIndexLen += indexLen[lp];
      if (curFrame > *endFrame) {
      }
      lp++;
      preFrame = *endFrame + 1;
   }while((curFrame > *endFrame) & (lp < 5) && (instNo >= numInst));

   totalLen = 0;
   for (lp2 = 0; lp2 < lp; lp2++)
      totalLen += strlen(partBuff[lp2]);
   if ((tempBuff = TMalloc(totalLen+1)) == NULL)
      return(ER_OUT_OF_MEMORY);


   memset(tempBuff,'\0',2);
   for (lp2 = 0; lp2 < lp; lp2++)
      strcat(tempBuff,partBuff[lp2]);


   stringLen = 0;
   totalIndexLen = 0;
   for (lp3 = 0; lp3 < lp ; lp3++) {
      tempSegment = FP_SEG(buffIndex[totalIndexLen]) - FP_SEG(tempBuff);
      tempOffset = FP_OFF(buffIndex[totalIndexLen]) - FP_OFF(tempBuff);
      tempOffset -= stringLen;
      stringLen += strlen(partBuff[lp3]);
      for (lp2 = 0; lp2 < indexLen[lp3]; lp2++) {
         indexOffset = FP_SEG(buffIndex[lp2+totalIndexLen]) - tempSegment;
         indexOffset <<=16;
         indexOffset += (FP_OFF(buffIndex[lp2+totalIndexLen]) - tempOffset);
         buffIndex[lp2+totalIndexLen] = (LPSTR)indexOffset;// +
         //   (FP_OFF(buffIndex[lp2+totalIndexLen]) - tempOffset);
      }
      totalIndexLen += indexLen[lp3];
   }

   lp3 = 0;
   while(totalIndexLen > lp3) {
      sscanf(buffIndex[lp3]," %ld",&firstFrame);
      sscanf(buffIndex[lp3+1]," %ld",&secondFrame);
      if (curFrame == firstFrame) break;
      else if((firstFrame < curFrame) && (secondFrame > curFrame)) break;
      lp3++;
   };
   *endFrame = firstFrame;
   lp3++;

   *(tempBuff+ strlen(tempBuff) - strlen(buffIndex[lp3])) = 0;
   if (lp3 > numInst) {
      stringLen = strlen(buffIndex[(U16)(lp3-numInst)]);
      memcpy(tempBuff,buffIndex[(U16)(lp3-numInst)],stringLen);
   }
   else {
      stringLen = strlen(buffIndex[0]);
      memcpy(tempBuff,buffIndex[0],stringLen);
   }
   *(tempBuff+stringLen) = 0;
   sscanf(tempBuff," %ld",startFrame);



   totalLen = strlen(tempBuff);
   if ((*buffer = TMalloc(totalLen+1)) == NULL)
      return(ER_OUT_OF_MEMORY);
   memcpy(*buffer,tempBuff,totalLen);
   if ((status = TrcReadFrameSet(dqState->traceId, curFrame)) != GOOD)
      return(status);

   *textLen = lstrlen(*buffer);
   for (lp2 = 0; lp2 < lp; lp2++)
      TFree(partBuff[lp2]);
   TFree(tempBuff);
   OutputStringToFile(*buffer,*textLen);
   return(GOOD);

}


/****************************************************************************
**
**  DadDqFlush
**
****************************************************************************/
#pragma argsused
RETCODE EXPORT DadDqFlush(DESCRIPTOR id) {
   return(GOOD);
}


//--------------------------- end of dequeuer-186 --------------------------
